/**
 * Modulares Ring-Programm mit Customizer-Eingaben
 * (Höhe jetzt in 0.1 mm Schritten einstellbar)
 */

// =======================================================
// === CUSTOMIZER-PARAMETER (Einstellfelder rechts) ===
// =======================================================

// @param innendurchmesser Innendurchmesser des Rings [10:0.1:50]
innendurchmesser = 14.2; 

// @param aussendurchmesser Außendurchmesser des Rings [10.2:0.1:60]
aussendurchmesser = 15.8; 

// Die Änderung: Der mittlere Wert im Array gibt den Schrittwert an (hier 0.1).
// @param hoehe Höhe des Rings [1:0.1:50] 
hoehe = 4.5; // Auf Ihren Wunschwert 4.5 mm gesetzt

// @param $fn Auflösung (Höher = Runder, aber längeres Rendern) [20:1:200]
$fn = 100; 

// =======================================================
// === MODELLIERUNG LOGIK ===
// =======================================================

// Berechne die Radien 
innenradius = innendurchmesser / 2;
aussenradius = aussendurchmesser / 2;

// Der "difference" Block subtrahiert den inneren Zylinder vom äußeren.
difference() {
    
    // Äußerer Zylinder (Der Körper des Rings)
    cylinder(r = aussenradius, h = hoehe, center = false);

    // Innerer Zylinder, der subtrahiert wird (Das Loch)
    translate([0, 0, -0.1])
    cylinder(r = innenradius, h = hoehe + 0.2, center = false);
}