#include <U8g2lib.h>
#include <Wire.h>
#include <SPI.h>
#include "Adafruit_SHT31.h"
#include <WiFi.h>
//#define NTP_SERVER "de.pool.ntp.org"
#define NTP_SERVER "Fritz.Box"
//#define TZ_INFO "WEST-1DWEST-2,M3.5.0/02:00:00,M10.5.0/03:00:00" // Western European Time
const char* TZ_INFO = "CET-1CEST-2,M3.5.0/02:00:00,M10.5.0/03:00:00";

char wochentage[7][12] = { "Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Sonnabend" };
//char wochentage[7][12] = {"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};   // Englisch

#define SDA_PIN 21
#define SCL_PIN 22
U8G2_SSD1306_128X64_NONAME_F_SW_I2C u8g2(U8G2_R0, SCL_PIN, SDA_PIN, U8X8_PIN_NONE);
U8G2_SSD1306_128X64_NONAME_F_SW_I2C u8g2_2(U8G2_R0, SCL_PIN, SDA_PIN, U8X8_PIN_NONE);

#define SDA_1 17
#define SCL_1 16
#define I2C_FREQ 400000
#define SHT31_I2C_ADDRESS 0x44


TwoWire I2C_1 = TwoWire(0);
Adafruit_SHT31 sht31 = Adafruit_SHT31(&I2C_1);


unsigned long previousMillis_d = 0;
long interval_d = 1000;

unsigned long previousMillis_d2 = 0;
long interval_d2 = 30000;

unsigned long previousMillis_sen = 0;
long interval_sen = 5000;

unsigned long previousMillis_up = 0;
long interval_up = 3600000;

byte zaehler = 0;

const int RunningAverageCountTemp = 5;  // Anzahl der in den Laufenden-Mettelwert aufgenommenen Messungen
float RunningAverageBufferTemp[RunningAverageCountTemp];
int NextRunningAverageTemp;

const int RunningAverageCountHum = 5;  // Anzahl der in den Laufenden-Mettelwert aufgenommenen Messungen
float RunningAverageBufferHum[RunningAverageCountHum];
int NextRunningAverageHum;

float Temp;
float AVG_Temp;
float Hum;
float AVG_Hum;

int Hum_Diff = +6.6;
int Temp_Diff = -3.1;

//---------------------Setup---------------------------
void setup() {
  Serial.begin(9600);
  pinMode(4, OUTPUT);
  digitalWrite(4, HIGH);
  I2C_1.begin(SDA_1, SCL_1, I2C_FREQ);
  sht31.begin(0x44);
 
  u8g2.setI2CAddress(0x3C * 2);
  u8g2.begin();
  u8g2_2.setI2CAddress(0x3D * 2);
  u8g2_2.begin();

  NTP_Zeit();
}
//---------------------LOOP---------------------------
void loop() {

  tm local;
  getLocalTime(&local);

//-----------------------Zeitabgleich------------------------

  unsigned long currentMillis_up = millis();
  if (currentMillis_up - previousMillis_up > interval_up) {
    previousMillis_up = currentMillis_up;
    NTP_Zeit();
  }

  //---------------------Sensor Auslesen---------------------

  unsigned long currentMillis_sen = millis();
  if (currentMillis_sen - previousMillis_sen > interval_sen) {
    previousMillis_sen = currentMillis_sen;
    Hum = (sht31.readHumidity() +Hum_Diff);
    Temp = (sht31.readTemperature() +Temp_Diff);
  

  float RawTemperatureTemp = Temp;

  RunningAverageBufferTemp[NextRunningAverageTemp++] = RawTemperatureTemp;
  if (NextRunningAverageTemp >= RunningAverageCountTemp) {
    NextRunningAverageTemp = 0;
  }
  float RunningAverageTemperatureTemp = 0;
  for (int i = 0; i < RunningAverageCountTemp; ++i) {
    RunningAverageTemperatureTemp += RunningAverageBufferTemp[i];
  }
  RunningAverageTemperatureTemp /= RunningAverageCountTemp;
  AVG_Temp = RunningAverageTemperatureTemp ;

  float RawHuminityHum = Hum;

  RunningAverageBufferHum[NextRunningAverageHum++] = RawHuminityHum;
  if (NextRunningAverageHum >= RunningAverageCountHum) {
    NextRunningAverageHum = 0;
  }
  float RunningAverageHumidityHum = 0;
  for (int i = 0; i < RunningAverageCountHum; ++i) {
    RunningAverageHumidityHum += RunningAverageBufferHum[i];
  }
  RunningAverageHumidityHum /= RunningAverageCountHum;
  AVG_Hum = RunningAverageHumidityHum ;
  }
 
  


//----------------------Dispaly 1-----------------------------

  unsigned long currentMillis_d2 = millis();

  if (currentMillis_d2 - previousMillis_d2 > interval_d2) {

    previousMillis_d2 = currentMillis_d2;

    u8g2.firstPage();
    u8g2.clearBuffer();

    u8g2.setFont(u8g2_font_inr27_t_cyrillic);
    u8g2.setCursor(5, 30);
    u8g2.print(AVG_Temp, 1);
    u8g2.drawCircle(100, 5, 3, U8G2_DRAW_ALL);
    u8g2.setCursor(105, 30);
    u8g2.print("C");

    u8g2.setFont(u8g2_font_inr27_t_cyrillic);
    u8g2.setCursor(5, 63);
    u8g2.print(AVG_Hum, 1);
    u8g2.setCursor(100, 63);
    u8g2.print("%");

    u8g2.sendBuffer();
  }

  //------------------Display 2-----------------------------

  unsigned long currentMillis_d = millis();

  if (currentMillis_d - previousMillis_d > interval_d) {

    previousMillis_d = currentMillis_d;


    u8g2_2.firstPage();
    u8g2_2.clearBuffer();

    u8g2_2.setFont(u8g2_font_spleen32x64_mu);
    u8g2_2.setCursor(0, 64);
    u8g2_2.printf("%02d \n", local.tm_hour);
    u8g2_2.setFont(u8g2_font_logisoso34_tn);
    u8g2_2.setCursor(60, 58);
    u8g2_2.print(":");
    u8g2_2.setFont(u8g2_font_spleen32x64_mu);
    u8g2_2.setCursor(68, 64);
    u8g2_2.printf("%02d \n", local.tm_min);
    u8g2_2.setFont(u8g2_font_spleen8x16_mf);
    u8g2_2.setCursor(15, 12);
    u8g2_2.print(wochentage[local.tm_wday]);
    u8g2_2.setFont(u8g2_font_spleen6x12_mf);
    u8g2_2.setCursor(115, 11);
    u8g2_2.print(&local, "%S");
    //u8g2_2.nextPage();
    u8g2_2.sendBuffer();
  }

  if (local.tm_mday == 1 && local.tm_hour == 0 && local.tm_min == 0 && local.tm_sec == 0) {
      ESP.restart();
    }
}

//----------------WIFI Verbindung---------------------
void NTP_Zeit() {
  WiFi.mode(WIFI_STA);
  WiFi.begin(" SSID ", " Password ");          // insert SSID and password

  while (WiFi.status() != WL_CONNECTED) {
    delay(5000);
  }
  struct tm local;
  configTzTime(TZ_INFO, NTP_SERVER);  // ESP32 Systemzeit mit NTP Synchronisieren
  getLocalTime(&local, 10000);        // Versuche 10 s zu Synchronisieren
  WiFi.mode(WIFI_OFF);
  //Serial.printf(" \tLast Update: %02d:%02d:%02d \n", local.tm_hour, local.tm_min, local.tm_sec);
}