// GMKtec NucBox K8 Plus
// Under-Desk-Mount-Bracket

$fn = 200;

// the good kind of slop! This was quite alright for PLA or PETG
SLOP = 0.4;

// front to back
DEPTH = 132.5 + SLOP;
WIDTH = 125 + SLOP;
HEIGHT = 65;

// wall thickness
W = 3;

// that is the distance from the side to the intake vents
INTAKE_OFFSET = 22;

// feet diameter, the actual measured diameter is 12.5mm, however these are
// adhesive attached rubber feet, so give them a little more air
FEETD = 14 + SLOP;
// feet inset from walls
FEETI = 6;

// tab size
TABS = 12;
// tabs screw diameter
TSD = 5;

module cage() {
    difference() {
        // Main Cage
        cube(size=[WIDTH + W*2, DEPTH + W, HEIGHT + W], center=false);
        
        // Main body cut-out
        translate([W, W, W])
            cube(size=[WIDTH, DEPTH+W, HEIGHT], center=false);    

        // backside: I/O slot
        translate([6+W,0,W+4])
            cube(size=[WIDTH - 12, W, HEIGHT - 4 - 14]);

        // Vent right
        translate([0,INTAKE_OFFSET+W,15])
            cube(size=[W, DEPTH - INTAKE_OFFSET * 2, HEIGHT - 35]);

        // Vent left
        translate([WIDTH+W,INTAKE_OFFSET+W,15])
            cube(size=[W, DEPTH - INTAKE_OFFSET*2, HEIGHT - 35]);

        // feet
        translate([W + FEETI + FEETD/2,W + FEETI + FEETD/2,0])
            union() {
                cylinder(W, FEETD/2, FEETD/2);
                translate([WIDTH-FEETI*2-FEETD, 0, 0])
                    cylinder(W, FEETD/2, FEETD/2);
                translate([WIDTH-FEETI*2-FEETD, DEPTH-FEETI*2-FEETD, 0])
                    cylinder(W, FEETD/2, FEETD/2);
                translate([0, DEPTH-FEETI*2-FEETD, 0])
                    cylinder(W, FEETD/2, FEETD/2);
            };

        // main vent, just a big hole
        translate([W + WIDTH / 2, W + DEPTH / 2, 0]) cylinder(W, 55, 55);

        // lets add some speed holes!
        count = 6;
        step = (DEPTH - W - INTAKE_OFFSET) / count;
        radius = 5;
        for(i = [1:count]) {
            translate([0, step * i + radius, HEIGHT - 9]) rotate([0,90,0]) cylinder(W, radius, radius);
            translate([WIDTH + W, step * i + radius, HEIGHT - 9]) rotate([0,90,0]) cylinder(W, radius, radius);
        }
    };

    // mounting tabs
    module tab() {
        difference() {
            union() {
                translate([-TABS/2,0,0])
                    cube([TABS/2, TABS, W]);
                translate([-TABS/2,TABS/2,0]) cylinder(W, TABS/2, TABS/2);
            };
            translate([-TABS/2, TABS/2, 0]) cylinder(W, TSD/2, TSD/2);
        };
    }

    translate([0,0,HEIGHT])
        union() {
            tab();
            translate([0,DEPTH-TABS/2-W,0]) tab();
            
            translate([WIDTH+W*2,DEPTH+W,0])
            rotate([0,0,180])
            union() {        
                tab();
                translate([0,DEPTH-TABS/2-W,0]) tab();
            };
        };

    // front bottom retainer, the k8plus should slides over this with its feet
    // when this is mounted
    translate([0, W+DEPTH, 0]) cube([WIDTH+W*2, W, W+5]);
}

cage();

// radius
RR = 2;

// bevel inner edges, this is messy, added to provide a little more strength
union() {
    // round out inner corners, right bottom
    translate([W,W,W])
        difference() {
            cube([RR,DEPTH,RR]);
            translate([RR, 0, RR]) rotate([-90, 0, 0]) cylinder(DEPTH, RR, RR);
        };
        
    // round out inner corners, left bottom
    translate([WIDTH+W-RR,W,W]) difference() {
        cube([RR,DEPTH,RR]);
        translate([0, 0, RR]) rotate([-90, 0, 0]) cylinder(DEPTH, RR, RR);
    };
    
    // left back
    difference() {
        translate([W, W, W]) cube([RR, RR, HEIGHT]);
        translate([W+RR, W+RR, W]) cylinder(HEIGHT, RR, RR);
    }
    
    // right back
    difference() {
        translate([WIDTH+W-RR, W, W]) cube([RR, RR, HEIGHT]);
        translate([WIDTH+W-RR, W+RR, W]) cylinder(HEIGHT, RR, RR);
    }
    
    // back bottom
    translate([RR, RR, RR])
    difference() {
        translate([0, W-RR, W-RR]) cube([WIDTH+W, RR, RR]);
        translate([0, W, W]) rotate([0, 90, 0]) cylinder(WIDTH+W, RR, RR);
    }

    // front bottom
    translate([WIDTH+W, DEPTH+W*2-RR, RR])
    rotate([0,0,180])
    union() {
        difference() {
            translate([0, W-RR, W-RR]) cube([WIDTH+W, RR, RR]);
            translate([0, W, W]) rotate([0, 90, 0]) cylinder(WIDTH+W, RR, RR);
        }
    }

    // triple intersection of bevels, left
    difference() {
        translate([W, W, W]) cube([RR, RR, RR]);
        translate([W+RR, W+RR, W+RR]) sphere(RR);
    }

    //right
    difference() {
        translate([WIDTH+W-RR, W, W]) cube([RR, RR, RR]);
        translate([WIDTH+W-RR, W+RR, W+RR]) sphere(RR);
    }
}