/* 2025 CC-BY Jan "jprofesorek" K. */

/* [Drill table] */
// Sorry, openscad customizer does not support vectors longer than four elements
Edit_source_to_customize_drill_sizes_and_lengths=false;


// vectors of drill diameters and lengths

drills=[4.5, 5.0, 5.5, 6.0, 6.5, 7.0, 7.5, 8.0, 8.5, 9.0, 9.5, 10.0];
lengths=[85, 90,  95,  95,  102, 110, 111, 120, 120, 130, 130, 138];

//modify ^^these^^ to customize how many and what size of
//drills and of which length thereof shall the box contain

/* [Parts] */

generate_box=true;
generate_lid=true;
generate_mouse_ears=false;

/* [Wall thicknessess] */

// thickness of  vertical walls
wallXY=1.2; //[0:0.1:3]
// thickness of horizontal walls
wallZ=0.8; //[0:0.1:2]

/* [Compartment size, tolerances, clearances] */

// How many drills of that size should fit in a compartment
drillMult=1;//[1:0.1:10]

// extra width of each compartment
drillPlay=1.0; //[0:0.1:10]
// extra length of each compartment
lengthPlay=3.0; //[0:0.1:30]
// extra height of the compartments
heightPlay=1.0; //[0:0.1:10]

// clearence between walls of the box and the lid
lidPlay=0.5;//[0:0.025:1]

// clearence between hinge sections
hingePlay=0.25;//[0:0.025:1]

/* [Hinge settings] */

// diameter of the hinge axis; 2.0 fits nicely the 1.75mm filament
hingeDia=2.0; //[0:0.1:10]
// hinge has this many segments on box (and one more on lid)
hingeSections=5;//[1:1:20]

// distance from the back wall of the box to the hinge axis
hingeOffset=2; //[0:0.1:10]

// distance from the back wall of the box to where the hinge starts on the lid
lidHingeOffset=0.5; //[0:0.1:10]

/* [Tab/protrusion to opening the box] */

// width, as a fraction of box total width
openingTabRelWidth=0.4; //[0:0.025:1]
// how much the tab protrudes from the box/lid outline
openingTabLen=2.0; //[0:0.1:10]
// Z height of the tab
openingTabH=1.6; //[0:0.1:10]

/* [Cutout for picking up drills] */

// width on top
coDim1=30; //[0:1:200]
// width on bottom
coDim2=20; //[0:1:200]
// distance from the front of the box
coOff=10; //[-20:1:200]
// radius for roundings
coRound=5; //[0.1:0.1:8]

/* [Latch settings] */

// how much the latch protrudes from the box
latchSize=1.5;//[1:0.1:5]

// width of the latch, as a fraction of box width
latchRelW=0.075; //[0:0.005:0.4]
// position of the latch, as a fraction of box width
latchRelOff=0.125; //[0:0.005:0.4]

// how far from the bottom of the box shall the latch start
latchZ1=2.6;//[0:0.1:10]
// for this length the latch goes straight up
latchStr=0.6;//[0.1:0.1:2]

/* [Misc] */

// The ususal accuracy of roundings
$fn=36;

// generate drill compartments aligned to hinge, not front
upside_down=false;

// larger drills to the left
mirrored = false;

mouseEarsH=0.4;
mouseEarsR=10;

// // // // // // // // // // // // // // // // // // // // //

function sum(v) = [for(p=[0:len(v)-1]) 1]*v;
function sumUpTo(v,n) = n<0?0:[for(p=[0:n]) 1, for(p=[n+1:len(v)-1]) 0]*v;

// // // // // // // // // // // // // // // // // // // // //

// internal length of the box
iL=max(lengths)+lengthPlay;

// total width of the box
tW=(len(drills)+1)*wallXY+len(drills)*drillPlay+sum(drills)*drillMult;

// total height of the box with lid
tH=max(drills)+heightPlay+2*wallZ;

// total length of the box (informational only, not used in code)
tL=iL+2*(wallXY)+hingeDia+hingeOffset+openingTabLen;

// latch width, absolute units
latchW=tW*latchRelW;
// latch first goes 45° up, calculate where it stops expanding
latchZ2=latchZ1+latchSize;
// latch shall stop on top of the box
latchZ3=tH-wallZ;

// total lid width
tLw=tW+2*wallXY+lidPlay;
// "total" lid length, without hinge and tab
tLl=iL+3*wallXY+lidPlay;

// // // // // // // // // // // // // // // // // // // // //

if(generate_box)
	box();

if(generate_lid)
	translate([0,-2-2*(generate_mouse_ears?mouseEarsR:0)-wallXY-lidPlay/2,tH])
		rotate([180,0,0])
			lid();

if(generate_mouse_ears && generate_box)
	for(x=[0,iL+2*wallXY])for(y=[0,tW])translate([x,y])
		cylinder(r=mouseEarsR,h=mouseEarsH);

if(generate_mouse_ears && generate_lid)
	translate([0,-2-2*(mouseEarsR)-tLw,0])
		for(x=[-hingeOffset-hingeDia/2,tLl])for(y=[0,tLw])translate([x,y])
			cylinder(r=mouseEarsR,h=mouseEarsH);

// // // // // // // // // // // // // // // // // // // // //

echo(str("box dimensions: ", tW,"×",tL,"×",tH-wallZ)); 
echo(str("lid dimensions: ", tLw,"×",tLl+hingeDia+hingeOffset+openingTabLen,"×",tH)); 

// // // // // // // // // // // // // // // // // // // // //


module lid(){
	difference(){
		union(){
		    // main (full) shape of the lid
			intersection(){
				translate([0,-wallXY-lidPlay/2,0])
					cube([tLl, tLw, tH]);
				translate([0,-wallXY-lidPlay/2,0])
					rotate([-90,0,0])
						cylinder(r=tLl,h=tLw,$fn=360);
			}
			// opening tab
			hull(){
				translate([0,tW/2-(tW*openingTabRelWidth+2*openingTabLen)/2,tH-openingTabH])
					cube([tLl-openingTabLen,tW*openingTabRelWidth+2*openingTabLen,openingTabH]);
				translate([0,tW/2-(tW*openingTabRelWidth-2*openingTabLen)/2,tH-openingTabH])
					cube([tLl+openingTabLen,tW*openingTabRelWidth-2*openingTabLen,openingTabH]);
			}
			// walls around latches
			latchExtraWalls(lidPlay);
		}
		// substraction:
		
		// main shape of the lid cutout
		intersection(){
			translate([-1,-lidPlay/2,-1])
				cube([tLl-wallXY+1, tLw-2*wallXY, tH-wallZ+1]);
			translate([0,-wallXY-lidPlay/2,0])
				rotate([-90,0,0])
					cylinder(r=tLl-wallXY,h=tLw,$fn=360);
		}
		
		// latches
		boxLatches(lidPlay);
		
		// cutout for the opening tab
		hull(){
			translate([tLl-wallXY-1,tW/2-(tW*openingTabRelWidth+2*openingTabLen)/2,0])
				cube([2+wallXY,tW*openingTabRelWidth+2*openingTabLen,lidPlay+openingTabH]);
			translate([tLl-wallXY-1,tW/2-(tW*openingTabRelWidth+(lidPlay+openingTabH)+2*openingTabLen)/2,-1])
				cube([2+wallXY,tW*openingTabRelWidth+(lidPlay+openingTabH)+2*openingTabLen,1]);
		}
	}
	
	// // // lid hinge start
	
	hinYStart=-wallXY-lidPlay/2;
	hinYlen=tLw;
	htv=[-hingeDia/2-hingeOffset,hinYStart,tH/2];
	
	// making wallZ longer (stretching it to the hinge)
	translate([-hingeOffset-hingeDia/2, hinYStart, tH-wallZ])
		cube([hingeOffset+hingeDia/2+1, hinYlen, wallZ]);
	
	//hinge
	intersection(){
		difference(){
			union(){
				// most of the hinge
				hull(){
					translate([-hingeOffset-hingeDia/2, hinYStart ,tH-wallZ])
						cube([hingeOffset-lidHingeOffset+hingeDia/2, hinYlen, wallZ]);
					translate(htv)
						rotate([-90,0,0])
							cylinder(d=hingeDia+2*wallXY,h=hinYlen);
				}
				// sides of the hinge
				for(i=[0,hinYlen-wallXY])translate([0, i, 0])
					hull(){
						translate([0, hinYStart, 0])
							cube([1, wallXY, tH]);
						translate(htv)
							rotate([-90,0,0])
								cylinder(d=hingeDia+2*wallXY,h=wallXY);
					}
			}
			// hinge axis
			translate(htv)
				rotate([-90,0,0])
					translate([0,0,-1])
						cylinder(d=hingeDia,h=hinYlen+2);
			// on top of hinge axis, for priting, a slot to prevent overhangs & bridges sagging into the axis
			translate(htv)
				translate([0,-1,0])
					rotate([0,90+45,0])
						cube([hingeDia/2,hinYlen+2,hingeDia/2]);
		}
		// hinge section cutout
		h1mask();
	}

}

module fingerCutout2D(){
	r=coRound;
	h=max(drills)+heightPlay;
	w=(coDim1-coDim2)/2;
	a=atan(w/h);
	
	translate([0,wallZ,0])
	roundedCutout2D(r,h,w);
}

//  --.             .--  that shape in 2D used 
//     \           /     for cutout "enabling"
//      \         /      picking the drills
//       `-------'
module roundedCutout2D(r,h,w,l=coDim2){
	a=atan(w/h);
	translate([w,0,0])
	difference(){
		polygon([
			[-(h-r)*tan(a)-r/cos(a),0],
			[-(h-r)*tan(a)-r/cos(a),h],
			
			//two points for imperfect rotating $fn-sided "circle"
			[-(h-r)*tan(a)-r/cos(a)-10,h+1],
			[l+-(-(h-r)*tan(a)-r/cos(a))+10,h+1],
			
			[l+-(-(h-r)*tan(a)-r/cos(a)),h],
			[l+-(-(h-r)*tan(a)-r/cos(a)),0]
		]);

		oneSide();
		translate([l,0,0])
			mirror([1,0,0])oneSide();
	}

	module oneSide(){
		difference(){
			hull(){
				translate([-1-((r-1)*cos(a))*tan(a),-1])
					square([1,(r-1)*cos(a)+1]);

				translate([-1-((r-1)*cos(a))*tan(a)+r,-1])
					square([1,(r-1)*cos(a)+1]);		
			}
			translate([r*(-tan(a)+1/cos(a)),r])
				circle(r=r);
		}
			
		hull(){
			translate([-(h-r)*tan(a)-r/cos(a),h-r])
				circle(r=r);
				
			translate([-(h-r)*tan(a)-r/cos(a),r-1])
				circle(r=r);
				
			translate([-1-((r-1)*cos(a))*tan(a),-1])
				square([1,(r-1)*cos(a)+1]);
		}	
	}
}
	
module box(){
	// main box outer walls, minus front wall
	difference(){
		cube([iL+wallXY, tW, tH-wallZ]);
		translate([wallXY, wallXY, wallZ])
		cube([iL, tW-2*wallXY, tH]);
	}

	// front wall
	intersection(){
		cube([iL+2*wallXY, tW, tH-wallZ]);
		rotate([-90,0,0])
			difference(){
				cylinder(r=iL+2*wallXY,h=tW,$fn=360);
				translate([0,0,-1])
					cylinder(r=iL+wallXY,h=tW+2,$fn=360);
			}
	}
	
	difference(){
		union(){
			// opening tab
			hull(){
				translate([0,tW/2-(tW*openingTabRelWidth+2*openingTabLen)/2,0])
					cube([tLl-openingTabLen,tW*openingTabRelWidth+2*openingTabLen,openingTabH]);
				translate([0,tW/2-(tW*openingTabRelWidth-2*openingTabLen)/2,0])
					cube([tLl+openingTabLen,tW*openingTabRelWidth-2*openingTabLen,openingTabH]);
			}
			// latches
			boxLatches(0);
		}
		rotate([-90,0,0])
			cylinder(r=iL+1*wallXY,h=tW,$fn=360);
	}
	

	// main box (with front wall) outline for drill compartments
	module mask()
		difference(){
			intersection(){
				cube([iL+2*wallXY, tW, tH-wallZ]);
				rotate([-90,0,0])
				cylinder(r=iL+2*wallXY,h=tW,$fn=360);
			}
			translate([upside_down?wallXY+coOff:iL+wallXY-coOff-coDim1,0,0])
				rotate([90,0,0])
					translate([0,0,-tW-1])
						linear_extrude(height=tW+2) fingerCutout2D();
		}

	
		
	// dividers, aka drill compartments 
	mirror([0,mirrored?1:0,0])translate([0,mirrored?-tW:0,0])
	intersection(){
		for(index=[0:len(drills)-1]){
			pos=wallXY+drillPlay+sumUpTo(drills,index-1)*drillMult+(index-1)*(wallXY+drillPlay);
			echo(str("drill #",index, "   diameter ",drills[index],"   length ",lengths[index]));
			tv=upside_down
			   ? [0,pos,0]
			   : [iL+2*(wallXY)-(lengths[index]+lengthPlay+2*wallXY),pos,0]
			;
			translate(tv)
			difference(){
				cube([
						lengths[index]+lengthPlay+2*wallXY,
						drills[index]*drillMult+drillPlay+2*wallXY,
						tH
					  ]);
				translate([wallXY, wallXY, 0]) cube([
						lengths[index]+lengthPlay,
						drills[index]*drillMult+drillPlay,
						tH
					  ]);
			}
		}
		mask();
	}

	// box hinge
	htv=[-hingeDia/2-hingeOffset,0,tH/2];
	difference(){
		hull(){
			translate([0,0,0])
				cube([wallXY, tW, tH-wallZ]);
			translate(htv)
				rotate([-90,0,0])
					cylinder(d=hingeDia+2*wallXY,h=tW);
		}
		translate(htv)
			rotate([-90,0,0])
				translate([0,0,-1])
					cylinder(d=hingeDia,h=tW+2);
		translate(htv)
			translate([0,-1,0])
				rotate([0,-45,0])
					cube([hingeDia/2,tW+2,hingeDia/2]);
		h2mask();
	}
}


// hinge "outer" cutout (for intersection) 
section=(tW+2*wallXY+hingePlay)/(2*hingeSections+1);
module h1mask(){
	for(i=[0:hingeSections]){
		translate([-75,section*2*i-wallXY,-25])
		cube([100, section-hingePlay, 100]);
	}
	translate([-75,section*-0.5-wallXY,-25])
		cube([100, section, 100]);
	translate([-75,section*(hingeSections*2+0.5)-wallXY,-25])
		cube([100, section, 100]);
}

// hinge "inner" cutout (for difference)
module h2mask(){
	for(i=[0:hingeSections]){
		translate([-75,section*2*i-hingePlay-wallXY,-25])
		cube([100, section+hingePlay, 100]);
	}
}

// helper for protruding walls of the lid 
module latchExtraWalls(extraR)
	minkowski(){
		boxLatches(extraR);
		translate([-wallXY,-wallXY,-wallZ])
			cube([2*wallXY,2*wallXY,2*wallZ]);
	}

module boxLatches(extraR){
	translate([iL+2*wallXY+extraR,tW*latchRelOff,0])
		latch(extraR);

	translate([iL+2*wallXY+extraR,tW*(1-latchRelOff),0])
		mirror([0,1,0])
			latch(extraR);	
}
	
module latch(extraR){
	lsq=sqrt(pow(iL+2*wallXY+extraR,2)-pow(tH-wallZ,2));
	a=acos(lsq/(iL+2*wallXY+extraR))/2;
	rotate([0,-a,0])
	hull(){
		translate([-latchSize,0,latchZ2])
			cube([latchSize*2,latchW,latchStr]);
		translate([-latchSize,-latchW*0.25,latchZ1])
			cube([latchSize,latchW*1.5,latchZ3-latchZ1]);
	}

}
