// Special variable in OpenSCAD to smooth edges of rounded shapes
$fn = 250;

// Cover values
THICKNESS=1;
CORNER_DIAMETER=4;

// Screw hole plug values
INNER_HEIGHT=6.5;
INNER_DIAMETER=11.25;
OUTER_DIAMETER=15.3;
CROSS_THICKNESS=1;
CROSS_LENGTH=INNER_DIAMETER + 0.5;

module cross_tab() {
    translate([-CROSS_LENGTH/2,-CROSS_THICKNESS/2,0]) cube([CROSS_LENGTH, CROSS_THICKNESS, INNER_HEIGHT]);
}

module cover() {
    hull() {
        cylinder(h=THICKNESS, d=CORNER_DIAMETER);
        translate([0, 99.25, 0]) cylinder(h=THICKNESS, d=CORNER_DIAMETER); 
        translate([118.5, 28, 0]) cylinder(h=THICKNESS, d=CORNER_DIAMETER);
        translate([118.5, 89, 0]) cylinder(h=THICKNESS, d=CORNER_DIAMETER);
    }
}

module screw_plug() {
    // Top cap
    cylinder(h=THICKNESS, d=OUTER_DIAMETER);

    // Inner cylinder
    difference() {
        union() {
            // Cross tabs
            cross_tab();
            rotate([0,0,90]) cross_tab();
            cylinder(h=INNER_HEIGHT, d=INNER_DIAMETER);
        }
        cylinder(h=INNER_HEIGHT, d=INNER_DIAMETER - 1.5);
    }
}

// Mirror things to put them in an orientation for printing
mirror([1,0,0]) cover();
mirror([1,0,0]) translate([115,79,0]) screw_plug();
mirror([1,0,0]) translate([59.25,21,0]) screw_plug();