$fn=50;

// Unit is the millimeter

PhoneHeight = 150;
PhoneWidth = 71;
PhoneDepth = 9.5;

CoverEdgeThickness = 3;

CdInsertThickness = 2;
CdInsertBumpHeight=2.5;
CdInsertAngle=95;
CdInsertOffset=15;

BackSupportAngle=5;

module Elipsoid(width, heigth, x,y,z){
  translate([x,y,z]) {
    scale([width, width, heigth]) {
        sphere(d=1);
    }
  }
}


module SolidFrame() {
  hull() {
    Elipsoid(
      CoverEdgeThickness*4,
      PhoneDepth+CoverEdgeThickness*2, 
     -PhoneWidth/2,0,0);
    
    Elipsoid(
      CoverEdgeThickness*4,
      PhoneDepth+CoverEdgeThickness*2, 
      PhoneWidth/2,0,0);

    Elipsoid(
      CoverEdgeThickness*4,
      PhoneDepth+CoverEdgeThickness*2, 
      -PhoneWidth/2,PhoneHeight/3,0);
    
    Elipsoid(
      CoverEdgeThickness*4,
      PhoneDepth+CoverEdgeThickness*2, 
      PhoneWidth/2,PhoneHeight/3,0);
  }
}  


module OpenFrame() {
  // Cut off top 66%
  difference() {
    SolidFrame();
    translate([-PhoneWidth,PhoneHeight/3+CoverEdgeThickness*2,-PhoneDepth]) {
      cube([PhoneWidth*2,PhoneHeight*2,PhoneDepth*2]);
    }

  // Open inside from top
    translate([-PhoneWidth/2+CoverEdgeThickness,CoverEdgeThickness,-PhoneDepth/2]) {
      cube([PhoneWidth-CoverEdgeThickness*2,PhoneHeight,PhoneDepth*2]);
    }

  // Carve inside sides
    translate([-PhoneWidth/2,0,-PhoneDepth/2]) {
      cube([PhoneWidth,PhoneHeight,PhoneDepth]);
    }
    
  // Carve out holes in bottom of frame
    translate([-PhoneWidth/2+CoverEdgeThickness*3,-CoverEdgeThickness*4,-PhoneDepth/2]) {
      cube([PhoneWidth-CoverEdgeThickness*6,PhoneHeight*2,PhoneDepth*2]);
    }
  }
}

module CdInsert() {
  // large surface
  hull() {
    translate([-(35),0,-19-CoverEdgeThickness*2]) {
      rotate([90,0,0]) cylinder(h=CdInsertThickness,r=19);
    }
    translate([+(35),0,-19-CoverEdgeThickness*2]) {
      rotate([90,0,0]) cylinder(h=CdInsertThickness,r=19);
    }
  }
  //Small bumps in surface to hold plate in slot
for(ball_position = [-16 : -8 : -40])
  { 
    translate([-60+19,-CdInsertThickness,ball_position]) {
    sphere(r=CdInsertBumpHeight);
    }
    translate([+60-19,-CdInsertThickness,ball_position]) {
    sphere(r=CdInsertBumpHeight);
    }

    translate([0,0,ball_position]) {
    sphere(r=CdInsertBumpHeight);
    }
  }
}

module BackSupport() {
translate([0,7,CdInsertOffset]) 
  difference() {
  cylinder(r1=5,r2=10,h=40);
    translate([-100,-200,0]) cube([200,200,200]);
  }
  

translate([0,7,CdInsertOffset])  
  difference()
  {
    rotate([0,90,0]) cylinder(r1=5,r2=2,h=35);
    translate([0,-200,-100]) cube([200,200,200]);
  }

translate([0,7,CdInsertOffset])  
rotate([0,180,0]) 
  difference()
  {
    rotate([0,90,0]) cylinder(r1=5,r2=2,h=35);
    translate([0,-200,-100]) cube([200,200,200]);
  }
  
  
  }

module PhoneMount() {
  translate([0,0,CoverEdgeThickness*2]) rotate([90,0,0]) OpenFrame();
  translate([0,0,CdInsertOffset]) rotate([CdInsertAngle,0,0]) CdInsert();
  BackSupport();
  }

PhoneMount();
