//=======================================================================================
//Disable $fn and $fa
$fn=0;
$fa=0.01;

//Use only $fs
//fine
$fs=0.25;

//coarse
//$fs=1;

//rotate axes
X=[1,0,0];
Y=[0,1,0];
Z=[0,0,1];
//======================================================================================
module torus(outerRadius, innerRadius)
  {
  r=(outerRadius-innerRadius)/2;
  rotate_extrude() translate([innerRadius+r,0,0]) circle(r);
  }
//=======================================================================================
module round_cylinder_cap(r_outer,r_smooth)
  {
  difference()
    {
    //positive
    union()
      {
      cylinder(r=r_outer+0.1,h=r_smooth+0.1);
      }
    //negative
    union()
      {
      rotate_extrude()
        translate([r_outer-r_smooth,0,0])
          circle(r_smooth);
      translate([0,0,-0.1])
        cylinder(r=r_outer-r_smooth-0.1,h=r_smooth+0.3);
      }
    }
  }  
//=======================================================================================
module outer_roundy_corner(rxy,rz)
  {
  translate([-rxy,-rxy,-rz])
    {
    difference()
      {
      //positive
      union()
        {
        cube([rxy+0.1,rxy+0.1,rz+0.1]);
        }
    //negative
      union()
        {
        torus(outerRadius=rxy,innerRadius=rxy-2*rz);
        translate([0,0,-0.1])
          cylinder(r=rxy-rz,h=rz+0.3);
        }
      }
    }
  }
//=======================================================================================
module outer_roundy_corner_sphere(radius)
  {
  difference()
    {
    //positive
    union()
      {
      translate([-0.1,-0.1,0])
        cube(radius+0.1);
      }
    //negative
    union()
      {
      translate([radius,radius,radius])
        sphere(radius);
      }
    }
  }
//=======================================================================================
module radius(radius,length,axis)
  {
  if(axis=="X")
    {
  rotate(90,[1,0,0]) rotate(90,[0,1,0])
      translate([0,0,-0.1])
        linear_extrude(height = length+0.2, center = false, convexity = 4, twist = 0)
          difference()
            {
            translate([-0.1,-0.1]) square([radius+0.1,radius+0.1]);
            translate([radius,radius]) circle(r=radius);
            }
  }
  else if(axis=="Y")
    {
  rotate(270,[0,1,0]) rotate(270,[1,0,0])
      translate([0,0,-0.1])
        linear_extrude(height = length+0.2, center = false, convexity = 4, twist = 0)
          difference()
            {
            translate([-0.1,-0.1]) square([radius+0.1,radius+0.1]);
            translate([radius,radius]) circle(r=radius);
            }
  }
  else
      {
      translate([0,0,-0.1])
        linear_extrude(height = length+0.2, center = false, convexity = 4, twist = 0)
          difference()
            {
            translate([-0.1,-0.1]) square([radius+0.1,radius+0.1]);
            translate([radius,radius]) circle(r=radius);
            }
    }
  }
//=======================================================================================
module Rounded_Rectangle(x,y,z,r)
  {
  difference()
    {
    union()
      {
      //positive
      cube([x,y,z], center=true);
      }
    union()
      {
      //negative
    translate([+x/2,+y/2,-z/2-0.01])
        rotate(180,Z)
          radius(radius=r,length=z+0.02,axis="Z");
      //negative
    translate([+x/2,-y/2,-z/2-0.01])
        rotate(90,Z)
          radius(radius=r,length=z+0.02,axis="Z");
      //negative
    translate([-x/2,+y/2,-z/2-0.01])
        rotate(-90,Z)
          radius(radius=r,length=z+0.02,axis="Z");
      //negative
    translate([-x/2,-y/2,-z/2-0.01])
        rotate(0,Z)
          radius(radius=r,length=z+0.02,axis="Z");
      }
    }
  }
//=======================================================================================
module Rounded_Rectangle_Cap(x,y,z,r)
  {
  difference()
    {
    union()
      {
      //positive
      cube([x,y,z], center=true);
      }
    union()
      {
      //negative
      //round the 4 upper edges
      translate([-x/2,-y/2,+z/2])
        rotate(90,Y)
          radius(radius=z,length=y,axis="Y");
      translate([+x/2,-y/2,+z/2])
        rotate(180,Y)
          radius(radius=z,length=y,axis="Y");
      translate([-x/2,-y/2,+z/2])
        rotate(-90,X)
          radius(radius=z,length=x,axis="X");
      translate([-x/2,+y/2,+z/2])
        rotate(180,X)
          radius(radius=z,length=x,axis="X");

      //roundy the corners
      translate([+x/2,+y/2,+z/2-0.01])
        rotate(0,Z)
          outer_roundy_corner(rxy=r,rz=z);
      translate([-x/2,+y/2,+z/2-0.01])
        rotate(90,Z)
          outer_roundy_corner(rxy=r,rz=z);
      translate([+x/2,-y/2,+z/2-0.01])
        rotate(-90,Z)
          outer_roundy_corner(rxy=r,rz=z);
      translate([-x/2,-y/2,+z/2-0.01])
        rotate(-180,Z)
          outer_roundy_corner(rxy=r,rz=z);
      }
    }
  }
//=======================================================================================
module Rounded_Rectangle_Shell(x,y,z,r,w)
  {
  difference()
    {
    union()
      {
      //positive
      Rounded_Rectangle(x,y,z,r);
      }
    union()
      {
      //negative
      Rounded_Rectangle(x-2*w,y-2*w,z+0.02,r-w);
      }
    }
  }
//=======================================================================================
hub_radius=35.0/2;
hub_depth=26.5;
//---------------------------------------------------------------------------------------
shaft_conical_relief_depth=5.0;
shaft_conical_relief_OR=31.5/2;
shaft_conical_relief_IR=24.75/2;
shaft_cylindrical_relief_depth=1.75;
shaft_cylindrical_relief_R=24.75/2;
shaft_across_flats=18.0;
shaft_depth=11.33;
shaft_minor_chamfer=23.5;
shaft_major_chamfer=1;
screw_hole_radius=6.35/2;
screw_head_radius=13.0/2;
screw_head_depth=5;

module shaft_cut_out()
  {
  difference()
    {
    union()
      {
      //positive
      //Main shaft
      translate([0,0,shaft_depth/2+shaft_cylindrical_relief_depth+shaft_conical_relief_depth])
        intersection()
          {
          rotate(45,Z)
            cube([shaft_across_flats,shaft_across_flats,shaft_depth],center=true);
          cube([shaft_minor_chamfer,shaft_minor_chamfer,shaft_depth],center=true);
          }
      //cylindrical section
      translate([0,0,shaft_conical_relief_depth-0.1])
        cylinder(r=shaft_cylindrical_relief_R,h=shaft_cylindrical_relief_depth+0.2);
      //conical section
      cylinder(r1=shaft_conical_relief_OR,r2=shaft_conical_relief_IR,h=shaft_conical_relief_depth);
      //Screw bore
      cylinder(r=screw_hole_radius,h=hub_depth+10);
      //Screw head clearance counterbore
      translate([0,0,hub_depth-screw_head_depth-0.1])
        cylinder(r=screw_head_radius,h=screw_head_depth+10.2);
      }
    union()
      {
      //negative
      //major flat
      translate([0,shaft_minor_chamfer/2-shaft_major_chamfer/2+0.05,shaft_depth/2+shaft_cylindrical_relief_depth+shaft_conical_relief_depth+0.05])
       cube([5,shaft_major_chamfer+0.1,shaft_depth+0.1],center=true);
      }
    }
  }
//=======================================================================================
paddle_base_z=9.5;
torus_rout=25;
torus_thick=14;
torous_rin=25-torus_thick;
lever=80.0;
module paddle()
  {
  //%cube([100,100,paddle_base_z]);  
  translate([0,0,-18.5])
    {
    rotate(15,X)  
      {  
      //right half = torus    
      difference()
        {
        union()
          {
          //positive
          //Torus is main shape
          translate([0,lever,torus_rout+paddle_base_z])
            rotate(90,Y)
              torus(outerRadius=torus_rout, innerRadius=torous_rin);
          }
        union()
          {
          //negative
          //Cut off left half of torus
          translate([-torus_thick/2-0.1,lever-torus_rout*2-0.1,paddle_base_z])
            cube([torus_thick+0.2,torus_rout*2+0.1,torus_rout*2+0.2]);
          }
        }
      //Left half = oblong torus    
      difference()
        {
        union()
          {
          //positive
          //Torus is main shape
          translate([0,lever,torus_rout+paddle_base_z])
            rotate(90,Y)
              scale([1,1.5,1])
                torus(outerRadius=torus_rout, innerRadius=torous_rin);
          }
        union()
          {
          //negative
          //Cut off right half of torus
          translate([-torus_thick/2-0.1,lever,paddle_base_z])
            cube([torus_thick+0.2,torus_rout*2+0.1,torus_rout*2+0.2]);
          }
        }
      }
    }
  //Top spoke
  translate([0,0,paddle_base_z+2])
    rotate(-54.82,X)  
      cylinder(r1=hub_radius-1.5,r2=torus_thick/2-0.2,h=lever-15);
  //Bottom spoke
  translate([0,14.3,paddle_base_z+11.5])
    rotate(-95.61,X)  
      cylinder(r1=hub_radius-4,r2=torus_thick/2-0.12,h=lever-33);
    
    
    
  }
//=======================================================================================
cylinder_top_radius=8;


module handle()
  {
  difference()
    {
    union()
      {
      //positive
      difference()
        {
        union()
          {
          //positive
          //Main hub body
          cylinder(r=hub_radius,h=hub_depth);
          }
        union()
          {
          //Main hub upper roundy
          translate([0,0,hub_depth-cylinder_top_radius])
            round_cylinder_cap(hub_radius,cylinder_top_radius);
          }
        }      
      paddle();
      }
    union()
      {
      //negative
      translate([0,0,-0.01])
        shaft_cut_out();
      //trim z < 0
      translate([0,0,-10])
        cube([100,100,20],center=true);  
      }
    }
  }



//=======================================================================================
//shaft_cut_out();
handle();


//=======================================================================================


































