//
//  adjusters for early BMW E39 (5-series) headlamps (none "angel-eye")
//
//  design by: egil kvaleberg, mar 2017

//

with_central_hole = false;

stem_width = 9.7;
stem_height = 24.0;
neck_dia = 6.2;
ball_height = 73.5;
ball1_offs = 6.5;
ball_dia = 8.1; // guess
guide_width = 16.0;
guide_thick = 2.0;
guide_a_offs = 2.7;
guide_b_offs = 9.5;

central_hole = 3.0;

adj_offs = 14.0;
adj_height = 11.0;
adj_minor = 4.65; // inner dia
adj_clearance = 6.0;

// BUG:
ball2_offs = 4.5;
guide2_offs = 1.0;
adj2_offs = 6.0;
stem2_height = 43.0;
ball2_height = 55.5;
top2_wall = 2.5;
slot2 = 3.0;

d = 1*0.1;

adj1();
translate([40,0,0]) adj2();

module add2() {
    translate([0, -stem_width/2, 0]) 
      cube([adj2_offs, stem_width, stem2_height]);
    difference () {
        translate([adj2_offs, 0, 0]) 
          cylinder(d=stem_width, h=stem2_height, $fn=64);
        translate([adj2_offs, -slot2/2, adj_height]) 
          cube([adj2_offs, slot2, stem2_height-adj_height-top2_wall]);
    }
    translate([ball2_offs, 0, stem2_height-d]) 
      cylinder(d1=stem_width, d2=neck_dia, h=ball2_height-ball_dia/2-stem2_height+d, $fn=32);
    translate([ball2_offs, 0, ball2_height-ball_dia/2]) 
      cylinder(d=neck_dia, h=ball_dia/2, $fn=32);
    translate([ball2_offs, 0, ball2_height]) 
      sphere(d=ball_dia, $fn=128);
    translate([guide2_offs-guide_thick/2, -guide_width/2, 0]) 
      cube([guide_thick, guide_width, stem2_height]);
}

module sub2() {
   translate([adj2_offs, 0, -d]) 
      cylinder(d=adj_minor, h=adj_height+3*d, $fn=64);
   translate([adj2_offs, 0, -d]) 
      cylinder(d1=adj_minor+4, d2=adj_minor, h=2, $fn=64);    
   translate([adj2_offs-(adj_minor+4)/2, -2/2, -d]) 
      cube([adj_minor+2, 2, adj_height+3*d]);
   translate([adj2_offs-2/2, -(adj_minor+2)/2, -d]) 
      cube([2, adj_minor+2, adj_height+3*d]);     
    
   translate([adj2_offs, 0, adj_height+d]) 
      cylinder(d=adj_clearance, h=stem2_height-top2_wall-adj_height, $fn=64);
       
   if (with_central_hole) translate([ball2_offs, 0, -d]) 
      cylinder(d=central_hole, h=ball2_height+ball_dia, $fn=64);
}

module add1() {
    translate([0, -stem_width/2, 0]) 
      cube([adj_offs, stem_width, stem_height]);
    translate([adj_offs, 0, 0]) 
      cylinder(d=stem_width, h=adj_height, $fn=64);
    translate([ball1_offs, 0, stem_height-d]) 
      cylinder(d1=stem_width, d2=neck_dia, h=ball_height-ball_dia/2-stem_height+d, $fn=32);
    translate([ball1_offs, 0, ball_height-ball_dia/2]) 
      cylinder(d=neck_dia, h=ball_dia/2, $fn=32);
    translate([ball1_offs, 0, ball_height]) 
      sphere(d=ball_dia, $fn=128);
    translate([guide_a_offs-guide_thick/2, -guide_width/2, 0]) 
      cube([guide_thick, guide_width, stem_height]);
    translate([guide_b_offs-guide_thick/2, -guide_width/2, 0]) 
      cube([guide_thick, guide_width, stem_height]);
}

module sub1() {
   translate([adj_offs, 0, -d]) 
      cylinder(d=adj_minor, h=adj_height+3*d, $fn=64);
   translate([adj_offs, 0, -d]) 
      cylinder(d1=adj_minor+4, d2=adj_minor, h=2, $fn=64);  
   translate([adj_offs-(adj_minor+4)/2, -2/2, -d]) 
      cube([adj_minor+2, 2, adj_height+3*d]);
   translate([adj_offs-2/2, -(adj_minor+2)/2, -d]) 
      cube([2, adj_minor+2, adj_height+3*d]); 
    
   translate([adj_offs, 0, adj_height+d]) 
      cylinder(d=adj_clearance, h=stem_height-adj_height, $fn=64);
    
   translate([stem_width/2, 0, -d]) 
      cylinder(d=stem_width-2*guide_thick, h=stem_height-guide_thick, $fn=64);
 
   if (with_central_hole) translate([ball1_offs, 0, -d]) 
      cylinder(d=central_hole, h=ball_height+ball_dia, $fn=64);
}

module adj1() {
    difference () {
        add1();
        sub1();
    }
}

module adj2() { 
    difference () {
        add2();
        sub2();
    }
}