phoneWidth=135;
phoneHeight=70;
phoneDepth=10;

edgeThickness=3;
clearance=1;
lip=5;

outWidth=phoneWidth + (2 * (edgeThickness + clearance));
outHeight=50;
outDepth=phoneDepth + (2 * (edgeThickness + clearance));
outRound=outDepth/2;

inWidth=phoneWidth + (2 * clearance);
inHeight=outHeight;
inDepth=phoneDepth + (2 * clearance);
inRound=inDepth/2;

hookWidth=95-2*8 +4; //+4 to make it tight 
hookDepth=7;
hookKnobR=2.5;
hookKnobSep=7.5;

blockForHoles=hookDepth-(outRound-inRound);

nfcTag=56;

module roundedBox() {
	// bit facing user is rounded
	bottom=outRound;
	left=outRound;
	top=outHeight-outRound;
	right=outWidth-outRound;

	hull() {
		translate([left, bottom, outRound]) sphere(outRound);
		translate([left, top, outRound]) sphere(outRound);
		translate([right, top, outRound]) sphere(outRound);
		translate([right, bottom, outRound]) sphere(outRound);

		translate([left, bottom, -outRound]) sphere(outRound);
		translate([left, top, -outRound]) sphere(outRound);
		translate([right, top, -outRound]) sphere(outRound);
		translate([right, bottom, -outRound]) sphere(outRound);
	}
}

module theOuter() {
	intersection() {
		roundedBox();
		translate([0, 0, -blockForHoles]) 
			cube([outWidth, outHeight, outDepth+blockForHoles]);
	};
}

module theBackBit(){
	// this is the holes for the adjustable angle bit
//	for(y = [40, 30, 20]) {
//		translate([-5, y, -1])
//			rotate([0, 90, 0])
//				cylinder(r=2, h=outWidth+10);
//	}




}

module hookGrip() {
	knobZ=hookDepth/2-blockForHoles;
	difference() {
		translate([(outWidth-hookWidth)/2, 0, -blockForHoles])
			cube([hookWidth, nfcTag, hookDepth]);

		for(y = [0:5]) {
			translate([(outWidth-hookWidth)/2, 15+(y*hookKnobSep), knobZ])
				sphere(hookKnobR);
			translate([(outWidth+hookWidth)/2, 15+(y*hookKnobSep), knobZ])
				sphere(hookKnobR);
		}
	}
}

module theInner() {

	// take away what we don't need at the back
	backBuffer=edgeThickness+lip+clearance;
	translate([backBuffer, backBuffer, -(outDepth/2)])
		cube([outWidth-2*backBuffer, max(outHeight, nfcTag), outDepth+2]);


//	translate([backBuffer, backBuffer, -(outDepth/2)])
//		cube([outWidth-2*backBuffer, outHeight, outDepth+2]);

	// take away what we don't need at the front
	frontBuffer=edgeThickness+(lip/2)+clearance;
	translate([frontBuffer, frontBuffer, outDepth/2])
		cube([outWidth-2*frontBuffer, outHeight, outDepth+2]);

	// take away the ridge where the phone will sit
	bottom=inRound + edgeThickness;
	left=inRound + edgeThickness;
	top=inHeight;
	right=edgeThickness + inWidth - inRound;
	
	hull() {
		translate([left, bottom, outRound]) sphere(inRound);
		translate([left, top, outRound]) sphere(inRound);
		translate([right, top, outRound]) sphere(inRound);
		translate([right, bottom, outRound]) sphere(inRound);
	}

}

module thePowerHole() {
	holeRound=2;
	translate([35, -5, outRound-inRound+holeRound])
		minkowski(){
			cube([20-(2*holeRound), edgeThickness + 10, phoneDepth-(2*holeRound)]);
			sphere(r=holeRound);
		}
}


module theHolder() {
	difference() {
		theOuter();
		theInner();
		thePowerHole();
		theBackBit();
	}
	hookGrip();
}


rotate([0, 0, 45])
	theHolder();



