wedgeX=75;
wedgeY=95;
wedgeZ=8;

halfZ = wedgeZ / 2;

bezel=3;


module wedge() {
	trimmedX=wedgeX - (2 * bezel);
	trimmedY=wedgeY - (2 * bezel);
	trimmedZ=wedgeZ - (2 * bezel);

	difference() {
		cube([trimmedX, trimmedY, trimmedZ]);
		
		translate([0, trimmedY / 2 + 2, -5])
			rotate([0, 0, 45])
				cube([100, 100, 100]);
	
		translate([0, trimmedY / 2 - 2, -5])
			rotate([0, 0, -135])
				cube([100, 100, 100]);
	}
}

module inWedge() {
	translate([wedgeZ - (2 * bezel), 0, 0])
		intersection() {
			wedge();
			translate([0, wedgeZ - (2 * bezel), 0])
				cube([wedgeX, wedgeY - (2 * wedgeZ) + (2 * bezel), wedgeZ]);
		}
}

module outWedge() {
	translate([bezel, bezel, bezel])
		difference() {
			wedge();			
			inWedge();
		}
}

module completedWedge() {
	difference() {
		minkowski() {
			outWedge();
			sphere(r=bezel);
		}

// old code when I used a spike
//		translate([wedgeX - halfZ, -5, halfZ])
//			rotate([-90, 0, 0])
//				cylinder(r=2, h=wedgeY + 10);

		translate([wedgeX - halfZ, -2, 0]) cube([halfZ, wedgeY + 4, halfZ]);
	}
}

module roundCube(size) {
	offset = size / 2 - bezel;
	translate([0, -(bezel - size / 2), 0])
	minkowski() {
		//cube(size - (2 * bezel));
		rotate([90, 0, 0])
		cylinder(r=(size - (2 * bezel)) / 2, h=size - (2 * bezel));
		sphere(r=bezel);
	}
}

//roundCube(10);

module hook() {
	hull() {
		translate([halfZ, wedgeY / 2, halfZ])
			roundCube(wedgeZ);

		translate([halfZ, wedgeY / 2, halfZ + 10])
			roundCube(wedgeZ);
	}

	split = 7;
	hull() {
		translate([halfZ, wedgeY / 2, halfZ + 10])
			roundCube(wedgeZ);

		translate([halfZ + 3, (wedgeY - split) / 2, halfZ + 15])
			roundCube(wedgeZ);

		translate([halfZ + 3, (wedgeY + split) / 2, halfZ + 15])
			roundCube(wedgeZ);
	}
	hull() {
		translate([halfZ + 3, (wedgeY - split) / 2, halfZ + 15])
			roundCube(wedgeZ);

		translate([halfZ + 3, (wedgeY + split) / 2, halfZ + 15])
			roundCube(wedgeZ);

		translate([halfZ + 8, wedgeY / 2 - split, halfZ + 20])
			roundCube(wedgeZ);

		translate([halfZ + 8, wedgeY / 2 + split, halfZ + 20])
			roundCube(wedgeZ);
	}
}

module baseAttach() {
	knobApart = 7.5;
	knobR = 2.5;
	knobCnt=2; //zero based, ie 2 means 0, 1, 2 so 3 knobs

	baseAngle=60;

	xDiff=cos(baseAngle)*knobApart;
	zDiff=sin(baseAngle)*knobApart;

	// angled jut
	hull() {
		translate([wedgeX - halfZ, wedgeY - halfZ, halfZ])
			roundCube(wedgeZ);

		translate([wedgeX - halfZ + knobCnt*xDiff, wedgeY - halfZ, halfZ + knobCnt*zDiff])
			roundCube(wedgeZ);
	}

	hull() {
		translate([wedgeX - halfZ, halfZ, halfZ])
			roundCube(wedgeZ);

		translate([wedgeX - halfZ + knobCnt*xDiff, halfZ, halfZ + knobCnt*zDiff])
			roundCube(wedgeZ);
	}

	// knobs
	for(i = [0:knobCnt]) {
		translate([wedgeX - halfZ + i*xDiff, wedgeY - wedgeZ, halfZ + i*zDiff])
			sphere(knobR);
		translate([wedgeX - halfZ + i*xDiff, wedgeZ, halfZ + i*zDiff])
			sphere(knobR);
	}



}

completedWedge();
hook();
baseAttach();




