// seat bar
bx1 = 47.14;
bx2 = bx1 - 12.53;

by1 = 12.3;
by2 = 15.3;

bz = 3;

// corner radius
cr = 3;

// part thickness
th1 = 2;
th2 = 3;
dth1 = th1 * 2;
dth2 = th2 * 2;

// square hole
hx = 38.14 - 29.6;
hy = (by2 / 3) + 2;

// layer one, proximal
module layer1()
{
    lx1 = bx1 + th2;
    lx2 = bx2 + th2;
    
    ly1 = by2 + dth2;
    ly2 = by1 + dth2;
    difference()
    {
        union()
        {
            cube([lx2, ly1, th1]);
            translate([0, ly1 - ly2, 0])
            {
                cube([lx1, ly2, th1]);
            }
        }
        union()
        {
            translate([-1, (ly1 - hy)/2, -1])
                cube([hx + (bx1 - 30.6) + 1, hy, th1 + 2]);
        }
    }
}

// layew with the slot for the bar
module layer2()
{
    translate([0, 0, th1])
    {
        difference()
        {
            union()
            {
                cube([bx2 + th2, th2, bz]);
                translate([(bx1 + th2) - 6.19, (by2 - by1), 0])
                    cube([6.19, th2, bz]);
                translate([bx1, (by2 - by1), 0])
                    cube([th2, by1 + dth2, bz]);
                translate([0, by2 + th2, 0])
                    cube([bx1 + th2, th2, bz]);
            }
            union()
            {
            }
        }
       
        // supports 
        /*g = 0.2;
        translate([0, 0, g])
        {
            translate([0, th2 + th2 + g, 0])
                    cube([bx1 - g, by1 - (g * 2), bz - (g * 2)]);
            translate([0, th2 + g, 0])
                    cube([bx2 - g, by2 - (g * 2), bz - (g * 2)]);
        }*/
        
        
        
        
        
    }
}

module layer3()
{
    lx1 = bx1 + th2;
    lx2 = bx2 + th2;
    
    ly1 = by2 + dth2;
    ly2 = by1 + dth2;
    translate([0, 0, th1 + bz])
    difference()
    {
        union()
        {
            cube([lx2, ly1, th1]);
            translate([0, ly1 - ly2, 0])
            {
                cube([lx1, ly2, th1]);
            }
        }
        union()
        {
        }
    }   
}


module bla()
{
    difference()
    {
        union()
        {
        }
        union()
        {
        }
    }   
}

layer1();
layer2();
layer3();

// add a handle
hdx = 80;
hdy = 10;
hdz = 25;
translate([0, by2 + dth2, 0])
{
    difference()
    {
        union()
        {
            cube([hdx, hdy, hdz]);
        }
        union()
        {
        }
    } 
}


