use <Triangles.scad>;
l=40.5;           //length
w=26.5;           //width
h=16.5;           //height
cr=5;           //corner radius;
lcr=250;        //length curve radius
lcz=-233;       //face curve z offset
lcx=60;         //face curve x offset
lcy=-7;			//face curve y offset
wall=2;

cd=17;			//clip depth

/*
#translate ([0, w, 0]) cube (size = [1, 1, 8 + cd]);			// reference for height
#translate ([0, -1, 0]) cube (size = [1, 1, 10 + cd]);			// reference for height
#translate ([l, -1, 0]) cube (size = [1, 1, h + cd]);			// reference for height
#translate ([l, w, 0]) cube (size = [1, 1, 14 + cd]);			// reference for height
*/
difference() { 
	translate ([0,0,cd])face(l,w,h,lcr,lcx,lcy,lcz,300,cr,100);
	translate ([2.5,wall,cd])resize (newsize = [35, w-wall*2, h-wall])face(l,w,h,lcr,lcx,lcy,lcz,100,cr,100);
	*translate ([l/2, w/2, 0]) cylinder(h+cd,6,6,$fn=100);		//hole cutout for cables etc
}
translate ([0,0,0])clips();

module face(l,w,h,sr,sx,sy,sz,sfn,cr,cfn){
    intersection(){
        roundedCube([l,w,h],cr,$fn=cfn);
        translate([sx,sy,sz])rotate([-90,0,0])sphere(sr,$fn=sfn);
    }
}

module clips(){

	cl=38;		//clip length
	cw=10;		//clip width
	wall=1.5;	//wall thickness
	csw=15;		//clip support width
	csh=8;		//clip support height
	cg=0.5;		//cut gap
	hd=5;		//hook depth

	x=1;		//x offset
	y=(w-cw)/2;
	csy=(cw-csw)/2;
	csz=(cd-csh);

	
	translate ([x, y, 0]) {
		
		difference() { 
			union () { 
				cube (size = [wall,cw,cd]);
				translate ([0, csy, csz]) cube (size = [wall, csw, csh]);
				translate ([cl-wall, 0, 0]) cube (size = [wall,cw,cd]);
				translate ([cl-wall, csy, csz]) cube (size = [wall, csw, csh]);
				hl=cw;																//hook length
				translate ([0, cw/2, hd]) rotate (a = [0, -180, 0]) Wedge(hd,hd/2,hl,hl);		//hook
				translate ([cl, cw/2, hd]) rotate (a = [180, 0, 0]) Wedge(hd,hd/2,hl,hl);			//hook
			}
			*translate([wall,wall,0])cube (size = [cl-(2*wall),cw-(2*wall),cd]);					//inside cutout
			*translate ([0,wall,0])cube (size = [cl, cg, cd]);										//side cutout
			*translate ([0,cw-(wall+cg),0])cube (size = [cl, cg, cd]);								//side cutout
		}
	}
	
}


module roundedCube(size, r)
{
	x = size[0];
	y = size[1];
	z = size[2];

    hull(){
        translate([r, r, 0]) cylinder(z,r, r);
        translate([x-r, r, 0]) cylinder(z,r, r);
        translate([r, y-r, 0]) cylinder(z,r, r);
        translate([x-r, y-r, 0]) cylinder(z,r, r);
		
    }
}
