celkova_vyska=25.08;
sirka_vicka=67.8;
sirka=88;
sirka_diry=65; //70.17 - skutecna
sirka_zavitu=74.79;
vrsek_vycka=13.59;
spodni_stena=5;

vyska_zubu=5;
sirka_zubu=4;
delka_zubu=9;

difference(){
    union(){
        telo();
        vycko();
        na_prsty();
        zuby();
    };
    dira();
}

module zuby(){
  for(i=[1:4]){
    rotate([0,0,i*90]){
            translate([(sirka_zavitu+sirka_zubu)/2,-5,celkova_vyska-vyska_zubu])
                rotate([0,0,90])
                    zub(delka_zubu,sirka_zubu,vyska_zubu);
        }
    }
}

module zub(w,h,d){
    difference(){
        cube([w,h,d]);
        translate([w*0.3,-0.1,0])
        rotate([0,55,0]){
            cube([w,h+0.2,d*2]);
        }
    }
}  
    
module vycko(){
    cylinder(d1=sirka_vicka, d2=sirka, h=vrsek_vycka, $fn=300);
}

module na_prsty() {
    translate([0,0,-2])
    for(i=[0:9]){
       rotate([90,0,(i*45)]){
            alternative_square((sirka*0.5), vrsek_vycka, 3); 
       }
    }
}
module alternative_square( width, height, r_c ) {
	hull() {
		translate( [r_c, r_c, 0] ) cylinder( r_c );
		translate( [r_c, height - r_c, 0 ] ) cylinder( r_c, $fn=50 );
		translate( [width - r_c, r_c, 0] ) cylinder( r_c );
		translate( [width - r_c, height - r_c, 0] ) cylinder( r_c,  $fn=50 );
	}
}

module telo(){
    cylinder(d=sirka_zavitu, h=celkova_vyska, $fn=300);
}

module dira(){
    translate([0, 0, spodni_stena]){
        cylinder(d=sirka_diry, h=celkova_vyska, $fn=300);
    }
}