
// Width of Tray (mm)
breite=153; // [100:200]
// Length of insert (mm)
laenge=120; // [100:150]
// Depth of insert (mm)
tiefe=40;   // [30:100]
// Thickness of wall (mm)
thick=2.1;  // [1.2:3.0]

halter_l=20+0;
halter_w=8+0;
halter_d=1.2+0;

// Box
difference(){
    roundedCube([laenge,breite,tiefe],4);    
    translate([thick,thick,thick+1])
        roundedCube([laenge-2*thick,breite-2*thick,tiefe-thick],4);
}

// Halter
translate([halter_l,-halter_w+thick,tiefe-halter_d])
    cube([halter_l,halter_w,halter_d]);
translate([laenge-2*halter_l,-halter_w+thick,tiefe-halter_d])
    cube([halter_l,halter_w,halter_d]); 
translate([halter_l,breite-thick,tiefe-halter_d])
    cube([halter_l,halter_w,halter_d]);
translate([laenge-2*halter_l,breite-thick,tiefe-halter_d])
    cube([halter_l,halter_w,halter_d]);
    
// Teiler

translate([0,breite/3,0])
    cube([laenge,2*thick,3*tiefe/4]);

/*
    cube mit gerundeten Ecken.
    Parameter: Aussenmasse, Radius der Eckenrundungen.
*/
module roundedCube(size, radius,steps=50)
{
    x = size[0];
    y = size[1];
    z = size[2];
    linear_extrude(height=z)
        hull(){
            translate([radius, radius, 0])
            circle(r=radius,$fn=steps);

            translate([x-radius, radius, 0])
            circle(r=radius, $fn=steps);

            translate([x-radius, y-radius, 0])
            circle(r=radius,$fn=steps);

            translate([radius, y-radius, 0])
            circle(r=radius,$fn=steps);
            
        }

}