


/*
// Coordinates of top (Sloped)
FLX=0 ; FLY=0 ;
FRX=175 ; FRY=0 ;
RLX=-8 ; RLY=148 ;
RRX=178 ; RRY=154 ;
*/

// What to produce
WHAT="base" ; // [base,strap,guard]

// Coordinates of top (Flat)
FLX=0 ; FLY=-0.5 ;
FRX=182 ; FRY=0.5 ;
RLX=-10 ; RLY=154 ;
RRX=176.5 ; RRY=163 ;

// Lip Depth and Height
LD=2 ;
LH=1 ;

// Curve indent front centre
FCY=3 ;
FCO=-3 ;

// Radius of top
TCR=5 ;

// Top Thickness
TT=8 ;

// Charger Cutout Top Thickness
CT=0.75 ;

// Socket Cutout Top Thickness
ST=1.5 ;

// Charger Type
TYPE="square" ; // [circle,square]

// Right Margin (between Charger and Edge)
RM=4 ;

// Phone Width
PW=70 ;

// Phone Height
PH=144 ;

// Charger Circular Diameter
CD=70 ;

// Charger Square Width
CW=88 ;

// Charger Square Height
CH=83.2 ;

// Length of legs (base height)
BH=30 ;

// Bast Tolerances
TOL=2 ;

// Offsets of legs at height BH
BFLX=26/5+TOL ; BFLY=83/5+TOL ;
BFRX=-40/5-TOL ; BFRY=90/4+TOL ;
BRLX=32.5/5+TOL ; BRLY=-79.5/5-TOL ;
BRRX=-23/5-2-TOL ; BRRY=-71/5-2-TOL ;

// Leg Widths
LW1=15 ;
LW2=20 ;
LW3=30 ;

// Radius of base
BCR=3 ;

// Thread Diameter
THR=2.7 ;

// Screw Thread Len
STL=10 ;

// Thread X Gap
TX=50 ;

// Thread Y Gap
TY=100 ;

// Near Zero and resolution
NZ=0.0001 ;
RES=25 ;

  // Width and height of charger recess    
  cw = (TYPE=="square") ? CW : 0.001 ;
  ch = (TYPE=="square") ? CH : 0.001 ;
  cd = (TYPE=="circle") ? CD : 0.001 ;
  x = FRX-(FRX-RRX)/2 ;
  ccx = (cw+cd)/2 ;
      
  // Screw Positions 
  txo=5 ;  
  t1x=x-ccx+txo ; t1y=FRY+PH/2-TY/2 ;
  t2x=x-ccx-TX/2+txo ; t2y=FRY+PH/2+TY/2 ;
  t3x=x-ccx+TX/2+txo ; t3y=FRY+PH/2+TY/2 ;

  // Charger Well Rotation Angle (wrt Front)
  cwra = atan((FRY-FLY)/(FRX-FLX)) ;
  
  // Right Hand Edge Rotation Angle
  rhea = 90+atan((RRY-FRY)/(RRX-FRX)) ;
  

if (WHAT=="guard") {
    ga=1.5 ;
    gb=1 ;
    gc=0.4 ;
    hb=1.5 ;
    l=50 ;
    difference() {

      hull() {
        cylinder(r=ga,h=1,$fn=RES) ;
        translate([l,0,0]) cylinder(r=ga,h=1,$fn=RES) ;
        translate([0,0,hb]) sphere(r=gb,$fn=RES) ;
        translate([l-gb/2,0,hb]) sphere(r=gb,$fn=RES) ;
      }
      
      hull() {
        sphere(r=gc,$fn=RES) ;
        translate([l,0,0]) sphere(r=gc,$fn=RES) ;
      }      
  }

  }
  
if (WHAT=="strap") {

 difference() {

  tp=THR*3 ;

  union() {
      
   // Thread Posts
   translate([t1x,t1y,0]) cylinder(r=tp/2,h=2,$fn=RES) ;
   translate([t2x,t2y,0]) cylinder(r=tp/2,h=2,$fn=RES) ;
   translate([t3x,t3y,0]) cylinder(r=tp/2,h=2,$fn=RES) ;

   hull() {
     translate([t1x,t1y,0]) cylinder(r=tp/2,h=1,$fn=RES) ;
     translate([t2x,t2y,0]) cylinder(r=tp/2,h=1,$fn=RES) ;
   }
   hull() {
     translate([t1x,t1y,0]) cylinder(r=tp/2,h=1,$fn=RES) ;
     translate([t3x,t3y,0]) cylinder(r=tp/2,h=1,$fn=RES) ;
   }
   hull() {
     translate([t3x,t3y,0]) cylinder(r=tp/2,h=1,$fn=RES) ;
     translate([t2x,t2y,0]) cylinder(r=tp/2,h=1,$fn=RES) ;
   }

  }
  union() {

   translate([t1x,t1y,0]) cylinder(r=THR/1.8,h=3,$fn=RES) ;
   translate([t2x,t2y,0]) cylinder(r=THR/1.8,h=3,$fn=RES) ;
   translate([t3x,t3y,0]) cylinder(r=THR/1.8,h=3,$fn=RES) ;
    
  }
  
  }
  
}

if (WHAT=="base") difference() {
  
 union() {
     
   // Thread Posts
   tp=THR*3 ;
   translate([t1x,t1y,-STL]) cylinder(r=tp/2,h=STL,$fn=RES) ;
   translate([t2x,t2y,-STL]) cylinder(r=tp/2,h=STL,$fn=RES) ;
   translate([t3x,t3y,-STL]) cylinder(r=tp/2,h=STL,$fn=RES) ;

   /* Main Body Start */    
   difference() { 
       
     union() { 

       // Main Body Top 
       hull() {
         translate([FLX+TCR,FLY+TCR,-LH]) 
           cylinder(r=TCR,h=LH,$fn=RES) ;
         translate([FRX-TCR,FRY+TCR,-LH]) 
           cylinder(r=TCR,h=LH,$fn=RES) ;
         translate([RLX+TCR,RLY-TCR,-LH]) 
           cylinder(r=TCR,h=LH,$fn=RES) ;
         translate([RRX-TCR,RRY-TCR,-LH]) 
           cylinder(r=TCR,h=LH,$fn=RES) ;
       }
       
       // Main Body Block
       translate([0,0,-NZ]) hull() {   
         translate([FLX+TCR+LD,FLY+TCR+LD,0]) 
           cylinder(r=TCR,h=NZ,$fn=RES) ;
         translate([FRX-TCR-LD,FRY+TCR+LD,0]) 
           cylinder(r=TCR,h=NZ,$fn=RES) ;
         translate([RLX+TCR+LD,RLY-TCR-LD,0]) 
           cylinder(r=TCR,h=NZ,$fn=RES) ;
         translate([RRX-TCR-LD,RRY-TCR-LD,0]) 
           cylinder(r=TCR,h=NZ,$fn=RES) ;
          
         translate([FLX+BFLX+BCR,FLY+BFLY+BCR,-BH+BCR]) 
           sphere(r=BCR,$fn=RES) ;
         translate([FRX+BFRX-BCR,FRY+BFRY+BCR,-BH+BCR]) 
           sphere(r=BCR,$fn=RES) ;
         translate([RLX+BRLX+BCR,RLY+BRLY-BCR,-BH+BCR]) 
           sphere(r=BCR,$fn=RES) ;
         translate([RRX+BRRX-BCR,RRY+BRRY-BCR,-BH+BCR]) 
           sphere(r=BCR,$fn=RES) ;
       }
 
     }      
     
     // Front Cutout   
     translate([FLX+LW2,FLY,-BH]) 
       cube([FRX-FLX-LW2-LW2,100,BH-TT]) ;
     // Rear Cutout
     translate([RLX+LW1,RLY-100,-BH]) 
       cube([RRX-RLX-LW1-LW1,150,BH-TT]) ;
     // Left Cutout
     translate([FLX-100,FLY+LW3,-BH]) 
       cube([150,RLY-FLY-LW3-LW3,BH-TT]) ;
     // Right Cutout
     translate([FRX-100,FRY+LW3,-BH]) 
       cube([150,RRY-FRY-LW3-LW3,BH-TT]) ;
   }  
  }
  /* Main Body End */
  
  
  // Subtractive
  union() {
  
    // Charger Well
    translate([x-ccx,FRY+PH/2,-BH]) 
      rotate([0,0,cwra]) {
        cylinder(r=cd/2,h=BH-CT,$fn=RES) ;
        translate([-cw/2,-ch/2,0]) cube([cw+RM,ch,BH-CT]) ;
        translate([-ccx-40,-10,0]) cube([50,20,BH-ST]) ;
    }

    // Right Hand Edge led cutout
    translate([x-ccx,FRY+PH/2,-BH]) 
      rotate([0,0,rhea]) {
        translate([cw/2+0.5,0,0]) 
          scale([1,10,1]) cylinder(r=1,h=100,$fn=RES) ;
      }
    
    // Door Flap Cutout
    translate([RLX+LW1,RLY-50,-BH])
      cube([50,100,BH-ST]) ;
    
    // Cable Cutout
    translate([RLX+LW1+2.5,RLY,-BH]) 
      cylinder(r=2.5,h=BH+NZ,$fn=RES) ;
     
    // Threads    
    translate([t1x,t1y,-STL]) screw(THR,STL-ST) ;
    translate([t2x,t2y,-STL]) screw(THR,STL-ST) ;
    translate([t3x,t3y,-STL]) screw(THR,STL-ST) ;
  
         
    // Front Curve Cutout
    fcentrex=(FRX-FLX)/2 ;
    fcentrey=(FRY-FLY)/2 ;
    ewidth=(FRX-FLX)*1.1 ;
    edepth=FCY ;
    hdepth=edepth+(BFLX+BFLY)/2 ;    

    translate([fcentrex,fcentrey+FCO,-50])
       rotate([0,0,cwra]) {
         union() {
          arc(ewidth,edepth,50.1) ;
          translate([-100,-100,0]) cube([200,100+edepth/2,50.1]) ;
         }
       }
  
/*
    // Centre Cutout
    translate([30,15,-30]) cube([130,120,50]) ;
    translate([15,15,-30]) cube([145,85,50]) ;
*/
    
  }
}

module screw(thread,height)
{
    translate([0,0,-0.001]) {
      cylinder(r=thread/2,h=height,$fn=RES) ;
      hull() {
        cylinder(r=0.5+thread/2,h=0.001,$fn=RES) ;
        translate([0,0,0.8]) cylinder(r=thread/2,h=0.001,$fn=RES) ;
      }
    }      
}

//
// Arc
//
// length=length of chord
// depth=depth of arc
// height=height of piece
// factor = shape factor 

module arc(length,depth,height)
{
  // c^2 = a^2 + b^2
  // x^2/a^2 + y^2/b^2 = 1
  // a = b*factor
  // c = length/2
  // x=c ;
  // y=b-h ;
    
  c=length/2 ;
  h=depth ;
  n= length/(4*depth) ;
    
  b = (c*c)/(2*n*n*h) + h/2 ;
  a = b*n ;
  y = b-h ;
    
  echo ("a=", a, "b=", b, "y=", y) ;
    
  difference() {
    translate([0,-y,0]) 
      scale([2*a,2*b,height]) 
        cylinder(r=0.5,h=1,$fn=80) ;
      
    translate([-a,-b-y,0]) 
      cube([2*a,b+y,height]) ;
  }  
}
