// Customizable American License plate for Costumes
// By Mark Kotsamanes

/*
An almost unlimited number of preset combinations (100,000+)

Mix and match State, Slogan and Background Details for 50 States and 6 Districts.
Plus your own text in the Header, Footer and Custom Plate Number

Do you want Alaska to be the Sunshine State with a Bucking Bronco on it I'm not going to stop you and neither is this app.

Use the Postal Abbreviation (CAPITALS) to select the State, Slogan and Background, invalid selections (or boring states like Virginia) will show nothing.

I am not American and my list and images came from Wikipedia and Google Image search I am very sorry if I made a mistake (or missed something). Also there is only so much that is possible some of the plates have been simplified due to available resolution.

This is part of a car costume (http://www.thingiverse.com/thing:1770501) and the default size is 120mm x 50mm.

I used a sharpie marker to colour the letters and background.

I used Inkscape and a plugin called paths2openscad (http://www.thingiverse.com/thing:25036) to convert a blank plate (jpg) to an SCAD file then added the text. It should be easy to duplicate it for another province or state.
*/

//State, use Postal Abriviation in CAPITALS
State="WA"; //[BLANK,AK,AL,AR,AS,AZ,CA,CO,CT,DC,DE,FL,GA,GU,HI,IA,ID,IL,IN,KS,KY,LA,MA,MD,ME,MI,MN,MO,MP,MS,MT,NC,ND,NE,NH,NJ,NM,NV,NY,OH,OK,OR,PA,PR,RI,SC,SD,TN,TX,UT,VA,VI,VT,WA,WI,WV,WY]
//State Slogan, use Postal Abriviation in CAPITALS
Slogan="WA"; //[BLANK,AK,AL,AR,AS,AZ,CA,CO,CT,DC,DE,FL,GA,GU,HI,IA,ID,IL,IN,KS,KY,LA,MA,MD,ME,MI,MN,MO,MP,MS,MT,NC,ND,NE,NH,NJ,NM,NV,NY,OH,OK,OR,PA,PR,RI,SC,SD,TN,TX,UT,VA,VI,VT,WA,WI,WV,WY]
//Plate Background, use Postal Abriviation in CAPITALS
Back="WA"; //[BLANK,AK,AL,AR,AS,AZ,CA,CO,CT,DC,DE,FL,GA,GU,HI,IA,ID,IL,IN,KS,KY,LA,MA,MD,ME,MI,MN,MO,MP,MS,MT,NC,ND,NE,NH,NJ,NM,NV,NY,OH,OK,OR,PA,PR,RI,SC,SD,TN,TX,UT,VA,VI,VT,WA,WI,WV,WY]
//License Plate Number/Text
PlateText="H4NSOLO";
PlateFont="Arial Black";
PlateHeight=25;
PlateSquish=.7;
//Header Text
HeadText="";
HeadFont="Arial Black";
HeadSize=10;
HeadSquish=1;
HeadLocation=24;
//Footer Text
FootText="";
FootFont="Arial Black";
FootSize=6;
FootSquish=1;
FootLocation=27;
//Select which holes to include Use a 1=show or 0=hide
TopRight=1; //[0,1]
TopLeft=1; //[0,1]
BottomRight=1; //[0,1]
BottomLeft=1; //[0,1]

fudge = 0.1;

/*
AK………Alaska
AL………Alabama
AR………Arkansas
AS………American Samoa
AZ………Arizona
CA………California
CO………Colorado
CT………Connecticut
DC………District of Columbia
DE………Delaware
FL………Florida
GA………Georgia
GU………Guam
HI………Hawaii
IA………Iowa
ID………Idaho
IL………Illinois
IN………Indiana
KS………Kansas
KY………Kentucky
LA………Louisiana
MA………Massachusetts
MD………Maryland
ME………Maine
MI………Michigan
MN………Minnesota
MO………Missouri
MP………Northern Mariana Islands
MS………Mississippi
MT………Montana
NC………North Carolina
ND………North Dakota
NE………Nebraska
NH………New Hampshire
NJ………New Jersey
NM………New Mexico
NV………Nevada
NY………New York
OH………Ohio
OK………Oklahoma
OR………Oregon
PA………Pennsylvania
PR………Puerto Rico
RI………Rhode Island
SC………South Carolina
SD………South Dakota
TN………Tennessee
TX………Texas
UT………Utah
VA………Virginia
VI………Virgin Islands
VT………Vermont
WA………Washington
WI………Wisconsin
WV………West Virginia
WY………Wyoming
*/

module PlateOutline (){
    color("grey"){
        difference(){
            translate([-60,-25,0]){
                minkowski(){
                    cube([120,50,1]);
                    cylinder(r=10,h=1);
                }
            }
            union(){
                if(TopRight==1)translate([-50,25,0])cylinder(d=5,h=10,center=true);
                if(BottomRight==1)translate([-50,-25,0])cylinder(d=5,h=10,center=true);
                if(TopLeft==1)translate([50,25,0])cylinder(d=5,h=10,center=true);
                if(BottomLeft==1)translate([50,-25,0])cylinder(d=5,h=10,center=true);
            }
        }
    }
}


PlateOutline();

// Custom Plate Number
linear_extrude(height=4)scale([PlateSquish,1,1])text(PlateText,font=PlateFont,valign="center",halign="center",size=PlateHeight);
// Custom Plate Header
translate([0,HeadLocation,0])linear_extrude(height=4)scale([HeadSquish,1,1])text(HeadText,font=HeadFont,valign="center",halign="center",size=HeadSize);
// Custom Plate Foother
translate([0,-FootLocation,0])linear_extrude(height=4)scale([FootSquish,1,1])text(FootText,font=FootFont,valign="center",halign="center",size=FootSize);

// Place State
color("green"){
if(State=="AK")translate([0,25,0])scale([.5,.5,1])AK_Stat(4);
if(State=="AL")translate([0,-23.5,0])scale([.33,.33,1])AL_Stat(4);
if(State=="AR")translate([0,22,0])scale([.47,.47,1])AR_Stat(4);
if(State=="AS")translate([8,-26.5,0])scale([.49,.49,1])AS_Stat(4);
if(State=="AZ")translate([0,27.5,0])scale([.4,.4,1])AZ_Stat(4);
if(State=="CA")translate([0,22,0])scale([.35,.35,1])CA_Stat(4);
if(State=="CO")translate([0,-25.5,0])scale([.4,.4,1])CO_Stat(4);
if(State=="CT")translate([0,23.25,0])scale([.4,.4,1])CT_Stat(4);
if(State=="DC")translate([0,25,0])scale([.4,.4,1])DC_Stat(4);
if(State=="DE")translate([0,-27.5,0])scale([.45,.45,1])DE_Stat(4);
if(State=="FL")translate([0,24.5,0])scale([.5,.5,1])FL_Stat(4);
if(State=="GA")translate([18.25,23,0])scale([.35,.35,1])GA_Stat(4);
if(State=="GU")translate([0,24,0])scale([.33,.33,1])GU_Stat(4);
if(State=="HI")translate([0,26,0])scale([.45,.45,1])HI_Stat(4);
if(State=="IA")translate([0,21,0])scale([.4,.4,1])IA_Stat(4);
if(State=="ID")translate([-15,24,0])scale([.4,.4,1])ID_Stat(4);
if(State=="IL")translate([0,24,0])scale([.42,.42,1])IL_Stat(4);
if(State=="IN")translate([0,24,0])scale([.42,.42,1])IN1(4);
if(State=="KS")translate([0,26,0])scale([.42,.42,1])KS1(4);
if(State=="KY")translate([0,23,0])scale([.42,.42,1])KY1(4);
if(State=="LA")translate([0,26,0])scale([.42,.42,1])LA1(4);
if(State=="MA")translate([0,26,0])scale([.42,.42,1])MA1(4);
if(State=="MD")translate([0,25,0])scale([.42,.42,1])MD1(4);
if(State=="ME")translate([0,25,0])scale([.4,.4,1])ME1(4);
if(State=="MI")translate([1,27,0])scale([.4,.4,1])MI1(4);
if(State=="MN")translate([-13,25,0])scale([.4,.4,1])MN1(4);
if(State=="MO")translate([0,27,0])scale([.5,.5,1])MO1(4);
if(State=="MP")translate([4,-25,0])scale([.55,.55,1])MP1(4);
if(State=="MS")translate([0,24.5,0])scale([.55,.55,1])MS1(4);
if(State=="MT")translate([-28,26.75,0])scale([.5,.5,1])MT1(4);
if(State=="NC")translate([0,-24,0])scale([.5,.5,1])NC1(4);
if(State=="ND")translate([0,26,0])scale([.5,.5,1])ND1(4);
if(State=="NE")translate([-9.5,22.5,0])scale([.5,.5,1])NE1(4);
if(State=="NH")translate([0,-22.5,0])scale([.5,.5,1])NH1(4);
if(State=="NJ")translate([0,23,0])scale([.5,.5,1])NJ1(4);
if(State=="NM")translate([0,-22,0])scale([.55,.55,1])NM1(4);
if(State=="NV")translate([0.5,25,0])scale([.5,.5,1])NV1(4);
if(State=="NY")translate([0,23,0])scale([.48,.48,1])NY1(4);
if(State=="OH")translate([0,28,0])scale([.5,.5,1])OH1(4);
if(State=="OK")translate([6,24,0])scale([.53,.53,1])OK1(4);
if(State=="OR")translate([0,25.5,0])scale([.5,.5,1])OR1(4);
if(State=="PA")translate([0,25.5,0])scale([.5,.5,1])PA1(4);
if(State=="PR")translate([0,25.5,0])scale([.5,.5,1])PR1(4);
if(State=="RI")translate([0,25.5,0])scale([.45,.45,1])RI1(4);
if(State=="SC")translate([0,-23,0])scale([.5,.5,1])SC1(4);
if(State=="SD")translate([0,24,0])scale([.55,.55,1])SD1(4);
if(State=="TN")translate([0,24,0])scale([.55,.55,1])TN1(4);
if(State=="TX")translate([0,25,0])scale([.5,.5,1])TX1(4);
if(State=="UT")translate([0,25,0])scale([.5,.5,1])UT1(4);
if(State=="VA")translate([0,25,0])scale([.5,.5,1])VA(4);
if(State=="VI")translate([0,25,0])scale([.5,.5,1])VI1(4);
if(State=="VT")translate([0,28,0])scale([.5,.5,1])VT1(4);
if(State=="WA")translate([-23,21,0])scale([.52,.52,1])WA1(4);
if(State=="WI")translate([-26.5,26.5,0])scale([.5,.5,1])WI1(4);
if(State=="WV")translate([0,24,0])scale([.5,.5,1])WV1(4);
if(State=="WY")translate([0,-26,0])scale([.55,.55,1])WY1(4);
}
// Place Slogan
color("blue"){
if(Slogan=="AK")translate([0,-28,0])scale([.5,.5,1])AK_Slog(4);
if(Slogan=="AL")translate([0,27.5,0])scale([.33,.33,1])AL_Slog(4);
if(Slogan=="AR")translate([0,-28,0])scale([.47,.47,1])AR_Slog(4);
if(Slogan=="AS")translate([11,26.5,0])scale([.52,.52,1])AS_Slog(4);
if(Slogan=="AZ")translate([31,-16.5,0])scale([.4,.4,1])AZ_Slog(4);
if(Slogan=="CA")translate([-2,-29,0])scale([.35,.35,1])CA_Slog(4);
if(Slogan=="CT")translate([0,-25,0])scale([.4,.4,1])CT_Slog(4);
if(Slogan=="DC")translate([0,-25,0])scale([.4,.4,1])DC_Slog(4);
if(Slogan=="DE")translate([0,28,0])scale([.45,.45,1])DE_Slog(4);
if(Slogan=="FL")translate([0,-28,0])scale([.5,.5,1])FL_Slog(4);
if(Slogan=="GA")translate([-29.5,22,0])scale([.35,.35,1])GA_Slog(4);
if(Slogan=="GU")translate([0,-26,0])scale([.33,.33,1])GU_Slog(4);
if(Slogan=="HI")translate([0,-26.5,0])scale([.45,.45,1])HI_Slog(4);
if(Slogan=="ID")translate([0,-26,0])scale([.4,.4,1])ID_Slog(4);
if(Slogan=="IL")translate([0,-30,0])scale([.42,.42,1])IL_Slog(4);
if(Slogan=="IN")translate([0,-26,0])scale([.42,.42,1])IN2(4);
if(Slogan=="LA")translate([0,-26,0])scale([.42,.42,1])LA2(4);
if(Slogan=="MA")translate([0,-27.5,0])scale([.42,.42,1])MA2(4);
if(Slogan=="MD")translate([0,-26,0])scale([.42,.42,1])MD2(4);
if(Slogan=="ME")translate([0,-26,0])scale([.4,.4,1])ME2(4);
if(Slogan=="MI")translate([0,-26,0])scale([.4,.4,1])MI2(4);
if(Slogan=="MN")translate([0,-27,0])scale([.4,.4,1])MN2(4);
if(Slogan=="MO")translate([-.25,21,0])scale([.5,.5,1])MO2(4);
if(Slogan=="MP")translate([5,25,0])scale([.55,.55,1])MP2(4);
if(Slogan=="MT")translate([23.75,-24.25,0])scale([.5,.5,1])MT2(4);
if(Slogan=="NC")translate([1,24,0])scale([.5,.5,1])NC2(4);
if(Slogan=="ND")translate([-45,-28,0])scale([.5,.5,1])ND2(4);
if(Slogan=="NH")translate([0,28,0])scale([.5,.5,1])NH2(4);
if(Slogan=="NM")translate([0,0,0])scale([.55,.55,1])NM2(4);
if(Slogan=="NV")translate([0,-29,0])scale([.5,.5,1])NV2(4);
if(Slogan=="NY")translate([0,-28,0])scale([.48,.48,1])NY2(4);
if(Slogan=="OK")translate([6,-28,0])scale([.53,.53,1])OK2(4);
if(Slogan=="PA")translate([0,-25,0])scale([.5,.5,1])PA2(4);
if(Slogan=="PR")translate([0,-25,0])scale([.5,.5,1])PR2(4);
if(Slogan=="RI")translate([0,-22,0])scale([.45,.45,1])RI2(4);
if(Slogan=="SC")translate([0,27,0])scale([.5,.5,1])SC2(4);
if(Slogan=="SD")translate([0,-28,0])scale([.55,.55,1])SD2(4);
if(Slogan=="TN")translate([17,30,0])scale([.55,.55,1])TN2(4);
if(Slogan=="TX")translate([0,-28,0])scale([.5,.5,1])TX2(4);
if(Slogan=="UT")translate([0,-7,0])scale([.5,.5,1])UT2(4);
if(Slogan=="VI")translate([0,-25,0])scale([.5,.5,1])VI2(4);
if(Slogan=="VT")translate([0,-28,0])scale([.5,.5,1])VT2(4);
if(Slogan=="WA")translate([0,-24,0])scale([.52,.52,1])WA2(4);
if(Slogan=="WI")translate([0,-28,0])scale([.5,.5,1])WI2(4);
if(Slogan=="WV")translate([0,-28,0])scale([.5,.5,1])WV2(4);
}
// Place Background
color("red"){
if(Back=="AK")translate([1,-3,0])scale([.5,.5,1])AK_Back(3);
if(Back=="AL")translate([0,-19,0])scale([.33,.33,1])AL_Back(3);
if(Back=="AR")translate([0,-5,0])scale([.47,.47,1])AR_Back(3);
if(Back=="AS")translate([-50,0,0])scale([.45,.45,1])AS_Back(3);
if(Back=="AZ")translate([0,-13,0])scale([.4,.4,1])AZ_Back(3);
if(Back=="CO")translate([0,13,0])scale([.4,.4,1])CO_Back(3);
if(Back=="CT")translate([-57,24,0])scale([.4,.4,1])CT_Back(3);
if(Back=="DC")translate([0,-0.5,0])scale([.4,.4,1])DC_Back(3);
if(Back=="FL")translate([2.25,-4.5,0])scale([.5,.5,1])FL_Back(3);
if(Back=="GU")translate([-23,5,0])scale([.33,.33,1])GU_Back(3);
if(Back=="IA")translate([10,-9,0])scale([.4,.4,1])IA_Back(3);
if(Back=="ID")translate([0,-22,0])scale([.4,.4,1])ID_Back(3);
if(Back=="IL")translate([-1,-2,0])scale([.42,.42,1])IL_Back(3);
if(Back=="IN")translate([-46,-3,0])scale([.42,.42,1])IN3(3);
if(Back=="KS")translate([15,-8,0])scale([.4,.4,1])KS2(3);
if(Back=="KY")translate([0,-1,0])scale([.4,.4,1])KY2(3);
if(Back=="MD")translate([0,0,0])scale([.42,.42,1])MD3(3);
if(Back=="ME")translate([-50,3,0])scale([.4,.4,1])ME3(3);
if(Back=="MI")translate([0,-22,0])scale([.4,.4,1])MI3(3);
if(Back=="MN")translate([-1,8,0])scale([.4,.4,1])MN3(3);
if(Back=="MO")translate([0,-6.5,0])scale([.5,.5,1])MO3(3);
if(Back=="MP")translate([-50.5,-1,0])scale([.55,.55,1])MP3(3);
if(Back=="MS")translate([1,-2,0])scale([.55,.55,1])MS2(3);
if(Back=="MT")translate([0,-1.57,0])scale([.5,.5,1])MT3(3);
if(Back=="NC")translate([0,0,0])scale([.5,.5,1])NC3(3);
if(Back=="ND")translate([0,-21.5,0])scale([.5,.5,1])ND3(3);
if(Back=="NE")translate([0,-0.5,0])scale([.5,.5,1])NE2(3);
if(Back=="NJ")translate([-16,0,0])scale([.5,.5,1])NJ3(3);
if(Back=="NM")translate([0,4,0])scale([.55,.55,1])NM3(3);
if(Back=="NV")translate([0,21,0])scale([.5,.5,1])NV3(3);
if(Back=="NY")translate([0,10,0])scale([.48,.48,1])NY3(3);
if(Back=="OH")translate([0,27,0])scale([.5,.5,1])OH2(3);
if(Back=="OK")translate([0,-3,0])scale([.53,.53,1])OK3(3);
if(Back=="OR")translate([0,-2,0])scale([.5,.5,1])OR2(3);
if(Back=="PA")translate([0,0,0])scale([.5,.5,1])PA3(3);
if(Back=="PR")translate([9,5,0])scale([.5,.5,1])PR3(3);
if(Back=="RI")translate([0,0,0])scale([.45,.45,1])RI3(3);
if(Back=="SC")translate([0,-5,0])scale([.5,.5,1])SC3(3);
if(Back=="TN")translate([0,0,0])scale([.55,.55,1])TN3(3);
if(Back=="TX")translate([-35,9,0])scale([.5,.5,1])TX3(3);
if(Back=="UT")translate([0,23,0])scale([.5,.5,1])UT3(3);
if(Back=="VI")translate([0,0,0])scale([.5,.5,1])VI3(3);
if(Back=="VT")translate([0,7,0])scale([.5,.5,1])VT3(3);
if(Back=="WA")translate([0,-8,0])scale([.52,.52,1])WA3(3);
if(Back=="WI")translate([0,25,0])scale([.5,.5,1])WI3(3);
if(Back=="WV")translate([0,1,0])scale([.5,.5,1])WV3(3);
if(Back=="WY")translate([-25,1,0])scale([.55,.55,1])WY2(3);
}

// Plate Files and Details
module AK_Stat(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[41.088057,44.277639],[38.678676,43.900152],[36.177127,44.007719],[33.635301,43.889182],[31.134777,42.838919],[29.812373,42.133046],[28.426052,41.728071],[25.189537,41.771989],[21.797368,41.918024],[20.616861,41.504333],[19.717275,40.681133],[19.051511,39.384647],[18.572473,37.551098],[17.986177,32.017699],[17.873078,26.511961],[18.319052,22.419093],[19.332003,19.702188],[20.053566,18.848188],[20.919837,18.324339],[23.153376,18.023868],[25.419635,18.835217],[27.735599,20.768562],[30.118257,23.834079],[33.049528,27.897463],[35.747242,30.750412],[38.656051,32.780172],[42.220607,34.373989],[46.094465,35.383642],[49.759612,35.516731],[53.117479,34.837801],[56.069498,33.411396],[58.517100,31.302060],[60.361714,28.574337],[61.504773,25.292773],[61.847707,21.521909],[61.443399,17.885571],[60.463750,14.442912],[59.012541,11.467919],[57.193557,9.234579],[52.226273,6.300482],[42.494307,1.235469],[36.239385,-2.035369],[31.281016,-4.987402],[27.492317,-7.779887],[24.746402,-10.572079],[22.916385,-13.523236],[21.875380,-16.792612],[21.496503,-20.539465],[21.652867,-24.923051],[22.024142,-27.869185],[22.656663,-30.494504],[23.579921,-32.840831],[24.823406,-34.949988],[26.416608,-36.863799],[28.389017,-38.624088],[33.589417,-41.851391],[37.177316,-43.587336],[39.944882,-44.457816],[43.050001,-44.677835],[47.650557,-44.462401],[64.564935,-43.127666],[68.869326,-42.499312],[70.789127,-41.853681],[71.956632,-39.780408],[72.839125,-36.220566],[73.273676,-32.121601],[73.097357,-28.430961],[72.664902,-26.575129],[72.033452,-25.213026],[71.111864,-24.205590],[69.808997,-23.413761],[67.832955,-22.708592],[67.045527,-22.744776],[66.309701,-23.099609],[64.746484,-24.943630],[62.650557,-28.597471],[60.582200,-31.860913],[58.900557,-33.613601],[53.553155,-35.536642],[48.067572,-36.409624],[43.106345,-36.191047],[41.029406,-35.659455],[39.332007,-34.839411],[37.760980,-33.992211],[37.603695,-34.137287],[37.823437,-34.656411],[37.861242,-35.116342],[36.897107,-34.381531],[36.016779,-33.265221],[35.361035,-31.829442],[34.735702,-28.293449],[35.045920,-24.361500],[36.316497,-20.621541],[38.158685,-17.842882],[40.807261,-15.346678],[44.512720,-12.939630],[49.525557,-10.428441],[61.568087,-4.913861],[65.673134,-2.833728],[69.097468,-0.642429],[71.882196,1.718964],[74.068428,4.309378],[75.697272,7.187741],[76.809836,10.412981],[77.447228,14.044024],[77.650557,18.139799],[77.254621,21.897516],[76.127495,25.698951],[74.360202,29.423648],[72.043765,32.951147],[69.269206,36.160990],[66.127548,38.932719],[62.709814,41.145875],[59.107027,42.679999],[54.417030,43.794217],[49.212921,44.488428],[44.451122,44.677835],[41.088057,44.277639]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[257.650557,43.600749],[256.004797,42.792330],[254.723616,41.808557],[253.809549,40.659172],[253.265127,39.353914],[253.092883,37.902527],[253.295350,36.314752],[253.875061,34.600329],[254.834547,32.768999],[256.157326,29.880961],[256.709547,27.247779],[256.159728,24.802541],[254.770097,22.404879],[252.941641,20.580653],[251.988162,20.047908],[251.075347,19.855719],[249.710666,19.649174],[248.889367,19.152589],[248.044502,18.777494],[246.262713,18.559333],[241.013642,18.546288],[235.392714,19.018409],[231.650487,19.880649],[229.298139,21.183746],[227.472100,22.501343],[226.157097,23.873964],[225.337857,25.342131],[224.999106,26.946367],[225.125571,28.727195],[225.701980,30.725138],[226.713057,32.980719],[227.999883,35.845533],[228.585955,38.150462],[228.400652,39.950341],[227.373351,41.300004],[225.433431,42.254289],[222.510269,42.868029],[218.533246,43.196061],[213.431737,43.293219],[207.315594,43.237011],[203.691745,42.954384],[201.533009,42.274341],[199.812207,41.025879],[197.181807,38.758529],[199.122807,36.151119],[201.537352,33.725323],[204.616877,31.554579],[207.377755,29.700312],[209.026187,28.035419],[213.909573,16.340224],[219.227397,2.043219],[226.468416,-16.386003],[235.181827,-36.720151],[237.193260,-40.222273],[239.112517,-42.437231],[241.175511,-43.264856],[243.489220,-43.226396],[245.729716,-42.384468],[247.573077,-40.801691],[249.528365,-37.691282],[252.039873,-32.795608],[257.132357,-20.966701],[260.326637,-13.328471],[263.284901,-6.832358],[265.150557,-1.613241],[267.395067,4.126959],[273.254437,17.853599],[276.752747,25.184399],[278.347495,27.484350],[279.976497,29.103599],[285.333006,33.581570],[286.964655,35.234735],[287.969941,36.627566],[288.402393,37.857722],[288.315541,39.022864],[287.762916,40.220650],[286.798047,41.548739],[285.512277,42.790494],[283.420886,43.475664],[279.326670,43.799552],[272.032427,43.957459],[262.455311,43.933316],[257.650557,43.600749]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[246.400557,5.793219],[247.724776,3.977519],[248.275557,2.245099],[247.700049,-0.651007],[246.298548,-4.996819],[244.558589,-9.429907],[242.967707,-12.587841],[241.495377,-14.834891],[238.088587,-11.852961],[236.363156,-10.086521],[234.844511,-8.041349],[232.597175,-3.579052],[231.953277,-1.394046],[231.685756,0.605451],[231.837011,2.303380],[232.449437,3.583679],[232.989892,4.482057],[232.806807,4.855719],[232.656440,5.268804],[233.275557,6.261969],[234.269588,6.973564],[235.768534,7.453670],[239.640822,7.742286],[243.611728,7.173556],[245.233946,6.581980],[246.400557,5.793219]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[-282.108173,42.541339],[-286.184782,41.923073],[-287.299886,41.306164],[-288.014173,40.406479],[-288.402393,39.360238],[-288.286028,38.376706],[-287.584738,37.248372],[-286.218183,35.767729],[-283.829598,33.799406],[-282.000513,32.980719],[-280.927262,32.672599],[-279.766881,31.698302],[-278.480262,29.982926],[-277.028298,27.451566],[-273.471908,19.641281],[-268.784853,7.668219],[-256.613302,-24.302348],[-253.525042,-31.825015],[-251.258763,-36.682811],[-249.640017,-39.757507],[-248.422082,-41.347871],[-247.076082,-41.894767],[-245.073143,-41.839061],[-243.325289,-41.558882],[-241.942548,-40.989801],[-240.772394,-40.041136],[-239.662303,-38.622211],[-235.837639,-31.105359],[-229.653028,-17.080094],[-222.242167,0.793595],[-214.738753,19.855719],[-212.519221,25.190937],[-210.406818,28.922429],[-207.929209,31.722309],[-204.614063,34.262689],[-201.758614,36.420022],[-200.328325,38.173297],[-200.111996,38.975403],[-200.209213,39.768881],[-201.287293,41.453139],[-202.503797,42.423412],[-204.437869,42.978621],[-213.354123,43.282899],[-221.286881,43.137169],[-226.769900,42.693457],[-230.070731,41.914528],[-230.986435,41.387722],[-231.456923,40.763149],[-231.312217,38.715704],[-230.252623,35.647809],[-229.358315,33.142753],[-228.898545,30.627840],[-228.856525,28.171116],[-229.215465,25.840628],[-229.958577,23.704424],[-231.069072,21.830550],[-232.530160,20.287053],[-234.325053,19.141979],[-236.480272,18.550544],[-239.658523,18.184854],[-247.392849,18.072124],[-254.145487,18.686633],[-256.096628,19.229989],[-256.530921,19.554285],[-256.533893,19.911219],[-256.815515,20.871206],[-258.146733,22.120879],[-259.855278,22.961528],[-260.438184,22.927815],[-260.834973,22.590499],[-261.235264,22.328005],[-261.687517,22.628968],[-262.586079,24.446023],[-263.207000,27.091181],[-263.226623,29.613959],[-262.322524,32.407728],[-260.805473,35.503619],[-259.584763,38.342991],[-259.393173,40.520029],[-259.874579,41.435337],[-260.758024,42.137144],[-262.179341,42.637538],[-264.274363,42.948604],[-271.028857,43.051105],[-282.108173,42.541339]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-239.960553,8.725749],[-239.191882,8.089053],[-238.284843,6.726799],[-237.808599,4.553035],[-238.196718,1.308113],[-239.476631,-3.134395],[-241.675773,-8.900921],[-243.398486,-12.445534],[-245.030204,-14.788811],[-246.246874,-15.574750],[-246.598300,-15.272467],[-246.724443,-14.447351],[-247.550617,-13.213081],[-249.536943,-12.019281],[-251.119979,-11.184175],[-252.080865,-10.143732],[-252.535881,-8.693408],[-252.601303,-6.628661],[-252.780173,-5.801018],[-253.271283,-5.456781],[-253.989238,-4.289974],[-254.680295,-1.485921],[-255.149079,1.910828],[-255.200213,4.855719],[-254.687883,7.260196],[-254.176692,8.059122],[-253.422444,8.626883],[-250.965669,9.182046],[-246.879333,9.151949],[-239.960553,8.725749]]);
    }
    linear_extrude(height=h)
      polygon([[-176.407023,42.476279],[-178.153245,41.511669],[-179.067313,40.135489],[-178.830003,38.517097],[-177.816617,36.790334],[-176.389918,35.416207],[-174.912673,34.855719],[-173.286364,34.191409],[-171.073593,32.594249],[-168.443193,30.332779],[-168.151443,-1.156201],[-167.859693,-32.645171],[-170.938503,-35.457221],[-173.395773,-37.447454],[-174.980253,-38.283641],[-177.225723,-39.110481],[-177.794914,-39.589839],[-177.918654,-40.104973],[-176.749613,-41.674251],[-175.363171,-42.605591],[-172.869727,-43.134516],[-160.467073,-43.425531],[-149.742763,-43.195269],[-146.426256,-42.860645],[-144.378108,-42.338092],[-143.526765,-41.596412],[-143.800673,-40.604406],[-145.128277,-39.330875],[-147.438023,-37.744621],[-149.998410,-35.882639],[-150.763913,-34.808751],[-150.801804,-34.046693],[-151.612833,-32.934461],[-152.303614,-31.079102],[-152.718332,-26.248404],[-152.972993,-1.874191],[-152.698667,23.420772],[-152.203213,28.434249],[-151.332363,31.105719],[-149.693193,34.386969],[-139.076793,34.386969],[-128.460393,34.386969],[-125.014293,30.523079],[-119.529763,24.194959],[-117.782303,22.503824],[-116.127274,21.848092],[-114.456535,22.218484],[-112.661943,23.605719],[-111.577814,25.292423],[-110.936054,27.577947],[-110.709782,30.243235],[-110.872118,33.069229],[-111.396181,35.836874],[-112.255089,38.327112],[-113.421964,40.320886],[-114.869923,41.599139],[-118.006802,42.034705],[-124.891464,42.412019],[-145.011578,42.922154],[-165.445139,42.990067],[-172.721611,42.814603],[-176.407023,42.476279]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[-88.052573,42.215559],[-89.145223,41.466530],[-89.786903,40.586670],[-89.983930,39.591675],[-89.742620,38.497239],[-89.069291,37.319059],[-87.970259,36.072829],[-84.520353,33.438999],[-81.045121,30.805229],[-79.636796,29.092630],[-78.264105,26.756912],[-75.073939,19.138194],[-70.371253,5.793219],[-66.238793,-5.129711],[-65.257565,-7.601342],[-64.849443,-9.395341],[-64.616994,-10.583166],[-64.058123,-11.597411],[-61.083753,-18.113031],[-56.343190,-29.609867],[-51.965313,-39.206781],[-50.170124,-41.584290],[-49.084515,-42.335233],[-47.917682,-42.783456],[-46.702713,-42.920822],[-45.472697,-42.739196],[-44.260724,-42.230444],[-43.099883,-41.386431],[-40.781952,-38.240375],[-37.682733,-32.562186],[-34.191376,-25.126206],[-30.697033,-16.706781],[-26.357753,-5.925531],[-20.261853,10.011969],[-16.363093,20.012792],[-13.235113,26.491967],[-11.745200,28.780763],[-10.190023,30.632938],[-6.539933,33.619149],[-3.904804,35.771921],[-2.471335,37.844463],[-2.217756,38.820058],[-2.279631,39.738886],[-2.661972,40.588712],[-3.369793,41.357299],[-4.994869,41.829452],[-8.222659,42.166076],[-17.409312,42.433423],[-26.775602,42.160708],[-30.227940,41.822255],[-32.167383,41.349299],[-33.421366,40.398397],[-33.798042,39.125627],[-33.282718,37.191150],[-31.860703,34.255129],[-30.786921,32.049244],[-30.323375,30.359042],[-30.411458,28.654646],[-30.992563,26.406179],[-32.508319,22.928524],[-34.483923,20.136909],[-36.024963,18.834914],[-38.120529,18.184043],[-42.035357,18.010906],[-49.034183,18.142109],[-61.281393,18.450369],[-63.529513,21.262869],[-64.456464,22.679603],[-65.143175,24.270941],[-65.785385,27.730389],[-65.435162,31.147125],[-64.881330,32.685073],[-64.071523,34.027059],[-62.563140,36.242296],[-61.794442,38.046318],[-61.735301,39.559856],[-62.355593,40.903639],[-63.402039,41.684400],[-65.498325,42.223122],[-74.713073,42.872869],[-83.654738,42.921149],[-86.426171,42.662708],[-88.052573,42.216459]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-41.620543,8.083809],[-40.203582,6.737406],[-39.653993,4.970061],[-39.942386,2.280262],[-41.039373,-1.833501],[-43.096001,-7.945487],[-45.118678,-12.404762],[-47.104309,-15.210803],[-48.082267,-15.993697],[-49.049803,-16.363087],[-50.006531,-16.318906],[-50.952065,-15.861090],[-52.808001,-13.704291],[-54.614518,-9.892165],[-56.368523,-4.424191],[-57.453276,0.193139],[-57.809378,3.660662],[-57.436052,6.249961],[-56.332523,8.232619],[-55.368321,8.838839],[-53.764393,9.262596],[-49.416925,9.570607],[-44.849254,9.172422],[-42.970071,8.713434],[-41.620513,8.083809]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[96.865857,41.414409],[96.045057,40.367340],[95.688235,39.440952],[95.766634,38.435750],[96.251497,37.152239],[97.874860,34.999812],[100.252917,33.171669],[104.028835,30.917954],[105.174041,29.663073],[105.945970,27.904003],[106.436040,25.326613],[106.735671,21.616773],[107.129287,9.543219],[107.670888,-12.187861],[107.750390,-24.862083],[107.316490,-31.236908],[106.890983,-32.923755],[106.317887,-34.069801],[104.257553,-36.217008],[101.510917,-38.011221],[99.567580,-39.113122],[98.456511,-40.099502],[98.298180,-40.809381],[99.213057,-41.081781],[99.875165,-41.494866],[100.150557,-42.488031],[100.447351,-42.848497],[101.287847,-43.161823],[104.300624,-43.646584],[113.558078,-44.045222],[123.133805,-43.676364],[126.544421,-43.201755],[128.238687,-42.532431],[128.716747,-41.775213],[128.779360,-41.053724],[127.556647,-39.225391],[125.833470,-36.643772],[124.591832,-33.131876],[123.840454,-28.724359],[123.588057,-23.455881],[123.729222,-18.825902],[124.190836,-15.410761],[125.030076,-13.193339],[125.609173,-12.528425],[126.304118,-12.156521],[128.070141,-12.283186],[130.385320,-13.556218],[133.306833,-15.958499],[136.891857,-19.472911],[141.797877,-24.675340],[144.927978,-28.395364],[146.689152,-31.173694],[147.488387,-33.551041],[147.486988,-35.068376],[147.090344,-35.230224],[146.386937,-35.052531],[145.384925,-34.851207],[146.096767,-35.935991],[146.652963,-36.763970],[146.833400,-37.563861],[146.060867,-39.726391],[145.386847,-41.648513],[145.685187,-42.877651],[149.700304,-43.618362],[157.724142,-44.214687],[166.112901,-44.476176],[171.222777,-44.212381],[172.287050,-43.776650],[172.930453,-43.158033],[173.164333,-42.386397],[173.000041,-41.491609],[171.522332,-39.452051],[168.588117,-37.278301],[165.684292,-35.173067],[164.859831,-34.273947],[164.626967,-33.636491],[164.557233,-32.992822],[164.027847,-33.034361],[163.372597,-32.867055],[162.221821,-32.020104],[159.082737,-28.838041],[151.465117,-20.316261],[145.453916,-13.403147],[143.398988,-10.594029],[141.938180,-8.138892],[141.041741,-5.979501],[140.679925,-4.057621],[140.822983,-2.315019],[141.441167,-0.693461],[145.291226,4.283417],[152.769070,13.066574],[160.822760,22.146019],[166.400357,28.011759],[169.283753,30.303763],[171.685537,31.601919],[174.649844,32.624193],[177.249350,33.834999],[179.180751,35.070579],[180.140747,36.167169],[180.347968,37.675378],[180.134747,39.447549],[179.621044,40.499327],[178.678741,41.373806],[177.311564,42.070187],[175.523236,42.587674],[170.698026,43.082773],[164.232907,42.852719],[155.931817,42.174079],[151.707277,37.811799],[146.957465,32.252414],[141.470777,25.012009],[137.104715,19.116232],[133.477497,14.757680],[130.540824,11.922368],[128.246398,10.596309],[127.324935,10.494880],[126.545920,10.765518],[125.903319,11.406478],[125.391092,12.416009],[124.733613,15.533795],[124.525187,20.104889],[124.679806,24.895991],[125.300675,28.337602],[126.623306,31.192777],[128.883217,34.224569],[130.413653,36.372612],[130.971177,38.123064],[130.567089,39.722692],[129.212687,41.418259],[127.796873,42.433512],[125.366163,42.997789],[120.793478,43.241052],[112.951737,43.293259],[105.086858,43.242214],[100.541992,43.000572],[98.180436,42.435571],[96.865487,41.414449]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[147.494307,-42.019281],[147.611875,-42.681392],[147.080887,-42.956781],[146.379700,-42.681392],[146.088057,-42.019281],[146.209500,-41.357173],[146.501477,-41.081781],[147.494307,-42.019281]]);
    }
  }
}
module AK_Slog(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-224.602160,25.798135],[-225.826295,25.174611],[-226.777589,24.277046],[-227.489831,22.906788],[-227.996807,20.865187],[-228.530117,13.973356],[-228.647820,2.012345],[-228.501446,-12.381622],[-227.974814,-16.691845],[-226.840407,-19.521239],[-225.973691,-20.484612],[-224.869116,-21.202562],[-221.831830,-22.068574],[-217.499441,-22.452032],[-211.642840,-22.685695],[-204.495091,-22.926715],[-200.441265,-22.838316],[-198.302421,-22.301464],[-196.899620,-21.197125],[-195.488326,-19.436585],[-194.998330,-17.817637],[-195.427279,-16.216109],[-196.772820,-14.507825],[-197.955453,-13.593525],[-199.467497,-13.015919],[-204.507200,-12.620025],[-208.923635,-12.476417],[-212.066156,-12.083955],[-213.815074,-11.467333],[-214.129529,-11.082679],[-214.050700,-10.651245],[-213.986480,-10.064406],[-214.553190,-9.820325],[-215.550662,-9.084150],[-216.522050,-7.314205],[-216.873775,-5.971961],[-216.824828,-4.820850],[-216.362166,-3.852513],[-215.472747,-3.058592],[-214.143530,-2.430731],[-212.361471,-1.960569],[-207.386660,-1.459915],[-205.448957,-0.986499],[-203.921720,0.104524],[-203.050958,1.552665],[-203.082680,3.097435],[-204.037582,4.761829],[-205.468694,5.986972],[-207.336731,6.749205],[-209.602410,7.024865],[-212.136208,7.249053],[-214.333791,7.834208],[-216.148928,8.729650],[-217.535389,9.884704],[-218.446943,11.248690],[-218.837362,12.770930],[-218.660414,14.400748],[-217.869870,16.087465],[-216.856638,17.303266],[-215.353066,17.968836],[-212.625324,18.248023],[-207.939580,18.304675],[-200.820651,18.693775],[-198.422104,19.188047],[-196.786561,19.889151],[-195.905817,20.802352],[-195.771666,21.932914],[-196.375902,23.286100],[-197.710320,24.867175],[-199.060145,25.866418],[-201.164327,26.424314],[-204.881351,26.657532],[-211.069700,26.682745],[-219.782161,26.398371],[-224.602160,25.798135]]);
    linear_extrude(height=h)
      polygon([[-160.905210,25.801135],[-163.608305,25.475693],[-165.641823,24.958689],[-167.106163,23.972047],[-168.101725,22.237690],[-168.728909,19.477541],[-169.088117,15.413523],[-169.404200,2.261575],[-169.475693,-10.068436],[-169.029524,-16.785233],[-168.517188,-18.566289],[-167.761285,-19.577178],[-166.723762,-20.028945],[-165.366570,-20.132635],[-164.011053,-20.011923],[-162.941135,-19.549779],[-162.116235,-18.596194],[-161.495772,-17.001157],[-160.705838,-11.286693],[-160.246690,-1.206305],[-159.799157,9.370152],[-159.386504,12.606152],[-158.686585,14.791499],[-157.578396,16.164318],[-155.940932,16.962733],[-150.594160,17.788855],[-146.766681,18.377971],[-144.232167,19.171785],[-142.829564,20.246744],[-142.397820,21.679295],[-142.777873,22.852323],[-143.866105,23.872113],[-145.584621,24.721317],[-147.855529,25.382586],[-153.742946,26.071924],[-160.905210,25.801335]]);
    linear_extrude(height=h)
      polygon([[-300.954907,24.257675],[-301.572554,22.705322],[-302.053449,19.550916],[-302.710317,7.425945],[-303.352527,-4.452841],[-303.807597,-7.606245],[-304.366017,-9.041935],[-306.370279,-10.437798],[-309.522267,-12.132085],[-311.425987,-13.164610],[-312.697693,-14.170149],[-313.446651,-15.262123],[-313.782127,-16.553955],[-313.790643,-17.846583],[-313.422622,-18.883325],[-312.583383,-19.692889],[-311.178247,-20.303985],[-306.291562,-21.045610],[-298.005127,-21.337875],[-291.314794,-21.379508],[-287.414341,-21.179491],[-285.277311,-20.606382],[-283.877250,-19.528735],[-282.919875,-18.449702],[-282.474875,-17.548701],[-282.500874,-16.647800],[-282.956500,-15.569065],[-284.454512,-13.783284],[-286.568440,-12.269565],[-289.832436,-10.213936],[-290.899335,-8.994734],[-291.670020,-7.421591],[-292.204881,-5.324746],[-292.564310,-2.534438],[-292.998427,5.805615],[-293.366177,14.732569],[-293.818689,19.931825],[-294.548322,22.699836],[-295.747437,24.333055],[-297.131919,25.392348],[-298.454773,25.732974],[-299.725826,25.354790],[-300.954907,24.257655]]);
    linear_extrude(height=h)
      polygon([[-270.354660,23.943025],[-271.291493,22.354024],[-271.877921,19.358461],[-272.521350,4.454325],[-272.579944,-10.436260],[-272.193391,-14.139858],[-271.466100,-16.617005],[-270.453009,-18.483658],[-269.327645,-19.633956],[-268.153077,-20.096634],[-266.992371,-19.900425],[-265.908595,-19.074062],[-264.964816,-17.646279],[-264.224102,-15.645809],[-263.749520,-13.101385],[-262.806253,-6.897039],[-262.192887,-4.837988],[-261.396056,-3.354640],[-260.349030,-2.357214],[-258.985076,-1.755926],[-255.039460,-1.382635],[-250.982626,-1.758557],[-249.495442,-2.261238],[-248.335362,-3.002866],[-247.477099,-4.005295],[-246.895363,-5.290375],[-246.460320,-8.795895],[-246.281650,-12.019555],[-245.778831,-14.780413],[-245.001647,-17.017664],[-243.999882,-18.670506],[-242.823322,-19.678135],[-241.521750,-19.979746],[-240.144951,-19.514538],[-238.742710,-18.221705],[-237.810027,-16.529482],[-237.304524,-13.445839],[-237.145680,2.454875],[-237.552286,18.361090],[-238.115651,21.354937],[-239.098630,22.924845],[-240.329138,24.052924],[-241.436029,24.652601],[-242.427100,24.716825],[-243.310152,24.238544],[-244.092983,23.210707],[-244.783390,21.626265],[-245.918130,16.759355],[-246.557636,13.348643],[-247.238334,11.231895],[-248.173467,9.962189],[-249.576280,9.092605],[-252.503093,8.359270],[-255.866185,8.489639],[-259.038267,9.385230],[-261.392050,10.947565],[-262.742187,13.501099],[-263.585310,17.061185],[-264.519579,20.829931],[-265.320812,22.349958],[-266.336350,23.607035],[-268.605330,25.876015],[-270.354660,23.943025]]);
    linear_extrude(height=h)
      polygon([[-80.014990,25.170615],[-81.962946,24.428378],[-83.696420,23.391971],[-85.171444,22.126464],[-86.344046,20.696929],[-87.170258,19.168436],[-87.606109,17.606057],[-87.607629,16.074863],[-87.130850,14.639925],[-86.046863,13.228918],[-84.582566,12.810801],[-82.366336,13.403169],[-79.026550,15.023615],[-76.800762,16.018208],[-74.407098,16.754871],[-69.483391,17.442421],[-64.989923,17.062288],[-63.134059,16.464347],[-61.661190,15.590495],[-60.554999,14.573617],[-60.022825,13.654494],[-59.996353,12.590633],[-60.407270,11.139545],[-61.651019,9.004621],[-63.897472,7.356386],[-67.490441,6.019058],[-72.773740,4.816855],[-76.807247,3.911951],[-80.153399,2.848264],[-82.859353,1.583479],[-84.972267,0.075279],[-86.539299,-1.718651],[-87.607604,-3.840626],[-88.224342,-6.332962],[-88.436670,-9.237975],[-88.136499,-13.108144],[-87.151342,-16.398953],[-85.457732,-19.163423],[-83.032200,-21.454575],[-81.293333,-22.483246],[-79.036732,-23.076478],[-75.496615,-23.348586],[-69.907200,-23.413885],[-60.851855,-23.072753],[-58.376116,-22.524041],[-56.455660,-21.614525],[-54.063363,-19.793796],[-52.458747,-17.740983],[-51.688976,-15.540566],[-51.801210,-13.277025],[-52.645550,-11.337387],[-53.267878,-10.796686],[-54.060200,-10.537106],[-56.264487,-10.846430],[-59.477740,-12.235605],[-62.140701,-13.355704],[-64.849535,-14.083701],[-67.501500,-14.428777],[-69.993855,-14.400109],[-72.223858,-14.006877],[-74.088767,-13.258260],[-75.485842,-12.163436],[-76.312340,-10.731585],[-76.494372,-9.487987],[-76.237740,-8.302088],[-75.548461,-7.178519],[-74.432549,-6.121909],[-70.944887,-4.228085],[-65.822880,-2.657655],[-60.085685,-1.002561],[-56.083990,0.668245],[-53.974310,2.278688],[-52.256495,4.256668],[-50.952753,6.515035],[-50.085290,8.966641],[-49.676313,11.524337],[-49.748029,14.100974],[-50.322646,16.609403],[-51.422370,18.962475],[-52.579054,20.621209],[-53.883115,21.984748],[-55.406010,23.079821],[-57.219199,23.933154],[-62.002293,25.021510],[-68.804070,25.463635],[-75.964464,25.469611],[-80.014990,25.170615]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[104.767070,23.961615],[102.579421,23.001465],[100.534239,21.624246],[98.790990,19.958062],[97.509140,18.131015],[96.548102,15.510469],[95.679348,11.677822],[94.397674,2.301372],[94.022080,-6.148043],[94.285927,-8.821898],[94.550338,-9.560549],[94.910530,-9.820135],[95.487290,-10.605579],[95.727180,-12.493995],[96.345338,-15.417664],[98.002158,-18.453762],[100.401159,-21.180992],[103.245860,-23.178055],[107.106966,-24.391513],[111.741273,-24.761595],[116.502191,-24.294947],[120.743130,-22.998215],[122.934383,-21.876481],[124.645238,-20.614285],[125.933711,-19.028042],[126.857820,-16.934171],[127.475580,-14.149090],[127.845008,-10.489215],[128.070930,0.189245],[127.925657,9.973349],[127.654172,13.261426],[127.170215,15.766299],[126.413859,17.702553],[125.325174,19.284774],[121.911100,22.245455],[120.574205,22.947223],[118.680346,23.542475],[113.875031,24.348036],[108.801744,24.531347],[104.767070,23.961615]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[117.847500,13.518615],[118.777775,12.106934],[119.319330,9.948047],[119.633430,0.491765],[119.319345,-8.964468],[118.777792,-11.123118],[117.847500,-12.534475],[116.771693,-13.483575],[115.563343,-14.127658],[114.257388,-14.469413],[112.888765,-14.511528],[110.103270,-13.707588],[107.486360,-11.737345],[105.976219,-9.973307],[105.204389,-7.999584],[104.950589,-4.679113],[104.994540,1.125165],[105.346527,8.635707],[105.748372,11.156106],[106.367240,12.989357],[107.252971,14.237535],[108.455406,15.002712],[110.024385,15.386964],[112.009750,15.492365],[115.542845,15.040518],[116.802602,14.428919],[117.847500,13.518615]]);
    }
    linear_extrude(height=h)
      polygon([[247.133430,24.241225],[245.654490,23.701779],[244.397494,22.836618],[243.337478,21.586026],[242.449474,19.890285],[241.089639,14.924487],[240.118260,7.461485],[239.491608,-1.729740],[239.479250,-8.117165],[239.510491,-11.623811],[239.179335,-12.540239],[238.597010,-13.009615],[237.655050,-13.951054],[237.319544,-15.403026],[237.602396,-16.735923],[237.979427,-17.160965],[238.515510,-17.320135],[239.116818,-17.604224],[239.847866,-18.377734],[241.329810,-20.920475],[243.152563,-23.782561],[245.304340,-25.607975],[247.270520,-26.095817],[250.433149,-26.436349],[258.736528,-26.682745],[266.992023,-26.361691],[270.094797,-25.992910],[271.977180,-25.487715],[273.100828,-24.753247],[273.921466,-23.859899],[274.437114,-22.848127],[274.645795,-21.758389],[274.545531,-20.631141],[274.134342,-19.506840],[273.410252,-18.425942],[272.371280,-17.428905],[270.899893,-16.484551],[269.216654,-15.873117],[264.394860,-15.445135],[259.827600,-15.119334],[256.506180,-14.336025],[255.271475,-13.643597],[254.571901,-12.822149],[254.301097,-11.653554],[254.352700,-9.919685],[254.606483,-8.100101],[255.171736,-7.011432],[256.335154,-6.366108],[258.383430,-5.876555],[265.131361,-4.276079],[266.465513,-3.490161],[267.249010,-2.396115],[267.611550,-1.299829],[267.547774,-0.212350],[267.084352,0.841168],[266.247951,1.835569],[263.562896,3.546398],[259.705960,4.718895],[257.085301,5.305604],[255.488695,5.967850],[254.583920,6.920053],[254.038750,8.376635],[253.663889,10.132232],[253.618816,11.531557],[253.961242,12.612271],[254.748876,13.412038],[256.039429,13.968518],[257.890611,14.319374],[263.505700,14.554865],[268.998239,14.772962],[272.462728,15.530863],[273.550244,16.160805],[274.269697,16.983979],[274.667404,18.019810],[274.789680,19.287725],[274.584002,20.551429],[273.946761,21.621395],[272.847646,22.507967],[271.256344,23.221486],[266.475937,24.170744],[259.363050,24.551915],[251.499319,24.524366],[247.133430,24.241225]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[-105.855820,20.294635],[-107.767784,18.327149],[-109.852138,16.932545],[-112.065996,16.110181],[-114.366472,15.859417],[-116.710682,16.179613],[-119.055740,17.070126],[-121.358761,18.530317],[-123.576860,20.559545],[-125.822497,22.277720],[-128.029990,22.992365],[-129.169689,22.872407],[-129.831164,22.379509],[-130.138463,21.314134],[-130.215640,19.476745],[-129.097975,12.036799],[-126.403270,-0.913885],[-124.285734,-9.975854],[-122.760089,-15.419209],[-121.410383,-18.473182],[-119.820670,-20.367005],[-117.633898,-22.010947],[-115.386674,-22.790385],[-112.827635,-22.743638],[-109.705420,-21.909025],[-107.565838,-20.830342],[-105.962319,-19.190162],[-104.780987,-16.824692],[-103.907970,-13.570135],[-100.770140,0.897595],[-99.120750,9.255007],[-98.322840,15.605060],[-98.372377,20.005630],[-98.713678,21.492946],[-99.265330,22.514595],[-100.633702,23.658600],[-102.075572,23.707891],[-103.759944,22.605544],[-105.855820,20.294635]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-113.804070,6.117365],[-113.901928,5.582600],[-113.495989,5.198556],[-111.426840,5.001885],[-110.966742,4.376275],[-110.858096,2.686779],[-111.087327,0.382926],[-111.640860,-2.085755],[-112.453397,-4.086583],[-113.395295,-4.981494],[-114.494827,-4.780098],[-115.780270,-3.492005],[-116.645840,-1.721075],[-117.027987,0.242355],[-116.878163,1.686260],[-116.588590,1.990883],[-116.147820,1.898615],[-115.779758,1.844890],[-115.482112,2.137416],[-115.210320,3.562035],[-115.026726,5.329629],[-114.585320,6.429865],[-113.594316,7.025966],[-113.516566,6.746740],[-113.804070,6.117365]]);
    }
    linear_extrude(height=h)
      polygon([[-27.215840,22.137595],[-28.470575,20.830090],[-29.141565,18.564389],[-29.426642,13.908188],[-29.523640,5.429185],[-29.849154,-5.567679],[-30.498990,-11.060855],[-32.349187,-12.791724],[-35.560680,-14.743055],[-38.501591,-16.760741],[-39.367580,-17.829318],[-39.822090,-18.901043],[-39.858745,-19.948406],[-39.471169,-20.943900],[-38.652986,-21.860019],[-37.397820,-22.669255],[-35.645737,-23.139967],[-32.718304,-23.498958],[-24.861252,-23.861079],[-16.874394,-23.714210],[-13.784703,-23.436965],[-11.805460,-23.016945],[-10.294474,-22.252416],[-9.267975,-21.320916],[-8.720313,-20.263707],[-8.645837,-19.122052],[-9.038897,-17.937214],[-9.893843,-16.750453],[-11.205024,-15.603033],[-12.966790,-14.536215],[-16.411150,-12.477909],[-17.501631,-11.327605],[-18.256507,-9.859504],[-18.739926,-7.895832],[-19.016033,-5.258817],[-19.202900,2.746335],[-19.309252,12.619387],[-19.585202,17.967494],[-20.234356,20.532153],[-21.460320,22.054865],[-22.948846,23.363902],[-24.167459,23.810641],[-25.471382,23.400192],[-27.215840,22.137665]]);
    linear_extrude(height=h)
      polygon([[16.953980,20.587585],[16.559965,18.181983],[16.281473,13.775179],[16.068213,1.551297],[16.308511,-10.897385],[16.596968,-15.585191],[16.996680,-18.384195],[17.578032,-19.982564],[18.409060,-21.262075],[19.594623,-22.257485],[21.239583,-23.003554],[26.327129,-23.886701],[34.510580,-24.189585],[41.828942,-24.066830],[46.533225,-23.441194],[48.037125,-22.905707],[49.045949,-22.203593],[49.612512,-21.321218],[49.789630,-20.244945],[49.642797,-19.103000],[49.190626,-18.116025],[48.415610,-17.275386],[47.300241,-16.572446],[43.978416,-15.545124],[39.085090,-14.964975],[33.419054,-14.342817],[30.016990,-13.524565],[28.889764,-12.295457],[28.293033,-10.383225],[28.294956,-8.251310],[28.963690,-6.363155],[30.263150,-5.235807],[32.423584,-4.239630],[35.015649,-3.528836],[37.610000,-3.257635],[39.776641,-2.761016],[41.502755,-1.469037],[42.523817,0.321485],[42.575300,2.313735],[41.674538,3.736999],[39.948904,4.952391],[37.707238,5.799363],[35.258380,6.117365],[33.339006,6.247799],[31.679443,6.656644],[30.255639,7.370212],[29.043538,8.414818],[28.019086,9.816772],[27.158228,11.602390],[25.831080,16.429865],[25.030812,19.650018],[24.026020,21.662015],[22.633726,22.698562],[20.670950,22.992365],[19.283298,22.875541],[18.270231,22.480436],[17.528270,21.740101],[16.953930,20.587585]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[58.414680,21.867365],[57.901358,20.297317],[57.552410,16.620632],[57.291130,1.945485],[57.498074,-11.604304],[57.854194,-16.044224],[58.466360,-19.230381],[59.400282,-21.389939],[60.721669,-22.750061],[62.496232,-23.537912],[64.789680,-23.980655],[69.549886,-24.315678],[74.346546,-24.132485],[78.610506,-23.483354],[81.772610,-22.420565],[83.934566,-20.905935],[85.740310,-18.833023],[87.166558,-16.290074],[88.190026,-13.365333],[88.787431,-10.147042],[88.935489,-6.723446],[88.610917,-3.182789],[87.790430,0.386685],[86.643783,6.200442],[86.498730,13.050415],[86.615242,17.051705],[86.446219,19.438571],[85.873836,20.807952],[84.780270,21.756785],[83.628810,22.438625],[82.763261,22.602091],[81.922488,22.212591],[80.845350,21.235535],[79.210329,18.794010],[77.939350,15.584005],[76.876964,12.612074],[75.514566,10.539405],[73.814424,9.325501],[71.738800,8.929865],[70.046379,9.496342],[68.543444,11.157662],[67.266437,13.856665],[66.251800,17.536185],[65.743635,19.163800],[64.987802,20.543495],[64.040782,21.644056],[62.959055,22.434269],[61.799101,22.882920],[60.617401,22.958796],[59.470434,22.630682],[58.414680,21.867365]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[78.149050,-3.460425],[79.214604,-5.134058],[79.710073,-6.948272],[79.683587,-8.790957],[79.183275,-10.550004],[78.257267,-12.113304],[76.953693,-13.368749],[75.320681,-14.204229],[73.406360,-14.507635],[70.916106,-14.160630],[69.040635,-13.099491],[67.746572,-11.294032],[67.000540,-8.714065],[66.810314,-6.867153],[67.000070,-5.458394],[67.659214,-4.207688],[68.877150,-2.834935],[71.119874,-1.299690],[73.523791,-0.899679],[75.922363,-1.623669],[78.149050,-3.460425]]);
    }
    linear_extrude(height=h)
      polygon([[162.899050,19.861385],[159.489721,15.678252],[155.439750,10.017635],[151.928606,5.280959],[150.604732,3.843324],[149.814750,3.319215],[148.099564,3.751273],[146.872743,5.192124],[145.985562,7.936180],[145.289300,12.277855],[144.518532,17.254345],[143.564384,20.231989],[142.941549,21.116878],[142.180477,21.676818],[140.120430,22.054865],[138.935807,21.880593],[137.999792,21.253601],[137.284441,20.017624],[136.761814,18.016396],[136.182957,11.093131],[136.039680,-0.766315],[136.203420,-12.643273],[136.474282,-16.548008],[136.929969,-19.336283],[137.614606,-21.187624],[138.572318,-22.281560],[139.847228,-22.797618],[141.483460,-22.915325],[143.788919,-22.574988],[145.834216,-21.298883],[148.141116,-18.611888],[151.231380,-14.038885],[154.175575,-9.763841],[156.753002,-6.641373],[158.957112,-4.672430],[160.781355,-3.857965],[161.548981,-3.883958],[162.219184,-4.198927],[163.264048,-5.696268],[163.909400,-8.350937],[164.148690,-12.163885],[164.468017,-16.727404],[165.374399,-19.952885],[166.061870,-21.093965],[166.913067,-21.936659],[167.933642,-22.493008],[169.129250,-22.775055],[170.594640,-22.726745],[171.780473,-22.140290],[172.712284,-20.914377],[173.415611,-18.947699],[174.238959,-12.386804],[174.454810,-1.647125],[174.185335,9.896554],[173.568850,16.873505],[172.855086,19.137435],[171.903719,20.878171],[170.744984,22.087248],[169.409118,22.756197],[167.926355,22.876553],[166.326933,22.439847],[164.641086,21.437614],[162.899050,19.861385]]);
    linear_extrude(height=h)
      polygon([[196.822620,22.361495],[195.965661,22.015449],[195.282591,21.383493],[194.746134,20.317720],[194.329014,18.670224],[193.743685,13.038433],[193.308400,3.304865],[192.758430,-12.163885],[189.646820,-13.717795],[185.605814,-16.295718],[184.238428,-17.648854],[183.324159,-19.009639],[182.876289,-20.351720],[182.908097,-21.648745],[183.432864,-22.874364],[184.463870,-24.002225],[186.350223,-24.637188],[189.873954,-25.081882],[199.581388,-25.409625],[209.081840,-25.003770],[212.346845,-24.531468],[213.870980,-23.882635],[214.725394,-21.766076],[214.558430,-19.677418],[213.352994,-17.564320],[211.091990,-15.374445],[207.646377,-12.078267],[206.486472,-10.328765],[205.640541,-8.321625],[205.062617,-5.914326],[204.706728,-2.964348],[204.477180,5.133735],[204.263969,12.643244],[203.553555,17.738792],[202.978718,19.515862],[202.239766,20.850879],[201.323427,21.797656],[200.216430,22.410005],[198.541130,22.883615],[196.822620,22.361495]]);
    linear_extrude(height=h)
      polygon([[225.208620,20.776865],[224.668759,18.626304],[224.197470,14.060369],[223.548805,0.801450],[223.439023,-12.761736],[223.641337,-17.708006],[224.044520,-20.391035],[224.941718,-21.994415],[226.107346,-23.112027],[227.445828,-23.748908],[228.861583,-23.910096],[230.259033,-23.600630],[231.542600,-22.825548],[232.616705,-21.589887],[233.385770,-19.898685],[234.227143,-15.779416],[234.745107,-10.378880],[234.879886,2.220637],[234.531238,8.396942],[233.928255,13.809158],[233.088206,17.945949],[232.028360,20.295975],[230.388885,21.496445],[228.486400,21.992219],[226.649960,21.760094],[225.208620,20.776865]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[282.912740,20.115685],[282.243089,18.273600],[281.802970,14.550406],[281.408280,-1.449825],[281.262080,-21.076165],[283.870970,-23.494005],[285.548927,-24.851901],[287.517930,-25.536955],[290.857296,-25.727122],[296.646340,-25.600355],[306.812810,-25.288885],[309.939900,-21.874435],[311.330058,-20.113029],[312.412186,-18.172484],[313.192797,-16.002962],[313.678403,-13.554625],[313.790643,-7.622159],[312.801000,0.023615],[311.862168,7.661036],[311.921510,13.845055],[312.099662,17.682856],[311.554274,20.221087],[310.985633,21.054116],[310.206564,21.623755],[307.977750,22.054865],[306.194434,21.580977],[304.610949,20.112086],[303.173847,17.577350],[301.829680,13.905925],[300.798027,11.414154],[299.532634,9.687507],[298.114604,8.717819],[296.625040,8.496930],[295.145047,9.016677],[293.755727,10.268898],[292.538183,12.245432],[291.573520,14.938115],[290.799339,17.269004],[289.855385,19.167652],[288.782486,20.609652],[287.621468,21.570596],[286.413157,22.026079],[285.198381,21.951693],[284.017967,21.323030],[282.912740,20.115685]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[301.290090,-3.960755],[302.911813,-6.343456],[303.512945,-8.707790],[303.090335,-10.971969],[301.640830,-13.054205],[299.583503,-14.764866],[297.848876,-15.307786],[296.215156,-14.677190],[294.460550,-12.867305],[293.238364,-10.363943],[292.876609,-7.485475],[293.361272,-4.859465],[293.916631,-3.837245],[294.678340,-3.113475],[296.340283,-2.463470],[298.152421,-2.408035],[299.880457,-2.917140],[301.290090,-3.960755]]);
    }
  }
}
module AK_Back(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    difference()
    {
       linear_extrude(height=h)
         polygon([[-63.824867,83.896692],[-64.503701,83.067392],[-65.043351,81.934113],[-65.801232,77.806081],[-66.290785,69.613519],[-66.704287,55.457352],[-67.678217,31.082352],[-69.006139,4.280621],[-70.507057,-40.760668],[-70.950812,-54.757330],[-71.502375,-63.266439],[-72.375694,-68.325251],[-73.784717,-71.971018],[-75.024286,-74.840396],[-75.544465,-77.034276],[-75.377785,-78.928879],[-74.556777,-80.900428],[-73.188697,-82.925276],[-71.528837,-84.267269],[-69.415032,-85.016262],[-66.685117,-85.262108],[-64.558396,-85.113025],[-62.666444,-84.496874],[-60.596723,-83.216106],[-57.936697,-81.073168],[-54.736385,-78.381458],[-52.775353,-77.179727],[-51.024248,-77.117484],[-48.453717,-77.844238],[-44.389847,-78.530752],[-39.218287,-78.791348],[-35.876038,-78.611846],[-32.731353,-78.018302],[-29.172190,-76.849858],[-24.586507,-74.945658],[-18.671425,-72.106397],[-14.548673,-69.280589],[-11.244840,-65.617761],[-7.786517,-60.267438],[-4.762197,-55.769618],[-1.776977,-52.441411],[1.068316,-50.376087],[2.406981,-49.846153],[3.672853,-49.666918],[6.873021,-50.193821],[11.335303,-51.460628],[16.220642,-52.942696],[20.476508,-53.859825],[24.245568,-54.185674],[27.670486,-53.893902],[30.893929,-52.958168],[34.058562,-51.352132],[37.307052,-49.049452],[40.782063,-46.023788],[47.365742,-40.179583],[50.022923,-38.268200],[52.600957,-36.877459],[55.357816,-35.892482],[58.551468,-35.198390],[67.281033,-34.223348],[70.416635,-33.792353],[72.790653,-33.063238],[74.423214,-31.972873],[75.334442,-30.458131],[75.544465,-28.455882],[75.073409,-25.902997],[73.941400,-22.736349],[72.168563,-18.892808],[69.289869,-12.485326],[67.012985,-6.206824],[65.516147,-0.617815],[64.977593,3.721192],[65.853165,10.163094],[67.958263,20.731812],[69.554740,28.436004],[70.462756,34.636349],[70.880246,41.245681],[71.005143,50.176832],[70.879338,63.361598],[70.218152,71.804027],[69.616282,74.707739],[68.795954,76.978916],[67.728966,78.801907],[66.387113,80.361062],[64.741324,81.840786],[63.228571,82.794741],[61.674767,83.306111],[59.905823,83.458082],[57.912100,83.225883],[55.894873,82.311539],[53.326269,80.388435],[49.678413,77.129952],[44.118625,72.394211],[38.999598,69.056677],[33.624357,66.741955],[27.295923,65.074652],[20.820066,64.166495],[13.824490,64.030904],[6.344423,64.666662],[-1.584907,66.072552],[-8.275995,67.170637],[-13.668200,67.185993],[-15.948629,66.779729],[-17.990026,66.093279],[-19.820955,65.123476],[-21.469977,63.867152],[-23.103733,62.216053],[-24.034759,60.318787],[-24.547431,57.184171],[-24.926127,51.821022],[-25.298323,46.763281],[-25.783677,43.564687],[-26.549710,41.523838],[-27.763947,39.939332],[-29.072883,38.751128],[-30.449962,38.009713],[-32.131270,37.628420],[-34.352897,37.520582],[-36.670385,37.749657],[-39.340074,38.390637],[-45.146413,40.630819],[-50.592641,43.686158],[-52.812191,45.346083],[-54.499487,47.001682],[-57.171617,50.176832],[-56.548947,66.021932],[-56.293122,79.504218],[-56.682431,82.181169],[-57.494637,83.600052],[-59.017441,84.806984],[-60.652049,85.262108],[-62.290509,84.960364],[-63.824867,83.896692]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[2.363153,51.570012],[2.408156,48.998018],[3.038147,46.241639],[4.012686,44.043340],[4.554024,43.385489],[5.091333,43.145582],[5.673115,42.725611],[5.915093,41.715892],[5.706642,41.095974],[5.122943,40.527207],[3.079733,39.719132],[0.508148,38.542766],[-1.671607,36.461322],[-3.226033,34.586579],[-4.527279,33.924013],[-5.840904,34.460857],[-7.432467,36.184342],[-9.425712,38.137074],[-11.551767,39.442392],[-13.031767,40.346716],[-13.582322,41.850348],[-13.223022,44.364862],[-11.973457,48.301832],[-10.319827,52.989332],[-6.186737,52.694162],[-3.642952,52.709180],[-1.029832,53.040122],[1.227984,53.608582],[2.705853,54.336152],[2.363153,51.570012]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[40.953723,50.880522],[41.139221,47.882044],[41.750373,45.610572],[42.212192,44.396676],[41.512013,44.569192],[40.771898,44.765167],[40.816253,43.979212],[41.591232,43.097653],[42.812873,42.807042],[44.144710,42.652931],[44.335940,42.372175],[44.230680,41.989746],[43.190594,41.022253],[41.144263,39.955222],[38.412205,38.296989],[36.348943,36.192642],[34.999213,34.455398],[34.388466,34.047922],[33.754107,33.954392],[32.215487,34.728716],[29.985213,36.817462],[27.352611,39.256622],[25.223963,40.842402],[24.326766,41.433587],[23.962025,42.043478],[24.097753,42.873144],[24.701963,44.123652],[25.744840,46.714139],[26.499963,49.708082],[26.897170,51.593187],[27.597533,52.568627],[29.091502,52.934107],[31.869523,52.989332],[35.480830,53.195877],[37.395733,53.692462],[38.330992,54.189202],[39.586973,54.396142],[40.281745,54.217196],[40.720112,53.625669],[40.953723,50.880522]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-51.610017,23.614492],[-50.910384,19.578622],[-50.494137,13.676554],[-50.448563,-1.439217],[-51.346813,-17.158893],[-52.110347,-23.815844],[-53.062407,-28.908548],[-54.687912,-34.981679],[-55.849447,-38.114306],[-56.339360,-38.726603],[-56.813041,-38.782181],[-57.844727,-37.461058],[-58.358766,-35.811738],[-58.621774,-33.099678],[-58.437277,-23.483018],[-57.348717,3.770582],[-56.852409,16.489927],[-56.300604,24.104444],[-55.557298,27.802030],[-55.071330,28.553192],[-54.486487,28.770582],[-53.804996,28.419214],[-53.076767,27.403926],[-51.610017,23.614492]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[1.567743,22.580662],[1.563026,20.091164],[2.197952,17.299204],[3.206909,15.023578],[3.768645,14.335264],[4.324283,14.083082],[4.667332,14.401023],[4.419283,15.165432],[4.219233,15.779163],[4.835243,15.577292],[5.294674,15.089838],[5.424970,14.447001],[4.835433,12.899598],[3.341187,11.343932],[1.216783,10.188852],[-1.112167,8.861651],[-2.950947,6.981692],[-4.273891,5.337957],[-5.508087,4.863628],[-6.915989,5.583054],[-8.760057,7.520582],[-10.786328,9.506908],[-12.334737,10.333082],[-13.538594,10.755554],[-14.736467,11.771292],[-15.276483,12.578131],[-15.459477,13.359186],[-14.757667,15.400282],[-13.734340,17.878087],[-12.920467,20.758942],[-12.459094,22.580486],[-11.728457,23.488614],[-10.218779,23.749279],[-7.420287,23.628432],[-3.514158,23.703508],[-0.913037,24.303052],[0.667465,25.094602],[1.535085,25.121837],[1.798814,24.309079],[1.567643,22.580652]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[40.751073,18.170532],[40.749450,13.155416],[41.147553,12.435123],[41.892933,12.502622],[43.074602,12.657709],[43.862453,12.242692],[43.800862,11.838565],[43.258073,11.345129],[41.092463,10.340062],[38.282913,8.788953],[36.194203,6.514492],[34.800292,4.608247],[33.485585,3.910269],[32.095130,4.409153],[30.473973,6.093492],[28.461015,8.008747],[26.187183,9.351542],[24.577324,10.327965],[23.870470,11.721141],[24.058637,13.581152],[25.133843,15.958082],[26.089848,18.387551],[26.506873,20.937402],[26.604186,22.417868],[27.077023,23.139558],[28.269186,23.280638],[30.524473,23.019272],[34.164607,22.888023],[37.321343,23.350002],[40.602593,24.316972],[40.839572,22.545508],[40.751073,18.170532]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-7.868197,-5.688648],[-5.323343,-6.240223],[-2.099867,-5.736848],[1.426043,-4.763308],[0.785613,-9.033988],[0.528015,-12.241767],[0.778218,-12.724662],[1.299993,-12.590958],[1.985388,-12.345372],[1.749363,-13.018678],[1.693792,-14.317696],[2.565663,-15.841608],[3.580285,-17.421158],[3.391845,-17.996329],[2.753153,-18.630448],[1.177740,-19.534424],[-0.736337,-20.152838],[-2.844125,-21.180461],[-4.885307,-23.068288],[-6.879047,-25.568678],[-8.919487,-23.378548],[-10.959907,-20.586078],[-11.633775,-19.800059],[-13.253927,-18.756048],[-15.078595,-17.486644],[-16.004660,-16.056988],[-16.063717,-14.367029],[-15.287357,-12.316718],[-12.960667,-7.245058],[-12.150461,-5.588062],[-11.224372,-4.835231],[-9.893312,-4.898215],[-7.868197,-5.688668]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[51.222163,-6.753648],[54.810483,-6.635458],[54.503413,-11.041818],[54.415174,-13.375235],[54.618160,-14.840549],[55.214350,-15.739443],[56.305723,-16.373598],[57.846855,-17.252965],[58.331081,-18.005971],[57.764868,-18.531745],[56.154683,-18.729418],[55.051193,-18.933352],[53.850820,-19.512899],[51.474363,-21.605318],[49.054443,-24.481228],[44.594143,-21.385488],[39.764463,-18.062068],[41.005700,-12.651059],[43.154563,-6.269408],[44.046460,-5.943251],[45.603373,-6.200008],[48.091461,-6.639779],[51.222163,-6.753668]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-27.366157,-27.455738],[-23.381777,-26.765148],[-21.621486,-26.428685],[-20.716815,-26.636627],[-20.382908,-27.675792],[-20.334907,-29.832998],[-20.199304,-31.699392],[-19.774563,-33.369792],[-19.033781,-34.918495],[-17.950057,-36.419798],[-15.565197,-39.254028],[-19.003527,-39.899068],[-20.649372,-40.344872],[-21.990302,-41.024377],[-23.078586,-41.972605],[-23.966497,-43.224578],[-25.350754,-45.108017],[-26.738000,-45.779059],[-28.230988,-45.242506],[-29.932467,-43.503158],[-31.956855,-41.538588],[-34.157787,-40.204798],[-35.322128,-39.655463],[-35.937554,-39.010289],[-36.086866,-38.100968],[-35.852867,-36.759188],[-34.691567,-31.385668],[-34.018242,-28.900685],[-33.086309,-27.340739],[-31.854283,-26.662931],[-30.280677,-26.824358],[-27.366157,-27.455738]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-36.095267,-52.017478],[-35.930205,-54.834788],[-35.032194,-57.458682],[-33.738825,-59.214456],[-33.049377,-59.555954],[-32.387687,-59.427408],[-32.039998,-59.302770],[-31.939325,-59.503309],[-32.475887,-60.830038],[-33.501305,-62.089521],[-34.018727,-62.345661],[-34.452797,-62.288908],[-35.906608,-61.993036],[-37.581137,-62.557096],[-39.209668,-63.832549],[-40.525487,-65.670858],[-41.769175,-67.610262],[-42.765207,-68.416918],[-44.266665,-67.497311],[-46.725507,-65.286338],[-49.333614,-62.946991],[-51.193927,-61.718738],[-51.808212,-61.277358],[-51.959498,-60.300806],[-50.793827,-55.513378],[-49.065927,-49.745028],[-42.903537,-49.420848],[-36.226257,-48.913038],[-35.975389,-49.749226],[-36.095247,-52.017478]]);
    }
  }
}
module AL_Stat(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    difference()
    {
       linear_extrude(height=h)
         polygon([[-277.606971,73.750010],[-278.174443,72.867197],[-279.538791,72.500010],[-281.804416,71.598722],[-284.538794,69.431810],[-286.190529,67.471501],[-287.114956,65.142660],[-287.518348,61.520894],[-287.606974,55.681810],[-287.540485,49.857943],[-287.221338,46.647722],[-286.470008,45.284096],[-285.106974,45.000010],[-283.341347,44.632822],[-282.804237,44.235362],[-282.606971,43.750010],[-281.978421,43.256854],[-280.249020,42.860260],[-274.425161,42.500010],[-270.075904,42.609207],[-267.154800,43.046885],[-265.056376,43.978176],[-263.175161,45.568210],[-261.637432,47.387719],[-260.700333,49.363435],[-260.233601,51.915488],[-260.106971,55.464010],[-260.509481,60.562535],[-260.974608,62.095519],[-261.581861,62.783310],[-262.096687,63.140152],[-262.392495,63.746022],[-262.246091,65.387410],[-261.764164,66.166784],[-261.031520,66.774907],[-259.125606,67.436160],[-257.151405,67.288688],[-256.333401,66.885905],[-255.731971,66.250010],[-255.141928,65.764658],[-254.106468,65.367198],[-251.283201,65.000010],[-248.686862,64.632823],[-247.897048,64.235362],[-247.606971,63.750010],[-247.431480,63.264658],[-246.953657,62.867198],[-245.382921,62.500010],[-244.377187,62.302744],[-243.282882,61.765635],[-241.356971,60.000010],[-239.602418,58.234385],[-237.914361,57.500010],[-236.913457,57.148726],[-235.483900,56.206591],[-232.031838,53.220085],[-228.944190,49.881116],[-227.970151,48.498404],[-227.606971,47.530310],[-226.505408,45.457323],[-223.856971,42.303210],[-221.208533,39.035573],[-220.106971,36.689610],[-219.739783,35.496323],[-218.856971,35.000010],[-218.371619,34.802744],[-217.974158,34.265635],[-217.606971,32.500010],[-217.239783,30.734385],[-216.842323,30.197276],[-216.356971,30.000010],[-215.871619,29.802744],[-215.474158,29.265635],[-215.106971,27.500010],[-214.739783,25.734385],[-214.342323,25.197276],[-213.856971,25.000010],[-213.371619,24.802744],[-212.974158,24.265635],[-212.606971,22.500010],[-212.239783,20.734385],[-211.842323,20.197276],[-211.356971,20.000010],[-210.871619,19.802744],[-210.474158,19.265635],[-210.106971,17.500010],[-209.739783,15.734385],[-209.342323,15.197276],[-208.856971,15.000010],[-208.371619,14.802744],[-207.974158,14.265635],[-207.606971,12.500010],[-207.239783,10.734385],[-206.842323,10.197276],[-206.356971,10.000010],[-205.871619,9.802744],[-205.474158,9.265635],[-205.106971,7.500010],[-204.739783,5.734385],[-204.342323,5.197276],[-203.856971,5.000010],[-203.371619,4.704112],[-202.974158,3.898448],[-202.606971,1.250010],[-202.239783,-1.398427],[-201.842323,-2.204092],[-201.356971,-2.499990],[-200.871619,-2.697256],[-200.474158,-3.234365],[-200.106971,-4.999990],[-199.739783,-6.765615],[-199.342323,-7.302724],[-198.856971,-7.499990],[-198.371619,-7.697256],[-197.974158,-8.234365],[-197.606971,-9.999990],[-197.239783,-11.765615],[-196.842323,-12.302724],[-196.356971,-12.499990],[-195.871619,-12.697256],[-195.474158,-13.234365],[-195.106971,-14.999990],[-194.739783,-16.765615],[-194.342323,-17.302724],[-193.856971,-17.499990],[-192.974158,-17.981540],[-192.606971,-19.139290],[-191.872596,-21.085327],[-190.106971,-23.462090],[-188.341346,-25.842299],[-187.606971,-27.796800],[-186.872596,-29.492344],[-185.106971,-31.250010],[-183.341346,-33.014979],[-182.606971,-34.728100],[-181.708937,-36.250859],[-179.325283,-39.085968],[-171.963813,-46.824950],[-164.247958,-54.208485],[-161.421321,-56.599284],[-159.903111,-57.500010],[-158.598096,-58.004156],[-157.011158,-59.201542],[-155.671162,-60.619590],[-155.106971,-61.785720],[-156.208533,-62.290191],[-158.856971,-62.500010],[-161.505408,-62.867197],[-162.311073,-63.264658],[-162.606971,-63.750010],[-163.583534,-64.264922],[-166.356972,-64.659099],[-176.356971,-65.000010],[-186.356973,-64.659099],[-189.130409,-64.264922],[-190.106971,-63.750010],[-190.305792,-63.264658],[-190.847133,-62.867197],[-192.626661,-62.500010],[-196.061836,-62.027337],[-200.186928,-60.901685],[-203.651965,-59.561608],[-204.715095,-58.948209],[-205.106971,-58.445660],[-205.841346,-57.777794],[-207.606971,-57.500010],[-209.372596,-57.194870],[-209.909705,-56.864573],[-210.106971,-56.461240],[-211.116738,-55.206572],[-213.544471,-53.648740],[-215.764154,-52.132703],[-218.813779,-49.562641],[-226.014758,-42.670384],[-232.371219,-35.791850],[-234.365196,-33.238942],[-235.106971,-31.746920],[-235.406036,-30.513165],[-236.125071,-30.000010],[-236.821722,-29.574104],[-237.752266,-28.427101],[-239.912152,-24.754075],[-241.798973,-20.549487],[-242.606971,-17.381890],[-242.974158,-15.699690],[-243.371619,-15.187943],[-243.856971,-14.999990],[-244.342323,-14.561971],[-244.739783,-13.369340],[-245.106971,-9.448790],[-245.474158,-5.301277],[-245.871619,-3.862982],[-246.356971,-3.124990],[-246.842323,-2.534954],[-247.239783,-1.499503],[-247.606971,1.323810],[-247.239783,3.920122],[-246.842323,4.709933],[-246.356971,5.000010],[-245.868687,5.585943],[-245.471552,7.187498],[-245.106971,12.500010],[-244.742390,17.812485],[-244.345255,19.414063],[-243.856971,20.000010],[-243.371619,20.295908],[-242.974158,21.101572],[-242.606971,23.750010],[-242.239783,26.398447],[-241.842323,27.204112],[-241.356971,27.500010],[-240.871619,27.894541],[-240.474158,28.968760],[-240.106971,32.500010],[-240.185096,35.390635],[-240.731971,36.875010],[-242.216346,37.421885],[-245.106971,37.500010],[-247.880412,37.412110],[-249.377807,36.953110],[-249.989785,35.830060],[-250.106971,33.750010],[-250.474158,31.101572],[-250.871619,30.295908],[-251.356971,30.000010],[-251.842323,29.660610],[-252.239783,28.736510],[-252.606971,25.698810],[-252.974158,22.434110],[-253.371619,21.264369],[-253.856971,20.625010],[-254.365623,18.958354],[-254.760495,14.910335],[-255.106971,1.250010],[-254.760495,-12.410353],[-254.365623,-16.458376],[-253.856971,-18.124990],[-253.371619,-18.764349],[-252.974158,-19.934090],[-252.606971,-23.198790],[-252.239783,-26.236526],[-251.842323,-27.160617],[-251.356971,-27.500010],[-250.871619,-27.727995],[-250.474158,-28.348744],[-250.106971,-30.389310],[-249.372596,-33.218134],[-247.606971,-35.962050],[-245.841346,-38.260501],[-245.106971,-40.018360],[-244.321650,-41.454137],[-242.233922,-43.988609],[-235.760652,-50.763066],[-228.905980,-57.160583],[-226.341497,-59.223879],[-224.888721,-60.000010],[-223.137707,-60.734385],[-221.356971,-62.500010],[-219.431063,-64.265635],[-218.336759,-64.802744],[-217.331021,-65.000010],[-215.760288,-65.367197],[-215.282463,-65.764658],[-215.106971,-66.250010],[-214.909705,-66.735362],[-214.372596,-67.132822],[-212.606971,-67.500010],[-210.841346,-67.777794],[-210.106971,-68.445660],[-209.715095,-68.948209],[-208.651965,-69.561608],[-205.186928,-70.901685],[-201.061836,-72.027337],[-197.626661,-72.500010],[-195.847133,-72.867197],[-195.305792,-73.264658],[-195.106971,-73.750010],[-193.583534,-74.277355],[-189.169472,-74.670150],[-172.606971,-75.000010],[-156.044473,-74.670150],[-151.630409,-74.277355],[-150.106971,-73.750010],[-149.819293,-73.264658],[-149.036010,-72.867197],[-146.461141,-72.500010],[-143.672085,-72.041027],[-142.656946,-71.544202],[-142.086141,-70.937510],[-141.356976,-70.000010],[-140.627811,-70.937510],[-140.112143,-71.544202],[-139.247131,-72.041027],[-136.951571,-72.500010],[-134.643282,-72.867197],[-133.231971,-73.750010],[-132.444663,-74.235362],[-130.872093,-74.632822],[-126.283201,-75.000010],[-122.871126,-74.922280],[-121.019940,-74.524874],[-120.256327,-73.561463],[-120.106971,-71.785720],[-120.556985,-69.199539],[-121.768318,-67.036497],[-123.532908,-65.551639],[-125.642691,-65.000010],[-127.192585,-64.742617],[-127.357392,-64.317847],[-127.058862,-63.604110],[-124.902054,-61.034993],[-120.382691,-56.485770],[-117.347823,-53.231630],[-114.424990,-49.627858],[-111.946807,-46.112851],[-110.245891,-43.125010],[-106.220171,-34.704470],[-105.710677,-32.012416],[-105.357354,-26.819045],[-105.107790,-12.454696],[-105.448616,1.335885],[-105.833282,5.812048],[-106.356971,7.500010],[-106.842323,7.894541],[-107.239783,8.968760],[-107.606971,12.500010],[-107.974158,16.031260],[-108.371619,17.105479],[-108.856971,17.500010],[-109.342323,17.894541],[-109.739783,18.968760],[-110.106971,22.500010],[-110.474158,26.031260],[-110.871619,27.105479],[-111.356971,27.500010],[-111.842323,27.894541],[-112.239783,28.968760],[-112.606971,32.500010],[-112.974158,36.031260],[-113.371619,37.105479],[-113.856971,37.500010],[-114.342323,37.894541],[-114.739783,38.968760],[-115.106971,42.500010],[-115.474158,46.031260],[-115.871619,47.105479],[-116.356971,47.500010],[-116.842323,47.894541],[-117.239783,48.968760],[-117.606971,52.500010],[-117.974158,56.031260],[-118.371619,57.105479],[-118.856971,57.500010],[-119.451010,57.661522],[-119.844583,58.104785],[-120.053547,59.588935],[-119.530296,61.457198],[-118.321261,63.214310],[-117.275638,63.907649],[-115.748711,64.475447],[-112.071261,65.000010],[-109.528013,65.092197],[-108.198491,65.662510],[-107.689282,67.151572],[-107.606971,70.000010],[-107.606971,75.000010],[-133.856971,75.000010],[-160.106971,75.000010],[-160.106971,70.000010],[-160.106971,65.000010],[-154.429711,65.000010],[-151.754610,64.855118],[-149.510668,64.413723],[-147.663218,63.665746],[-146.177591,62.601110],[-143.778553,59.870994],[-141.852945,56.713210],[-140.572004,53.469626],[-140.106971,50.482110],[-139.716522,48.375985],[-139.293879,47.735310],[-138.777771,47.500010],[-138.285367,47.186137],[-137.946535,46.324472],[-137.840271,43.437510],[-138.231971,39.375010],[-169.653611,39.375010],[-201.075241,39.375010],[-205.591111,44.306810],[-208.780440,48.097510],[-210.106971,50.285910],[-211.436226,52.393477],[-214.466064,55.667172],[-217.759589,58.678762],[-219.879911,60.000010],[-221.813900,61.101572],[-224.910201,63.750010],[-228.235664,66.398447],[-229.678525,67.204112],[-230.720601,67.500010],[-232.052849,67.867197],[-232.606971,68.750010],[-232.804237,69.235362],[-233.341346,69.632822],[-235.106971,70.000010],[-236.872596,70.367197],[-237.409705,70.764658],[-237.606971,71.250010],[-237.798415,71.735362],[-238.319675,72.132822],[-240.033201,72.500010],[-241.973656,72.867197],[-243.231971,73.750010],[-244.783494,74.254557],[-248.494075,74.649885],[-260.805751,75.000010],[-273.094170,74.664247],[-276.439709,74.270715],[-277.606971,73.750010]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-134.392691,28.214310],[-133.699332,27.168658],[-133.131528,25.641722],[-132.606971,21.964310],[-132.239783,18.811385],[-131.842323,17.852266],[-131.356971,17.500010],[-130.871619,17.160610],[-130.474158,16.236510],[-130.106971,13.198810],[-129.739783,9.934110],[-129.342323,8.764369],[-128.856971,8.125010],[-128.371619,7.436327],[-127.974158,6.132298],[-127.606971,2.426210],[-127.239783,-1.052915],[-126.842323,-2.111281],[-126.356971,-2.499990],[-125.871619,-2.888699],[-125.474158,-3.947065],[-125.106971,-7.426190],[-124.739783,-11.132315],[-124.342323,-12.436321],[-123.856971,-13.124990],[-122.974158,-14.728840],[-122.606971,-17.499990],[-122.974158,-20.271178],[-123.856971,-21.874990],[-124.739783,-23.478831],[-125.106971,-26.250010],[-125.474158,-29.021179],[-126.356971,-30.625010],[-127.239783,-32.066920],[-127.606971,-34.448790],[-127.974158,-36.603714],[-128.371619,-37.259250],[-128.856971,-37.500010],[-129.739783,-38.050369],[-130.106971,-39.373580],[-130.501502,-40.507592],[-131.575721,-42.210237],[-135.106971,-46.399310],[-138.638221,-50.544522],[-139.712440,-52.199692],[-140.106971,-53.275730],[-140.663678,-54.493501],[-142.002141,-55.000010],[-143.549326,-54.219783],[-146.194118,-52.143437],[-153.168976,-45.688409],[-159.711624,-38.806958],[-161.816153,-36.197585],[-162.606971,-34.671120],[-163.341346,-32.998245],[-165.106971,-31.250010],[-166.872596,-29.405160],[-167.606971,-27.500010],[-168.341346,-25.594857],[-170.106971,-23.749990],[-171.872596,-21.824115],[-172.409705,-20.729815],[-172.606971,-19.724090],[-172.974158,-18.153302],[-173.371619,-17.675479],[-173.856971,-17.499990],[-174.342323,-17.302724],[-174.739783,-16.765615],[-175.106971,-14.999990],[-175.474158,-13.234365],[-175.871619,-12.697256],[-176.356971,-12.499990],[-176.842323,-12.302724],[-177.239783,-11.765615],[-177.606971,-9.999990],[-177.974158,-8.234365],[-178.371619,-7.697256],[-178.856971,-7.499990],[-179.342323,-7.302724],[-179.739783,-6.765615],[-180.106971,-4.999990],[-180.474158,-3.234365],[-180.871619,-2.697256],[-181.356971,-2.499990],[-181.842323,-2.302724],[-182.239783,-1.765615],[-182.606971,0.000010],[-182.974158,1.765635],[-183.371619,2.302744],[-183.856971,2.500010],[-184.342323,2.795908],[-184.739783,3.601572],[-185.106971,6.250010],[-185.474158,8.898447],[-185.871619,9.704112],[-186.356971,10.000010],[-186.842323,10.197276],[-187.239783,10.734385],[-187.606971,12.500010],[-187.974158,14.265635],[-188.371619,14.802744],[-188.856971,15.000010],[-189.342323,15.295908],[-189.739783,16.101572],[-190.106971,18.750010],[-190.474158,21.398447],[-190.871619,22.204112],[-191.356971,22.500010],[-191.842323,22.697276],[-192.239783,23.234385],[-192.606971,25.000010],[-192.974158,26.765635],[-193.371619,27.302744],[-193.856971,27.500010],[-194.739783,27.867197],[-195.106971,28.750010],[-193.148266,29.281979],[-187.428401,29.674260],[-165.642691,30.000010],[-141.609276,29.649635],[-136.529207,29.103610],[-135.171796,28.706372],[-134.392691,28.214310]]);
    }
    linear_extrude(height=h)
      polygon([[-101.044471,73.130210],[-101.687267,71.402354],[-102.170346,68.204833],[-102.631796,59.496747],[-102.377708,51.197843],[-101.966366,48.511799],[-101.686824,47.763874],[-101.356971,47.500010],[-100.871619,47.160610],[-100.474158,46.236510],[-100.106971,43.198810],[-99.739783,39.934110],[-99.342323,38.764369],[-98.856971,38.125010],[-98.371619,37.534960],[-97.974158,36.499485],[-97.606971,33.676210],[-97.239783,31.079898],[-96.842323,30.290087],[-96.356971,30.000010],[-95.871619,29.605479],[-95.474158,28.531260],[-95.106971,25.000010],[-94.739783,21.468760],[-94.342323,20.394541],[-93.856971,20.000010],[-93.371619,19.660610],[-92.974158,18.736510],[-92.606971,15.698810],[-92.239783,12.434110],[-91.842323,11.264369],[-91.356971,10.625010],[-90.871619,10.034960],[-90.474158,8.999485],[-90.106971,6.176210],[-89.739783,3.579898],[-89.342323,2.790087],[-88.856971,2.500010],[-88.371619,2.105479],[-87.974158,1.031260],[-87.606971,-2.499990],[-87.239783,-6.031240],[-86.842323,-7.105459],[-86.356971,-7.499990],[-85.871619,-7.894521],[-85.474158,-8.968740],[-85.106971,-12.499990],[-84.739783,-16.031240],[-84.342323,-17.105459],[-83.856971,-17.499990],[-83.371619,-17.790067],[-82.974158,-18.579878],[-82.606971,-21.176190],[-82.239783,-23.999513],[-81.842323,-25.034971],[-81.356971,-25.625010],[-80.871619,-26.363002],[-80.474158,-27.801294],[-80.106971,-31.948780],[-79.739783,-35.869337],[-79.342323,-37.061984],[-78.856971,-37.500010],[-78.371619,-37.839403],[-77.974158,-38.763495],[-77.606971,-41.801240],[-77.239783,-45.065914],[-76.842323,-46.235651],[-76.356971,-46.875010],[-75.871619,-47.465052],[-75.474158,-48.500512],[-75.106971,-51.323780],[-74.739783,-53.920119],[-74.342323,-54.709933],[-73.856971,-55.000010],[-73.371619,-55.295908],[-72.974158,-56.101572],[-72.606971,-58.750010],[-72.606971,-62.500010],[-63.856971,-62.500010],[-55.106971,-62.500010],[-55.106971,-55.698780],[-55.474158,-50.668481],[-55.871619,-48.961635],[-56.356971,-48.125010],[-57.239783,-46.521179],[-57.606971,-43.750010],[-57.974158,-40.978841],[-58.856971,-39.375010],[-59.342323,-38.735651],[-59.739783,-37.565914],[-60.106971,-34.301240],[-60.474158,-31.263495],[-60.871619,-30.339403],[-61.356971,-30.000010],[-61.842323,-29.704112],[-62.239783,-28.898447],[-62.606971,-26.250010],[-62.933990,-23.601555],[-63.287966,-22.795889],[-63.720211,-22.499990],[-64.212573,-22.154782],[-64.730210,-21.214853],[-65.595211,-18.124990],[-67.118741,-9.374990],[-67.983742,-6.285165],[-68.501379,-5.345212],[-68.993741,-4.999990],[-69.425985,-4.605459],[-69.779957,-3.531240],[-70.106971,0.000010],[-70.474158,3.531260],[-70.871619,4.605479],[-71.356971,5.000010],[-71.842323,5.339396],[-72.239783,6.263473],[-72.606971,9.301210],[-72.974158,12.565910],[-73.371619,13.735651],[-73.856971,14.375010],[-74.739783,15.978822],[-75.106971,18.750010],[-75.474158,21.521160],[-76.356971,23.125010],[-76.842323,23.764369],[-77.239783,24.934110],[-77.606971,28.198810],[-77.974158,31.236510],[-78.371619,32.160610],[-78.856971,32.500010],[-79.342323,32.894541],[-79.739783,33.968760],[-80.106971,37.500010],[-80.474158,41.031260],[-80.871619,42.105479],[-81.356971,42.500010],[-81.842323,42.839396],[-82.239783,43.763473],[-82.606971,46.801210],[-82.974158,50.065910],[-83.371619,51.235651],[-83.856971,51.875010],[-84.347854,52.483850],[-84.719115,53.526169],[-85.081220,56.276735],[-84.900188,58.857688],[-84.592527,59.687992],[-84.132921,60.000010],[-82.915695,59.265635],[-81.356971,57.500010],[-80.373093,56.490030],[-79.087231,55.699472],[-77.617252,55.184183],[-76.081021,55.000010],[-74.236166,55.127232],[-73.186847,55.677810],[-72.716485,56.905113],[-72.608501,59.062510],[-72.815633,60.832541],[-73.389143,62.681787],[-75.352498,66.229298],[-77.932957,68.927790],[-79.277848,69.715762],[-80.564911,70.000010],[-82.007118,70.367197],[-82.606971,71.250010],[-82.804237,71.735362],[-83.341346,72.132822],[-85.106971,72.500010],[-86.872596,72.867197],[-87.409705,73.264658],[-87.606971,73.750010],[-88.110994,74.366343],[-89.455028,74.761193],[-93.654913,74.932947],[-98.190203,74.358283],[-99.953491,73.820110],[-101.044471,73.130210]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[-60.106971,73.750010],[-60.683981,72.867197],[-62.071261,72.500010],[-63.983086,71.975447],[-65.821261,70.714310],[-67.082418,68.876097],[-67.606971,66.964310],[-67.974158,65.577010],[-68.856971,65.000010],[-69.349262,64.379618],[-69.745952,62.674697],[-70.106971,56.948810],[-69.739783,51.035672],[-69.342323,49.060268],[-68.856971,48.125010],[-67.974158,46.866673],[-67.606971,44.926210],[-67.239783,43.212710],[-66.842323,42.691454],[-66.356971,42.500010],[-65.474158,41.936985],[-65.106971,40.583310],[-64.765044,39.497158],[-63.834055,37.956722],[-60.773641,34.333310],[-57.150206,31.272922],[-55.609776,30.341937],[-54.523641,30.000010],[-53.169992,29.632822],[-52.606971,28.750010],[-51.708533,28.238291],[-49.169471,27.843760],[-40.106971,27.500010],[-31.044471,27.843760],[-28.505408,28.238291],[-27.606971,28.750010],[-26.864784,29.252912],[-24.794473,29.648422],[-17.606971,30.000010],[-7.606971,30.000010],[-7.606971,33.750010],[-7.974158,36.398447],[-8.371619,37.204112],[-8.856971,37.500010],[-9.342323,37.894541],[-9.739783,38.968760],[-10.106971,42.500010],[-10.474158,46.031260],[-10.871619,47.105479],[-11.356971,47.500010],[-11.842323,47.825491],[-12.239783,48.711710],[-12.606971,51.625010],[-13.041478,54.972760],[-14.086141,57.229110],[-14.882223,58.522398],[-14.719071,59.554610],[-14.205691,59.670088],[-13.433440,59.358985],[-11.530791,57.700410],[-10.360746,56.649752],[-8.910686,55.791348],[-7.362444,55.212374],[-5.897851,55.000010],[-4.146047,55.136449],[-3.152318,55.731898],[-2.708636,57.065552],[-2.606971,59.416610],[-2.818696,61.741383],[-3.532683,63.815498],[-4.867149,65.877668],[-6.940311,68.166610],[-10.563746,71.227085],[-12.104176,72.158082],[-13.190311,72.500010],[-14.543951,72.867198],[-15.106971,73.750010],[-15.662541,74.235362],[-17.175231,74.632823],[-22.147851,75.000010],[-25.768787,74.882251],[-28.303802,74.451610],[-30.146667,73.592044],[-31.691151,72.187510],[-33.716656,70.449623],[-34.353998,70.417393],[-34.754441,70.937510],[-35.259892,71.544210],[-36.221517,72.041035],[-38.961141,72.500010],[-41.536010,72.867198],[-42.319293,73.264658],[-42.606971,73.750010],[-43.271033,74.246668],[-45.106971,74.642873],[-51.356971,75.000010],[-57.606971,74.642873],[-59.442908,74.246668],[-60.106971,73.750010]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-41.503601,62.725710],[-39.433247,60.881160],[-37.294471,59.639910],[-35.749551,58.585572],[-35.106971,57.190210],[-34.372596,55.503822],[-32.606971,53.750010],[-31.417900,52.475446],[-30.581849,50.721532],[-30.096451,48.638456],[-29.959341,46.376410],[-30.168154,44.085582],[-30.720523,41.916163],[-31.614084,40.018342],[-32.846471,38.542310],[-35.169868,37.031772],[-36.179106,36.702640],[-36.908971,36.736610],[-40.671893,38.483332],[-43.208568,39.973910],[-44.642508,41.295813],[-45.097221,42.536510],[-45.838346,44.415872],[-47.606971,46.250010],[-48.577674,47.168626],[-49.372596,48.337835],[-49.909705,49.607432],[-50.106971,50.827210],[-50.474158,53.014172],[-51.356971,54.375010],[-52.361597,55.482168],[-52.439071,57.018747],[-51.580680,59.024283],[-49.777711,61.538310],[-47.492956,63.853902],[-45.455387,64.808872],[-44.481000,64.783059],[-43.510453,64.425412],[-41.503601,62.725710]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[12.393029,73.750010],[11.825557,72.867197],[10.461209,72.500010],[8.195584,71.598722],[5.461209,69.431810],[3.294307,66.697435],[2.393029,64.431810],[2.025842,63.067472],[1.143029,62.500010],[0.646375,61.835947],[0.250170,60.000010],[-0.106971,53.750010],[0.250170,47.500010],[0.646375,45.664072],[1.143029,45.000010],[1.628381,44.660610],[2.025842,43.736510],[2.393029,40.698810],[2.760217,37.434110],[3.157677,36.264369],[3.643029,35.625010],[4.128381,35.034960],[4.525842,33.999485],[4.893029,31.176210],[5.260217,28.579898],[5.657677,27.790087],[6.143029,27.500010],[6.628381,27.105479],[7.025842,26.031260],[7.393029,22.500010],[7.760217,18.968760],[8.157677,17.894541],[8.643029,17.500010],[9.128381,17.105479],[9.525842,16.031260],[9.893029,12.500010],[10.260217,8.968760],[10.657677,7.894541],[11.143029,7.500010],[11.628381,7.209933],[12.025842,6.420122],[12.393029,3.823810],[12.760217,1.000497],[13.157677,-0.034954],[13.643029,-0.624990],[14.128381,-1.264349],[14.525842,-2.434090],[14.893029,-5.698790],[15.260217,-8.736527],[15.657677,-9.660604],[16.143029,-9.999990],[16.628381,-10.394521],[17.025842,-11.468740],[17.393029,-14.999990],[17.760217,-18.531240],[18.157677,-19.605459],[18.643029,-19.999990],[19.128381,-20.394522],[19.525842,-21.468742],[19.893029,-25.000010],[20.260217,-28.531260],[20.657677,-29.605479],[21.143029,-30.000010],[21.628381,-30.394541],[22.025842,-31.468760],[22.393029,-35.000010],[22.760217,-38.531260],[23.157677,-39.605479],[23.643029,-40.000010],[24.128381,-40.394541],[24.525842,-41.468760],[24.893029,-45.000010],[25.260217,-48.531260],[25.657677,-49.605479],[26.143029,-50.000010],[26.631516,-50.320566],[27.037515,-51.193368],[27.432779,-54.062510],[27.566929,-56.394936],[27.959092,-58.275383],[28.669319,-59.747306],[29.757667,-60.854161],[31.284187,-61.639403],[33.308935,-62.146489],[39.093329,-62.500010],[47.393029,-62.500010],[47.393029,-57.573780],[47.025842,-53.867700],[46.628381,-52.563685],[46.143029,-51.875010],[45.657677,-51.235651],[45.260217,-50.065912],[44.893029,-46.801230],[44.525842,-43.763494],[44.128381,-42.839403],[43.643029,-42.500010],[43.157677,-42.160617],[42.760217,-41.236525],[42.393029,-38.198780],[42.025842,-34.934106],[41.628381,-33.764369],[41.143029,-33.125010],[40.657677,-32.534967],[40.260217,-31.499506],[39.893029,-28.676230],[39.525842,-26.079900],[39.128381,-25.290087],[38.643029,-25.000010],[38.157677,-24.704108],[37.760217,-23.898438],[37.393029,-21.249990],[37.025842,-18.601553],[36.628381,-17.795888],[36.143029,-17.499990],[35.657677,-17.105459],[35.260217,-16.031240],[34.893029,-12.499990],[34.525842,-8.968740],[34.128381,-7.894521],[33.643029,-7.499990],[33.157677,-7.105459],[32.760217,-6.031240],[32.393029,-2.499990],[32.025842,1.031260],[31.628381,2.105479],[31.143029,2.500010],[30.657677,2.790087],[30.260217,3.579898],[29.893029,6.176210],[29.525842,8.999485],[29.128381,10.034960],[28.643029,10.625010],[28.157677,11.258547],[27.760217,12.412435],[27.393029,15.625010],[27.025842,18.837585],[26.628381,19.991472],[26.143029,20.625010],[25.260217,22.066922],[24.893029,24.448810],[25.086555,26.189708],[25.505890,26.731050],[26.297987,27.098097],[29.473604,27.444643],[35.559689,27.500010],[41.734830,27.576999],[45.398530,28.066422],[47.892809,29.355965],[50.559689,31.833310],[53.037066,34.500202],[54.326619,36.994473],[54.816042,40.658162],[54.893029,46.833310],[54.543905,54.520835],[54.148702,56.716154],[53.643029,57.500010],[52.760217,58.093060],[52.393029,59.518910],[52.025290,60.639555],[51.035163,62.141491],[47.866279,65.634935],[44.243450,68.690641],[42.685892,69.645405],[41.523749,70.000010],[40.372052,70.367197],[39.893029,71.250010],[39.597131,71.735362],[38.791467,72.132822],[36.143029,72.500010],[33.494592,72.867197],[32.688927,73.264658],[32.393029,73.750010],[31.650841,74.252912],[29.580528,74.648422],[22.393029,75.000010],[15.205527,74.648422],[13.135216,74.252912],[12.393029,73.750010]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[29.012339,62.177210],[31.573635,59.136549],[33.721873,55.782247],[35.402694,52.315952],[36.561742,48.939310],[37.144656,45.853968],[37.097081,43.261572],[36.364658,41.363771],[35.724642,40.738357],[34.893029,40.362210],[33.127404,39.576097],[32.393029,38.604210],[32.209320,37.868122],[31.690252,37.495704],[29.838400,37.765810],[27.222196,39.262391],[24.226359,41.833310],[21.165945,45.456722],[20.234956,46.997158],[19.893029,48.083310],[19.525842,49.436985],[18.643029,50.000010],[18.070505,50.505977],[17.679854,51.855290],[17.425439,56.072422],[17.842319,60.628349],[18.290787,62.401154],[18.893029,63.500010],[19.886005,64.250633],[21.053044,64.726952],[23.716580,64.881872],[26.498168,64.015162],[29.012339,62.177210]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[63.955529,70.574610],[61.086387,67.082735],[60.213585,65.640894],[59.893029,64.660510],[59.480417,63.075160],[58.488399,61.595410],[57.972456,60.249531],[57.881056,57.922497],[58.714644,51.592635],[60.474685,45.141160],[61.541350,42.662111],[62.646699,41.103410],[64.233169,39.233473],[64.893029,37.576610],[65.408563,35.985752],[66.681368,34.329297],[68.300745,33.027349],[69.855999,32.500010],[71.627045,31.765635],[73.930989,30.000010],[75.739140,28.711255],[78.232463,27.951672],[82.155733,27.591258],[88.253729,27.500010],[96.670704,27.846047],[99.048385,28.240865],[99.893029,28.750010],[100.635216,29.252912],[102.705527,29.648422],[109.893029,30.000010],[119.893029,30.000010],[119.893029,35.000010],[119.525842,38.531260],[119.128381,39.605479],[118.643029,40.000010],[118.157677,40.394541],[117.760217,41.468760],[117.393029,45.000010],[117.025842,48.531260],[116.628381,49.605479],[116.143029,50.000010],[115.657677,50.345218],[115.260217,51.285147],[114.893029,54.375010],[115.260217,57.464835],[115.657677,58.404788],[116.143029,58.750010],[117.025842,58.177060],[117.393029,56.799510],[117.622057,55.885333],[118.394395,55.348622],[119.837925,55.146730],[122.080529,55.237010],[124.323736,55.587506],[125.921467,56.221796],[126.873589,57.151171],[127.179967,58.386922],[126.840466,59.940341],[125.854952,61.822718],[121.945349,66.619510],[117.435239,70.772622],[115.606295,72.036005],[114.391889,72.500010],[112.980192,72.867197],[112.393029,73.750010],[111.837459,74.235362],[110.324769,74.632822],[105.352149,75.000010],[101.731213,74.882251],[99.196198,74.451610],[97.353333,73.592044],[95.808849,72.187510],[93.783344,70.449623],[93.146002,70.417393],[92.745559,70.937510],[91.645670,72.041035],[89.788859,72.500010],[88.096803,72.867197],[87.582074,73.264658],[87.393029,73.750010],[86.678426,74.248307],[84.680130,74.625910],[77.705529,74.914110],[72.166696,74.777891],[68.796289,74.251485],[66.443002,72.971516],[63.955529,70.574610]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[84.893029,63.750010],[85.460497,62.867197],[86.824839,62.500010],[89.090464,61.598722],[91.824839,59.431810],[93.991747,56.697435],[94.893029,54.431810],[95.260217,53.067472],[96.143029,52.500010],[97.025842,51.944235],[97.393029,50.608010],[97.852012,48.494447],[98.955529,46.069710],[99.893029,43.839460],[99.658654,43.252682],[98.955529,42.857510],[97.852012,41.754097],[97.393029,39.895810],[96.872277,38.203772],[96.308591,37.689052],[95.620259,37.500010],[92.042609,36.807410],[90.895009,36.932633],[89.225064,37.807229],[85.150777,41.035635],[81.485010,44.954829],[80.325717,46.692908],[79.893029,48.027010],[79.525842,49.420422],[78.643029,50.000010],[78.062628,50.477848],[77.670343,51.755546],[77.427867,55.775622],[77.871096,60.190443],[78.335944,61.961570],[78.955529,63.130210],[80.642238,64.350057],[82.598923,64.902235],[84.218286,64.723351],[84.711691,64.339949],[84.893029,63.750010]]);
    }
    linear_extrude(height=h)
      polygon([[127.393029,70.000010],[127.760217,66.468760],[128.157677,65.394541],[128.643029,65.000010],[129.128381,64.660610],[129.525842,63.736510],[129.893029,60.698810],[130.260217,57.434110],[130.657677,56.264369],[131.143029,55.625010],[131.628381,55.034960],[132.025842,53.999485],[132.393029,51.176210],[132.760217,48.579897],[133.157677,47.790087],[133.643029,47.500010],[134.525842,47.132822],[134.893029,46.250010],[134.498498,45.764658],[133.424279,45.367197],[129.893029,45.000010],[127.205938,44.907555],[125.698948,44.489572],[125.038999,43.535133],[124.893029,41.833310],[125.218616,40.313907],[126.103821,38.498893],[129.003752,34.596247],[132.494153,31.353808],[134.117447,30.364052],[135.476359,30.000010],[136.830008,29.632822],[137.393029,28.750010],[137.727113,28.181332],[138.642176,27.793327],[141.692089,27.545272],[145.496480,27.977712],[149.009059,29.062510],[150.570202,29.971940],[151.613430,31.049847],[152.198028,32.384087],[152.383279,34.062510],[152.563858,36.500860],[152.834887,37.096354],[153.272928,37.273160],[154.789610,36.362010],[157.393029,33.750010],[160.454097,31.101572],[161.842157,30.295908],[162.894539,30.000010],[164.305969,29.632822],[164.893029,28.750010],[165.447179,28.264658],[166.956002,27.867197],[171.915909,27.500010],[175.772641,27.617215],[178.345074,28.136672],[180.307607,29.310149],[182.334639,31.389410],[184.268606,33.468868],[185.672628,34.420972],[187.011308,34.404171],[188.749249,33.576910],[192.393029,31.250010],[194.459582,29.746790],[197.213927,28.559647],[200.380287,27.780187],[203.682889,27.500010],[206.240358,27.695198],[208.484604,28.274746],[210.407067,29.229629],[211.999187,30.550822],[213.252402,32.229302],[214.158155,34.256043],[214.707884,36.622020],[214.893029,39.318210],[214.525842,43.330985],[214.128381,44.551682],[213.643029,45.000010],[213.157677,45.394541],[212.760217,46.468760],[212.393029,50.000010],[212.025842,53.531260],[211.628381,54.605479],[211.143029,55.000010],[210.260217,55.367197],[209.893029,56.250010],[210.287560,56.735362],[211.361779,57.132822],[214.893029,57.500010],[217.578572,57.592524],[219.085734,58.009872],[219.746543,58.961765],[219.893029,60.657910],[219.535555,62.383438],[218.473758,64.433585],[216.723571,66.783394],[214.300929,69.407910],[211.081431,72.458593],[208.588713,74.138997],[205.961030,74.851883],[202.336639,75.000010],[199.383248,74.912973],[197.071091,74.585207],[195.323899,73.916730],[194.065404,72.807560],[193.219338,71.157715],[192.709432,68.867213],[192.393029,61.964310],[192.746799,55.178585],[193.142583,53.208716],[193.643029,52.500010],[194.128381,52.105479],[194.525842,51.031260],[194.893029,47.500010],[194.683207,43.968760],[194.178739,42.500010],[193.035762,43.058368],[191.615142,44.378547],[190.404893,45.928208],[189.893029,47.175010],[189.250449,48.666235],[187.705529,50.701810],[185.639572,53.422947],[183.744299,56.562510],[182.186467,58.990235],[180.931799,60.000010],[180.528466,60.197276],[180.198169,60.734385],[179.893029,62.500010],[179.525842,64.265635],[179.128381,64.802744],[178.643029,65.000010],[178.157677,65.253633],[177.760217,65.944197],[177.393029,68.214310],[177.259954,69.946914],[176.842704,71.392008],[176.114238,72.567007],[175.047518,73.489322],[173.615504,74.176368],[171.791158,74.645555],[166.857309,75.000010],[159.893029,75.000010],[159.893029,67.500010],[160.257610,62.187497],[160.654745,60.585943],[161.143029,60.000010],[161.628381,59.605479],[162.025842,58.531260],[162.393029,55.000010],[162.760217,51.468760],[163.157677,50.394541],[163.643029,50.000010],[164.128381,49.704112],[164.525842,48.898447],[164.893029,46.250010],[164.697195,43.601572],[164.226359,42.500010],[163.395592,42.881361],[162.136593,43.901063],[158.998420,47.109410],[156.140884,50.632832],[154.893029,52.979110],[154.617637,54.381597],[153.955529,55.208310],[152.360485,57.205397],[150.167920,61.170035],[148.228535,65.412510],[147.393029,68.243110],[147.025842,69.483922],[146.143029,70.000010],[145.657677,70.197276],[145.260217,70.734385],[144.893029,72.500010],[144.639122,73.844874],[143.486777,74.598222],[140.850057,74.927465],[136.143029,75.000010],[127.393029,75.000010],[127.393029,70.000010]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[232.393029,73.750010],[231.816019,72.867197],[230.428739,72.500010],[228.735923,72.124857],[227.062272,71.009510],[225.424781,69.169138],[223.840449,66.618910],[223.250150,64.843847],[222.814616,62.230451],[222.421522,55.814010],[222.688536,50.020294],[223.078137,48.185304],[223.643029,47.500010],[224.525842,46.944235],[224.893029,45.608010],[225.308933,43.715876],[226.435801,41.374435],[230.097365,36.208610],[234.427594,31.840485],[236.390292,30.496169],[237.976359,30.000010],[239.330008,29.632822],[239.893029,28.750010],[240.747792,28.240358],[243.155833,27.845597],[251.694249,27.500010],[260.265774,27.866072],[263.040085,28.263393],[264.268029,28.750010],[265.305014,29.235362],[267.557398,29.632822],[274.381029,30.000010],[280.527175,30.326479],[282.587055,30.762106],[284.007665,31.403810],[284.816150,32.269951],[285.039654,33.378891],[284.705323,34.748990],[283.840299,36.398610],[282.818164,38.958247],[282.393029,41.858010],[282.025841,44.077047],[281.628381,44.752087],[281.143029,45.000010],[280.657677,45.394541],[280.260216,46.468760],[279.893029,50.000010],[279.525841,53.531260],[279.128381,54.605479],[278.643029,55.000010],[278.157677,55.197276],[277.760216,55.734385],[277.393029,57.500010],[277.679155,59.265635],[278.367079,60.000010],[279.584305,59.265635],[281.143029,57.500010],[283.068936,55.734385],[284.163241,55.197276],[285.168979,55.000010],[286.355712,55.459005],[287.149818,56.702562],[287.563003,58.530539],[287.606974,60.742797],[287.293437,63.139195],[286.634097,65.519590],[285.640663,67.683842],[284.324839,69.431810],[281.590464,71.598722],[279.324839,72.500010],[277.960496,72.867197],[277.393029,73.750010],[276.837459,74.235362],[275.324769,74.632822],[270.352149,75.000010],[266.755881,74.883288],[264.236170,74.461860],[262.423876,73.628832],[260.949859,72.277310],[259.745149,71.041457],[258.777038,70.444810],[257.936807,70.451913],[257.115739,71.027310],[255.231106,72.067410],[252.768029,72.500010],[250.737560,72.867197],[250.119884,73.264658],[249.893029,73.750010],[249.228966,74.246668],[247.393029,74.642872],[241.143029,75.000010],[234.893029,74.642872],[233.057091,74.246668],[232.393029,73.750010]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[254.069189,59.498810],[258.182275,55.026485],[259.433491,53.209019],[259.893029,51.998810],[260.260217,50.587172],[261.143029,50.000010],[261.753514,49.622440],[262.152429,48.609822],[262.351574,45.399985],[261.812517,41.811585],[261.288678,40.325764],[260.607309,39.285710],[258.717484,38.098159],[256.367232,37.649855],[253.776128,37.853014],[251.163750,38.619847],[248.749675,39.862570],[246.753478,41.493396],[245.394737,43.424538],[244.893029,45.568210],[244.525842,46.932547],[243.643029,47.500010],[243.157677,47.697276],[242.760217,48.234385],[242.393029,50.000010],[242.025842,51.765635],[241.628381,52.302744],[241.143029,52.500010],[240.657677,52.750108],[240.260217,53.431072],[239.893029,55.669610],[240.089873,56.979730],[240.630321,58.444972],[242.441530,61.442935],[244.725654,63.867710],[245.857245,64.616469],[246.881689,64.923510],[247.870702,64.519108],[249.555515,63.361547],[254.069189,59.498810]]);
    }
  }
}
module AL_Slog(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-249.687500,30.630205],[-250.315522,29.308835],[-250.809977,27.052306],[-251.250000,20.677755],[-250.935558,15.313246],[-250.507188,13.668378],[-249.866659,12.687837],[-248.990424,12.351177],[-247.854940,12.637948],[-244.712040,14.999995],[-242.335311,16.765620],[-240.389300,17.499995],[-239.231546,17.867182],[-238.750000,18.749995],[-238.459069,19.318380],[-237.676628,19.707469],[-235.179342,19.963700],[-232.342385,19.550579],[-231.135356,19.102977],[-230.250000,18.499995],[-229.190625,16.921002],[-228.750000,15.231085],[-229.120125,14.216428],[-230.113584,12.787521],[-233.269001,9.364467],[-236.813250,6.316951],[-238.292749,5.357464],[-239.343330,4.999995],[-240.829441,4.265620],[-242.500000,2.499995],[-244.268542,0.734370],[-245.990240,-0.000005],[-247.379208,-0.170369],[-248.520920,-0.717748],[-249.434505,-1.696574],[-250.139091,-3.161280],[-250.997777,-7.766057],[-251.250000,-14.967535],[-251.165593,-21.233964],[-250.769231,-25.058695],[-249.846207,-27.453918],[-248.181810,-29.431825],[-246.143013,-31.136033],[-243.464106,-32.054630],[-238.769052,-32.428870],[-230.681810,-32.500005],[-216.250000,-32.500005],[-216.250000,-23.750005],[-216.305126,-18.697976],[-216.686506,-16.099590],[-217.100793,-15.465534],[-217.718146,-15.138912],[-219.724050,-15.000005],[-221.260279,-15.184180],[-222.730256,-15.699471],[-224.016118,-16.490030],[-225.000000,-17.500005],[-226.028150,-18.505911],[-227.410425,-19.258928],[-230.801395,-19.983073],[-234.301002,-19.625991],[-235.819074,-19.027475],[-237.037340,-18.141235],[-237.921887,-17.056933],[-238.055496,-16.066860],[-237.359412,-14.863975],[-235.754880,-13.141235],[-233.049964,-10.922740],[-230.957760,-10.000005],[-229.259004,-9.265630],[-227.500000,-7.500005],[-225.745447,-5.734380],[-224.057390,-5.000005],[-223.077273,-4.656952],[-221.621516,-3.722896],[-218.069050,-0.652395],[-215.574087,2.033799],[-214.271364,4.583960],[-213.758681,8.410928],[-213.633840,14.927545],[-213.667799,21.158647],[-214.042244,24.932270],[-214.983102,27.304128],[-216.716300,29.329935],[-218.799045,31.100829],[-221.441525,32.042984],[-226.043740,32.409241],[-234.005690,32.452445],[-245.375716,32.026759],[-248.231280,31.471055],[-249.687500,30.630205]]);
    linear_extrude(height=h)
      polygon([[-196.250000,29.448765],[-196.617187,27.066904],[-197.500000,25.624995],[-198.382812,24.366680],[-198.750000,22.426225],[-199.117187,20.712699],[-199.514648,20.191439],[-200.000000,19.999995],[-200.485352,19.802729],[-200.882812,19.265620],[-201.250000,17.499995],[-201.617187,15.734370],[-202.014648,15.197261],[-202.500000,14.999995],[-202.985352,14.704097],[-203.382812,13.898432],[-203.750000,11.249995],[-204.117187,8.601557],[-204.514648,7.795893],[-205.000000,7.499995],[-205.485352,7.302729],[-205.882812,6.765620],[-206.250000,4.999995],[-206.617187,3.234370],[-207.014648,2.697261],[-207.500000,2.499995],[-207.985352,2.302729],[-208.382812,1.765620],[-208.750000,-0.000005],[-209.117187,-1.765630],[-209.514648,-2.302739],[-210.000000,-2.500005],[-210.485352,-2.894536],[-210.882812,-3.968755],[-211.250000,-7.500005],[-211.250000,-12.500005],[-205.250000,-12.500005],[-201.167856,-12.200006],[-198.371427,-11.262509],[-197.425222,-10.537119],[-196.764285,-9.631259],[-196.250000,-7.250005],[-195.882812,-5.660943],[-195.485352,-5.177544],[-195.000000,-5.000005],[-194.514648,-4.802739],[-194.117187,-4.265630],[-193.750000,-2.500005],[-193.382812,-0.734380],[-192.985352,-0.197271],[-192.500000,-0.000005],[-192.014648,0.295893],[-191.617187,1.101557],[-191.250000,3.749995],[-191.015090,6.398432],[-190.450300,7.499995],[-189.146112,6.766288],[-187.798386,4.944485],[-186.736480,2.603562],[-186.289750,0.312495],[-185.894475,-1.673831],[-185.488483,-2.278080],[-185.000000,-2.500005],[-184.514648,-2.697271],[-184.117187,-3.234380],[-183.750000,-5.000005],[-183.382812,-6.765630],[-182.985352,-7.302739],[-182.500000,-7.500005],[-182.014648,-7.697271],[-181.617187,-8.234380],[-181.250000,-10.000005],[-181.038686,-11.299416],[-180.184492,-12.057815],[-178.357043,-12.412309],[-175.225960,-12.500005],[-169.201930,-12.500005],[-167.500000,-6.250005],[-165.997205,-1.835943],[-165.305946,-0.493169],[-164.774040,-0.000005],[-164.376421,0.197261],[-164.050809,0.734370],[-163.750000,2.499995],[-163.593749,3.593746],[-163.124997,4.374996],[-162.343747,4.843745],[-161.250000,4.999995],[-160.166943,4.844898],[-159.384505,4.384217],[-158.909814,3.624868],[-158.750000,2.573765],[-158.382812,0.633306],[-157.500000,-0.625005],[-156.617187,-2.066914],[-156.250000,-4.448775],[-155.882812,-6.603708],[-155.485352,-7.259244],[-155.000000,-7.500005],[-154.514648,-7.697271],[-154.117187,-8.234380],[-153.750000,-10.000005],[-153.515624,-11.328129],[-152.499997,-12.083338],[-150.234372,-12.421880],[-146.250000,-12.500005],[-138.750000,-12.500005],[-138.750000,-8.198775],[-139.117187,-4.934101],[-139.514648,-3.764364],[-140.000000,-3.125005],[-140.882812,-1.866690],[-141.250000,0.073765],[-141.617187,1.787291],[-142.014648,2.308551],[-142.500000,2.499995],[-142.985352,2.697261],[-143.382812,3.234370],[-143.750000,4.999995],[-144.117187,6.765620],[-144.514648,7.302729],[-145.000000,7.499995],[-145.485352,7.697261],[-145.882812,8.234370],[-146.250000,9.999995],[-146.617187,11.765620],[-147.014648,12.302729],[-147.500000,12.499995],[-147.985352,12.795893],[-148.382812,13.601557],[-148.750000,16.249995],[-149.117187,18.898432],[-149.514648,19.704097],[-150.000000,19.999995],[-150.485352,20.197261],[-150.882812,20.734370],[-151.250000,22.499995],[-151.617187,24.265620],[-152.014648,24.802729],[-152.500000,24.999995],[-153.382812,25.577005],[-153.750000,26.964285],[-154.324296,29.152451],[-155.906456,30.908327],[-158.285388,32.076111],[-161.250000,32.499995],[-164.199045,32.077980],[-166.579706,30.919461],[-168.170515,29.185724],[-168.750000,27.038055],[-169.117187,25.475941],[-170.000000,24.374995],[-170.882812,22.933086],[-171.250000,20.551225],[-171.617187,18.396292],[-172.014648,17.740756],[-172.500000,17.499995],[-172.985352,17.302729],[-173.382812,16.765620],[-173.750000,14.999995],[-174.117187,13.234370],[-174.514648,12.697261],[-175.000000,12.499995],[-175.485352,12.697261],[-175.882812,13.234370],[-176.250000,14.999995],[-176.617187,16.765620],[-177.014648,17.302729],[-177.500000,17.499995],[-177.985352,17.697261],[-178.382812,18.234370],[-178.750000,19.999995],[-179.117187,21.765620],[-179.514648,22.302729],[-180.000000,22.499995],[-180.882812,23.033497],[-181.250000,24.316175],[-181.676127,26.534104],[-182.700650,29.316175],[-183.664598,30.983645],[-184.948471,31.948084],[-186.983434,32.392523],[-190.200650,32.499995],[-193.500050,32.419049],[-195.317937,32.029870],[-196.089519,31.112946],[-196.250000,29.448765]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[-132.187500,28.074595],[-135.056642,24.347374],[-135.929444,22.650763],[-136.250000,21.359285],[-136.617188,19.393742],[-137.500000,18.124995],[-137.985352,17.239054],[-138.382813,15.397930],[-138.750000,9.926225],[-138.384898,4.669051],[-137.987697,3.081321],[-137.500000,2.499995],[-137.014648,2.242057],[-136.617188,1.539752],[-136.250000,-0.768915],[-135.959888,-2.461808],[-135.091428,-4.279155],[-133.647436,-6.216382],[-131.630730,-8.268915],[-128.796056,-10.676800],[-126.156336,-11.937151],[-122.337146,-12.421156],[-115.964060,-12.500005],[-109.549437,-12.426306],[-105.780696,-11.942364],[-103.258458,-10.653910],[-100.583340,-8.166675],[-97.522917,-4.543233],[-96.591927,-3.002804],[-96.250000,-1.916675],[-95.882812,-0.563026],[-95.000000,-0.000005],[-94.482421,1.054682],[-94.088541,4.062494],[-93.750000,14.999995],[-93.808594,23.320309],[-94.114584,27.812496],[-94.421387,28.989254],[-94.863282,29.648433],[-95.464681,29.936519],[-96.250000,29.999995],[-98.015625,30.367182],[-98.552734,30.764643],[-98.750000,31.249995],[-99.777102,31.763000],[-102.712896,32.139547],[-113.437500,32.414085],[-128.125000,32.328185],[-132.187500,28.074615]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-106.250000,18.749995],[-106.052734,18.264643],[-105.515625,17.867182],[-103.750000,17.499995],[-101.984375,17.132807],[-101.447266,16.735347],[-101.250000,16.249995],[-101.992187,15.747064],[-104.062497,15.351556],[-111.250000,14.999995],[-117.168676,15.140112],[-120.303615,15.665307],[-120.946536,16.121455],[-121.036746,16.732847],[-119.750000,18.499995],[-118.651158,19.102237],[-116.878360,19.550705],[-112.322431,19.967585],[-108.105287,19.713170],[-106.755969,19.322519],[-106.250000,18.749995]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-111.250000,1.249995],[-111.595215,0.764643],[-112.535156,0.367182],[-115.625000,-0.000005],[-118.714844,0.367182],[-119.654785,0.764643],[-120.000000,1.249995],[-119.654785,1.735347],[-118.714844,2.132807],[-115.625000,2.499995],[-112.535156,2.132807],[-111.595215,1.735347],[-111.250000,1.249995]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[-78.750000,31.395785],[-79.484375,30.423892],[-81.250000,29.637805],[-83.015625,28.590930],[-83.552734,27.817074],[-83.750000,26.992025],[-84.117188,25.585152],[-85.000000,24.999995],[-85.485352,24.802729],[-85.882813,24.265620],[-86.250000,22.499995],[-86.617188,20.734370],[-87.014648,20.197261],[-87.500000,19.999995],[-88.002927,19.257807],[-88.398435,17.187494],[-88.750000,9.999995],[-88.398435,2.812496],[-88.002927,0.742183],[-87.500000,-0.000005],[-86.617188,-0.563026],[-86.250000,-1.916675],[-85.908073,-3.002804],[-84.977082,-4.543233],[-81.916660,-8.166675],[-79.235788,-10.660854],[-78.037080,-11.430576],[-76.692498,-11.948536],[-72.844623,-12.428621],[-66.250000,-12.500005],[-59.655378,-12.428626],[-55.807506,-11.948551],[-54.462924,-11.430593],[-53.264216,-10.660870],[-50.583340,-8.166675],[-48.510174,-5.877715],[-47.175709,-3.815536],[-46.461724,-1.741427],[-46.250000,0.583325],[-45.882813,3.702599],[-45.485352,4.651492],[-45.000000,4.999995],[-44.514648,5.394526],[-44.117188,6.468745],[-43.750000,9.999995],[-43.750000,14.999995],[-58.750000,14.999995],[-69.343750,15.209817],[-73.750000,15.714285],[-73.163627,16.805121],[-71.753830,18.424745],[-70.474504,19.184698],[-68.510673,19.754296],[-63.538542,20.296699],[-58.855533,20.000495],[-57.253104,19.521834],[-56.479740,18.814225],[-55.923333,18.303933],[-54.732200,17.886049],[-51.145840,17.499995],[-46.250000,17.499995],[-46.250000,23.214285],[-46.335745,26.097224],[-46.705017,28.315054],[-47.525869,29.954297],[-48.966355,31.101475],[-51.194528,31.843111],[-54.378443,32.265728],[-64.285710,32.499995],[-74.501119,32.175631],[-77.608679,31.824527],[-78.750000,31.395785]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-63.750000,1.249995],[-64.045898,0.764643],[-64.851563,0.367182],[-67.500000,-0.000005],[-70.148438,0.367182],[-70.954102,0.764643],[-71.250000,1.249995],[-70.954102,1.735347],[-70.148438,2.132807],[-67.500000,2.499995],[-64.851563,2.132807],[-64.045898,1.735347],[-63.750000,1.249995]]);
    }
    linear_extrude(height=h)
      polygon([[-34.134440,27.704975],[-35.091341,24.876742],[-35.748971,21.332680],[-36.128225,16.912265],[-36.250000,11.454975],[-36.304567,4.924989],[-36.643785,1.514022],[-37.002412,0.661831],[-37.530931,0.209787],[-39.229280,-0.000005],[-40.651461,-0.166387],[-41.676058,-0.706424],[-42.372758,-1.681451],[-42.811250,-3.152805],[-42.783124,-5.066319],[-41.763661,-7.269619],[-39.453278,-10.227012],[-35.552390,-14.402805],[-31.757759,-18.128937],[-28.757569,-20.638911],[-26.384294,-22.055132],[-24.470410,-22.500005],[-22.733739,-22.357122],[-21.763776,-21.702318],[-21.342028,-20.196357],[-21.250000,-17.500005],[-21.250000,-12.500005],[-15.000000,-12.500005],[-8.750000,-12.500005],[-8.750000,-6.250005],[-8.750000,-0.000005],[-15.000000,-0.000005],[-21.250000,-0.000005],[-21.250000,9.999995],[-21.250000,19.999995],[-15.000000,19.999995],[-8.750000,19.999995],[-8.750000,26.249995],[-8.750000,32.499995],[-20.384440,32.499995],[-32.018880,32.499995],[-34.134440,27.704975]]);
    linear_extrude(height=h)
      polygon([[23.750000,-0.000005],[23.750000,-32.500005],[30.000000,-32.500005],[36.250000,-32.500005],[36.250000,-20.023815],[36.400897,-11.607467],[36.943088,-9.113780],[38.110725,-7.520361],[40.139521,-6.645170],[43.265191,-6.306163],[53.750000,-6.508535],[65.625000,-6.875005],[65.981220,-19.687505],[66.337460,-32.500005],[73.793720,-32.500005],[81.250000,-32.500005],[81.250000,-0.000005],[81.250000,32.499995],[73.750000,32.499995],[66.250000,32.499995],[66.250000,19.999995],[66.250000,7.499995],[51.250000,7.499995],[36.250000,7.499995],[36.250000,19.999995],[36.250000,32.499995],[30.000000,32.499995],[23.750000,32.499995],[23.750000,-0.000005]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[97.500000,31.249995],[97.116126,30.367182],[96.193190,29.999995],[95.150573,29.728871],[93.968130,28.987230],[91.527540,26.522774],[89.558978,23.467383],[88.966569,21.987074],[88.750000,20.681815],[88.382813,18.434655],[87.985352,17.751061],[87.500000,17.499995],[87.011716,16.914058],[86.614581,15.312496],[86.250000,9.999995],[86.614581,4.687494],[87.011716,3.085932],[87.500000,2.499995],[87.985352,2.302729],[88.382813,1.765620],[88.750000,-0.000005],[89.117188,-1.765630],[89.514648,-2.302739],[90.000000,-2.500005],[90.485352,-2.697271],[90.882813,-3.234380],[91.250000,-5.000005],[91.731546,-6.765630],[92.252793,-7.302739],[92.889300,-7.500005],[94.835311,-8.234380],[97.212040,-10.000005],[99.003698,-11.281195],[101.439305,-12.041619],[105.207992,-12.406235],[110.998890,-12.500005],[122.102310,-12.500005],[127.926160,-6.998865],[130.712757,-4.181075],[132.506189,-1.861020],[133.465566,0.215420],[133.750000,2.302365],[134.117188,5.213111],[134.514648,6.275180],[135.000000,6.874995],[135.882813,8.295232],[136.250000,10.624995],[135.882813,12.954757],[135.000000,14.374995],[134.514648,14.965036],[134.117188,16.000494],[133.750000,18.823765],[133.382813,21.420104],[132.985352,22.209918],[132.500000,22.499995],[131.617188,23.077005],[131.250000,24.464285],[130.740306,26.395022],[129.429508,28.179502],[127.645027,29.490301],[125.714290,29.999995],[124.327006,30.367182],[123.750000,31.249995],[122.812499,31.763384],[120.156247,32.157730],[110.625000,32.499995],[101.093753,32.157730],[98.437501,31.763384],[97.500000,31.249995]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[118.290540,16.562495],[120.139833,13.686695],[121.132474,10.733659],[121.131512,8.429416],[120.715634,7.747476],[120.000000,7.499995],[119.514648,7.302729],[119.117188,6.765620],[118.750000,4.999995],[118.593749,3.906244],[118.124997,3.124994],[117.343747,2.656245],[116.250000,2.499995],[114.484375,2.132807],[113.947266,1.735347],[113.750000,1.249995],[113.502519,0.534358],[112.820578,0.118478],[110.516332,0.117517],[107.563296,1.110160],[104.687500,2.959455],[103.143615,4.516343],[102.073839,6.143824],[101.451518,7.895113],[101.250000,9.823425],[101.735150,13.095047],[103.065518,15.820999],[105.053485,17.927082],[107.511427,19.339097],[110.251726,19.982846],[113.086758,19.784127],[115.828903,18.668743],[118.290540,16.562495]]);
    }
    linear_extrude(height=h)
      polygon([[138.750000,10.095985],[138.750000,-12.308025],[156.250000,-12.380025],[168.995272,-12.099349],[172.513852,-11.727380],[173.750000,-11.226015],[173.947266,-10.749975],[174.484375,-10.360139],[176.250000,-9.999995],[178.015625,-10.367183],[178.552734,-10.764643],[178.750000,-11.249995],[179.492187,-11.752926],[181.562497,-12.148434],[188.750000,-12.499995],[195.937503,-12.148434],[198.007813,-11.752926],[198.750000,-11.249995],[198.947266,-10.764643],[199.484375,-10.367183],[201.250000,-9.999995],[202.343747,-9.843745],[203.124997,-9.374996],[203.593749,-8.593746],[203.750000,-7.499995],[204.117188,-5.734370],[204.514648,-5.197261],[205.000000,-4.999995],[205.523434,-3.710933],[205.916664,0.000004],[206.250000,13.750005],[206.250000,32.500005],[199.461890,32.500005],[192.673770,32.500005],[193.399150,18.750005],[193.629967,8.144407],[193.310995,5.749468],[193.037934,5.182791],[192.687260,5.000005],[192.129200,4.802739],[191.672196,4.265630],[191.250000,2.500005],[191.063057,1.251569],[190.379461,0.487506],[189.015062,0.104693],[186.785710,0.000005],[184.351415,0.105168],[182.460564,0.521595],[181.045696,1.400699],[180.039351,2.893889],[179.374070,5.152575],[178.982391,8.328168],[178.750000,18.035715],[178.750000,32.500005],[172.500000,32.500005],[166.250000,32.500005],[166.250000,18.035715],[166.025203,8.685926],[165.680226,5.525240],[165.123325,3.211896],[164.311846,1.624298],[163.203134,0.640848],[161.754537,0.139950],[159.923400,0.000005],[158.657855,0.221930],[157.248771,0.826179],[154.687220,2.812505],[153.370013,4.713908],[152.712509,7.324091],[152.593360,11.740982],[152.891220,19.062505],[153.576220,32.500005],[146.163110,32.500005],[138.750000,32.500005],[138.750000,10.095995]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[215.312500,27.812755],[213.270209,25.248643],[211.992218,22.881935],[211.298494,20.256844],[211.009010,16.917585],[210.923458,9.791188],[211.199367,3.759950],[211.779998,-0.494785],[212.166852,-1.743045],[212.608610,-2.291675],[213.414715,-3.132353],[213.750000,-4.568455],[214.265739,-6.445071],[215.586614,-8.197951],[217.373109,-9.493971],[219.285710,-10.000005],[220.672990,-10.367193],[221.250000,-11.250005],[222.039062,-11.755999],[224.249997,-12.151166],[232.000000,-12.500005],[238.211226,-12.422968],[241.894154,-11.940405],[244.380005,-10.675143],[247.000000,-8.250005],[251.250000,-4.000005],[251.250000,12.464285],[250.869714,25.802605],[250.319947,29.058288],[249.464290,30.714285],[247.904121,31.557705],[244.982905,32.101504],[233.526790,32.457675],[219.375000,32.415375],[215.312500,27.812785]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[236.250000,21.249995],[236.471923,20.761507],[237.076170,20.355505],[239.062500,19.960245],[241.353567,19.513532],[243.694490,18.451624],[245.516293,17.103888],[246.250000,15.799695],[245.460938,15.489184],[243.312500,15.234905],[236.250000,14.999995],[229.187500,15.209817],[226.250000,15.714285],[226.550399,16.408320],[227.360855,17.345407],[229.967489,19.545484],[232.981003,21.508011],[235.312500,22.426485],[235.974608,22.111202],[236.250000,21.249995]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[236.250000,1.249995],[235.954102,0.764643],[235.148438,0.367182],[232.500000,-0.000005],[229.851563,0.367182],[229.045898,0.764643],[228.750000,1.249995],[229.045898,1.735347],[229.851563,2.132807],[232.500000,2.499995],[235.148438,2.132807],[235.954102,1.735347],[236.250000,1.249995]]);
    }
  }
}
module AL_Back(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    difference()
    {
       linear_extrude(height=h)
         polygon([[-713.749980,67.775905],[-713.702297,34.541201],[-713.414493,16.907072],[-713.112690,12.304244],[-712.669432,9.638383],[-712.057576,8.255097],[-711.249980,7.499995],[-710.124816,6.413556],[-709.347056,5.000201],[-708.895759,3.205255],[-708.749980,0.974045],[-709.117168,-2.362313],[-709.514628,-3.377247],[-709.999980,-3.750005],[-710.507796,-4.570318],[-710.902761,-6.875008],[-711.249980,-15.000005],[-710.902761,-23.125003],[-710.507796,-25.429692],[-709.999980,-26.250005],[-709.485068,-27.226567],[-709.090891,-30.000003],[-708.749980,-40.000005],[-708.409073,-50.000008],[-708.014897,-52.773443],[-707.499980,-53.750005],[-706.919357,-53.951755],[-706.526993,-54.491014],[-706.284630,-56.186099],[-706.728067,-58.043347],[-707.192953,-58.785309],[-707.812480,-59.270845],[-708.749980,-60.000005],[-707.812480,-60.729165],[-707.149932,-61.533803],[-706.659313,-63.204819],[-706.249980,-68.854165],[-705.884664,-74.088546],[-705.487437,-75.670578],[-704.999980,-76.250005],[-704.117168,-76.827011],[-703.749980,-78.214295],[-703.286581,-79.878445],[-702.157108,-81.692546],[-700.752643,-83.151449],[-699.464270,-83.750005],[-698.959803,-83.046230],[-698.749980,-81.354165],[-698.290998,-79.447921],[-697.187480,-78.229165],[-696.249980,-77.500005],[-697.187480,-76.770845],[-697.850032,-75.966209],[-698.340651,-74.295195],[-698.749980,-68.645845],[-699.025373,-63.419669],[-699.323468,-61.827618],[-699.687480,-61.240255],[-700.795834,-60.251931],[-702.139698,-57.916161],[-703.273077,-55.151326],[-703.749980,-52.875805],[-704.117168,-51.727584],[-704.999980,-51.250005],[-705.519638,-50.123704],[-705.913288,-46.901049],[-706.249980,-35.104165],[-706.604994,-22.482753],[-707.088824,-19.489083],[-707.812480,-18.324325],[-708.460412,-17.951196],[-708.629482,-17.515458],[-707.499980,-16.250005],[-706.370485,-14.984553],[-706.539553,-14.548814],[-707.187480,-14.175685],[-707.806715,-13.726831],[-708.271793,-13.010947],[-708.716264,-11.181089],[-708.474467,-9.492109],[-708.081712,-8.952323],[-707.499980,-8.750005],[-706.617168,-9.349514],[-706.249980,-10.790875],[-705.435588,-12.938576],[-703.477580,-15.236255],[-702.118791,-16.520303],[-701.541691,-17.435634],[-701.698160,-18.171097],[-702.540080,-18.915545],[-703.641035,-20.051901],[-703.464476,-20.459297],[-702.812480,-20.824335],[-701.708966,-21.975879],[-701.249980,-23.854165],[-700.882793,-25.546230],[-700.485332,-26.060959],[-699.999980,-26.250005],[-699.514628,-26.501069],[-699.117168,-27.184660],[-698.749980,-29.431815],[-697.966601,-32.043825],[-696.092787,-35.118504],[-693.843025,-37.679385],[-692.800440,-38.462007],[-691.931800,-38.750005],[-691.450265,-37.281255],[-691.249980,-33.750005],[-691.617168,-30.218755],[-692.014628,-29.144536],[-692.499980,-28.750005],[-692.985332,-28.493678],[-693.382793,-27.795758],[-693.749980,-25.501515],[-694.011629,-23.906763],[-694.760211,-22.184455],[-695.941178,-20.432799],[-697.499980,-18.750005],[-699.058787,-17.067206],[-700.239753,-15.315551],[-700.988332,-13.593245],[-701.249980,-11.998495],[-701.617168,-9.704249],[-702.014628,-9.006331],[-702.499980,-8.750005],[-702.985332,-8.454107],[-703.382793,-7.648443],[-703.749980,-5.000005],[-704.117168,-2.351568],[-704.514628,-1.545903],[-704.999980,-1.250005],[-705.485332,-0.756841],[-705.882793,0.585932],[-706.249980,4.999995],[-706.164043,8.261711],[-705.812481,10.156242],[-705.054669,11.035150],[-703.749980,11.249995],[-702.656233,11.093744],[-701.874982,10.624992],[-701.406231,9.843742],[-701.249980,8.749995],[-700.882793,6.984370],[-700.485332,6.447261],[-699.999980,6.249995],[-699.514628,6.052729],[-699.117168,5.515620],[-698.749980,3.749995],[-698.382793,1.984370],[-697.985332,1.447261],[-697.499980,1.249995],[-697.014628,1.052729],[-696.617168,0.515620],[-696.249980,-1.250005],[-695.882793,-3.015630],[-695.485332,-3.552739],[-694.999980,-3.750005],[-694.465947,-3.495852],[-694.084494,-2.817238],[-693.779333,-0.689710],[-694.084494,1.626421],[-694.465947,2.540787],[-694.999980,3.124995],[-695.485332,3.912303],[-695.882793,5.484874],[-696.249980,10.073775],[-696.163483,13.292860],[-695.810989,15.165489],[-695.052990,16.036319],[-693.749980,16.250005],[-691.984355,16.617192],[-691.447246,17.014653],[-691.249980,17.500005],[-690.954082,17.985357],[-690.148418,18.382817],[-687.499980,18.750005],[-685.367170,18.632816],[-684.702131,18.383791],[-684.249982,17.916667],[-683.820293,16.054688],[-683.749980,12.500005],[-683.540163,8.085934],[-683.035700,6.249995],[-681.594422,6.903011],[-680.206943,8.556846],[-679.162412,10.753684],[-678.749980,13.035705],[-678.382793,15.305817],[-677.985332,15.996382],[-677.499980,16.250005],[-676.972639,14.726565],[-676.579844,10.312497],[-676.249980,-6.250005],[-676.579844,-22.812503],[-676.972639,-27.226567],[-677.499980,-28.750005],[-677.985332,-28.947271],[-678.382793,-29.484380],[-678.749980,-31.250005],[-678.382793,-33.015630],[-677.985332,-33.552739],[-677.499980,-33.750005],[-677.014628,-33.947271],[-676.617168,-34.484380],[-676.249980,-36.250005],[-676.617168,-38.015630],[-677.014628,-38.552739],[-677.499980,-38.750005],[-678.074692,-38.979949],[-678.456098,-39.608137],[-678.662195,-41.689400],[-678.164672,-44.254090],[-677.009930,-46.562505],[-675.496138,-48.243058],[-674.487133,-48.561479],[-673.924539,-47.489788],[-673.749980,-45.000005],[-673.382793,-42.351567],[-672.985332,-41.545903],[-672.499980,-41.250005],[-672.014628,-40.855474],[-671.617168,-39.781255],[-671.249980,-36.250005],[-671.617168,-32.718755],[-672.014628,-31.644536],[-672.499980,-31.250005],[-672.985332,-31.052739],[-673.382793,-30.515630],[-673.749980,-28.750005],[-673.382793,-26.984380],[-672.985332,-26.447271],[-672.499980,-26.250005],[-672.014628,-25.855474],[-671.617168,-24.781255],[-671.249980,-21.250005],[-671.617168,-17.718755],[-672.014628,-16.644536],[-672.499980,-16.250005],[-672.834801,-16.001397],[-673.118355,-15.297889],[-673.535105,-12.780065],[-673.791301,-5.078428],[-673.323712,2.792631],[-672.835730,5.522232],[-672.187480,6.770835],[-671.249980,7.499995],[-672.187480,8.229155],[-672.851467,8.722122],[-673.325744,9.441230],[-673.705165,11.248645],[-673.325744,13.032953],[-672.851467,13.723176],[-672.187480,14.175705],[-671.523156,14.539516],[-671.331688,14.936617],[-672.390210,16.041405],[-673.227869,16.749002],[-673.477636,17.409780],[-673.127885,18.191421],[-672.166990,19.261605],[-670.185650,20.665905],[-668.214270,21.250005],[-667.430230,21.438214],[-666.808019,21.960230],[-666.397860,22.752133],[-666.249980,23.750005],[-666.093730,24.843769],[-665.624981,25.625017],[-664.843731,26.093760],[-663.749980,26.250005],[-662.947573,26.164557],[-662.338152,25.722666],[-661.895211,24.646009],[-661.592244,22.656266],[-661.300204,14.824234],[-661.249980,-0.000005],[-661.577361,-19.375003],[-661.969846,-24.492192],[-662.499980,-26.250005],[-663.007796,-27.070318],[-663.402761,-29.375008],[-663.749980,-37.500005],[-664.097203,-45.625003],[-664.492168,-47.929692],[-664.999980,-48.750005],[-665.496634,-49.414068],[-665.892839,-51.250005],[-666.249980,-57.500005],[-666.607125,-63.750005],[-667.003331,-65.585943],[-667.499980,-66.250005],[-667.986023,-66.818696],[-668.383407,-68.368518],[-668.749980,-73.474055],[-668.858828,-77.123960],[-669.248574,-79.616731],[-670.014023,-81.294651],[-671.249980,-82.500005],[-672.437641,-83.649391],[-673.208456,-85.183068],[-673.625034,-87.293160],[-673.749980,-90.171795],[-674.179420,-94.602646],[-674.672553,-95.994476],[-675.312480,-96.675685],[-675.960412,-97.048814],[-676.129482,-97.484553],[-674.999980,-98.750005],[-673.870485,-100.015459],[-674.039553,-100.451200],[-674.687480,-100.824335],[-675.306715,-101.273186],[-675.771793,-101.989068],[-676.216264,-103.818923],[-675.974467,-105.507901],[-675.581712,-106.047687],[-674.999980,-106.250005],[-674.514628,-106.545903],[-674.117168,-107.351568],[-673.749980,-110.000005],[-673.382793,-112.648443],[-672.985332,-113.454107],[-672.499980,-113.750005],[-672.014628,-113.552739],[-671.617168,-113.015630],[-671.249980,-111.250005],[-670.882793,-109.484380],[-670.485332,-108.947271],[-669.999980,-108.750005],[-669.514628,-108.454107],[-669.117168,-107.648443],[-668.749980,-105.000005],[-668.382793,-102.351568],[-667.985332,-101.545903],[-667.499980,-101.250005],[-667.014628,-101.052739],[-666.617168,-100.515630],[-666.249980,-98.750005],[-665.882793,-96.984380],[-665.485332,-96.447271],[-664.999980,-96.250005],[-664.514628,-95.954107],[-664.117168,-95.148443],[-663.749980,-92.500005],[-664.117168,-89.851568],[-664.514628,-89.045903],[-664.999980,-88.750005],[-665.485332,-88.454107],[-665.882793,-87.648443],[-666.249980,-85.000005],[-666.132793,-83.183602],[-665.729149,-82.031258],[-664.960920,-81.425787],[-663.749980,-81.250005],[-662.656233,-81.093754],[-661.874982,-80.625003],[-661.406231,-79.843752],[-661.249980,-78.750005],[-661.617168,-76.984380],[-662.014628,-76.447271],[-662.499980,-76.250005],[-662.985332,-75.855474],[-663.382793,-74.781255],[-663.749980,-71.250005],[-663.652325,-68.710945],[-663.281232,-67.187508],[-662.519514,-66.445318],[-661.249980,-66.250005],[-659.484355,-65.963875],[-658.749980,-65.275955],[-659.484355,-64.058729],[-661.249980,-62.500005],[-662.845375,-60.738308],[-663.671965,-58.677108],[-663.600063,-56.964856],[-663.186649,-56.442227],[-662.499980,-56.250005],[-661.988261,-55.351568],[-661.593730,-52.812505],[-661.249980,-43.750005],[-660.906230,-34.687505],[-660.511699,-32.148443],[-659.999980,-31.250005],[-659.478216,-30.039068],[-659.084801,-26.562508],[-658.749980,-13.750005],[-658.415159,-0.937503],[-658.021744,2.539058],[-657.499980,3.749995],[-656.985068,4.726557],[-656.590891,7.499994],[-656.249980,17.500005],[-656.040163,27.210942],[-655.535700,31.250005],[-654.506680,30.725442],[-653.035700,29.464305],[-651.826665,27.707193],[-651.303413,25.838930],[-651.512374,24.354780],[-651.905945,23.911517],[-652.499980,23.750005],[-653.026178,22.304688],[-653.419100,18.124991],[-653.749980,2.499995],[-654.080864,-13.125008],[-654.473787,-17.304693],[-654.999980,-18.750005],[-655.485332,-18.947271],[-655.882793,-19.484380],[-656.249980,-21.250005],[-655.882793,-23.015630],[-655.485332,-23.552739],[-654.999980,-23.750005],[-654.514628,-24.045903],[-654.117168,-24.851568],[-653.749980,-27.500005],[-654.117168,-30.148443],[-654.514628,-30.954107],[-654.999980,-31.250005],[-655.485332,-31.447271],[-655.882793,-31.984380],[-656.249980,-33.750005],[-655.882793,-35.515630],[-655.485332,-36.052739],[-654.999980,-36.250005],[-654.514628,-36.743169],[-654.117168,-38.085943],[-653.749980,-42.500005],[-653.382793,-46.914068],[-652.985332,-48.256841],[-652.499980,-48.750005],[-651.617168,-49.327011],[-651.249980,-50.714295],[-650.786581,-52.378445],[-649.657108,-54.192546],[-648.252643,-55.651449],[-646.964270,-56.250005],[-646.459803,-55.546230],[-646.249980,-53.854165],[-645.790998,-51.975878],[-644.687480,-50.824325],[-643.846664,-50.088195],[-644.379300,-49.157665],[-645.023053,-48.189649],[-645.509644,-46.611673],[-645.985946,-42.466929],[-645.757415,-38.405605],[-645.362965,-36.931905],[-644.773260,-36.109875],[-644.180729,-35.530238],[-644.166806,-34.822748],[-644.757191,-33.915416],[-645.977580,-32.736255],[-647.065640,-31.537500],[-647.945889,-30.074678],[-648.535083,-28.518799],[-648.749980,-27.040875],[-649.117168,-24.716701],[-649.514628,-24.009676],[-649.999980,-23.750005],[-650.337893,-23.445325],[-650.624083,-22.583344],[-651.044776,-19.499838],[-651.303800,-10.081158],[-650.832789,-0.491690],[-650.340939,2.805298],[-649.687480,4.270835],[-648.749980,4.999995],[-649.687480,5.729155],[-650.294172,6.299960],[-650.790998,7.315099],[-651.249980,10.104155],[-651.130562,11.860364],[-650.723198,12.981786],[-649.954225,13.575856],[-648.749980,13.750005],[-647.539044,13.574228],[-646.770815,12.968766],[-646.367168,11.816421],[-646.249980,9.999995],[-645.882793,7.351557],[-645.485332,6.545893],[-644.999980,6.249995],[-644.514628,6.052729],[-644.117168,5.515620],[-643.749980,3.749995],[-643.382793,1.984370],[-642.985332,1.447261],[-642.499980,1.249995],[-642.014628,0.756831],[-641.617168,-0.585943],[-641.249980,-5.000005],[-641.164043,-8.261721],[-640.812481,-10.156253],[-640.054669,-11.035160],[-638.749980,-11.250005],[-637.480450,-11.445318],[-636.718731,-12.187508],[-636.347637,-13.710945],[-636.249980,-16.250005],[-635.882793,-19.781255],[-635.485332,-20.855474],[-634.999980,-21.250005],[-634.514628,-21.425496],[-634.117168,-21.903319],[-633.749980,-23.474055],[-633.552714,-24.479793],[-633.015605,-25.574098],[-631.249980,-27.500005],[-630.036441,-28.678287],[-629.268501,-30.281573],[-628.866300,-32.575867],[-628.749980,-35.827175],[-628.382793,-40.662598],[-627.985332,-42.310156],[-627.499980,-43.125005],[-626.887538,-44.549441],[-626.474142,-47.580208],[-626.218686,-56.301669],[-626.682002,-64.971258],[-627.167072,-67.937185],[-627.812480,-69.270845],[-628.749980,-70.000005],[-627.812480,-70.729165],[-627.185256,-71.539642],[-626.712905,-73.132470],[-626.259168,-77.567406],[-626.503962,-81.838432],[-626.904774,-83.226371],[-627.499980,-83.750005],[-627.985332,-83.947271],[-628.382793,-84.484380],[-628.749980,-86.250005],[-628.428632,-87.906670],[-627.655576,-88.677973],[-626.717298,-88.469667],[-625.900280,-87.187505],[-625.187048,-86.377940],[-624.233620,-86.733635],[-623.877920,-87.687068],[-624.687480,-88.400305],[-625.329045,-89.363727],[-625.812272,-91.477972],[-626.276102,-97.581734],[-626.023747,-103.557206],[-625.611741,-105.511089],[-624.999980,-106.250005],[-624.514628,-106.644536],[-624.117168,-107.718755],[-623.749980,-111.250005],[-623.382793,-114.781255],[-622.985332,-115.855474],[-622.499980,-116.250005],[-622.014628,-116.447271],[-621.617168,-116.984380],[-621.249980,-118.750005],[-620.882793,-120.515630],[-620.485332,-121.052739],[-619.999980,-121.250005],[-619.514628,-120.954107],[-619.117168,-120.148442],[-618.749980,-117.500005],[-618.382793,-114.851567],[-617.985332,-114.045903],[-617.499980,-113.750005],[-616.901300,-113.225424],[-616.498327,-111.836688],[-616.252511,-107.576781],[-616.708555,-103.190351],[-617.182906,-101.643461],[-617.812480,-100.897465],[-618.313813,-100.487420],[-618.246692,-99.818956],[-616.401850,-97.694865],[-613.428720,-95.053125],[-617.339350,-91.400055],[-619.476181,-89.187894],[-620.650928,-87.043029],[-621.147542,-84.101287],[-621.249980,-79.498495],[-621.609836,-73.624628],[-622.006381,-71.882723],[-622.499980,-71.250005],[-623.017559,-70.195317],[-623.411439,-67.187503],[-623.749980,-56.250005],[-623.463854,-45.656255],[-623.154136,-42.433599],[-622.775930,-41.250005],[-621.558704,-41.984380],[-619.999980,-43.750005],[-618.441260,-45.515630],[-617.224030,-46.250005],[-616.717901,-46.044904],[-616.399767,-45.498357],[-616.282743,-43.793471],[-616.783474,-41.960435],[-617.812480,-40.824335],[-618.464476,-40.459297],[-618.641035,-40.051901],[-617.540080,-38.915545],[-616.698165,-38.171097],[-616.541695,-37.435634],[-617.118793,-36.520303],[-618.477580,-35.236255],[-619.565640,-34.037500],[-620.445889,-32.574678],[-621.035083,-31.018799],[-621.249980,-29.540875],[-621.617168,-27.216701],[-622.014628,-26.509676],[-622.499980,-26.250005],[-623.033109,-24.135049],[-623.425261,-17.946431],[-623.749980,5.714285],[-623.402566,31.807252],[-622.856909,37.238520],[-622.458603,38.664380],[-621.964270,39.464305],[-620.493283,40.725442],[-619.464270,41.250005],[-618.959803,37.578130],[-618.749980,28.750005],[-618.406230,19.687505],[-618.011699,17.148442],[-617.499980,16.250005],[-617.003331,15.585942],[-616.607125,13.750004],[-616.249980,7.499995],[-615.892839,1.249995],[-615.496634,-0.585943],[-614.999980,-1.250005],[-614.514628,-1.743169],[-614.117168,-3.085943],[-613.749980,-7.500005],[-613.382793,-11.914068],[-612.985332,-13.256841],[-612.499980,-13.750005],[-612.014628,-14.045903],[-611.617168,-14.851568],[-611.249980,-17.500005],[-611.617168,-20.148443],[-612.014628,-20.954107],[-612.499980,-21.250005],[-613.382793,-21.617193],[-613.749980,-22.500005],[-613.552714,-22.985357],[-613.015605,-23.382818],[-611.249980,-23.750005],[-610.045740,-23.924160],[-609.276766,-24.518238],[-608.869400,-25.639659],[-608.749980,-27.395845],[-609.208966,-30.135465],[-609.705793,-31.097089],[-610.312480,-31.602545],[-610.832580,-32.002987],[-610.800345,-32.640326],[-609.062480,-34.665835],[-607.862901,-35.995994],[-606.980563,-37.550170],[-606.436058,-39.280956],[-606.249980,-41.140945],[-606.053457,-42.576291],[-605.515309,-44.191302],[-603.722676,-47.502868],[-601.489150,-50.160737],[-600.399886,-50.958627],[-599.431800,-51.250005],[-598.950265,-49.414068],[-598.749980,-45.000005],[-599.117168,-40.585943],[-599.514628,-39.243169],[-599.999980,-38.750005],[-600.485332,-38.475880],[-600.882793,-37.729500],[-601.249980,-35.275955],[-601.434156,-33.739726],[-601.949450,-32.269749],[-602.740009,-30.983887],[-603.749980,-30.000005],[-604.759955,-29.016123],[-605.550514,-27.730261],[-606.065805,-26.260284],[-606.249980,-24.724055],[-606.617168,-22.270510],[-607.014628,-21.524130],[-607.499980,-21.250005],[-607.985332,-20.855474],[-608.382793,-19.781255],[-608.749980,-16.250005],[-609.117168,-12.718755],[-609.514628,-11.644536],[-609.999980,-11.250005],[-610.488264,-10.664067],[-610.885399,-9.062503],[-611.249980,-3.750005],[-611.614561,1.562492],[-612.011696,3.164057],[-612.499980,3.749995],[-613.007792,4.570309],[-613.402758,6.874999],[-613.749980,15.000005],[-614.097206,23.125017],[-614.492172,25.429697],[-614.999980,26.250005],[-615.488264,26.835938],[-615.885399,28.437492],[-616.249980,33.750005],[-616.040162,39.046880],[-615.535700,41.250005],[-614.094417,40.596989],[-612.706939,38.943155],[-611.662411,36.746321],[-611.249980,34.464305],[-610.882793,32.194192],[-610.485332,31.503628],[-609.999980,31.250005],[-609.514628,31.644536],[-609.117168,32.718755],[-608.749980,36.250005],[-609.117168,39.781255],[-609.514628,40.855474],[-609.999980,41.250005],[-610.485332,41.447271],[-610.882793,41.984380],[-611.249980,43.750005],[-611.074199,44.960924],[-610.468731,45.729155],[-609.316388,46.132811],[-607.499980,46.250005],[-604.851543,46.617192],[-604.045878,47.014653],[-603.749980,47.500005],[-603.355449,47.985357],[-602.281230,48.382817],[-598.749980,48.750005],[-595.859355,48.671880],[-594.374980,48.125005],[-593.828105,46.640630],[-593.749980,43.750005],[-594.117168,40.218755],[-594.514628,39.144536],[-594.999980,38.750005],[-595.346520,37.912099],[-595.640056,35.543154],[-596.071715,27.080794],[-596.338536,1.338705],[-595.857954,-24.577947],[-595.355359,-33.258510],[-595.041631,-35.769286],[-594.687480,-36.770845],[-593.749980,-37.500005],[-594.687480,-38.229165],[-595.307008,-38.714698],[-595.771895,-39.456659],[-596.215334,-41.313908],[-595.972971,-43.008995],[-595.580606,-43.548254],[-594.999980,-43.750005],[-594.514628,-44.122763],[-594.117168,-45.137698],[-593.749980,-48.474055],[-593.895759,-50.705265],[-594.347056,-52.500211],[-595.124816,-53.913566],[-596.249980,-55.000005],[-598.043050,-56.555221],[-598.640740,-57.736586],[-598.491318,-58.169281],[-598.043050,-58.487160],[-596.249980,-58.750005],[-595.039040,-58.925787],[-594.270811,-59.531258],[-593.867167,-60.683602],[-593.749980,-62.500005],[-594.117168,-65.148443],[-594.514628,-65.954107],[-594.999980,-66.250005],[-595.485332,-66.447271],[-595.882793,-66.984380],[-596.249980,-68.750005],[-596.617168,-70.515630],[-597.014628,-71.052739],[-597.499980,-71.250005],[-598.382793,-71.617193],[-598.749980,-72.500005],[-598.552714,-72.985357],[-598.015605,-73.382818],[-596.249980,-73.750005],[-594.984192,-73.943691],[-594.222058,-74.674488],[-593.848884,-76.167003],[-593.749980,-78.645845],[-594.208760,-82.318273],[-594.705561,-83.601546],[-595.312480,-84.270845],[-596.249980,-85.000005],[-595.312480,-85.729165],[-594.648181,-86.222988],[-594.173682,-86.943268],[-593.794083,-88.747628],[-594.173682,-90.511101],[-594.648181,-91.180273],[-595.312480,-91.602545],[-595.801081,-92.019392],[-595.709644,-92.709500],[-593.790080,-94.902095],[-592.358244,-96.289471],[-591.682677,-97.296916],[-591.715850,-98.055064],[-592.410230,-98.694545],[-593.097804,-99.357201],[-593.105035,-100.196196],[-592.378421,-101.360521],[-590.864460,-102.999165],[-588.495157,-105.224810],[-587.092072,-106.066485],[-586.679848,-105.980215],[-586.421562,-105.562210],[-586.249980,-103.750005],[-585.882793,-101.984380],[-585.485332,-101.447271],[-584.999980,-101.250005],[-584.514628,-100.756841],[-584.117168,-99.414068],[-583.749980,-95.000005],[-584.117168,-90.585943],[-584.514628,-89.243169],[-584.999980,-88.750005],[-585.580606,-88.548254],[-585.972971,-88.008995],[-586.215334,-86.313908],[-585.771895,-84.456659],[-585.307008,-83.714698],[-584.687480,-83.229165],[-583.749980,-82.500005],[-584.687480,-81.770845],[-585.790998,-80.552089],[-586.249980,-78.645845],[-586.617168,-76.953784],[-587.014628,-76.439052],[-587.499980,-76.250005],[-587.985332,-76.052739],[-588.382793,-75.515630],[-588.749980,-73.750005],[-589.117168,-71.984380],[-589.514628,-71.447271],[-589.999980,-71.250005],[-590.580606,-71.048254],[-590.972971,-70.508995],[-591.215334,-68.813908],[-590.771895,-66.956659],[-590.307008,-66.214698],[-589.687480,-65.729165],[-588.749980,-65.000005],[-589.687480,-64.270845],[-590.399923,-63.169488],[-590.884999,-60.524499],[-591.249980,-49.895845],[-591.591105,-39.973966],[-591.985308,-37.220058],[-592.499980,-36.250005],[-593.095188,-35.726371],[-593.496003,-34.338432],[-593.740796,-30.067406],[-593.287057,-25.632470],[-592.814705,-24.039642],[-592.187480,-23.229165],[-591.249980,-22.500005],[-592.187480,-21.770845],[-592.832103,-20.631122],[-593.317395,-18.185409],[-593.782616,-11.173488],[-593.528394,-4.330035],[-593.114383,-2.094907],[-592.499980,-1.250005],[-591.916383,-0.940749],[-591.522974,-0.118086],[-591.282148,2.436850],[-591.728362,5.153568],[-592.193754,6.178460],[-592.812480,6.770835],[-593.749980,7.499995],[-592.812480,8.229155],[-592.084208,9.556648],[-591.600891,12.982070],[-591.249980,27.604205],[-590.916531,41.276055],[-590.523288,44.967455],[-589.999980,46.250005],[-589.511696,45.664072],[-589.114561,44.062517],[-588.749980,38.750005],[-588.385399,33.437492],[-587.988264,31.835938],[-587.499980,31.250005],[-586.988261,30.351567],[-586.593730,27.812505],[-586.249980,18.750005],[-585.906230,9.687496],[-585.511699,7.148433],[-584.999980,6.249995],[-584.514628,5.954097],[-584.117168,5.148432],[-583.749980,2.499995],[-583.632793,0.683592],[-583.229149,-0.468753],[-582.460920,-1.074223],[-581.249980,-1.250005],[-579.484355,-0.882818],[-578.947246,-0.485357],[-578.749980,-0.000005],[-579.117168,0.882807],[-579.999980,1.249995],[-580.496634,1.914057],[-580.892839,3.749995],[-581.249980,9.999995],[-581.607125,16.250004],[-582.003331,18.085942],[-582.499980,18.750005],[-583.011699,19.648442],[-583.406230,22.187505],[-583.749980,31.250005],[-583.687481,38.125019],[-583.374982,41.875017],[-583.066389,42.871108],[-582.624983,43.437510],[-581.249980,43.750005],[-579.484355,43.382817],[-578.947246,42.985357],[-578.749980,42.500005],[-579.117168,41.617192],[-579.999980,41.250005],[-580.882793,40.882817],[-581.249980,40.000005],[-581.052714,39.514653],[-580.515605,39.117192],[-578.749980,38.750005],[-577.656233,38.593760],[-576.874982,38.125017],[-576.406231,37.343769],[-576.249980,36.250005],[-575.882793,34.484380],[-575.485332,33.947271],[-574.999980,33.750005],[-574.514628,34.045903],[-574.117168,34.851567],[-573.749980,37.500005],[-573.632793,39.316425],[-573.229149,40.468767],[-572.460920,41.074228],[-571.249980,41.250005],[-570.156233,41.093760],[-569.374982,40.625017],[-568.906231,39.843769],[-568.749980,38.750005],[-568.382793,36.984380],[-567.985332,36.447271],[-567.499980,36.250005],[-567.011696,36.835938],[-566.614561,38.437492],[-566.249980,43.750005],[-565.885399,49.062517],[-565.488264,50.664072],[-564.999980,51.250005],[-564.514628,51.447271],[-564.117168,51.984380],[-563.749980,53.750005],[-563.602101,54.747877],[-563.191946,55.539780],[-562.569738,56.061796],[-561.785700,56.250005],[-559.854961,56.759697],[-558.070477,58.070492],[-556.759675,59.854969],[-556.249980,61.785705],[-556.061771,62.569767],[-555.539755,63.191980],[-554.747852,63.602130],[-553.749980,63.750005],[-551.984355,63.382817],[-551.447246,62.985357],[-551.249980,62.500005],[-551.617168,61.617192],[-552.499980,61.250005],[-552.985332,60.855474],[-553.382793,59.781255],[-553.749980,56.250005],[-553.382793,52.718755],[-552.985332,51.644536],[-552.499980,51.250005],[-551.976546,49.960947],[-551.583316,46.250017],[-551.249980,32.500005],[-551.583316,18.749992],[-551.976546,15.039063],[-552.499980,13.750005],[-552.988264,13.164065],[-553.385399,11.562497],[-553.749980,6.249995],[-554.114561,0.937497],[-554.511696,-0.664067],[-554.999980,-1.250005],[-555.486023,-1.818696],[-555.883407,-3.368518],[-556.249980,-8.474055],[-556.358828,-12.123960],[-556.748574,-14.616731],[-557.514023,-16.294651],[-558.749980,-17.500005],[-559.720683,-18.437547],[-560.515605,-19.658230],[-561.052714,-21.004006],[-561.249980,-22.316825],[-561.471905,-23.684928],[-562.076154,-25.181214],[-562.970441,-26.624645],[-564.062480,-27.834185],[-565.800345,-29.859685],[-565.832580,-30.497023],[-565.312480,-30.897465],[-564.647764,-31.320813],[-564.172968,-31.991496],[-563.793130,-33.751014],[-564.172968,-35.528312],[-564.647764,-36.221221],[-565.312480,-36.675685],[-565.960412,-37.048814],[-566.129482,-37.484553],[-564.999980,-38.750005],[-563.870481,-40.015459],[-564.039549,-40.451200],[-564.687480,-40.824335],[-566.099675,-41.777613],[-566.265114,-42.266850],[-566.097256,-42.728185],[-564.843075,-43.458250],[-562.499980,-43.750005],[-560.683577,-43.632818],[-559.531232,-43.229174],[-558.925762,-42.460945],[-558.749980,-41.250005],[-558.382793,-39.484380],[-557.985332,-38.947271],[-557.499980,-38.750005],[-557.014628,-38.355474],[-556.617168,-37.281255],[-556.249980,-33.750005],[-555.882793,-30.218755],[-555.485332,-29.144536],[-554.999980,-28.750005],[-554.514628,-28.454107],[-554.117168,-27.648443],[-553.749980,-25.000005],[-554.117168,-22.351568],[-554.514628,-21.545903],[-554.999980,-21.250005],[-555.882793,-20.882818],[-556.249980,-20.000005],[-556.052714,-19.514653],[-555.515605,-19.117193],[-553.749980,-18.750005],[-551.984355,-18.382818],[-551.447246,-17.985357],[-551.249980,-17.500005],[-551.052714,-17.014653],[-550.515605,-16.617193],[-548.749981,-16.250005],[-546.984356,-15.882818],[-546.447247,-15.485357],[-546.249981,-15.000005],[-546.545879,-14.514653],[-547.351543,-14.117193],[-549.999980,-13.750005],[-551.816388,-13.632818],[-552.968731,-13.229174],[-553.574199,-12.460945],[-553.749980,-11.250005],[-553.593730,-10.156258],[-553.124981,-9.375008],[-552.343731,-8.906256],[-551.249980,-8.750005],[-549.484355,-8.382818],[-548.947246,-7.985357],[-548.749981,-7.500005],[-549.117168,-6.617193],[-549.999980,-6.250005],[-550.485332,-5.954107],[-550.882793,-5.148443],[-551.249980,-2.500005],[-550.882793,0.148432],[-550.485332,0.954097],[-549.999980,1.249995],[-549.488262,2.148433],[-549.093731,4.687496],[-548.749981,13.750005],[-548.406231,22.812505],[-548.011700,25.351567],[-547.499981,26.250005],[-546.976547,27.539063],[-546.583317,31.249992],[-546.249981,45.000005],[-546.583317,58.750017],[-546.976547,62.460947],[-547.499981,63.750005],[-548.382793,64.117192],[-548.749981,65.000005],[-548.552715,65.485357],[-548.015606,65.882817],[-546.249981,66.250005],[-545.458966,66.181647],[-544.854893,65.859385],[-544.412649,65.107436],[-544.107125,63.750017],[-543.805785,58.515644],[-543.749981,48.750005],[-543.415163,35.937517],[-543.021749,32.460947],[-542.499981,31.250005],[-541.997514,30.514321],[-541.601955,28.463530],[-541.249981,21.354205],[-540.868121,13.721870],[-540.380935,11.703384],[-539.687481,10.824315],[-539.039550,10.451186],[-538.870482,10.015447],[-539.999981,8.749995],[-541.129483,7.484541],[-540.960413,7.048800],[-540.312481,6.675665],[-539.683928,5.901600],[-539.210446,4.334725],[-538.755407,-0.072774],[-539.000780,-4.337470],[-539.402814,-5.725843],[-539.999981,-6.250005],[-540.882793,-6.617193],[-541.249981,-7.500005],[-540.855450,-7.985357],[-539.781231,-8.382818],[-536.249981,-8.750005],[-532.718731,-8.382818],[-531.644512,-7.985357],[-531.249981,-7.500005],[-531.617168,-6.617193],[-532.499981,-6.250005],[-532.985333,-5.855474],[-533.382793,-4.781255],[-533.749981,-1.250005],[-533.382793,2.281245],[-532.985333,3.355464],[-532.499981,3.749995],[-532.014629,4.045893],[-531.617168,4.851557],[-531.249981,7.499995],[-530.882793,10.148432],[-530.485333,10.954097],[-529.999981,11.249995],[-529.514629,11.545895],[-529.117168,12.351562],[-528.749981,15.000005],[-528.382793,17.648442],[-527.985333,18.454107],[-527.499981,18.750005],[-527.014629,19.102261],[-526.617168,20.061380],[-526.249981,23.214305],[-525.874320,26.123507],[-524.891075,28.702042],[-523.515856,30.545635],[-522.748633,31.065490],[-521.964271,31.250005],[-521.459804,30.148442],[-521.249981,27.500005],[-520.882793,24.851567],[-520.485333,24.045903],[-519.999981,23.750005],[-519.514629,23.194435],[-519.117168,21.681742],[-518.749981,16.709105],[-518.633269,13.096561],[-518.207715,10.575090],[-517.360194,8.759287],[-515.977581,7.263745],[-514.618794,5.979697],[-514.041696,5.064366],[-514.198166,4.328903],[-515.040081,3.584455],[-516.141036,2.448099],[-515.964477,2.040703],[-515.312481,1.675665],[-514.698727,1.047696],[-514.202686,-0.193113],[-513.749981,-3.854165],[-513.650317,-6.303075],[-513.284557,-7.798916],[-512.552552,-8.546342],[-511.354151,-8.750005],[-509.510197,-9.205710],[-508.441211,-10.301345],[-508.069858,-10.865805],[-507.481090,-10.919999],[-505.535701,-9.464295],[-504.079994,-7.518899],[-504.134190,-6.930133],[-504.698651,-6.558785],[-505.301003,-6.070317],[-505.794277,-5.122608],[-506.249981,-2.395845],[-506.617168,0.179029],[-507.014629,0.962315],[-507.499981,1.249995],[-508.021749,2.460932],[-508.415164,5.937494],[-508.749981,18.750005],[-508.415164,31.562492],[-508.021749,35.039063],[-507.499981,36.250005],[-507.014629,35.954107],[-506.617168,35.148442],[-506.249981,32.500005],[-505.882793,29.851567],[-505.485333,29.045903],[-504.999981,28.750005],[-504.514629,28.454107],[-504.117168,27.648442],[-503.749981,25.000005],[-503.382793,22.351567],[-502.985333,21.545903],[-502.499981,21.250005],[-502.014629,21.052739],[-501.617168,20.515630],[-501.249981,18.750005],[-501.617168,16.984380],[-502.014629,16.447271],[-502.499981,16.250005],[-503.382793,15.882817],[-503.749981,15.000005],[-503.552715,14.514653],[-503.015606,14.117192],[-501.249981,13.750005],[-500.298205,13.558198],[-499.552130,13.044816],[-498.742589,11.425552],[-498.952368,9.636673],[-499.480445,8.911270],[-500.312481,8.422635],[-500.699401,7.938704],[-500.395407,7.023062],[-497.812481,4.066955],[-495.900404,2.051793],[-494.645843,0.158199],[-493.958976,-1.791647],[-493.749981,-3.975565],[-493.591528,-5.925976],[-493.119106,-7.587264],[-492.337122,-8.948812],[-491.249981,-10.000005],[-490.310017,-10.930359],[-489.581801,-12.144236],[-488.807272,-14.971360],[-489.019723,-17.578989],[-489.525231,-18.518497],[-490.312481,-19.064735],[-490.579859,-19.642623],[-490.001891,-20.836991],[-486.562481,-24.695905],[-482.810530,-28.725699],[-481.669171,-30.280156],[-481.249981,-31.241295],[-480.758603,-32.648922],[-479.582498,-34.301220],[-478.168707,-35.675733],[-476.964271,-36.250005],[-476.459803,-35.515630],[-476.249981,-33.750005],[-476.617168,-31.984380],[-477.014629,-31.447271],[-477.499981,-31.250005],[-477.985333,-30.975880],[-478.382793,-30.229500],[-478.749981,-27.775955],[-478.934157,-26.239726],[-479.449451,-24.769749],[-480.240010,-23.483887],[-481.249981,-22.500005],[-482.259956,-21.516123],[-483.050515,-20.230261],[-483.565806,-18.760284],[-483.749981,-17.224055],[-484.117168,-14.770506],[-484.514629,-14.024129],[-484.999981,-13.750005],[-485.485333,-13.552739],[-485.882793,-13.015630],[-486.249981,-11.250005],[-486.617168,-9.484380],[-487.014629,-8.947271],[-487.499981,-8.750005],[-487.985333,-8.454107],[-488.382793,-7.648442],[-488.749981,-5.000005],[-489.117168,-2.351567],[-489.514629,-1.545903],[-489.999981,-1.250005],[-490.485333,-0.877247],[-490.882793,0.137688],[-491.249981,3.474045],[-491.395760,5.705255],[-491.847057,7.500201],[-492.624817,8.913556],[-493.749981,9.999995],[-495.515606,11.925894],[-496.052715,13.020185],[-496.249981,14.025905],[-496.617168,15.596693],[-497.014629,16.074516],[-497.499981,16.250005],[-497.985333,16.545903],[-498.382793,17.351567],[-498.749981,20.000005],[-499.117168,22.648442],[-499.514629,23.454107],[-499.999981,23.750005],[-500.485333,24.045903],[-500.882793,24.851567],[-501.249981,27.500005],[-501.617168,30.148442],[-502.014629,30.954107],[-502.499981,31.250005],[-502.985333,31.545903],[-503.382793,32.351567],[-503.749981,35.000005],[-504.117168,37.648442],[-504.514629,38.454107],[-504.999981,38.750005],[-505.485333,39.045903],[-505.882793,39.851567],[-506.249981,42.500005],[-506.617168,45.148442],[-507.014629,45.954107],[-507.499981,46.250005],[-507.985333,46.545903],[-508.382793,47.351567],[-508.749981,50.000005],[-509.117168,52.648442],[-509.514629,53.454107],[-509.999981,53.750005],[-510.488265,54.335938],[-510.885400,55.937492],[-511.249981,61.250005],[-511.171857,65.234394],[-510.833317,67.500018],[-510.078109,68.515635],[-508.749981,68.750005],[-506.984356,69.117192],[-506.447247,69.514653],[-506.249981,70.000005],[-505.855450,70.485357],[-504.781231,70.882817],[-501.249981,71.250005],[-498.710921,71.152344],[-497.187483,70.781242],[-496.445294,70.019522],[-496.249981,68.750005],[-496.093731,67.656241],[-495.624982,66.874992],[-494.843732,66.406250],[-493.749981,66.250005],[-492.480451,66.054697],[-491.718732,65.312518],[-491.347638,63.789082],[-491.249981,61.250005],[-490.882793,57.718755],[-490.485333,56.644536],[-489.999981,56.250005],[-489.514629,55.962330],[-489.117168,55.179055],[-488.749981,52.604205],[-488.290999,49.843068],[-487.794173,48.858166],[-487.187481,48.324305],[-486.535487,47.959272],[-486.358930,47.551892],[-487.459881,46.415505],[-488.285451,45.663238],[-488.399200,44.890017],[-487.740815,43.900666],[-486.249981,42.500005],[-484.759147,41.099302],[-484.100762,40.109955],[-484.214511,39.336758],[-485.040081,38.584505],[-486.141036,37.448118],[-485.964477,37.040738],[-485.312481,36.675705],[-484.208967,35.524130],[-483.749981,33.645805],[-483.382793,31.953768],[-482.985333,31.439047],[-482.499981,31.250005],[-482.014629,30.998942],[-481.617168,30.315355],[-481.249981,28.068205],[-481.007883,26.590666],[-480.348704,24.919768],[-479.373118,23.260588],[-478.181801,21.818205],[-475.930172,19.713103],[-474.579973,18.920418],[-474.177763,19.006349],[-473.922734,19.408525],[-473.749981,21.145805],[-473.290999,23.052068],[-472.187481,24.270805],[-471.249981,25.000005],[-472.187481,25.729205],[-473.290999,26.947942],[-473.749981,28.854205],[-474.117168,30.546242],[-474.514629,31.060963],[-474.999981,31.250005],[-475.485333,31.545903],[-475.882793,32.351567],[-476.249981,35.000005],[-476.367168,36.816425],[-476.770812,37.968768],[-477.539041,38.574228],[-478.749981,38.750005],[-479.843732,38.906250],[-480.624982,39.374992],[-481.093731,40.156241],[-481.249981,41.250005],[-481.617168,43.015630],[-482.014629,43.552739],[-482.499981,43.750005],[-482.985333,44.045903],[-483.382793,44.851567],[-483.749981,47.500005],[-484.117168,50.148442],[-484.514629,50.954107],[-484.999981,51.250005],[-485.485333,51.545903],[-485.882793,52.351567],[-486.249981,55.000005],[-486.617168,57.648442],[-487.014629,58.454107],[-487.499981,58.750005],[-487.985333,59.144536],[-488.382793,60.218755],[-488.749981,63.750005],[-489.117168,67.281255],[-489.514629,68.355474],[-489.999981,68.750005],[-490.485333,68.947271],[-490.882793,69.484380],[-491.249981,71.250005],[-491.049701,73.015630],[-490.568171,73.750005],[-489.727383,73.465259],[-488.697870,72.692999],[-486.443557,70.177805],[-484.547004,67.188161],[-483.749981,64.707805],[-483.552715,63.437288],[-483.015606,62.126167],[-482.220684,60.928916],[-481.249981,60.000005],[-479.484356,58.155117],[-478.749981,56.250005],[-478.015606,54.344817],[-476.249981,52.500005],[-474.484356,50.731430],[-473.749981,49.009805],[-473.223824,47.222205],[-471.885587,45.521455],[-470.095620,44.249930],[-468.214271,43.750005],[-467.430231,43.938214],[-466.808020,44.460230],[-466.397861,45.252133],[-466.249981,46.250005],[-466.617168,48.015630],[-467.014629,48.552739],[-467.499981,48.750005],[-467.985333,48.947271],[-468.382793,49.484380],[-468.749981,51.250005],[-469.117168,53.015630],[-469.514629,53.552739],[-469.999981,53.750005],[-470.485333,53.947271],[-470.882793,54.484380],[-471.249981,56.250005],[-471.397354,57.240367],[-471.803961,58.033105],[-472.416533,58.559292],[-473.181801,58.750005],[-474.246421,58.994122],[-475.497386,59.659014],[-478.153609,61.846380],[-480.340972,64.502608],[-481.005864,65.753579],[-481.249981,66.818205],[-481.617168,68.182542],[-482.499981,68.750005],[-482.985333,68.947271],[-483.382793,69.484380],[-483.749981,71.250005],[-483.574200,72.460924],[-482.968732,73.229155],[-481.816389,73.632811],[-479.999981,73.750005],[-477.351543,74.117192],[-476.545879,74.514653],[-476.249981,75.000005],[-476.052715,75.485357],[-475.515606,75.882817],[-473.749981,76.250005],[-472.539041,76.074228],[-471.770812,75.468768],[-471.367168,74.316425],[-471.249981,72.500005],[-470.882793,69.851567],[-470.485333,69.045903],[-469.999981,68.750005],[-469.514629,68.552739],[-469.117168,68.015630],[-468.749981,66.250005],[-468.382793,64.484380],[-467.985333,63.947271],[-467.499981,63.750005],[-467.014629,64.045903],[-466.617168,64.851567],[-466.249981,67.500005],[-466.617168,70.148442],[-467.014629,70.954107],[-467.499981,71.250005],[-467.985333,71.447271],[-468.382793,71.984380],[-468.749981,73.750005],[-468.563040,74.998428],[-467.879447,75.762493],[-466.515052,76.145313],[-464.285701,76.250005],[-461.851403,76.144843],[-459.960549,75.728417],[-458.545680,74.849317],[-457.539334,73.356130],[-456.874052,71.097446],[-456.482372,67.921855],[-456.249981,58.214305],[-455.910477,47.678592],[-455.516476,44.771216],[-454.999981,43.750005],[-454.497055,43.007813],[-454.101546,40.937492],[-453.749981,33.750005],[-453.398420,26.562518],[-453.002913,24.492197],[-452.499981,23.750005],[-452.011698,23.164072],[-451.614563,21.562518],[-451.249981,16.250005],[-451.614563,10.937488],[-452.011698,9.335929],[-452.499981,8.749995],[-453.382794,8.382808],[-453.749981,7.499995],[-453.552716,7.014643],[-453.015606,6.617183],[-451.249981,6.249995],[-450.039042,6.074213],[-449.270813,5.468743],[-448.867168,4.316398],[-448.749981,2.499995],[-449.117169,-0.148442],[-449.514630,-0.954107],[-449.999981,-1.250005],[-450.686654,-1.442227],[-451.100069,-1.964856],[-451.171970,-3.677108],[-450.345378,-5.738308],[-448.749981,-7.500005],[-447.624817,-8.586444],[-446.847058,-9.999799],[-446.395760,-11.794745],[-446.249981,-14.025955],[-445.882794,-17.362312],[-445.485333,-18.377247],[-444.999981,-18.750005],[-444.117169,-19.317473],[-443.749981,-20.681815],[-442.898472,-22.701570],[-440.911109,-25.390666],[-438.638636,-27.742384],[-436.931801,-28.750005],[-436.450266,-26.546880],[-436.249981,-21.250005],[-436.614562,-15.937507],[-437.011697,-14.335943],[-437.499981,-13.750005],[-437.985333,-13.293068],[-438.382793,-12.048932],[-438.749981,-7.959125],[-438.884258,-5.281307],[-439.290344,-3.096042],[-439.973124,-1.385854],[-440.937481,-0.133265],[-443.259542,2.468417],[-444.919938,5.336358],[-445.917231,8.467304],[-446.249981,11.858005],[-446.617169,14.959855],[-447.014630,15.903449],[-447.499981,16.250005],[-447.988265,16.835938],[-448.385400,18.437493],[-448.749981,23.750005],[-449.114563,29.062518],[-449.511698,30.664072],[-449.999981,31.250005],[-450.511405,32.141935],[-450.905969,34.661468],[-451.249981,43.645805],[-451.620258,53.276968],[-452.105995,55.726941],[-452.812481,56.770805],[-453.749981,57.500005],[-452.812481,58.229205],[-452.192957,58.714719],[-451.728073,59.456668],[-451.284635,61.313905],[-451.526996,63.008993],[-451.919359,63.548253],[-452.499981,63.750005],[-452.985333,63.947271],[-453.382794,64.484380],[-453.749981,66.250005],[-453.382794,68.015630],[-452.985333,68.552739],[-452.499981,68.750005],[-451.617169,68.382818],[-451.249981,67.500005],[-450.882794,66.617193],[-449.999981,66.250005],[-449.514630,66.545903],[-449.117169,67.351568],[-448.749981,70.000005],[-448.632795,71.672608],[-448.273795,72.840930],[-447.661818,73.526289],[-446.785702,73.750005],[-445.612875,73.598606],[-444.546922,73.159175],[-442.796665,71.504818],[-441.656997,68.964128],[-441.249981,65.714305],[-440.882794,62.561380],[-440.485333,61.602261],[-439.999981,61.250005],[-439.514630,60.756841],[-439.117169,59.414068],[-438.749981,55.000005],[-438.382793,50.585943],[-437.985333,49.243169],[-437.499981,48.750005],[-436.997054,48.007813],[-436.601546,45.937493],[-436.249981,38.750005],[-436.601546,31.562518],[-436.997054,29.492197],[-437.499981,28.750005],[-437.985333,28.552739],[-438.382793,28.015630],[-438.749981,26.250005],[-438.382793,24.484380],[-437.985333,23.947271],[-437.499981,23.750005],[-437.014629,23.299116],[-436.617168,22.071443],[-436.249981,18.035705],[-435.742172,13.438618],[-435.176465,11.678710],[-434.464271,10.535705],[-432.868871,9.157926],[-431.885422,8.960035],[-431.387825,10.015004],[-431.249981,12.395805],[-430.790999,15.184880],[-430.294173,16.200021],[-429.687481,16.770805],[-428.749981,17.500005],[-429.687481,18.229205],[-430.348476,19.028546],[-430.839269,20.683355],[-431.249981,26.250005],[-431.656617,31.809043],[-432.146900,33.421866],[-432.812481,34.175705],[-433.460413,34.548794],[-433.629483,34.984518],[-432.499981,36.250005],[-431.370482,37.515418],[-431.539550,37.951160],[-432.187481,38.324305],[-432.833323,39.020008],[-433.325799,40.454705],[-433.749981,45.104205],[-434.117168,49.444680],[-434.514629,50.765064],[-434.999981,51.250005],[-435.488265,51.835938],[-435.885400,53.437493],[-436.249981,58.750005],[-436.614562,64.062518],[-437.011697,65.664072],[-437.499981,66.250005],[-437.985333,66.537680],[-438.382793,67.320955],[-438.749981,69.895805],[-439.193267,72.618443],[-439.673099,73.561688],[-440.259031,74.044705],[-440.449942,74.280933],[-440.367136,74.741905],[-439.508708,76.205625],[-435.918889,80.372993],[-431.542840,84.427541],[-429.701627,85.750238],[-428.433831,86.250005],[-426.751961,86.984380],[-424.999981,88.750005],[-423.221397,90.515630],[-421.475551,91.250005],[-420.530309,91.545903],[-419.229992,92.351568],[-416.249981,95.000005],[-414.567187,96.558786],[-412.815531,97.739755],[-411.093223,98.488349],[-409.498471,98.750005],[-407.204229,99.117193],[-406.506308,99.514653],[-406.249981,100.000005],[-406.052715,100.485357],[-405.515606,100.882818],[-403.749981,101.250005],[-402.752109,101.397880],[-401.960206,101.808030],[-401.438190,102.430243],[-401.249981,103.214305],[-400.759753,105.043200],[-399.526719,106.838993],[-397.907347,108.206366],[-396.258111,108.750005],[-395.226225,109.243169],[-393.466667,110.585943],[-388.749981,115.000005],[-384.033303,119.414068],[-382.273747,120.756841],[-381.241861,121.250005],[-379.842377,121.742360],[-378.195252,122.920093],[-376.823461,124.334207],[-376.249981,125.535705],[-425.820294,126.040193],[-544.999981,126.250005],[-713.749980,126.250005],[-713.749980,67.775905]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-531.249981,65.000005],[-530.882794,62.351567],[-530.485333,61.545903],[-529.999981,61.250005],[-529.514629,60.855474],[-529.117169,59.781255],[-528.749981,56.250005],[-528.382794,52.718755],[-527.985333,51.644536],[-527.499981,51.250005],[-527.014629,50.863697],[-526.617169,49.811867],[-526.249981,46.354205],[-525.791205,42.681755],[-525.294405,41.398496],[-524.687481,40.729205],[-523.749981,40.000005],[-524.687481,39.270805],[-525.294405,38.601514],[-525.791205,37.318255],[-526.249981,33.645805],[-526.617169,30.188142],[-527.014629,29.136313],[-527.499981,28.750005],[-527.985333,28.454107],[-528.382794,27.648442],[-528.749981,25.000005],[-529.117169,22.351567],[-529.514629,21.545903],[-529.999981,21.250005],[-530.485333,20.954107],[-530.882794,20.148442],[-531.249981,17.500005],[-531.617169,14.851567],[-532.014629,14.045903],[-532.499981,13.750005],[-532.985333,13.552739],[-533.382794,13.015629],[-533.749981,11.249995],[-534.117169,9.484370],[-534.514629,8.947261],[-534.999981,8.749995],[-535.485333,9.144526],[-535.882794,10.218746],[-536.249981,13.750005],[-536.617169,17.281255],[-537.014629,18.355474],[-537.499981,18.750005],[-538.007793,19.570313],[-538.402759,21.874992],[-538.749981,30.000005],[-539.097207,38.125017],[-539.492173,40.429697],[-539.999981,41.250005],[-540.329834,41.513869],[-540.609376,42.261794],[-541.020719,44.947838],[-541.274806,53.246742],[-540.813356,61.954828],[-540.330277,65.152349],[-539.687481,66.880205],[-537.574204,68.147555],[-534.687481,68.702405],[-532.886151,68.601341],[-531.844980,68.092867],[-531.365684,66.963563],[-531.249981,65.000005]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-518.749981,65.000005],[-519.117169,64.117192],[-519.999981,63.750005],[-520.488265,63.164072],[-520.885400,61.562517],[-521.249981,56.250005],[-521.459804,50.953130],[-521.964271,48.750005],[-522.813213,48.943233],[-523.610748,49.495408],[-524.975424,51.511555],[-525.905950,54.468352],[-526.249981,58.035705],[-526.617169,62.071442],[-527.014629,63.299116],[-527.499981,63.750005],[-528.382794,64.117192],[-528.749981,65.000005],[-528.355450,65.485357],[-527.281231,65.882817],[-523.749981,66.250005],[-520.218731,65.882817],[-519.144512,65.485357],[-518.749981,65.000005]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-513.749981,48.750005],[-513.406231,39.687505],[-513.011700,37.148442],[-512.499981,36.250005],[-512.014629,35.954107],[-511.617169,35.148442],[-511.249981,32.500005],[-511.617169,29.851567],[-512.014629,29.045903],[-512.499981,28.750005],[-512.985333,28.552739],[-513.382794,28.015630],[-513.749981,26.250005],[-513.382794,24.484380],[-512.985333,23.947271],[-512.499981,23.750005],[-512.014629,23.552739],[-511.617169,23.015630],[-511.249981,21.250005],[-511.406232,20.156241],[-511.874984,19.374992],[-512.656234,18.906250],[-513.749981,18.750005],[-514.960921,18.925782],[-515.729150,19.531242],[-516.132794,20.683585],[-516.249981,22.500005],[-516.617169,25.148442],[-517.014629,25.954107],[-517.499981,26.250005],[-517.985333,26.545903],[-518.382794,27.351567],[-518.749981,30.000005],[-519.117169,32.648442],[-519.514629,33.454107],[-519.999981,33.750005],[-520.488265,34.335938],[-520.885400,35.937492],[-521.249981,41.250005],[-520.885400,46.562517],[-520.488265,48.164072],[-519.999981,48.750005],[-519.514629,49.243169],[-519.117169,50.585942],[-518.749981,55.000005],[-518.664044,58.261738],[-518.312482,60.156267],[-517.554670,61.035166],[-516.249981,61.250005],[-514.874982,60.937510],[-514.433576,60.371108],[-514.124982,59.375017],[-513.812481,55.625019],[-513.749981,48.750005]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-626.249980,31.250005],[-626.601545,24.062517],[-626.997053,21.992197],[-627.499980,21.250005],[-628.023418,19.960947],[-628.416648,16.250016],[-628.749980,2.499995],[-628.959803,-10.742193],[-629.464270,-16.250005],[-630.752643,-15.651449],[-632.157108,-14.192546],[-633.286581,-12.378445],[-633.749980,-10.714295],[-634.117168,-9.327011],[-634.999980,-8.750005],[-635.485332,-8.552739],[-635.882793,-8.015630],[-636.249980,-6.250005],[-636.617168,-4.484380],[-637.014628,-3.947271],[-637.499980,-3.750005],[-637.985332,-3.454107],[-638.382793,-2.648443],[-638.749980,-0.000005],[-639.117168,2.648432],[-639.514628,3.454097],[-639.999980,3.749995],[-640.485332,4.045893],[-640.882793,4.851557],[-641.249980,7.499995],[-641.617168,10.148432],[-642.014628,10.954097],[-642.499980,11.249995],[-643.186649,11.442216],[-643.600063,11.964842],[-643.671965,13.677087],[-642.845375,15.738289],[-641.249980,17.500005],[-640.240009,18.483875],[-639.449450,19.769742],[-638.934156,21.239716],[-638.749980,22.775905],[-638.382793,25.229505],[-637.985332,25.975883],[-637.499980,26.250005],[-637.011701,26.835938],[-636.614565,28.437492],[-636.249980,33.750005],[-636.249980,41.250005],[-631.249980,41.250005],[-626.249980,41.250005],[-626.249980,31.250005]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-641.249980,28.750005],[-641.318340,23.320303],[-641.640607,20.312492],[-642.392561,19.023438],[-643.749980,18.750005],[-644.843731,18.906250],[-645.624981,19.374992],[-646.093730,20.156241],[-646.249980,21.250005],[-646.617168,23.015630],[-647.014628,23.552739],[-647.499980,23.750005],[-648.080381,24.227843],[-648.472667,25.505541],[-648.715146,29.525617],[-648.271917,33.940438],[-647.807068,35.711565],[-647.187480,36.880205],[-645.441390,38.147555],[-643.437480,38.702405],[-642.292011,38.389708],[-641.629355,37.007680],[-641.323886,33.984914],[-641.249980,28.750005]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-446.249982,-5.000005],[-446.617169,-5.882818],[-447.499982,-6.250005],[-448.382794,-5.882818],[-448.749981,-5.000005],[-448.382794,-4.117193],[-447.499982,-3.750005],[-446.617169,-4.117193],[-446.249982,-5.000005]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[468.750030,125.501505],[469.851592,123.943880],[472.500030,121.250005],[474.276921,119.363471],[475.433655,117.530280],[476.061077,115.556577],[476.250030,113.248505],[475.882842,110.071430],[475.485382,109.104961],[475.000030,108.750005],[474.514678,108.574516],[474.117217,108.096692],[473.750030,106.525905],[473.552764,105.520180],[473.015655,104.425880],[471.250030,102.500005],[469.484405,100.721417],[468.750030,98.975605],[468.454132,98.030363],[467.648467,96.730042],[465.000030,93.750005],[462.351592,90.864542],[461.250030,88.846305],[460.669333,87.591146],[459.119802,85.596339],[454.269605,80.506005],[449.010171,75.811746],[446.949093,74.312033],[445.652230,73.750005],[444.913646,73.592314],[444.308805,73.162955],[443.900127,72.527496],[443.750030,71.751505],[443.454132,70.699113],[442.648467,69.311067],[440.000030,66.250005],[437.715116,63.638946],[436.437517,61.220730],[436.316175,59.442152],[436.735644,58.932350],[437.500030,58.750005],[438.382842,59.117192],[438.750030,60.000005],[439.310455,60.882817],[440.657930,61.250005],[441.932685,61.710813],[443.750074,62.946811],[448.134205,66.865830],[452.053224,71.249961],[453.289222,73.067350],[453.750030,74.342105],[453.942641,75.093561],[454.471993,75.699030],[455.265363,76.103011],[456.250030,76.250005],[457.300172,76.401938],[458.086268,76.840492],[458.579244,77.539803],[458.750030,78.474005],[458.947296,79.479774],[459.484405,80.574080],[461.250030,82.500005],[463.015655,84.278555],[463.750030,86.024405],[464.045928,86.969647],[464.851592,88.269967],[467.500030,91.250005],[470.148467,94.153730],[471.250030,96.215805],[471.739938,97.635760],[472.913592,99.295892],[474.326891,100.674532],[475.535730,101.250005],[476.040217,100.515630],[476.250030,98.750005],[475.882842,96.984380],[475.485382,96.447271],[475.000030,96.250005],[474.503372,95.585942],[474.107168,93.750005],[473.750030,87.500005],[473.392892,81.250005],[472.996688,79.414067],[472.500030,78.750005],[472.014678,78.493682],[471.617217,77.795767],[471.250030,75.501505],[470.988374,73.906780],[470.239780,72.184480],[469.058811,70.432817],[467.500030,68.750005],[464.851592,65.864542],[463.750030,63.846305],[463.169333,62.591146],[461.619802,60.596339],[456.769605,55.506005],[451.510171,50.811746],[449.449093,49.312033],[448.152230,48.750005],[447.413646,48.595014],[446.808805,48.173005],[446.400127,47.548421],[446.250030,46.785705],[445.740338,44.854969],[444.429542,43.070492],[442.645066,41.759697],[440.714330,41.250005],[439.930268,41.061796],[439.308055,40.539780],[438.897905,39.747877],[438.750030,38.750005],[438.382842,36.984380],[437.985382,36.447271],[437.500030,36.250005],[437.014678,36.052739],[436.617217,35.515630],[436.250030,33.750005],[436.617217,31.984380],[437.014678,31.447271],[437.500030,31.250005],[438.382842,31.617192],[438.750030,32.500005],[438.947296,32.985357],[439.484405,33.382817],[441.250030,33.750005],[442.240350,33.897372],[443.033093,34.303967],[443.559303,34.916532],[443.750030,35.681805],[443.994147,36.746431],[444.659039,37.997402],[446.846405,40.653630],[449.502633,42.840996],[450.753604,43.505888],[451.818230,43.750005],[452.568316,43.907696],[453.182567,44.337055],[453.597600,44.972514],[453.750030,45.748505],[454.045928,46.800855],[454.851592,48.188905],[457.500030,51.250005],[460.148467,54.139717],[461.250030,56.168205],[462.526544,58.332677],[465.431843,61.732830],[468.579560,64.871121],[470.583330,66.250005],[471.054193,65.148442],[471.250030,62.500005],[470.882842,59.851567],[470.485382,59.045903],[470.000030,58.750005],[469.503372,58.085942],[469.107168,56.250005],[468.750030,50.000005],[468.392892,43.750005],[467.996688,41.914067],[467.500030,41.250005],[467.011725,40.664072],[466.614593,39.062517],[466.250030,33.750005],[465.885430,28.437492],[465.488293,26.835938],[465.000030,26.250005],[464.514678,25.756841],[464.117217,24.414067],[463.750030,20.000005],[463.382842,15.585942],[462.985382,14.243169],[462.500030,13.750005],[462.014678,13.256839],[461.617217,11.914062],[461.250030,7.499995],[460.882842,3.085932],[460.485382,1.743159],[460.000030,1.249995],[459.514678,0.855464],[459.117217,-0.218755],[458.750030,-3.750005],[458.382842,-7.281255],[457.985382,-8.355474],[457.500030,-8.750005],[457.011725,-9.335943],[456.614593,-10.937508],[456.250030,-16.250005],[455.885430,-21.562503],[455.488293,-23.164067],[455.000030,-23.750005],[454.514678,-24.006331],[454.117217,-24.704249],[453.750030,-26.998495],[453.488374,-28.593245],[452.739780,-30.315551],[451.558811,-32.067206],[450.000030,-33.750005],[448.099868,-35.751692],[446.956830,-37.676250],[446.397893,-39.950563],[446.250030,-43.001515],[446.160005,-45.973295],[445.801630,-47.718941],[445.042455,-48.542996],[443.750030,-48.750005],[442.795168,-48.937338],[442.050216,-49.441581],[441.248892,-51.054279],[441.463763,-52.895049],[441.989053,-53.684384],[442.812530,-54.270845],[443.750030,-55.000005],[442.812530,-55.729165],[442.275144,-56.493989],[441.824521,-58.065388],[441.256530,-62.507778],[441.254489,-66.816071],[441.511304,-68.219849],[441.964330,-68.750005],[443.405580,-68.096989],[444.793055,-66.443154],[445.837592,-64.246316],[446.250030,-61.964295],[446.617217,-59.694203],[447.014678,-59.003633],[447.500030,-58.750005],[447.985382,-58.552739],[448.382842,-58.015630],[448.750030,-56.250005],[449.117217,-54.484380],[449.514678,-53.947271],[450.000030,-53.750005],[450.485382,-53.552739],[450.882842,-53.015630],[451.250030,-51.250005],[451.617217,-49.484380],[452.014678,-48.947271],[452.500030,-48.750005],[452.985382,-48.355474],[453.382842,-47.281255],[453.750030,-43.750005],[454.117217,-40.218755],[454.514678,-39.144536],[455.000030,-38.750005],[455.485382,-38.256841],[455.882842,-36.914068],[456.250030,-32.500005],[456.335963,-29.238289],[456.687517,-27.343758],[457.445328,-26.464850],[458.750030,-26.250005],[459.843752,-26.093754],[460.625005,-25.625003],[461.093771,-24.843752],[461.250030,-23.750005],[460.882842,-21.984380],[460.485382,-21.447271],[460.000030,-21.250005],[459.514678,-21.052739],[459.117217,-20.515630],[458.750030,-18.750005],[459.117217,-16.984380],[459.514678,-16.447271],[460.000030,-16.250005],[460.485382,-15.954107],[460.882842,-15.148443],[461.250030,-12.500005],[461.617217,-9.851568],[462.014678,-9.045903],[462.500030,-8.750005],[462.985382,-8.256841],[463.382842,-6.914068],[463.750030,-2.500005],[464.117217,1.914057],[464.514678,3.256831],[465.000030,3.749995],[465.485382,4.243159],[465.882842,5.585932],[466.250030,9.999995],[466.617217,14.414066],[467.014678,15.756841],[467.500030,16.250005],[467.996688,16.914067],[468.392892,18.750005],[468.750030,25.000005],[469.107168,31.250005],[469.503372,33.085942],[470.000030,33.750005],[470.496688,34.414067],[470.892892,36.250005],[471.250030,42.500005],[471.607168,48.750005],[472.003372,50.585942],[472.500030,51.250005],[472.996688,51.914067],[473.392892,53.750005],[473.750030,60.000005],[474.107168,66.250005],[474.503372,68.085942],[475.000030,68.750005],[475.485382,69.024125],[475.882842,69.770492],[476.250030,72.224005],[476.434203,73.760252],[476.949492,75.230255],[477.740050,76.516133],[478.750030,77.500005],[480.515655,79.278555],[481.250030,81.024405],[481.545928,81.969647],[482.351592,83.269967],[485.000030,86.250005],[487.648467,89.144192],[488.750030,91.183305],[489.018101,92.260577],[489.752328,93.470788],[492.199343,95.949042],[495.251250,97.936103],[496.741595,98.532322],[498.068230,98.750005],[500.315380,98.382817],[500.998967,97.985357],[501.250030,97.500005],[500.882842,96.617192],[500.000030,96.250005],[499.503372,95.585942],[499.107168,93.750005],[498.750030,87.500005],[498.392892,81.250005],[497.996688,79.414067],[497.500030,78.750005],[497.011725,78.164072],[496.614593,76.562517],[496.250030,71.250005],[495.885430,65.937492],[495.488293,64.335938],[495.000030,63.750005],[494.514678,63.355474],[494.117217,62.281255],[493.750030,58.750005],[493.382842,55.218755],[492.985382,54.144536],[492.500030,53.750005],[492.014678,53.355474],[491.617217,52.281255],[491.250030,48.750005],[490.882842,45.218755],[490.485382,44.144536],[490.000030,43.750005],[489.514678,43.355474],[489.117217,42.281255],[488.750030,38.750005],[488.382842,35.218755],[487.985382,34.144536],[487.500030,33.750005],[487.014678,33.454107],[486.617217,32.648442],[486.250030,30.000005],[485.882842,27.351567],[485.485382,26.545903],[485.000030,26.250005],[484.514678,25.954107],[484.117217,25.148442],[483.750030,22.500005],[483.382842,19.851567],[482.985382,19.045903],[482.500030,18.750005],[482.014678,18.454107],[481.617217,17.648442],[481.250030,15.000005],[480.882842,12.351562],[480.485382,11.545895],[480.000030,11.249995],[479.514678,11.052729],[479.117217,10.515620],[478.750030,8.749995],[478.382842,6.984370],[477.985382,6.447261],[477.500030,6.249995],[477.014678,5.954097],[476.617217,5.148432],[476.250030,2.499995],[476.132836,0.683592],[475.729180,-0.468753],[474.960949,-1.074223],[473.750030,-1.250005],[472.090125,-1.562745],[471.329292,-2.335715],[471.544453,-3.321040],[472.812530,-4.270845],[473.750030,-5.000005],[472.812530,-5.729165],[472.205830,-6.291752],[471.709005,-7.284513],[471.250030,-10.000005],[470.794317,-12.653204],[470.301022,-13.578536],[469.698630,-14.058785],[469.092991,-14.410903],[468.974318,-14.932736],[470.234430,-16.662955],[471.909052,-18.156596],[472.992505,-18.634009],[473.575821,-18.091645],[473.750030,-16.525955],[473.947296,-15.520221],[474.484405,-14.425916],[476.250030,-12.500005],[478.015655,-10.604694],[478.750030,-8.578215],[479.209005,-6.866864],[480.312530,-5.729165],[481.250030,-5.000005],[480.312530,-4.270845],[479.489053,-3.684384],[478.963763,-2.895049],[478.748892,-1.054279],[479.550216,0.558419],[480.295168,1.062662],[481.250030,1.249995],[482.554689,1.464840],[483.312505,2.343747],[483.664083,4.238279],[483.750030,7.499995],[484.117217,11.914062],[484.514678,13.256839],[485.000030,13.750005],[485.485382,14.144536],[485.882842,15.218755],[486.250030,18.750005],[486.617217,22.281255],[487.014678,23.355474],[487.500030,23.750005],[487.985382,24.045903],[488.382842,24.851567],[488.750030,27.500005],[489.117217,30.148442],[489.514678,30.954107],[490.000030,31.250005],[490.485382,31.644536],[490.882842,32.718755],[491.250030,36.250005],[491.617217,39.781255],[492.014678,40.855474],[492.500030,41.250005],[492.985382,41.644536],[493.382842,42.718755],[493.750030,46.250005],[494.117217,49.781255],[494.514678,50.855474],[495.000030,51.250005],[495.485382,51.644536],[495.882842,52.718755],[496.250030,56.250005],[496.617217,59.781255],[497.014678,60.855474],[497.500030,61.250005],[497.985382,61.644536],[498.382842,62.718755],[498.750030,66.250005],[499.117217,69.781255],[499.514678,70.855474],[500.000030,71.250005],[500.496688,71.914067],[500.892892,73.750005],[501.250030,80.000005],[501.607168,86.250005],[502.003372,88.085942],[502.500030,88.750005],[502.985382,88.947271],[503.382842,89.484380],[503.750030,91.250005],[503.906289,92.343769],[504.375055,93.125017],[505.156308,93.593760],[506.250030,93.750005],[508.015655,93.382817],[508.552764,92.985357],[508.750030,92.500005],[508.947296,92.014653],[509.484405,91.617192],[511.250030,91.250005],[512.578146,91.015635],[513.333355,90.000017],[513.671902,87.734394],[513.750030,83.750005],[513.959830,78.453130],[514.464230,76.250005],[515.219159,76.429585],[515.972574,76.932674],[517.352630,78.695455],[518.359936,81.110511],[518.750030,83.750005],[519.140108,86.389499],[520.147380,88.804555],[521.527402,90.567336],[522.280805,91.070425],[523.035730,91.250005],[523.540217,89.414067],[523.750030,85.000005],[523.382842,80.585942],[522.985382,79.243169],[522.500030,78.750005],[522.014678,78.574516],[521.617217,78.096692],[521.250030,76.525905],[521.052764,75.520180],[520.515655,74.425880],[518.750030,72.500005],[516.984405,70.574080],[516.447296,69.479774],[516.250030,68.474005],[515.882842,66.903305],[515.485382,66.425492],[515.000030,66.250005],[514.514678,66.052739],[514.117217,65.515630],[513.750030,63.750005],[513.602141,62.752133],[513.191967,61.960230],[512.569750,61.438214],[511.785730,61.250005],[509.904396,60.750080],[508.114430,59.478555],[506.776189,57.777805],[506.250030,55.990205],[505.515655,54.268505],[503.750030,52.500005],[502.026063,50.624764],[501.321993,48.576180],[501.368699,47.665870],[501.689916,46.927008],[502.292156,46.431188],[503.181930,46.250005],[505.447555,47.151292],[508.181930,49.318205],[510.348793,52.052580],[511.250030,54.318205],[511.617217,55.682542],[512.500030,56.250005],[512.985382,56.425492],[513.382842,56.903305],[513.750030,58.474005],[513.947296,59.479774],[514.484405,60.574080],[516.250030,62.500005],[518.015655,64.425880],[518.552764,65.520180],[518.750030,66.525905],[519.117217,68.096692],[519.514678,68.574516],[520.000030,68.750005],[520.485382,68.256841],[520.882842,66.914067],[521.250030,62.500005],[520.882842,58.085942],[520.485382,56.743169],[520.000030,56.250005],[519.503372,55.585942],[519.107168,53.750005],[518.750030,47.500005],[518.392855,41.250005],[517.996646,39.414067],[517.500030,38.750005],[517.011725,38.164072],[516.614593,36.562517],[516.250030,31.250005],[515.885468,25.937492],[515.488335,24.335938],[515.000030,23.750005],[514.514678,23.454107],[514.117217,22.648442],[513.750030,20.000005],[513.382842,17.351567],[512.985382,16.545903],[512.500030,16.250005],[512.011725,15.664072],[511.614593,14.062516],[511.250030,8.749995],[510.885467,3.437497],[510.488335,1.835933],[510.000030,1.249995],[509.514678,0.756831],[509.117217,-0.585943],[508.750030,-5.000005],[508.382842,-9.414068],[507.985382,-10.756841],[507.500030,-11.250005],[507.014678,-11.644536],[506.617217,-12.718755],[506.250030,-16.250005],[505.882842,-19.781255],[505.485382,-20.855474],[505.000030,-21.250005],[504.514678,-21.599702],[504.117217,-22.551848],[503.750030,-25.681815],[503.551707,-27.496224],[502.998028,-29.331913],[501.072343,-32.742638],[498.468450,-35.264998],[497.067014,-35.990233],[495.681830,-36.250005],[494.317493,-36.617193],[493.750030,-37.500005],[494.117217,-38.382818],[495.000030,-38.750005],[495.485382,-39.045903],[495.882842,-39.851568],[496.250030,-42.500005],[495.882842,-45.148443],[495.485382,-45.954107],[495.000030,-46.250005],[494.497086,-46.992192],[494.101580,-49.062503],[493.750030,-56.250005],[494.101580,-63.437508],[494.497086,-65.507818],[495.000030,-66.250005],[495.485382,-66.074513],[495.882842,-65.596688],[496.250030,-64.025955],[496.447296,-63.020221],[496.984405,-61.925916],[498.750030,-60.000005],[499.760010,-59.016123],[500.550568,-57.730261],[501.065857,-56.260284],[501.250030,-54.724055],[501.617217,-52.270510],[502.014678,-51.524130],[502.500030,-51.250005],[502.985382,-50.954107],[503.382842,-50.148443],[503.750030,-47.500005],[504.117217,-44.851568],[504.514678,-44.045903],[505.000030,-43.750005],[505.485382,-43.355474],[505.882842,-42.281255],[506.250030,-38.750005],[506.513893,-35.718418],[507.205405,-34.021066],[507.664620,-33.726122],[508.174455,-33.828809],[509.270930,-35.312505],[510.000030,-36.250005],[510.729130,-35.312505],[511.947943,-34.208991],[513.854130,-33.750005],[515.546255,-33.382818],[516.060986,-32.985357],[516.250030,-32.500005],[515.673030,-31.617193],[514.285730,-31.250005],[513.112896,-31.098606],[512.046941,-30.659177],[510.296693,-29.004820],[509.157038,-26.464128],[508.750030,-23.214295],[508.854708,-20.984943],[509.237505,-19.620544],[510.001564,-18.936948],[511.250030,-18.750005],[512.343752,-18.593754],[513.125005,-18.125003],[513.593771,-17.343752],[513.750030,-16.250005],[513.382842,-14.484380],[512.985382,-13.947271],[512.500030,-13.750005],[512.014678,-13.355474],[511.617217,-12.281255],[511.250030,-8.750005],[511.617217,-5.218755],[512.014678,-4.144536],[512.500030,-3.750005],[512.985382,-3.454107],[513.382842,-2.648443],[513.750030,-0.000005],[514.117217,2.648432],[514.514678,3.454097],[515.000030,3.749995],[515.485382,4.144526],[515.882842,5.218745],[516.250030,8.749995],[516.617217,12.281254],[517.014678,13.355474],[517.500030,13.750005],[517.996646,14.414067],[518.392855,16.250005],[518.750030,22.500005],[519.107168,28.750005],[519.503372,30.585942],[520.000030,31.250005],[520.485382,31.743169],[520.882842,33.085942],[521.250030,37.500005],[521.617217,41.914067],[522.014678,43.256841],[522.500030,43.750005],[522.996646,44.414067],[523.392855,46.250005],[523.750030,52.500005],[524.107168,58.750005],[524.503372,60.585942],[525.000030,61.250005],[525.502932,61.992197],[525.898443,64.062517],[526.250030,71.250005],[526.601617,78.437492],[526.997128,80.507813],[527.500030,81.250005],[527.985382,81.447271],[528.382842,81.984380],[528.750030,83.750005],[529.117217,85.515630],[529.514678,86.052739],[530.000030,86.250005],[530.485382,86.447271],[530.882842,86.984380],[531.250030,88.750005],[531.617217,90.515630],[532.014678,91.052739],[532.500030,91.250005],[533.031619,89.335938],[533.423943,83.749992],[533.750030,62.500005],[533.423943,41.250017],[533.031619,35.664072],[532.500030,33.750005],[532.003372,33.085942],[531.607168,31.250005],[531.250030,25.000005],[530.892855,18.750005],[530.496646,16.914067],[530.000030,16.250005],[529.485105,15.273442],[529.090930,12.500002],[528.750030,2.499995],[528.409130,-7.500008],[528.014955,-10.273443],[527.500030,-11.250005],[527.011725,-11.835943],[526.614593,-13.437508],[526.250030,-18.750005],[525.885468,-24.062503],[525.488335,-25.664067],[525.000030,-26.250005],[524.514678,-26.537685],[524.117217,-27.320971],[523.750030,-29.895845],[523.291055,-32.684901],[522.794230,-33.700040],[522.187530,-34.270845],[521.250030,-35.000005],[522.187530,-35.729165],[522.807037,-36.214698],[523.271921,-36.956659],[523.715380,-38.813908],[523.473039,-40.508995],[523.080673,-41.048254],[522.500030,-41.250005],[522.014678,-41.644536],[521.617217,-42.718755],[521.250030,-46.250005],[520.882842,-49.781255],[520.485382,-50.855474],[520.000030,-51.250005],[519.514678,-51.425496],[519.117217,-51.903319],[518.750030,-53.474055],[518.552764,-54.479793],[518.015655,-55.574098],[516.250030,-57.500005],[514.484405,-59.425916],[513.947296,-60.520221],[513.750030,-61.525955],[513.382842,-63.096688],[512.985382,-63.574513],[512.500030,-63.750005],[511.916434,-64.059261],[511.523027,-64.881924],[511.282205,-67.436860],[511.728421,-70.153578],[512.193810,-71.178470],[512.812530,-71.770845],[513.750030,-72.500005],[512.812530,-73.229165],[511.709005,-74.447921],[511.250030,-76.354165],[510.882842,-78.046230],[510.485382,-78.560959],[510.000030,-78.750005],[509.514678,-79.243169],[509.117217,-80.585943],[508.750030,-85.000005],[508.382842,-89.414068],[507.985382,-90.756841],[507.500030,-91.250005],[507.014678,-91.447271],[506.617217,-91.984380],[506.250030,-93.750005],[506.617217,-95.515630],[507.014678,-96.052739],[507.500030,-96.250005],[507.985382,-96.644536],[508.382842,-97.718755],[508.750030,-101.250005],[509.117217,-104.781255],[509.514678,-105.855474],[510.000030,-106.250005],[510.485382,-106.074513],[510.882842,-105.596688],[511.250030,-104.025955],[511.447296,-103.020217],[511.984405,-101.925913],[513.750030,-100.000005],[514.760010,-99.016123],[515.550567,-97.730261],[516.065857,-96.260284],[516.250030,-94.724055],[516.617217,-92.270510],[517.014678,-91.524130],[517.500030,-91.250005],[517.985382,-90.855474],[518.382842,-89.781255],[518.750030,-86.250005],[519.117217,-82.718755],[519.514678,-81.644536],[520.000030,-81.250005],[520.485382,-80.863694],[520.882842,-79.811855],[521.250030,-76.354165],[521.708817,-72.681741],[522.205619,-71.398465],[522.812530,-70.729165],[523.750030,-70.000005],[522.812530,-69.270845],[521.544453,-68.321040],[521.329292,-67.335715],[522.090125,-66.562745],[523.750030,-66.250005],[525.019589,-66.054692],[525.781305,-65.312503],[526.152383,-63.789065],[526.250030,-61.250005],[525.882842,-57.718755],[525.485382,-56.644536],[525.000030,-56.250005],[524.514678,-55.855474],[524.117217,-54.781255],[523.750030,-51.250005],[523.847677,-48.710945],[524.218755,-47.187508],[524.980471,-46.445318],[526.250030,-46.250005],[527.454283,-46.075850],[528.223255,-45.481773],[528.630614,-44.360351],[528.750030,-42.604165],[528.291055,-39.815109],[527.794230,-38.799970],[527.187530,-38.229165],[526.250030,-37.500005],[527.187530,-36.770845],[527.865822,-35.904172],[528.354693,-34.038663],[528.750030,-27.395845],[528.750030,-18.750005],[533.750030,-18.750005],[537.281280,-18.382818],[538.355499,-17.985357],[538.750030,-17.500005],[538.454132,-17.014653],[537.648467,-16.617193],[535.000030,-16.250005],[533.017897,-16.132818],[531.883967,-15.633685],[531.370569,-14.531253],[531.250030,-12.604165],[531.709005,-9.843065],[532.205830,-8.858185],[532.812530,-8.324325],[533.460457,-7.951196],[533.629518,-7.515458],[532.500030,-6.250005],[531.370505,-4.984553],[531.539561,-4.548814],[532.187530,-4.175685],[532.854600,-3.416702],[533.344718,-1.787669],[533.750030,3.854155],[534.115343,9.088536],[534.512569,10.670568],[535.000030,11.249995],[535.517613,12.304679],[535.911493,15.312487],[536.250030,26.250005],[536.588567,37.187517],[536.982447,40.195322],[537.500030,41.250005],[538.029299,42.929697],[538.421880,47.812517],[538.750030,66.250005],[538.750030,91.250005],[541.964230,91.250005],[543.760978,91.117052],[545.236191,90.688936],[546.415133,89.921774],[547.323067,88.771680],[547.985260,87.194771],[548.426975,85.147161],[548.750030,79.464305],[548.389968,73.616067],[547.993397,71.880582],[547.500030,71.250005],[547.014678,70.954107],[546.617217,70.148442],[546.250030,67.500005],[545.882842,64.851567],[545.485382,64.045903],[545.000030,63.750005],[544.514678,63.552739],[544.117217,63.015630],[543.750030,61.250005],[543.382842,59.484380],[542.985382,58.947271],[542.500030,58.750005],[542.014678,58.355474],[541.617217,57.281255],[541.250030,53.750005],[541.459830,50.218755],[541.964230,48.750005],[543.405580,49.403021],[544.793080,51.056855],[545.837605,53.253689],[546.250030,55.535705],[546.617217,57.805817],[547.014678,58.496382],[547.500030,58.750005],[547.985382,58.947271],[548.382842,59.484380],[548.750030,61.250005],[549.117217,63.015630],[549.514678,63.552739],[550.000030,63.750005],[550.527329,62.226572],[550.920111,57.812517],[551.249980,41.250005],[550.920111,24.687492],[550.527329,20.273438],[550.000030,18.750005],[549.514678,18.454107],[549.117217,17.648442],[548.750030,15.000005],[549.117217,12.351562],[549.514678,11.545895],[550.000030,11.249995],[550.485374,11.052729],[550.882818,10.515620],[551.249980,8.749995],[550.882818,6.984370],[550.485374,6.447261],[550.000030,6.249995],[549.478271,5.039058],[549.084855,1.562497],[548.750030,-11.250005],[548.415168,-24.062508],[548.021747,-27.539068],[547.500030,-28.750005],[546.988311,-29.648443],[546.593780,-32.187505],[546.250030,-41.250005],[545.906280,-50.312505],[545.511749,-52.851568],[545.000030,-53.750005],[544.514678,-53.947271],[544.117217,-54.484380],[543.750030,-56.250005],[543.382842,-58.015630],[542.985382,-58.552739],[542.500030,-58.750005],[541.617217,-58.382818],[541.250030,-57.500005],[541.052764,-57.014653],[540.515655,-56.617193],[538.750030,-56.250005],[536.984405,-56.617193],[536.447296,-57.014653],[536.250030,-57.500005],[536.447296,-57.985357],[536.984405,-58.382818],[538.750030,-58.750005],[539.800130,-58.901944],[540.586230,-59.340514],[541.079230,-60.039841],[541.250030,-60.974055],[541.052764,-61.979789],[540.515655,-63.074094],[538.750030,-65.000005],[537.154627,-66.761702],[536.328030,-68.822903],[536.399933,-70.535154],[536.813351,-71.057783],[537.500030,-71.250005],[537.985382,-71.545903],[538.382842,-72.351568],[538.750030,-75.000005],[538.382842,-77.648443],[537.985382,-78.454107],[537.500030,-78.750005],[537.014678,-79.037683],[536.617217,-79.820968],[536.250030,-82.395845],[535.791055,-85.184901],[535.294230,-86.200040],[534.687530,-86.770845],[533.750030,-87.500005],[534.687530,-88.229165],[535.307037,-88.714698],[535.771921,-89.456659],[536.215380,-91.313908],[535.973039,-93.008995],[535.580673,-93.548254],[535.000030,-93.750005],[534.514678,-93.947271],[534.117217,-94.484380],[533.750030,-96.250005],[534.117217,-98.015630],[534.514678,-98.552739],[535.000030,-98.750005],[535.488335,-99.335943],[535.885468,-100.937508],[536.250030,-106.250005],[536.614593,-111.562503],[537.011725,-113.164067],[537.500030,-113.750005],[537.985382,-113.377247],[538.382842,-112.362313],[538.750030,-109.025955],[538.895813,-106.794745],[539.347117,-104.999799],[540.124878,-103.586444],[541.250030,-102.500005],[543.015655,-100.574094],[543.552764,-99.479789],[543.750030,-98.474055],[544.117217,-96.903319],[544.514678,-96.425496],[545.000030,-96.250005],[545.487491,-95.670578],[545.884717,-94.088546],[546.250030,-88.854165],[546.655342,-83.212341],[547.145460,-81.583308],[547.812530,-80.824325],[548.460457,-80.451196],[548.629518,-80.015458],[547.500030,-78.750005],[546.370505,-77.484551],[546.539561,-77.048810],[547.187530,-76.675675],[547.806742,-76.226821],[548.271808,-75.510938],[548.716280,-73.681084],[548.474502,-71.992107],[548.081755,-71.452322],[547.500030,-71.250005],[547.014678,-71.052739],[546.617217,-70.515630],[546.250030,-68.750005],[546.617217,-66.984380],[547.014678,-66.447271],[547.500030,-66.250005],[548.382842,-66.617193],[548.750030,-67.500005],[549.117217,-68.382818],[550.000030,-68.750005],[550.485374,-68.454107],[550.882818,-67.648443],[551.249980,-65.000005],[550.882818,-62.351568],[550.485374,-61.545903],[550.000030,-61.250005],[549.514678,-60.756841],[549.117217,-59.414068],[548.750030,-55.000005],[549.117217,-50.585943],[549.514678,-49.243169],[550.000030,-48.750005],[550.882818,-49.117193],[551.249980,-50.000005],[551.617168,-50.882818],[552.499980,-51.250005],[552.985332,-51.052739],[553.382793,-50.515630],[553.749980,-48.750005],[553.382793,-46.984380],[552.985332,-46.447271],[552.499980,-46.250005],[551.988261,-45.351568],[551.593730,-42.812505],[551.249980,-33.750005],[551.593730,-24.687505],[551.988261,-22.148443],[552.499980,-21.250005],[553.019799,-20.117193],[553.413430,-16.875005],[553.749980,-5.000005],[554.086493,6.874995],[554.480119,10.117182],[554.999980,11.249995],[555.343652,11.779137],[555.634747,13.275478],[556.062764,18.623267],[556.327005,34.913787],[555.849608,51.377614],[555.350579,56.942036],[555.039094,58.579189],[554.687480,59.270805],[553.749980,60.000005],[554.687480,60.729205],[555.306987,61.214719],[555.771871,61.956667],[556.215330,63.813905],[555.972989,65.508992],[555.580623,66.048253],[554.999980,66.250005],[554.492143,67.070313],[554.097180,69.374992],[553.749980,77.500005],[553.815072,83.652363],[554.131893,87.031267],[554.441674,87.937026],[554.882757,88.457041],[556.249980,88.750005],[558.015605,88.382817],[558.552714,87.985357],[558.749980,87.500005],[559.045878,87.014653],[559.851543,86.617192],[562.499980,86.250005],[565.148418,85.882817],[565.954082,85.485357],[566.249980,85.000005],[565.882793,84.117192],[564.999980,83.750005],[564.514628,83.560963],[564.117168,83.046242],[563.749980,81.354205],[563.291005,79.498205],[562.187480,78.400305],[561.377855,77.687068],[561.733580,76.733605],[562.687030,76.377955],[563.400180,77.187505],[564.289063,78.615333],[564.763959,78.778343],[565.219393,78.604605],[565.952566,77.338452],[566.249980,75.000005],[566.367160,73.183585],[566.770792,72.031242],[567.539019,71.425782],[568.749980,71.250005],[570.054639,71.464844],[570.812455,72.343742],[571.164033,74.238272],[571.249980,77.500005],[571.335927,80.761738],[571.687505,82.656267],[572.445321,83.535166],[573.749980,83.750005],[575.515605,83.382817],[576.052714,82.985357],[576.249980,82.500005],[576.447246,82.014653],[576.984355,81.617192],[578.749980,81.250005],[580.019539,81.054697],[580.781255,80.312517],[581.152333,78.789082],[581.249980,76.250005],[581.617168,72.718755],[582.014628,71.644536],[582.499980,71.250005],[583.382793,70.882817],[583.749980,70.000005],[583.150468,69.117192],[581.709080,68.750005],[579.593718,67.972880],[577.373880,66.104505],[576.136074,64.911936],[574.884355,64.229855],[573.512599,64.022299],[571.914680,64.253305],[570.430477,64.527071],[569.452580,64.449705],[568.914558,63.998014],[568.749980,63.148805],[568.594989,62.411553],[568.172980,61.807792],[567.548396,61.399838],[566.785680,61.250005],[564.873893,60.725442],[563.035680,59.464305],[561.826653,57.707193],[561.303418,55.838930],[561.512388,54.354780],[561.905955,53.911517],[562.499980,53.750005],[563.382793,54.117192],[563.749980,55.000005],[563.947246,55.485357],[564.484355,55.882817],[566.249980,56.250005],[568.015605,56.617192],[568.552714,57.014653],[568.749980,57.500005],[568.925482,57.985357],[569.403317,58.382817],[570.973980,58.750005],[571.979721,58.947271],[573.074055,59.484380],[574.999980,61.250005],[576.925867,63.015630],[578.020197,63.552739],[579.025980,63.750005],[580.596643,64.117192],[581.074478,64.514653],[581.249980,65.000005],[581.617168,65.882817],[582.499980,66.250005],[583.215279,65.950174],[583.641618,65.143888],[583.707305,62.571192],[582.856830,59.650403],[582.137965,58.409000],[581.249980,57.500005],[579.484355,55.731430],[578.749980,54.009805],[578.245271,52.325649],[576.990130,50.613405],[575.373039,49.284411],[573.782480,48.750005],[572.862549,48.494560],[571.729377,47.802155],[569.237430,45.550055],[567.134883,42.880880],[566.488461,41.667132],[566.249980,40.681805],[565.882793,39.317467],[564.999980,38.750005],[564.514628,38.552739],[564.117168,38.015630],[563.749980,36.250005],[563.897868,35.252133],[564.308030,34.460230],[564.930218,33.938214],[565.714180,33.750005],[567.544778,34.240527],[569.340418,35.474730],[570.706888,37.096571],[571.249980,38.750005],[571.793071,40.403439],[573.159530,42.025280],[574.955139,43.259483],[576.785680,43.750005],[577.647157,43.965878],[578.260767,44.615167],[578.627910,45.700375],[578.749980,47.224005],[578.934153,48.760252],[579.449443,50.230255],[580.240000,51.516133],[581.249980,52.500005],[583.015605,54.425880],[583.552714,55.520180],[583.749980,56.525905],[583.920766,57.460164],[584.413742,58.159505],[585.199838,58.598071],[586.249980,58.750005],[587.442336,58.921469],[588.212630,59.496742],[588.626599,60.567147],[588.749980,62.224005],[588.934153,63.760252],[589.449443,65.230255],[590.240000,66.516133],[591.249980,67.500005],[593.015605,69.268505],[593.749980,70.990205],[594.276139,72.777805],[595.614380,74.478555],[597.404346,75.750080],[599.285680,76.250005],[600.161796,76.026289],[600.773780,75.340930],[601.132789,74.172608],[601.249980,72.500005],[600.882793,69.851567],[600.485332,69.045903],[599.999980,68.750005],[599.514628,68.454107],[599.117168,67.648442],[598.749980,65.000005],[598.382793,62.351567],[597.985332,61.545903],[597.499980,61.250005],[597.014628,60.855474],[596.617168,59.781255],[596.249980,56.250005],[595.882793,52.718755],[595.485332,51.644536],[594.999980,51.250005],[594.514628,51.052739],[594.117168,50.515630],[593.749980,48.750005],[593.382793,46.984380],[592.985332,46.447271],[592.499980,46.250005],[592.014628,46.052739],[591.617168,45.515630],[591.249980,43.750005],[590.882793,41.984380],[590.485332,41.447271],[589.999980,41.250005],[589.514628,41.052739],[589.117168,40.515630],[588.749980,38.750005],[588.382793,36.984380],[587.985332,36.447271],[587.499980,36.250005],[587.014628,36.052739],[586.617168,35.515630],[586.249980,33.750005],[585.882793,31.984380],[585.485332,31.447271],[584.999980,31.250005],[584.514628,31.052739],[584.117168,30.515630],[583.749980,28.750005],[583.382793,26.984380],[582.985332,26.447271],[582.499980,26.250005],[582.014628,26.052739],[581.617168,25.515630],[581.249980,23.750005],[580.882793,21.984380],[580.485332,21.447271],[579.999980,21.250005],[579.514628,21.052739],[579.117168,20.515630],[578.749980,18.750005],[578.382793,16.984380],[577.985332,16.447271],[577.499980,16.250005],[577.014628,16.052739],[576.617168,15.515630],[576.249980,13.750005],[575.882793,11.984375],[575.485332,11.447262],[574.999980,11.249995],[574.514628,11.052729],[574.117168,10.515620],[573.749980,8.749995],[573.593721,7.656248],[573.124955,6.874997],[572.343702,6.406246],[571.249980,6.249995],[569.990714,6.058993],[569.227855,5.346986],[568.851058,3.905471],[568.749980,1.525945],[568.604197,-0.705265],[568.152893,-2.500211],[567.375132,-3.913566],[566.249980,-5.000005],[565.240000,-5.983887],[564.449443,-7.269749],[563.934153,-8.739726],[563.749980,-10.275955],[563.382793,-12.729500],[562.985332,-13.475880],[562.499980,-13.750005],[562.014628,-14.045903],[561.617168,-14.851568],[561.249980,-17.500005],[560.882793,-20.148443],[560.485332,-20.954107],[559.999980,-21.250005],[559.514628,-21.447271],[559.117168,-21.984380],[558.749980,-23.750005],[558.382793,-25.515630],[557.985332,-26.052739],[557.499980,-26.250005],[557.014628,-26.545903],[556.617168,-27.351568],[556.249980,-30.000005],[556.450305,-32.648443],[556.931880,-33.750005],[558.638669,-32.742384],[560.911118,-30.390666],[562.898472,-27.701570],[563.749980,-25.681815],[564.117168,-24.317473],[564.999980,-23.750005],[565.485332,-23.454107],[565.882793,-22.648443],[566.249980,-20.000005],[566.617168,-17.351568],[567.014628,-16.545903],[567.499980,-16.250005],[567.985332,-16.052739],[568.382793,-15.515630],[568.749980,-13.750005],[569.117168,-11.984380],[569.514628,-11.447271],[569.999980,-11.250005],[570.485332,-11.060959],[570.882793,-10.546230],[571.249980,-8.854165],[571.708955,-6.975878],[572.812480,-5.824325],[573.460407,-5.451196],[573.629468,-5.015458],[572.499980,-3.750005],[571.370455,-2.484553],[571.539511,-2.048814],[572.187480,-1.675685],[573.291005,-0.524133],[573.749980,1.354155],[574.117168,3.046220],[574.514628,3.560949],[574.999980,3.749995],[575.485332,3.947261],[575.882793,4.484370],[576.249980,6.249995],[576.617168,8.015620],[577.014628,8.552729],[577.499980,8.749995],[577.985332,8.947261],[578.382793,9.484370],[578.749980,11.249995],[579.117168,13.015629],[579.514628,13.552739],[579.999980,13.750005],[580.485332,13.947271],[580.882793,14.484380],[581.249980,16.250005],[581.617168,18.015630],[582.014628,18.552739],[582.499980,18.750005],[582.985332,19.045903],[583.382793,19.851567],[583.749980,22.500005],[584.117168,25.148442],[584.514628,25.954107],[584.999980,26.250005],[585.882793,26.837055],[586.249980,28.248505],[586.545878,29.300855],[587.351543,30.688905],[589.999980,33.750005],[592.648418,36.811067],[593.454082,38.199113],[593.749980,39.251505],[594.117168,40.662955],[594.999980,41.250005],[595.485332,41.447271],[595.882793,41.984380],[596.249980,43.750005],[596.617168,45.515630],[597.014628,46.052739],[597.499980,46.250005],[597.985332,46.545903],[598.382793,47.351567],[598.749980,50.000005],[599.117168,52.648442],[599.514628,53.454107],[599.999980,53.750005],[600.485332,53.256841],[600.882793,51.914067],[601.249980,47.500005],[600.882793,43.085942],[600.485332,41.743169],[599.999980,41.250005],[599.511675,40.664072],[599.114542,39.062517],[598.749980,33.750005],[598.385418,28.437492],[597.988285,26.835938],[597.499980,26.250005],[597.014628,25.855474],[596.617168,24.781255],[596.249980,21.250005],[595.882793,17.718755],[595.485332,16.644536],[594.999980,16.250005],[594.514628,15.975883],[594.117168,15.229505],[593.749980,12.775905],[593.565807,11.239699],[593.050518,9.769734],[592.259960,8.483877],[591.249980,7.499995],[589.484355,5.731452],[588.749980,4.009755],[588.223819,2.222195],[586.885568,0.521455],[585.095572,-0.750075],[583.214180,-1.250005],[582.451522,-1.425496],[581.826967,-1.903319],[581.404969,-2.610497],[581.249980,-3.474055],[581.052714,-4.479789],[580.515605,-5.574094],[578.749980,-7.500005],[577.753416,-8.472561],[576.961368,-9.748108],[576.438625,-11.192550],[576.249980,-12.671795],[575.791005,-15.215691],[575.294180,-16.117129],[574.687480,-16.599705],[573.856980,-17.286548],[574.054580,-18.154275],[574.626705,-18.303472],[575.497255,-17.973036],[577.660380,-16.137905],[579.808768,-14.266499],[580.484960,-14.190731],[580.897480,-14.687505],[581.716711,-15.969415],[582.655755,-16.177841],[583.428786,-15.406725],[583.749980,-13.750005],[583.906239,-12.656258],[584.375005,-11.875008],[585.156258,-11.406256],[586.249980,-11.250005],[587.344627,-11.404823],[588.112928,-11.838722],[588.556815,-12.505872],[588.678218,-13.360439],[587.961288,-15.448501],[585.977580,-17.736255],[584.648938,-18.995121],[584.072518,-19.894781],[584.204228,-20.593616],[584.999980,-21.250005],[585.795732,-21.906390],[585.927443,-22.605225],[585.351022,-23.504888],[584.022380,-24.763755],[582.722661,-26.168598],[581.865930,-27.818573],[581.394324,-29.875201],[581.249980,-32.500005],[581.103871,-35.131381],[580.625980,-37.204018],[579.756964,-38.883193],[578.437480,-40.334185],[576.699593,-42.359685],[576.667363,-42.997023],[577.187480,-43.397465],[577.806479,-43.818158],[578.271702,-44.514013],[578.716980,-46.322814],[578.475633,-48.007075],[578.082575,-48.547256],[577.499980,-48.750005],[577.014628,-48.947271],[576.617168,-49.484380],[576.249980,-51.250005],[575.882793,-53.015630],[575.485332,-53.552739],[574.999980,-53.750005],[574.514628,-54.122763],[574.117168,-55.137698],[573.749980,-58.474055],[573.604197,-60.705265],[573.152893,-62.500211],[572.375132,-63.913566],[571.249980,-65.000005],[570.124828,-66.086444],[569.347068,-67.499799],[568.895763,-69.294745],[568.749980,-71.525955],[568.959780,-74.862312],[569.464180,-76.250005],[570.752600,-75.651449],[572.157093,-74.192546],[573.286578,-72.378445],[573.749980,-70.714295],[573.938189,-69.930255],[574.460205,-69.308044],[575.252108,-68.897885],[576.249980,-68.750005],[577.460941,-68.574223],[578.229168,-67.968753],[578.632800,-66.816408],[578.749980,-65.000005],[579.117168,-62.351567],[579.514628,-61.545903],[579.999980,-61.250005],[580.580623,-61.048254],[580.972989,-60.508995],[581.215330,-58.813908],[580.771871,-56.956659],[580.306987,-56.214698],[579.687480,-55.729165],[578.749980,-55.000005],[579.687480,-54.270845],[580.294391,-53.601546],[580.791193,-52.318273],[581.249980,-48.645845],[581.617168,-45.188159],[582.014628,-44.136318],[582.499980,-43.750005],[582.985332,-43.454107],[583.382793,-42.648442],[583.749980,-40.000005],[584.117168,-37.351567],[584.514628,-36.545903],[584.999980,-36.250005],[585.485332,-36.052739],[585.882793,-35.515630],[586.249980,-33.750005],[586.617168,-31.984380],[587.014628,-31.447271],[587.499980,-31.250005],[588.382793,-31.617192],[588.749980,-32.500005],[589.117168,-33.382817],[589.999980,-33.750005],[590.485332,-33.552739],[590.882793,-33.015630],[591.249980,-31.250005],[590.882793,-29.484380],[590.485332,-28.947271],[589.999980,-28.750005],[589.514628,-28.454107],[589.117168,-27.648442],[588.749980,-25.000005],[588.867160,-23.183602],[589.270792,-22.031257],[590.039019,-21.425787],[591.249980,-21.250005],[593.015605,-20.882817],[593.552714,-20.485357],[593.749980,-20.000005],[593.382793,-19.117192],[592.499980,-18.750005],[592.014628,-18.355474],[591.617168,-17.281255],[591.249980,-13.750005],[591.617168,-10.218755],[592.014628,-9.144536],[592.499980,-8.750005],[593.382793,-8.182537],[593.749980,-6.818195],[594.032103,-5.672235],[594.781539,-4.313696],[597.100755,-1.532075],[599.544433,0.380281],[600.449448,0.652238],[600.949380,0.276985],[601.645368,-0.801450],[602.604080,-1.250005],[603.155960,-1.047075],[603.520183,-0.504950],[603.715855,1.196878],[603.251489,3.055474],[602.187480,4.270835],[601.249980,4.999995],[602.187480,5.729155],[603.291005,6.947911],[603.749980,8.854155],[603.933392,9.999992],[604.551580,10.737841],[605.706468,11.132807],[607.499980,11.249995],[609.464225,11.367179],[610.600143,11.851988],[611.123478,12.904302],[611.249980,14.724005],[611.434153,16.260252],[611.949443,17.730255],[612.740000,19.016133],[613.749980,20.000005],[615.515605,21.768505],[616.249980,23.490205],[616.727428,25.019702],[617.880318,26.749130],[619.289463,28.164046],[620.535680,28.750005],[621.040168,26.914068],[621.249980,22.500005],[620.882793,18.085943],[620.485332,16.743169],[619.999980,16.250005],[619.514628,15.855474],[619.117168,14.781254],[618.749980,11.249995],[618.382793,7.718745],[617.985332,6.644526],[617.499980,6.249995],[617.014628,5.855464],[616.617168,4.781245],[616.249980,1.249995],[615.882793,-2.281255],[615.485332,-3.355474],[614.999980,-3.750005],[614.514628,-4.045903],[614.117168,-4.851567],[613.749980,-7.500005],[613.382793,-10.148442],[612.985332,-10.954107],[612.499980,-11.250005],[612.014628,-11.545903],[611.617168,-12.351567],[611.249980,-15.000005],[610.882793,-17.648442],[610.485332,-18.454107],[609.999980,-18.750005],[609.117168,-19.327011],[608.749980,-20.714295],[608.240286,-22.645032],[606.929480,-24.429512],[605.144974,-25.740311],[603.214180,-26.250005],[601.826967,-26.617192],[601.249980,-27.500005],[601.447246,-27.985357],[601.984355,-28.382817],[603.749980,-28.750005],[605.552578,-28.954172],[605.986137,-29.228542],[606.106568,-29.634800],[605.404138,-30.894075],[603.437480,-32.834185],[601.699593,-34.859685],[601.667363,-35.497023],[602.187480,-35.897465],[602.806479,-36.318158],[603.271702,-37.014013],[603.716980,-38.822814],[603.475633,-40.507075],[603.082575,-41.047256],[602.499980,-41.250005],[602.014628,-41.447271],[601.617168,-41.984380],[601.249980,-43.750005],[600.882793,-45.515630],[600.485332,-46.052739],[599.999980,-46.250005],[599.514628,-46.545903],[599.117168,-47.351567],[598.749980,-50.000005],[598.382793,-52.648442],[597.985332,-53.454107],[597.499980,-53.750005],[597.014628,-54.045903],[596.617168,-54.851567],[596.249980,-57.500005],[595.882793,-60.148442],[595.485332,-60.954107],[594.999980,-61.250005],[594.514628,-61.447271],[594.117168,-61.984380],[593.749980,-63.750005],[593.959780,-65.515630],[594.464180,-66.250005],[595.710455,-65.664045],[597.119630,-64.249131],[598.272530,-62.519715],[598.749980,-60.990245],[599.484355,-59.268547],[601.249980,-57.500005],[603.015605,-55.574097],[603.552714,-54.479793],[603.749980,-53.474055],[604.117168,-51.903319],[604.514628,-51.425496],[604.999980,-51.250005],[605.486007,-50.681314],[605.883393,-49.131492],[606.249980,-44.025955],[606.358821,-40.376051],[606.748555,-37.883282],[607.514002,-36.205363],[608.749980,-35.000005],[609.759960,-34.016123],[610.550518,-32.730261],[611.065807,-31.260284],[611.249980,-29.724055],[611.617168,-27.270510],[612.014628,-26.524130],[612.499980,-26.250005],[612.985332,-25.855474],[613.382793,-24.781255],[613.749980,-21.250005],[614.117168,-17.718755],[614.514628,-16.644536],[614.999980,-16.250005],[615.485332,-15.954107],[615.882793,-15.148442],[616.249980,-12.500005],[616.617168,-9.851567],[617.014628,-9.045903],[617.499980,-8.750005],[617.985332,-8.355474],[618.382793,-7.281255],[618.749980,-3.750005],[619.117168,-0.218755],[619.514628,0.855464],[619.999980,1.249995],[620.485332,1.545893],[620.882793,2.351558],[621.249980,4.999995],[621.617168,7.648433],[622.014628,8.454097],[622.499980,8.749995],[623.011699,7.851558],[623.406230,5.312495],[623.749980,-3.750005],[624.093730,-12.812505],[624.488261,-15.351567],[624.999980,-16.250005],[625.485332,-16.743169],[625.882793,-18.085942],[626.249980,-22.500005],[625.882793,-26.914067],[625.485332,-28.256841],[624.999980,-28.750005],[624.514628,-28.947271],[624.117168,-29.484380],[623.749980,-31.250005],[624.117168,-33.015630],[624.514628,-33.552739],[624.999980,-33.750005],[625.485332,-34.045903],[625.882793,-34.851567],[626.249980,-37.500005],[625.882793,-40.148442],[625.485332,-40.954107],[624.999980,-41.250005],[624.414748,-41.666723],[624.020741,-42.772690],[623.780692,-46.187235],[624.228413,-49.763375],[624.694117,-51.071335],[625.312480,-51.770845],[626.249980,-52.500005],[625.312480,-53.229165],[624.584196,-54.556660],[624.100880,-57.982081],[623.749980,-72.604165],[623.416542,-86.276046],[623.023300,-89.967453],[622.499980,-91.250005],[621.617168,-91.849514],[621.249980,-93.290875],[620.423818,-95.467340],[618.437480,-97.834185],[616.699593,-99.859685],[616.667363,-100.497023],[617.187480,-100.897465],[617.794180,-101.394702],[618.291005,-102.333949],[618.749980,-105.000005],[618.291005,-107.687541],[617.794180,-108.650044],[617.187480,-109.175685],[616.539511,-109.548814],[616.370455,-109.984552],[617.499980,-111.250005],[618.629468,-112.515459],[618.460407,-112.951200],[617.812480,-113.324335],[617.193268,-113.773186],[616.728202,-114.489067],[616.283730,-116.318922],[616.525508,-118.007901],[616.918255,-118.547687],[617.499980,-118.750005],[617.985332,-119.045903],[618.382793,-119.851567],[618.749980,-122.500005],[618.867158,-124.492195],[619.374955,-125.625007],[620.507764,-126.132818],[622.499980,-126.250005],[624.848524,-125.964782],[626.089055,-125.237675],[626.250175,-124.768677],[626.081924,-124.261522],[624.687480,-123.229165],[623.749980,-122.500005],[624.687480,-121.770845],[625.294391,-121.101546],[625.791193,-119.818272],[626.249980,-116.145845],[626.617168,-112.688159],[627.014628,-111.636318],[627.499980,-111.250005],[627.985332,-110.756841],[628.382793,-109.414067],[628.749980,-105.000005],[628.382793,-100.585942],[627.985332,-99.243169],[627.499980,-98.750005],[627.014628,-98.454107],[626.617168,-97.648442],[626.249980,-95.000005],[626.617168,-92.351567],[627.014628,-91.545903],[627.499980,-91.250005],[628.382793,-91.617192],[628.749980,-92.500005],[629.117168,-93.382817],[629.999980,-93.750005],[630.485332,-93.552739],[630.882793,-93.015630],[631.249980,-91.250005],[630.882793,-89.484380],[630.485332,-88.947271],[629.999980,-88.750005],[629.514628,-88.552739],[629.117168,-88.015630],[628.749980,-86.250005],[628.382793,-84.484380],[627.985332,-83.947271],[627.499980,-83.750005],[627.014628,-83.552739],[626.617168,-83.015630],[626.249980,-81.250005],[626.406239,-80.156258],[626.875005,-79.375007],[627.656258,-78.906256],[628.749980,-78.750005],[630.515605,-78.382817],[631.052714,-77.985357],[631.249980,-77.500005],[630.882793,-76.617192],[629.999980,-76.250005],[629.657232,-75.776992],[629.366924,-74.439278],[628.940078,-69.657683],[628.676667,-55.085410],[629.153038,-40.340224],[629.650919,-35.342489],[629.961683,-33.864283],[630.312480,-33.229165],[631.249980,-32.500005],[630.312480,-31.770845],[629.912495,-31.320355],[629.579260,-30.336233],[629.096493,-26.536720],[628.749980,-10.000005],[628.403430,6.536706],[627.920658,10.336211],[627.587436,11.320325],[627.187480,11.770805],[626.249980,12.500005],[627.187480,13.229205],[627.806987,13.714719],[628.271871,14.456668],[628.715330,16.313905],[628.472989,18.008993],[628.080623,18.548253],[627.499980,18.750005],[627.011675,19.335938],[626.614542,20.937493],[626.249980,26.250005],[626.459780,31.546880],[626.964180,33.750005],[627.748538,33.565490],[628.515766,33.045635],[629.891017,31.202043],[630.874300,28.623507],[631.249980,25.714305],[631.617168,22.561380],[632.014628,21.602261],[632.499980,21.250005],[632.985332,21.052739],[633.382793,20.515630],[633.749980,18.750005],[633.382793,16.984380],[632.985332,16.447271],[632.499980,16.250005],[632.014628,15.954107],[631.617168,15.148443],[631.249980,12.500005],[631.367160,10.683596],[631.770792,9.531249],[632.539019,8.925777],[633.749980,8.749995],[634.843702,8.593744],[635.624955,8.124993],[636.093721,7.343742],[636.249980,6.249995],[636.617168,4.484370],[637.014628,3.947261],[637.499980,3.749995],[637.985332,3.552729],[638.382793,3.015620],[638.749980,1.249995],[639.117168,-0.515630],[639.514628,-1.052739],[639.999980,-1.250005],[640.485332,-1.447271],[640.882793,-1.984380],[641.249980,-3.750005],[641.617168,-5.515630],[642.014628,-6.052739],[642.499980,-6.250005],[643.024861,-7.617192],[643.417930,-11.562505],[643.749980,-26.250005],[644.081993,-40.937505],[644.475057,-44.882817],[644.999980,-46.250005],[645.514905,-47.226567],[645.909080,-50.000002],[646.249980,-60.000005],[645.909080,-70.000007],[645.514905,-72.773443],[644.999980,-73.750005],[644.117168,-74.117192],[643.749980,-75.000005],[643.947246,-75.485357],[644.484355,-75.882817],[646.249980,-76.250005],[647.460941,-76.425787],[648.229168,-77.031257],[648.632800,-78.183602],[648.749980,-80.000005],[648.382793,-82.648442],[647.985332,-83.454107],[647.499980,-83.750005],[647.014628,-83.947271],[646.617168,-84.484380],[646.249980,-86.250005],[645.882793,-88.015630],[645.485332,-88.552739],[644.999980,-88.750005],[644.117168,-89.117192],[643.749980,-90.000005],[643.947246,-90.485357],[644.484355,-90.882817],[646.249980,-91.250005],[647.454233,-91.424160],[648.223205,-92.018237],[648.630564,-93.139659],[648.749980,-94.895845],[648.291005,-97.684901],[647.794180,-98.700040],[647.187480,-99.270845],[646.249980,-100.000005],[647.187480,-100.729165],[648.291005,-101.947921],[648.749980,-103.854165],[648.566568,-105.000006],[647.948380,-105.737855],[646.793492,-106.132819],[644.999980,-106.250005],[642.351543,-106.617192],[641.545878,-107.014653],[641.249980,-107.500005],[641.447246,-107.985357],[641.984355,-108.382817],[643.749980,-108.750005],[645.515605,-109.117192],[646.052714,-109.514653],[646.249980,-110.000005],[646.447246,-110.485357],[646.984355,-110.882817],[648.749980,-111.250005],[650.515605,-111.617192],[651.052714,-112.014653],[651.249980,-112.500005],[650.882793,-113.382817],[649.999980,-113.750005],[649.313301,-113.942227],[648.899883,-114.464856],[648.827980,-116.177107],[649.654577,-118.238308],[651.249980,-120.000005],[653.015605,-121.925916],[653.552714,-123.020221],[653.749980,-124.025955],[654.117168,-125.596687],[654.514628,-126.074512],[654.999980,-126.250005],[655.485332,-125.954107],[655.882793,-125.148442],[656.249980,-122.500005],[656.617168,-119.851567],[657.014628,-119.045903],[657.499980,-118.750005],[657.985332,-118.256841],[658.382793,-116.914067],[658.749980,-112.500005],[658.382793,-108.085942],[657.985332,-106.743169],[657.499980,-106.250005],[656.914973,-105.939782],[656.521064,-105.116270],[656.280955,-102.572334],[656.728483,-99.904098],[657.194121,-98.925212],[657.812480,-98.397465],[658.332583,-97.997023],[658.300330,-97.359685],[656.562480,-95.334185],[654.576143,-92.967340],[653.749980,-90.790875],[653.382793,-89.349514],[652.499980,-88.750005],[651.988261,-87.851567],[651.593730,-85.312505],[651.249980,-76.250005],[650.906230,-67.187505],[650.511699,-64.648442],[649.999980,-63.750005],[649.485055,-62.773443],[649.090880,-60.000007],[648.749980,-50.000005],[648.810347,-42.402352],[649.119293,-38.281257],[649.426909,-37.194831],[649.868582,-36.582037],[651.249980,-36.250005],[652.419049,-36.416909],[653.191930,-36.960234],[653.618836,-37.943896],[653.749980,-39.431815],[653.997835,-40.915119],[654.672693,-42.601715],[655.671494,-44.284126],[656.891180,-45.754875],[658.687389,-47.451710],[659.890480,-48.129170],[660.919271,-47.864765],[662.192580,-46.736005],[663.499693,-44.953500],[663.396597,-44.415425],[662.801380,-44.058785],[661.705693,-42.989795],[661.249980,-41.145845],[660.882793,-39.453784],[660.485332,-38.939052],[659.999980,-38.750005],[659.514628,-38.475880],[659.117168,-37.729500],[658.749980,-35.275955],[658.565807,-33.739726],[658.050518,-32.269749],[657.259960,-30.983887],[656.249980,-30.000005],[654.484355,-28.074097],[653.947246,-26.979793],[653.749980,-25.974055],[653.382793,-24.403319],[652.985332,-23.925496],[652.499980,-23.750005],[652.014628,-23.552739],[651.617168,-23.015630],[651.249980,-21.250005],[650.882793,-19.484380],[650.485332,-18.947271],[649.999980,-18.750005],[649.511675,-18.164067],[649.114542,-16.562502],[648.749980,-11.250005],[648.385418,-5.937507],[647.988285,-4.335943],[647.499980,-3.750005],[646.617168,-3.382817],[646.249980,-2.500005],[646.447246,-2.014653],[646.984355,-1.617192],[648.749980,-1.250005],[650.125008,-0.937504],[650.566416,-0.371097],[650.875005,0.624998],[651.187489,4.374998],[651.249980,11.249995],[650.906230,20.312504],[650.511699,22.851567],[649.999980,23.750005],[649.117168,24.117193],[648.749980,25.000005],[648.947246,25.485357],[649.484355,25.882818],[651.249980,26.250005],[652.343702,26.406250],[653.124955,26.874993],[653.593721,27.656241],[653.749980,28.750005],[653.896176,29.875927],[654.314744,30.647005],[654.975659,31.066408],[655.848893,31.137305],[658.112210,30.246255],[660.864480,27.999205],[662.340366,26.394110],[663.072092,25.226593],[663.103863,24.379982],[662.479880,23.737605],[661.783339,23.139468],[661.645155,22.465955],[662.087958,21.603143],[663.134380,20.437105],[665.009380,19.045843],[665.576249,19.121207],[665.941180,19.698705],[667.010180,20.794305],[668.854080,21.250005],[670.546205,21.617193],[671.060936,22.014653],[671.249980,22.500005],[671.447246,22.985357],[671.984355,23.382818],[673.749980,23.750005],[675.515605,23.463880],[676.249980,22.775905],[675.515605,21.558693],[673.749980,20.000005],[672.740000,19.016133],[671.949443,17.730255],[671.434153,16.260252],[671.249980,14.724005],[670.882793,12.270488],[670.485332,11.524117],[669.999980,11.249995],[669.514628,10.954097],[669.117168,10.148433],[668.749980,7.499995],[668.382793,4.851558],[667.985332,4.045893],[667.499980,3.749995],[667.014628,3.552729],[666.617168,3.015620],[666.249980,1.249995],[666.419311,-0.552543],[666.671349,-0.976291],[667.070855,-1.077091],[668.419936,-0.296049],[670.681880,1.818185],[672.048727,3.450245],[673.004780,5.217556],[673.566408,7.160181],[673.749980,9.318185],[674.117168,12.448165],[674.514628,13.400309],[674.999980,13.750005],[675.485332,13.947271],[675.882793,14.484380],[676.249980,16.250005],[676.617168,18.015630],[677.014628,18.552739],[677.499980,18.750005],[677.985332,19.045903],[678.382793,19.851568],[678.749980,22.500005],[679.117168,25.148443],[679.514628,25.954107],[679.999980,26.250005],[680.485332,25.855474],[680.882793,24.781255],[681.249980,21.250005],[680.882793,17.718755],[680.485332,16.644536],[679.999980,16.250005],[679.511675,15.664072],[679.114542,14.062516],[678.749980,8.749995],[678.385418,3.437498],[677.988285,1.835933],[677.499980,1.249995],[677.011675,0.664057],[676.614542,-0.937507],[676.249980,-6.250005],[675.885418,-11.562502],[675.488285,-13.164067],[674.999980,-13.750005],[674.497078,-14.492192],[674.101568,-16.562502],[673.749980,-23.750005],[673.398393,-30.937507],[673.002882,-33.007818],[672.499980,-33.750005],[672.003322,-34.414067],[671.607117,-36.250005],[671.249980,-42.500005],[670.892805,-48.750005],[670.496596,-50.585942],[669.999980,-51.250005],[669.514628,-51.545903],[669.117168,-52.351567],[668.749980,-55.000005],[669.117168,-57.648442],[669.514628,-58.454107],[669.999980,-58.750005],[670.485332,-58.947271],[670.882793,-59.484380],[671.249980,-61.250005],[670.882793,-63.015630],[670.485332,-63.552739],[669.999980,-63.750005],[669.503322,-64.414067],[669.107117,-66.250005],[668.749980,-72.500005],[668.959780,-78.679692],[669.464180,-81.250005],[670.307223,-81.057130],[671.101997,-80.506742],[672.467668,-78.502842],[673.403044,-75.577136],[673.749980,-72.068455],[674.190130,-67.833289],[674.684602,-66.439494],[675.312480,-65.729165],[676.249980,-65.000005],[675.312480,-64.270845],[674.667846,-63.131122],[674.182555,-60.685409],[673.717355,-53.673487],[673.971593,-46.830035],[674.385598,-44.594907],[674.999980,-43.750005],[675.580623,-43.548254],[675.972989,-43.008995],[676.215330,-41.313907],[675.771871,-39.456659],[675.306987,-38.714698],[674.687480,-38.229165],[673.749980,-37.500005],[674.687480,-36.770845],[675.386655,-35.785043],[675.873205,-33.529992],[676.249980,-24.895845],[676.597518,-16.848964],[676.992522,-14.563807],[677.499980,-13.750005],[677.988285,-13.164067],[678.385418,-11.562502],[678.749980,-6.250005],[679.114542,-0.937507],[679.511675,0.664057],[679.999980,1.249995],[680.485332,1.644526],[680.882793,2.718745],[681.249980,6.249995],[681.617168,9.781245],[682.014628,10.855464],[682.499980,11.249995],[682.985332,11.644528],[683.382793,12.718750],[683.749980,16.250005],[684.117168,19.781255],[684.514628,20.855474],[684.999980,21.250005],[685.485332,21.447271],[685.882793,21.984380],[686.249980,23.750005],[686.617168,25.515630],[687.014628,26.052739],[687.499980,26.250005],[688.382793,25.882818],[688.749980,25.000005],[688.947246,24.514653],[689.484355,24.117193],[691.249980,23.750005],[692.343702,23.593760],[693.124955,23.125018],[693.593721,22.343769],[693.749980,21.250005],[693.382793,19.484380],[692.985332,18.947271],[692.499980,18.750005],[692.014628,18.454107],[691.617168,17.648443],[691.249980,15.000005],[691.617168,12.351563],[692.014628,11.545895],[692.499980,11.249995],[692.985332,11.447262],[693.382793,11.984375],[693.749980,13.750005],[694.117168,15.515630],[694.514628,16.052739],[694.999980,16.250005],[695.485332,16.052739],[695.882793,15.515630],[696.249980,13.750005],[696.617168,11.984375],[697.014628,11.447262],[697.499980,11.249995],[698.021697,10.039058],[698.415118,6.562498],[698.749980,-6.250005],[699.084805,-19.062507],[699.478221,-22.539068],[699.999980,-23.750005],[700.526211,-25.195317],[700.919130,-29.375002],[701.249980,-45.000005],[700.919130,-60.625007],[700.526211,-64.804693],[699.999980,-66.250005],[699.514628,-66.439052],[699.117168,-66.953784],[698.749980,-68.645845],[698.291005,-70.552089],[697.187480,-71.770845],[696.249980,-72.500005],[697.187480,-73.229165],[697.794180,-73.791752],[698.291005,-74.784512],[698.749980,-77.500005],[698.291005,-80.215497],[697.794180,-81.208258],[697.187480,-81.770845],[696.249980,-82.500005],[697.187480,-83.229165],[697.794180,-83.799970],[698.291005,-84.815109],[698.749980,-87.604165],[699.117168,-90.179042],[699.514628,-90.962327],[699.999980,-91.250005],[700.485332,-91.545903],[700.882793,-92.351567],[701.249980,-95.000005],[701.617168,-97.648442],[702.014628,-98.454107],[702.499980,-98.750005],[702.985332,-98.454107],[703.382793,-97.648442],[703.749980,-95.000005],[704.117168,-92.351567],[704.514628,-91.545903],[704.999980,-91.250005],[705.487441,-90.670578],[705.884668,-89.088546],[706.249980,-83.854165],[706.659305,-78.204819],[707.149924,-76.533803],[707.812480,-75.729165],[708.749980,-75.000005],[707.812480,-74.270845],[706.708955,-73.052089],[706.249980,-71.145845],[705.882793,-69.453784],[705.485332,-68.939052],[704.999980,-68.750005],[704.117168,-68.382817],[703.749980,-67.500005],[704.045878,-67.014653],[704.851543,-66.617192],[707.499980,-66.250005],[709.316358,-66.132818],[710.468705,-65.729174],[711.074189,-64.960945],[711.249980,-63.750005],[711.093721,-62.656258],[710.624955,-61.875007],[709.843702,-61.406256],[708.749980,-61.250005],[707.656258,-61.093754],[706.875005,-60.625002],[706.406239,-59.843752],[706.249980,-58.750005],[705.882793,-56.984380],[705.485332,-56.447271],[704.999980,-56.250005],[704.416384,-55.940749],[704.022977,-55.118086],[703.782155,-52.563150],[704.228371,-49.846432],[704.693760,-48.821540],[705.312480,-48.229165],[706.249980,-47.500005],[705.312480,-46.770845],[704.584196,-45.443351],[704.100880,-42.017932],[703.749980,-27.395845],[703.416542,-13.723964],[703.023300,-10.032557],[702.499980,-8.750005],[701.980288,-7.623704],[701.586643,-4.401049],[701.249980,7.395835],[700.893118,20.020709],[700.409057,23.055834],[699.687480,24.270805],[698.749980,25.000005],[699.687480,25.729205],[700.791005,26.947943],[701.249980,28.854205],[701.423377,29.959911],[701.977530,30.702205],[702.963383,31.119449],[704.431880,31.250005],[705.909419,31.492107],[707.580318,32.151293],[709.239497,33.126885],[710.681880,34.318205],[713.749980,37.386405],[713.749980,81.818205],[713.749980,126.250005],[591.249980,126.250005],[504.734399,126.030143],[478.416045,125.792144],[468.750030,125.501505]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[485.681830,108.181805],[487.848743,105.478042],[488.750030,103.286005],[489.209005,101.830455],[490.312530,100.897505],[490.832591,100.497038],[490.800343,99.859692],[489.062530,97.834205],[487.076192,95.548367],[486.250030,93.566805],[485.515655,91.791017],[483.750030,90.000005],[481.984405,88.231430],[481.250030,86.509805],[480.772582,84.980308],[479.619692,83.250880],[478.210547,81.835964],[476.964330,81.250005],[476.459842,81.984380],[476.250030,83.750005],[476.617217,85.515630],[477.014678,86.052739],[477.500030,86.250005],[478.005758,87.034555],[478.400955,89.231955],[478.750030,96.927805],[479.160180,105.268405],[479.650902,107.911321],[480.312530,109.380205],[481.508544,110.665482],[482.426467,110.978017],[483.629747,110.192047],[485.681830,108.181805]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[588.749980,82.500005],[589.045878,82.014653],[589.851543,81.617192],[592.499980,81.250005],[595.077927,81.111472],[595.751726,80.886386],[596.022505,80.511267],[595.376296,79.172482],[593.181880,76.818205],[590.131483,74.314299],[588.939326,73.808028],[587.967230,73.799430],[587.213722,74.288916],[586.677327,75.276899],[586.249980,78.750005],[586.617168,82.281255],[587.014628,83.355474],[587.499980,83.750005],[588.382793,83.382817],[588.749980,82.500005]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[611.249980,61.250005],[611.617168,57.718755],[612.014628,56.644536],[612.499980,56.250005],[612.985332,56.052739],[613.382793,55.515630],[613.749980,53.750005],[613.906239,52.656241],[614.375005,51.874992],[615.156258,51.406250],[616.249980,51.250005],[617.554639,51.035166],[618.312455,50.156267],[618.664033,48.261738],[618.749980,45.000005],[619.117168,40.585942],[619.514628,39.243169],[619.999980,38.750005],[620.764337,38.567660],[621.183793,38.057858],[621.062455,36.279280],[619.784880,33.861064],[617.499980,31.250005],[614.851543,28.364542],[613.749980,26.346305],[611.690582,23.411563],[607.062593,18.286200],[602.191322,13.416812],[599.402080,11.249995],[598.941555,12.351562],[598.749980,15.000005],[599.117168,17.648442],[599.514628,18.454107],[599.999980,18.750005],[600.488285,19.335938],[600.885418,20.937492],[601.249980,26.250005],[601.614542,31.562517],[602.011675,33.164072],[602.499980,33.750005],[602.985332,34.243169],[603.382793,35.585942],[603.749980,40.000005],[604.117168,44.414067],[604.514628,45.756841],[604.999980,46.250005],[605.493136,46.878296],[605.889730,48.606930],[606.249980,54.427805],[606.515408,59.404143],[607.296330,63.069855],[608.569702,65.358192],[609.383855,65.964986],[610.312480,66.202405],[610.676483,65.826280],[610.974580,64.767205],[611.249980,61.250005]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[624.464180,51.964305],[625.145549,50.924251],[625.669397,49.438430],[626.208492,45.850030],[626.009382,42.640192],[625.610472,41.627575],[624.999980,41.250005],[624.514628,41.545903],[624.117168,42.351567],[623.749980,45.000005],[623.382793,47.648442],[622.985332,48.454107],[622.499980,48.750005],[622.014628,48.947271],[621.617168,49.484380],[621.249980,51.250005],[621.411577,52.951253],[621.948755,53.625742],[622.940096,53.290938],[624.464180,51.964305]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[636.964180,41.964305],[638.263416,39.908482],[638.679217,37.472792],[638.215250,35.028385],[636.875180,32.946405],[635.820511,32.008942],[635.000180,31.696455],[634.179849,32.008942],[633.125180,32.946405],[632.278529,34.154006],[631.679652,35.726786],[631.219830,39.319155],[631.734933,42.426049],[632.354712,43.391985],[633.214180,43.750005],[635.126043,43.225442],[636.964180,41.964305]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[641.249980,26.785705],[640.699180,24.847680],[639.374980,22.946405],[638.318171,22.011089],[637.488555,21.707930],[636.647502,22.041258],[635.556380,23.015405],[634.639193,24.071374],[634.290805,24.940930],[634.497080,25.795674],[635.243880,26.807205],[637.097718,28.187941],[639.060605,28.643467],[640.616655,28.175613],[641.080901,27.595989],[641.249980,26.786205]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[643.749980,9.999995],[643.392805,3.749995],[642.996596,1.914057],[642.499980,1.249995],[642.014628,1.545893],[641.617168,2.351557],[641.249980,4.999995],[640.882793,7.648432],[640.485332,8.454097],[639.999980,8.749995],[639.514628,8.947261],[639.117168,9.484370],[638.749980,11.249995],[639.117168,13.015629],[639.514628,13.552739],[639.999980,13.750005],[640.485332,13.947271],[640.882793,14.484380],[641.249980,16.250005],[641.617168,18.015630],[642.014628,18.552739],[642.499980,18.750005],[642.996596,18.085942],[643.392805,16.250004],[643.749980,9.999995]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[651.249980,-31.250005],[650.882793,-33.015630],[650.485332,-33.552739],[649.999980,-33.750005],[649.514628,-33.552739],[649.117168,-33.015630],[648.749980,-31.250005],[649.117168,-29.484380],[649.514628,-28.947271],[649.999980,-28.750005],[650.485332,-28.947271],[650.882793,-29.484380],[651.249980,-31.250005]]);
    }
    linear_extrude(height=h)
      polygon([[-448.749981,62.500005],[-448.382794,61.617192],[-447.499982,61.250005],[-446.617169,61.617192],[-446.249982,62.500005],[-446.617169,63.382817],[-447.499982,63.750005],[-448.382794,63.382817],[-448.749981,62.500005]]);
    linear_extrude(height=h)
      polygon([[-556.249980,43.750005],[-556.617168,40.218755],[-557.014628,39.144536],[-557.499980,38.750005],[-557.985332,38.355474],[-558.382793,37.281255],[-558.749980,33.750005],[-559.117168,30.218755],[-559.514628,29.144536],[-559.999980,28.750005],[-560.485332,28.355474],[-560.882793,27.281255],[-561.249980,23.750005],[-561.617168,20.218755],[-562.014628,19.144536],[-562.499980,18.750005],[-562.985332,18.552739],[-563.382793,18.015630],[-563.749980,16.250005],[-564.117168,14.484380],[-564.514628,13.947271],[-564.999980,13.750005],[-565.485332,13.947271],[-565.882793,14.484380],[-566.249980,16.250005],[-566.617168,18.015630],[-567.014628,18.552739],[-567.499980,18.750005],[-567.985332,19.045903],[-568.382793,19.851567],[-568.749980,22.500005],[-569.117168,25.148442],[-569.514628,25.954107],[-569.999980,26.250005],[-570.485332,26.447271],[-570.882793,26.984380],[-571.249980,28.750005],[-571.406231,29.843769],[-571.874982,30.625017],[-572.656233,31.093760],[-573.749980,31.250005],[-575.515605,30.882817],[-576.052714,30.485357],[-576.249980,30.000005],[-575.882793,29.117192],[-574.999980,28.750005],[-574.514628,28.355474],[-574.117168,27.281255],[-573.749980,23.750005],[-573.382793,20.218755],[-572.985332,19.144536],[-572.499980,18.750005],[-572.014628,18.574516],[-571.617168,18.096692],[-571.249980,16.525905],[-571.052714,15.520180],[-570.515605,14.425880],[-568.749980,12.500005],[-567.154590,10.738302],[-566.327999,8.677099],[-566.399899,6.964846],[-566.813311,6.442217],[-567.499980,6.249995],[-567.985332,5.855464],[-568.382793,4.781245],[-568.749980,1.249995],[-569.117168,-2.281255],[-569.514628,-3.355474],[-569.999980,-3.750005],[-570.485332,-4.144536],[-570.882793,-5.218755],[-571.249980,-8.750005],[-570.882793,-12.281255],[-570.485332,-13.355474],[-569.999980,-13.750005],[-569.514628,-13.454107],[-569.117168,-12.648443],[-568.749980,-10.000005],[-568.382793,-7.351568],[-567.985332,-6.545903],[-567.499980,-6.250005],[-567.014628,-6.052739],[-566.617168,-5.515630],[-566.249980,-3.750005],[-565.882793,-1.984380],[-565.485332,-1.447271],[-564.999980,-1.250005],[-564.514628,-0.855474],[-564.117168,0.218745],[-563.749980,3.749995],[-563.382793,7.281245],[-562.985332,8.355464],[-562.499980,8.749995],[-562.014628,9.144526],[-561.617168,10.218746],[-561.249980,13.750005],[-560.882793,17.281255],[-560.485332,18.355474],[-559.999980,18.750005],[-559.514628,19.144536],[-559.117168,20.218755],[-558.749980,23.750005],[-558.382793,27.281255],[-557.985332,28.355474],[-557.499980,28.750005],[-557.014628,29.144536],[-556.617168,30.218755],[-556.249980,33.750005],[-555.882793,37.281255],[-555.485332,38.355474],[-554.999980,38.750005],[-554.514628,39.144536],[-554.117168,40.218755],[-553.749980,43.750005],[-554.117168,47.281255],[-554.514628,48.355474],[-554.999980,48.750005],[-555.485332,48.355474],[-555.882793,47.281255],[-556.249980,43.750005]]);
    linear_extrude(height=h)
      polygon([[-583.749980,-5.000005],[-583.382793,-5.882818],[-582.499980,-6.250005],[-582.014628,-6.545903],[-581.617168,-7.351568],[-581.249980,-10.000005],[-580.882793,-12.648443],[-580.485332,-13.454107],[-579.999980,-13.750005],[-579.514628,-13.355474],[-579.117168,-12.281255],[-578.749980,-8.750005],[-578.847637,-6.210945],[-579.218731,-4.687508],[-579.980450,-3.945318],[-581.249980,-3.750005],[-583.015605,-4.117193],[-583.552714,-4.514653],[-583.749980,-5.000005]]);
    linear_extrude(height=h)
      polygon([[-542.187481,-13.119795],[-543.290999,-15.592770],[-543.749981,-19.046295],[-543.910469,-20.957281],[-544.386282,-22.600013],[-545.168945,-23.954313],[-546.249981,-25.000005],[-547.259956,-25.983887],[-548.050515,-27.269749],[-548.565806,-28.739726],[-548.749981,-30.275955],[-549.117168,-32.729500],[-549.514629,-33.475880],[-549.999980,-33.750005],[-550.485332,-33.925496],[-550.882793,-34.403319],[-551.249980,-35.974055],[-551.447246,-36.979793],[-551.984355,-38.074098],[-553.749980,-40.000005],[-554.759955,-40.983887],[-555.550514,-42.269749],[-556.065805,-43.739726],[-556.249980,-45.275955],[-556.126588,-46.932825],[-555.712600,-48.003246],[-554.942302,-48.578535],[-553.749980,-48.750005],[-552.656233,-48.593754],[-551.874982,-48.125003],[-551.406231,-47.343752],[-551.249980,-46.250005],[-551.093730,-45.156258],[-550.624981,-44.375008],[-549.843732,-43.906256],[-548.749981,-43.750005],[-547.421857,-43.515629],[-546.666649,-42.500003],[-546.328106,-40.234377],[-546.249981,-36.250005],[-546.171857,-32.265633],[-545.833317,-30.000008],[-545.078109,-28.984381],[-543.749981,-28.750005],[-542.480451,-28.554692],[-541.718732,-27.812503],[-541.347638,-26.289065],[-541.249981,-23.750005],[-541.152326,-21.210945],[-540.781233,-19.687508],[-540.019515,-18.945318],[-538.749981,-18.750005],[-536.984356,-18.382818],[-536.447247,-17.985357],[-536.249981,-17.500005],[-535.882794,-16.617193],[-534.999981,-16.250005],[-534.514629,-16.545903],[-534.117169,-17.351568],[-533.749981,-20.000005],[-533.382794,-22.648443],[-532.985333,-23.454107],[-532.499981,-23.750005],[-532.014629,-24.045903],[-531.617169,-24.851568],[-531.249981,-27.500005],[-530.882794,-30.148443],[-530.485333,-30.954107],[-529.999981,-31.250005],[-529.514629,-31.447271],[-529.117169,-31.984380],[-528.749981,-33.750005],[-528.382794,-35.515630],[-527.985333,-36.052739],[-527.499981,-36.250005],[-527.014629,-36.447271],[-526.617169,-36.984380],[-526.249981,-38.750005],[-525.882794,-40.515630],[-525.485333,-41.052739],[-524.999981,-41.250005],[-524.514629,-41.060959],[-524.117169,-40.546230],[-523.749981,-38.854165],[-523.290999,-36.947921],[-522.187481,-35.729165],[-521.249981,-35.000005],[-522.187481,-34.270845],[-522.794173,-33.700040],[-523.290999,-32.684901],[-523.749981,-29.895845],[-524.117169,-27.320971],[-524.514629,-26.537685],[-524.999981,-26.250005],[-525.485333,-25.756841],[-525.882794,-24.414068],[-526.249981,-20.000005],[-526.337221,-16.776498],[-526.682275,-14.877721],[-527.410141,-13.977586],[-528.645821,-13.750005],[-530.552065,-13.291023],[-531.770821,-12.187505],[-532.499986,-11.250005],[-533.229151,-12.187505],[-533.714684,-12.807033],[-534.456644,-13.271920],[-536.313889,-13.715359],[-538.008972,-13.472996],[-538.548231,-13.080631],[-538.749981,-12.500005],[-539.028115,-11.560351],[-539.778131,-11.365648],[-540.873447,-11.893070],[-542.187481,-13.119795]]);
    linear_extrude(height=h)
      polygon([[-513.749981,-19.895845],[-514.167657,-24.526221],[-514.656181,-25.915291],[-515.301321,-26.558785],[-515.907001,-26.910903],[-516.025690,-27.432736],[-514.765611,-29.162955],[-512.858001,-30.539080],[-510.897647,-31.182085],[-509.367367,-31.024788],[-508.914386,-30.625031],[-508.749981,-30.000005],[-509.117169,-29.117193],[-509.999981,-28.750005],[-510.488265,-28.164067],[-510.885400,-26.562503],[-511.249981,-21.250005],[-511.614562,-15.937508],[-512.011697,-14.335943],[-512.499981,-13.750005],[-512.985333,-14.234950],[-513.382794,-15.555346],[-513.749981,-19.895845]]);
    linear_extrude(height=h)
      polygon([[-578.749980,-23.750005],[-579.114561,-29.062503],[-579.511696,-30.664067],[-579.999980,-31.250005],[-580.485332,-31.447271],[-580.882793,-31.984380],[-581.249980,-33.750005],[-581.617168,-35.515630],[-582.014628,-36.052739],[-582.499980,-36.250005],[-582.985332,-36.545903],[-583.382793,-37.351568],[-583.749980,-40.000005],[-583.632793,-41.816408],[-583.229149,-42.968753],[-582.460920,-43.574223],[-581.249980,-43.750005],[-580.039040,-43.574223],[-579.270811,-42.968753],[-578.867167,-41.816408],[-578.749980,-40.000005],[-578.382793,-37.351568],[-577.985332,-36.545903],[-577.499980,-36.250005],[-577.014628,-36.545903],[-576.617168,-37.351568],[-576.249980,-40.000005],[-575.882793,-42.648443],[-575.485332,-43.454107],[-574.999980,-43.750005],[-574.514628,-43.947271],[-574.117168,-44.484380],[-573.749980,-46.250005],[-573.382793,-48.015630],[-572.985332,-48.552739],[-572.499980,-48.750005],[-572.014628,-48.947271],[-571.617168,-49.484380],[-571.249980,-51.250005],[-571.617168,-53.015630],[-572.014628,-53.552739],[-572.499980,-53.750005],[-572.985332,-53.947271],[-573.382793,-54.484380],[-573.749980,-56.250005],[-573.593730,-57.343752],[-573.124981,-58.125003],[-572.343731,-58.593754],[-571.249980,-58.750005],[-570.039040,-58.925787],[-569.270811,-59.531258],[-568.867167,-60.683602],[-568.749980,-62.500005],[-569.117168,-65.148443],[-569.514628,-65.954107],[-569.999980,-66.250005],[-570.882793,-66.617193],[-571.249980,-67.500005],[-571.052714,-67.985357],[-570.515605,-68.382818],[-568.749980,-68.750005],[-567.451788,-68.960538],[-566.693254,-69.809264],[-566.338083,-71.621873],[-566.249980,-74.724055],[-566.126533,-77.661827],[-565.712454,-79.801043],[-564.942138,-81.345752],[-563.749980,-82.500005],[-562.562319,-83.649391],[-561.791504,-85.183068],[-561.374926,-87.293160],[-561.249980,-90.171795],[-561.684483,-94.612126],[-562.178248,-96.046181],[-562.812480,-96.770845],[-563.749980,-97.500005],[-562.812480,-98.229165],[-562.205793,-98.799970],[-561.708966,-99.815109],[-561.249980,-102.604165],[-561.130562,-104.360351],[-560.723197,-105.481773],[-559.954225,-106.075850],[-558.749980,-106.250005],[-557.656233,-106.406256],[-556.874982,-106.875008],[-556.406231,-107.656258],[-556.249980,-108.750005],[-555.882793,-110.515630],[-555.485332,-111.052739],[-554.999980,-111.250005],[-554.514628,-111.447271],[-554.117168,-111.984380],[-553.749980,-113.750005],[-553.593730,-114.843752],[-553.124981,-115.625003],[-552.343731,-116.093754],[-551.249980,-116.250005],[-550.156233,-116.093754],[-549.374983,-115.625003],[-548.906232,-114.843752],[-548.749981,-113.750005],[-549.117168,-111.984380],[-549.514629,-111.447271],[-549.999980,-111.250005],[-550.485332,-110.954107],[-550.882793,-110.148443],[-551.249980,-107.500005],[-551.617168,-104.851568],[-552.014628,-104.045903],[-552.499980,-103.750005],[-552.985332,-103.278614],[-553.382793,-101.995125],[-553.749980,-97.775955],[-553.873429,-94.838183],[-554.287510,-92.698968],[-555.057826,-91.154258],[-556.249980,-90.000005],[-557.375148,-88.913566],[-558.152908,-87.500211],[-558.604203,-85.705265],[-558.749980,-83.474055],[-559.117168,-80.137698],[-559.514628,-79.122763],[-559.999980,-78.750005],[-560.485332,-78.552739],[-560.882793,-78.015630],[-561.249980,-76.250005],[-561.617168,-74.484380],[-562.014628,-73.947271],[-562.499980,-73.750005],[-563.082584,-73.547256],[-563.475646,-73.007075],[-563.716991,-71.322814],[-563.271706,-69.514013],[-562.806480,-68.818158],[-562.187480,-68.397465],[-561.667385,-67.997023],[-561.699623,-67.359685],[-563.437480,-65.334185],[-564.539614,-64.097827],[-565.432780,-62.602669],[-566.031421,-61.024941],[-566.249980,-59.540875],[-566.617168,-57.216701],[-567.014628,-56.509676],[-567.499980,-56.250005],[-567.985332,-55.863694],[-568.382793,-54.811855],[-568.749980,-51.354165],[-569.202685,-47.693111],[-569.698726,-46.452300],[-570.312480,-45.824325],[-570.960412,-45.451196],[-571.129482,-45.015458],[-569.999980,-43.750005],[-568.870481,-42.484553],[-569.039549,-42.048814],[-569.687480,-41.675685],[-570.790998,-40.554729],[-571.249980,-38.750005],[-571.708966,-36.945281],[-572.812480,-35.824325],[-573.458535,-35.456127],[-573.626861,-35.035561],[-572.499980,-33.845165],[-571.562484,-33.091485],[-571.249985,-32.515864],[-571.562484,-31.956103],[-572.499980,-31.250005],[-573.437482,-30.543907],[-573.749982,-29.984146],[-573.437482,-29.408525],[-572.499980,-28.654845],[-571.373106,-27.464449],[-571.541431,-27.043883],[-572.187480,-26.675685],[-572.794172,-26.184096],[-573.290998,-25.314310],[-573.749980,-22.931555],[-574.166018,-20.701428],[-575.216558,-18.536438],[-576.605238,-16.898619],[-578.035700,-16.250005],[-578.540162,-18.453130],[-578.749980,-23.750005]]);
    linear_extrude(height=h)
      polygon([[521.250030,-17.500005],[521.617217,-18.382818],[522.500030,-18.750005],[523.382842,-18.382818],[523.750030,-17.500005],[523.382842,-16.617193],[522.500030,-16.250005],[521.617217,-16.617193],[521.250030,-17.500005]]);
    linear_extrude(height=h)
      polygon([[-588.749980,-22.500005],[-588.382793,-23.382818],[-587.499980,-23.750005],[-586.617168,-23.382818],[-586.249980,-22.500005],[-586.617168,-21.617193],[-587.499980,-21.250005],[-588.382793,-21.617193],[-588.749980,-22.500005]]);
    linear_extrude(height=h)
      polygon([[616.249980,-30.000005],[616.447246,-30.485357],[616.984355,-30.882818],[618.749980,-31.250005],[620.515605,-30.882818],[621.052714,-30.485357],[621.249980,-30.000005],[621.052714,-29.514653],[620.515605,-29.117193],[618.749980,-28.750005],[616.984355,-29.117193],[616.447246,-29.514653],[616.249980,-30.000005]]);
    linear_extrude(height=h)
      polygon([[596.249980,-32.500005],[596.617168,-33.382818],[597.499980,-33.750005],[598.382793,-33.382818],[598.749980,-32.500005],[598.382793,-31.617193],[597.499980,-31.250005],[596.617168,-31.617193],[596.249980,-32.500005]]);
    linear_extrude(height=h)
      polygon([[-517.187481,-35.619795],[-517.806652,-36.895125],[-518.271770,-38.949113],[-518.716464,-44.223431],[-518.474790,-49.103484],[-518.081951,-50.664640],[-517.499981,-51.250005],[-517.014629,-51.447271],[-516.617169,-51.984380],[-516.249981,-53.750005],[-515.882794,-55.515630],[-515.485333,-56.052739],[-514.999981,-56.250005],[-514.514629,-55.855474],[-514.117169,-54.781255],[-513.749981,-51.250005],[-513.382794,-47.718755],[-512.985333,-46.644536],[-512.499981,-46.250005],[-512.014629,-46.060959],[-511.617169,-45.546230],[-511.249981,-43.854165],[-510.790999,-41.947921],[-509.687481,-40.729165],[-508.749981,-40.000005],[-509.687481,-39.270845],[-510.790999,-38.052089],[-511.249981,-36.145845],[-511.410197,-35.201968],[-511.852306,-34.498740],[-512.518501,-34.041282],[-513.350974,-33.834716],[-515.283519,-34.194745],[-517.187481,-35.619795]]);
    linear_extrude(height=h)
      polygon([[-472.313581,-35.754775],[-473.363389,-37.397205],[-473.268679,-38.315431],[-472.289152,-38.292911],[-470.684511,-37.113105],[-469.318250,-35.537023],[-468.749981,-34.464295],[-469.066717,-33.840713],[-469.891577,-33.893324],[-471.036539,-34.554040],[-472.313581,-35.754775]]);
    linear_extrude(height=h)
      polygon([[-456.249982,-35.000005],[-455.882794,-35.882818],[-454.999982,-36.250005],[-454.117169,-35.882818],[-453.749982,-35.000005],[-454.117169,-34.117193],[-454.999982,-33.750005],[-455.882794,-34.117193],[-456.249982,-35.000005]]);
    linear_extrude(height=h)
      polygon([[-504.813581,-38.254775],[-505.735252,-39.854738],[-505.804800,-40.536973],[-505.579961,-41.019745],[-504.764705,-41.164789],[-504.099681,-40.312505],[-503.595331,-39.705818],[-502.634610,-39.208991],[-499.895821,-38.750005],[-497.320947,-38.382818],[-496.537661,-37.985357],[-496.249981,-37.500005],[-496.540888,-36.882783],[-497.323837,-36.492603],[-499.827231,-36.345898],[-502.682900,-36.964938],[-503.906193,-37.531941],[-504.813581,-38.254775]]);
    linear_extrude(height=h)
      polygon([[-491.249981,-38.750005],[-490.882794,-40.515630],[-490.485333,-41.052739],[-489.999981,-41.250005],[-489.514629,-41.052739],[-489.117169,-40.515630],[-488.749981,-38.750005],[-489.117169,-36.984380],[-489.514629,-36.447271],[-489.999981,-36.250005],[-490.485333,-36.447271],[-490.882794,-36.984380],[-491.249981,-38.750005]]);
    linear_extrude(height=h)
      polygon([[-486.249981,-37.500005],[-485.882794,-38.382818],[-484.999981,-38.750005],[-484.117169,-38.382818],[-483.749981,-37.500005],[-484.117169,-36.617193],[-484.999981,-36.250005],[-485.882794,-36.617193],[-486.249981,-37.500005]]);
    linear_extrude(height=h)
      polygon([[-466.249981,-37.500005],[-465.882794,-38.382818],[-464.999981,-38.750005],[-464.117169,-38.382818],[-463.749981,-37.500005],[-464.117169,-36.617193],[-464.999981,-36.250005],[-465.882794,-36.617193],[-466.249981,-37.500005]]);
    linear_extrude(height=h)
      polygon([[-536.249981,-42.500005],[-536.052715,-42.985357],[-535.515606,-43.382818],[-533.749981,-43.750005],[-531.984356,-43.382818],[-531.447247,-42.985357],[-531.249981,-42.500005],[-531.447247,-42.014653],[-531.984356,-41.617193],[-533.749981,-41.250005],[-535.515606,-41.617193],[-536.052715,-42.014653],[-536.249981,-42.500005]]);
    linear_extrude(height=h)
      polygon([[-471.249981,-52.500005],[-470.882794,-53.382818],[-469.999981,-53.750005],[-469.117169,-53.382818],[-468.749981,-52.500005],[-469.117169,-51.617193],[-469.999981,-51.250005],[-470.882794,-51.617193],[-471.249981,-52.500005]]);
    linear_extrude(height=h)
      polygon([[526.250030,-80.000005],[526.617217,-80.882818],[527.500030,-81.250005],[528.382842,-80.882818],[528.750030,-80.000005],[528.382842,-79.117193],[527.500030,-78.750005],[526.617217,-79.117193],[526.250030,-80.000005]]);
    linear_extrude(height=h)
      polygon([[636.249980,-107.500005],[636.617168,-108.382818],[637.499980,-108.750005],[638.382793,-108.382818],[638.749980,-107.500005],[638.382793,-106.617193],[637.499980,-106.250005],[636.617168,-106.617193],[636.249980,-107.500005]]);
    linear_extrude(height=h)
      polygon([[636.249980,-125.000005],[636.617168,-125.882818],[637.499980,-126.250005],[638.382793,-125.882818],[638.749980,-125.000005],[638.382793,-124.117193],[637.499980,-123.750005],[636.617168,-124.117193],[636.249980,-125.000005]]);
  }
}
module AR_Stat(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    difference()
    {
       linear_extrude(height=h)
         polygon([[122.423633,66.658785],[120.068033,66.412875],[114.458513,65.851545],[111.505584,65.381215],[108.776483,64.804985],[106.226483,64.221095],[104.673833,63.761755],[103.842053,63.439015],[103.885553,52.259155],[104.075363,39.787945],[104.221703,38.496585],[107.596373,41.887945],[111.709028,45.923513],[113.305553,47.186495],[114.205553,47.825605],[117.502227,49.793582],[121.105553,51.321985],[124.574513,51.538595],[127.178228,51.177163],[129.397951,50.284416],[130.955601,49.019207],[131.573093,47.540385],[131.789243,46.629985],[132.170315,44.791838],[132.052853,41.788115],[131.052211,38.453520],[129.600623,35.835955],[128.755553,34.540805],[127.705553,33.298735],[126.655554,32.024915],[125.230554,30.515605],[120.805554,26.399825],[117.055554,23.036455],[114.900859,20.997892],[111.868865,17.459655],[108.980415,13.683031],[107.256354,10.929305],[105.958884,7.629305],[104.868204,3.279305],[104.189367,-2.190565],[104.486244,-8.120695],[104.906052,-11.339507],[105.297534,-12.556105],[105.604464,-13.606105],[106.831407,-16.762212],[108.901224,-20.228655],[109.801224,-21.437185],[112.539402,-24.344589],[115.638774,-27.117105],[116.605554,-27.889585],[117.955554,-28.738745],[120.505554,-30.170575],[122.210847,-31.135069],[124.329984,-31.817045],[126.214614,-32.585335],[126.784824,-32.687145],[127.395924,-32.855135],[127.837434,-33.031885],[129.691704,-33.291925],[133.405554,-33.885015],[139.785770,-34.058836],[145.855554,-33.925315],[150.359454,-33.499145],[153.959454,-33.051195],[156.355554,-32.764235],[159.130554,-32.309045],[159.845146,-31.721766],[160.002504,-29.803125],[160.126554,-26.720705],[160.126554,-8.640235],[159.409524,-8.973195],[158.609574,-9.246355],[158.565274,-9.377265],[158.387854,-9.977265],[157.059784,-11.323965],[155.991394,-12.305035],[154.790884,-13.199935],[151.418614,-15.286632],[146.938984,-16.975665],[144.565410,-17.391417],[142.161146,-17.468212],[140.024756,-17.217487],[138.454804,-16.650675],[137.152905,-15.655855],[136.051864,-13.851875],[135.574272,-12.518005],[135.488617,-11.032270],[135.795773,-9.382315],[136.496614,-7.555785],[137.730034,-5.204145],[146.667634,4.825475],[153.403305,12.280264],[155.921464,15.429295],[157.326934,17.179295],[157.557064,17.551225],[158.955724,20.001225],[160.811014,23.244754],[162.492514,26.957205],[162.970654,28.135125],[164.238874,26.892185],[171.221254,21.213725],[173.171254,20.109695],[175.155934,18.969665],[182.678254,15.067725],[189.357064,12.083075],[201.703384,5.785535],[202.828384,5.229295],[203.157064,4.989565],[204.157084,4.388215],[205.097617,3.881810],[205.622347,3.029111],[205.816828,1.553126],[205.766614,-0.823135],[205.438530,-5.264794],[204.896404,-8.120705],[204.482614,-9.994525],[204.130504,-11.444251],[203.473654,-12.454125],[201.534814,-13.945799],[200.155594,-14.698385],[199.780594,-14.799325],[198.491531,-15.290831],[197.356684,-15.418445],[196.826704,-15.661095],[193.412797,-16.045290],[189.617674,-15.813315],[187.231084,-15.318745],[184.405594,-14.676905],[182.905594,-14.172055],[182.305594,-13.922545],[180.955594,-13.517655],[179.313844,-12.882375],[178.283554,-12.470705],[176.625304,-11.913235],[173.455594,-10.529165],[169.656844,-8.686645],[168.007428,-7.843038],[167.268739,-7.826989],[167.286049,-8.855703],[167.904634,-11.146385],[168.486934,-14.000925],[168.651034,-14.270705],[168.921424,-14.645705],[169.058254,-15.470705],[171.031414,-22.470395],[173.349004,-29.618675],[175.272574,-30.818412],[177.655594,-31.804835],[181.855594,-33.408115],[183.924424,-33.972405],[185.525134,-34.407915],[186.246304,-34.579995],[187.495624,-34.715975],[189.805594,-35.141565],[192.635704,-35.581275],[196.985704,-35.906195],[200.605594,-36.138875],[203.314804,-36.122875],[207.964804,-35.777195],[211.255594,-35.483145],[213.205594,-35.119055],[217.105594,-34.340745],[218.274724,-34.123885],[221.775385,-32.726720],[225.452934,-30.440745],[226.733134,-29.500205],[227.830734,-28.450205],[229.400634,-26.718245],[230.425834,-25.303485],[231.175834,-24.678995],[231.287134,-24.625295],[232.105734,-22.402195],[233.254234,-19.820695],[233.541134,-18.770695],[234.119859,-15.703465],[234.645034,-10.775635],[234.567034,16.010995],[234.388646,35.785371],[234.603034,45.410995],[235.366184,53.629756],[236.487834,60.454035],[236.732577,61.881917],[236.597634,62.689356],[235.970840,63.048050],[234.740034,63.129695],[209.460484,64.022345],[207.051585,64.145165],[206.125504,63.980645],[205.541404,55.629315],[205.279924,54.459345],[204.913042,54.285633],[204.121897,54.751768],[200.005594,58.591765],[195.287081,62.667980],[193.304700,64.082488],[192.160804,64.629315],[190.785574,65.224855],[189.029756,65.708361],[184.490014,65.708095],[178.555594,65.385965],[177.055594,65.025045],[175.033864,64.301635],[173.454304,63.729315],[169.304614,61.410725],[167.822254,60.199775],[165.454335,58.030699],[164.155594,56.366125],[163.542244,55.384105],[162.043774,52.752945],[161.158624,50.780135],[160.257094,51.681645],[159.355594,52.834075],[158.755594,53.459695],[158.155594,54.128425],[157.395257,55.382380],[155.538416,57.350861],[153.221327,59.418607],[151.080244,60.970355],[147.049091,62.959009],[143.468164,64.221805],[142.555594,64.684525],[142.292614,64.802195],[140.567614,65.064055],[137.605594,65.697105],[135.826084,66.068925],[134.476084,66.284655],[124.061194,66.855325],[122.423644,66.658795]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[203.346083,45.288325],[205.105583,43.976405],[205.442428,43.280345],[205.619660,41.644489],[205.688933,31.367935],[205.671211,23.464428],[205.307911,19.760374],[204.837373,19.006427],[204.089285,18.730285],[201.505583,18.848675],[197.005583,19.310865],[196.028213,19.497285],[194.505373,20.039376],[192.949640,21.098429],[191.730366,22.364914],[191.216903,23.529305],[190.653263,26.529305],[190.516883,27.535885],[190.300733,28.135885],[189.834984,30.129305],[189.485784,33.129305],[189.751321,36.307541],[190.858224,39.846475],[191.972440,41.656876],[193.457446,43.342539],[194.870170,44.472884],[195.767543,44.617335],[195.955583,44.740315],[196.858902,45.256946],[199.105583,45.824375],[201.226115,45.830430],[203.346083,45.288325]]);
    }
    linear_extrude(height=h)
      polygon([[258.411823,66.096485],[254.605623,65.727435],[250.555624,65.359715],[247.555624,64.781125],[243.971724,64.075345],[242.417424,63.902865],[242.024724,63.760305],[240.671324,63.281955],[239.227824,62.730855],[239.209824,58.479305],[239.385124,50.679305],[239.545924,46.417045],[239.737624,41.970105],[239.864824,37.720305],[240.565361,37.785729],[241.237024,38.596615],[242.207524,40.029305],[243.781824,42.069035],[246.792286,45.331868],[249.805824,47.865565],[251.305824,48.730455],[252.655824,49.499535],[253.930824,50.119795],[254.755824,50.388565],[255.580824,50.635245],[258.507024,51.427805],[260.196572,51.609528],[261.587686,51.379116],[263.037919,50.610896],[264.904824,49.179195],[267.177824,46.975975],[268.044724,45.171455],[268.348124,44.337035],[268.536974,42.491609],[268.044224,40.239405],[267.596924,39.045955],[267.208624,38.638865],[266.751024,38.122205],[266.081099,37.028121],[264.049924,34.712415],[263.155824,33.555855],[258.538024,28.672755],[249.492524,19.179305],[246.842424,16.029305],[245.455824,14.079305],[244.116724,12.129305],[244.023724,11.754305],[242.749274,9.517524],[241.578324,6.429305],[240.662124,3.560425],[240.410274,-2.902849],[240.662124,-9.027085],[241.020224,-10.612105],[241.275024,-11.870255],[241.825624,-13.362275],[243.367436,-17.200069],[245.552524,-21.170695],[248.800761,-24.927219],[252.506724,-28.156845],[254.490324,-29.648805],[254.867024,-29.892875],[256.833724,-30.759055],[260.072024,-32.203146],[262.211424,-32.870545],[263.561424,-33.285145],[265.596399,-33.847712],[268.717374,-34.289129],[277.106724,-34.693075],[283.556724,-34.557595],[285.806724,-34.234515],[288.800736,-33.845940],[291.191524,-33.175935],[292.974324,-32.788265],[293.524524,-32.652545],[295.005924,-31.995075],[295.980774,-31.445316],[296.249124,-29.780975],[296.348124,-11.659775],[296.087524,-10.201665],[293.903024,-11.690465],[291.036124,-13.831275],[290.156524,-14.628405],[289.972924,-14.787095],[288.178024,-15.512905],[286.036624,-16.523555],[285.506524,-16.672415],[284.695524,-16.853765],[282.745524,-17.382465],[279.480899,-17.830196],[276.122224,-17.467965],[273.506625,-16.408279],[271.917936,-15.014351],[271.260916,-13.147910],[271.440324,-10.670685],[273.405824,-5.608326],[274.820611,-2.926681],[276.049024,-1.127165],[276.956524,0.038435],[277.706524,0.905585],[278.456524,1.812535],[289.565824,13.285395],[294.061961,18.696401],[295.773897,21.231893],[296.456524,22.732845],[296.774224,23.229315],[296.929124,23.492875],[297.230024,24.686245],[297.822724,26.297685],[298.095024,27.696695],[298.134024,43.885285],[297.900924,45.087845],[297.560824,46.029315],[297.461824,46.470635],[297.208224,47.334915],[296.910324,47.882945],[295.996449,50.025681],[294.248124,53.103915],[292.051030,55.755569],[289.224124,58.250027],[285.936342,60.457382],[282.356624,62.247725],[279.206624,63.584465],[276.806624,64.310155],[270.038024,65.529315],[268.856624,65.819905],[268.481624,65.977825],[263.512924,66.062225],[258.412924,66.096525]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[-40.594417,65.834175],[-43.195207,65.431965],[-47.395207,64.185395],[-50.869417,63.059775],[-51.244417,62.761605],[-51.544417,62.679305],[-51.844417,62.547015],[-52.242127,62.229305],[-53.344417,61.479305],[-54.446707,60.729305],[-54.851377,60.504305],[-57.426097,57.306845],[-59.438999,54.190687],[-61.316227,50.039965],[-62.152297,47.229305],[-62.282167,46.854305],[-62.581117,46.329305],[-62.759707,43.479305],[-62.964593,39.207177],[-62.820107,36.429305],[-62.342747,33.879305],[-62.151167,32.991795],[-61.696784,31.566740],[-60.807054,29.919165],[-58.102907,26.562135],[-53.902723,23.405449],[-48.394457,20.293185],[-43.744457,18.071925],[-39.694457,16.186105],[-32.779577,13.013391],[-29.568467,11.109535],[-29.411777,11.037735],[-25.840427,9.540105],[-19.386707,6.200625],[-16.178957,4.559885],[-15.975047,2.927925],[-15.913947,-3.112345],[-16.160453,-7.024885],[-16.745157,-9.320665],[-17.689017,-11.220665],[-17.944467,-11.636265],[-18.627702,-12.571426],[-20.413707,-14.056585],[-22.710773,-15.120585],[-24.699657,-15.360185],[-25.013427,-15.439985],[-25.522827,-15.882455],[-29.685098,-16.058015],[-33.846447,-15.758135],[-35.740857,-15.327275],[-38.564798,-14.766003],[-41.705903,-13.777306],[-50.280837,-10.028885],[-54.855837,-7.970655],[-55.081052,-8.140085],[-55.106479,-8.748639],[-54.503877,-11.884705],[-53.828877,-15.470655],[-53.577057,-16.383675],[-53.247117,-17.133675],[-52.956657,-18.170655],[-50.810757,-25.996985],[-50.717457,-26.320035],[-49.890597,-28.190715],[-48.844437,-30.179315],[-45.544437,-31.529195],[-43.744437,-32.112255],[-41.158857,-32.877475],[-39.058856,-33.503325],[-37.444436,-33.963225],[-35.494437,-34.402015],[-33.844437,-34.645875],[-32.166837,-34.995345],[-31.716567,-35.142775],[-29.194167,-35.309575],[-25.744437,-35.700185],[-15.544437,-35.761385],[-12.993837,-35.434995],[-6.844437,-34.482075],[-5.116647,-34.153995],[-3.973947,-33.737505],[-3.261027,-33.470655],[-1.853727,-33.022505],[-0.544437,-32.558945],[1.361452,-31.739431],[3.913023,-29.890235],[6.628080,-27.042446],[8.155563,-24.828085],[8.530563,-24.390305],[9.877833,-22.293655],[11.007663,-19.820655],[11.360373,-18.770655],[12.243993,-15.620655],[12.705881,-12.049144],[12.805564,-4.220655],[12.403533,17.379345],[12.155176,29.066635],[12.331333,38.232935],[13.444142,54.778017],[14.136127,60.650922],[14.756233,63.249965],[15.093883,63.264365],[15.461563,61.179365],[16.078843,56.503145],[16.321363,55.161435],[16.711123,52.179365],[17.044484,48.879365],[17.318864,45.879365],[17.832853,39.429365],[18.192494,13.179365],[18.088382,-6.974789],[17.508704,-18.170635],[16.652144,-27.770635],[16.481112,-29.787884],[16.620844,-31.535875],[20.188654,-31.977335],[24.955594,-32.407625],[29.905594,-32.717265],[39.355593,-33.176045],[45.553473,-33.467765],[45.918635,-32.864050],[46.242517,-31.167596],[46.668514,-25.220635],[46.931122,-21.046218],[47.154130,-20.209916],[47.474644,-19.970635],[49.017543,-21.166895],[50.510374,-22.366895],[50.912764,-22.993245],[51.244504,-23.481735],[53.542114,-25.585095],[62.455594,-34.293605],[63.351975,-34.707334],[64.555594,-34.804375],[66.174484,-34.905415],[68.921794,-34.986644],[74.455594,-34.633465],[78.779437,-34.195910],[80.680594,-33.667995],[81.955594,-33.370675],[82.358194,-33.209975],[82.958194,-33.073235],[83.155594,-32.920635],[83.380594,-32.634375],[84.280594,-32.323815],[84.960184,-32.185085],[85.185184,-32.106285],[86.755594,-31.004955],[90.040571,-28.440583],[92.764534,-25.163365],[94.590064,-22.520685],[95.826097,-19.759973],[96.839494,-16.370685],[97.380007,-7.191094],[97.855204,19.179315],[98.301994,43.329315],[98.586124,48.429315],[98.897584,52.029315],[99.232024,54.279315],[99.551974,56.529315],[99.703084,57.729315],[99.882244,58.629315],[100.142284,59.679315],[100.820974,63.056805],[100.929544,64.176505],[100.797664,64.866495],[84.701614,64.822895],[67.030594,64.971705],[66.029542,65.067452],[65.569252,64.913996],[65.779054,63.139215],[66.251494,60.439215],[66.752014,57.729305],[67.105504,55.629305],[67.576564,51.279305],[68.001214,46.779305],[68.456164,40.291955],[68.657292,22.599447],[68.359964,6.729305],[68.141144,2.529305],[67.906364,-0.920695],[67.613834,-2.706655],[66.917954,-5.752415],[65.336564,-8.594819],[64.487447,-9.619618],[63.937064,-9.909255],[63.655574,-10.072515],[61.330574,-11.488585],[58.924041,-12.402903],[56.155574,-12.586795],[53.195177,-12.500021],[50.455574,-12.073805],[49.091485,-11.466010],[47.720084,-10.331385],[47.138667,-9.348878],[46.783502,-7.156648],[46.334654,5.679305],[46.165135,33.480504],[46.411836,43.521854],[46.845104,48.129305],[46.861304,49.547015],[47.055854,51.197015],[47.371994,52.779305],[47.612834,55.329305],[47.882444,57.729305],[48.057524,58.779305],[48.222584,59.379305],[48.741044,62.304305],[49.169144,64.629305],[37.437434,64.692205],[11.005694,64.767205],[-10.219306,65.048515],[-16.744306,65.317715],[-16.754306,60.248515],[-16.813160,56.537962],[-17.103188,54.763937],[-17.396516,54.480690],[-17.821587,54.534654],[-19.165556,55.458325],[-25.444766,61.338225],[-30.094766,65.922725],[-34.594766,66.003825],[-40.594766,65.834155]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-19.221967,45.969165],[-18.658027,45.729305],[-17.979487,45.378945],[-17.234376,45.039345],[-16.908787,44.647285],[-16.625594,42.989884],[-16.231578,37.108056],[-16.142678,29.851863],[-16.449247,23.679305],[-16.981604,20.022981],[-17.289689,19.400338],[-17.743327,19.171695],[-22.376718,19.107411],[-26.840977,19.838465],[-28.219417,20.285035],[-28.444417,20.547015],[-28.669417,20.739365],[-29.707537,21.471655],[-30.345817,22.329305],[-30.501727,22.727845],[-30.922117,23.702845],[-31.220077,24.612685],[-31.603807,26.112685],[-31.911967,28.155925],[-32.291467,29.955925],[-32.609140,33.819124],[-32.413837,36.836405],[-32.111257,37.889425],[-31.294724,40.599582],[-29.522077,43.268235],[-27.005478,45.150087],[-24.424237,46.252315],[-23.662627,46.515735],[-21.512508,46.508437],[-19.221967,45.969165]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[-293.044423,63.422535],[-300.543940,62.985387],[-301.762992,62.693518],[-302.044423,62.255605],[-301.275896,60.285690],[-300.138713,58.558895],[-300.039814,58.333895],[-299.699134,57.504305],[-298.616344,55.629305],[-296.784494,52.179305],[-292.761444,44.321445],[-289.257866,37.571445],[-288.479467,36.210415],[-286.374687,31.329305],[-285.788287,29.911085],[-284.189227,26.381725],[-282.545457,22.778095],[-281.350867,19.779305],[-279.722086,16.029305],[-278.305047,12.954305],[-277.950197,11.824715],[-277.878197,11.599715],[-276.464587,8.529305],[-273.707766,1.839375],[-271.863857,-2.735625],[-271.445267,-3.470695],[-271.014196,-4.520695],[-270.530817,-5.570695],[-270.244406,-6.010515],[-269.819436,-7.435515],[-267.531156,-13.070695],[-266.301016,-15.954895],[-265.432736,-18.134855],[-263.976086,-21.850655],[-262.270486,-26.120695],[-261.551316,-27.909125],[-260.944407,-29.459815],[-260.443647,-30.821385],[-259.595041,-32.616521],[-259.601946,-33.182895],[-259.430016,-33.470695],[-259.245456,-33.901315],[-259.081816,-34.441555],[-258.706176,-35.185915],[-258.350956,-36.220665],[-256.271656,-41.645695],[-256.146376,-42.095695],[-256.108876,-42.545695],[-255.876926,-42.770695],[-255.460275,-43.398093],[-255.331346,-44.270695],[-254.697816,-45.395695],[-254.210716,-46.370695],[-254.122516,-46.745695],[-253.637056,-47.917855],[-252.798316,-50.167855],[-252.112686,-51.920695],[-251.540186,-53.420695],[-250.094596,-57.020695],[-248.886716,-60.170695],[-248.622756,-60.998835],[-248.192786,-61.973835],[-247.944056,-62.870695],[-247.680196,-63.245695],[-245.981887,-65.053515],[-244.678447,-66.459145],[-244.049527,-66.641065],[-234.159648,-66.676831],[-223.744417,-66.361185],[-221.944416,-66.051065],[-218.979749,-65.242635],[-217.295106,-64.220695],[-216.546306,-62.870695],[-215.702508,-60.982653],[-215.178186,-58.970695],[-214.743696,-57.170695],[-213.673806,-53.420695],[-212.694246,-50.120695],[-212.448606,-49.520695],[-211.157886,-45.770695],[-209.002356,-39.620695],[-207.749316,-36.320695],[-207.327126,-35.137675],[-206.763606,-33.637675],[-206.176836,-32.120695],[-205.788006,-30.920695],[-204.671376,-28.147045],[-200.909496,-18.099765],[-200.644416,-17.112815],[-200.044416,-15.470695],[-199.444416,-13.682645],[-199.209847,-13.070695],[-198.914676,-12.338415],[-198.249247,-10.529295],[-197.642557,-8.786565],[-197.192557,-7.261405],[-196.744417,-6.056955],[-196.143967,-4.591495],[-195.543967,-3.320935],[-195.521467,-3.095695],[-195.401257,-2.570695],[-194.924347,-1.220695],[-194.514967,-0.170695],[-194.247127,0.354305],[-194.165327,0.729305],[-193.288007,3.144255],[-192.305117,5.769255],[-191.897987,7.029305],[-190.918157,9.654305],[-190.102577,11.229305],[-189.973097,11.494835],[-188.307737,16.669835],[-186.179237,22.629305],[-185.691887,23.979305],[-185.485157,24.429305],[-184.677197,26.229305],[-182.344397,31.629995],[-181.838657,33.017665],[-181.388657,34.404305],[-181.126697,34.629305],[-180.969407,34.888875],[-180.227240,36.501280],[-179.146607,37.929305],[-179.513447,-14.389825],[-179.982827,-21.889825],[-180.443777,-24.320695],[-180.854597,-25.315075],[-180.945397,-25.840075],[-181.129957,-26.270695],[-181.291897,-26.574675],[-181.894375,-28.583271],[-183.435847,-31.301765],[-184.017014,-32.242198],[-183.699667,-32.864825],[-182.734045,-33.323149],[-180.192007,-33.445765],[-176.927457,-33.631125],[-172.080567,-33.949365],[-167.062707,-34.250925],[-158.594337,-34.574465],[-150.557667,-34.753605],[-149.960997,-34.037145],[-149.460319,-32.712273],[-149.354337,-28.886285],[-149.285704,-25.852337],[-149.008815,-24.394744],[-148.750770,-24.184157],[-148.390854,-24.280151],[-147.299007,-25.275205],[-144.701265,-27.389534],[-140.494347,-30.040525],[-136.616824,-31.801880],[-133.788567,-32.714925],[-133.052127,-32.920045],[-127.968120,-33.672251],[-121.144347,-34.075625],[-115.687639,-34.499920],[-110.194347,-35.264355],[-104.244477,-37.037035],[-102.402908,-37.609981],[-102.127200,-37.284033],[-102.078447,-36.499395],[-102.317337,-35.465865],[-102.499647,-34.912165],[-102.963627,-32.870695],[-103.579677,-31.070695],[-105.738638,-26.181339],[-108.463047,-21.824265],[-108.844347,-21.193705],[-111.845007,-17.945729],[-115.911537,-14.120695],[-119.649320,-11.558015],[-122.992170,-10.095369],[-126.427906,-9.591213],[-130.444347,-9.904005],[-135.244347,-10.834565],[-139.963928,-11.552691],[-144.544347,-11.487645],[-147.207349,-10.473689],[-149.190627,-9.036605],[-149.559829,-6.125194],[-149.897937,2.079305],[-150.306507,13.329305],[-150.392407,25.929305],[-150.265390,37.968785],[-149.809807,44.829305],[-149.351197,48.729305],[-148.739287,52.635445],[-148.322227,54.735445],[-147.416227,58.929305],[-146.848327,61.122795],[-146.570954,62.502466],[-146.742997,62.970145],[-173.689815,63.439249],[-203.810867,63.569285],[-209.527397,63.351195],[-210.033587,60.315255],[-210.702317,56.079305],[-211.031387,54.429305],[-211.324277,53.229305],[-211.646687,51.729305],[-211.797047,50.764715],[-212.093687,49.714715],[-212.536757,48.279305],[-213.153347,46.029305],[-213.593687,44.004305],[-213.881207,43.629305],[-214.070657,43.455595],[-214.305380,42.031282],[-215.077337,39.879305],[-217.840037,31.779305],[-220.806095,23.685085],[-221.856468,21.852943],[-222.863897,20.969205],[-226.996573,20.609436],[-242.582987,20.529305],[-258.684290,20.608205],[-261.183510,20.765724],[-261.908657,21.054305],[-263.216790,23.797509],[-265.295617,29.979305],[-266.863037,34.929305],[-267.149247,36.416365],[-267.556537,37.793965],[-267.649037,38.324655],[-267.769027,38.897055],[-268.277987,41.079305],[-268.753857,43.936325],[-268.990087,45.886325],[-269.303847,48.812165],[-269.652364,54.818411],[-269.300847,60.906955],[-269.099837,63.284715],[-278.713831,63.568552],[-293.044424,63.422535]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-231.381617,-0.149965],[-231.260777,-0.610585],[-231.283577,-1.606315],[-231.737777,-3.149675],[-232.076746,-4.199675],[-232.343656,-4.957865],[-232.723306,-6.007865],[-233.480506,-8.270695],[-235.556446,-14.720695],[-235.712956,-15.243245],[-237.752056,-20.870695],[-238.418296,-22.970695],[-239.223076,-24.795045],[-239.491246,-25.423975],[-239.755618,-26.566226],[-240.443056,-27.870695],[-240.718966,-28.320695],[-241.466146,-30.584264],[-241.971471,-31.341828],[-242.361286,-31.461105],[-243.384916,-29.270695],[-244.917366,-25.727725],[-245.738126,-23.581985],[-246.146786,-22.624955],[-246.698207,-21.470695],[-247.334926,-20.128945],[-247.744517,-19.003945],[-247.980677,-18.470695],[-248.264557,-17.837125],[-248.771237,-16.696425],[-249.343547,-15.604995],[-249.987247,-13.820695],[-250.608096,-12.170695],[-250.721566,-11.645695],[-250.774067,-11.345695],[-251.138437,-10.520695],[-251.521357,-9.695695],[-251.644487,-9.320695],[-252.085317,-7.820695],[-252.622587,-6.545695],[-252.735597,-6.170695],[-253.144487,-4.670695],[-253.625457,-3.170695],[-253.890697,-2.078415],[-254.120357,-0.428415],[-253.785177,-0.117142],[-252.370029,0.049671],[-242.591807,0.129305],[-234.341417,0.053604],[-231.381677,-0.149965]]);
    }
    linear_extrude(height=h)
      polygon([[-133.206097,62.513415],[-136.086280,62.050405],[-136.315319,61.573891],[-136.065067,60.729305],[-135.709897,58.329305],[-135.095826,51.879305],[-134.649276,46.029305],[-134.369617,40.479305],[-133.589167,11.079305],[-133.100917,-2.916355],[-132.703255,-4.914594],[-132.402777,-5.221909],[-131.899087,-5.341335],[-130.875097,-5.239425],[-129.606887,-5.077508],[-127.100609,-5.217813],[-124.648905,-5.539808],[-123.544417,-5.922965],[-123.265147,-6.033505],[-122.805547,-6.152695],[-122.184817,-6.275495],[-121.744417,-6.488595],[-121.547017,-6.673295],[-120.947017,-6.810035],[-120.544417,-6.972735],[-119.652277,-7.204623],[-117.669547,-8.259128],[-114.594427,-10.422705],[-114.177697,-10.670695],[-111.900494,-12.382889],[-109.306087,-14.870695],[-107.580757,-16.745695],[-106.591147,-17.870695],[-106.224817,-18.470695],[-105.503167,-19.070695],[-105.194827,-9.545695],[-104.848387,0.359695],[-104.470930,0.513929],[-103.739977,0.059695],[-102.860767,-0.920695],[-101.763367,-2.420695],[-99.890377,-4.670695],[-98.721187,-5.960605],[-98.344417,-6.498265],[-98.030197,-7.158355],[-96.242332,-9.566598],[-95.543017,-11.075155],[-95.493817,-11.197005],[-94.199377,-12.537325],[-93.173587,-14.188715],[-92.182057,-16.092535],[-91.144417,-18.028585],[-90.229837,-20.104805],[-89.497537,-22.375735],[-89.405837,-22.670695],[-88.452586,-24.958785],[-87.968574,-27.047449],[-87.976456,-28.633785],[-88.237007,-31.458485],[-88.294406,-32.896275],[-74.344406,-32.849775],[-61.302555,-32.925533],[-57.177117,-33.362235],[-56.764407,-33.050665],[-57.363795,-31.977935],[-59.541537,-29.653515],[-64.048485,-24.906078],[-67.444407,-20.893745],[-69.550677,-18.245655],[-69.631277,-17.861115],[-69.849797,-17.486115],[-72.420474,-14.282836],[-77.872726,-6.628675],[-81.851026,-0.920655],[-81.713356,0.579345],[-81.276646,3.270925],[-81.108436,4.593325],[-80.984746,5.051745],[-79.877956,8.976005],[-78.283772,14.632309],[-76.014706,21.454112],[-73.571491,28.018947],[-71.454857,32.904345],[-70.877956,34.329345],[-69.751276,36.984605],[-69.368236,37.747785],[-65.311021,46.269440],[-61.116976,54.379345],[-60.844456,54.904345],[-60.581956,55.329345],[-60.151216,56.170595],[-58.933996,58.570595],[-58.020826,60.129345],[-57.550546,61.317395],[-56.944457,62.667395],[-75.471227,62.829345],[-93.997996,62.829345],[-94.336216,62.004345],[-95.092096,59.754345],[-95.362156,59.529345],[-95.498296,59.235545],[-95.694946,58.260545],[-96.121336,57.354345],[-96.242477,56.904345],[-96.269476,56.422765],[-96.491746,55.822765],[-96.930436,54.579345],[-97.468756,52.779345],[-98.345356,49.955495],[-98.873296,48.305495],[-99.166157,47.379345],[-99.699047,45.429345],[-100.156816,43.929345],[-100.925986,41.229345],[-102.227326,36.579345],[-103.126096,33.760045],[-103.567096,31.885045],[-103.726786,31.629345],[-104.008966,31.404345],[-104.046466,30.954345],[-104.182906,30.504345],[-105.081196,28.179345],[-105.473356,27.279345],[-105.733906,28.779345],[-105.986743,40.178977],[-105.745906,55.479345],[-105.642016,62.126965],[-109.441896,62.484218],[-117.660980,62.700786],[-126.761598,62.727067],[-133.206076,62.513455]]);
    linear_extrude(height=h)
      polygon([[301.555624,-36.170695],[301.320524,-37.835655],[301.809423,-36.424545],[302.044423,-34.759585],[301.555624,-36.170695]]);
    linear_extrude(height=h)
      polygon([[-132.996546,-36.001685],[-133.281306,-36.911085],[-133.131306,-37.528795],[-132.848388,-42.610643],[-133.097707,-47.691815],[-133.367001,-49.702205],[-133.455168,-53.904296],[-133.363104,-58.222227],[-133.091707,-60.580135],[-132.070270,-62.038066],[-131.344147,-62.736795],[-130.669147,-62.989355],[-128.693530,-63.750369],[-125.184787,-64.390655],[-122.494147,-64.955865],[-121.744147,-65.213695],[-119.344147,-65.645535],[-116.869147,-66.167695],[-114.844327,-66.750735],[-109.092997,-66.855325],[-104.568363,-66.720038],[-103.106767,-66.410195],[-103.082812,-63.572768],[-103.604047,-59.870695],[-104.073528,-56.191441],[-104.135647,-48.280335],[-104.164323,-41.440774],[-104.341216,-40.355170],[-104.688757,-39.880335],[-105.438517,-39.426765],[-108.094147,-38.571195],[-110.622434,-37.959945],[-114.094147,-37.507485],[-116.944147,-37.170235],[-119.866237,-37.055675],[-122.383747,-36.896215],[-124.711657,-36.576215],[-130.126165,-36.167181],[-132.569887,-35.704785],[-132.996277,-36.001685]]);
  }
}
module AR_Slog(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-87.995527,24.025805],[-89.195527,23.547155],[-90.874627,23.082695],[-91.895527,22.437005],[-92.959327,21.837005],[-93.511297,21.367985],[-93.955927,21.062525],[-94.563822,20.921996],[-95.630069,20.167407],[-98.573617,17.278295],[-100.595527,14.830415],[-104.698447,8.313395],[-105.095527,7.410545],[-105.717457,6.592925],[-106.842457,5.086415],[-107.728447,3.527645],[-109.502497,0.912005],[-111.144577,-1.262995],[-111.395527,-1.819195],[-112.145527,-3.184645],[-112.895527,-3.993895],[-112.922827,-3.003445],[-112.703827,17.332025],[-112.100456,19.626238],[-111.179317,21.300845],[-110.898037,22.271285],[-111.918592,22.640236],[-115.809427,22.711445],[-120.737489,22.569507],[-121.651493,22.366191],[-121.895587,22.034225],[-121.096987,20.041745],[-120.100297,17.937005],[-119.983567,2.421455],[-120.237997,-14.976625],[-121.153897,-18.803035],[-121.866787,-20.655865],[-122.129527,-21.029455],[-122.622832,-21.894145],[-122.429527,-22.622305],[-116.400277,-22.732825],[-111.658473,-22.630386],[-110.800650,-22.473410],[-110.468677,-22.202815],[-109.738957,-21.249235],[-109.295587,-20.466715],[-108.999037,-20.310865],[-108.881107,-20.028565],[-108.727687,-19.562995],[-108.395587,-19.207345],[-107.818057,-18.232345],[-107.143057,-17.174065],[-106.370587,-15.977125],[-105.695587,-14.841055],[-105.388147,-14.462995],[-104.795587,-13.712995],[-104.203027,-12.962995],[-103.895587,-12.497065],[-103.180211,-10.991774],[-102.245887,-10.189585],[-102.183487,-10.089325],[-101.550367,-8.739325],[-100.316407,-6.893065],[-99.335947,-5.468065],[-98.938897,-4.862995],[-98.068297,-3.355045],[-96.843097,-1.255045],[-96.411787,-0.662995],[-95.795617,0.237005],[-95.176237,1.137005],[-94.165447,2.412005],[-93.340897,3.387005],[-93.395597,-17.163175],[-93.584237,-17.839165],[-94.252937,-19.863955],[-94.964297,-21.962995],[-95.045597,-22.712995],[-89.832347,-22.778595],[-84.619127,-22.844195],[-84.784607,-21.610355],[-85.232417,-20.194775],[-86.054627,-18.100925],[-86.215247,-17.463005],[-86.313247,3.386995],[-86.418959,21.420284],[-86.601036,23.755360],[-86.945647,24.143875],[-87.995647,24.025795]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[-154.554817,23.593355],[-156.000097,23.246225],[-159.161992,22.029879],[-162.007987,20.376605],[-162.873067,19.737005],[-163.811707,18.875112],[-164.667547,17.562005],[-165.096337,17.037005],[-165.736387,15.987005],[-166.320817,14.937005],[-166.660957,14.423975],[-167.311057,12.087005],[-167.767293,7.362440],[-167.726304,5.098106],[-167.479657,4.137005],[-167.316337,3.654875],[-167.235873,2.211744],[-166.685407,0.237005],[-166.430017,-0.512995],[-165.932538,-1.838061],[-165.423157,-2.462995],[-164.946247,-3.060715],[-163.520939,-5.207770],[-161.961577,-6.662995],[-160.613887,-7.443595],[-158.335676,-8.724366],[-156.588127,-9.155605],[-155.952787,-9.356965],[-155.601228,-9.568463],[-155.495527,-9.389165],[-155.356927,-9.192032],[-154.861927,-9.381165],[-153.321733,-9.652246],[-151.094767,-9.502313],[-148.886970,-9.030325],[-147.404287,-8.335245],[-146.270527,-7.728465],[-145.595527,-7.242975],[-145.312267,-7.038195],[-143.550956,-5.497774],[-141.375037,-2.577405],[-140.495527,-0.311685],[-140.135527,0.776805],[-139.964587,1.136805],[-139.876787,2.102175],[-139.555297,5.107012],[-139.653725,6.462000],[-139.920087,7.151955],[-148.401867,7.427505],[-156.737967,7.612995],[-156.964067,8.176546],[-156.974847,9.237555],[-156.442587,11.606415],[-155.609427,12.955132],[-154.399621,14.281013],[-152.999087,15.409264],[-151.593747,16.165095],[-149.579943,16.662867],[-147.425824,16.639406],[-145.014024,16.079720],[-142.227177,14.968815],[-139.943764,14.088094],[-139.527194,14.163510],[-139.451037,14.561805],[-140.145777,17.781525],[-140.386017,18.531525],[-140.949747,20.561805],[-141.580557,21.236805],[-141.995577,21.497055],[-144.315979,22.517306],[-147.879507,23.494065],[-151.645182,23.732836],[-154.554867,23.593165]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-150.051157,0.759515],[-150.154961,-0.407725],[-150.770617,-1.781785],[-152.002241,-2.612875],[-153.429277,-3.062995],[-155.201572,-2.405174],[-156.517297,-0.937195],[-156.986414,0.268817],[-156.833474,0.890150],[-155.798253,1.111320],[-153.620527,1.116845],[-150.051157,0.759515]]);
    }
    linear_extrude(height=h)
      polygon([[-37.649797,23.327315],[-40.349797,22.854365],[-41.247157,22.669775],[-42.403867,21.829205],[-43.627267,20.937005],[-43.895527,20.652455],[-44.611777,19.595075],[-45.645217,17.554625],[-46.018109,14.669581],[-45.924217,12.665705],[-46.000817,11.618465],[-45.949117,10.558325],[-45.814777,9.702755],[-46.025414,4.928094],[-45.880777,0.594095],[-45.950377,0.114905],[-46.098157,-0.730825],[-46.097994,-1.424095],[-46.393357,-1.921799],[-47.999587,-2.446885],[-49.445497,-2.612995],[-49.431097,-4.927465],[-49.278877,-7.379725],[-48.243337,-7.615225],[-46.949167,-8.087995],[-46.157407,-8.462995],[-45.094841,-9.231936],[-41.870587,-12.527515],[-41.495587,-13.324825],[-41.028577,-14.396245],[-40.713277,-15.062995],[-40.469257,-16.037995],[-40.212907,-17.398075],[-40.222262,-17.944550],[-39.807374,-18.340608],[-37.740937,-18.662995],[-36.190544,-18.558006],[-35.632627,-18.137995],[-35.296586,-16.925234],[-35.480677,-15.990865],[-35.611554,-15.504134],[-35.428977,-15.116335],[-35.240311,-14.615245],[-35.415177,-13.719955],[-35.573806,-12.994195],[-35.444277,-12.844795],[-35.250987,-12.735520],[-35.217447,-12.170215],[-35.240847,-10.187515],[-35.195647,-9.062035],[-32.890987,-9.170125],[-30.017977,-9.129625],[-29.475982,-8.768519],[-29.119634,-7.950846],[-28.856467,-4.519525],[-28.920572,-2.361676],[-29.181723,-1.216158],[-29.714151,-0.950986],[-30.592087,-1.434175],[-31.605673,-1.915119],[-32.908151,-2.198841],[-34.128104,-2.237826],[-34.894117,-1.984555],[-35.158065,0.561645],[-35.241836,5.723892],[-35.147997,10.852333],[-34.879117,13.297115],[-34.595527,13.998545],[-34.167540,14.889846],[-33.097004,15.779690],[-31.704055,16.463569],[-30.308827,16.736975],[-29.337907,17.248145],[-29.155061,18.110131],[-30.138007,20.558705],[-30.695527,22.126775],[-31.285036,22.806645],[-32.847074,23.268999],[-35.071906,23.460368],[-37.649797,23.327285]]);
    linear_extrude(height=h)
      polygon([[-17.741077,22.874135],[-19.732807,22.062905],[-20.950597,21.091205],[-22.767397,18.450425],[-23.762617,16.405415],[-23.857017,4.946225],[-24.027916,-5.144174],[-24.237850,-6.810929],[-24.619797,-7.701685],[-25.064427,-9.114085],[-23.786847,-9.359725],[-20.045517,-9.381265],[-16.029567,-9.655615],[-14.004406,-9.918081],[-13.651048,-9.729295],[-13.463817,-9.287995],[-13.100487,2.187005],[-12.669777,13.314605],[-12.598077,13.839605],[-12.445497,14.037005],[-12.095487,14.479835],[-11.000517,15.484415],[-9.955456,15.879402],[-9.099057,15.643805],[-7.787731,14.611749],[-7.076007,12.934415],[-6.919891,11.902959],[-7.093107,11.359415],[-7.130507,11.036345],[-6.845507,8.636105],[-7.088207,6.236735],[-7.125007,5.903825],[-6.931897,0.278825],[-7.046516,-4.233895],[-7.452757,-6.512995],[-8.233327,-8.349985],[-8.318627,-9.174985],[-7.750749,-9.563294],[-6.081137,-9.662995],[-3.825737,-9.330955],[-3.433037,-9.292055],[-2.243083,-9.588365],[0.096081,-9.765069],[2.391133,-9.774288],[3.448753,-9.568145],[3.648013,4.570735],[3.802963,18.354445],[4.553713,19.790215],[5.266108,21.555389],[5.227793,22.000422],[4.929463,22.172725],[0.025003,22.276885],[-4.849997,22.558915],[-5.195537,22.454755],[-5.735537,22.137055],[-6.624726,21.766244],[-6.995537,20.877055],[-7.069190,20.462959],[-7.335171,20.396564],[-8.714237,21.387055],[-10.393217,22.437055],[-10.950887,22.753075],[-11.833365,23.062118],[-13.738881,23.193869],[-17.741087,22.874185]]);
    linear_extrude(height=h)
      polygon([[-225.620527,22.806335],[-226.094058,22.615210],[-226.268379,22.269609],[-225.711327,21.252845],[-225.009188,20.144130],[-224.612213,17.898350],[-224.374827,5.862185],[-224.495517,-6.363715],[-224.642187,-9.738865],[-224.750007,-14.087965],[-224.861157,-15.062965],[-227.222277,-15.062965],[-230.415392,-14.690860],[-232.619137,-13.666435],[-233.620507,-13.262965],[-234.017993,-13.490369],[-233.945627,-14.537965],[-232.234117,-21.860635],[-231.760164,-22.353629],[-229.968954,-22.606638],[-216.535857,-22.712965],[-206.209118,-22.634121],[-203.523447,-22.307815],[-203.517447,-20.807815],[-203.931747,-18.662965],[-204.797239,-14.622524],[-205.585107,-12.962965],[-206.373027,-13.593685],[-208.011518,-14.723545],[-210.425877,-15.140425],[-211.923286,-15.100218],[-212.489397,-14.762965],[-213.076227,-13.597765],[-213.193137,-12.697765],[-212.874747,2.858465],[-212.741956,15.805816],[-212.584622,18.106888],[-212.319957,18.983465],[-212.025987,19.737035],[-211.460487,20.740355],[-210.736081,21.998851],[-210.831830,22.352048],[-211.220217,22.620305],[-218.114723,22.886232],[-225.620217,22.806335]]);
    linear_extrude(height=h)
      polygon([[-193.745527,22.737035],[-199.567964,22.413552],[-200.355000,22.115605],[-200.070997,21.668555],[-199.566907,21.039365],[-199.268857,19.637945],[-199.011457,9.887945],[-199.029457,0.762035],[-199.072357,-4.412965],[-198.970627,-8.989555],[-198.951727,-10.086025],[-199.133437,-14.884435],[-199.376137,-19.562965],[-199.478737,-19.809175],[-199.893277,-20.987185],[-200.244510,-21.848621],[-199.837949,-22.360439],[-195.800167,-22.743355],[-191.880667,-22.977775],[-191.316157,-22.960075],[-190.890907,-23.205745],[-190.839569,-23.462815],[-190.628407,-23.205805],[-190.383071,-22.975109],[-190.165297,-23.130805],[-189.795181,-23.421100],[-189.309674,-23.442276],[-188.522317,-22.787845],[-188.479617,-22.030285],[-188.590047,-20.530285],[-188.503247,-13.637845],[-188.325688,-8.591496],[-187.922464,-8.177825],[-187.163177,-8.622385],[-185.905877,-9.062845],[-185.075867,-9.313735],[-183.633167,-9.624925],[-181.280807,-9.795865],[-178.655807,-9.357025],[-177.095507,-8.926165],[-174.377777,-7.107955],[-172.640537,-4.946395],[-171.939242,-3.627850],[-171.560754,-1.606311],[-171.273557,9.996785],[-171.090546,18.118891],[-170.887799,19.556671],[-170.531987,20.346785],[-169.929288,21.866555],[-170.094186,22.297273],[-170.570487,22.540775],[-180.301077,22.654385],[-181.132287,22.725285],[-182.573543,22.603706],[-183.157983,22.235897],[-183.395487,21.771375],[-183.128007,21.237135],[-182.672307,20.487135],[-182.224497,19.737135],[-182.046537,10.590255],[-182.034094,3.521696],[-181.786797,1.647825],[-181.595743,1.711005],[-181.781797,1.419735],[-182.320387,-0.137865],[-182.583633,-0.951623],[-182.944597,-1.262865],[-183.651247,-1.772355],[-184.274628,-2.207310],[-185.264418,-2.281324],[-186.347150,-2.019215],[-187.249357,-1.445805],[-187.915784,-0.403564],[-188.202817,1.510845],[-188.309894,11.906228],[-187.995967,20.000175],[-187.299427,21.087135],[-186.762307,22.191825],[-186.963833,22.526683],[-188.087418,22.720789],[-193.745917,22.737135]]);
    linear_extrude(height=h)
      polygon([[-73.851547,22.724135],[-75.786547,22.165895],[-76.518187,21.836915],[-77.232959,21.560247],[-78.555907,20.443745],[-79.412737,19.954145],[-79.763437,19.322315],[-80.224027,18.536915],[-80.873656,17.572716],[-81.444026,15.340719],[-81.751624,12.831819],[-81.612937,11.036915],[-81.119467,9.536915],[-80.076066,7.795277],[-78.196518,6.052475],[-75.840414,4.581360],[-73.367347,3.654785],[-68.297827,1.985675],[-66.924406,1.156422],[-66.214046,0.159515],[-66.189941,-0.938889],[-66.875287,-2.072635],[-67.903012,-2.785983],[-70.198837,-2.849305],[-72.560962,-2.641716],[-74.405317,-2.024305],[-76.331767,-1.263085],[-76.588887,-2.154246],[-76.283267,-3.220615],[-76.142207,-3.952795],[-76.146474,-4.387919],[-75.884327,-4.656655],[-75.249017,-6.042205],[-74.769107,-7.263085],[-74.554907,-7.488085],[-74.358909,-8.432778],[-73.860737,-8.891605],[-73.114877,-9.088465],[-71.537571,-9.559904],[-67.295477,-9.822565],[-64.473750,-9.793557],[-62.316167,-9.419275],[-60.578839,-8.626651],[-59.017877,-7.342615],[-58.349357,-6.915025],[-57.623447,-6.090025],[-57.273347,-5.163085],[-57.028187,-4.788085],[-56.311604,-3.833240],[-55.829743,-2.132534],[-55.406627,4.436915],[-55.131137,12.041176],[-54.839998,13.701033],[-54.372077,14.669765],[-52.705858,16.062609],[-51.811831,16.501010],[-51.282617,16.524065],[-51.099039,16.607031],[-51.112292,17.251201],[-51.590237,19.071545],[-52.132397,20.486915],[-52.387637,21.311915],[-52.728017,22.265915],[-53.414677,22.723835],[-54.885853,22.951895],[-58.745477,22.631225],[-61.745477,21.235775],[-63.020477,20.458115],[-63.395477,19.854815],[-63.688547,19.436915],[-64.503319,18.683376],[-65.272629,16.738040],[-65.857541,14.073829],[-66.119117,11.163665],[-66.247007,8.336915],[-67.723119,8.962554],[-69.309617,10.078895],[-70.196124,11.287835],[-70.336487,13.112375],[-70.131444,14.368430],[-69.369167,15.414065],[-68.009237,16.231505],[-67.595477,16.422515],[-67.322537,16.603655],[-66.599717,16.607655],[-66.299537,16.931700],[-66.403277,17.664165],[-66.688337,18.687045],[-67.301117,20.106495],[-67.888877,21.725235],[-68.375682,22.369117],[-69.669283,22.773277],[-71.563336,22.903152],[-73.851497,22.724175]]);
    linear_extrude(height=h)
      polygon([[110.280863,22.913315],[107.902553,22.625735],[104.472953,22.171475],[103.122953,21.925115],[101.604473,21.352595],[99.423443,20.386925],[98.347928,19.323860],[98.108693,17.870825],[97.957523,17.336915],[97.739183,16.811915],[97.410383,14.486915],[97.080657,12.115265],[97.250813,10.790585],[97.762414,10.860523],[99.054473,11.635805],[105.152813,14.747195],[108.602813,15.075095],[112.022119,14.711053],[113.232583,14.220208],[114.180593,13.503665],[114.574585,12.622184],[114.755693,11.234821],[114.705591,9.744223],[114.405953,8.553035],[112.871194,6.614570],[110.754473,5.046095],[108.654473,3.812195],[106.779473,2.807795],[106.104473,2.316695],[105.504473,2.036915],[104.904473,1.736915],[104.591333,1.436915],[100.254263,-2.018035],[99.125866,-3.448982],[98.822543,-4.272205],[98.529473,-4.587115],[98.004473,-5.497705],[97.708493,-6.655555],[97.272713,-8.660845],[97.004813,-10.984855],[97.292326,-13.733417],[98.296643,-16.801075],[99.411154,-18.617057],[101.154473,-20.531905],[104.448781,-22.524539],[108.180533,-23.968285],[112.948613,-24.143875],[116.443643,-23.780635],[117.472913,-23.524525],[119.220713,-23.116555],[120.624263,-22.717495],[121.276349,-22.470861],[121.681399,-21.788916],[121.959023,-18.452455],[121.666523,-14.692195],[121.342114,-14.268925],[120.940193,-14.663395],[120.514013,-14.953675],[119.724773,-15.205045],[116.900195,-16.417889],[113.746133,-16.878539],[110.995563,-16.568321],[110.000644,-16.118303],[109.381463,-15.468565],[108.960953,-12.719755],[109.076378,-11.080026],[109.544903,-10.441795],[111.159443,-9.138175],[112.544153,-8.163175],[114.167993,-7.538327],[115.689593,-6.531115],[116.501183,-6.063175],[118.441846,-5.287420],[119.904473,-4.258135],[120.371993,-3.963175],[121.344137,-3.289770],[122.800628,-1.747199],[124.125921,-0.051925],[124.704473,1.079585],[125.289023,2.386355],[125.890882,4.073680],[126.276376,6.280381],[126.401600,8.616002],[126.222653,10.690085],[125.262068,13.939370],[124.058213,16.141685],[123.074993,17.411825],[122.119973,18.236825],[121.704473,18.686825],[121.404473,19.136825],[120.520673,19.720625],[118.356136,21.018361],[116.163293,21.836825],[115.576343,22.101425],[113.383643,22.569785],[110.882783,22.908485],[110.280863,22.913485]]);
    linear_extrude(height=h)
      polygon([[37.854473,22.330835],[34.945077,21.395585],[32.679473,19.758605],[31.104473,17.955665],[30.507023,16.358765],[30.034591,14.809516],[29.797643,12.737525],[29.843892,10.494215],[30.551573,8.694965],[32.293429,6.289955],[33.930863,5.042795],[34.680863,4.628105],[37.817254,3.323990],[41.683613,2.228315],[43.116803,1.561535],[44.641913,0.768755],[45.031229,0.361779],[45.255518,-0.376889],[45.083153,-2.046085],[43.884713,-3.057715],[41.012157,-3.350155],[38.138003,-2.755465],[35.960386,-1.994020],[34.884863,-2.113765],[35.269673,-3.944005],[35.650643,-5.467555],[35.805983,-5.695735],[36.573323,-7.566145],[37.099306,-9.010330],[38.099903,-9.581245],[41.027423,-10.100815],[43.059533,-10.385185],[46.307476,-10.252199],[49.499573,-9.687865],[50.322263,-9.362965],[52.136832,-8.304130],[53.956733,-6.343495],[54.788993,-5.162965],[55.562093,-3.062965],[56.025079,-0.419125],[56.209403,4.137035],[56.388166,11.681379],[56.670203,13.437035],[56.904473,13.830905],[57.831867,15.088775],[59.521133,16.015355],[60.612353,16.585445],[60.322024,18.209446],[59.440913,20.147435],[59.004473,21.175205],[58.827433,21.788970],[58.262412,22.203425],[55.765013,22.518755],[53.650058,22.386706],[52.045943,21.882875],[50.334113,21.237035],[48.425843,19.644845],[47.076732,18.050077],[46.167698,16.294152],[45.622602,14.174122],[45.365303,11.487035],[45.216383,8.262035],[44.754466,8.041572],[44.304473,8.273135],[43.724693,8.552975],[42.521512,9.001030],[41.630018,10.032177],[41.144514,11.476864],[41.159303,13.165535],[41.513503,14.157000],[42.180462,15.002435],[43.096051,15.641680],[44.196143,16.014575],[45.098821,16.334495],[45.065273,17.301515],[44.832443,18.749075],[44.404463,19.264655],[43.982543,19.952555],[43.336673,21.529137],[42.739106,22.071456],[42.100013,22.275155],[41.304473,22.430915],[40.090797,22.584335],[37.854473,22.330775]]);
    linear_extrude(height=h)
      polygon([[138.204473,22.364335],[136.869473,21.813565],[136.108193,21.537055],[134.327513,20.151190],[132.557183,17.937055],[132.172285,16.905230],[131.946072,15.243918],[131.720993,6.687055],[131.457233,-2.687945],[130.433423,-3.062945],[128.754473,-3.362945],[128.089579,-3.912226],[128.110193,-5.837945],[128.282104,-7.960813],[128.616983,-8.162945],[131.172541,-9.238659],[133.853603,-11.032055],[135.565246,-13.147115],[136.565933,-15.018635],[137.974823,-19.306295],[140.080988,-19.518100],[141.958193,-19.256895],[142.261073,-14.883225],[142.564212,-10.409760],[142.960225,-9.874894],[143.686913,-9.886935],[145.104473,-10.019985],[147.568321,-9.855330],[148.388903,-9.392025],[148.659409,-5.868401],[148.519763,-2.087265],[148.192538,-1.755124],[147.109043,-2.278545],[144.511474,-3.127478],[143.367067,-3.160947],[142.681313,-2.885025],[142.418333,1.052505],[142.544453,8.487075],[142.692387,11.724952],[143.076353,13.287075],[144.398191,14.999314],[146.313353,15.659925],[147.593816,15.909880],[148.285561,16.283014],[148.452707,16.849473],[148.159373,17.679405],[147.278603,19.907985],[146.763975,21.153346],[146.007897,21.936656],[144.831209,22.370760],[143.054753,22.568505],[140.752853,22.439685],[140.085263,22.407085],[138.204473,22.364285]]);
    linear_extrude(height=h)
      polygon([[9.236153,22.173535],[9.034422,21.730379],[9.536153,20.742565],[10.029715,19.857905],[10.280738,18.770042],[10.382183,12.987055],[10.199566,-0.357601],[9.798293,-6.976895],[9.187253,-8.186465],[8.990922,-8.944955],[9.506558,-9.391104],[13.566173,-9.643205],[18.812423,-9.965075],[20.414446,-10.125346],[20.708515,-9.810361],[20.738513,-9.202715],[20.882123,-7.864168],[21.279779,-7.906622],[21.919343,-8.406935],[24.104224,-9.818038],[26.810993,-10.183295],[28.196121,-10.038765],[28.931052,-9.454576],[29.204919,-8.059707],[29.206853,-5.483135],[28.887391,-2.140055],[28.465605,-1.660433],[27.772853,-1.722965],[25.786564,-1.971840],[24.504233,-1.787965],[24.055073,-1.562965],[22.330073,-0.359035],[21.054473,0.844925],[21.054473,6.615965],[21.258619,16.854751],[21.561799,19.294098],[22.041713,20.548895],[22.659379,21.586707],[22.179473,21.987185],[15.581566,22.322011],[9.236153,22.173515]]);
    linear_extrude(height=h)
      polygon([[193.029473,22.206335],[192.504473,21.797345],[192.214763,21.680675],[190.694956,21.223524],[189.307763,20.173475],[188.747363,19.737035],[187.428533,17.836445],[186.502643,15.935855],[186.473543,9.211445],[186.470543,2.037035],[186.130253,-3.236815],[184.592663,-3.411175],[183.376666,-3.574465],[182.963333,-4.358395],[182.782283,-6.787233],[182.991497,-7.771465],[183.376223,-8.366245],[184.320503,-8.629015],[184.704113,-8.772385],[185.263463,-9.062965],[186.838463,-9.958165],[188.204633,-10.858165],[189.204113,-11.912965],[190.128593,-12.962965],[190.404113,-13.545265],[190.722623,-14.324395],[191.352413,-15.317095],[192.045053,-17.912965],[192.298166,-18.911920],[192.670366,-19.469714],[194.447273,-19.789255],[195.895398,-19.717541],[196.654816,-19.139868],[196.944849,-17.617288],[196.984823,-14.710855],[197.084623,-10.382455],[199.965883,-10.203865],[202.094492,-10.058354],[203.043943,-9.764935],[203.364056,-6.067986],[203.097443,-2.436355],[202.539413,-2.376648],[201.480623,-2.747965],[199.868171,-3.284217],[198.539127,-3.357389],[197.636688,-2.986573],[197.304053,-2.190865],[196.944053,-1.022965],[196.750246,-0.749005],[196.919453,-0.662965],[197.179962,0.849541],[197.273093,5.745935],[197.403259,11.637117],[197.586129,12.884144],[197.882243,13.437035],[198.365003,14.152475],[198.877103,14.602475],[199.563443,15.087035],[199.850296,15.400629],[199.858643,15.312035],[199.890481,14.961856],[201.039293,15.361535],[202.222403,15.618785],[202.843973,15.828635],[203.133383,16.821264],[202.714403,18.087065],[201.995003,19.775315],[201.398552,21.110378],[200.609487,21.846170],[199.249107,22.169245],[196.938713,22.266155],[193.029113,22.206355]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[220.404473,22.227335],[218.904473,21.929255],[217.918673,21.811505],[216.006169,21.359461],[213.804473,20.332055],[212.529473,19.645145],[212.004473,19.146335],[211.659563,18.836915],[210.884155,18.354647],[209.739507,17.149100],[207.570263,14.015705],[206.811364,12.243242],[206.345569,10.351149],[206.114903,5.117465],[206.585116,0.440424],[207.023462,-1.287656],[207.537683,-2.298085],[207.804473,-3.106075],[208.436993,-4.072105],[208.878533,-4.824145],[209.219463,-5.565931],[210.379568,-6.802416],[213.362723,-9.063085],[215.005163,-10.010545],[216.355163,-10.424665],[217.854473,-10.867945],[220.913783,-11.013175],[223.356709,-10.811065],[224.983493,-10.297435],[226.612463,-9.663085],[227.338343,-9.172285],[228.866333,-7.974025],[229.852523,-6.889855],[230.759933,-5.763085],[231.615376,-4.912210],[232.150643,-3.888085],[232.702883,-2.763085],[233.399341,-0.390340],[234.017993,3.562535],[233.882303,5.662535],[233.609063,5.869355],[232.854473,5.936955],[232.273407,6.074176],[232.099883,5.854555],[232.037746,5.664777],[231.874883,5.786955],[225.504473,6.136935],[217.950473,6.211935],[216.546443,6.236835],[216.642243,7.666995],[217.269123,10.291995],[217.827333,11.672895],[219.402712,13.139737],[221.822763,14.693385],[224.794777,15.316061],[226.246633,15.299345],[227.178123,15.032415],[227.706708,14.816471],[228.282093,14.978415],[228.693281,15.147716],[228.672963,14.966715],[228.861753,14.635305],[231.297663,13.585305],[233.622663,12.536775],[233.883896,13.467649],[233.455053,15.646665],[233.150793,17.330865],[232.708533,18.757485],[232.081588,19.652839],[231.143482,20.392766],[228.354453,21.393795],[226.854453,21.734235],[223.879282,22.277704],[220.404453,22.227195]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[223.493063,-0.343525],[223.696439,-0.741819],[223.485938,-1.635587],[222.321413,-3.547465],[221.299756,-4.280755],[220.219643,-4.360825],[218.488013,-3.910765],[217.368053,-3.065268],[216.921833,-2.463085],[216.813173,-1.593445],[216.885173,-0.402415],[219.234199,-0.190347],[223.493093,-0.343515]]);
    }
    linear_extrude(height=h)
      polygon([[65.047373,21.877925],[64.838641,20.989602],[65.450123,19.736915],[65.729988,19.293608],[65.865169,17.598147],[65.904893,2.936915],[65.809703,-16.630788],[65.652842,-19.862180],[65.379473,-20.688205],[65.004473,-21.242155],[64.640843,-22.253515],[64.505903,-23.064505],[69.394433,-23.368585],[73.150118,-23.525931],[74.898623,-23.865205],[76.073479,-24.041774],[76.594643,-23.112085],[76.854593,-2.463085],[77.170647,15.788517],[77.504994,19.045545],[78.078023,20.681735],[78.328656,21.374649],[78.121623,21.776075],[71.622881,22.106315],[65.047413,21.877925]]);
    linear_extrude(height=h)
      polygon([[157.942133,21.412025],[155.673991,20.421894],[153.476813,18.421895],[152.580169,17.258135],[152.147723,16.096895],[151.729763,14.936915],[151.455286,12.391171],[151.752263,8.847575],[152.898027,6.603140],[154.147223,5.336915],[155.546993,4.470335],[158.275369,3.076936],[161.005613,2.336915],[161.604413,2.023775],[161.979413,1.771865],[163.198943,1.485035],[164.606243,1.136915],[165.357443,0.832025],[165.825143,0.699725],[166.104413,0.429635],[166.466003,-0.133615],[166.820243,-1.510885],[166.692844,-2.485085],[166.265251,-3.138160],[165.449116,-3.545445],[164.156093,-3.782275],[161.516873,-3.801025],[159.104543,-3.088915],[157.611778,-2.556031],[156.704674,-2.496377],[156.388415,-2.908471],[156.668183,-3.790825],[156.950063,-4.870135],[157.287383,-5.603185],[157.600673,-6.266815],[157.776353,-7.077535],[158.235593,-8.459215],[158.909622,-9.710489],[159.434186,-10.056438],[159.938363,-10.077715],[160.404413,-10.195495],[161.709588,-10.615391],[164.735221,-10.842062],[168.146469,-10.830830],[170.608493,-10.537015],[172.960362,-9.482946],[174.464093,-8.359015],[175.470773,-7.083355],[176.467876,-5.587030],[177.104618,-3.548500],[177.469516,-0.519993],[177.651083,3.946265],[177.985748,11.734850],[178.284469,13.187108],[178.743773,13.660295],[179.304413,14.173745],[180.075574,14.903982],[181.170443,15.292265],[181.541632,15.441679],[181.770094,15.979569],[181.660613,17.576615],[181.267193,18.846635],[180.709493,20.214725],[180.019249,21.269259],[178.818323,21.783185],[175.564681,21.851728],[174.008315,21.540143],[173.121353,21.075305],[172.354163,20.636915],[171.235620,20.145367],[169.851732,18.942560],[168.599294,17.436251],[167.875103,16.034195],[167.232503,14.133995],[166.864313,11.133995],[166.743203,7.736915],[166.624643,6.905195],[166.169423,7.302515],[165.504413,7.958165],[164.022008,8.693071],[162.919583,10.360715],[162.604904,11.368010],[162.662614,12.381898],[163.096159,13.416744],[163.908983,14.486915],[165.107813,15.611915],[165.916913,15.536915],[166.489827,15.698934],[166.631123,16.361915],[166.104143,18.386915],[165.201953,20.565725],[164.868787,21.213740],[164.335073,21.600102],[161.754413,21.955295],[159.905551,21.892861],[157.942073,21.412025]]);
  }
}
module AR_Back(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-1.825688,110.140693],[-3.841553,109.212763],[-7.675688,106.080013],[-12.459728,101.793823],[-13.697618,100.720933],[-22.509698,92.707123],[-31.368038,84.607123],[-56.946848,61.126243],[-65.757128,53.147473],[-73.610288,45.972553],[-83.119988,37.232203],[-91.322258,29.773273],[-101.641478,20.473273],[-107.689238,15.134983],[-111.750008,11.566063],[-122.823158,1.880863],[-128.223158,-2.827967],[-133.278008,-7.284887],[-136.935968,-10.449787],[-141.011737,-13.942877],[-153.410197,-24.806667],[-158.283098,-29.242347],[-161.178596,-32.084242],[-162.679725,-34.324753],[-163.320960,-37.253496],[-163.636777,-42.160087],[-163.808554,-47.445502],[-163.369928,-50.110087],[-162.533490,-52.206463],[-160.447898,-54.367557],[-155.581057,-58.717557],[-150.058957,-63.592877],[-144.595237,-68.392877],[-139.137157,-73.192877],[-125.382307,-85.342877],[-121.439467,-88.792877],[-105.542227,-102.623757],[-96.757987,-110.154627],[-88.128997,-110.314887],[0.014224,-110.472241],[87.948622,-110.315787],[96.397223,-110.154997],[104.298623,-103.253937],[120.149993,-89.408577],[157.013093,-57.301717],[162.007200,-52.842184],[162.878303,-51.558907],[163.369583,-50.109947],[163.808554,-47.445602],[163.636763,-42.159947],[163.320945,-37.253356],[162.679710,-34.324613],[161.178581,-32.084102],[158.283083,-29.242207],[153.410183,-24.806527],[141.011723,-13.942737],[136.935953,-10.449647],[133.277993,-7.284747],[128.223143,-2.827827],[122.823143,1.881003],[111.749993,11.566203],[107.689222,15.135123],[101.641462,20.473413],[91.322242,29.773413],[83.119972,37.232343],[73.610272,45.972693],[65.757112,53.147613],[56.946832,61.126383],[31.368022,84.607263],[22.507282,92.706423],[13.488142,100.873443],[12.402652,101.799963],[7.799992,105.954183],[4.518431,108.689756],[2.296729,110.092162],[0.420239,110.472241],[-1.825688,110.140833]]);
  }
}
module AS_Stat(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[90.470715,27.604420],[87.840246,26.129124],[85.996574,24.111835],[84.911239,21.507648],[84.555785,18.271660],[84.794228,14.590485],[85.187707,13.424754],[85.848847,12.646569],[86.841265,12.209163],[88.228578,12.065768],[92.442355,12.473940],[95.709509,12.743206],[98.194424,12.508026],[99.774949,11.796779],[100.328935,10.637840],[99.706635,9.015385],[98.012252,6.810799],[95.504567,4.313629],[92.442355,1.813420],[88.901557,-1.233067],[86.447051,-4.370994],[85.018555,-7.700768],[84.555785,-11.322800],[84.803706,-15.562875],[85.570955,-19.092996],[86.892761,-21.943099],[88.804350,-24.143119],[91.340952,-25.722992],[94.537795,-26.712652],[98.430106,-27.142037],[103.053115,-27.041080],[109.440724,-26.379493],[111.549910,-25.872770],[113.082735,-25.151006],[114.149238,-24.140887],[114.859458,-22.769096],[115.651205,-18.647240],[115.929374,-14.507645],[115.718863,-13.225976],[115.183671,-12.388997],[114.255087,-11.936160],[112.864396,-11.806917],[108.421845,-12.277020],[105.085152,-12.632718],[102.693396,-12.564821],[101.245921,-12.048137],[100.742071,-11.057478],[101.181189,-9.567650],[102.562619,-7.553466],[108.149785,-1.851260],[110.883595,1.002169],[113.211306,4.110346],[115.093772,7.361569],[116.491846,10.644137],[117.366384,13.846350],[117.678238,16.856506],[117.388264,19.562903],[116.457315,21.853840],[115.328876,23.022668],[113.392127,24.370868],[108.050059,27.171218],[102.343826,29.386556],[99.951872,30.003492],[98.186145,30.148550],[95.177036,29.332418],[90.470715,27.604420]]);
    linear_extrude(height=h)
      polygon([[-205.494905,25.933750],[-205.946372,24.983658],[-206.325197,23.188599],[-206.870965,17.535389],[-207.157279,1.279256],[-206.450546,-15.285717],[-205.755005,-21.324978],[-204.847465,-24.610600],[-203.503511,-25.981581],[-201.628949,-26.841795],[-199.402064,-27.140852],[-197.001145,-26.828360],[-194.855186,-26.455188],[-193.097834,-26.507545],[-191.910434,-26.954672],[-191.474335,-27.765810],[-191.054319,-28.996324],[-189.916096,-29.769387],[-188.242401,-30.108081],[-186.215969,-30.035486],[-184.019536,-29.574685],[-181.835837,-28.748758],[-179.847608,-27.580786],[-178.237585,-26.093850],[-177.113517,-24.441534],[-176.558920,-22.895723],[-176.564760,-21.469715],[-177.122004,-20.176810],[-178.221617,-19.030307],[-179.854566,-18.043505],[-182.011816,-17.229703],[-184.684335,-16.602200],[-187.090186,-15.901462],[-188.916695,-14.846810],[-190.142146,-13.549604],[-190.744829,-12.121209],[-190.703028,-10.672984],[-189.995031,-9.316294],[-188.599125,-8.162498],[-186.493595,-7.322960],[-184.189276,-6.398915],[-182.529383,-5.065455],[-181.515944,-3.420573],[-181.150990,-1.562264],[-181.436550,0.411481],[-182.374655,2.402666],[-183.967333,4.313301],[-186.216615,6.045390],[-188.477876,7.630491],[-190.066429,9.126274],[-190.983855,10.511152],[-191.231734,11.763537],[-190.811647,12.861844],[-189.725176,13.784484],[-187.973902,14.509872],[-185.559405,15.016420],[-182.976213,15.765093],[-180.958900,17.170900],[-179.553092,19.188213],[-178.804415,21.771400],[-178.692673,24.992274],[-179.149113,26.035282],[-180.090391,26.770346],[-181.623981,27.250226],[-183.857354,27.527678],[-190.853345,27.686330],[-200.471019,27.171514],[-203.797400,26.614249],[-205.494905,25.933750]]);
    linear_extrude(height=h)
      polygon([[-166.062025,25.933750],[-166.742524,23.453088],[-167.299789,17.994350],[-167.814605,1.367040],[-167.647408,-7.390040],[-167.082750,-14.434993],[-166.026034,-19.935650],[-164.382659,-24.059841],[-163.311412,-25.658209],[-162.058026,-26.975397],[-160.610677,-28.032383],[-158.957538,-28.850146],[-154.986594,-29.851921],[-150.050595,-30.148550],[-147.459749,-30.002130],[-145.038435,-29.571344],[-142.794009,-28.868898],[-140.733828,-27.907502],[-138.865247,-26.699865],[-137.195624,-25.258693],[-134.482678,-21.726584],[-132.653839,-17.412841],[-131.767961,-12.419131],[-131.883896,-6.847122],[-133.060495,-0.798480],[-133.920409,3.334849],[-134.438693,7.986376],[-134.575035,12.586358],[-134.289125,16.565050],[-134.075289,20.145076],[-134.527461,23.046674],[-135.567073,25.225108],[-137.115558,26.635641],[-139.094346,27.233537],[-141.424871,26.974058],[-144.028563,25.812468],[-146.826855,23.704030],[-149.639134,21.319384],[-151.388905,20.486165],[-152.012335,20.644403],[-152.546521,21.182174],[-153.582335,23.385210],[-154.457830,24.866260],[-155.765953,26.063583],[-157.388173,26.952976],[-159.205954,27.510230],[-161.100763,27.711141],[-162.954067,27.531502],[-164.647332,26.947107],[-166.062025,25.933750]]);
    linear_extrude(height=h)
      polygon([[-124.059865,21.909340],[-124.959197,16.973563],[-125.512091,10.614908],[-125.737188,3.423597],[-125.653133,-4.010150],[-125.278567,-11.096110],[-124.632136,-17.244063],[-123.732480,-21.863787],[-123.193520,-23.416119],[-122.598245,-24.365060],[-120.992729,-25.589945],[-118.953271,-26.593019],[-116.741668,-27.270770],[-114.619715,-27.519690],[-113.149123,-27.373214],[-112.024346,-26.776898],[-111.209799,-25.495412],[-110.669895,-23.293428],[-110.271672,-15.186638],[-110.544985,-0.573890],[-111.095948,14.275544],[-111.480159,19.069502],[-112.016119,22.457466],[-112.763277,24.700319],[-113.781080,26.058945],[-115.128977,26.794228],[-116.866415,27.167050],[-119.497941,27.188237],[-121.515356,26.361895],[-123.006664,24.623703],[-124.059865,21.909340]]);
    linear_extrude(height=h)
      polygon([[-95.362045,24.184350],[-97.008478,22.562021],[-98.397697,20.348955],[-99.533634,17.629355],[-100.420222,14.487424],[-101.461079,7.273378],[-101.551726,-0.619560],[-100.723622,-8.517769],[-99.008225,-15.747626],[-97.827622,-18.901416],[-96.436993,-21.635511],[-94.840270,-23.865706],[-93.041385,-25.507800],[-91.300517,-26.500407],[-89.420450,-27.181679],[-85.381532,-27.677132],[-81.202267,-27.127990],[-77.160291,-25.668084],[-73.533240,-23.431242],[-70.598750,-20.551296],[-69.477976,-18.911981],[-68.634456,-17.162075],[-68.102894,-15.318309],[-67.917995,-13.397410],[-68.353266,-11.211428],[-68.965179,-10.474256],[-69.900235,-9.951449],[-72.920639,-9.480378],[-77.776215,-9.661120],[-87.634435,-10.432110],[-88.453745,0.964620],[-89.273075,12.361350],[-79.318485,11.480050],[-74.289477,11.248646],[-71.095345,11.753344],[-70.041307,12.337329],[-69.271928,13.172057],[-68.355065,15.682700],[-68.212431,17.536682],[-68.512693,19.276902],[-69.213246,20.889947],[-70.271486,22.362405],[-71.644810,23.680866],[-73.290612,24.831918],[-77.229236,26.578146],[-81.746525,27.493797],[-86.501645,27.471576],[-91.153763,26.404192],[-93.334686,25.445034],[-95.362045,24.184350]]);
    linear_extrude(height=h)
      polygon([[-55.549715,25.928630],[-55.755873,23.950666],[-55.368145,20.112137],[-53.266776,8.919806],[-50.157102,-3.515513],[-48.508992,-8.907777],[-46.950615,-13.060970],[-43.650765,-22.032290],[-42.700635,-24.218784],[-41.318171,-25.660763],[-39.648259,-26.382888],[-37.835783,-26.409823],[-36.025626,-25.766228],[-34.362675,-24.476766],[-32.991813,-22.566099],[-32.057925,-20.058890],[-30.310519,-14.344382],[-28.452915,-10.432110],[-27.061469,-7.503316],[-25.540495,-2.001840],[-23.726863,6.770588],[-21.457445,19.512240],[-20.734456,24.547019],[-20.766044,26.053917],[-21.147764,26.990111],[-21.945675,27.432819],[-23.225837,27.459258],[-27.497145,26.572200],[-33.929855,25.217606],[-39.095166,24.733609],[-43.727701,25.112320],[-48.562085,26.345850],[-50.851594,26.869348],[-52.932222,26.965184],[-54.574690,26.647048],[-55.549715,25.928630]]);
    linear_extrude(height=h)
      polygon([[-6.892235,2.054960],[-6.338419,-12.227086],[-5.948496,-16.796006],[-5.395101,-20.000086],[-4.612140,-22.101749],[-3.533515,-23.363418],[-2.093132,-24.047514],[-0.224895,-24.416460],[2.300780,-24.524077],[4.156096,-24.052085],[5.299650,-23.021238],[5.690035,-21.452290],[5.982525,-19.732423],[6.778910,-17.861845],[7.957562,-16.066327],[9.396855,-14.571640],[11.322686,-13.368955],[12.074955,-13.312800],[12.724580,-13.654221],[13.829257,-15.632156],[14.863435,-19.507480],[15.925982,-22.738207],[17.427089,-25.167191],[19.224779,-26.771222],[21.177078,-27.527092],[23.142006,-27.411591],[24.977590,-26.401508],[26.541852,-24.473634],[27.692815,-21.604760],[28.365972,-18.223758],[28.845380,-13.970988],[29.223611,-3.709047],[28.828819,7.463254],[27.662315,17.828110],[26.586792,22.837830],[25.936443,24.561243],[25.148334,25.841107],[24.175437,26.735486],[22.970726,27.302441],[19.677755,27.686330],[16.522437,27.232958],[13.924956,25.765355],[11.696005,23.122292],[9.646275,19.142540],[5.969865,10.598750],[4.186845,19.142540],[3.090937,23.024354],[1.642043,25.678299],[-0.236275,27.200312],[-2.620455,27.686330],[-4.168929,27.558871],[-5.349540,27.020478],[-6.201292,25.837122],[-6.763190,23.774776],[-7.173445,16.077009],[-6.892345,2.054960]]);
    linear_extrude(height=h)
      polygon([[129.246375,22.243050],[129.972527,15.624655],[131.718395,8.156540],[137.934775,-13.060970],[139.953008,-19.008449],[142.139196,-23.405645],[144.432226,-26.240328],[145.599710,-27.067906],[146.770986,-27.500270],[147.938417,-27.535891],[149.094362,-27.173242],[150.231183,-26.410793],[151.341241,-25.247015],[153.450510,-21.709361],[155.361055,-16.548050],[158.084727,-6.695582],[159.913215,1.238550],[161.344361,6.673444],[163.112715,10.517100],[163.877365,12.088120],[164.474616,14.361964],[164.844882,17.034041],[164.928575,19.799760],[164.566543,23.082154],[164.147037,24.185776],[163.518511,24.974052],[162.643446,25.479261],[161.484321,25.733679],[158.163815,25.619260],[150.586994,24.843551],[145.403319,24.663800],[141.177872,25.122561],[136.475735,26.262390],[132.662723,27.118489],[131.393086,27.156613],[130.475789,26.894621],[129.856649,26.302392],[129.481488,25.349803],[129.246375,22.243050]]);
    linear_extrude(height=h)
      polygon([[177.353665,23.951910],[176.641109,20.670382],[176.255049,14.496134],[176.221337,6.313323],[176.565825,-2.993890],[177.438821,-15.833729],[177.941902,-19.972582],[178.583501,-22.897693],[179.434214,-24.839286],[180.564636,-26.027587],[182.045364,-26.692823],[183.946995,-27.065220],[187.031586,-27.104589],[188.282601,-26.734048],[189.387505,-26.065249],[191.303204,-23.718552],[193.067135,-19.835850],[194.415396,-16.522803],[195.649940,-14.151564],[196.840731,-12.720902],[198.057727,-12.229586],[199.370892,-12.676386],[200.850186,-14.060070],[204.587005,-19.633170],[206.978350,-23.017722],[209.592366,-25.489589],[212.369720,-27.004889],[215.251075,-27.519740],[217.189907,-27.441257],[218.659142,-27.015936],[219.723840,-25.958970],[220.449063,-23.985549],[220.899871,-20.810865],[221.141325,-16.150112],[221.256415,-1.231160],[221.153725,13.966925],[220.909837,18.639310],[220.434896,21.771348],[219.651886,23.671108],[218.483789,24.646661],[216.853588,25.006075],[214.684265,25.057420],[211.494909,24.772765],[209.476009,23.788994],[208.840054,22.974091],[208.418202,21.911393],[208.112125,18.945250],[207.790218,15.774119],[207.293082,14.713258],[206.487600,13.948010],[205.310604,13.437734],[203.698924,13.141788],[198.918845,13.030320],[194.283729,13.356725],[191.477754,14.264601],[190.632930,15.017565],[190.092074,16.013065],[189.717845,18.861230],[189.386414,21.174595],[188.490610,23.308751],[187.166916,25.026487],[185.551815,26.090590],[182.230163,27.267753],[180.238145,27.429310],[179.515019,27.070350],[178.853424,26.386825],[177.353665,23.951860]]);
    linear_extrude(height=h)
      polygon([[-308.807795,14.293720],[-307.331119,5.828190],[-305.615876,-1.856617],[-303.688849,-8.694285],[-301.576819,-14.618394],[-299.306566,-19.562526],[-296.904872,-23.460263],[-294.398518,-26.245187],[-291.814285,-27.850880],[-289.023067,-28.786842],[-286.778146,-29.052339],[-284.919118,-28.389996],[-283.285576,-26.542435],[-281.717114,-23.252279],[-280.053325,-18.262151],[-275.798145,-2.152470],[-271.835019,14.194766],[-270.943932,19.126439],[-270.829518,22.317886],[-271.075207,23.359715],[-271.529039,24.084914],[-272.195672,24.532959],[-273.079763,24.743325],[-275.518953,24.608926],[-278.883875,23.997520],[-286.067466,22.692456],[-290.976084,22.246252],[-295.525262,22.650380],[-301.630535,23.896310],[-310.575705,25.875210],[-308.807795,14.293690]]);
    linear_extrude(height=h)
      polygon([[-262.413255,0.740540],[-262.220386,-8.980976],[-261.724958,-17.474569],[-261.002013,-23.826025],[-260.126595,-27.121130],[-258.712674,-28.647182],[-256.928598,-29.536066],[-254.928534,-29.827839],[-252.866649,-29.562563],[-250.897109,-28.780295],[-249.174080,-27.521096],[-247.851730,-25.825024],[-247.084225,-23.732140],[-246.428328,-21.495659],[-245.360199,-19.133174],[-244.027677,-16.926094],[-242.578605,-15.155830],[-240.551286,-13.660474],[-239.597544,-13.496257],[-238.608371,-13.756368],[-236.297613,-15.655639],[-233.166765,-19.570420],[-229.257920,-24.290239],[-227.548937,-25.870842],[-225.996923,-26.921401],[-224.596885,-27.434035],[-223.343829,-27.400864],[-222.232762,-26.814008],[-221.258691,-25.665585],[-220.416623,-23.947716],[-219.701565,-21.652520],[-218.632506,-15.298626],[-218.011568,-6.540861],[-217.798805,4.683820],[-217.928392,15.624982],[-218.588511,21.766449],[-219.222009,23.459732],[-220.113525,24.460014],[-221.304855,24.936268],[-222.837795,25.057470],[-225.061971,24.667810],[-226.815823,23.525466],[-228.059393,21.670392],[-228.752725,19.142540],[-229.544823,16.162379],[-230.229050,15.139811],[-231.180790,14.385881],[-232.456588,13.868315],[-234.112990,13.554835],[-238.793785,13.411030],[-243.379222,13.751222],[-246.327339,14.700907],[-247.306404,15.474404],[-248.018941,16.484387],[-248.834835,19.325960],[-249.576455,21.945657],[-250.965678,23.724291],[-253.096819,24.736638],[-256.064195,25.057470],[-258.149986,24.997426],[-259.723400,24.634491],[-260.856030,23.694456],[-261.619473,21.903115],[-262.085321,18.986260],[-262.325172,14.669684],[-262.413255,0.740540]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[235.046085,22.022460],[234.326858,20.963043],[233.684390,19.323060],[232.653325,14.463273],[232.000080,7.766851],[231.771845,-0.442450],[231.999820,-7.795597],[232.701556,-14.013076],[233.903768,-19.142737],[235.633169,-23.232431],[237.916474,-26.330009],[240.780399,-28.483321],[244.251658,-29.740218],[248.356965,-30.148550],[252.312656,-29.871540],[255.619352,-28.986154],[258.334118,-27.410859],[260.514020,-25.064124],[262.216123,-21.864415],[263.497493,-17.730200],[264.415196,-12.579945],[265.026295,-6.332120],[265.359105,1.452316],[265.132290,7.895123],[264.288115,13.105982],[262.768845,17.194573],[260.516744,20.270576],[257.474077,22.443673],[253.583109,23.823544],[248.786105,24.519870],[244.423476,24.571239],[240.405156,24.122306],[237.142306,23.247803],[235.046085,22.022460]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[251.548505,3.836880],[252.142479,1.039092],[252.312183,-2.010514],[252.112032,-5.087242],[251.596439,-7.966395],[250.819817,-10.423278],[249.836580,-12.233194],[248.701141,-13.171447],[248.093351,-13.243482],[247.467915,-13.013340],[246.391841,-11.475437],[245.615586,-8.677379],[245.141177,-5.070772],[244.970641,-1.107220],[245.106005,2.761671],[245.549294,6.084294],[246.302535,8.409046],[246.796021,9.056093],[247.367755,9.284320],[248.456137,8.854483],[249.607160,7.684134],[250.683648,5.952018],[251.548425,3.836880]]);
    }
    linear_extrude(height=h)
      polygon([[273.833575,20.643620],[274.277297,16.851964],[275.629042,11.141998],[281.180075,-6.488830],[282.924065,-13.060970],[284.108909,-17.041225],[286.399155,-22.919190],[287.819014,-25.664662],[289.416984,-27.749841],[291.121952,-29.159607],[292.862804,-29.878840],[294.568428,-29.892421],[296.167711,-29.185229],[297.589541,-27.742145],[298.762805,-25.548050],[301.970718,-15.583817],[305.864103,-1.264097],[309.160063,12.414901],[310.575705,20.456970],[310.251673,22.247098],[309.311653,23.603244],[307.884532,24.511313],[306.099196,24.957213],[304.084534,24.926848],[301.969431,24.406125],[299.882776,23.380950],[297.953455,21.837230],[296.144774,20.407873],[294.338060,19.931420],[292.244876,20.407873],[289.576785,21.837230],[286.750892,23.343328],[283.958567,24.360443],[281.305596,24.896594],[278.897765,24.959803],[276.840861,24.558089],[275.240671,23.699473],[274.202980,22.391977],[273.833575,20.643620]]);
  }
}
module AS_Slog(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-326.635640,28.567880],[-327.922895,27.619388],[-328.955480,26.341064],[-329.758988,24.596965],[-330.359012,22.251151],[-331.050984,15.210613],[-331.236142,4.131920],[-331.046149,-7.606212],[-330.737304,-11.720793],[-330.222465,-14.952105],[-329.454063,-17.514939],[-328.384528,-19.624084],[-326.966289,-21.494331],[-325.151778,-23.340470],[-320.619584,-27.214126],[-318.942101,-28.282150],[-317.624433,-28.776935],[-316.642133,-28.702955],[-315.970758,-28.064680],[-315.585859,-26.866584],[-315.462992,-25.113140],[-315.273133,-23.526642],[-314.758258,-22.352055],[-314.000417,-21.598330],[-313.081663,-21.274419],[-312.084045,-21.389272],[-311.089615,-21.951841],[-310.180424,-22.971077],[-309.438524,-24.455930],[-308.661173,-25.786405],[-307.676086,-26.260070],[-306.544175,-25.944474],[-305.326351,-24.907167],[-304.083526,-23.215696],[-302.876613,-20.937612],[-301.766523,-18.140464],[-300.814168,-14.891800],[-299.895537,-10.557327],[-299.926823,-9.277310],[-300.402692,-8.500324],[-301.411280,-8.160035],[-303.040723,-8.190106],[-308.514717,-9.095990],[-318.091850,-10.892670],[-318.091850,3.685180],[-317.957356,8.485727],[-317.575297,12.404576],[-316.977803,15.386687],[-316.197009,17.377018],[-315.265046,18.320529],[-314.214047,18.162179],[-313.076144,16.846926],[-311.883470,14.319730],[-310.840021,12.735322],[-309.221191,11.557694],[-307.240429,10.798064],[-305.111184,10.467651],[-303.046905,10.577672],[-301.261043,11.139345],[-299.967047,12.163888],[-299.378367,13.662520],[-299.294871,18.402993],[-300.060452,22.305828],[-301.719744,25.501689],[-304.317380,28.121240],[-306.481581,29.422379],[-309.064229,30.372513],[-311.945471,30.969243],[-315.005450,31.210171],[-318.124312,31.092897],[-321.182201,30.615023],[-324.059262,29.774150],[-326.635640,28.567880]]);
    linear_extrude(height=h)
      polygon([[-287.614058,29.462520],[-288.249175,26.806201],[-288.717900,20.950889],[-289.140650,3.720928],[-288.851257,-14.072082],[-288.429803,-20.631205],[-287.818668,-24.272860],[-287.300270,-24.918148],[-286.305738,-25.503284],[-283.147018,-26.480816],[-278.859997,-27.180887],[-273.962167,-27.578929],[-268.971017,-27.650374],[-264.404039,-27.370653],[-260.778722,-26.715198],[-258.612558,-25.659440],[-257.810492,-24.366294],[-257.633959,-22.851714],[-258.001531,-21.237094],[-258.831777,-19.643825],[-260.043268,-18.193303],[-261.554575,-17.006919],[-263.284268,-16.206067],[-265.150918,-15.912140],[-266.789890,-15.767072],[-268.203962,-15.356903],[-270.360773,-13.891470],[-271.628076,-11.816257],[-272.012602,-9.431682],[-271.521076,-7.038161],[-270.160227,-4.936113],[-267.936781,-3.425954],[-266.503688,-2.986713],[-264.857468,-2.808100],[-263.517186,-2.347761],[-262.803423,-1.180046],[-262.653068,0.477691],[-263.003009,2.408095],[-263.790138,4.393811],[-264.951342,6.217485],[-266.423513,7.661763],[-268.143538,8.509290],[-270.551140,9.454693],[-272.186008,10.749756],[-273.063974,12.278825],[-273.200872,13.926246],[-272.612534,15.576365],[-271.314793,17.113530],[-269.323484,18.422086],[-266.654438,19.386380],[-263.750379,20.409052],[-261.804109,21.780800],[-260.812126,23.505317],[-260.770928,25.586300],[-261.141858,26.761603],[-261.793083,27.748004],[-262.764914,28.560830],[-264.097658,29.215411],[-268.007128,30.111155],[-273.843968,30.557870],[-282.925452,30.427915],[-286.044780,30.031676],[-287.614058,29.462520]]);
    linear_extrude(height=h)
      polygon([[-150.953038,27.053740],[-151.568995,23.564298],[-151.979889,17.436137],[-152.214472,0.763256],[-151.712755,-15.965716],[-151.203274,-22.163990],[-150.530708,-25.751590],[-150.013078,-26.493198],[-149.065938,-27.131940],[-145.926818,-28.092578],[-141.200720,-28.617005],[-134.975018,-28.688720],[-127.312393,-28.350812],[-124.830744,-28.024147],[-123.099818,-27.528563],[-122.007827,-26.816224],[-121.442981,-25.839295],[-121.293491,-24.549942],[-121.447568,-22.900330],[-122.232769,-20.564580],[-123.783359,-18.536435],[-125.958949,-16.952005],[-128.619148,-15.947400],[-131.541749,-15.070978],[-133.696923,-14.014617],[-135.079037,-12.814181],[-135.682459,-11.505532],[-135.501556,-10.124532],[-134.530695,-8.707045],[-132.764244,-7.288934],[-130.196568,-5.906060],[-127.410300,-4.340945],[-125.416968,-2.593190],[-124.216926,-0.733888],[-123.810528,1.165868],[-124.198129,3.034987],[-125.380083,4.802374],[-127.356745,6.396940],[-130.128468,7.747590],[-132.997817,9.048127],[-134.992861,10.421758],[-136.116014,11.848803],[-136.369686,13.309585],[-135.756289,14.784423],[-134.278236,16.253639],[-131.937938,17.697554],[-128.737808,19.096490],[-124.760281,20.931616],[-122.259442,22.814945],[-121.548682,23.750963],[-121.190176,24.670565],[-121.178285,25.564260],[-121.507369,26.422561],[-123.165906,27.995021],[-126.120671,29.312031],[-130.326550,30.297678],[-135.738428,30.876050],[-142.490020,31.067501],[-146.877722,30.594405],[-148.371955,30.061712],[-149.499427,29.306554],[-150.334872,28.310155],[-150.953028,27.053740]]);
    linear_extrude(height=h)
      polygon([[61.778172,29.476360],[57.678793,27.950708],[56.131258,27.017167],[55.206022,26.116800],[54.761560,23.211243],[54.523054,16.818040],[54.726812,-2.655010],[55.312664,-16.656253],[56.179586,-24.629058],[56.814377,-26.826950],[57.634550,-28.084316],[58.678478,-28.590019],[59.984532,-28.532920],[61.188872,-28.110865],[62.205142,-27.286730],[63.057774,-25.978675],[63.771199,-24.104860],[64.878155,-18.332596],[65.721462,-9.315220],[66.439698,-2.313715],[67.513970,3.862847],[68.909208,9.141016],[70.590344,13.447342],[72.522310,16.708378],[74.670035,18.850673],[75.813849,19.479341],[76.998452,19.800780],[78.219461,19.805810],[79.472492,19.485250],[80.808339,19.380837],[82.264680,19.907719],[83.709799,20.908133],[85.011979,22.224318],[86.039505,23.698513],[86.660660,25.172956],[86.743728,26.489885],[86.156992,27.491540],[84.711516,28.102797],[82.129529,28.665564],[74.913684,29.535090],[67.224789,29.879046],[61.778172,29.476360]]);
    linear_extrude(height=h)
      polygon([[-247.587048,22.863520],[-247.930518,12.315226],[-247.576548,-4.739490],[-246.966676,-16.866343],[-246.555144,-20.703912],[-245.978309,-23.350722],[-245.165491,-25.026633],[-244.046010,-25.951505],[-242.549185,-26.345197],[-240.604338,-26.427570],[-237.626040,-25.999388],[-235.251833,-24.628535],[-233.336101,-22.185558],[-231.733228,-18.541000],[-230.447520,-15.478789],[-228.979168,-12.971103],[-227.509129,-11.276721],[-226.218358,-10.654420],[-225.144647,-11.276721],[-224.265332,-12.971103],[-223.671179,-15.478789],[-223.452958,-18.541000],[-223.206504,-22.361058],[-222.357604,-24.784535],[-221.655891,-25.549574],[-220.741951,-26.057888],[-218.195238,-26.427570],[-216.555623,-26.301776],[-215.296451,-25.749818],[-214.367842,-24.509839],[-213.719921,-22.319980],[-213.302806,-18.918382],[-213.066622,-14.043185],[-212.937528,1.175440],[-213.042203,17.062673],[-213.282663,21.965728],[-213.745977,25.265178],[-214.505221,27.278599],[-215.633474,28.323567],[-217.203813,28.717658],[-219.289318,28.778450],[-222.387970,28.336993],[-224.975688,26.944018],[-227.180906,24.496617],[-229.132058,20.891880],[-232.181247,15.321982],[-233.563097,13.627600],[-234.610118,13.005300],[-235.381687,13.627600],[-236.013532,15.321982],[-236.440452,17.829668],[-236.597248,20.891880],[-236.843703,24.671982],[-237.677367,27.099898],[-238.358606,27.875480],[-239.239692,28.395448],[-241.672128,28.778450],[-243.896304,28.388788],[-245.650156,27.246442],[-246.893726,25.391367],[-247.587058,22.863520]]);
    linear_extrude(height=h)
      polygon([[-186.922068,28.121240],[-187.961678,10.376440],[-189.002998,-10.062270],[-189.628276,-11.560622],[-191.127637,-13.163017],[-193.276413,-14.677506],[-195.849938,-15.912140],[-199.195649,-17.492663],[-201.363001,-19.185640],[-202.381063,-20.917363],[-202.278904,-22.614124],[-201.085593,-24.202215],[-198.830199,-25.607929],[-195.541791,-26.757557],[-191.249438,-27.577390],[-184.755012,-28.289322],[-178.956945,-28.628940],[-173.892137,-28.601621],[-169.597488,-28.212743],[-166.109897,-27.467681],[-163.466264,-26.371812],[-161.703487,-24.930513],[-160.858468,-23.149160],[-160.912083,-21.036003],[-161.882083,-19.120299],[-163.721326,-17.462031],[-166.382668,-16.121180],[-169.169437,-14.860312],[-171.385434,-13.311682],[-173.092057,-11.298810],[-174.350704,-8.645220],[-175.222774,-5.174434],[-175.769664,-0.709974],[-176.133498,11.905880],[-176.292448,20.920969],[-176.554757,23.888997],[-176.995508,26.012165],[-177.657115,27.426582],[-178.581993,28.268361],[-179.812556,28.673613],[-181.391218,28.778450],[-185.184706,28.585396],[-186.922068,28.121240]]);
    linear_extrude(height=h)
      polygon([[-109.845738,0.712980],[-109.309359,-15.714323],[-108.930963,-20.770783],[-108.365381,-24.164477],[-107.527326,-26.226924],[-106.331514,-27.289647],[-104.692656,-27.684166],[-102.525468,-27.742000],[-100.009864,-27.529569],[-98.018794,-26.951165],[-96.752841,-26.095127],[-96.412588,-25.049790],[-96.196291,-23.490875],[-95.267820,-21.236464],[-93.776224,-18.588467],[-91.870548,-15.848790],[-86.869228,-9.339990],[-86.482178,-15.254920],[-85.766498,-24.455930],[-85.198830,-25.794651],[-83.895957,-27.010510],[-82.051724,-27.969570],[-79.859978,-28.537890],[-78.092059,-28.694664],[-76.735279,-28.436301],[-75.728842,-27.523222],[-75.011948,-25.715847],[-74.523801,-22.774595],[-74.203602,-18.459889],[-73.823858,-4.751790],[-74.004547,13.923518],[-74.452040,20.627438],[-75.082528,24.304330],[-76.447152,26.761674],[-78.212436,28.267981],[-80.274405,28.855994],[-82.529083,28.558452],[-84.872493,27.408098],[-87.200660,25.437671],[-89.409607,22.679915],[-91.395358,19.167570],[-95.953328,9.556680],[-97.267758,18.510350],[-98.190147,22.834298],[-99.585009,25.732207],[-100.521795,26.729685],[-101.651311,27.470598],[-104.588018,28.315990],[-106.560319,28.534684],[-108.035474,28.342466],[-109.074186,27.420640],[-109.737159,25.450508],[-110.085097,22.113373],[-110.178704,17.090539],[-109.845738,0.712980]]);
    linear_extrude(height=h)
      polygon([[-63.092598,-0.138990],[-63.092598,-29.056430],[-56.520448,-29.056430],[-52.835772,-28.577315],[-51.512018,-27.957845],[-50.519250,-27.066808],[-49.846417,-25.890487],[-49.482465,-24.415164],[-49.636998,-20.512640],[-49.550436,-19.747090],[-49.084628,-19.120170],[-48.315618,-18.696575],[-47.319448,-18.541000],[-46.350571,-18.307638],[-45.655874,-17.672244],[-45.300052,-16.731861],[-45.347798,-15.583530],[-45.343693,-14.340131],[-44.846677,-13.140884],[-43.943009,-12.122371],[-42.718948,-11.421170],[-41.934148,-11.274610],[-41.259798,-11.454368],[-40.235286,-12.810750],[-39.631085,-15.526141],[-39.432868,-19.636360],[-39.213161,-24.342973],[-38.408841,-27.221708],[-37.719388,-28.097565],[-36.802106,-28.662787],[-34.175158,-29.056430],[-32.530613,-28.927711],[-31.269125,-28.355283],[-30.340214,-27.059742],[-29.693397,-24.761682],[-29.278192,-21.181697],[-29.044119,-16.040384],[-28.917438,0.043850],[-29.022350,16.664361],[-29.252447,21.795884],[-29.688933,25.229516],[-30.397780,27.281203],[-31.444959,28.266895],[-32.896441,28.502538],[-34.818198,28.304080],[-37.558922,27.353188],[-40.227817,25.366401],[-42.685263,22.476533],[-44.791638,18.816400],[-46.437828,15.680993],[-47.935457,13.545306],[-49.262662,12.402282],[-50.397582,12.244860],[-51.318353,13.065981],[-52.003114,14.858588],[-52.430003,17.615620],[-52.577158,21.330020],[-52.833280,24.896778],[-53.698293,27.190182],[-54.404437,27.923558],[-55.317169,28.415613],[-57.834878,28.778450],[-59.478849,28.650087],[-60.740067,28.080159],[-61.668943,26.791403],[-62.315889,24.506556],[-62.731316,20.948355],[-62.965636,15.839539],[-63.092598,-0.138990]]);
    linear_extrude(height=h)
      polygon([[-15.773148,0.617100],[-15.647486,-15.209751],[-15.412353,-20.255313],[-14.992969,-23.759808],[-14.337299,-26.001370],[-13.393305,-27.258131],[-12.108950,-27.808223],[-10.432198,-27.929780],[-8.747927,-27.819722],[-7.472426,-27.305422],[-6.559769,-26.110693],[-5.964028,-23.959347],[-5.639277,-20.575196],[-5.539590,-15.682053],[-5.831698,-0.264040],[-6.377056,14.176968],[-7.251087,22.690611],[-7.904127,25.220532],[-8.750661,26.863646],[-9.827799,27.818297],[-11.172648,28.282830],[-12.562717,28.379446],[-13.643561,27.919630],[-14.453363,26.673765],[-15.030307,24.412233],[-15.638348,15.923702],[-15.773148,0.617100]]);
    linear_extrude(height=h)
      polygon([[5.257722,22.644450],[5.836892,17.733141],[6.463812,15.788366],[7.229362,14.538800],[8.656669,12.631511],[9.319592,10.814590],[11.744632,-1.453420],[15.384937,-17.489534],[16.732042,-22.399944],[17.952697,-25.628233],[19.188586,-27.466630],[20.581394,-28.207366],[22.272808,-28.142673],[24.404512,-27.564780],[30.514842,-25.443780],[31.632758,-22.589381],[33.220152,-16.623394],[36.963596,0.462842],[40.065615,17.453929],[40.851229,23.300980],[40.846652,25.988870],[39.823502,27.286628],[38.631291,28.149264],[37.275802,28.577584],[35.762821,28.572395],[34.098133,28.134502],[32.287524,27.264712],[28.251682,24.232670],[25.399940,21.809150],[24.401037,21.203270],[23.587062,21.001310],[22.883229,21.203270],[22.214749,21.809150],[20.684702,24.232670],[19.188664,25.997711],[16.995847,27.443127],[14.401090,28.419759],[11.699232,28.778450],[8.585198,28.488992],[6.605101,27.495396],[5.978638,26.675848],[5.561692,25.609827],[5.257722,22.644450]]);
    linear_extrude(height=h)
      polygon([[160.360352,21.164210],[160.875916,17.245244],[162.494433,13.459723],[165.323640,9.623013],[169.471272,5.550480],[173.142173,1.913266],[176.402134,-2.076555],[178.896769,-5.935621],[180.271692,-9.180570],[181.062647,-13.544161],[180.942813,-14.816507],[180.433662,-15.508708],[179.500860,-15.640381],[178.110075,-15.231141],[173.817222,-12.868390],[171.451558,-11.714164],[169.088144,-11.143237],[166.823507,-11.119284],[164.754172,-11.605979],[162.976664,-12.566996],[161.587507,-13.966009],[160.683228,-15.766693],[160.360352,-17.932720],[160.629925,-20.711211],[161.463897,-23.051154],[162.900150,-24.973533],[164.976566,-26.499334],[167.731026,-27.649540],[171.201413,-28.445135],[175.425608,-28.907104],[180.441492,-29.056430],[194.213342,-29.056430],[196.067002,-16.695400],[196.707847,-11.149814],[196.732432,-7.111093],[196.135964,-4.523685],[195.603338,-3.756864],[194.913652,-3.332040],[193.746090,-2.737890],[192.789958,-1.861108],[192.143923,-0.819817],[191.906652,0.267860],[191.595502,1.587594],[190.748311,3.260728],[187.963362,6.808710],[186.159868,8.790475],[184.952178,10.556853],[184.346975,12.136969],[184.350944,13.559948],[184.970770,14.854918],[186.213135,16.051002],[188.084724,17.177328],[190.592222,18.263020],[193.144064,19.549512],[195.233802,21.205197],[196.645788,23.016564],[197.164372,24.770100],[196.978130,25.863998],[196.361524,26.750686],[195.227736,27.449077],[193.489944,27.978081],[187.855076,28.603572],[178.762362,28.778450],[160.360352,28.778450],[160.360352,21.164210]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[211.884792,23.809930],[210.680938,22.257601],[209.713154,20.463182],[208.964641,18.319916],[208.418601,15.721048],[207.866741,8.729483],[207.923182,-1.365560],[208.269679,-9.056363],[208.915945,-15.244690],[209.946351,-20.077574],[211.445272,-23.702045],[213.497079,-26.265136],[216.186147,-27.913876],[219.596847,-28.795297],[223.813552,-29.056430],[228.927396,-28.884393],[232.940651,-28.234017],[235.990959,-26.903904],[237.198022,-25.921010],[238.215963,-24.692657],[239.753306,-21.398876],[240.740630,-16.821165],[241.315577,-10.758126],[241.615792,-3.008360],[241.688774,8.089486],[241.076567,15.228182],[240.430253,17.762777],[239.512723,19.847497],[238.290671,21.662314],[236.730792,23.387200],[233.967799,25.611315],[230.832612,27.219733],[227.462363,28.210120],[223.994183,28.580143],[220.565205,28.327469],[217.312559,27.449764],[214.373378,25.944696],[211.884792,23.809930]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[228.190842,-0.173490],[227.633593,-5.956398],[226.814897,-10.125305],[225.822817,-12.672201],[225.289278,-13.334893],[224.745418,-13.589078],[224.202244,-13.433756],[223.670765,-12.867925],[222.686922,-10.500734],[221.881952,-6.479496],[221.343922,-0.796200],[221.122417,6.104332],[221.524088,10.321481],[222.003179,11.603449],[222.691541,12.430164],[223.607000,12.873493],[224.767382,13.005300],[225.921711,12.876808],[226.834017,12.447089],[227.521542,11.649776],[228.001526,10.418505],[228.407827,6.388621],[228.190842,-0.173490]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[258.213062,24.686100],[256.474832,23.334507],[255.114904,21.875097],[254.088112,20.119328],[253.349291,17.878660],[252.853274,14.964551],[252.554896,11.188462],[252.370392,0.296180],[252.545628,-7.322644],[253.130882,-13.557840],[254.215470,-18.563390],[255.888711,-22.493275],[258.239921,-25.501476],[261.358418,-27.741973],[265.333519,-29.368748],[270.254542,-30.535780],[274.507499,-31.071209],[277.902939,-30.837944],[279.311847,-30.376654],[280.545684,-29.655511],[281.617554,-28.651959],[282.540559,-27.343435],[283.992387,-23.721241],[285.005989,-18.608452],[285.686190,-11.824593],[286.137812,-3.189190],[286.492783,9.870250],[286.382128,14.200286],[286.012876,17.419125],[285.335150,19.793208],[284.299074,21.588980],[282.854770,23.072882],[280.952362,24.511360],[278.082284,26.275592],[275.220323,27.541998],[272.366373,28.310577],[269.520327,28.581331],[266.682080,28.354259],[263.851524,27.629363],[261.028553,26.406643],[258.213062,24.686100]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[272.881432,-0.173490],[272.362156,-5.457102],[271.572274,-9.492152],[270.598331,-12.224718],[269.526871,-13.600879],[268.981617,-13.763457],[268.444437,-13.566714],[267.437575,-12.068300],[266.592829,-9.051716],[265.996742,-4.463040],[265.769621,3.134737],[266.017319,6.135248],[266.504486,8.598551],[267.230092,10.520926],[268.193109,11.898654],[269.392509,12.728019],[270.827262,13.005300],[271.444742,12.775364],[271.965579,12.099281],[272.704491,9.491017],[273.018330,5.345197],[272.881432,-0.173490]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[302.318702,23.520740],[300.864941,21.895208],[299.700243,20.152578],[298.798549,18.172858],[298.133798,15.836058],[297.410888,9.611252],[297.323032,0.518230],[297.548609,-8.301794],[297.991248,-15.315505],[298.733663,-20.732605],[299.858569,-24.762797],[301.448683,-27.615781],[303.586720,-29.501261],[306.355394,-30.628936],[309.837422,-31.208510],[313.710007,-31.210171],[317.811698,-30.584122],[321.679407,-29.433599],[324.850042,-27.861840],[326.812306,-26.466835],[328.327993,-25.021087],[329.454105,-23.300064],[330.247646,-21.079235],[330.765617,-18.134070],[331.065022,-14.240037],[331.236142,-2.707240],[331.020850,5.339070],[330.345430,12.047613],[329.165567,17.500043],[327.436946,21.778017],[325.115250,24.963189],[322.156164,27.137215],[318.515374,28.381750],[314.148562,28.778450],[311.181854,28.363583],[307.962529,27.233997],[304.878756,25.562210],[302.318702,23.520740]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[318.091852,-3.142070],[317.906915,-9.106392],[317.324847,-13.015358],[316.872113,-14.246236],[316.304764,-15.019860],[315.617691,-15.355091],[314.805782,-15.270790],[313.548583,-14.137157],[312.437610,-11.811077],[311.517210,-8.608294],[310.831731,-4.844554],[310.425519,-0.835601],[310.342922,3.102821],[310.628288,6.654966],[311.325962,9.505090],[312.448566,11.661340],[313.605490,12.537814],[314.740021,12.240522],[315.795447,10.875475],[316.715056,8.548681],[317.442134,5.366153],[317.919970,1.433899],[318.091852,-3.142070]]);
    }
  }
}
module AS_Back(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    difference()
    {
       linear_extrude(height=h)
         polygon([[26.381577,135.268962],[23.519548,132.169482],[21.175794,129.179200],[19.592176,126.638719],[19.010557,124.888642],[18.432193,123.575022],[16.857440,122.222913],[14.526806,120.991421],[11.680797,120.039652],[8.834788,119.110948],[6.504153,117.942221],[4.929400,116.682997],[4.351037,115.482802],[3.922437,114.629991],[2.735517,114.404235],[0.938591,114.797224],[-1.320023,115.800652],[-4.885959,117.123881],[-9.580670,118.058813],[-14.909701,118.607806],[-20.378597,118.773212],[-25.492902,118.557388],[-29.758160,117.962688],[-32.679916,116.991468],[-33.482463,116.365399],[-33.763713,115.646082],[-33.951417,114.938718],[-34.511979,114.389518],[-36.736390,113.767187],[-40.406367,113.782244],[-45.491333,114.437842],[-51.043818,115.176451],[-54.678015,115.129788],[-55.863305,114.797604],[-56.674085,114.251850],[-57.145374,113.486776],[-57.312193,112.496632],[-57.564090,110.981696],[-57.850681,110.660121],[-58.252381,110.631188],[-59.425146,111.457395],[-61.130463,113.472602],[-63.387901,115.527025],[-66.515613,116.966961],[-70.409075,117.759180],[-74.963763,117.870452],[-80.147805,117.334408],[-81.956415,116.829505],[-83.330107,116.103476],[-84.334399,115.108914],[-85.034810,113.798415],[-85.786053,110.039982],[-85.860637,105.708169],[-85.099773,102.030123],[-83.395542,98.928445],[-80.640023,96.325737],[-76.725297,94.144600],[-71.543444,92.307636],[-64.986542,90.737447],[-56.946673,89.356632],[-39.455917,86.478621],[-27.899903,84.096682],[-25.883832,83.329798],[-23.924727,82.158118],[-22.020630,80.576956],[-20.169585,78.581627],[-16.618816,73.329725],[-13.256761,66.364930],[-10.067757,57.649757],[-7.036145,47.146724],[-4.146264,34.818347],[-1.382453,20.627142],[2.021841,0.759544],[2.919180,-5.863659],[3.296775,-10.881084],[3.167224,-14.743697],[2.543123,-17.902464],[1.437068,-20.808349],[-0.138343,-23.912318],[-2.552649,-27.968015],[-4.946139,-31.104876],[-7.344225,-33.332013],[-9.772316,-34.658540],[-12.255824,-35.093572],[-14.820159,-34.646221],[-17.490732,-33.325602],[-20.292953,-31.140828],[-23.897055,-28.491623],[-27.867025,-26.652292],[-32.029903,-25.616271],[-36.212728,-25.376998],[-40.242541,-25.927910],[-43.946379,-27.262444],[-47.151284,-29.374037],[-49.684293,-32.256128],[-51.471454,-35.475383],[-52.934985,-39.047813],[-53.923857,-42.538448],[-54.287043,-45.512318],[-54.981080,-48.540902],[-56.870783,-52.180512],[-59.667544,-55.973427],[-63.082753,-59.461928],[-66.293843,-62.686292],[-68.778605,-66.069091],[-70.531512,-69.579094],[-71.547033,-73.185073],[-71.819643,-76.855797],[-71.343811,-80.560037],[-70.114011,-84.266564],[-68.124713,-87.944148],[-66.605371,-90.883687],[-65.243440,-94.612265],[-64.187802,-98.651513],[-63.587343,-102.523058],[-62.367805,-111.330599],[-61.459533,-115.094698],[-60.324418,-118.452071],[-58.941578,-121.417509],[-57.290131,-124.005804],[-55.349196,-126.231745],[-53.097891,-128.110124],[-50.515335,-129.655733],[-47.580645,-130.883362],[-44.272942,-131.807803],[-40.571342,-132.443846],[-31.902929,-132.909905],[-21.408353,-132.399868],[-10.145422,-131.735309],[-1.693165,-132.058510],[1.944166,-132.644460],[5.437073,-133.542078],[12.733947,-136.358618],[18.510392,-138.726044],[23.846880,-140.426640],[28.779848,-141.460694],[33.345733,-141.828494],[37.580972,-141.530328],[41.522001,-140.566485],[45.205257,-138.937252],[48.667177,-136.642918],[57.078398,-131.023399],[67.482317,-125.181018],[72.758981,-122.208282],[76.948833,-119.043991],[80.169654,-115.396798],[82.539225,-110.975362],[84.175329,-105.488336],[85.195744,-98.644376],[85.718253,-90.152138],[85.860637,-79.720278],[85.699970,-64.948391],[85.370259,-60.213331],[84.750492,-56.799932],[83.747812,-54.373997],[82.269364,-52.601330],[80.222294,-51.147736],[77.513747,-49.679018],[73.870412,-48.054692],[70.901182,-47.273334],[68.704879,-47.348455],[67.927457,-47.711418],[67.380327,-48.293568],[66.116542,-49.959261],[64.842667,-50.888452],[63.562241,-51.083627],[62.278805,-50.547272],[60.995900,-49.281870],[59.717064,-47.289909],[57.185767,-41.136248],[55.434320,-36.638234],[53.124353,-31.841504],[50.556275,-27.319913],[48.030497,-23.647318],[46.492098,-21.313838],[45.080162,-18.337219],[43.769732,-14.613044],[42.535849,-10.036897],[40.197895,2.088982],[37.866637,18.875752],[35.841957,33.477415],[33.533627,47.278037],[31.225919,58.722909],[29.203107,66.257322],[26.841678,73.469642],[25.400991,79.499897],[24.972136,84.673354],[25.646203,89.315285],[27.514281,93.750956],[30.667462,98.305639],[35.196833,103.304601],[41.193487,109.073112],[49.426111,117.064202],[52.229914,120.196454],[54.274904,122.929962],[55.648227,125.397316],[56.437029,127.731105],[56.728453,130.063917],[56.609647,132.528342],[55.746675,136.917422],[55.004903,138.421425],[53.940033,139.554951],[52.464886,140.385411],[50.492281,140.980215],[44.705977,141.732502],[39.049999,141.828494],[36.671888,141.512422],[34.497077,140.919558],[32.453103,140.024342],[30.467504,138.801212],[26.381577,135.268972]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[8.797007,74.764112],[10.722203,70.565593],[12.661854,65.450401],[16.477772,53.051293],[20.031255,38.729374],[23.108799,23.647231],[25.496902,8.967449],[26.982058,-4.147386],[27.350764,-14.534687],[27.049729,-18.342204],[26.389517,-21.031868],[25.149219,-23.782007],[24.661557,-24.446070],[24.205078,-24.628575],[23.214237,-23.526257],[21.833837,-20.429738],[20.881375,-17.079599],[20.070435,-12.292647],[19.486894,-6.707625],[19.216627,-0.963278],[18.807439,6.205477],[17.834225,15.034944],[14.603117,35.456997],[10.338096,55.864846],[8.072491,64.676556],[5.853957,71.820452],[3.322513,79.941233],[2.912807,82.194627],[3.052863,83.222440],[3.726996,83.008983],[4.919522,81.538568],[8.797007,74.764112]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-19.904223,-62.942348],[-16.911192,-64.916844],[-13.523935,-66.541480],[-9.985564,-67.774559],[-6.539193,-68.574385],[-3.427936,-68.899262],[-0.894904,-68.707492],[0.816788,-67.957379],[1.288658,-67.359915],[1.464027,-66.607228],[2.291178,-63.796612],[4.216937,-60.127028],[5.828069,-58.094888],[6.620613,-57.632362],[7.481294,-57.547835],[9.637519,-58.539689],[12.757647,-61.124268],[15.210202,-62.822950],[18.035609,-63.957994],[21.018158,-64.545132],[23.942138,-64.600097],[26.591840,-64.138620],[28.751554,-63.176435],[30.205569,-61.729274],[30.738177,-59.812868],[30.969521,-58.751179],[31.599420,-57.881748],[32.531673,-57.294294],[33.670077,-57.078538],[34.259035,-57.294467],[34.808481,-57.913327],[35.740733,-60.186269],[36.370632,-63.550223],[36.601977,-67.658048],[36.798782,-73.277462],[37.126170,-75.056991],[37.678553,-76.247164],[38.510186,-76.921055],[39.675323,-77.151736],[43.223127,-76.575758],[46.128393,-76.137181],[49.144217,-76.171505],[51.914280,-76.647314],[54.082267,-77.533188],[56.131052,-79.158114],[56.653020,-80.029141],[56.841933,-81.029309],[56.226276,-83.687361],[54.295447,-87.672858],[52.416009,-90.592903],[50.273992,-92.984168],[48.133152,-94.599888],[46.257247,-95.193298],[44.580717,-95.706158],[43.484912,-97.222883],[42.982912,-99.710693],[43.087797,-103.136808],[43.296466,-107.602793],[42.902715,-108.978314],[42.003075,-109.883160],[40.467175,-110.393064],[38.164641,-110.583754],[30.738177,-110.310418],[24.679464,-109.615114],[19.637373,-108.299345],[15.630337,-106.369720],[12.676787,-103.832848],[10.109905,-101.415201],[7.203977,-99.696604],[4.070317,-98.676196],[0.820237,-98.353117],[-2.434949,-98.726506],[-5.583926,-99.795503],[-8.515382,-101.559247],[-11.118003,-104.016878],[-13.973052,-106.953285],[-15.213857,-107.786898],[-16.437302,-108.217675],[-17.723724,-108.260786],[-19.153461,-107.931400],[-22.764233,-106.215808],[-28.193295,-102.697561],[-30.040430,-101.058590],[-31.312886,-99.494160],[-32.013354,-98.000102],[-32.144523,-96.572246],[-31.709083,-95.206421],[-30.709723,-93.898458],[-29.493102,-92.033307],[-28.637576,-89.374186],[-28.141002,-86.131929],[-28.001236,-82.517372],[-28.216135,-78.741348],[-28.783555,-75.014693],[-29.701352,-71.548241],[-30.967383,-68.552828],[-31.842633,-66.548066],[-32.364893,-64.538659],[-32.549104,-62.608425],[-32.410205,-60.841184],[-31.963134,-59.320756],[-31.222833,-58.130959],[-30.204239,-57.355613],[-28.922293,-57.078538],[-25.628318,-58.801034],[-19.904223,-62.942348]]);
    }
  }
}
module AZ_Stat(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    difference()
    {
       linear_extrude(height=h)
         polygon([[46.436976,32.425165],[36.656603,30.864619],[32.682403,29.805988],[29.111601,28.471175],[25.788750,26.792223],[22.558406,24.701174],[15.753456,19.010955],[12.865039,15.928917],[11.899636,14.406173],[11.199863,12.729971],[10.436484,8.420263],[10.253456,2.005935],[10.487380,-3.387423],[11.212404,-8.183290],[12.463407,-12.440646],[14.275268,-16.218470],[16.682867,-19.575743],[19.721082,-22.571445],[23.424792,-25.264556],[27.828876,-27.714055],[33.578985,-30.158239],[36.485467,-30.973289],[39.743611,-31.562905],[48.307015,-32.203621],[61.253456,-32.355955],[74.217884,-32.203838],[82.783688,-31.561004],[86.043674,-30.968155],[88.955886,-30.147730],[94.739496,-27.684295],[99.431597,-25.115720],[103.354155,-22.380589],[106.548512,-19.413711],[109.056016,-16.149894],[110.918009,-12.523944],[112.175837,-8.470669],[112.870844,-3.924877],[113.044376,1.178625],[112.755834,7.400343],[111.878333,11.789592],[110.090314,15.299335],[107.070216,18.882535],[103.745515,22.239539],[100.659410,24.892684],[97.438689,26.975910],[93.710141,28.623159],[89.100555,29.968370],[83.236720,31.145486],[66.253456,33.531195],[58.369863,33.466092],[46.436976,32.425165]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[70.455016,12.381345],[76.182888,10.031245],[78.311153,8.738753],[79.987561,7.328895],[81.241053,5.772369],[82.100571,4.039872],[82.595058,2.102102],[82.753456,-0.070245],[82.489447,-2.511345],[81.728272,-4.764273],[80.516203,-6.817095],[78.899515,-8.657876],[76.924482,-10.274680],[74.637379,-11.655572],[72.084480,-12.788618],[69.312058,-13.661882],[66.366389,-14.263430],[63.293746,-14.581325],[60.140403,-14.603634],[56.952635,-14.318421],[53.776717,-13.713750],[50.658921,-12.777687],[47.645523,-11.498297],[44.782796,-9.863645],[42.278660,-7.611943],[40.711025,-4.882799],[40.045622,-1.849966],[40.248186,1.312802],[41.284450,4.431753],[43.120147,7.333133],[45.721011,9.843188],[49.052776,11.788165],[54.421550,13.702784],[59.376856,14.428730],[64.520682,13.982688],[70.455016,12.381345]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[-314.413200,31.310715],[-315.235502,30.145474],[-315.605490,28.715363],[-315.510644,26.985948],[-314.938441,24.922791],[-312.311882,19.657514],[-307.625644,12.644045],[-287.873444,-15.555685],[-276.047184,-32.755415],[-262.405644,-32.555695],[-248.764104,-32.355975],[-233.187824,-10.355975],[-214.929004,14.874965],[-210.057324,21.874965],[-209.485587,22.520519],[-209.011429,22.258664],[-208.326689,18.692161],[-207.944777,10.534325],[-207.807364,-2.855975],[-207.671522,-18.154303],[-207.189484,-26.779906],[-206.745183,-29.183533],[-206.126181,-30.630696],[-205.303096,-31.358634],[-204.246544,-31.604585],[-188.002384,-31.798911],[-164.053069,-31.264705],[-141.734457,-30.303674],[-134.104119,-29.757383],[-130.382404,-29.217525],[-127.626889,-27.958237],[-125.156930,-26.399932],[-122.997755,-24.575734],[-121.174589,-22.518766],[-119.712659,-20.262153],[-118.637190,-17.839018],[-117.973410,-15.282484],[-117.746544,-12.625675],[-118.034218,-9.775820],[-118.833450,-6.830111],[-120.048558,-3.935209],[-121.583859,-1.237775],[-123.343671,1.115529],[-125.232311,2.978041],[-127.154096,4.203100],[-129.013344,4.644045],[-129.414876,4.813102],[-129.409846,5.297625],[-128.289124,7.077175],[-125.869222,9.710907],[-122.368184,12.927035],[-115.151154,19.428140],[-111.310804,23.427035],[-111.010877,23.280492],[-110.708808,21.999579],[-110.131059,16.474050],[-109.310804,-3.355955],[-108.746544,-32.355955],[-94.246544,-32.943575],[-79.746544,-33.531195],[-79.746544,-10.443575],[-79.272979,5.862056],[-78.760369,10.822287],[-78.458250,12.172823],[-78.134404,12.644045],[-76.026917,11.618264],[-71.480459,8.825295],[-57.746544,-0.355955],[-38.970824,-13.355955],[-55.468264,-13.355955],[-71.965704,-13.355955],[-71.356124,-22.555965],[-70.746544,-31.755975],[-33.246544,-31.651195],[6.253456,-31.451185],[7.030018,-30.802658],[7.665956,-29.107294],[8.095643,-26.622515],[8.253456,-23.605745],[7.918605,-19.034902],[7.262329,-17.213902],[6.068853,-15.452197],[4.179703,-13.562051],[1.436403,-11.355724],[-7.246544,-5.243575],[-19.925419,3.673486],[-28.642704,10.210445],[-34.538864,15.052495],[-12.642704,14.355185],[9.253456,13.657865],[9.253456,22.650955],[9.253456,31.644055],[-66.256044,32.033895],[-141.765544,32.423745],[-152.901644,22.678785],[-161.557171,15.823092],[-165.417767,13.294461],[-168.857717,11.417741],[-171.795118,10.232260],[-174.148071,9.777343],[-175.834673,10.092316],[-176.773024,11.216505],[-177.535732,15.574706],[-178.182444,22.644045],[-178.746544,31.644045],[-208.359224,32.109785],[-237.971924,32.575515],[-241.359224,26.622425],[-243.592601,23.222675],[-244.845048,22.165866],[-246.485027,21.449241],[-248.735308,21.006406],[-251.818661,20.770967],[-261.375664,20.656695],[-270.840433,20.773808],[-273.995236,21.020899],[-276.400319,21.477091],[-278.282181,22.204944],[-279.867323,23.267014],[-283.053444,26.644045],[-286.135410,29.896411],[-287.619967,30.953801],[-289.270657,31.701704],[-293.681688,32.478167],[-300.591004,32.644045],[-309.802937,32.252379],[-312.910049,31.828421],[-314.413200,31.310715]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-261.023284,-2.355955],[-262.004374,-4.474705],[-262.746544,-5.355955],[-263.488714,-4.474705],[-264.469804,-2.355955],[-264.737150,-1.123991],[-264.518472,-0.177542],[-263.844645,0.429700],[-262.746544,0.644045],[-261.648385,0.429700],[-260.974564,-0.177542],[-260.755919,-1.123991],[-261.023284,-2.355955]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-149.746544,-11.355955],[-150.004356,-11.765812],[-150.746543,-12.144419],[-153.496542,-12.779034],[-157.621541,-13.202110],[-162.746544,-13.355955],[-167.871547,-13.202110],[-171.996547,-12.779034],[-174.746545,-12.144419],[-175.488732,-11.765812],[-175.746544,-11.355955],[-175.488732,-10.946098],[-174.746545,-10.567491],[-171.996547,-9.932876],[-167.871547,-9.509800],[-162.746544,-9.355955],[-157.621541,-9.509800],[-153.496542,-9.932876],[-150.746543,-10.567491],[-150.004356,-10.946098],[-149.746544,-11.355955]]);
    }
    linear_extrude(height=h)
      polygon([[120.967976,30.182135],[120.497230,26.955445],[120.182247,19.906065],[119.996738,-0.566014],[120.365783,-21.044601],[120.743992,-28.102116],[121.243716,-31.340195],[122.480006,-31.788207],[125.304378,-32.131433],[134.038096,-32.368555],[138.355638,-32.277715],[141.838677,-31.988714],[144.870345,-31.286395],[147.833776,-29.955599],[151.112101,-27.781166],[155.088455,-24.547939],[166.667776,-14.044465],[173.929311,-7.908205],[176.615099,-6.041533],[178.167776,-5.355955],[178.610562,-5.596062],[179.012603,-6.293339],[179.671896,-8.921146],[180.100548,-12.962863],[180.253456,-18.141975],[180.596278,-26.447090],[181.200934,-29.130701],[182.250981,-31.018236],[183.863837,-32.247113],[186.156921,-32.954747],[189.247655,-33.278556],[193.253456,-33.355955],[197.630886,-33.321621],[200.896057,-32.932755],[202.162459,-32.471375],[203.211894,-31.760565],[204.064727,-30.746725],[204.741323,-29.376256],[205.647269,-25.351037],[206.092656,-19.256112],[206.253456,0.858025],[206.253456,32.644045],[192.753456,32.626645],[185.192685,32.445558],[182.486708,32.138624],[180.248753,31.607809],[178.292637,30.793395],[176.432172,29.635668],[172.253456,26.051405],[155.971576,11.015095],[146.689696,2.536665],[147.352196,16.046085],[147.489291,22.015883],[147.246556,26.527712],[146.627111,29.554486],[145.634076,31.069115],[143.514411,31.859078],[140.356833,32.364233],[132.453136,32.574970],[124.973383,31.811022],[122.345736,31.097821],[120.967976,30.182085]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[208.986176,29.668725],[208.794564,28.156591],[209.273888,26.021973],[210.544124,23.059550],[212.725248,19.063998],[220.300067,7.152216],[232.958156,-11.355955],[247.537856,-32.355955],[261.330436,-32.355955],[275.122996,-32.355955],[292.715796,-8.355955],[302.254733,4.760776],[309.182145,14.735211],[313.578829,21.996822],[314.853399,24.744529],[315.525586,26.975081],[315.605490,28.742164],[315.103212,30.099461],[314.028851,31.100656],[312.392507,31.799434],[307.474269,32.504471],[300.429296,32.644045],[292.529738,32.515759],[289.911058,32.262884],[287.940001,31.801949],[286.436731,31.071276],[285.221416,30.009187],[282.935316,26.644045],[280.602387,23.199625],[279.300298,22.134232],[277.587413,21.415671],[275.223449,20.975657],[271.968121,20.745905],[261.822236,20.644045],[249.414288,21.120764],[245.639744,21.636789],[244.612038,21.940921],[244.253456,22.266925],[243.055568,24.698860],[240.175536,28.266925],[237.597199,30.484210],[234.417693,31.818471],[229.851419,32.471240],[223.112776,32.644045],[216.954033,32.490075],[212.749176,31.985514],[210.194468,31.066389],[209.441004,30.431372],[208.986176,29.668725]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[264.253456,-1.237925],[264.098736,-2.374289],[263.680778,-3.257938],[263.068880,-3.872652],[262.332343,-4.202209],[261.540466,-4.230389],[260.762550,-3.940972],[260.067893,-3.317738],[259.525796,-2.344465],[259.260737,-1.111672],[259.490623,-0.169465],[260.185701,0.432370],[261.316216,0.644045],[262.456690,0.495547],[263.390641,0.091219],[264.021689,-0.507189],[264.253456,-1.237925]]);
    }
  }
}
module AZ_Slog(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-214.690020,16.628006],[-216.507341,13.999235],[-217.681243,10.619323],[-218.312028,6.046247],[-218.500000,-0.162014],[-218.311671,-5.572504],[-217.717603,-10.067478],[-216.674179,-13.706768],[-215.137778,-16.550204],[-213.064780,-18.657617],[-210.411568,-20.088836],[-207.134521,-20.903691],[-203.190020,-21.162014],[-199.141254,-21.006947],[-196.814165,-20.354947],[-196.153670,-19.755035],[-195.752499,-18.925815],[-195.500000,-16.439354],[-195.691823,-14.066666],[-196.429152,-12.769919],[-197.954781,-12.366731],[-200.511500,-12.674714],[-203.089477,-12.942094],[-205.322712,-12.692438],[-207.211517,-11.925397],[-208.756202,-10.640619],[-209.957082,-8.837755],[-210.814467,-6.516453],[-211.328669,-3.676363],[-211.500000,-0.317134],[-211.012129,5.302918],[-210.411805,7.558317],[-209.582345,9.428928],[-208.530092,10.903477],[-207.261388,11.970687],[-205.782577,12.619282],[-204.100000,12.837986],[-202.929939,12.520997],[-202.122670,11.673283],[-201.671092,10.449716],[-201.568103,9.005173],[-201.806601,7.494528],[-202.379484,6.072655],[-203.279651,4.894429],[-204.500000,4.114726],[-206.230677,3.189769],[-207.280928,2.078053],[-207.690154,0.875151],[-207.497757,-0.323362],[-206.743142,-1.421910],[-205.465708,-2.324918],[-203.704860,-2.936811],[-201.500000,-3.162014],[-198.031250,-2.974514],[-196.964844,-2.529202],[-196.250000,-1.662014],[-195.816406,-0.232327],[-195.593750,1.900486],[-195.500000,8.837986],[-195.500000,20.837986],[-203.190020,20.837986],[-206.845789,20.586504],[-209.938645,19.816536],[-212.532189,18.504797],[-214.690020,16.628006]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[-191.500000,-0.162014],[-191.500000,-21.162014],[-183.900000,-21.162014],[-180.759687,-20.972639],[-177.827500,-20.457014],[-175.431562,-19.693889],[-173.900000,-18.762014],[-172.943452,-17.329700],[-172.232326,-15.317993],[-171.568400,-10.338774],[-171.952344,-5.389106],[-172.551055,-3.414336],[-173.428280,-2.033734],[-174.072106,-0.618269],[-174.150725,1.720898],[-173.669671,4.907749],[-172.634480,8.866266],[-170.828924,14.037683],[-170.093273,15.107183],[-169.386123,15.100723],[-168.645283,13.969438],[-167.808565,11.664464],[-165.598740,3.337986],[-162.153408,-10.256056],[-159.877300,-17.592829],[-158.936926,-19.513759],[-157.999922,-20.589195],[-156.969977,-21.058744],[-155.750780,-21.162014],[-154.719802,-20.956875],[-153.745789,-20.281282],[-152.788203,-19.044969],[-151.806508,-17.157672],[-149.608637,-11.069068],[-146.827880,-1.293354],[-143.249070,12.148846],[-141.915313,18.647141],[-142.035658,20.075603],[-142.651663,20.708023],[-145.283180,20.837986],[-146.958708,20.496732],[-148.395533,19.511308],[-149.535705,17.939223],[-150.321280,15.837986],[-151.121572,13.683836],[-152.281668,12.117631],[-153.778149,11.161602],[-155.587600,10.837986],[-157.377671,11.191800],[-159.024903,12.198158],[-160.431583,13.774430],[-161.500000,15.837986],[-162.742679,18.311410],[-164.408370,19.842141],[-166.834846,20.620794],[-170.359880,20.837986],[-174.172269,20.645229],[-175.461329,20.311987],[-176.435660,19.738793],[-177.167782,18.864117],[-177.730216,17.626428],[-178.636100,13.815886],[-180.188399,8.072945],[-181.000396,6.541692],[-181.772330,5.918328],[-182.456229,6.213663],[-183.004121,7.438505],[-183.368035,9.603663],[-183.500000,12.719946],[-183.654888,16.850685],[-184.246368,19.323228],[-184.765274,20.058322],[-185.464663,20.523640],[-187.500000,20.837986],[-188.747398,20.742282],[-189.705361,20.322360],[-190.411834,19.378999],[-190.904765,17.712983],[-191.401787,11.416108],[-191.500000,-0.162014]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-153.530620,0.337986],[-154.121440,-2.308889],[-155.500000,-5.162014],[-156.441709,-6.360325],[-157.042270,-6.395872],[-157.364041,-5.189490],[-157.469380,-2.662014],[-157.323102,-0.526467],[-156.903190,1.222361],[-156.274028,2.404001],[-155.500000,2.837986],[-154.725854,2.640720],[-154.096495,2.103611],[-153.676544,1.308689],[-153.530620,0.337986]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-178.832860,-10.308234],[-179.550956,-11.784784],[-180.322589,-12.706920],[-181.101748,-13.098215],[-181.842420,-12.982242],[-182.498593,-12.382574],[-183.024256,-11.322785],[-183.500000,-7.917134],[-183.385019,-5.362455],[-182.953290,-4.121227],[-182.074636,-4.064507],[-180.618880,-5.063354],[-179.586604,-6.216964],[-178.905775,-7.590379],[-178.634993,-9.011502],[-178.832860,-10.308234]]);
    }
    linear_extrude(height=h)
      polygon([[-139.500000,-0.162014],[-139.398066,-11.611743],[-138.908730,-17.922884],[-138.432756,-19.622782],[-137.756694,-20.603591],[-136.846133,-21.053828],[-135.666660,-21.162014],[-134.629150,-21.020839],[-133.653019,-20.575307],[-131.794847,-18.639129],[-129.912057,-15.089394],[-127.824560,-9.662014],[-123.815780,1.837986],[-123.657980,-9.662014],[-123.444459,-15.725750],[-122.846200,-19.204779],[-122.325029,-20.190130],[-121.614356,-20.787426],[-119.500080,-21.162014],[-118.252205,-21.066039],[-117.294019,-20.644215],[-116.587517,-19.695693],[-116.094692,-18.019624],[-115.598060,-11.681454],[-115.500080,-0.022914],[-115.585405,11.921686],[-116.086977,18.152336],[-116.608981,19.672218],[-117.373197,20.420361],[-118.425673,20.615678],[-119.812460,20.477086],[-120.977218,20.164023],[-122.077838,19.558753],[-124.184850,17.332106],[-126.329872,13.518173],[-128.709280,7.837986],[-133.293700,-4.162014],[-133.396900,8.337986],[-133.587242,14.396764],[-134.102778,18.237456],[-135.041175,20.253412],[-135.699467,20.700037],[-136.500100,20.837986],[-137.339946,20.646580],[-138.013497,19.994237],[-138.537493,18.763769],[-138.928675,16.837988],[-139.379566,10.431738],[-139.500100,-0.162014]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[-111.500000,-0.162014],[-111.500000,-21.162014],[-104.409100,-21.162014],[-100.462014,-20.831054],[-97.034856,-19.839792],[-94.129583,-18.190659],[-91.748153,-15.886087],[-89.892522,-12.928506],[-88.564648,-9.320346],[-87.766488,-5.064039],[-87.500000,-0.162014],[-87.766488,4.740010],[-88.564648,8.996317],[-89.892522,12.604477],[-91.748153,15.562058],[-94.129583,17.866630],[-97.034856,19.515763],[-100.462014,20.507025],[-104.409100,20.837986],[-111.500000,20.837986],[-111.500000,-0.162014]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-97.900000,10.437986],[-96.879977,8.762031],[-96.151390,6.251181],[-95.714238,3.183733],[-95.568520,-0.162014],[-95.714238,-3.507761],[-96.151390,-6.575209],[-96.879977,-9.086060],[-97.900000,-10.762014],[-99.811802,-12.434105],[-101.416832,-13.294477],[-102.731075,-13.320834],[-103.770517,-12.490879],[-104.551145,-10.782317],[-105.088944,-8.172849],[-105.500000,-0.162014],[-105.088944,7.848821],[-104.551145,10.458288],[-103.770517,12.166851],[-102.731075,12.996805],[-101.416832,12.970448],[-99.811802,12.110076],[-97.900000,10.437986]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[-62.700600,19.357886],[-64.098520,18.162363],[-65.345555,16.637395],[-67.374883,12.765564],[-68.764407,8.075282],[-69.489947,2.899438],[-69.527329,-2.429079],[-68.852373,-7.577379],[-67.440902,-12.212574],[-66.451419,-14.233729],[-65.268740,-16.001774],[-62.931650,-18.564418],[-60.611795,-20.119657],[-57.999508,-20.808379],[-54.785120,-20.771474],[-51.882056,-20.202380],[-49.683199,-19.226721],[-48.221269,-17.993194],[-47.528985,-16.650499],[-47.639068,-15.347335],[-48.584238,-14.232401],[-50.397215,-13.454394],[-53.110720,-13.162014],[-55.801159,-12.766843],[-58.136190,-11.641572],[-60.071512,-9.876565],[-61.562823,-7.562187],[-62.565821,-4.788802],[-63.036204,-1.646776],[-62.929671,1.773528],[-62.201920,5.381746],[-60.986425,8.673078],[-59.351818,10.802046],[-56.884481,12.115793],[-53.170800,12.961466],[-45.978200,14.130586],[-43.671720,3.824146],[-40.637265,-9.015946],[-38.306865,-16.612049],[-37.247532,-18.841240],[-36.174428,-20.236595],[-35.024291,-20.957169],[-33.733860,-21.162014],[-32.709273,-20.955062],[-31.738882,-20.275066],[-30.782923,-19.033314],[-29.801633,-17.141097],[-27.604002,-11.050422],[-24.827880,-1.293354],[-21.249070,12.148846],[-19.915313,18.647141],[-20.035658,20.075603],[-20.651663,20.708023],[-23.283180,20.837986],[-24.958708,20.496732],[-26.395533,19.511308],[-27.535705,17.939223],[-28.321280,15.837986],[-29.264782,13.606808],[-30.706415,11.979847],[-32.468391,10.964804],[-34.372925,10.569383],[-36.242229,10.801288],[-37.898518,11.668221],[-39.164003,13.177886],[-39.860900,15.337986],[-40.539036,17.702917],[-41.187205,18.519987],[-42.140805,19.140343],[-45.262396,19.931566],[-50.500000,20.357886],[-58.208923,20.278621],[-61.057082,19.907036],[-62.700600,19.357886]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-31.640580,1.337986],[-33.500000,-4.162014],[-34.415584,-6.108337],[-34.954170,-6.568832],[-35.230526,-5.450918],[-35.359420,-2.662014],[-35.256226,-0.526467],[-34.871235,1.222361],[-34.265481,2.404001],[-33.500000,2.837986],[-32.128795,2.397361],[-31.743808,1.920408],[-31.640580,1.337986]]);
    }
    linear_extrude(height=h)
      polygon([[-17.500000,-0.162014],[-17.398066,-11.611743],[-16.908730,-17.922884],[-16.432756,-19.622782],[-15.756694,-20.603591],[-14.846133,-21.053828],[-13.666660,-21.162014],[-12.629150,-21.020839],[-11.653019,-20.575307],[-9.794847,-18.639129],[-7.912057,-15.089394],[-5.824560,-9.662014],[-1.815780,1.837986],[-1.657980,-9.808654],[-1.450722,-15.810302],[-0.901868,-19.250037],[-0.438459,-20.191805],[0.183406,-20.712236],[0.988082,-20.884377],[1.999920,-20.781274],[3.027338,-20.440174],[3.835488,-19.758349],[4.449731,-18.586201],[4.895425,-16.774129],[5.382609,-10.631817],[5.499920,-0.134614],[5.399689,10.843762],[4.899990,16.836271],[4.407055,18.429566],[3.702311,19.336486],[2.748444,19.743727],[1.508140,19.837986],[0.408000,19.699389],[-0.618587,19.255653],[-2.568207,17.285098],[-4.574929,13.590987],[-6.872960,7.837986],[-11.262300,-4.162014],[-11.381300,8.337986],[-11.579390,14.393820],[-12.100147,18.234838],[-13.041201,20.252430],[-13.699848,20.699751],[-14.500180,20.837986],[-15.340026,20.646580],[-16.013577,19.994237],[-16.537573,18.763769],[-16.928755,16.837988],[-17.379646,10.431738],[-17.500180,-0.162014]]);
    linear_extrude(height=h)
      polygon([[17.833340,19.504646],[17.315628,18.387839],[16.891668,16.332656],[16.500000,10.578686],[16.184375,6.829867],[15.325000,2.235398],[14.053125,-2.622602],[12.500000,-7.162014],[9.762139,-14.501654],[8.734485,-18.741694],[8.845756,-19.952414],[9.365103,-20.691894],[10.286035,-21.061354],[11.602060,-21.162014],[13.053258,-20.571498],[14.711410,-18.963654],[16.372128,-16.584046],[17.831020,-13.678234],[20.957960,-6.194454],[23.942880,-13.678234],[25.321717,-16.584046],[26.869408,-18.963654],[28.396589,-20.571498],[29.713900,-21.162014],[30.951939,-20.968173],[31.798523,-20.363488],[32.250838,-19.313216],[32.306075,-17.782612],[31.214065,-13.141437],[28.500000,-6.162014],[26.946875,-1.841645],[25.675000,3.023488],[24.815625,7.837325],[24.500000,12.003806],[24.010392,17.247457],[23.425734,19.078465],[22.638823,20.354906],[21.667892,21.056261],[20.531177,21.162014],[19.246915,20.651648],[17.833340,19.504646]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[39.309980,16.628006],[37.492659,13.999235],[36.318758,10.619323],[35.687972,6.046247],[35.500000,-0.162014],[35.691877,-5.211073],[36.273936,-9.536397],[37.255817,-13.153558],[38.647163,-16.078132],[40.457612,-18.325691],[42.696808,-19.911808],[45.374390,-20.852058],[48.500000,-21.162014],[51.625610,-20.852058],[54.303192,-19.911808],[56.542388,-18.325691],[58.352837,-16.078132],[59.744183,-13.153558],[60.726064,-9.536397],[61.308123,-5.211073],[61.500000,-0.162014],[61.308123,4.887044],[60.726064,9.212368],[59.744183,12.829530],[58.352837,15.754103],[56.542388,18.001662],[54.303192,19.587780],[51.625610,20.528030],[48.500000,20.837986],[46.110400,20.505793],[43.581163,19.601308],[41.213839,18.262667],[39.309980,16.628006]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[53.286020,9.674406],[54.143397,5.479983],[54.500000,-0.162014],[54.156278,-6.052813],[53.083408,-10.092724],[52.253993,-11.460951],[51.218833,-12.417281],[49.970109,-12.978655],[48.500000,-13.162014],[47.029891,-12.978655],[45.781167,-12.417281],[44.746007,-11.460951],[43.916593,-10.092724],[42.843722,-6.052813],[42.500000,-0.162014],[42.843722,5.728784],[43.916592,9.768696],[44.746007,11.136922],[45.781167,12.093252],[47.029891,12.654626],[48.500000,12.837986],[49.982747,12.588361],[51.379362,11.908688],[52.532802,10.902769],[53.286020,9.674406]]);
    }
    linear_extrude(height=h)
      polygon([[65.354380,18.179706],[65.004294,15.739719],[64.805162,11.061286],[64.917160,-2.320294],[65.347896,-11.967347],[66.057605,-17.416604],[66.616587,-18.959666],[67.364727,-19.924407],[68.341830,-20.467869],[69.587700,-20.747094],[70.776124,-20.799967],[71.825948,-20.547765],[72.785199,-19.921186],[73.701902,-18.850929],[75.599776,-15.102176],[77.903780,-8.747094],[82.132160,3.837986],[82.316160,-8.662014],[82.546567,-14.705656],[83.088955,-18.548029],[84.040926,-20.572395],[84.701005,-21.022594],[85.500080,-21.162014],[86.339926,-20.970608],[87.013477,-20.318265],[87.537473,-19.087797],[87.928655,-17.162017],[88.379546,-10.755767],[88.500080,-0.162014],[88.398146,11.287714],[87.908810,17.598856],[87.432836,19.298754],[86.756774,20.279562],[85.846213,20.729800],[84.666740,20.837986],[83.629230,20.696811],[82.653099,20.251279],[80.794927,18.315101],[78.912137,14.765365],[76.824640,9.337986],[72.815860,-2.162014],[72.658060,9.337986],[72.437367,14.900053],[71.893108,18.434823],[70.926159,20.296175],[70.253201,20.709905],[69.437400,20.837986],[68.167684,20.628232],[66.974658,20.057118],[65.992287,19.211868],[65.354540,18.179706]]);
    linear_extrude(height=h)
      polygon([[108.500000,16.115326],[108.691611,13.769951],[109.408093,12.466181],[110.861918,12.034067],[113.265560,12.303666],[115.745103,12.571728],[117.581490,12.340288],[118.766779,11.660786],[119.293030,10.584663],[119.152302,9.163359],[118.336655,7.448315],[116.838148,5.490970],[114.648840,3.342766],[111.699483,0.408133],[109.806775,-2.426602],[108.797889,-5.514188],[108.500000,-9.207374],[108.639668,-12.192959],[109.071719,-14.707479],[109.815723,-16.773430],[110.891250,-18.413309],[112.317871,-19.649611],[114.115156,-20.504833],[116.302676,-21.001468],[118.900000,-21.162014],[121.574997,-20.965586],[123.299998,-20.304872],[124.224999,-19.072729],[124.500000,-17.162014],[124.251843,-15.429120],[123.514753,-14.177219],[122.299795,-13.417716],[120.618040,-13.162014],[118.416896,-12.971697],[116.830018,-12.419512],[115.858395,-11.533605],[115.503018,-10.342127],[115.764874,-8.873224],[116.644953,-7.155046],[118.144246,-5.215740],[120.263740,-3.083454],[123.585077,0.701204],[125.694649,4.705055],[126.637538,8.705006],[126.458828,12.477963],[125.203600,15.800833],[124.186380,17.223768],[122.916937,18.450522],[121.400906,19.453207],[119.643923,20.203938],[117.651622,20.674826],[115.429640,20.837986],[111.836829,20.670285],[109.733660,19.997228],[109.123797,19.391526],[108.746071,18.563885],[108.500000,16.115326]]);
    linear_extrude(height=h)
      polygon([[134.500000,3.837986],[134.396348,-5.512189],[133.878042,-10.612169],[133.366198,-11.966811],[132.634055,-12.737072],[131.642735,-13.082344],[130.353360,-13.162014],[128.533205,-13.367922],[127.364708,-14.002767],[126.822382,-15.092236],[126.880740,-16.662014],[127.683491,-18.400627],[129.581665,-19.471337],[133.034192,-20.012385],[138.500000,-20.162014],[143.965808,-20.012385],[147.418335,-19.471337],[149.316509,-18.400627],[150.119260,-16.662014],[150.177618,-15.092236],[149.635292,-14.002767],[148.466795,-13.367922],[146.646640,-13.162014],[145.357265,-13.082344],[144.365945,-12.737072],[143.633802,-11.966811],[143.121958,-10.612169],[142.603652,-5.512189],[142.500000,3.837986],[142.393383,13.103608],[141.882355,18.212983],[141.385572,19.589937],[140.680149,20.384860],[139.730241,20.750095],[138.500000,20.837986],[137.269759,20.750095],[136.319851,20.384860],[135.614428,19.589937],[135.117645,18.212983],[134.606617,13.103608],[134.500000,3.837986]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[149.280440,17.337986],[154.660780,-3.662014],[156.966122,-12.338381],[158.861723,-17.693784],[159.753118,-19.338650],[160.658777,-20.408303],[161.617597,-20.987755],[162.668480,-21.162014],[164.481154,-20.693600],[166.009975,-19.204577],[167.342124,-16.569272],[168.564780,-12.662014],[173.641880,5.700986],[175.660425,13.441356],[176.500000,18.200986],[176.236678,19.653664],[175.525282,20.528720],[174.483668,20.862765],[173.229692,20.692413],[171.881210,20.054278],[170.556077,18.984973],[169.372148,17.521111],[168.447280,15.699306],[167.269083,13.555008],[165.714664,12.062662],[163.933549,11.214024],[162.075263,11.000853],[160.289329,11.414906],[158.725275,12.447940],[157.532623,14.091714],[156.860900,16.337986],[156.328430,18.286393],[155.369163,19.694903],[153.997069,20.549955],[152.226120,20.837986],[150.448075,20.644892],[149.393238,20.031403],[149.018422,18.946205],[149.280440,17.337986]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[164.469380,-2.662014],[164.364074,-5.189490],[164.042300,-6.395872],[163.441721,-6.360325],[162.500000,-5.162014],[161.077539,-2.261192],[160.603385,0.305383],[161.077539,2.138260],[161.670231,2.654732],[162.500000,2.837986],[163.274146,2.404001],[163.903505,1.222361],[164.323456,-0.526467],[164.469380,-2.662014]]);
    }
    linear_extrude(height=h)
      polygon([[184.500000,3.837986],[184.393383,-5.427637],[183.882355,-10.537012],[183.385572,-11.913966],[182.680149,-12.708888],[181.730241,-13.074123],[180.500000,-13.162014],[178.750003,-13.412015],[177.500002,-14.162017],[176.750001,-15.412017],[176.500000,-17.162014],[176.859376,-19.269972],[177.431642,-19.972387],[178.375002,-20.480199],[181.703128,-21.031334],[187.500000,-21.162014],[193.296872,-21.031334],[196.624998,-20.480199],[197.568358,-19.972387],[198.140624,-19.269972],[198.500000,-17.162014],[198.249999,-15.412017],[197.499998,-14.162017],[196.249997,-13.412015],[194.500000,-13.162014],[193.269759,-13.074123],[192.319851,-12.708888],[191.614428,-11.913966],[191.117645,-10.537012],[190.606617,-5.427637],[190.500000,3.837986],[190.373163,12.306737],[189.911768,17.504653],[189.517696,19.091892],[188.994488,20.119236],[188.326978,20.672621],[187.500000,20.837986],[186.673022,20.672621],[186.005512,20.119236],[185.482304,19.091892],[185.088233,17.504653],[184.626837,12.306737],[184.500000,3.837986]]);
    linear_extrude(height=h)
      polygon([[200.500000,-0.162014],[200.500000,-21.162014],[209.500000,-21.162014],[214.140622,-21.016180],[216.874998,-20.439789],[217.673826,-19.925032],[218.171874,-19.224511],[218.500000,-17.162014],[218.234374,-15.299512],[217.374998,-14.062012],[215.828122,-13.374513],[213.500000,-13.162014],[211.171878,-12.949515],[209.625002,-12.262017],[208.765626,-11.024517],[208.500000,-9.162014],[208.750001,-7.412017],[209.500002,-6.162017],[210.750003,-5.412015],[212.500000,-5.162014],[214.249997,-4.912013],[215.499998,-4.162012],[216.249999,-2.912012],[216.500000,-1.162014],[216.253644,0.553153],[215.529155,1.807023],[214.348404,2.576375],[212.733260,2.837986],[211.190561,3.144472],[209.774630,3.978966],[208.642394,5.214019],[207.950780,6.722186],[207.502284,9.721198],[207.693026,10.785824],[208.194985,11.596458],[209.034078,12.180045],[210.236223,12.563532],[213.833340,12.837986],[215.968750,13.061200],[217.416665,13.766558],[218.239582,15.007630],[218.500000,16.837986],[218.171874,18.900483],[217.673826,19.601003],[216.874998,20.115761],[214.140622,20.692151],[209.500000,20.837986],[200.500000,20.837986],[200.500000,-0.162014]]);
  }
}
module AZ_Back(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    difference()
    {
       linear_extrude(height=h)
         polygon([[-399.195839,160.534242],[-574.195840,160.043742],[-577.695840,155.801542],[-578.671207,154.412152],[-579.454185,152.760765],[-580.518447,148.095602],[-581.039579,140.653248],[-581.168530,129.280902],[-580.796541,112.230767],[-580.408881,106.019895],[-579.940510,102.522502],[-578.462398,99.774447],[-575.532072,96.629022],[-571.397658,93.242752],[-566.307281,89.772167],[-560.509068,86.373793],[-554.251145,83.204159],[-547.781637,80.419793],[-541.348670,78.177222],[-535.058836,76.029247],[-528.908579,73.507939],[-523.603366,70.927482],[-519.848666,68.602062],[-513.195836,63.527702],[-513.195836,35.633602],[-513.358556,24.472783],[-513.802286,14.777099],[-514.460381,7.569011],[-515.266196,3.870982],[-516.573828,2.176091],[-518.425880,0.961494],[-520.823090,0.226856],[-523.766196,-0.028158],[-527.806146,-0.111302],[-529.439335,-0.328104],[-530.843419,-0.776659],[-532.039961,-1.543166],[-533.050526,-2.713822],[-533.896677,-4.374829],[-534.599980,-6.612383],[-535.664294,-13.161934],[-536.415981,-23.052065],[-537.671526,-55.612438],[-538.575291,-90.757243],[-538.479275,-102.255022],[-537.928516,-110.456636],[-536.855907,-115.927274],[-536.102938,-117.815099],[-535.194341,-119.232125],[-534.121727,-120.249002],[-532.876709,-120.936377],[-529.835906,-121.605218],[-527.116554,-121.676597],[-524.980243,-121.301668],[-523.455089,-120.489550],[-522.569206,-119.249358],[-522.015502,-114.378170],[-521.348561,-103.305793],[-520.010766,-69.134978],[-518.935804,-41.181043],[-518.293479,-31.998779],[-517.500158,-25.536751],[-516.495018,-21.437782],[-515.894008,-20.162828],[-515.217234,-19.344698],[-514.457093,-18.938744],[-513.605981,-18.900321],[-511.600436,-19.747478],[-510.951952,-20.988262],[-510.348466,-23.978087],[-509.236061,-35.811018],[-508.182374,-56.458580],[-507.106556,-87.133078],[-505.114008,-134.971731],[-504.074388,-150.553156],[-503.177756,-157.497538],[-502.159272,-159.174872],[-500.738933,-160.480095],[-499.020629,-161.397144],[-497.108251,-161.909953],[-495.105692,-162.002462],[-493.116842,-161.658604],[-491.245593,-160.862318],[-489.595836,-159.597538],[-488.984507,-158.143587],[-488.474088,-154.995260],[-487.732060,-142.931393],[-487.321920,-122.037754],[-487.195836,-90.946158],[-487.195836,-24.694798],[-482.464986,-20.250398],[-477.734136,-15.805998],[-476.474106,-22.106178],[-474.970558,-33.104996],[-473.125056,-50.701938],[-471.006735,-71.569013],[-469.182093,-84.543846],[-468.266920,-88.679665],[-467.289588,-91.572016],[-466.204904,-93.464094],[-464.967676,-94.599098],[-463.433085,-95.281367],[-461.641093,-95.634676],[-459.814546,-95.637116],[-458.176286,-95.266778],[-457.103785,-94.727826],[-456.295301,-93.912157],[-455.731916,-92.627653],[-455.394712,-90.682196],[-455.323175,-84.039956],[-455.929346,-72.448498],[-457.971646,-43.628669],[-460.178106,-20.402376],[-462.415218,-3.961404],[-463.503548,1.342154],[-464.549476,4.502462],[-466.034923,6.773835],[-467.877173,8.447592],[-470.006775,9.519169],[-472.354275,9.983999],[-474.850222,9.837518],[-477.425164,9.075162],[-480.009650,7.692365],[-482.534226,5.684562],[-487.130426,1.366642],[-486.084696,21.184562],[-483.979266,53.305802],[-483.253168,60.384096],[-482.799846,62.618203],[-482.166115,64.187767],[-481.261804,65.246896],[-479.996742,65.949705],[-476.023686,66.902802],[-470.679900,67.523784],[-468.685754,67.484919],[-467.515666,67.200142],[-462.688656,65.902459],[-453.347126,64.181642],[-448.090414,63.124306],[-443.004153,61.603052],[-437.835433,59.472373],[-432.331342,56.586767],[-426.238970,52.800727],[-419.305404,47.968749],[-401.903049,34.584962],[-393.816106,28.280006],[-387.333696,23.755634],[-382.029780,20.999273],[-379.686621,20.280169],[-377.478320,19.998354],[-375.351624,20.152256],[-373.253278,20.740304],[-371.130026,21.760927],[-368.928614,23.212553],[-364.078291,27.402529],[-358.276269,33.297662],[-353.642620,38.042047],[-349.873857,41.539726],[-346.799391,43.831144],[-344.248635,44.956749],[-342.051003,44.956985],[-340.035906,43.872299],[-338.032758,41.743136],[-335.870970,38.609942],[-331.733458,32.424689],[-327.682515,27.043925],[-323.725230,22.473879],[-319.868691,18.720782],[-316.119988,15.790861],[-312.486210,13.690348],[-308.974444,12.425471],[-305.591780,12.002462],[-303.619537,12.436446],[-301.060645,13.618087],[-298.246025,15.366915],[-295.506600,17.502462],[-283.600051,27.753424],[-276.336980,33.318714],[-273.868662,34.721226],[-271.867509,35.404713],[-270.102287,35.519972],[-268.341760,35.217802],[-266.109737,34.268812],[-263.640156,32.590424],[-261.233322,30.419679],[-259.189540,27.993622],[-255.626836,23.639861],[-252.076237,20.638544],[-250.294243,19.646265],[-248.501792,18.993551],[-246.694393,18.680887],[-244.867550,18.708759],[-243.016770,19.077651],[-241.137559,19.788048],[-237.275867,22.235295],[-233.246525,26.054380],[-229.013580,31.249182],[-225.634316,35.448490],[-222.353235,38.865029],[-219.530201,41.161964],[-217.525080,42.002462],[-215.613433,41.450118],[-213.028725,39.946212],[-210.109884,37.720430],[-207.195840,35.002462],[-204.237363,32.286646],[-201.197542,30.066729],[-198.433786,28.571503],[-196.303500,28.029762],[-190.740502,28.523114],[-188.441526,29.105578],[-186.470017,29.908979],[-184.830316,30.931124],[-183.526760,32.169821],[-182.563688,33.622877],[-181.945440,35.288102],[-181.092779,37.664893],[-179.809068,39.778168],[-178.121023,41.611471],[-176.055357,43.148347],[-173.638789,44.372339],[-170.898033,45.266992],[-167.859805,45.815852],[-164.550820,46.002462],[-161.739165,46.144823],[-159.176852,46.664595],[-156.679655,47.700810],[-154.063345,49.392502],[-151.143696,51.878702],[-147.736480,55.298443],[-138.722440,65.494682],[-136.520504,67.799590],[-133.903501,70.067150],[-127.626904,74.413032],[-120.297876,78.377954],[-112.321642,81.807539],[-104.103430,84.547412],[-96.048465,86.443197],[-88.561973,87.340519],[-85.158537,87.366513],[-82.049180,87.085002],[-75.524427,85.610454],[-73.276585,84.736359],[-72.138680,83.909962],[-72.015807,82.455183],[-72.531687,79.870149],[-75.092060,72.771282],[-78.131789,64.903066],[-78.898206,61.924670],[-79.162325,59.583154],[-78.924149,57.878321],[-78.183678,56.809976],[-76.940915,56.377921],[-75.195860,56.581962],[-73.071904,56.861222],[-72.368823,56.596890],[-71.863455,55.982572],[-71.321208,53.461932],[-71.195860,48.815222],[-71.035732,44.849847],[-70.540152,42.108059],[-69.686332,40.516662],[-68.451480,40.002462],[-67.320300,40.602045],[-66.255245,42.226249],[-65.312593,44.613255],[-64.548622,47.501244],[-63.781844,53.732898],[-63.891593,56.552925],[-64.405140,58.826662],[-64.666489,60.199367],[-64.394280,61.441874],[-63.627056,62.470005],[-62.403360,63.199582],[-61.077012,63.888438],[-60.120432,64.770267],[-59.534508,65.807369],[-59.320130,66.962044],[-59.478187,68.196591],[-60.009568,69.473310],[-60.915163,70.754500],[-62.195860,72.002462],[-63.360704,73.405783],[-64.314610,75.386182],[-64.959141,77.680410],[-65.195860,80.025222],[-64.983834,83.174152],[-64.528781,84.148831],[-63.672125,84.802402],[-62.287186,85.193926],[-60.247283,85.382466],[-53.695860,85.386842],[-41.461485,85.894804],[-28.195860,87.356662],[-17.867735,88.614559],[-14.382969,88.799308],[-12.695860,88.632122],[-12.113438,87.600682],[-11.636485,85.432294],[-11.195860,78.954802],[-11.389026,74.620749],[-12.044302,71.558159],[-13.275358,69.455805],[-15.195860,68.002462],[-16.391986,67.241383],[-17.325882,66.278881],[-18.029216,64.948136],[-18.533657,63.082329],[-19.072534,57.078253],[-19.195860,46.932102],[-19.068837,37.647013],[-18.621020,31.842987],[-17.752288,28.851107],[-17.128791,28.200687],[-16.362520,28.002462],[-15.182797,28.199727],[-14.065157,28.736837],[-13.135674,29.531758],[-12.520420,30.502462],[-12.314558,30.810762],[-12.116277,30.723555],[-11.761597,29.477462],[-11.353760,23.502462],[-11.127656,18.594976],[-10.505425,15.709697],[-9.977268,14.868877],[-9.267886,14.345800],[-7.195860,14.002462],[-5.087902,14.361837],[-4.385487,14.934104],[-3.877675,15.877464],[-3.326541,19.205589],[-3.195860,25.002462],[-3.050975,30.283710],[-2.559500,33.669127],[-1.636205,35.471211],[-0.985991,35.876159],[-0.195860,36.002462],[0.621001,36.153412],[1.283762,36.652024],[1.806350,37.566939],[2.202693,38.966797],[2.672347,43.495907],[2.804140,50.788482],[2.657750,57.921384],[2.163768,62.664039],[1.239971,65.453225],[0.591199,66.251761],[-0.195860,66.725722],[-1.435692,67.663981],[-2.375577,69.343254],[-2.968780,71.642256],[-3.168560,74.439702],[-2.759218,81.379556],[-2.265736,84.059870],[-1.573687,86.228347],[-0.678553,87.895915],[0.424187,89.073505],[1.739051,89.772044],[3.270560,90.002462],[5.220468,89.794635],[6.254333,89.031592],[6.487995,87.503983],[6.037300,85.002462],[3.570980,75.002462],[3.155393,72.667547],[3.294768,71.121427],[4.024673,70.265823],[5.380680,70.002462],[6.822529,69.633642],[7.581498,68.335392],[7.725717,65.820027],[7.323320,61.799862],[6.860408,57.475960],[7.043970,55.095332],[7.429984,54.489714],[8.039782,54.197078],[10.013620,54.320302],[11.544610,54.952614],[12.885280,56.138624],[13.897525,57.716122],[14.443240,59.522902],[14.860304,61.262232],[15.523435,62.686592],[16.341419,63.648997],[17.223040,64.002462],[17.832110,64.647278],[18.226468,66.426441],[18.399803,72.456084],[17.800550,80.227951],[16.486220,87.878602],[16.634487,89.229727],[17.788050,90.365654],[19.968978,91.300089],[23.199340,92.046742],[29.187345,93.563177],[31.604406,94.494528],[33.199340,95.394822],[35.200493,96.676375],[37.777344,97.712657],[41.157061,98.527600],[45.566813,99.145137],[58.385095,99.883723],[78.049540,100.119882],[93.313977,100.290796],[103.635703,100.786249],[110.037197,101.691903],[112.087382,102.325325],[113.540940,103.093422],[116.147072,104.452463],[119.315549,105.389704],[122.804554,105.911343],[126.372265,106.023579],[129.776865,105.732610],[132.776533,105.044636],[135.129451,103.965853],[136.593800,102.502462],[137.796558,100.712591],[139.007388,100.049579],[140.661268,100.477768],[143.193180,101.961502],[146.285383,103.253181],[151.030783,104.274844],[157.260121,104.999556],[164.804140,105.400382],[188.509340,106.570182],[191.134654,106.623228],[193.338293,106.255877],[195.056116,105.547271],[196.223985,104.576557],[196.777759,103.422878],[196.653299,102.165379],[195.786466,100.883205],[194.113120,99.655502],[192.901386,98.584488],[191.943442,96.996727],[191.262124,95.095504],[190.880268,93.084104],[190.820707,91.165814],[191.106279,89.543920],[191.759818,88.421707],[192.804160,88.002462],[193.580723,87.765743],[194.216660,87.121212],[194.646348,86.167305],[194.804160,85.002462],[195.116660,83.830589],[195.970828,82.877464],[197.241661,82.236837],[198.804160,82.002462],[200.357289,82.226029],[201.629164,82.834754],[202.488536,83.735667],[202.804160,84.835802],[203.001426,86.002233],[203.538535,87.083687],[204.333457,87.959617],[205.304160,88.509482],[206.415983,89.248071],[206.768730,90.657834],[206.357894,93.032176],[205.178970,96.664502],[203.662875,102.377334],[203.464712,104.540804],[203.704320,105.840842],[205.362217,106.489418],[209.031145,106.865197],[214.192971,106.941643],[220.329560,106.692222],[235.358258,105.910922],[246.703720,105.815842],[255.120658,106.426677],[261.363780,107.763122],[266.440783,108.722998],[274.239055,109.435932],[294.544325,110.098357],[315.369428,109.705164],[323.817490,109.098576],[329.804200,108.211122],[342.567145,105.522256],[347.355874,104.868189],[351.574620,104.679949],[355.592264,104.961726],[359.777690,105.717708],[370.127420,108.669042],[379.954572,111.509083],[384.337680,112.364112],[389.102833,112.897867],[401.986337,113.167703],[423.019220,112.650902],[453.749375,111.779450],[471.124008,111.591732],[481.097697,112.173558],[489.625020,113.610742],[495.436973,114.425503],[502.262120,114.889949],[509.393717,114.976196],[516.125020,114.656362],[530.804120,113.415522],[530.786120,103.208982],[530.417633,93.063129],[529.556620,83.002462],[528.710128,77.664178],[527.467533,74.216117],[526.563320,72.967466],[525.398831,71.911227],[522.074020,70.002462],[519.347398,68.219316],[516.999790,65.636413],[515.018419,62.211938],[513.390508,57.904077],[512.103279,52.671013],[511.143956,46.470932],[510.499762,39.262020],[510.157920,31.002462],[510.069547,22.265124],[510.471683,17.458162],[510.939194,16.166626],[511.628337,15.423349],[512.572112,15.083554],[513.803520,15.002462],[514.935921,15.117547],[515.914839,15.504182],[516.774947,16.224438],[517.550920,17.340384],[518.989151,21.007624],[520.506920,27.002462],[523.909067,41.705769],[526.120045,49.795739],[526.946535,51.857241],[527.676461,52.861231],[528.376897,53.006315],[529.114920,52.491102],[529.559754,51.633486],[529.874087,50.076638],[530.111132,44.840157],[529.825822,36.731483],[529.017920,25.700442],[527.934265,8.230555],[527.951397,1.878754],[528.368208,-3.070546],[529.204976,-6.757040],[530.481981,-9.320423],[532.219503,-10.900391],[534.437820,-11.636638],[535.866011,-11.772745],[536.944764,-11.479685],[537.725232,-10.416884],[538.258570,-8.243766],[538.788476,0.795717],[538.943720,18.363362],[539.293793,37.886796],[540.183932,49.917319],[540.857457,53.307901],[541.697115,55.047449],[542.182486,55.321230],[542.713279,55.210027],[543.916320,53.869702],[544.779726,51.493907],[545.797670,47.144714],[547.788820,35.002462],[549.025465,26.490408],[550.247982,21.570757],[550.979676,20.134954],[551.858718,19.209498],[552.935402,18.665137],[554.260020,18.372622],[556.432098,18.335598],[558.011320,19.032717],[559.154642,20.594187],[560.019020,23.150222],[560.292899,26.429882],[560.188932,31.886682],[559.137136,46.320629],[557.442982,60.429912],[556.536068,65.480883],[555.685820,68.192382],[554.752765,68.935580],[552.968432,69.735589],[547.871520,71.121582],[545.159439,71.812134],[542.795395,72.750514],[541.033489,73.813473],[540.127820,74.877762],[539.914247,77.184854],[540.038822,81.534590],[541.022032,93.628492],[542.516687,105.692468],[543.280567,110.004797],[543.962020,112.259522],[544.874370,112.936274],[546.562145,113.490474],[551.300820,114.002462],[559.190200,114.718587],[569.365430,116.440342],[581.168530,118.878222],[580.485830,136.233242],[579.978177,144.879296],[579.159105,150.880262],[577.880246,154.948252],[575.993230,157.795382],[572.183830,162.002462],[173.993780,161.513582],[-399.195839,160.534242]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-489.871266,61.502462],[-490.262957,60.926290],[-490.583717,61.205587],[-490.880046,64.002462],[-490.583717,66.799337],[-490.262957,67.078633],[-489.871266,66.502462],[-489.455151,64.002462],[-489.871266,61.502462]]);
    }
  }
}
module CA_Stat(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    difference()
    {
       linear_extrude(height=h)
         polygon([[-138.848000,109.418248],[-139.646404,108.810747],[-140.587000,108.934158],[-141.118019,108.863737],[-141.793677,108.195998],[-143.231790,105.517048],[-145.390720,100.344538],[-145.478413,99.992197],[-145.306170,99.854487],[-144.322130,100.237038],[-143.611953,100.585040],[-143.257085,100.510548],[-143.556530,99.002598],[-143.846649,97.009219],[-143.337920,95.360038],[-142.116527,92.532480],[-140.693220,87.705978],[-139.110492,82.190353],[-137.505850,77.705978],[-134.323855,70.029337],[-132.213724,64.215344],[-131.186988,60.299768],[-131.255180,58.318378],[-131.335624,57.880677],[-131.109002,57.409994],[-129.910980,56.595788],[-128.764416,55.698325],[-128.593485,55.137535],[-128.741930,54.589798],[-128.863250,53.700757],[-128.062430,53.330978],[-127.553279,53.183029],[-127.244416,52.780197],[-127.324430,51.455978],[-127.476911,50.131759],[-127.246508,49.728927],[-126.833170,49.580978],[-126.363046,49.396250],[-125.978056,48.893278],[-125.622390,47.239878],[-125.249251,45.067913],[-124.083669,41.525725],[-119.098180,29.580978],[-118.345552,27.003637],[-118.064274,24.073650],[-118.262101,21.319242],[-118.946790,19.268638],[-119.533308,19.338831],[-120.706737,20.222855],[-124.133560,23.833288],[-128.177830,28.162759],[-131.422300,30.845718],[-133.780812,32.789457],[-135.695010,35.341678],[-136.978374,37.295303],[-137.820160,37.799868],[-140.339097,39.157099],[-145.654740,43.160758],[-149.351638,45.963758],[-152.357659,47.799358],[-154.968518,48.817817],[-157.479930,49.169398],[-160.463557,49.047253],[-161.209966,48.848877],[-161.292630,48.584548],[-161.279627,48.038471],[-161.765556,47.072964],[-163.892930,44.429068],[-165.706660,42.256003],[-166.687817,39.840258],[-167.076486,36.103500],[-167.112750,29.967398],[-166.808430,21.272610],[-166.197090,15.830978],[-165.228745,11.410376],[-165.004812,8.146989],[-165.531934,5.920539],[-166.816750,4.610748],[-168.155659,4.288936],[-169.741560,4.840567],[-171.865556,6.434065],[-174.818750,9.237858],[-178.917570,13.776995],[-180.164446,15.500491],[-180.622390,16.540448],[-180.819392,17.173982],[-181.355785,17.790870],[-183.119050,18.692288],[-184.174003,19.177020],[-185.200764,20.014197],[-186.699750,22.275578],[-187.790466,24.202777],[-188.375293,24.678219],[-188.890580,24.721228],[-189.427772,24.743277],[-190.072229,25.161663],[-191.358960,26.901308],[-192.554546,28.549389],[-193.100335,28.868653],[-193.517040,28.769658],[-193.888494,28.622455],[-194.311087,28.810459],[-195.101700,30.027058],[-195.983447,31.477637],[-196.996610,32.080978],[-198.385121,32.685250],[-200.729369,34.343412],[-207.086640,39.893478],[-208.700950,41.236117],[-209.372390,41.392368],[-210.663796,41.891034],[-213.768680,44.056958],[-216.161227,45.635229],[-218.649269,46.737234],[-221.431391,47.430626],[-224.706180,47.783058],[-228.373825,47.863330],[-230.953711,47.414762],[-233.217009,46.167486],[-235.934890,43.851638],[-239.245435,40.143488],[-240.252516,38.495403],[-240.622390,37.272488],[-240.881066,35.407205],[-241.502990,34.117038],[-242.257385,32.505872],[-242.834579,29.868788],[-243.324615,27.417009],[-243.950985,26.010965],[-244.628680,25.758755],[-245.272689,26.768478],[-246.186979,27.871992],[-247.601549,28.330978],[-248.852204,28.719837],[-249.372389,29.654748],[-249.714451,30.378255],[-250.536859,30.258838],[-251.143705,30.200259],[-251.935180,30.572780],[-253.661859,32.338198],[-255.046483,33.992819],[-255.467691,34.245406],[-255.622389,34.040378],[-255.794996,33.761454],[-256.264965,33.812850],[-257.809889,34.806098],[-261.674865,37.657272],[-265.932393,40.092863],[-270.028833,41.835942],[-273.410549,42.609578],[-275.770032,42.449036],[-278.014616,41.683321],[-280.082750,40.384088],[-281.912884,38.622993],[-283.443466,36.471692],[-284.612945,34.001840],[-285.359769,31.285093],[-285.622389,28.393108],[-286.028858,25.700837],[-286.468843,24.881835],[-287.006129,24.581038],[-287.484711,24.421034],[-287.756680,23.983975],[-287.605259,22.536398],[-287.265556,21.490683],[-287.402935,21.120450],[-289.659029,22.358888],[-292.063585,24.461888],[-293.858969,26.896118],[-294.999796,28.602663],[-295.486318,28.982323],[-295.830649,28.956118],[-296.518732,29.137819],[-297.941226,30.083574],[-302.158869,33.651028],[-311.283679,41.785493],[-313.972221,43.874271],[-315.335519,44.581038],[-316.623774,45.262073],[-318.666829,46.899448],[-322.070931,49.403982],[-326.631489,52.169868],[-329.360282,53.569966],[-331.167853,54.210982],[-332.316329,54.143800],[-333.067839,53.419308],[-334.356665,52.426272],[-335.977719,52.429588],[-337.028936,52.478880],[-338.279164,51.980681],[-341.028140,49.714088],[-343.527624,46.374357],[-344.465985,44.534737],[-345.080589,42.706038],[-346.048732,39.622090],[-347.131489,37.473438],[-347.525469,36.666754],[-347.610148,35.675364],[-346.862879,33.313268],[-346.051167,30.900137],[-346.111899,28.858368],[-346.300688,27.603129],[-345.796829,27.081038],[-345.182077,26.595103],[-344.245329,25.272013],[-341.915299,20.922648],[-338.847993,15.445398],[-335.523879,10.924608],[-330.382139,4.873458],[-326.337704,0.914236],[-319.724105,-4.284982],[-312.461526,-9.309443],[-306.470149,-12.744392],[-300.312046,-15.192486],[-293.970149,-17.186102],[-290.341869,-18.032575],[-287.947775,-18.216597],[-286.062573,-17.678084],[-283.960969,-16.356952],[-281.278440,-14.110061],[-279.795019,-12.217342],[-279.394644,-11.638635],[-278.770785,-11.279760],[-277.188889,-11.335312],[-275.895324,-11.533325],[-276.295019,-10.341902],[-276.435605,-9.881777],[-276.017990,-9.924027],[-273.831499,-11.379472],[-270.719366,-13.305629],[-267.790894,-13.998716],[-266.367820,-13.883606],[-264.957409,-13.461126],[-262.130239,-11.695252],[-260.513243,-10.199797],[-259.888641,-8.686288],[-260.181466,-6.265784],[-261.316749,-2.049342],[-263.275806,3.478258],[-264.267604,5.473794],[-265.101979,6.579638],[-266.094676,7.779944],[-266.217501,8.324244],[-266.049839,8.736928],[-265.908553,9.787088],[-266.669389,11.211438],[-267.824049,13.294723],[-268.629629,15.929138],[-269.381049,18.956038],[-269.819669,22.209478],[-269.819627,23.739742],[-269.513724,24.722243],[-268.854931,25.229611],[-267.796219,25.334478],[-265.882353,24.737755],[-264.465249,23.483388],[-263.373246,22.477525],[-262.241029,22.478208],[-261.455644,22.613660],[-260.352373,22.299319],[-257.388444,20.521766],[-253.741770,17.546559],[-249.804883,13.774707],[-245.970312,9.607219],[-242.630588,5.445107],[-240.178241,1.689380],[-239.005800,-1.258952],[-238.297866,-3.671171],[-237.130340,-6.262002],[-235.962954,-8.851942],[-235.255340,-11.262002],[-234.483755,-13.791610],[-233.162540,-16.668962],[-231.631120,-20.100452],[-231.636348,-21.710753],[-231.021466,-24.253930],[-230.156806,-26.524973],[-229.746538,-27.181879],[-229.412700,-27.318872],[-228.826686,-27.615886],[-227.900339,-28.838181],[-225.535520,-33.276662],[-222.557141,-39.072865],[-219.569650,-43.856462],[-217.774124,-46.731226],[-217.476153,-47.610113],[-217.661530,-47.938102],[-218.048534,-48.221377],[-217.454170,-48.875602],[-215.108976,-51.727320],[-211.286530,-57.293962],[-205.701240,-65.418962],[-201.515990,-71.169422],[-195.134489,-79.678167],[-187.379049,-88.844527],[-180.139082,-96.543482],[-177.302842,-99.178614],[-175.304000,-100.650012],[-171.443406,-102.193843],[-167.858070,-102.866572],[-166.066345,-102.723545],[-164.869092,-102.065382],[-164.027434,-100.649037],[-163.302490,-98.231462],[-161.367460,-89.622381],[-161.400582,-88.235479],[-161.989420,-87.918962],[-162.429329,-87.573747],[-162.789579,-86.633806],[-163.122390,-83.543962],[-163.478056,-80.454118],[-163.863046,-79.514177],[-164.333170,-79.168962],[-164.999485,-78.677010],[-164.901280,-77.494232],[-164.804186,-76.717449],[-165.014894,-75.840472],[-166.190500,-74.216172],[-167.554897,-72.189147],[-168.122390,-69.567132],[-168.492205,-67.520171],[-168.949737,-67.226391],[-169.584810,-67.425242],[-170.177182,-67.694380],[-170.487382,-67.594548],[-170.262930,-66.285192],[-170.159545,-64.372086],[-171.012290,-62.642632],[-173.790532,-58.782433],[-177.533566,-52.632930],[-180.827134,-46.635485],[-182.256980,-43.231462],[-182.607276,-42.127945],[-183.404490,-41.668962],[-183.965340,-41.301775],[-183.747390,-40.418962],[-183.612309,-39.536150],[-184.372390,-39.168962],[-185.149569,-38.829441],[-185.055600,-38.013152],[-185.075360,-37.239057],[-185.657230,-35.985791],[-188.106830,-32.734572],[-190.766257,-29.353923],[-191.872390,-27.015392],[-192.232585,-25.887912],[-193.098580,-25.418962],[-193.636570,-25.172380],[-194.194964,-24.500993],[-195.109090,-22.293962],[-195.990399,-20.086931],[-196.513277,-19.415544],[-197.007900,-19.168962],[-197.795005,-18.786277],[-198.122390,-17.866202],[-198.581376,-16.403098],[-199.684890,-14.714822],[-204.531160,-8.998982],[-209.218660,-3.453122],[-210.215669,-1.609506],[-210.641530,0.465778],[-210.885295,1.849924],[-211.695640,1.074228],[-212.337565,0.499107],[-213.163992,0.637024],[-214.267083,1.537580],[-215.739000,3.250378],[-218.322664,5.943087],[-219.465823,6.764815],[-220.309890,7.069698],[-221.413407,7.420063],[-221.872390,8.246798],[-222.588029,9.297263],[-224.308600,10.185788],[-225.318522,10.649799],[-225.934335,11.272837],[-226.152925,12.049675],[-225.971180,12.975088],[-225.760222,14.231387],[-226.024086,14.373878],[-226.524280,14.171188],[-227.087688,14.289200],[-227.437537,15.482387],[-227.504900,21.153628],[-227.026583,27.559714],[-226.242021,32.148103],[-225.153809,34.908606],[-224.496644,35.600218],[-223.764540,35.831038],[-221.083534,35.449704],[-217.912208,34.052066],[-213.825795,31.257673],[-208.399531,26.686072],[-201.208649,19.956810],[-191.828382,10.689435],[-164.800630,-16.981462],[-163.047359,-18.265799],[-160.953862,-18.934063],[-158.620619,-19.016013],[-156.148107,-18.541406],[-153.636807,-17.540000],[-151.187196,-16.041554],[-148.899754,-14.075825],[-146.874960,-11.672572],[-145.364766,-9.281104],[-144.807104,-6.958058],[-145.161094,-3.553868],[-146.385860,2.081038],[-147.067460,7.393538],[-147.408510,8.938462],[-147.799540,9.408431],[-148.284310,9.581038],[-148.716665,9.784328],[-148.937412,10.344524],[-148.697700,12.237578],[-148.425904,13.928849],[-148.613124,14.262467],[-149.004510,14.183398],[-149.496248,14.378266],[-149.832527,15.486713],[-150.055549,19.353608],[-149.707248,23.602612],[-149.329375,25.188697],[-148.821300,26.052258],[-147.752974,26.366307],[-146.269803,26.065694],[-144.367785,25.147501],[-142.042916,23.608810],[-136.108619,18.658263],[-128.434890,11.190708],[-120.268872,3.098445],[-117.784743,0.827666],[-116.872390,0.220408],[-116.492165,0.067309],[-115.456900,-0.966897],[-112.053700,-4.994212],[-107.867066,-9.962538],[-104.567990,-13.412272],[-101.362915,-17.035375],[-97.973745,-21.970060],[-95.248625,-26.854295],[-94.035700,-30.326052],[-93.608727,-32.157295],[-92.856390,-32.918962],[-92.161440,-33.631666],[-91.872390,-35.345192],[-91.480170,-37.301118],[-90.537180,-38.596632],[-89.774109,-39.648331],[-89.814490,-41.018082],[-89.941937,-42.465561],[-89.388190,-43.704142],[-87.982069,-46.565906],[-86.450644,-51.354198],[-85.367289,-56.000247],[-85.172818,-57.623440],[-85.305380,-58.435282],[-85.406684,-58.953442],[-84.619950,-59.168962],[-84.125716,-59.316911],[-83.829067,-59.719743],[-83.920350,-61.043962],[-84.089090,-62.368181],[-83.876270,-62.771013],[-83.484400,-62.918962],[-82.343300,-64.535687],[-80.644494,-68.529387],[-78.878260,-73.615350],[-77.534880,-78.508862],[-76.277781,-82.240865],[-73.024190,-90.106462],[-71.604942,-93.858413],[-71.368070,-95.418962],[-70.436475,-96.887712],[-67.346980,-100.418962],[-63.644856,-103.950212],[-62.180205,-105.024431],[-61.240330,-105.418962],[-59.857334,-105.100964],[-58.532044,-104.203124],[-57.306839,-102.809676],[-56.224097,-101.004852],[-54.655519,-96.498010],[-54.254440,-93.964458],[-54.165340,-91.356462],[-53.843117,-88.928726],[-53.435859,-88.190202],[-52.919020,-87.918962],[-52.411422,-87.810708],[-52.261552,-87.482678],[-53.036270,-86.147692],[-54.146596,-83.581235],[-54.751820,-79.898132],[-55.239902,-76.735210],[-55.633271,-75.772937],[-56.068590,-75.419402],[-56.430202,-75.277655],[-56.622899,-74.892033],[-56.451320,-73.624722],[-56.345457,-72.230745],[-57.057740,-71.398832],[-57.576119,-70.963088],[-58.030266,-70.095750],[-58.550010,-67.568952],[-58.953242,-65.168698],[-59.281271,-64.438329],[-59.645630,-64.169842],[-60.072287,-63.627875],[-59.836710,-62.326082],[-59.715467,-61.457190],[-59.908110,-60.453708],[-61.072830,-58.539912],[-62.238006,-56.627305],[-62.431145,-55.625110],[-62.310500,-54.757792],[-62.185906,-53.459117],[-62.438839,-53.064057],[-62.877140,-52.918962],[-63.580574,-52.486310],[-64.555371,-51.308298],[-66.803700,-47.435852],[-69.400121,-42.731167],[-71.915220,-39.119592],[-73.650599,-36.235223],[-74.372390,-33.278922],[-74.709700,-31.363343],[-75.074820,-30.942855],[-75.520680,-30.981102],[-76.031714,-30.959897],[-76.574300,-30.377545],[-77.494990,-27.929872],[-78.416399,-25.273730],[-78.959750,-24.465722],[-79.471720,-24.168962],[-79.918500,-23.971697],[-80.284377,-23.434587],[-80.622390,-21.668962],[-81.011250,-19.903337],[-81.432171,-19.366228],[-81.946170,-19.168962],[-82.639844,-18.778636],[-82.448720,-17.840202],[-82.302748,-17.133212],[-82.512385,-16.190517],[-83.818680,-14.090202],[-85.104875,-12.380198],[-85.292765,-11.860012],[-85.120240,-11.668962],[-84.928356,-11.449750],[-85.063541,-10.852885],[-86.176520,-8.890822],[-87.550787,-6.276102],[-88.122390,-3.890822],[-88.511250,-2.321635],[-88.932171,-1.844281],[-89.446170,-1.668962],[-90.169829,-1.327143],[-90.050780,-0.505332],[-89.922034,0.550818],[-90.622390,1.456038],[-91.322750,2.361258],[-91.194000,3.417408],[-90.977536,4.698205],[-91.466980,6.143538],[-92.582990,8.331038],[-94.211080,12.597088],[-95.031865,15.657695],[-94.921042,16.687589],[-94.474784,17.373788],[-93.702121,17.708726],[-92.612085,17.684838],[-89.516020,16.530318],[-86.766146,14.711250],[-85.929623,13.848889],[-85.622390,13.165198],[-85.481653,12.694390],[-85.098456,12.411662],[-83.838780,12.497998],[-83.015739,12.604742],[-82.093281,12.389428],[-80.401280,11.167288],[-76.819906,8.179123],[-70.531850,3.824608],[-64.210832,-0.563060],[-60.550200,-3.630952],[-57.872064,-6.037106],[-53.913220,-8.833822],[-49.270840,-12.099527],[-44.949340,-15.633222],[-41.343818,-18.621206],[-37.230622,-21.400102],[-32.180688,-24.232669],[-25.764950,-27.381662],[-22.699696,-28.640087],[-19.646049,-29.550359],[-16.627328,-30.123069],[-13.666852,-30.368809],[-10.787938,-30.298169],[-8.013905,-29.921739],[-5.368072,-29.250110],[-2.873756,-28.293873],[-0.554277,-27.063619],[1.567047,-25.569938],[3.466898,-23.823420],[5.121957,-21.834657],[6.508907,-19.614239],[7.604428,-17.172757],[8.385201,-14.520801],[8.827910,-11.668962],[9.243680,-8.199362],[9.684233,-8.092864],[10.628484,-8.422828],[13.428416,-10.005398],[16.444148,-12.173578],[18.476350,-14.153872],[19.886464,-15.745091],[20.450710,-16.093866],[20.818610,-16.061302],[21.412259,-16.174746],[22.591179,-16.921091],[26.021900,-19.819252],[31.065300,-24.168962],[38.372170,-31.043962],[43.523054,-35.610898],[45.659235,-36.954368],[47.575788,-37.688580],[49.327623,-37.826590],[50.969650,-37.381453],[52.556779,-36.366225],[54.143920,-34.793962],[55.886719,-32.586931],[56.261270,-31.668962],[57.117843,-29.297968],[60.019530,-23.597492],[62.648682,-18.202632],[64.092699,-14.043147],[64.292163,-11.366203],[63.906621,-10.660922],[63.187660,-10.418962],[62.420246,-9.975115],[61.210411,-8.766618],[58.127610,-4.793962],[55.677289,-0.821306],[55.152085,0.387190],[55.220700,0.831038],[55.373823,0.985736],[55.078728,1.406943],[53.384840,2.791558],[51.603734,4.492875],[51.214238,5.256886],[51.252090,5.830188],[51.324429,6.837707],[50.562790,7.746098],[49.795263,8.832619],[49.853560,10.268378],[49.791346,12.497838],[48.734070,15.492628],[47.767802,18.542661],[47.704784,21.485694],[48.461979,23.704297],[49.122207,24.348989],[49.956350,24.581038],[52.523649,23.930756],[56.177924,22.242384],[60.170477,19.909629],[63.752610,17.326198],[85.326270,-2.779242],[97.466081,-13.957553],[101.944885,-17.631675],[105.590073,-20.167457],[108.571979,-21.668663],[111.060943,-22.239056],[113.227301,-21.982398],[115.241390,-21.002452],[116.981769,-19.675069],[118.524794,-18.117699],[120.954306,-14.443980],[122.400976,-10.243262],[122.715447,-8.027143],[122.735850,-5.777512],[122.747469,-1.993037],[122.932423,-0.841786],[123.215800,-0.418962],[126.125265,-2.248503],[132.005990,-6.647192],[144.647483,-16.016843],[149.436766,-19.035102],[153.489810,-21.060458],[157.020168,-22.181516],[160.241392,-22.486879],[163.367035,-22.065153],[166.610650,-21.004942],[169.350723,-19.742007],[171.140626,-18.375610],[172.313094,-16.546871],[173.200860,-13.896912],[174.115708,-8.690273],[174.523716,-2.392477],[174.401034,3.940463],[173.723810,9.252538],[173.300050,12.157154],[173.332015,14.698027],[173.782859,16.823835],[174.615735,18.483254],[175.793799,19.624959],[177.280205,20.197628],[179.038107,20.149935],[181.030660,19.430558],[184.796647,16.768123],[189.197936,12.751879],[192.852325,8.756472],[193.967493,7.196159],[194.377610,6.156548],[195.020186,4.756645],[196.565110,3.713518],[199.313083,1.872716],[204.161379,-2.241276],[218.078700,-15.437072],[222.488243,-19.434672],[226.877610,-22.876852],[231.877610,-26.748552],[232.667984,-27.390082],[233.839209,-27.834953],[236.858234,-28.144985],[240.002724,-27.699177],[241.330782,-27.199250],[242.340720,-26.518062],[244.132606,-23.788836],[245.539869,-19.945943],[246.238470,-16.162835],[246.220760,-14.660404],[245.904370,-13.612962],[245.273408,-11.889683],[244.812923,-8.415406],[244.037300,8.029788],[243.880704,15.261077],[244.184481,20.005850],[245.177143,23.762592],[247.087200,28.029788],[250.371823,34.113450],[253.362760,38.662838],[256.144560,42.119638],[253.502850,44.761368],[252.009521,46.025000],[250.513919,46.705803],[248.761117,46.870096],[246.496190,46.584198],[243.678619,45.800387],[241.086305,44.560921],[238.738365,42.888210],[236.653918,40.804663],[234.852080,38.332691],[233.351971,35.494704],[232.172709,32.313113],[231.333410,28.810328],[230.080940,24.707768],[229.551026,19.477979],[229.287640,8.539498],[228.949961,-1.721908],[228.500080,-4.863347],[227.795390,-6.784927],[226.785308,-7.566388],[225.419249,-7.287466],[223.646628,-6.027902],[221.416860,-3.867432],[217.630953,-0.324356],[214.025270,2.455138],[211.785413,4.383618],[211.272136,5.242261],[211.283260,5.880638],[211.316629,6.457490],[210.863908,7.148603],[208.823100,8.526368],[206.566281,9.831363],[205.627610,10.924378],[205.031907,12.074494],[203.389763,14.002690],[197.835939,19.402142],[190.705710,25.540379],[183.738650,30.835048],[181.259388,32.288309],[178.716859,33.289430],[176.141239,33.839853],[173.562701,33.941024],[171.011421,33.594385],[168.517573,32.801380],[166.111331,31.563453],[163.822870,29.882048],[161.707129,27.774271],[160.247666,25.372102],[159.155646,22.024653],[158.142230,17.081038],[157.005870,9.174788],[156.638680,3.331038],[156.379022,-0.506107],[155.380631,-3.690868],[153.815078,-5.864677],[152.873230,-6.460421],[151.853930,-6.668962],[150.541547,-6.404003],[148.820547,-5.599651],[144.080256,-2.315903],[137.488188,3.296000],[128.899470,11.349778],[120.866923,18.928733],[117.146230,22.081038],[114.540003,24.282113],[109.186870,29.574058],[104.024703,34.639504],[102.454355,36.004151],[101.877610,36.295998],[101.749186,36.103191],[101.399516,36.148210],[100.250060,36.875658],[99.239560,37.492269],[98.144706,37.768800],[97.005653,37.722892],[95.862556,37.372188],[93.724851,35.826958],[92.052830,33.274248],[91.196200,30.860790],[90.724866,28.371558],[90.636854,25.817303],[90.930191,23.208773],[91.602903,20.556719],[92.653016,17.871890],[94.078556,15.165036],[95.877550,12.446908],[98.865668,7.836094],[100.373839,4.304248],[100.557496,3.003112],[100.352630,2.043929],[99.753061,1.450767],[98.752610,1.247698],[97.428391,1.553689],[96.877610,2.289378],[96.383913,3.025049],[95.196930,3.331038],[94.031742,4.011026],[91.785814,5.837566],[85.401831,11.649748],[78.745173,18.206477],[74.516030,22.946648],[66.054600,30.639148],[59.509656,35.523749],[56.358339,37.343045],[53.359508,38.718692],[50.566948,39.629454],[48.034446,40.054097],[45.815788,39.971387],[43.964760,39.360088],[41.778521,37.852723],[39.625330,35.761333],[37.597911,33.244963],[35.788990,30.462655],[34.291293,27.573453],[33.197545,24.736398],[32.600473,22.110536],[32.592800,19.854908],[33.810400,12.389578],[35.376753,6.968609],[38.185000,-0.354412],[40.537174,-6.310910],[41.646876,-10.419496],[41.591066,-13.181905],[41.150142,-14.215086],[40.446700,-15.099872],[39.596044,-15.397877],[38.364793,-15.080630],[35.115506,-12.902140],[31.408834,-9.167913],[27.954770,-4.481462],[25.624705,-1.612323],[24.493691,-0.739520],[23.576880,-0.418962],[22.495621,-0.011943],[22.402306,0.450240],[22.633900,1.043458],[22.816475,1.946878],[21.590730,1.758748],[20.589271,1.671907],[19.394739,2.053332],[18.098715,2.859359],[16.792780,4.046328],[14.322470,6.189595],[12.386670,7.081038],[11.628111,7.431052],[10.602815,8.378329],[8.179539,11.448085],[5.971893,15.057133],[4.834930,17.972298],[4.063716,19.682823],[2.530780,21.606438],[-1.413720,26.534458],[-4.821547,29.954573],[-10.390110,34.171578],[-15.679396,37.917789],[-18.415750,40.206038],[-19.069967,40.800543],[-19.353250,40.474558],[-19.566455,40.203714],[-20.133446,40.191805],[-21.983030,40.890248],[-25.905630,41.899614],[-31.670530,42.364398],[-35.763801,42.286214],[-38.544589,41.627940],[-41.063812,39.920496],[-44.372390,36.694798],[-51.507615,29.073835],[-52.545346,27.521899],[-52.542546,27.174802],[-52.234180,27.061898],[-51.998975,26.959077],[-52.088039,26.692637],[-53.122390,25.831038],[-54.079421,24.967977],[-54.084792,24.699767],[-53.747390,24.594538],[-53.242870,23.862621],[-52.790228,21.932847],[-52.137092,15.951397],[-51.981008,9.593519],[-52.149680,7.193212],[-52.515000,5.802548],[-53.279693,5.776068],[-54.836527,6.508197],[-59.357654,9.528199],[-64.140453,13.422388],[-67.247000,16.750598],[-68.397471,17.866783],[-69.759780,18.331038],[-71.748721,19.184357],[-74.405770,21.235958],[-80.955500,26.379728],[-83.211251,28.391691],[-83.872263,29.474093],[-84.219000,30.589337],[-84.249186,31.723844],[-83.960546,32.864035],[-82.417690,35.107158],[-81.265865,36.857673],[-81.093438,37.678137],[-81.241470,38.321448],[-81.380734,39.211035],[-80.622390,39.581038],[-79.872250,39.964309],[-80.031230,40.885788],[-80.213830,42.273469],[-79.520490,43.777588],[-78.894376,44.853964],[-78.599912,46.200736],[-78.644951,47.847610],[-79.037342,49.824289],[-80.895591,54.885879],[-84.237470,61.623138],[-88.262459,67.083555],[-95.851101,76.441350],[-103.943573,86.004515],[-109.480050,92.081038],[-116.853017,98.687190],[-118.810448,99.953408],[-119.790470,99.996288],[-120.144939,99.957630],[-120.644819,100.317622],[-121.815090,101.973978],[-123.264916,103.815213],[-124.791370,104.581038],[-126.336795,105.009868],[-127.832240,106.040888],[-130.377525,107.687130],[-133.872676,109.047344],[-137.101549,109.748670],[-138.236087,109.735731],[-138.848000,109.418248]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-115.622390,82.344648],[-115.376516,81.227264],[-115.110373,81.078701],[-114.785380,81.251388],[-114.224935,81.181559],[-113.317732,80.372692],[-110.964530,77.084718],[-108.489145,73.550870],[-107.449695,72.475860],[-106.727760,72.081038],[-106.050442,71.745210],[-106.181400,70.937798],[-106.374334,70.007234],[-105.846000,69.375298],[-103.769353,66.411824],[-100.418095,60.092352],[-97.114326,53.067825],[-95.180150,47.989188],[-94.977009,45.458100],[-95.207016,44.508958],[-95.638190,43.946278],[-96.332081,43.055538],[-96.209980,42.020498],[-95.995836,41.283843],[-96.078626,40.361752],[-96.926767,38.310974],[-98.337915,36.567593],[-99.124463,36.029748],[-99.895580,35.831038],[-100.652954,36.033715],[-101.304960,36.574737],[-102.180221,38.269768],[-102.296064,40.112031],[-101.998798,40.837094],[-101.427190,41.297428],[-101.050454,41.532840],[-101.081641,41.740448],[-102.258660,41.982348],[-103.644431,42.393874],[-103.901583,42.785070],[-103.800780,43.244668],[-103.691079,44.312587],[-104.437210,45.246098],[-105.197511,46.351443],[-105.121840,47.832478],[-105.025265,49.067399],[-105.289549,49.443066],[-105.735390,49.581038],[-106.416062,49.947580],[-106.248740,50.828848],[-106.102963,51.532731],[-106.276134,52.526829],[-107.424980,54.856978],[-108.800336,57.442657],[-109.372390,59.754998],[-109.759576,61.379687],[-110.690460,62.312058],[-111.713120,63.247640],[-112.320940,64.880048],[-112.771712,66.613508],[-113.416750,67.792058],[-113.749326,68.920450],[-113.448850,70.533298],[-113.257154,71.800809],[-114.372400,71.456038],[-115.488440,71.124825],[-115.249050,72.500988],[-114.951594,73.970024],[-115.068326,74.416909],[-115.357300,74.581038],[-116.372664,75.993008],[-117.709746,79.294908],[-118.874383,83.085717],[-119.372410,85.964418],[-119.265579,86.521778],[-118.931279,86.686319],[-117.497410,85.831038],[-116.173191,84.165014],[-115.622410,82.344648]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-315.622389,28.565188],[-308.998479,23.642645],[-302.060858,17.358877],[-296.591502,11.463178],[-294.964292,9.207511],[-294.372389,7.704848],[-294.663307,6.885063],[-295.447947,6.299580],[-297.969710,5.831432],[-300.880313,6.300242],[-302.151002,6.885955],[-303.122389,7.705848],[-304.748886,9.030067],[-306.474219,9.580848],[-307.515506,9.948035],[-307.655660,10.345496],[-307.497389,10.830848],[-307.336183,11.316199],[-307.468339,11.713660],[-308.483289,12.080848],[-309.673043,12.598671],[-311.612564,14.008584],[-316.666819,18.643348],[-322.019811,24.308664],[-324.958801,28.146870],[-325.693660,29.668906],[-326.029755,31.079882],[-325.778639,34.029618],[-325.530586,34.375351],[-324.398340,33.925874],[-315.622389,28.564998]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-15.414640,21.503818],[-12.316992,16.864630],[-11.517750,15.221888],[-11.394120,14.343638],[-11.475742,13.628493],[-10.793100,13.331038],[-9.777149,12.768436],[-8.853557,11.226402],[-8.060280,8.923594],[-7.435271,6.078670],[-6.841882,-0.362890],[-6.949411,-3.522210],[-7.377030,-6.349012],[-8.147951,-8.740665],[-9.196559,-10.450363],[-10.528438,-11.478121],[-12.149179,-11.823957],[-14.064367,-11.487888],[-16.279589,-10.469929],[-18.800435,-8.770099],[-21.632490,-6.388412],[-25.358890,-2.738671],[-28.753041,1.021347],[-31.266432,4.243365],[-32.350550,6.279108],[-33.298520,8.955948],[-33.737979,10.267138],[-34.030740,12.300101],[-34.192564,17.680997],[-33.816778,23.397943],[-32.936170,27.750248],[-31.443700,31.877608],[-25.752340,29.764448],[-22.883024,28.454343],[-20.302289,26.719689],[-17.862154,24.442232],[-15.414640,21.503718]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-213.834930,-20.560602],[-214.800563,-21.541530],[-215.714761,-21.577036],[-216.363687,-20.772345],[-216.533500,-19.232682],[-216.365726,-18.146798],[-216.040905,-17.617736],[-215.516494,-17.619057],[-214.749950,-18.124322],[-213.821144,-19.387743],[-213.834930,-20.560602]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-211.182680,-23.856462],[-210.564960,-25.676771],[-210.423940,-26.981462],[-210.013304,-27.643570],[-208.747390,-27.918962],[-207.423171,-28.257976],[-206.872390,-29.073052],[-205.921782,-31.017872],[-203.636280,-34.073052],[-201.566995,-36.789226],[-201.105801,-37.615496],[-201.136280,-37.918962],[-201.233638,-38.107422],[-200.954566,-38.620553],[-199.484000,-40.307352],[-197.145270,-43.403893],[-194.876290,-47.494852],[-192.441736,-51.943021],[-189.704940,-55.898372],[-186.364776,-60.551164],[-183.936872,-65.036291],[-182.722045,-68.682286],[-182.663540,-69.980775],[-183.021110,-70.817682],[-184.059889,-71.405520],[-184.372390,-70.219052],[-184.613036,-69.281221],[-185.268261,-68.169157],[-187.422160,-65.978862],[-189.774321,-63.571443],[-191.146840,-60.999542],[-192.598970,-58.124940],[-195.142530,-54.989742],[-197.162356,-52.633273],[-197.523507,-51.907739],[-197.355340,-51.630952],[-197.097740,-51.515661],[-197.215405,-51.229841],[-198.434890,-50.318842],[-199.979814,-48.886471],[-200.622390,-47.231852],[-200.931847,-45.951498],[-201.675870,-45.418962],[-202.321014,-44.950456],[-203.298834,-43.674820],[-205.721500,-39.481462],[-208.181019,-35.042075],[-209.892570,-32.706422],[-210.822799,-31.449635],[-211.403850,-29.604112],[-212.025794,-27.875558],[-213.054320,-26.899982],[-213.586090,-26.522395],[-213.981149,-25.858088],[-214.345104,-24.084875],[-214.114119,-22.411460],[-213.765504,-21.871902],[-213.256130,-21.668962],[-212.186592,-22.311538],[-211.182680,-23.856462]]);
    }
    linear_extrude(height=h)
      polygon([[-428.121839,55.719188],[-429.188578,54.615127],[-431.667370,53.287614],[-434.477919,52.224838],[-436.539929,51.914988],[-437.126854,51.883381],[-437.456136,51.559572],[-437.298149,50.137588],[-437.185051,49.061565],[-437.606776,47.848114],[-438.552785,46.516847],[-440.012539,45.087378],[-442.261529,42.964149],[-442.772931,42.318256],[-442.755600,42.081038],[-442.599061,41.753472],[-442.731445,40.861585],[-443.734490,37.929718],[-445.905807,31.638689],[-447.425631,25.075008],[-448.127650,19.171859],[-448.120009,16.759604],[-447.845550,14.862428],[-447.237106,10.985500],[-447.254200,7.375678],[-447.252537,5.724339],[-446.906079,3.756028],[-445.419570,-0.144482],[-443.797186,-3.461473],[-443.122390,-5.678192],[-441.651028,-9.747610],[-438.051393,-17.544921],[-433.545164,-26.539350],[-429.354019,-34.200122],[-427.002443,-38.592181],[-426.472364,-39.928258],[-426.497719,-40.418962],[-426.609482,-40.640885],[-426.314673,-41.245132],[-424.736499,-43.231462],[-422.321845,-46.319351],[-420.127699,-49.793962],[-416.350315,-56.283151],[-413.660709,-59.765162],[-402.062589,-73.147572],[-396.458026,-79.387993],[-390.621615,-85.190558],[-384.651802,-90.483028],[-378.647036,-95.193165],[-372.705765,-99.248731],[-366.926434,-102.577488],[-361.407493,-105.107198],[-356.247389,-106.765622],[-351.441750,-108.138207],[-348.664359,-109.311982],[-347.612961,-109.718342],[-346.107169,-109.748670],[-342.202550,-108.843136],[-337.890804,-106.919190],[-334.112229,-104.300642],[-332.136623,-102.322189],[-330.963950,-100.455045],[-330.409085,-98.264362],[-330.286899,-95.315292],[-330.857053,-86.482275],[-331.363832,-82.631857],[-331.883379,-80.418962],[-332.020409,-78.856462],[-332.283062,-78.194351],[-333.122389,-77.918962],[-333.607741,-77.721697],[-334.005202,-77.184587],[-334.372389,-75.418962],[-334.755674,-73.653337],[-335.170560,-73.116228],[-335.677189,-72.918962],[-336.539099,-72.459976],[-336.779079,-71.356462],[-336.621411,-68.675009],[-336.818308,-66.414220],[-337.298673,-64.963689],[-337.622938,-64.664019],[-337.991409,-64.713012],[-338.718140,-64.863955],[-339.378392,-64.333296],[-340.631259,-61.043962],[-341.553492,-59.677042],[-343.311329,-58.145932],[-344.761645,-56.639951],[-345.038310,-55.915615],[-344.944529,-55.333432],[-344.825108,-54.511025],[-345.548619,-54.168962],[-346.483530,-53.618181],[-346.872389,-52.293962],[-347.219542,-50.969743],[-348.054179,-50.418962],[-349.367838,-49.530370],[-350.866679,-47.393972],[-354.649596,-40.699216],[-358.119095,-35.158987],[-360.972178,-31.227216],[-362.905849,-29.357832],[-364.735870,-28.767831],[-366.648095,-28.720258],[-368.551953,-29.159150],[-370.356869,-30.028546],[-371.972272,-31.272482],[-373.307588,-32.834995],[-374.272244,-34.660123],[-374.775669,-36.691902],[-374.886538,-38.993430],[-374.686891,-41.188811],[-374.185989,-43.259736],[-373.393089,-45.187895],[-372.317450,-46.954977],[-370.968331,-48.542672],[-369.354991,-49.932670],[-367.486689,-51.106662],[-365.381394,-52.530324],[-362.977189,-54.662917],[-357.762690,-60.446953],[-352.824478,-67.242885],[-349.143839,-73.834822],[-347.516257,-77.812185],[-346.930229,-79.945072],[-346.658880,-80.759412],[-345.787899,-81.566672],[-345.219623,-82.280180],[-344.631860,-83.629887],[-343.675179,-87.463882],[-343.324057,-90.212581],[-343.455822,-91.848225],[-344.201848,-92.750665],[-345.693509,-93.299752],[-348.461163,-93.396625],[-351.136979,-92.589222],[-353.255971,-91.642188],[-354.684889,-91.403402],[-355.347000,-91.223767],[-355.622389,-90.418962],[-356.121738,-89.536150],[-357.322299,-89.168962],[-358.163083,-88.928286],[-359.195716,-88.272980],[-361.312779,-86.118812],[-363.201409,-84.132082],[-363.986777,-83.658018],[-364.525619,-83.638662],[-365.211165,-83.447740],[-366.395966,-82.506538],[-369.597639,-78.984202],[-377.630469,-69.643772],[-380.959919,-65.857555],[-383.475951,-62.453746],[-385.067222,-59.601928],[-385.622389,-57.471682],[-386.173170,-55.999493],[-387.497389,-54.966932],[-388.821608,-53.927072],[-389.372389,-52.437362],[-389.661389,-51.036605],[-390.356229,-50.210632],[-392.231583,-47.967895],[-395.014050,-43.504696],[-397.478594,-38.930922],[-398.400179,-36.356462],[-398.571179,-35.694351],[-399.372389,-35.418962],[-400.255201,-34.868181],[-400.622389,-33.543962],[-401.368239,-31.473897],[-403.161449,-29.129902],[-405.172683,-26.246597],[-406.442699,-22.879902],[-407.288159,-20.259053],[-407.795393,-19.461780],[-408.278639,-19.168962],[-409.051099,-18.591956],[-409.372389,-17.204672],[-409.926549,-15.263245],[-411.258879,-13.353902],[-412.367469,-11.659560],[-412.530582,-10.862396],[-412.383699,-10.235022],[-412.241571,-9.639776],[-412.417624,-8.930087],[-413.568689,-7.523302],[-415.682437,-3.872367],[-418.856260,3.238927],[-421.767803,10.653991],[-423.094709,15.216238],[-423.208459,16.143538],[-424.181150,21.322732],[-424.705171,27.358140],[-424.712334,32.779084],[-424.134449,36.114888],[-423.170304,37.752283],[-422.085158,38.928551],[-420.813452,39.644799],[-419.289630,39.902133],[-417.448135,39.701661],[-415.223410,39.044492],[-409.362039,36.364488],[-402.707925,32.513963],[-400.331162,30.843412],[-399.039539,29.636998],[-396.848798,27.518433],[-393.747339,25.491308],[-388.638301,21.993106],[-382.700901,16.936769],[-377.928233,12.153419],[-376.601515,10.436340],[-376.313389,9.474178],[-376.437699,9.030317],[-376.253840,8.666834],[-375.118469,8.331038],[-373.464082,7.462170],[-370.365180,5.096440],[-361.607199,-2.680352],[-351.987749,-11.572294],[-345.689928,-16.593931],[-343.361444,-17.936396],[-341.353145,-18.650899],[-339.494958,-18.850642],[-337.616809,-18.648832],[-334.921968,-17.679563],[-334.086705,-16.923425],[-333.602304,-15.970454],[-333.475832,-14.808779],[-333.714354,-13.426527],[-335.314652,-9.952803],[-338.459733,-5.454305],[-343.206132,0.163948],[-349.610386,6.996933],[-357.729029,15.139628],[-371.752699,28.720216],[-381.227270,37.409313],[-386.885025,41.841905],[-388.511436,42.660445],[-389.458249,42.652978],[-389.902803,42.613500],[-390.385710,42.955653],[-391.233559,44.537498],[-392.052599,46.213664],[-392.910759,46.743148],[-394.627066,47.550144],[-397.509309,49.893538],[-400.801755,52.321274],[-402.325118,53.059798],[-403.504289,53.331038],[-405.918304,53.790024],[-408.517059,54.893538],[-410.133116,55.430386],[-412.717034,55.874055],[-419.329609,56.420420],[-425.437104,56.409757],[-427.389671,56.157140],[-428.121839,55.719188]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[358.752610,51.519398],[351.052269,49.834532],[345.677285,47.894027],[343.427803,46.614806],[341.238863,45.015951],[336.348210,40.518378],[333.316623,37.185622],[330.732884,33.646651],[328.597744,29.903537],[326.911951,25.958355],[325.676255,21.813180],[324.891403,17.470084],[324.558145,12.931142],[324.677230,8.198428],[324.814341,1.974898],[324.524808,0.624056],[323.996080,0.441838],[323.515972,0.627141],[323.268359,0.462247],[323.500960,-0.838912],[323.674636,-2.307948],[323.423927,-2.754834],[322.971360,-2.918962],[321.841560,-2.184587],[320.989800,-0.418962],[320.255074,1.346663],[319.406670,2.081038],[317.467444,3.274399],[314.110110,6.143538],[303.911187,15.364221],[295.813428,21.952505],[288.626787,26.798678],[281.161220,30.793028],[276.492814,32.609048],[271.866938,33.710607],[268.143060,33.958768],[266.887955,33.719408],[266.180650,33.214598],[265.318558,32.601229],[264.265050,32.775608],[263.511562,32.774406],[262.702804,31.986472],[261.111478,28.608965],[259.875078,23.760218],[259.377610,18.557358],[259.999821,13.814555],[261.676214,8.444163],[264.121430,3.182303],[267.050110,-1.234902],[267.519319,-2.473750],[267.238920,-2.951129],[266.617280,-3.323722],[265.676868,-3.859421],[266.689080,-4.070272],[269.324377,-5.878268],[273.650415,-9.775517],[277.464721,-13.657317],[278.491701,-14.934703],[278.564820,-15.418962],[278.990441,-16.153337],[280.627650,-17.918962],[282.747544,-19.684587],[284.333670,-20.418962],[285.595280,-21.184787],[286.934950,-23.026022],[288.132204,-24.655402],[288.661286,-24.986188],[289.051410,-24.911862],[289.995735,-24.763502],[291.253380,-25.419562],[295.499937,-27.722636],[302.467993,-30.626245],[309.514982,-33.113862],[313.998340,-34.168962],[315.922563,-34.514400],[316.341769,-34.888318],[316.298410,-35.344922],[316.341041,-35.843295],[317.166236,-36.053483],[320.509063,-35.729511],[325.016373,-34.613409],[329.377650,-32.945582],[331.713417,-31.964660],[333.724969,-31.517385],[335.716261,-31.574106],[337.991250,-32.105172],[340.302284,-32.687846],[341.896975,-32.687860],[343.167628,-32.012787],[344.506550,-30.570202],[345.509477,-29.058894],[346.079588,-27.488751],[346.238755,-25.760874],[346.008850,-23.776362],[345.217538,-20.780195],[344.402450,-19.168962],[343.498570,-17.985036],[342.550188,-15.913108],[341.026650,-10.418962],[339.804700,-4.309586],[338.349350,-0.143152],[337.390859,3.953058],[337.126474,8.913942],[337.536201,13.435616],[337.987610,15.124286],[338.600050,16.214198],[339.627400,17.726795],[340.127650,19.268538],[340.440150,22.514288],[341.847100,25.015420],[344.966450,28.665058],[346.925056,30.392716],[349.287497,31.989836],[354.932275,34.682565],[361.317566,36.523456],[367.860150,37.292718],[401.234863,37.531640],[415.920811,37.242998],[427.067950,36.704198],[436.931341,36.256852],[443.440300,36.712234],[445.572237,37.303851],[447.028009,38.151633],[447.861765,39.265741],[448.127650,40.656338],[447.918098,41.874045],[447.303159,43.008832],[446.303410,44.048980],[444.939425,44.982768],[441.201053,46.484383],[436.252650,47.419918],[427.027750,48.813048],[415.152750,50.268888],[407.765475,51.087347],[402.502650,51.975488],[399.165072,52.487047],[394.264400,52.826212],[381.682150,53.007248],[368.572650,52.558381],[358.752650,51.519398]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[293.013210,7.783048],[301.987326,1.204123],[309.296049,-5.130242],[311.999470,-7.892599],[313.894840,-10.218077],[314.851593,-11.981430],[314.937185,-12.613171],[314.739160,-13.057412],[313.514161,-13.205627],[311.159643,-12.704454],[304.655974,-10.407926],[298.416011,-7.475794],[296.391124,-6.180115],[295.627610,-5.216022],[295.250638,-4.476537],[294.344300,-4.168962],[292.078934,-2.964780],[288.731559,-0.200856],[285.698882,2.849878],[284.737026,4.085006],[284.377610,4.914488],[283.476350,6.458033],[281.309480,8.509628],[279.558205,10.489711],[278.968045,12.462155],[279.109071,13.304647],[279.541202,13.976188],[280.264713,14.420434],[281.279880,14.581038],[285.400888,12.584127],[293.013220,7.783048]]);
    }
    linear_extrude(height=h)
      polygon([[-144.797250,-51.447822],[-145.659217,-52.779139],[-146.481605,-54.719408],[-147.635170,-59.385042],[-147.965718,-62.567073],[-147.716255,-64.607717],[-146.654842,-66.138968],[-144.549540,-67.792822],[-142.538453,-69.086493],[-140.961697,-69.718363],[-139.587483,-69.739743],[-138.184020,-69.201942],[-135.959244,-67.476567],[-134.233960,-65.000792],[-133.063684,-61.881885],[-132.503930,-58.227112],[-132.725150,-55.685162],[-133.615868,-53.465425],[-135.029256,-51.648873],[-136.818486,-50.316475],[-138.836729,-49.549200],[-140.937156,-49.428020],[-142.972939,-50.033904],[-144.797250,-51.447822]]);
    linear_extrude(height=h)
      polygon([[253.840410,-66.571942],[252.941562,-67.911079],[252.101778,-69.780881],[250.975430,-74.121592],[250.745447,-76.836051],[250.971100,-78.871310],[251.748626,-80.587215],[253.174260,-82.343612],[255.870669,-84.475387],[257.250186,-85.048365],[258.626253,-85.291356],[259.980622,-85.203324],[261.295050,-84.783235],[262.551291,-84.030053],[263.731100,-82.942742],[264.567704,-81.707425],[265.284097,-80.077855],[266.246669,-76.325088],[266.399644,-73.062704],[266.104041,-72.046111],[265.523850,-71.668962],[264.714319,-71.139003],[264.377610,-69.864842],[263.620048,-68.164983],[261.777495,-66.297011],[259.495149,-64.788984],[257.418210,-64.168962],[255.788441,-64.874837],[253.840410,-66.571942]]);
  }
}
module CA_Slog(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    difference()
    {
       linear_extrude(height=h)
         polygon([[176.818878,31.789481],[165.150118,30.634861],[156.306190,29.948411],[151.238107,29.189745],[148.081479,27.892923],[144.971918,25.592001],[143.121815,23.935489],[141.987922,22.505126],[141.559435,21.315146],[141.825552,20.379781],[142.775467,19.713263],[144.398378,19.329824],[149.619968,19.469111],[154.165327,19.665600],[155.363795,19.397189],[155.775118,18.891011],[155.573651,18.436179],[155.025103,18.164016],[153.221878,18.251611],[151.431254,18.347906],[151.049361,18.000829],[151.034378,17.399841],[150.832708,16.621254],[150.013249,15.624581],[147.044618,13.490131],[144.330002,11.796391],[143.785511,11.276775],[143.919618,11.080741],[144.353606,10.790773],[143.669088,10.119811],[142.490674,8.465689],[141.737188,5.811231],[141.160081,3.174739],[140.405718,1.563811],[139.663115,0.470006],[139.561736,-0.449167],[140.027802,-0.913764],[140.987538,-0.643839],[141.581636,-0.374559],[141.889661,-0.479576],[141.651768,-1.820069],[141.465381,-3.289105],[141.702337,-3.735990],[142.138118,-3.900119],[142.818393,-4.267306],[142.650118,-5.150119],[142.554563,-6.032931],[143.409678,-6.400119],[144.256004,-6.635850],[144.139308,-7.202609],[144.206274,-7.830257],[145.194647,-8.745336],[149.212198,-11.078774],[154.745116,-13.484901],[160.346558,-15.245699],[165.929240,-16.342743],[170.861268,-16.972005],[174.255774,-17.057369],[175.099309,-16.872303],[175.225888,-16.522719],[175.776192,-16.181144],[177.669671,-15.890441],[184.295738,-15.584759],[199.753988,-15.101639],[205.607868,-14.691619],[205.378988,-5.544459],[205.537702,0.915308],[205.835290,2.880069],[206.240668,3.601291],[206.548614,3.739910],[206.580899,4.118384],[205.867478,5.363591],[205.149113,6.824996],[205.204122,7.419248],[205.546778,7.833761],[205.943243,8.355846],[206.177732,9.255143],[206.089548,11.680481],[205.344589,13.699900],[204.868162,14.159828],[204.396508,14.145391],[204.031431,14.037489],[203.845214,14.242948],[204.054278,15.425881],[204.131141,17.353294],[203.261908,19.240791],[202.398356,20.553774],[202.311640,20.953188],[202.488788,21.099881],[202.585905,21.331948],[202.281271,21.963815],[200.701358,24.040941],[199.139885,25.393513],[196.948902,26.622703],[194.214340,27.688477],[191.022128,28.550801],[180.568878,31.132661],[178.093188,31.743491],[176.818878,31.789481]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[177.547878,22.841141],[178.944307,21.748830],[179.525118,20.188091],[179.444833,19.327059],[179.162671,18.980243],[177.744868,19.771241],[176.671398,20.330516],[175.152831,20.644188],[171.182368,20.490661],[162.337618,19.109611],[159.435678,19.026634],[158.583375,19.297641],[158.275118,19.754001],[158.413090,20.193172],[158.788757,20.452015],[160.023678,20.350431],[161.470574,20.219524],[162.493848,20.847031],[163.022969,21.252788],[163.930212,21.494469],[166.370278,21.411511],[168.641287,21.368406],[169.292270,21.685387],[169.525118,22.204151],[169.737053,22.712986],[170.323385,23.110973],[172.322394,23.550836],[174.928455,23.476605],[177.547878,22.841141]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[183.980088,19.556161],[183.756464,18.267141],[183.329904,18.030968],[182.735148,18.115211],[181.662808,19.103606],[181.219682,20.549695],[181.459684,21.750825],[181.852706,22.039950],[182.436728,22.004341],[183.403637,21.114005],[183.980088,19.556161]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[184.669108,6.232461],[186.200236,3.905990],[186.930831,1.859666],[186.807067,0.404095],[186.407979,-0.005094],[185.775118,-0.150119],[184.892306,-0.627136],[184.525118,-1.774009],[184.187584,-2.526589],[183.268554,-3.375260],[180.247458,-4.944719],[176.221411,-5.876508],[171.894016,-6.159140],[168.437757,-5.803599],[167.402704,-5.389946],[167.025118,-4.820869],[166.660837,-4.291526],[165.785018,-4.519009],[164.263713,-4.684397],[162.347518,-4.005789],[161.115951,-3.090876],[160.990616,-2.803867],[161.240668,-2.688139],[161.545254,-2.530164],[161.568393,-2.128130],[160.824908,-0.835109],[159.783474,1.083265],[159.772337,2.957989],[160.689084,4.718557],[162.431301,6.294464],[164.896575,7.615203],[167.982493,8.610268],[171.586642,9.209152],[175.606608,9.341351],[179.022792,9.115870],[181.444163,8.600701],[183.212382,7.678635],[184.669108,6.232461]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[244.212618,20.864181],[242.890351,20.080344],[240.150118,19.404461],[236.400118,18.607031],[234.129488,17.977641],[231.357649,16.451013],[227.881988,13.385781],[224.875271,10.512921],[223.230868,9.448791],[222.974848,9.120628],[222.836414,8.051342],[222.871892,4.448603],[223.256486,0.158970],[223.909378,-3.299159],[225.254741,-5.614966],[227.759535,-7.885816],[231.202676,-10.023391],[235.363079,-11.939376],[240.019663,-13.545457],[244.951343,-14.753318],[249.937036,-15.474644],[254.755658,-15.621119],[262.207585,-15.008536],[269.078923,-13.786380],[274.988904,-12.042999],[279.556758,-9.866739],[282.980602,-7.926329],[285.113208,-7.084549],[285.805555,-6.804376],[286.537896,-6.087075],[287.960764,-3.692955],[289.058225,-0.605911],[289.506688,2.470331],[288.968407,5.742485],[287.640502,9.397916],[285.999733,12.371943],[285.211011,13.270716],[284.522858,13.599881],[283.275819,14.058864],[281.779008,15.162381],[278.827774,17.395088],[275.379448,19.290224],[272.207497,20.486596],[270.085388,20.623011],[268.806884,20.396265],[268.275118,20.826601],[267.258297,21.205496],[264.574030,21.479192],[256.400341,21.707560],[248.148415,21.504848],[245.366353,21.239695],[244.212618,20.864201]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[257.529528,10.904751],[257.342526,10.286749],[257.770117,9.979433],[260.642898,10.260931],[263.514871,10.542320],[263.943252,10.235544],[263.757208,9.618631],[263.497547,9.042908],[263.591861,8.734333],[264.827618,8.928151],[265.790732,9.041579],[266.885894,8.744676],[268.018806,8.078211],[269.095168,7.082951],[270.481734,4.986526],[270.437362,4.349618],[269.907838,3.961491],[269.385154,3.610499],[269.065152,3.041553],[269.134668,1.564401],[269.197000,0.676275],[268.807096,-0.305164],[266.986963,-2.295220],[264.307046,-3.900243],[261.400118,-4.614709],[258.762341,-4.966401],[255.931078,-5.686119],[253.836262,-6.108694],[253.618288,-5.807416],[253.899968,-5.150369],[254.141878,-4.482666],[253.786694,-4.155340],[251.048728,-4.465019],[249.237874,-4.638310],[247.547673,-4.366422],[246.015355,-3.686485],[244.678153,-2.635630],[243.573297,-1.250988],[242.738018,0.430311],[242.209548,2.371134],[242.025118,4.534351],[242.360946,7.302278],[242.724460,7.982765],[243.168358,8.040861],[244.101514,7.919113],[244.739688,8.618591],[245.225572,9.139817],[246.232066,9.609623],[249.218968,10.188881],[252.080844,10.666258],[252.952004,11.025798],[253.272628,11.412381],[254.030294,12.074489],[255.848888,12.349881],[257.512176,11.970359],[257.734548,11.516476],[257.529528,10.904751]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[39.525118,19.579841],[39.289295,19.240032],[38.647204,19.074444],[36.536478,19.302351],[34.180444,19.435163],[33.272807,19.166650],[32.712718,18.701161],[31.534744,17.746818],[29.875338,17.349881],[28.863244,17.040962],[27.540837,16.207698],[24.514036,13.529105],[21.892830,10.436038],[21.077419,9.084681],[20.775118,8.050431],[21.509493,6.638940],[23.275118,5.139961],[25.040743,3.428448],[25.577852,2.433952],[25.775118,1.505951],[25.989927,0.256888],[26.222445,0.044094],[26.506378,0.164481],[28.166211,0.282336],[31.129978,-0.461139],[33.098068,-1.204359],[33.939369,-1.737529],[33.740033,-2.193366],[32.586208,-2.704589],[30.498532,-3.068775],[28.900118,-2.699589],[28.131608,-2.408630],[27.188928,-2.433953],[25.122116,-3.231491],[23.381805,-4.688291],[22.847251,-5.537691],[22.650118,-6.400439],[22.896700,-7.323928],[23.568087,-8.452317],[25.775118,-10.752589],[28.105304,-12.786464],[29.319378,-14.197869],[29.951314,-14.674067],[30.881878,-14.459449],[31.689291,-14.370691],[32.025118,-15.150119],[32.366936,-15.925885],[33.188738,-15.828509],[34.237694,-15.688119],[35.125618,-16.360489],[35.826931,-16.795887],[37.164832,-17.056502],[40.981778,-16.972989],[45.170941,-16.925279],[46.777443,-17.273864],[47.890178,-17.849359],[49.453871,-18.638461],[50.079588,-18.556866],[50.557888,-18.152909],[51.427392,-17.668577],[53.172246,-17.245411],[58.275118,-16.764769],[64.935369,-16.260225],[70.389721,-15.143279],[74.507119,-13.452372],[76.023505,-12.403697],[77.156508,-11.225949],[78.154992,-9.401389],[78.813401,-6.892922],[79.175990,-3.442244],[79.287018,1.208951],[79.702096,8.771866],[80.151398,11.676123],[80.700058,13.459611],[81.409691,15.329919],[81.401186,15.903249],[81.131588,16.119011],[80.898450,16.221834],[80.989206,16.488278],[82.025118,17.349881],[82.698912,17.933664],[82.549146,18.332315],[79.525118,18.712581],[68.670926,18.730376],[61.087618,17.905711],[59.078110,17.578509],[57.834374,17.637249],[57.201636,18.127190],[57.025118,19.093591],[56.931468,20.078291],[56.563873,20.466743],[55.792366,20.282211],[54.486978,19.547961],[52.359013,18.688605],[51.601564,18.792927],[51.049478,19.253341],[50.247730,19.764164],[48.798340,20.153875],[44.886892,20.543609],[41.175647,20.369834],[39.976511,20.055159],[39.525118,19.579841]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[57.337618,8.673651],[57.999726,8.029085],[58.275118,6.583001],[58.095272,5.625694],[57.456986,5.133234],[56.212141,5.061219],[54.212618,5.365251],[43.900118,7.333561],[43.184966,7.559836],[43.283282,7.854196],[45.278053,8.507216],[48.599904,9.012719],[51.964308,9.090801],[57.337618,8.673651]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[45.775118,-3.677909],[46.258298,-4.038457],[47.573886,-4.260377],[51.898578,-4.217519],[56.503346,-4.247100],[58.048756,-4.563337],[58.838508,-5.050419],[59.037438,-5.551727],[58.872996,-5.805324],[57.509978,-5.548389],[56.179684,-5.297797],[55.971677,-5.510005],[56.112638,-5.934989],[55.964067,-6.423741],[54.923359,-6.793591],[50.604608,-7.084909],[47.615749,-6.942127],[45.472612,-6.549957],[44.025548,-5.863441],[43.124908,-4.837619],[42.634563,-3.791776],[42.577097,-3.118050],[42.971811,-2.757234],[43.838008,-2.650119],[45.206092,-2.952030],[45.775118,-3.677909]]);
    }
    linear_extrude(height=h)
      polygon([[103.692628,19.459301],[102.272355,18.356335],[101.215542,16.772733],[100.531516,14.883804],[100.229601,12.864854],[100.319123,10.891190],[100.809408,9.138118],[101.709781,7.780946],[103.029568,6.994981],[107.542668,5.404261],[109.181422,4.996495],[109.291218,5.314356],[108.964728,5.995331],[108.733534,6.715839],[109.153238,7.161291],[112.197178,7.331101],[118.523422,7.090681],[120.489095,7.226266],[121.820873,7.616139],[122.642061,8.323118],[123.075962,9.410023],[123.275118,12.974881],[122.999726,16.975628],[122.701630,18.214531],[122.337618,18.695511],[118.900118,19.240611],[113.685508,20.016264],[109.375218,20.311801],[106.025506,20.126417],[103.692628,19.459301]]);
    linear_extrude(height=h)
      polygon([[323.743248,17.883361],[320.527864,13.836605],[316.087618,8.986111],[312.335663,4.827074],[310.775118,2.442701],[309.645382,0.700678],[306.929208,-1.914009],[304.516604,-4.214216],[304.018925,-4.925389],[304.116708,-5.200169],[304.246719,-5.366740],[303.836784,-5.783311],[301.712618,-7.115089],[300.351224,-8.041407],[299.261171,-9.150699],[298.537466,-10.323426],[298.275118,-11.440049],[298.545922,-12.764414],[299.778512,-13.505621],[302.603155,-13.829059],[307.650118,-13.900119],[314.499478,-13.543491],[316.370972,-13.126602],[317.025118,-12.576349],[317.392992,-11.868791],[318.277458,-12.026569],[318.854086,-12.099234],[319.498339,-11.724931],[320.675038,-9.912839],[322.435731,-6.955420],[325.060678,-3.900119],[329.580728,0.474881],[332.623338,4.224881],[333.801723,5.419684],[334.487787,5.463624],[335.381791,5.045296],[338.223692,2.541952],[343.187578,-2.650119],[349.408689,-9.638400],[352.006588,-13.275119],[352.636650,-13.764236],[354.367526,-14.136424],[360.265868,-14.410959],[366.385164,-13.949544],[368.301036,-13.431725],[369.472071,-12.704067],[369.911528,-11.752748],[369.632669,-10.563944],[368.648752,-9.123832],[366.973038,-7.418589],[364.361381,-4.800197],[363.275118,-3.247849],[361.806368,-1.318060],[358.275118,2.207781],[354.743868,5.805983],[353.275118,7.909741],[352.632538,9.113773],[351.087618,10.548811],[349.542694,12.075269],[348.900118,13.499111],[348.604833,14.436981],[347.894888,14.795041],[346.562267,15.484216],[344.769888,17.218111],[343.340458,18.407670],[341.242819,19.319886],[338.308303,20.008415],[334.368238,20.526911],[329.627784,20.930670],[326.887908,20.776713],[325.231947,19.836967],[323.743238,17.883361]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[-320.474883,17.818661],[-320.648886,16.862075],[-321.256571,16.360259],[-322.426445,16.270436],[-324.287021,16.549831],[-327.064704,16.792754],[-327.479280,16.446298],[-327.319321,15.768581],[-327.171793,15.360661],[-327.346576,15.391120],[-328.507183,16.651321],[-329.951092,17.994755],[-330.339952,17.957827],[-330.474883,17.435761],[-330.564939,16.765980],[-330.845241,16.481294],[-332.037383,17.052281],[-333.275204,17.562774],[-335.355851,17.949593],[-340.745776,18.328109],[-345.607477,18.139636],[-347.027842,17.817718],[-347.341270,17.335981],[-347.377171,16.961555],[-347.958666,16.724804],[-350.361971,16.742261],[-353.426606,16.578640],[-354.651436,16.108407],[-355.522608,15.417391],[-356.953058,14.388886],[-357.684939,14.259401],[-358.306146,14.429641],[-358.937777,14.566565],[-359.698039,14.346350],[-361.221783,13.019581],[-366.682371,6.584221],[-368.567915,4.327744],[-369.603249,2.512448],[-369.911528,0.816486],[-369.615908,-1.081989],[-369.065863,-3.972662],[-369.020483,-6.087589],[-368.858960,-7.191106],[-368.029683,-7.650089],[-367.108169,-8.043505],[-366.724883,-8.989379],[-366.197891,-10.500995],[-364.904198,-12.106350],[-363.274726,-13.380896],[-361.740396,-13.900089],[-361.007925,-14.329676],[-361.231170,-15.362519],[-361.500304,-15.954887],[-361.400471,-16.265086],[-360.091108,-16.040629],[-359.158451,-15.875192],[-358.129930,-16.004496],[-356.284870,-17.018679],[-354.837321,-18.060475],[-353.831858,-18.090409],[-352.860890,-17.901260],[-351.496296,-18.416369],[-349.361007,-19.032226],[-346.537096,-19.085329],[-343.954697,-19.230845],[-342.981039,-19.579439],[-342.400071,-20.068889],[-341.084646,-21.009052],[-339.077346,-21.400089],[-337.538193,-21.026497],[-337.255106,-20.619945],[-337.368108,-20.120609],[-337.375941,-19.618481],[-336.623586,-19.378069],[-332.875446,-19.685979],[-328.861386,-20.027985],[-328.344462,-19.654252],[-328.613508,-18.878039],[-328.974293,-18.151745],[-328.915919,-17.784167],[-327.452708,-18.062669],[-324.107871,-18.900089],[-323.711160,-19.282346],[-323.510207,-20.332834],[-323.738583,-23.860779],[-324.531833,-28.821469],[-319.378358,-29.645539],[-315.738716,-30.530721],[-314.631524,-31.035946],[-314.224883,-31.501719],[-313.903969,-31.789481],[-313.056928,-31.630151],[-310.478675,-30.380202],[-307.878538,-28.571854],[-307.004143,-27.714525],[-306.644933,-27.025089],[-306.523003,-26.737003],[-306.261749,-26.876651],[-305.474883,-28.275089],[-305.239538,-28.396697],[-305.025153,-27.649762],[-304.668818,-23.722324],[-304.312745,-7.337589],[-304.224885,16.099911],[-309.747648,16.099911],[-313.941723,16.284641],[-316.891833,16.811770],[-318.462672,17.640713],[-318.688582,18.155680],[-318.518935,18.730881],[-318.419365,19.521194],[-319.151110,19.849911],[-320.086026,19.253229],[-320.474885,17.818661]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-327.588608,6.194581],[-327.101333,5.760521],[-327.349883,4.849911],[-327.490256,4.364560],[-327.301370,3.967099],[-326.099883,3.599911],[-324.898395,3.232724],[-324.709509,2.835263],[-324.849883,2.349911],[-325.084774,1.467099],[-324.564658,1.099911],[-324.143009,0.877987],[-323.776894,0.273738],[-323.368283,-1.712589],[-323.447159,-3.239936],[-323.608729,-3.347357],[-323.831445,-2.962589],[-324.614703,-1.859075],[-325.652820,-1.400089],[-326.305530,-1.737674],[-326.162170,-2.549319],[-326.030545,-3.139699],[-326.197217,-3.897629],[-327.278870,-5.525509],[-328.322450,-7.062517],[-328.447909,-7.722087],[-328.265958,-8.192359],[-328.099483,-8.457206],[-328.267059,-8.557477],[-329.449045,-8.255959],[-331.120164,-8.099926],[-332.297220,-8.814899],[-332.948368,-9.372419],[-334.015449,-9.776921],[-336.777580,-10.120409],[-339.343946,-9.832441],[-340.166322,-9.447625],[-340.474883,-8.900099],[-340.795440,-8.413237],[-341.668242,-8.011666],[-344.537383,-7.630969],[-347.348656,-7.351455],[-347.433940,-6.962430],[-346.724883,-6.357199],[-345.822243,-5.640981],[-345.576806,-5.014156],[-346.013192,-4.304377],[-347.156021,-3.339299],[-348.211733,-2.182633],[-348.825593,-0.773984],[-349.030867,0.748466],[-348.860822,2.246530],[-348.348724,3.582024],[-347.527839,4.616762],[-346.431432,5.212559],[-345.092771,5.231231],[-343.489599,5.080498],[-343.392818,5.289800],[-343.794671,5.678961],[-343.699784,5.961179],[-342.691341,6.192693],[-338.657547,6.480576],[-333.140799,6.496555],[-327.588608,6.194571]]);
    }
    linear_extrude(height=h)
      polygon([[-79.950442,18.762611],[-80.198559,18.328973],[-81.370889,17.952023],[-85.729672,17.529971],[-90.625203,16.975040],[-92.295916,16.443833],[-93.183742,15.804771],[-94.020873,13.375553],[-94.142771,10.366780],[-93.599012,7.472216],[-92.439172,5.385621],[-91.073735,4.236198],[-89.972414,3.656006],[-89.409103,3.728569],[-89.657692,4.537411],[-89.473190,4.881535],[-88.541809,5.125481],[-85.043972,5.222871],[-79.027183,5.211635],[-74.833628,5.933286],[-73.318248,6.602865],[-72.135898,7.496370],[-71.245651,8.627369],[-70.606582,10.009431],[-69.927591,12.907215],[-70.042267,15.235086],[-70.908360,16.824313],[-71.609986,17.289205],[-72.483622,17.506161],[-75.908979,17.978061],[-77.454042,18.912411],[-78.508635,19.624974],[-79.498423,19.824196],[-80.090121,19.530076],[-79.950442,18.762611]]);
    linear_extrude(height=h)
      polygon([[-32.107472,18.363461],[-34.030808,17.942973],[-36.588442,18.209221],[-38.617992,18.431951],[-38.936657,18.161040],[-38.778332,17.638641],[-38.866710,16.944275],[-39.777077,16.078215],[-43.619762,14.150881],[-47.428301,12.434594],[-48.439440,11.765060],[-48.635712,11.344061],[-48.589833,10.950390],[-48.941679,10.355250],[-50.582962,8.883521],[-51.756846,7.870970],[-52.425336,6.781436],[-52.625944,5.513148],[-52.396182,3.964331],[-52.255773,1.278753],[-52.531926,0.077581],[-53.012042,-0.819869],[-53.428386,-1.886450],[-52.963467,-3.272522],[-51.487720,-5.199253],[-48.871582,-7.887809],[-44.152477,-12.372076],[-41.093651,-14.939400],[-39.195672,-15.950311],[-37.959112,-15.765339],[-37.087436,-15.640225],[-36.724882,-16.410559],[-36.543787,-16.927101],[-36.033628,-17.209846],[-34.224882,-17.025089],[-32.451787,-16.836511],[-31.919346,-17.076234],[-31.724882,-17.518519],[-30.888981,-17.988452],[-28.654271,-18.289643],[-21.626378,-18.420276],[-13.917112,-17.979383],[-10.830686,-17.566166],[-8.802382,-17.035929],[-6.569511,-16.298235],[-4.427382,-15.911639],[-2.942850,-15.526668],[-1.068127,-14.625966],[3.128621,-11.833115],[6.716320,-8.644573],[7.829732,-7.249258],[8.248428,-6.171829],[8.086150,-5.300424],[7.624668,-4.482595],[6.087618,-3.374769],[2.148589,-3.011065],[-3.273858,-3.399024],[-8.312442,-4.307273],[-10.104260,-4.884202],[-11.099882,-5.504439],[-12.159697,-6.115969],[-14.108772,-6.597145],[-19.849882,-7.025089],[-24.558625,-6.777702],[-27.884351,-6.078932],[-29.641599,-4.993866],[-29.874089,-4.326811],[-29.644912,-3.587589],[-29.578302,-3.223577],[-29.816512,-2.925481],[-31.026112,-2.650089],[-31.880481,-2.387369],[-32.488142,-1.670052],[-32.965427,0.703324],[-32.462155,3.619936],[-31.844118,5.016298],[-30.982512,6.229681],[-29.059069,7.586466],[-28.072157,7.845021],[-27.232512,7.756871],[-25.991243,7.673653],[-25.613644,7.954234],[-25.474962,8.420541],[-25.050824,8.945667],[-23.875178,9.345988],[-19.849962,9.645761],[-15.686723,9.156743],[-14.597341,8.645382],[-14.224962,7.972631],[-13.931652,7.251447],[-13.097947,6.582632],[-10.086711,5.470396],[-5.745962,4.772499],[-0.630412,4.625511],[2.916483,5.016766],[5.738241,5.871239],[7.602034,7.086106],[8.101937,7.796554],[8.275038,8.558541],[8.012625,9.530889],[7.298986,10.689491],[4.959643,13.175991],[2.140233,15.239109],[0.826510,15.868483],[-0.276022,16.099911],[-2.157731,16.473081],[-2.425190,16.926668],[-2.228272,17.546811],[-1.991521,18.148898],[-2.206563,18.470691],[-4.029502,18.288831],[-5.933126,18.039091],[-6.512224,18.156180],[-6.724912,18.428471],[-7.739461,18.800612],[-10.429998,19.061392],[-18.720357,19.254298],[-27.358641,19.018040],[-30.484084,18.742366],[-32.107502,18.363471]]);
    linear_extrude(height=h)
      polygon([[-246.459322,17.662381],[-246.714028,16.203718],[-247.699332,14.013211],[-248.556899,11.792568],[-248.366477,11.186777],[-247.765232,10.821641],[-247.173434,10.471048],[-246.958254,9.909673],[-247.650482,7.974081],[-248.323354,5.495620],[-247.921612,2.834541],[-247.507789,-0.342085],[-248.023112,-4.106239],[-248.796753,-6.417267],[-249.835796,-7.670062],[-251.669401,-8.191441],[-254.826732,-8.308219],[-258.815778,-8.030382],[-260.029262,-7.711450],[-260.474942,-7.315919],[-260.644363,-6.946762],[-261.105658,-6.699630],[-262.622072,-6.657819],[-263.714626,-6.549758],[-264.558658,-5.679896],[-265.255819,-3.871593],[-265.907762,-0.948209],[-266.450869,3.991678],[-266.167266,5.319500],[-265.502182,6.083041],[-264.632697,7.017534],[-264.798568,7.452698],[-265.361882,7.905001],[-266.142094,8.859573],[-266.046562,9.936251],[-265.952278,10.758063],[-266.735412,11.099881],[-267.251954,11.280976],[-267.534699,11.791135],[-267.349942,13.599881],[-267.088774,14.898768],[-267.441958,15.682305],[-268.587452,16.092205],[-270.703212,16.270181],[-279.224942,16.707861],[-282.684597,16.613591],[-284.858872,16.011451],[-285.346985,14.889679],[-285.745367,12.547820],[-286.108872,5.573791],[-286.457213,-1.222710],[-286.851213,-3.210916],[-287.349942,-3.938109],[-287.679022,-4.044262],[-287.650992,-4.305200],[-286.619472,-5.134389],[-285.768775,-5.981834],[-285.105853,-7.384667],[-284.431132,-11.597209],[-283.915773,-15.712155],[-282.968512,-18.156559],[-281.828400,-18.736741],[-279.874523,-19.209097],[-274.778762,-19.766605],[-270.187803,-19.701629],[-268.864929,-19.395882],[-268.583722,-19.167723],[-268.608222,-18.886719],[-268.820928,-18.312576],[-268.678897,-17.924807],[-267.612157,-17.687005],[-265.971067,-18.130534],[-264.318692,-19.212619],[-262.878549,-20.148794],[-262.443556,-19.912234],[-262.086932,-19.205619],[-261.361899,-18.293492],[-260.426912,-18.305599],[-257.324202,-19.064385],[-252.241121,-19.441637],[-246.996360,-19.381511],[-243.408612,-18.828159],[-241.132181,-18.373639],[-240.321042,-18.541278],[-239.807822,-18.969059],[-238.926359,-19.617587],[-237.868182,-19.459919],[-237.217426,-18.643051],[-237.315492,-17.706649],[-237.364572,-17.258746],[-237.031494,-16.794340],[-235.462132,-16.035369],[-233.483296,-15.938940],[-232.214822,-16.619549],[-231.682890,-17.039473],[-230.798314,-17.270672],[-228.463582,-17.103389],[-226.342716,-16.936875],[-225.706962,-17.177359],[-225.474942,-17.613099],[-225.253019,-18.102750],[-224.648772,-18.504672],[-222.662442,-18.879159],[-213.599942,-19.070819],[-207.635916,-18.943804],[-202.220566,-18.333515],[-198.435615,-17.419208],[-197.492580,-16.904065],[-197.362792,-16.380139],[-197.430847,-15.914426],[-197.136784,-15.422025],[-195.682802,-14.591869],[-194.313422,-13.917327],[-193.161336,-12.815980],[-192.219177,-11.261593],[-191.479579,-9.227934],[-190.578607,-3.617865],[-190.399492,4.224091],[-190.893082,12.292559],[-191.316311,14.842862],[-191.796052,15.893351],[-192.440447,16.511775],[-192.312402,17.409851],[-192.686501,17.831000],[-194.206394,18.166568],[-199.712312,18.445091],[-204.991220,18.200269],[-206.699539,17.794156],[-207.926143,17.075491],[-208.775314,15.951714],[-209.351333,14.330263],[-210.101042,9.224091],[-210.553834,2.205550],[-209.732962,-3.765969],[-209.416957,-6.811934],[-209.707652,-7.290886],[-210.307012,-7.129699],[-211.308424,-6.816195],[-211.724942,-7.293049],[-212.119473,-7.696734],[-213.193692,-8.027316],[-216.724942,-8.332719],[-220.256192,-8.048987],[-221.330411,-7.741862],[-221.724942,-7.366819],[-221.971524,-6.991774],[-222.642911,-6.684645],[-224.849942,-6.400909],[-227.013492,-6.125520],[-227.637813,-5.827424],[-227.826922,-5.463409],[-227.826922,-1.014639],[-228.316471,1.435901],[-228.830027,1.800744],[-229.537442,1.614481],[-230.474942,1.245435],[-229.537442,2.415711],[-228.933855,3.468795],[-228.445468,5.091703],[-228.014222,9.161591],[-228.274626,11.856084],[-228.989230,14.086462],[-230.126067,15.834238],[-231.653173,17.080923],[-233.538583,17.808028],[-235.750331,17.997067],[-238.256452,17.629551],[-241.024982,16.686991],[-242.954184,16.293683],[-243.572693,16.557021],[-243.941642,17.124201],[-244.620104,18.096426],[-245.564776,18.573861],[-246.327315,18.460814],[-246.459382,17.661591]]);
    linear_extrude(height=h)
      polygon([[-147.349882,17.704781],[-150.058933,16.395043],[-153.061542,14.085831],[-155.614632,12.232818],[-156.612962,11.887445],[-157.242882,12.019881],[-157.588385,12.242741],[-157.812283,12.143569],[-157.819582,11.099881],[-157.850475,10.078224],[-158.232751,8.772762],[-159.695577,5.879201],[-161.496315,3.556751],[-162.300982,2.965176],[-162.923222,2.942961],[-163.412502,2.921683],[-164.060993,2.441214],[-165.497722,0.432221],[-166.967898,-1.744656],[-168.186112,-2.650089],[-168.919742,-3.200870],[-169.224882,-4.525089],[-169.378653,-5.253116],[-169.797334,-5.849307],[-171.173652,-6.400089],[-172.311154,-6.786511],[-172.471325,-7.204790],[-172.309422,-7.715559],[-172.290690,-8.344564],[-172.854584,-9.072580],[-175.360652,-10.489609],[-177.689615,-11.607375],[-179.037614,-12.714741],[-179.210495,-13.562161],[-178.014102,-13.900089],[-177.597413,-14.039304],[-177.357886,-14.418354],[-177.480372,-15.664389],[-177.423314,-16.545636],[-176.273917,-17.154307],[-173.764815,-17.564895],[-169.628642,-17.851889],[-163.489687,-17.896006],[-161.532293,-17.711160],[-160.706622,-17.407819],[-159.851722,-17.016767],[-158.348552,-17.294439],[-157.035567,-17.438690],[-156.817534,-17.091085],[-156.908782,-16.473339],[-156.689239,-15.419890],[-155.703377,-13.715907],[-152.068032,-9.298089],[-148.495601,-4.894540],[-147.623853,-3.243689],[-147.538982,-2.236459],[-147.856841,-1.449119],[-147.446082,-1.608369],[-146.881090,-1.727875],[-146.029922,-1.437255],[-143.930482,0.144331],[-142.428963,1.570426],[-141.470328,2.068365],[-140.684720,1.656372],[-139.702282,0.352671],[-136.767472,-3.534769],[-135.854551,-4.983712],[-135.474842,-6.347269],[-135.001814,-7.267344],[-133.864542,-7.650029],[-132.882829,-8.076471],[-131.400241,-9.237576],[-127.736712,-13.054439],[-125.023917,-16.129666],[-122.805981,-17.739570],[-120.018485,-18.358014],[-115.597012,-18.458859],[-109.718526,-18.070841],[-108.304814,-17.557033],[-107.787342,-16.804439],[-107.601191,-12.886106],[-107.985723,-12.301843],[-108.763502,-12.287919],[-110.413312,-11.753781],[-112.394742,-10.100419],[-113.638561,-8.369832],[-113.766082,-7.843380],[-113.515002,-7.650029],[-113.412899,-7.354130],[-113.946077,-6.548466],[-116.523412,-3.900029],[-119.160494,-1.251591],[-119.758352,-0.445927],[-119.735242,-0.150029],[-119.748499,0.199933],[-120.445403,1.152800],[-123.408092,4.285141],[-126.633358,7.788661],[-127.974842,9.983911],[-128.308557,10.670081],[-129.110902,10.545381],[-129.789059,10.554473],[-130.795704,11.098251],[-133.251072,13.413441],[-136.041349,15.774751],[-139.586303,17.357776],[-143.488334,18.041492],[-147.349842,17.704871]]);
  }
}
module CO_Stat(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-260.011134,36.439038],[-262.321007,35.286219],[-265.009682,33.435218],[-270.906669,28.248780],[-276.468557,22.099954],[-278.738357,19.045966],[-280.461804,16.208968],[-282.472421,11.347976],[-283.561471,6.355019],[-283.791088,1.304268],[-283.223405,-3.730105],[-281.920556,-8.673927],[-279.944674,-13.453026],[-277.357893,-17.993232],[-274.222346,-22.220371],[-270.600167,-26.060272],[-266.553489,-29.438763],[-262.144446,-32.281671],[-257.435171,-34.514826],[-252.487798,-36.064054],[-247.364460,-36.855184],[-242.127291,-36.814044],[-236.838424,-35.866462],[-232.659946,-34.377258],[-228.596735,-32.269999],[-224.818545,-29.708923],[-221.495126,-26.858265],[-218.796230,-23.882262],[-216.891611,-20.945151],[-215.951018,-18.211169],[-215.895279,-16.971675],[-216.144204,-15.844552],[-217.160169,-14.085952],[-218.613789,-12.875565],[-220.454952,-12.210242],[-222.633541,-12.086832],[-225.099442,-12.502187],[-227.802542,-13.453157],[-230.692724,-14.936592],[-233.719874,-16.949342],[-237.537521,-19.227876],[-241.403966,-20.544443],[-245.248944,-20.981947],[-249.002191,-20.623293],[-252.593442,-19.551386],[-255.952433,-17.849129],[-259.008899,-15.599426],[-261.692576,-12.885184],[-263.933198,-9.789304],[-265.660503,-6.394693],[-266.804224,-2.784253],[-267.294097,0.959109],[-267.059859,4.752491],[-266.031244,8.512988],[-264.137987,12.157695],[-261.309824,15.603708],[-258.394156,18.042592],[-255.208828,19.803602],[-251.763080,20.886581],[-248.066148,21.291368],[-244.127272,21.017804],[-239.955689,20.065731],[-235.560637,18.434988],[-230.951354,16.125418],[-225.489473,13.173443],[-223.677530,12.409542],[-222.289103,12.109388],[-221.182331,12.264748],[-220.215352,12.867390],[-218.133324,15.381588],[-216.557962,17.889067],[-216.003213,19.985574],[-216.458938,22.103113],[-217.914994,24.673688],[-219.378724,26.568120],[-221.162997,28.354096],[-225.551828,31.561171],[-230.798790,34.215903],[-236.621186,36.239281],[-242.736318,37.552295],[-248.861490,38.075932],[-254.714005,37.731184],[-260.011164,36.439038]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[-190.121684,34.573468],[-194.347144,32.295148],[-198.108129,29.556912],[-201.397702,26.412317],[-204.208926,22.914919],[-206.534864,19.118276],[-208.368578,15.075946],[-209.703133,10.841485],[-210.531589,6.468451],[-210.847012,2.010402],[-210.642462,-2.479107],[-209.911003,-6.946516],[-208.645698,-11.338270],[-206.839610,-15.600811],[-204.485802,-19.680581],[-201.577335,-23.524024],[-198.107274,-27.077582],[-193.566809,-30.745487],[-188.962254,-33.594757],[-184.276738,-35.628235],[-179.493389,-36.848764],[-174.595338,-37.259186],[-169.565712,-36.862344],[-164.387641,-35.661082],[-159.044254,-33.658242],[-154.459458,-31.248240],[-150.395802,-28.343507],[-146.860013,-25.004915],[-143.858815,-21.293337],[-141.398936,-17.269643],[-139.487099,-12.994705],[-138.130031,-8.529395],[-137.334457,-3.934585],[-137.107103,0.728855],[-137.454695,5.400052],[-138.383958,10.018134],[-139.901617,14.522231],[-142.014399,18.851471],[-144.729029,22.944981],[-148.052232,26.741890],[-151.990734,30.181328],[-156.000642,32.737588],[-160.534926,34.755856],[-165.439463,36.218377],[-170.560133,37.107400],[-175.742813,37.405173],[-180.833379,37.093944],[-185.677710,36.155959],[-190.121684,34.573468]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-163.957134,18.804378],[-161.603662,17.446143],[-159.466463,15.642126],[-157.575594,13.447273],[-155.961116,10.916533],[-154.653086,8.104852],[-153.681563,5.067177],[-153.076606,1.858457],[-152.868274,-1.466362],[-153.404559,-4.828012],[-154.898291,-8.262858],[-157.176788,-11.610191],[-160.067367,-14.709299],[-163.397346,-17.399471],[-166.994042,-19.519998],[-170.684772,-20.910169],[-174.296854,-21.409272],[-178.158371,-20.908622],[-181.966182,-19.501429],[-185.578148,-17.329835],[-188.852129,-14.535977],[-191.645987,-11.261996],[-193.817582,-7.650030],[-195.224774,-3.842219],[-195.725424,0.019298],[-195.305937,3.774202],[-194.026814,7.394364],[-191.857067,10.944208],[-188.765704,14.488158],[-185.973731,16.979097],[-183.133183,18.905576],[-180.224191,20.271052],[-177.226886,21.078981],[-174.121397,21.332822],[-170.887856,21.036030],[-167.506391,20.192063],[-163.957134,18.804378]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[-56.439704,34.780068],[-61.113287,32.389832],[-65.294139,29.584816],[-68.973884,26.412128],[-72.144147,22.918875],[-74.796553,19.152164],[-76.922724,15.159103],[-78.514286,10.986800],[-79.562862,6.682360],[-80.060077,2.292893],[-79.997555,-2.134496],[-79.366919,-6.552698],[-78.159795,-10.914606],[-76.367807,-15.173113],[-73.982578,-19.281111],[-70.995732,-23.191493],[-67.398894,-26.857152],[-64.283079,-29.475888],[-61.130695,-31.739633],[-57.948950,-33.648480],[-54.745047,-35.202521],[-51.526193,-36.401850],[-48.299594,-37.246559],[-45.072454,-37.736742],[-41.851979,-37.872491],[-38.645376,-37.653899],[-35.459848,-37.081059],[-32.302603,-36.154064],[-29.180844,-34.873006],[-26.101779,-33.237980],[-23.072612,-31.249077],[-20.100548,-28.906390],[-17.192794,-26.210012],[-12.949436,-21.430292],[-9.679398,-16.541413],[-7.379845,-11.525904],[-6.047944,-6.366291],[-5.680863,-1.045101],[-6.275766,4.455138],[-7.829821,10.151900],[-10.340194,16.062658],[-12.145420,19.327938],[-14.191988,22.353566],[-16.458926,25.131027],[-18.925259,27.651805],[-21.570014,29.907383],[-24.372218,31.889246],[-27.310896,33.588878],[-30.365076,34.997764],[-33.513782,36.107387],[-36.736043,36.909232],[-40.010883,37.394782],[-43.317329,37.555523],[-46.634408,37.382937],[-49.941146,36.868510],[-53.216570,36.003726],[-56.439704,34.780068]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-28.875614,14.488158],[-26.467404,11.728320],[-24.593468,8.839808],[-23.235641,5.864944],[-22.375756,2.846051],[-21.995647,-0.174547],[-22.077145,-3.154527],[-22.602086,-6.051567],[-23.552302,-8.823342],[-24.909627,-11.427531],[-26.655893,-13.821809],[-28.772936,-15.963854],[-31.242586,-17.811343],[-34.046679,-19.321952],[-37.167048,-20.453359],[-40.585525,-21.163240],[-44.283944,-21.409272],[-47.112351,-20.959531],[-50.424014,-19.734989],[-53.806673,-17.922665],[-56.848064,-15.709582],[-60.118063,-12.457203],[-62.147553,-9.142995],[-63.183869,-5.179861],[-63.474344,0.019298],[-63.237915,3.570171],[-62.555633,6.847229],[-61.468011,9.833529],[-60.015560,12.512130],[-58.238791,14.866091],[-56.178215,16.878471],[-53.874345,18.532327],[-51.367691,19.810719],[-48.698764,20.696705],[-45.908077,21.173343],[-43.036141,21.223693],[-40.123466,20.830812],[-37.210565,19.977760],[-34.337948,18.647594],[-31.546128,16.823374],[-28.875614,14.488158]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[238.748606,35.876348],[235.452316,34.886688],[231.794368,33.448159],[228.220138,31.753702],[225.175006,29.996258],[222.403428,27.697372],[219.599791,24.512247],[216.887878,20.672696],[214.391468,16.410535],[212.234344,11.957579],[210.540288,7.545642],[209.433081,3.406540],[209.036506,-0.227912],[209.461917,-3.748099],[210.646756,-7.891876],[212.453925,-12.405685],[214.746331,-17.035970],[217.386877,-21.529175],[220.238468,-25.631743],[223.164009,-29.090117],[226.026406,-31.650742],[229.479934,-33.670036],[233.643881,-35.306105],[238.301815,-36.534244],[243.237306,-37.329751],[248.233921,-37.667920],[253.075231,-37.524048],[257.544802,-36.873430],[261.426206,-35.691362],[264.292429,-34.321301],[267.009695,-32.659748],[269.566445,-30.730203],[271.951121,-28.556168],[276.158021,-23.568627],[279.537931,-17.885132],[281.998387,-11.693688],[283.446927,-5.182302],[283.791088,1.461022],[283.520131,4.773409],[282.938406,8.048278],[281.594164,12.169031],[279.492604,16.390651],[276.783110,20.545842],[273.615068,24.467306],[270.137862,27.987750],[266.500876,30.939875],[262.853496,33.156386],[259.345106,34.469988],[249.512706,36.767638],[247.558438,36.947252],[244.877543,36.839088],[238.748606,35.876348]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[258.377306,16.750918],[261.370813,14.565228],[263.804709,12.049907],[265.695773,9.269894],[267.060787,6.290129],[267.916529,3.175554],[268.279781,-0.008891],[268.167321,-3.198266],[267.595931,-6.327630],[266.582389,-9.332042],[265.143477,-12.146562],[263.295975,-14.706249],[261.056662,-16.946162],[258.442318,-18.801362],[255.469724,-20.206907],[252.155660,-21.097858],[248.516906,-21.409272],[241.240416,-20.982080],[238.435839,-20.381081],[236.068268,-19.462251],[234.048627,-18.180917],[232.287838,-16.492408],[230.696824,-14.352050],[229.186506,-11.715172],[227.706425,-8.479903],[226.661441,-5.339241],[226.051568,-2.292343],[225.876818,0.661636],[226.137204,3.523542],[226.832738,6.294217],[227.963435,8.974508],[229.529306,11.565258],[232.362612,15.010566],[235.467890,17.665907],[238.819538,19.526678],[242.391956,20.588276],[246.159542,20.846102],[250.096696,20.295552],[254.177818,18.932024],[258.377306,16.750918]]);
    }
    linear_extrude(height=h)
      polygon([[-125.634464,32.637278],[-126.043128,28.928371],[-126.277484,21.118770],[-126.154964,-2.226622],[-125.659744,-18.945401],[-124.855766,-28.937661],[-124.248904,-32.027572],[-123.457947,-34.175324],[-122.447259,-35.627408],[-121.181204,-36.630312],[-118.394549,-37.826263],[-117.166974,-37.927161],[-116.046457,-37.687113],[-115.030418,-37.098948],[-114.116275,-36.155494],[-112.583348,-33.174036],[-111.427025,-28.685370],[-110.626650,-22.632127],[-110.161571,-14.956938],[-110.011134,-5.602432],[-110.011134,18.818068],[-97.756344,19.537728],[-93.259376,19.986812],[-89.474193,20.760040],[-86.409117,21.850841],[-84.072467,23.252646],[-82.472564,24.958888],[-81.617727,26.962996],[-81.516277,29.258403],[-82.176534,31.838538],[-82.783767,32.920771],[-83.766042,33.791436],[-85.239846,34.471264],[-87.321663,34.980993],[-93.775275,35.573085],[-104.058754,35.733588],[-113.442989,35.560226],[-119.979744,35.013264],[-123.949933,34.052386],[-125.060349,33.404131],[-125.634464,32.637278]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[7.250806,34.156728],[6.525797,33.148940],[5.895039,30.867211],[4.917495,23.193514],[4.320615,12.558810],[4.106843,0.386270],[4.278623,-11.900932],[4.838398,-22.879625],[5.788611,-31.126636],[6.410895,-33.781019],[7.131706,-35.218792],[8.091419,-35.840728],[9.637151,-36.398692],[14.309918,-37.299337],[20.796504,-37.873995],[28.743406,-38.075932],[39.250884,-37.904543],[42.876207,-37.591458],[45.740556,-37.038917],[48.087404,-36.181021],[50.160227,-34.951872],[54.457706,-31.116222],[57.456907,-27.566110],[59.641374,-23.771758],[61.008876,-19.799734],[61.557181,-15.716607],[61.284057,-11.588945],[60.187274,-7.483316],[58.264601,-3.466289],[55.513806,0.395568],[49.610206,7.411608],[55.966706,17.017018],[58.905921,21.828892],[60.454431,25.430376],[60.724752,28.216616],[59.829406,30.582758],[57.982898,33.034671],[56.083640,34.550035],[54.086952,35.110680],[51.948156,34.698438],[49.622572,33.295140],[47.065521,30.882618],[44.232325,27.442703],[41.078306,22.957228],[36.643552,16.728769],[32.686923,12.092448],[29.243300,9.056552],[26.347568,7.629369],[25.116062,7.521634],[24.034609,7.819184],[23.107571,8.523056],[22.339307,9.634284],[21.296545,13.082957],[20.941206,18.173488],[20.718404,23.026625],[20.055077,27.081776],[18.958847,30.330044],[17.437331,32.762531],[15.498149,34.370341],[13.148921,35.144575],[10.397267,35.076337],[7.250806,34.156728]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[45.941206,-15.456892],[45.842596,-16.829935],[45.494254,-17.935381],[44.817410,-18.808574],[43.733293,-19.484859],[40.028163,-20.388078],[33.748706,-20.927792],[27.372545,-21.129229],[23.497343,-20.671530],[22.268492,-20.126777],[21.389948,-19.334767],[20.317206,-16.899012],[19.841631,-14.632390],[19.800985,-12.861822],[20.289096,-11.539760],[21.399793,-10.618654],[23.226904,-10.050953],[25.864257,-9.789109],[33.945006,-9.992792],[40.111948,-10.529842],[43.758693,-11.433590],[44.828368,-12.110140],[45.497645,-12.982964],[45.843074,-14.086925],[45.941206,-15.456892]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[73.798406,32.876448],[73.144224,31.821759],[72.571120,30.057903],[71.675718,24.475081],[71.127360,16.272771],[70.941206,5.595758],[70.941206,-18.827812],[80.096406,-28.451862],[85.047863,-33.273780],[89.186743,-36.213370],[91.189360,-37.104664],[93.274304,-37.678224],[98.071806,-38.075932],[102.373029,-37.819433],[106.492290,-37.068219],[110.379028,-35.849722],[113.982681,-34.191369],[117.252686,-32.120589],[120.138484,-29.664812],[122.589511,-26.851467],[124.555206,-23.707982],[125.493177,-21.369934],[126.276133,-18.359080],[127.390085,-10.748964],[127.923225,-1.737646],[127.901718,7.814858],[127.351728,17.048535],[126.299420,25.103371],[124.770957,31.119354],[123.836345,33.094020],[122.792506,34.236468],[120.843080,35.139096],[119.002306,35.363447],[117.306675,34.943736],[115.792681,33.914179],[114.496814,32.308990],[113.455568,30.162383],[112.705434,27.508574],[112.282906,24.381778],[111.610906,16.090728],[110.596431,15.397370],[107.977256,14.829570],[104.150356,14.445921],[99.512706,14.305018],[92.640410,14.430134],[90.524942,14.723762],[89.105043,15.293423],[88.242052,16.230604],[87.797307,17.626794],[87.607906,22.162158],[87.448957,25.015315],[86.988534,27.618219],[86.251272,29.930748],[85.261806,31.912784],[84.044771,33.524206],[82.624802,34.724894],[81.026536,35.474728],[79.274606,35.733588],[78.032216,35.508142],[76.585593,34.894304],[73.798406,32.876448]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[111.090606,-4.490202],[112.629846,-5.800141],[113.140631,-7.423545],[112.622152,-9.803304],[111.073606,-13.382312],[109.875612,-15.449080],[108.437286,-17.196257],[106.802454,-18.628665],[105.014941,-19.751127],[103.118576,-20.568465],[101.157182,-21.085502],[97.214618,-21.237962],[95.321100,-20.883031],[93.537858,-20.247089],[91.908721,-19.334959],[90.477513,-18.151463],[89.288062,-16.701424],[88.384192,-14.989664],[87.809732,-13.021006],[87.608506,-10.800272],[88.074781,-6.616285],[88.579493,-4.980636],[89.195806,-3.948962],[90.633774,-3.217994],[93.039146,-2.729943],[99.559556,-2.453115],[106.371940,-3.059520],[109.142281,-3.675512],[111.091206,-4.490202]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[142.846006,32.876448],[142.148716,31.501577],[141.544399,28.974273],[140.614681,21.120901],[140.056849,10.633397],[139.870906,-1.171172],[140.056849,-12.975742],[140.614681,-23.463246],[141.544399,-31.316618],[142.148716,-33.843921],[142.846006,-35.218792],[145.101745,-36.341486],[149.117818,-37.248487],[154.374260,-37.854926],[160.351106,-38.075932],[167.771485,-37.817301],[173.582243,-36.939146],[178.429757,-35.288077],[182.960406,-32.710702],[187.213146,-29.434850],[190.856549,-25.790568],[193.893723,-21.836986],[196.327774,-17.633230],[198.161809,-13.238429],[199.398934,-8.711711],[200.042255,-4.112204],[200.094881,0.500964],[199.559916,5.068665],[198.440468,9.531772],[196.739644,13.831156],[194.460549,17.907690],[191.606292,21.702245],[188.179977,25.155693],[184.184713,28.208907],[179.623606,30.802758],[174.977273,32.655448],[169.740663,34.086932],[164.215934,35.080174],[158.705243,35.618136],[153.510747,35.683782],[148.934604,35.260074],[145.278971,34.329975],[142.846006,32.876448]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[178.267206,12.107208],[180.855363,9.266498],[182.809065,6.517777],[184.137881,3.795467],[184.851381,1.033989],[184.959133,-1.832236],[184.470709,-4.868785],[183.395676,-8.141238],[181.743606,-11.715172],[180.264340,-14.293801],[178.700360,-16.406818],[176.981419,-18.091761],[175.037268,-19.386171],[172.797659,-20.327587],[170.192345,-20.953550],[163.603606,-21.409272],[156.655506,-21.409272],[156.655506,-1.171172],[156.655506,19.066918],[163.981506,19.066918],[167.632749,18.637089],[171.216681,17.340731],[174.754449,15.167540],[178.267206,12.107208]]);
    }
  }
}
module CO_Back(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-333.678186,141.601469],[-333.207823,138.981726],[-333.304115,137.116297],[-333.969340,135.996244],[-335.205776,135.612629],[-336.349019,135.464042],[-336.646470,135.045882],[-336.094657,134.342853],[-334.690106,133.339659],[-332.957665,132.546979],[-331.467019,132.552576],[-330.153518,133.375554],[-328.952516,135.035019],[-328.168580,136.792794],[-327.979372,138.190081],[-328.383552,139.211769],[-329.379776,139.842749],[-330.296567,140.452511],[-330.850320,141.465268],[-330.997848,142.740140],[-330.695966,144.136249],[-330.414994,145.463235],[-330.619531,146.549926],[-331.257876,147.284178],[-332.278326,147.553849],[-333.435472,147.172746],[-334.057345,146.041543],[-334.139674,144.178398],[-333.678186,141.601469]]);
    linear_extrude(height=h)
      polygon([[-381.258276,98.795439],[-383.799214,96.332452],[-384.027869,95.574224],[-383.465416,95.285089],[-382.040698,95.451379],[-380.498528,95.938786],[-377.532964,97.545849],[-375.510986,99.444062],[-375.148298,100.295408],[-375.374856,100.971209],[-376.239837,101.200280],[-377.637434,100.866413],[-379.374597,100.041002],[-381.258276,98.795439]]);
    linear_extrude(height=h)
      polygon([[-358.465416,97.694369],[-358.279697,96.709667],[-357.774025,95.684753],[-356.111736,93.999279],[-355.281795,93.699487],[-354.832835,94.012149],[-354.789390,94.878484],[-355.175996,96.239709],[-356.357729,98.688772],[-357.414271,99.798158],[-357.841974,99.826759],[-358.174031,99.491985],[-358.465416,97.694369]]);
    linear_extrude(height=h)
      polygon([[-544.103990,85.053849],[-544.321265,83.436009],[-544.856874,82.111138],[-545.630210,81.215955],[-546.560664,80.887179],[-547.485143,80.699307],[-548.242212,80.187774],[-548.753744,79.430707],[-548.941616,78.506229],[-548.768196,77.581752],[-548.296011,76.824684],[-547.597179,76.313152],[-546.743814,76.125279],[-545.279256,75.514694],[-542.916285,73.852211],[-536.800202,68.387179],[-529.054392,60.649089],[-527.130962,67.791939],[-526.501678,70.938040],[-526.210144,74.223911],[-526.270590,77.260214],[-526.697248,79.657609],[-527.572730,82.100902],[-527.939360,82.664983],[-528.305225,82.775934],[-529.174585,81.594184],[-530.460661,78.467129],[-531.781167,75.317046],[-532.804875,74.087969],[-533.324098,74.157396],[-533.911522,74.663378],[-535.480847,76.926749],[-541.127800,85.260089],[-542.715410,87.316414],[-543.596225,87.977493],[-543.986875,87.228323],[-544.103990,85.053899]]);
    linear_extrude(height=h)
      polygon([[227.416224,74.339559],[227.605893,68.307236],[228.016114,64.896771],[228.314214,64.133295],[228.679790,63.975557],[229.629824,65.410989],[230.571090,68.299549],[231.243423,71.761514],[231.781289,79.223891],[231.646822,82.633417],[231.243423,85.434579],[230.571090,87.331934],[230.134073,87.849358],[229.629824,88.030039],[229.148832,87.755597],[228.709431,86.966858],[227.988956,84.054014],[227.535515,79.706564],[227.416224,74.339559]]);
    linear_extrude(height=h)
      polygon([[-383.189256,76.720519],[-385.997476,68.982419],[-386.310414,67.794743],[-386.023561,67.546551],[-383.767216,69.824539],[-381.808984,72.054878],[-381.189460,72.473220],[-380.767866,72.382226],[-380.393071,70.537875],[-380.433806,66.253119],[-380.894156,61.487981],[-381.263106,60.718793],[-381.670466,61.244329],[-382.269764,62.527465],[-383.062037,63.427250],[-384.027703,63.944583],[-385.147177,64.080366],[-386.400878,63.835497],[-387.769222,63.210879],[-390.771506,60.825989],[-392.208539,58.978745],[-392.942582,57.097920],[-393.016712,55.266215],[-392.474007,53.566331],[-391.357546,52.080967],[-389.710405,50.892826],[-387.575662,50.084606],[-384.996396,49.739009],[-378.708592,49.295319],[-372.427906,48.503509],[-369.543384,48.274228],[-367.313409,48.665094],[-365.697312,49.691090],[-364.654426,51.367199],[-364.167367,53.155867],[-364.439016,54.168354],[-365.537607,54.470104],[-367.531376,54.126559],[-369.209599,54.009874],[-370.462025,54.561596],[-371.277823,55.653606],[-371.646160,57.157787],[-371.556203,58.946022],[-370.997120,60.890194],[-369.958079,62.862186],[-368.428246,64.733879],[-366.262998,67.550689],[-365.793976,68.744023],[-365.723704,69.724167],[-366.044443,70.438761],[-366.748455,70.835446],[-367.828002,70.861865],[-369.275346,70.465659],[-370.727562,70.114504],[-371.809391,70.275652],[-372.446530,70.914546],[-372.564676,71.996629],[-372.340069,76.139892],[-372.984421,78.890006],[-373.660218,79.795475],[-374.586568,80.416069],[-377.235346,80.887179],[-379.092452,80.558403],[-380.834047,79.663222],[-382.264770,78.338354],[-383.189256,76.720519]]);
    linear_extrude(height=h)
      polygon([[-303.667066,78.417659],[-304.056521,76.968256],[-305.091226,75.727427],[-306.613438,74.827042],[-308.465416,74.398969],[-310.314376,74.446938],[-311.828515,74.842821],[-312.851582,75.520480],[-313.227326,76.413779],[-313.418262,77.217346],[-313.938136,77.650738],[-314.707551,77.685143],[-315.647106,77.291749],[-316.723710,76.411441],[-317.208284,75.494579],[-317.126057,74.566714],[-316.502255,73.653397],[-315.362106,72.780177],[-313.730836,71.972606],[-309.095846,70.656609],[-306.532910,70.449332],[-303.938557,70.753639],[-301.428921,71.500741],[-299.120135,72.621846],[-297.128332,74.048164],[-295.569646,75.710904],[-294.560210,77.541276],[-294.216156,79.470489],[-294.414906,80.200991],[-294.930242,80.262692],[-295.683774,79.687226],[-296.597106,78.506229],[-297.915887,76.720517],[-298.941606,76.125279],[-299.967325,76.720517],[-301.286106,78.506229],[-302.527303,80.277973],[-303.241129,80.857388],[-303.572683,80.239074],[-303.667066,78.417629]]);
    linear_extrude(height=h)
      polygon([[-418.465425,73.268129],[-416.947570,72.018136],[-415.608285,71.601472],[-414.268998,72.018136],[-412.751136,73.268129],[-411.635066,74.652058],[-411.506718,75.148711],[-411.679710,75.530037],[-412.974354,75.991349],[-415.608286,76.125279],[-418.242213,75.991349],[-419.536854,75.530037],[-419.709845,75.148711],[-419.581496,74.652058],[-418.465425,73.268129]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[145.106014,71.363369],[145.515853,69.466891],[145.462833,67.958036],[144.973895,66.961372],[144.075984,66.601469],[143.089202,66.783446],[142.281116,67.278928],[141.735115,68.012240],[141.534584,68.907709],[141.252776,69.695022],[140.485478,70.133888],[139.349875,70.193597],[137.963154,69.843439],[136.576437,69.140878],[135.440834,68.241088],[134.673533,67.259906],[134.391724,66.313169],[133.816101,64.960249],[132.248814,62.873137],[127.096724,57.635309],[124.630878,55.084102],[122.831229,52.504498],[121.703527,50.010092],[121.253520,47.714482],[121.486959,45.731265],[122.409593,44.174038],[124.027171,43.156397],[126.345444,42.791939],[130.001651,41.985712],[134.089274,40.047329],[136.647405,39.090362],[139.413140,39.129213],[142.218915,40.034899],[144.897163,41.678439],[147.280319,43.930852],[149.200818,46.663156],[150.491095,49.746369],[150.983584,53.051509],[151.193271,55.604375],[151.715223,57.415596],[152.485294,58.348928],[153.439344,58.268129],[154.616864,57.673166],[155.363876,57.607588],[155.681432,58.067376],[155.570585,59.048513],[154.067888,62.558754],[150.864204,68.106159],[147.297159,73.419397],[145.047561,75.790407],[144.464094,75.845829],[144.266737,75.133596],[145.106014,71.363369]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[145.106014,59.458609],[144.310897,58.537010],[143.233774,57.787776],[142.015973,57.287836],[140.798824,57.114119],[139.893207,57.294665],[139.723040,57.774523],[140.274705,58.510302],[141.534584,59.458609],[144.279222,61.121365],[145.720670,61.675617],[145.984887,61.537054],[145.961933,61.121365],[145.106014,59.458609]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[136.820444,48.686789],[137.869149,47.157023],[138.498138,45.674464],[138.658780,44.408386],[138.302444,43.528059],[137.708468,43.147369],[137.222049,43.241686],[136.893384,43.772512],[136.772674,44.701349],[136.490866,45.642754],[135.723569,46.207798],[134.587969,46.352758],[133.201254,46.033909],[131.689135,45.710776],[130.567465,46.027733],[129.869832,46.961698],[129.629824,48.489589],[129.778201,50.076931],[130.202747,51.219482],[130.872584,51.916397],[131.756836,52.166828],[132.824626,51.969929],[134.045075,51.324852],[136.820444,48.686779]]);
    }
    linear_extrude(height=h)
      polygon([[293.915534,71.224229],[294.253527,69.282972],[295.189749,67.469949],[296.607564,65.856743],[298.390338,64.514936],[300.421434,63.516107],[302.584217,62.931839],[304.762052,62.833713],[306.838304,63.293309],[308.661926,64.188342],[309.858324,65.165465],[310.455983,66.134064],[310.483386,67.003522],[309.969019,67.683223],[308.941365,68.082552],[307.428908,68.110893],[305.460134,67.677629],[303.052392,67.063689],[301.702481,67.149964],[301.297350,67.996544],[301.723944,69.663519],[302.005298,71.277294],[301.545455,72.645121],[300.372041,73.725586],[298.512684,74.477279],[296.388409,74.790776],[294.964358,74.388543],[294.165182,73.217416],[293.915534,71.224229]]);
    linear_extrude(height=h)
      polygon([[-218.570876,70.870829],[-219.032481,68.757006],[-219.143487,66.037099],[-218.511570,59.873734],[-217.070859,54.570148],[-216.170872,52.924962],[-215.217086,52.315749],[-214.786847,52.509525],[-214.420384,53.064890],[-213.900884,55.104631],[-213.702777,58.123445],[-213.870256,61.809809],[-214.749080,68.255885],[-215.885646,72.030772],[-216.522370,72.862133],[-217.189673,72.960433],[-217.876270,72.303916],[-218.570876,70.870829]]);
    linear_extrude(height=h)
      polygon([[550.419194,66.838939],[549.143863,63.971341],[547.730794,61.619302],[546.351925,60.025802],[545.179194,59.433819],[544.553334,59.143243],[543.712614,58.320045],[541.533656,55.305777],[538.936442,50.850995],[536.215094,45.415679],[532.866153,38.821617],[529.822144,34.233764],[526.849609,31.362677],[525.317190,30.480469],[523.715094,29.918909],[520.449900,28.689905],[518.497186,27.094704],[517.770504,25.296683],[518.183406,23.459217],[519.649444,21.745682],[522.082170,20.319453],[525.395136,19.343907],[529.501894,18.982419],[531.786002,19.558772],[534.867406,21.128048],[538.342355,23.450578],[541.807094,26.286689],[549.867894,33.590969],[542.129794,32.049889],[538.496231,31.516082],[536.059144,31.564034],[534.796931,32.135187],[534.687994,33.170979],[535.710731,34.612852],[537.843544,36.402244],[541.064831,38.480597],[545.352994,40.789349],[549.424790,43.026421],[553.113048,45.436505],[556.300202,47.897159],[558.868681,50.285936],[560.700919,52.480392],[561.679345,54.358083],[561.686393,55.796563],[561.288910,56.312836],[560.604494,56.673389],[559.766033,57.160104],[559.281581,57.885814],[559.186811,58.752457],[559.517394,59.661969],[559.840995,60.507489],[559.727206,61.199894],[559.214586,61.667735],[558.341694,61.839559],[557.362669,62.038520],[556.560944,62.580244],[556.019244,63.381993],[555.820294,64.361029],[556.026222,65.212797],[556.586919,65.668011],[557.416753,65.696859],[558.430094,65.269529],[559.456658,64.896543],[560.114006,65.237863],[560.375823,66.254609],[560.215794,67.907899],[559.507794,70.286425],[558.500041,71.930592],[557.268614,72.848702],[555.889594,73.049056],[554.439061,72.539955],[552.993097,71.329701],[551.627781,69.426595],[550.419194,66.838939]]);
    linear_extrude(height=h)
      polygon([[-297.972256,65.318349],[-297.540081,62.745162],[-296.848656,60.468854],[-295.940292,58.537880],[-294.857299,57.000696],[-293.641988,55.905757],[-292.336670,55.301520],[-290.983656,55.236438],[-289.625256,55.758969],[-288.502405,56.771396],[-287.714130,58.147298],[-287.258349,59.787936],[-287.132980,61.594568],[-287.335942,63.468454],[-287.865153,65.310854],[-288.718532,67.023026],[-289.893996,68.506229],[-291.657186,70.022371],[-293.292412,70.957028],[-294.756027,71.327424],[-296.004382,71.150783],[-296.993831,70.444331],[-297.680724,69.225291],[-298.021416,67.510889],[-297.972256,65.318349]]);
    linear_extrude(height=h)
      polygon([[-565.332090,62.313409],[-565.066619,58.091691],[-564.554659,56.209176],[-563.739118,54.384668],[-561.045009,50.627004],[-556.679712,46.253359],[-550.110744,40.582233],[-547.951258,39.065980],[-546.524232,38.425929],[-545.816514,38.659576],[-545.814950,39.764416],[-547.877669,44.577659],[-550.294219,50.292197],[-551.032696,52.879082],[-551.307900,54.836869],[-551.612781,56.723946],[-552.406523,58.883449],[-554.814498,63.109326],[-556.105679,64.720499],[-557.239624,65.693695],[-558.054808,65.801312],[-558.389705,64.815749],[-558.610960,63.386152],[-559.134034,62.442927],[-559.876004,61.968375],[-560.753948,61.944797],[-561.684945,62.354493],[-562.586073,63.179763],[-563.374409,64.402909],[-563.967031,66.006229],[-564.411611,67.003907],[-564.817174,66.640216],[-565.332090,62.313409]]);
    linear_extrude(height=h)
      polygon([[-422.255853,63.621689],[-423.705710,60.212318],[-424.757554,56.672496],[-425.408735,53.182542],[-425.656604,49.922774],[-425.498512,47.073512],[-424.931807,44.815073],[-423.953840,43.327776],[-422.561961,42.791939],[-421.588203,43.270940],[-421.083508,44.652874],[-421.060048,46.855144],[-421.529992,49.795149],[-421.912596,52.919310],[-421.815183,56.241568],[-421.276623,59.367790],[-420.335789,61.903839],[-418.694803,65.798319],[-418.420325,67.207750],[-418.586392,67.992279],[-419.180042,67.951522],[-420.069771,67.113897],[-422.255853,63.621689]]);
    linear_extrude(height=h)
      polygon([[7.105724,66.447829],[7.276890,65.117174],[6.609894,63.327427],[5.230743,61.312871],[3.265444,59.307789],[0.834426,56.728325],[-1.812761,53.149853],[-4.356448,49.045510],[-6.476966,44.888429],[-9.373640,38.283147],[-10.554899,34.820848],[-10.556485,33.951359],[-10.194304,33.487265],[-8.465416,33.268129],[-7.540939,33.520717],[-6.783871,34.208454],[-6.272338,35.226304],[-6.084466,36.469229],[-5.615016,38.258024],[-4.336809,40.762153],[-2.445060,43.649583],[-0.134986,46.588279],[2.190141,49.556196],[4.122893,52.523187],[5.461792,55.145069],[6.005364,57.077659],[6.162371,58.487456],[6.442171,59.054664],[6.851516,58.782181],[7.397154,57.672899],[8.190134,56.106514],[9.025187,55.140917],[9.856759,54.750121],[10.639291,54.908137],[11.327229,55.588977],[11.875017,56.766653],[12.237097,58.415176],[12.367914,60.508559],[12.099832,62.868065],[11.369908,64.996149],[10.289618,66.659331],[8.970444,67.624129],[7.718881,67.963732],[6.961425,67.862281],[6.742298,67.347679],[7.105724,66.447829]]);
    linear_extrude(height=h)
      polygon([[71.903464,60.645059],[71.576836,58.060301],[71.640838,55.990939],[72.039244,54.479168],[72.715826,53.567182],[73.614357,53.297174],[74.678608,53.711338],[75.852353,54.851869],[77.079364,56.760959],[78.052601,59.039676],[78.256648,60.915142],[77.676214,62.529102],[76.296014,64.023299],[74.660342,65.063884],[74.024608,65.149588],[73.484825,64.925996],[72.616765,63.492200],[71.903464,60.645059]]);
    linear_extrude(height=h)
      polygon([[-364.417806,61.839559],[-362.679142,60.158014],[-361.605929,59.646482],[-360.565336,59.458609],[-359.756970,59.646482],[-359.316047,60.158014],[-359.272409,60.915082],[-359.655896,61.839559],[-361.394555,63.521113],[-362.467768,64.032647],[-363.508356,64.220519],[-364.316728,64.032647],[-364.757654,63.521113],[-364.801293,62.764042],[-364.417806,61.839559]]);
    linear_extrude(height=h)
      polygon([[120.106014,60.649089],[120.380890,58.126766],[120.678426,57.359467],[121.041754,57.077659],[122.105199,58.126766],[123.347984,60.649089],[123.698141,62.035806],[123.638433,63.171409],[123.199567,63.938710],[122.412254,64.220519],[121.516785,63.938710],[120.783473,63.171409],[120.287991,62.035806],[120.106014,60.649089]]);
    linear_extrude(height=h)
      polygon([[311.162604,62.638709],[309.773206,61.870585],[309.084827,61.038409],[309.019677,60.214717],[309.499966,59.472048],[310.447904,58.882939],[311.785699,58.519928],[313.435563,58.455552],[315.319704,58.762349],[317.054427,59.409414],[318.279095,60.256322],[318.881205,61.193218],[318.748254,62.110249],[317.617570,63.419412],[316.160476,63.931052],[314.100859,63.664406],[311.162604,62.638709]]);
    linear_extrude(height=h)
      polygon([[511.772594,61.839559],[511.400214,60.915082],[511.474056,60.158014],[511.959667,59.646482],[512.822594,59.458609],[513.801634,59.646482],[514.603394,60.158014],[515.145128,60.915082],[515.344094,61.839559],[515.035656,63.521113],[514.294094,64.220519],[513.120306,63.521113],[511.772594,61.839559]]);
    linear_extrude(height=h)
      polygon([[47.428064,57.077659],[48.644944,49.562469],[49.020780,49.050517],[50.018728,48.811873],[53.274584,49.201839],[54.886685,49.918072],[55.961531,50.987598],[56.518128,52.272092],[56.575479,53.633227],[56.152590,54.932677],[55.268466,56.032117],[53.942113,56.793219],[52.192534,57.077659],[50.870094,57.312499],[49.574519,57.951913],[48.454564,58.898248],[47.658984,60.053849],[47.202902,60.739766],[47.007334,60.407271],[47.428034,57.077659]]);
    linear_extrude(height=h)
      polygon([[83.686914,60.341119],[83.471960,59.835813],[83.566549,59.105784],[84.547787,57.113586],[86.357485,54.648572],[88.722501,51.994788],[94.025917,47.257101],[96.418031,45.741291],[98.272894,45.172899],[99.430252,45.407739],[100.228994,46.047153],[100.597251,46.993488],[100.463154,48.149089],[99.811799,49.304686],[98.771681,50.251022],[97.486033,50.890439],[96.098084,51.125279],[94.602944,51.547991],[93.025478,52.698938],[91.553482,54.402341],[90.374754,56.482419],[88.676910,59.776908],[87.102924,61.456683],[86.312408,61.719883],[85.492892,61.614001],[83.686914,60.341119]]);
    linear_extrude(height=h)
      polygon([[-404.564536,55.887179],[-404.914695,54.500463],[-404.854987,53.364859],[-404.416119,52.597558],[-403.628796,52.315749],[-402.733329,52.597558],[-402.000020,53.364859],[-401.504542,54.500463],[-401.322566,55.887179],[-401.597439,58.409503],[-401.894975,59.176802],[-402.258306,59.458609],[-403.321755,58.409503],[-404.564536,55.887179]]);
    linear_extrude(height=h)
      polygon([[-260.846376,54.696709],[-260.630316,52.668032],[-260.022200,51.241272],[-259.082124,50.500563],[-257.870186,50.530039],[-256.714585,51.165738],[-255.768250,52.163228],[-255.128835,53.385791],[-254.893996,54.696709],[-255.128835,56.007627],[-255.768250,57.230189],[-256.714585,58.227677],[-257.870186,58.863369],[-259.082124,58.892845],[-260.022200,58.152138],[-260.630316,56.725381],[-260.846376,54.696709]]);
    linear_extrude(height=h)
      polygon([[-60.846366,55.065729],[-60.475053,53.024017],[-59.464050,50.712268],[-57.967765,48.414362],[-56.140606,46.414179],[-53.089016,42.966656],[-52.372275,41.575590],[-52.360296,40.658149],[-52.446459,39.609416],[-51.996960,37.860879],[-49.823866,33.238259],[-46.362016,27.315749],[-47.836916,33.268129],[-50.403057,41.694094],[-53.705072,50.209998],[-56.878945,56.800358],[-58.147822,58.743620],[-59.060656,59.449689],[-59.754014,59.106566],[-60.321814,58.165614],[-60.705462,56.770710],[-60.846366,55.065729]]);
    linear_extrude(height=h)
      polygon([[-42.695086,55.795139],[-43.699270,52.245708],[-44.028776,49.144829],[-43.790138,48.514830],[-43.252057,48.855628],[-41.596676,52.066189],[-40.263921,56.372131],[-40.075094,57.898618],[-40.262986,58.716499],[-40.748025,58.779110],[-41.368257,58.249183],[-42.695086,55.795139]]);
    linear_extrude(height=h)
      polygon([[-17.393986,50.674579],[-17.311681,47.279749],[-16.908044,45.909271],[-16.512263,45.936524],[-15.947993,46.413899],[-14.196446,48.644389],[-12.529347,51.780597],[-12.208144,53.207009],[-12.219357,54.477477],[-12.556128,55.545888],[-13.211594,56.366131],[-14.178897,56.892092],[-15.451176,57.077659],[-16.205535,56.572416],[-16.823287,55.196753],[-17.240687,53.160774],[-17.393986,50.674579]]);
    linear_extrude(height=h)
      polygon([[27.787274,45.054619],[27.274595,36.701673],[26.778523,33.742804],[26.098519,31.538618],[25.216500,30.046324],[24.114385,29.223131],[22.774090,29.026250],[21.177534,29.412889],[19.798834,29.541793],[18.469319,28.951261],[17.323531,27.739265],[16.496014,26.003779],[15.445963,23.967321],[13.770909,22.517891],[11.463650,21.651302],[8.516984,21.363369],[5.790801,21.163421],[3.177610,20.619006],[0.974049,19.813270],[-0.523246,18.829359],[-1.889033,17.891787],[-3.346885,17.775451],[-4.968168,18.494316],[-6.824246,20.062349],[-8.527826,21.474688],[-10.381581,22.535461],[-12.161724,23.141990],[-13.644466,23.191599],[-14.390165,23.328584],[-15.341721,23.968838],[-17.705909,26.556527],[-20.424048,30.549412],[-23.183156,35.542239],[-26.352676,41.532366],[-28.611157,44.856881],[-29.464630,45.592300],[-30.169388,45.748637],[-30.751781,45.354998],[-31.238156,44.440489],[-31.671922,42.619916],[-31.692724,40.686478],[-31.322104,38.871043],[-30.581606,37.404479],[-29.694111,35.816917],[-28.923262,33.672033],[-28.062176,28.835039],[-27.683845,26.343760],[-26.870680,23.717698],[-25.742228,21.269354],[-24.418036,19.311229],[-20.605042,13.793288],[-16.987619,6.833598],[-14.287726,0.007631],[-13.507467,-2.862871],[-13.227326,-5.109141],[-12.859892,-7.137736],[-11.833883,-8.990163],[-10.263740,-10.605956],[-8.263904,-11.924651],[-5.948815,-12.885781],[-3.432916,-13.428881],[-0.830646,-13.493486],[1.743554,-13.019131],[4.312975,-11.837614],[7.415213,-9.800121],[10.659431,-7.192702],[13.654794,-4.301411],[16.932027,-1.168295],[19.881605,0.816319],[22.602570,1.702574],[25.193964,1.540609],[29.216315,1.040296],[32.950588,1.479719],[35.701226,2.682718],[36.490321,3.515507],[36.772674,4.473129],[36.101734,5.355602],[34.274918,6.540172],[28.269674,9.195769],[23.704195,10.660539],[20.530984,11.056099],[19.249357,10.840739],[18.055250,10.343452],[15.582204,8.483599],[12.037650,5.809108],[10.500800,4.995519],[9.391724,4.696709],[8.264821,4.381765],[6.679431,3.524244],[2.975324,0.705349],[0.886396,-0.902929],[-0.937715,-1.701989],[-2.508594,-1.694536],[-3.837826,-0.883271],[-4.748855,0.467431],[-5.149119,2.064389],[-5.090685,3.776195],[-4.625617,5.471439],[-3.805982,7.018712],[-2.683845,8.286604],[-1.311271,9.143707],[0.259674,9.458609],[2.254388,9.915784],[5.459090,11.152811],[13.920856,15.159429],[22.489764,19.864485],[25.828393,21.974559],[28.010604,23.653999],[28.943228,25.683983],[29.751769,29.502163],[30.849446,40.055536],[31.009328,50.418957],[30.645623,53.999700],[30.336765,55.122124],[29.937104,55.697269],[29.553780,55.689841],[29.185562,55.217138],[28.529714,53.050512],[28.040104,49.546602],[27.787274,45.054619]]);
    linear_extrude(height=h)
      polygon([[246.908134,53.423429],[240.858441,49.682606],[238.107706,47.451915],[235.529961,44.970836],[230.864185,39.226910],[226.802604,32.389619],[224.751087,27.806460],[223.725348,24.218703],[223.662268,21.671440],[223.972000,20.802085],[224.498726,20.209764],[225.234558,19.900113],[226.171604,19.878768],[228.617783,20.723544],[231.774142,22.789183],[235.577564,26.120779],[238.815040,29.478286],[241.466254,32.645912],[243.257615,35.267159],[243.915534,36.985529],[244.306333,38.563043],[245.370390,40.800767],[248.868224,46.065139],[252.129080,50.983186],[252.802272,52.745852],[252.847715,54.005207],[252.273216,54.731946],[251.086582,54.896766],[249.295619,54.470362],[246.908134,53.423429]]);
    linear_extrude(height=h)
      polygon([[448.829704,43.287889],[448.402603,35.289628],[447.141208,28.100416],[444.809672,20.766845],[441.172154,12.335509],[438.180472,6.358255],[435.582946,1.890672],[433.658085,-0.636477],[433.034936,-1.037776],[432.684394,-0.792431],[432.503006,0.685722],[432.735350,2.607881],[433.330449,4.725274],[434.237324,6.789129],[435.281198,9.111804],[436.039704,11.559079],[436.691860,16.292004],[436.581135,18.309941],[436.176291,19.917053],[435.475140,20.979481],[434.475494,21.363369],[433.382446,20.987626],[432.104488,19.964563],[430.800615,18.450428],[429.629824,16.601469],[427.971019,14.207410],[426.075763,12.625623],[424.058857,11.835382],[422.035099,11.815962],[420.119288,12.546636],[418.426224,14.006679],[417.070707,16.175366],[416.167534,19.031969],[415.336094,22.452759],[414.425763,24.979815],[413.495027,26.597680],[412.602369,27.290897],[411.806273,27.044009],[411.165224,25.841558],[410.737706,23.668087],[410.582204,20.508139],[410.192280,13.644886],[409.254804,8.769859],[409.020317,7.145815],[409.363130,5.281027],[410.209975,3.405817],[411.487584,1.750509],[413.264531,-0.298333],[413.857095,-2.063916],[413.265403,-4.082368],[411.489584,-6.889821],[409.973402,-8.626541],[408.165165,-10.075151],[406.263129,-11.178764],[404.465546,-11.880496],[402.970672,-12.123462],[401.976761,-11.850778],[401.682067,-11.005559],[402.284844,-9.530921],[402.927887,-7.672982],[403.059476,-5.254426],[402.754421,-2.524400],[402.087533,0.267951],[401.133620,2.873478],[399.967494,5.043037],[398.663965,6.527479],[397.297844,7.077659],[395.984593,6.821188],[394.909145,6.122873],[394.182487,5.089367],[393.915604,3.827319],[393.518442,2.060367],[392.437063,-0.347892],[390.836621,-3.080843],[388.882274,-5.821871],[387.041634,-8.420156],[385.750831,-10.764439],[385.127727,-12.597469],[385.290184,-13.661991],[385.649617,-14.462802],[385.562851,-15.577807],[385.065839,-16.859411],[384.194534,-18.160021],[383.641619,-19.017441],[383.449392,-19.859372],[383.641425,-20.712500],[384.241294,-21.603512],[386.758833,-23.605939],[391.190604,-26.080151],[396.440963,-28.639993],[399.426779,-29.579492],[400.312824,-29.458520],[400.923544,-28.952752],[401.706754,-26.813881],[402.325649,-25.189558],[402.697804,-24.946345],[403.129889,-25.096008],[404.228233,-26.614699],[405.729444,-29.827101],[407.001927,-32.381279],[408.203988,-34.014714],[409.204919,-34.596011],[409.589115,-34.451045],[409.874014,-33.993771],[410.734125,-32.838174],[412.259079,-31.891838],[414.233380,-31.252421],[416.441534,-31.017581],[418.988885,-30.775300],[421.219603,-30.077330],[423.099763,-28.966980],[424.595440,-27.487558],[425.672709,-25.682373],[426.297646,-23.594732],[426.436326,-21.267945],[426.054824,-18.745321],[425.746002,-16.101275],[426.072026,-13.383927],[426.993825,-10.760578],[428.472324,-8.398531],[430.552014,-6.027736],[431.161420,-5.685290],[431.514183,-5.989598],[431.540732,-8.792832],[430.813564,-14.946151],[430.398305,-19.337427],[430.358354,-22.933501],[430.676573,-25.363279],[430.964640,-26.024842],[431.335824,-26.255671],[433.129415,-25.801552],[434.920941,-24.529638],[436.637328,-22.575586],[438.205505,-20.075057],[439.552399,-17.163710],[440.604936,-13.977205],[441.290046,-10.651202],[441.534654,-7.321361],[441.722526,-3.572456],[442.234059,-0.281371],[442.991127,2.196618],[443.915604,3.506229],[444.464690,3.594475],[444.941312,3.173010],[445.676826,1.024477],[446.121473,-2.492308],[446.274583,-6.930286],[445.703500,-16.781573],[444.977965,-21.300762],[443.958204,-24.952901],[442.616511,-27.505790],[440.691876,-29.910391],[438.441423,-31.896319],[436.122274,-33.193191],[431.790796,-35.361271],[429.983932,-36.720295],[428.391985,-38.290101],[425.779844,-42.144430],[423.808374,-47.089011],[423.452392,-49.201106],[423.721266,-50.844130],[424.473183,-51.981655],[425.566330,-52.577252],[426.858895,-52.594493],[428.209066,-51.996948],[429.475030,-50.748190],[430.514974,-48.811791],[431.885197,-47.045405],[434.585055,-44.922581],[438.224170,-42.710288],[442.412164,-40.675501],[450.261735,-36.796813],[452.985911,-35.072750],[454.385824,-33.793301],[454.780071,-31.619605],[454.766039,-27.460703],[453.614394,-15.578031],[452.521858,-6.532561],[452.409629,-3.243829],[452.641813,-0.426246],[453.259700,2.183830],[454.304583,4.850037],[457.840494,11.405409],[461.990706,19.445328],[463.202637,22.614078],[463.833900,25.180674],[463.880579,27.119106],[463.338761,28.403363],[462.204531,29.007435],[460.473974,28.905309],[459.258517,28.898382],[459.113678,29.683496],[460.042543,31.269993],[462.048204,33.667219],[463.968832,36.247291],[465.705416,39.416448],[467.178870,42.887092],[468.310108,46.371627],[469.020044,49.582454],[469.229592,52.231975],[468.859667,54.032593],[468.432688,54.524689],[467.831184,54.696709],[466.934079,54.275916],[466.085130,53.130193],[465.380041,51.434523],[464.914514,49.363889],[464.236278,46.660021],[463.149266,44.782848],[461.739727,43.724619],[460.093909,43.477582],[458.298061,44.033983],[456.438432,45.386069],[454.601270,47.526089],[452.872824,50.446289],[448.982044,58.268129],[448.829664,43.287889]]);
    linear_extrude(height=h)
      polygon([[-289.417796,52.740899],[-287.975362,48.611954],[-284.507396,41.431379],[-281.481710,36.224123],[-280.905513,35.728671],[-281.102706,36.839559],[-283.929776,48.149089],[-284.505562,50.231041],[-285.286830,52.027722],[-287.117831,54.474114],[-287.993572,54.978245],[-288.726810,54.905946],[-289.230550,54.184428],[-289.417796,52.740899]]);
    linear_extrude(height=h)
      polygon([[-529.743078,47.249379],[-529.520111,44.410348],[-528.730866,41.130059],[-527.491692,37.639813],[-525.918935,34.170908],[-524.128943,30.954644],[-522.238063,28.222320],[-520.362644,26.205236],[-518.619031,25.134689],[-517.091819,24.479112],[-515.569759,23.459915],[-512.394011,20.142727],[-508.797611,14.807262],[-504.486385,7.077659],[-503.268168,5.026094],[-502.268350,3.840344],[-501.590263,3.607754],[-501.337238,4.415669],[-501.685136,6.279061],[-502.643266,8.920282],[-505.803931,15.129959],[-507.671543,18.904908],[-509.443858,23.695252],[-510.920777,28.886302],[-511.902200,33.863369],[-512.706375,38.254647],[-513.700690,41.850724],[-514.758753,44.280507],[-515.272193,44.942070],[-515.754172,45.172899],[-516.622005,44.985027],[-517.332686,44.473493],[-517.812875,43.716422],[-517.989236,42.791939],[-518.308096,41.376930],[-519.166842,40.564941],[-520.418724,40.309753],[-521.916988,40.565146],[-523.514885,41.284899],[-525.065662,42.422795],[-526.422567,43.932611],[-527.438850,45.768129],[-528.399494,47.898535],[-529.099296,48.852684],[-529.544932,48.634868],[-529.743078,47.249379]]);
    linear_extrude(height=h)
      polygon([[-363.227326,47.834879],[-363.039454,46.794291],[-362.527921,45.721078],[-360.846376,43.982419],[-359.921893,43.598932],[-359.164822,43.642571],[-358.653289,44.083494],[-358.465416,44.891859],[-358.653289,45.932452],[-359.164822,47.005666],[-360.846376,48.744329],[-361.770853,49.127817],[-362.527921,49.084177],[-363.039454,48.643251],[-363.227326,47.834879]]);
    linear_extrude(height=h)
      polygon([[390.541614,47.873379],[389.930289,46.589059],[389.644325,45.322653],[389.698023,44.220053],[390.105684,43.427149],[390.906623,42.865208],[391.682636,42.738882],[392.390754,42.990207],[392.988006,43.561224],[393.678043,45.430485],[393.408994,47.882969],[392.831679,49.243501],[392.235400,49.695617],[391.509073,49.238909],[390.541614,47.872969]]);
    linear_extrude(height=h)
      polygon([[-258.412466,47.113609],[-258.238329,45.351564],[-257.678408,43.235298],[-255.770077,38.666464],[-253.425196,34.859834],[-252.319587,33.696321],[-251.381486,33.268129],[-249.673886,33.792687],[-249.166530,34.360490],[-248.994566,35.053849],[-249.416140,36.326370],[-250.485352,38.218859],[-253.703220,42.758059],[-256.921236,46.460095],[-257.990633,47.306127],[-258.295987,47.356963],[-258.412466,47.113609]]);
    linear_extrude(height=h)
      polygon([[-248.941606,45.427629],[-248.690877,44.582747],[-247.992587,43.719059],[-245.576716,42.097336],[-242.340773,40.886599],[-238.931536,40.410989],[-238.122214,40.664929],[-237.939060,41.385782],[-238.373709,42.512096],[-239.417796,43.982419],[-240.755726,45.303269],[-242.270518,46.331580],[-245.392702,47.444118],[-246.781105,47.495115],[-247.908386,47.187110],[-248.665052,46.503486],[-248.941606,45.427629]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[-217.296536,44.930019],[-218.433688,42.970227],[-219.091322,39.931931],[-219.255309,35.936096],[-218.911516,31.103689],[-217.647776,20.172899],[-222.580416,25.793809],[-225.210031,28.650909],[-226.710731,29.751382],[-227.137115,29.666464],[-227.400524,29.170688],[-227.597416,26.984289],[-227.776012,25.004978],[-227.987790,24.584855],[-228.305579,24.555311],[-229.332256,25.700618],[-231.002186,28.506229],[-234.322566,34.458609],[-236.719276,28.506229],[-238.456265,25.176614],[-239.019166,24.844118],[-239.266876,25.530039],[-239.536654,26.843173],[-240.120729,27.763105],[-240.911142,28.294804],[-241.799934,28.443243],[-242.679145,28.213393],[-243.440817,27.610225],[-243.976991,26.638710],[-244.179706,25.303819],[-243.780070,23.013867],[-242.661976,20.860321],[-240.946642,18.918576],[-238.755290,17.264026],[-236.209138,15.972063],[-233.429407,15.118082],[-230.537317,14.777476],[-227.654086,15.025639],[-224.447238,15.441624],[-221.861404,15.289693],[-219.923618,14.575028],[-218.660916,13.302809],[-217.481303,11.761778],[-215.825757,10.237441],[-211.528040,7.468723],[-206.650114,5.456408],[-204.269306,4.877575],[-202.074326,4.660249],[-197.971961,3.933026],[-194.179706,2.235729],[-192.447587,0.901407],[-191.946485,-0.164024],[-192.710804,-1.240516],[-194.774946,-2.608021],[-196.415581,-3.740734],[-197.640636,-4.922432],[-198.441316,-6.091466],[-198.808821,-7.186188],[-198.734356,-8.144951],[-198.209121,-8.906108],[-197.224321,-9.408010],[-195.771156,-9.589011],[-194.508942,-9.122328],[-192.876008,-7.799856],[-188.771277,-3.053003],[-184.003555,3.720630],[-179.119436,11.590124],[-174.665511,19.624563],[-171.188373,26.893027],[-169.234614,32.464598],[-168.999812,34.323137],[-169.350826,35.408359],[-170.383714,35.400452],[-172.126967,34.320933],[-174.337120,32.357215],[-176.770706,29.696709],[-182.744396,22.553849],[-181.273826,29.101469],[-180.837519,31.818842],[-180.883834,33.785779],[-181.362707,34.998651],[-182.224077,35.453828],[-183.417882,35.147679],[-184.894058,34.076575],[-186.602544,32.236885],[-188.493276,29.624979],[-190.736011,26.419587],[-192.283535,25.142587],[-192.956773,25.185477],[-193.648424,25.660356],[-195.343256,27.839269],[-198.077770,32.928982],[-200.575876,39.214179],[-201.965571,43.243738],[-202.486965,44.310946],[-202.973052,44.774059],[-203.484082,44.653795],[-204.080300,43.970868],[-205.769296,40.999889],[-206.967821,38.247589],[-207.408399,35.760986],[-207.096183,33.343175],[-206.036326,30.797249],[-205.151114,28.525808],[-204.660389,25.927838],[-204.598202,23.323701],[-204.998606,21.033759],[-205.992115,18.723866],[-207.063233,17.683914],[-208.172815,17.847847],[-209.281715,19.149607],[-210.350788,21.523137],[-211.340888,24.902378],[-212.212869,29.221275],[-212.927586,34.413769],[-213.785491,40.805367],[-214.704410,44.459444],[-215.231378,45.367333],[-215.827154,45.719747],[-216.509590,45.559653],[-217.296536,44.930019]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-195.370176,11.839559],[-194.997776,10.915082],[-195.071604,10.158014],[-195.557207,9.646482],[-196.420136,9.458609],[-197.399176,9.646482],[-198.200925,10.158014],[-198.742647,10.915082],[-198.941606,11.839559],[-198.633186,13.521113],[-197.891656,14.220519],[-196.717867,13.521113],[-195.370176,11.839559]]);
    }
    linear_extrude(height=h)
      polygon([[-95.009486,38.877659],[-97.020676,33.894842],[-97.951196,30.093279],[-97.857292,27.010141],[-96.795206,24.182599],[-95.746103,21.855090],[-94.971154,19.391601],[-94.261296,14.606938],[-94.335177,12.560888],[-94.700791,10.929108],[-95.362532,9.849161],[-96.324796,9.458609],[-97.505088,10.303329],[-99.133017,12.603308],[-100.993742,16.007278],[-102.872416,20.163969],[-104.742846,24.321366],[-106.581087,27.727254],[-108.175738,30.030073],[-109.315396,30.878259],[-109.980468,30.552987],[-110.282950,29.660637],[-110.208780,28.337663],[-109.743896,26.720519],[-108.217305,21.854444],[-106.810586,16.006229],[-106.347887,12.768932],[-106.625940,10.764213],[-107.079013,10.146422],[-107.760791,9.743598],[-109.868486,9.458609],[-112.425761,9.144397],[-113.026292,8.780227],[-113.217422,8.303433],[-112.499487,7.088226],[-110.527972,5.651284],[-107.558894,4.145118],[-103.848269,2.722236],[-99.652115,1.535147],[-95.226446,0.736359],[-88.655337,-0.360027],[-86.242204,-1.141119],[-84.191414,-2.221789],[-82.338510,-3.710272],[-80.519037,-5.714800],[-76.322566,-11.704931],[-72.204213,-17.625497],[-70.494396,-19.559114],[-68.831296,-20.932411],[-67.075271,-21.838480],[-65.086679,-22.370414],[-59.853226,-22.684251],[-54.910771,-22.492032],[-53.245451,-22.184332],[-52.018211,-21.675637],[-51.154658,-20.920994],[-50.580397,-19.875453],[-50.002176,-16.731871],[-50.010783,-13.793056],[-50.419634,-10.196654],[-52.090085,-2.324903],[-54.317551,4.295746],[-55.422672,6.328272],[-56.406056,7.077659],[-57.123106,6.607980],[-57.934740,5.329148],[-59.443136,1.125279],[-60.475146,-2.091756],[-61.586670,-4.110967],[-62.690477,-4.997283],[-63.699339,-4.815637],[-64.526024,-3.630960],[-65.083304,-1.508184],[-65.283948,1.487760],[-65.040726,5.291939],[-63.846176,15.410989],[-67.703416,6.494559],[-69.358879,3.031516],[-71.014932,0.193761],[-72.479400,-1.725738],[-73.560106,-2.434011],[-73.927852,-2.029585],[-74.205397,-0.865554],[-74.484327,3.414356],[-74.385784,9.751780],[-73.898656,17.492779],[-73.315947,26.477638],[-73.280926,32.988513],[-73.798956,37.143794],[-74.267040,38.375083],[-74.875396,39.061869],[-76.007968,39.291809],[-76.834607,38.418596],[-77.341052,36.472396],[-77.513036,33.483379],[-77.687765,29.993302],[-78.311045,28.024589],[-78.837342,27.544540],[-79.531518,27.365385],[-81.497826,27.803829],[-83.379434,28.352831],[-84.322127,28.101126],[-84.406223,26.938045],[-83.712036,24.752919],[-81.716941,18.856160],[-80.635066,14.049204],[-80.397170,10.452095],[-80.934010,8.184876],[-81.471318,7.587488],[-82.176345,7.367589],[-83.040434,7.540183],[-84.054932,8.120277],[-86.500530,10.562983],[-89.443896,14.815749],[-91.203855,17.990353],[-92.544439,21.036419],[-93.462364,23.923317],[-93.954347,26.620419],[-94.017104,29.097096],[-93.647350,31.322720],[-92.841802,33.266660],[-91.597176,34.898289],[-90.657297,36.343101],[-90.007324,38.367906],[-89.705849,40.704135],[-89.811466,43.083219],[-90.376608,45.696038],[-90.748199,46.162912],[-91.229575,46.029286],[-92.672992,43.838110],[-95.009486,38.877659]]);
    linear_extrude(height=h)
      polygon([[59.515364,41.137219],[59.881264,38.086110],[60.595740,35.834865],[61.536318,34.402915],[62.580521,33.809688],[63.605877,34.074612],[64.489908,35.217116],[65.110143,37.256629],[65.344104,40.212579],[65.123471,43.210199],[64.501183,45.528144],[63.536652,47.023625],[62.289294,47.553849],[61.073396,47.082818],[60.165431,45.763046],[59.625915,43.734518],[59.515364,41.137219]]);
    linear_extrude(height=h)
      polygon([[79.034584,36.952449],[73.666779,30.181498],[70.748548,25.304436],[70.212447,23.586378],[70.294050,22.354110],[70.995125,21.611739],[72.317444,21.363369],[74.427995,22.068965],[77.208013,23.971077],[80.364420,26.747692],[83.604139,30.076797],[86.634092,33.636377],[89.161203,37.104420],[90.892392,40.158912],[91.534584,42.477839],[91.410023,44.824921],[90.995911,46.357686],[90.231604,47.049327],[89.056458,46.873039],[87.409826,45.802014],[85.231067,43.809446],[79.034584,36.952449]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[296.877804,35.906749],[293.104155,26.556196],[291.956197,22.836357],[291.534584,20.430559],[291.252776,18.943795],[290.485478,17.726264],[289.349875,16.903608],[287.963154,16.601469],[286.576437,16.413597],[285.440834,15.902064],[284.673533,15.144997],[284.391724,14.220519],[284.819492,13.296036],[285.984208,12.538966],[287.707986,12.027432],[289.812944,11.839559],[292.918034,11.088072],[297.364956,9.041942],[302.559925,6.013668],[307.909154,2.315749],[313.168171,-1.382165],[318.117493,-4.410439],[322.200854,-6.456572],[324.861994,-7.208061],[326.183572,-6.903281],[327.864170,-6.040894],[332.023551,-2.954999],[336.782395,1.426214],[341.582956,6.479336],[345.867493,11.580956],[349.078260,16.107667],[350.657515,19.436058],[350.661030,20.456068],[350.047514,20.942719],[348.439567,21.655676],[347.301611,22.954713],[346.631977,24.715095],[346.428993,26.812087],[346.690987,29.120953],[347.416289,31.516957],[348.603229,33.875365],[350.250134,36.071439],[351.635441,37.907494],[352.484659,39.677132],[352.730359,41.178889],[352.305114,42.211299],[351.484040,42.664153],[350.651966,42.587897],[349.906071,42.022074],[349.343534,41.006229],[348.746079,39.850633],[347.905069,38.904297],[346.932209,38.264880],[345.939204,38.030039],[343.778036,37.480124],[341.023312,35.993949],[337.946792,33.816872],[334.820236,31.194253],[331.915406,28.371449],[329.504062,25.593818],[327.857964,23.106719],[327.248874,21.155509],[327.025728,19.286781],[326.346104,18.174179],[325.194722,17.805338],[323.556304,18.167889],[321.643732,18.322436],[319.259229,17.629882],[316.644655,16.193242],[314.041874,14.115529],[311.671923,12.101331],[309.522764,10.660246],[307.830940,9.926225],[306.832994,10.033219],[306.872822,10.999392],[308.006598,12.604731],[310.039321,14.625901],[312.775994,16.839569],[316.211950,19.760361],[318.470721,22.674241],[319.705521,25.848200],[320.069564,29.549229],[319.929881,32.579722],[319.543503,34.262264],[319.255681,34.602244],[318.903638,34.610264],[318.003494,33.637129],[316.972566,32.461993],[316.513775,32.335339],[316.080653,32.526032],[315.255075,33.889667],[314.423154,36.613319],[313.643298,38.814068],[312.575016,40.557055],[311.302984,41.813957],[309.911876,42.556446],[308.486369,42.756195],[307.111138,42.384880],[305.870857,41.414174],[304.850204,39.815749],[304.424326,39.082865],[304.275215,39.287481],[304.812304,42.196709],[305.373448,45.145117],[305.340077,46.906925],[304.787599,47.541911],[303.791420,47.109853],[302.426949,45.670530],[300.769592,43.283720],[296.877854,35.906749]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[310.065654,28.901119],[310.199387,27.542523],[309.523015,26.698546],[308.020737,26.360618],[305.676754,26.520169],[303.483508,27.079728],[301.530158,28.015159],[300.029416,29.196125],[299.193994,30.492289],[299.060259,31.850886],[299.736629,32.694864],[301.238906,33.032795],[303.582894,32.873249],[305.776136,32.313686],[307.729486,31.378254],[309.230231,30.197288],[310.065654,28.901119]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[341.971084,16.085589],[340.810092,15.099221],[339.921679,14.706873],[339.353605,14.914598],[339.153634,15.728449],[339.618422,17.980890],[340.760131,19.718484],[342.199782,20.562251],[342.912904,20.530517],[343.558394,20.133209],[343.813745,19.433250],[343.599605,18.436786],[341.971084,16.085589]]);
    }
    linear_extrude(height=h)
      polygon([[-234.655896,41.882499],[-234.468024,40.379671],[-233.956491,38.927923],[-233.199423,37.692728],[-232.274946,36.839559],[-231.350463,36.550010],[-230.593392,36.849419],[-230.081859,37.668878],[-229.893986,38.939479],[-230.081859,40.442312],[-230.593392,41.894059],[-231.350463,43.129252],[-232.274946,43.982419],[-233.199423,44.271970],[-233.956491,43.972563],[-234.468024,43.153105],[-234.655896,41.882499]]);
    linear_extrude(height=h)
      polygon([[-387.036846,38.589999],[-386.396666,36.521164],[-384.857506,34.339559],[-383.948432,32.991628],[-383.084272,30.993583],[-381.881316,26.125279],[-381.346875,23.854585],[-380.470544,22.130685],[-379.323025,20.968159],[-377.975015,20.381583],[-376.497216,20.385534],[-374.960326,20.994589],[-373.435046,22.223325],[-371.992076,24.086319],[-371.028384,26.089796],[-370.858557,27.894871],[-371.500517,29.636182],[-372.972186,31.448369],[-377.213128,34.942852],[-381.820817,37.729523],[-385.520356,39.161025],[-386.631163,39.166288],[-387.036846,38.589999]]);
    linear_extrude(height=h)
      polygon([[39.629824,35.172899],[38.520447,33.734689],[37.611963,31.930864],[36.998121,29.991920],[36.772674,28.148349],[36.445463,26.347109],[35.554544,24.523421],[34.235982,22.890174],[32.625844,21.660259],[30.841563,20.529344],[29.821209,19.577783],[29.542648,18.818098],[29.983743,18.262811],[31.122357,17.924445],[32.936356,17.815523],[38.501964,18.336099],[42.500261,19.106171],[43.721239,19.553261],[44.476791,20.103068],[44.806935,20.801604],[44.751688,21.694878],[43.645084,24.249689],[42.752636,26.447985],[42.199306,28.926996],[42.029620,31.382818],[42.288104,33.511549],[42.991826,36.542531],[42.902990,37.754979],[41.842141,37.261051],[39.629824,35.172899]]);
    linear_extrude(height=h)
      polygon([[216.355374,29.101469],[213.136613,21.334871],[210.640334,16.422371],[208.600549,13.929755],[207.668722,13.455211],[206.751274,13.422809],[205.716785,13.400388],[204.468345,13.048997],[201.958654,11.598709],[200.314971,9.451210],[198.398471,5.692312],[194.250256,-5.151568],[190.520478,-17.916712],[189.127024,-24.077189],[188.215604,-29.586901],[187.449841,-34.646435],[186.501414,-38.759580],[185.324450,-41.983374],[183.873078,-44.374861],[182.101422,-45.991079],[179.963612,-46.889072],[177.413774,-47.125878],[174.406034,-46.758541],[170.648936,-46.206298],[169.465887,-46.367540],[168.653819,-46.934157],[168.143217,-47.991497],[167.864567,-49.624910],[167.725064,-54.961351],[167.979460,-58.608492],[168.690701,-61.671214],[169.780869,-64.082179],[171.172043,-65.774048],[172.786304,-66.679483],[174.545732,-66.731146],[176.372409,-65.861698],[178.188414,-64.003801],[179.955452,-62.387034],[182.260448,-61.356075],[184.930521,-60.890387],[187.792788,-60.969436],[190.674366,-61.572683],[193.402375,-62.679594],[195.803932,-64.269632],[197.706154,-66.322261],[199.322977,-68.274816],[201.059117,-69.772227],[202.811352,-70.796250],[204.476463,-71.328643],[205.951228,-71.351165],[207.132429,-70.845573],[207.916844,-69.793626],[208.201254,-68.177081],[208.483061,-66.781132],[209.250360,-65.432087],[210.385963,-64.283744],[211.772684,-63.489901],[213.284041,-62.651309],[214.355859,-61.481047],[214.988479,-60.004359],[215.182241,-58.246487],[214.937487,-56.232674],[214.254558,-53.988163],[213.133793,-51.538198],[211.575534,-48.908021],[210.199968,-46.336791],[209.240464,-43.587647],[208.784209,-40.989870],[208.918394,-38.872741],[209.473205,-37.027865],[209.858361,-36.567789],[210.305984,-39.946151],[210.601111,-42.026229],[211.200473,-43.729632],[212.016882,-44.880579],[212.963154,-45.303291],[214.107383,-44.997459],[214.855335,-44.128045],[215.214692,-42.767168],[215.193140,-40.986948],[214.038042,-36.456960],[211.451514,-31.115041],[209.422121,-27.218115],[208.927487,-25.550986],[208.783563,-23.853314],[209.559847,-19.712059],[211.774984,-13.485771],[213.339919,-9.830141],[214.956172,-6.865741],[216.577702,-4.625198],[218.158468,-3.141141],[219.652428,-2.446198],[221.013541,-2.572998],[222.195767,-3.554169],[223.153064,-5.422341],[223.710887,-6.442901],[224.443950,-7.021552],[225.257040,-7.116792],[226.054944,-6.687121],[226.471489,-5.568593],[226.246229,-3.788222],[225.442539,-1.590965],[224.123794,0.778219],[222.692909,3.616087],[221.518066,7.240778],[220.621189,11.423019],[220.024205,15.933537],[219.749039,20.543057],[219.817616,25.022307],[220.251862,29.142012],[221.073704,32.672899],[221.853268,35.470093],[222.082067,37.219791],[221.839861,37.982367],[221.206410,37.818193],[220.261476,36.787643],[219.084818,34.951090],[216.355374,29.101469]]);
    linear_extrude(height=h)
      polygon([[370.106014,34.318089],[370.293886,32.992927],[370.805419,32.128791],[371.562487,31.799196],[372.486964,32.077659],[374.168513,33.775038],[374.680043,34.803570],[374.867914,35.789599],[374.680043,36.659519],[374.168513,37.371909],[373.411445,37.853254],[372.486964,38.030039],[371.562487,37.737143],[370.805419,36.939653],[370.293886,35.759369],[370.106014,34.318089]]);
    linear_extrude(height=h)
      polygon([[399.795724,31.774769],[396.755819,28.695581],[394.779331,27.354341],[394.072308,27.297022],[393.490065,27.628077],[392.511824,29.393819],[391.638262,31.163502],[390.657763,32.374440],[389.666228,33.040921],[388.759559,33.177234],[388.033656,32.797670],[387.584422,31.916517],[387.507758,30.548063],[387.899564,28.706599],[388.419491,26.313259],[388.345862,24.516061],[387.784585,23.335869],[386.841569,22.793549],[385.622721,22.909966],[384.233951,23.705983],[382.781166,25.202466],[381.370274,27.420279],[379.654123,30.337775],[378.250071,31.742842],[377.597251,31.913482],[376.941056,31.748337],[375.510014,30.467119],[374.456361,28.309469],[374.152405,25.092886],[374.603409,20.539181],[375.814634,14.370169],[377.052191,9.428826],[378.290260,5.611048],[379.539232,2.908375],[380.809500,1.312349],[382.111456,0.814511],[383.455492,1.406401],[384.852000,3.079560],[386.311374,5.825529],[387.589139,8.160666],[389.042584,10.072939],[390.492886,11.365015],[391.761224,11.839559],[392.727269,12.199393],[393.330514,13.183943],[393.524633,14.650787],[393.263304,16.457499],[393.072788,17.712824],[393.183702,18.939034],[394.391230,21.412731],[397.048705,24.095829],[401.318944,27.205569],[404.915688,29.770990],[407.861116,32.224456],[409.851273,34.287803],[410.582204,35.682869],[410.360924,36.991387],[409.727221,37.753708],[408.726303,37.986214],[407.403376,37.705282],[403.972325,35.668624],[399.795724,31.774769]]);
    linear_extrude(height=h)
      polygon([[-411.965396,33.383749],[-412.431263,32.198797],[-412.559104,30.817983],[-412.353693,29.412875],[-411.819806,28.155039],[-410.962868,26.065777],[-410.309526,23.122540],[-409.653321,16.070431],[-409.930574,9.791280],[-410.444054,7.814243],[-410.798848,7.269078],[-411.220666,7.077659],[-412.217214,7.529089],[-413.360066,8.758231],[-414.508138,10.577361],[-415.520346,12.798759],[-416.604603,15.315475],[-417.776318,17.344963],[-419.069998,18.907359],[-420.520146,20.022801],[-422.161268,20.711425],[-424.027869,20.993370],[-426.154454,20.888773],[-428.575527,20.417769],[-430.969675,19.409358],[-433.031011,17.735761],[-434.636375,15.527370],[-435.662604,12.914579],[-436.586343,10.360211],[-437.868112,8.521303],[-439.452242,7.454300],[-441.283063,7.215649],[-446.318574,7.434965],[-448.070915,7.197345],[-449.384450,6.685851],[-450.312780,5.868715],[-450.909508,4.714171],[-451.322568,1.265789],[-451.497043,-1.251868],[-451.999171,-3.296157],[-452.797005,-4.846263],[-453.858599,-5.881369],[-455.152005,-6.380662],[-456.645279,-6.323327],[-458.306472,-5.688548],[-460.103639,-4.455511],[-462.064916,-2.971441],[-462.645520,-2.720686],[-462.980631,-2.825686],[-462.977960,-4.187648],[-462.184078,-7.226731],[-460.986654,-10.641655],[-459.447495,-13.916714],[-457.615312,-16.992372],[-455.538816,-19.809092],[-453.266719,-22.307338],[-450.847732,-24.427574],[-448.330566,-26.110264],[-445.763932,-27.295871],[-442.180550,-28.184480],[-440.658014,-28.098737],[-439.164528,-27.585744],[-437.587304,-26.590089],[-435.813551,-25.056357],[-431.225301,-20.153011],[-425.609501,-13.352713],[-424.030628,-10.982608],[-423.260498,-9.258566],[-423.291154,-8.150110],[-424.114641,-7.626766],[-425.723003,-7.658058],[-428.108282,-8.213511],[-437.375904,-10.593000],[-443.981194,-11.583453],[-446.229631,-11.554658],[-447.745484,-11.174845],[-448.506419,-10.442760],[-448.490104,-9.357151],[-447.563872,-7.815368],[-445.848155,-6.086161],[-443.587813,-4.381028],[-441.027706,-2.911471],[-438.553654,-1.369051],[-436.527619,0.534468],[-435.158676,2.557288],[-434.655901,4.457609],[-434.264754,6.466822],[-433.199748,8.786127],[-431.623540,11.128446],[-429.698784,13.206699],[-426.933006,15.551531],[-425.159645,16.391711],[-424.482445,16.258746],[-423.858139,15.763047],[-422.507925,13.701349],[-418.662721,7.998431],[-413.668285,1.941259],[-408.955836,-2.867980],[-407.152614,-4.303942],[-405.956596,-4.827101],[-404.505902,-4.400324],[-403.145282,-3.251040],[-401.950250,-1.575817],[-400.996324,0.428776],[-400.359018,2.566169],[-400.113850,4.639795],[-400.336334,6.453085],[-401.101986,7.809469],[-402.112111,9.604438],[-402.939316,12.568596],[-403.498239,16.290210],[-403.703516,20.357549],[-403.930301,23.992063],[-404.554830,27.317413],[-405.493367,30.201576],[-406.662176,32.512528],[-407.977520,34.118245],[-409.355662,34.886704],[-410.712867,34.685880],[-411.965396,33.383749]]);
    linear_extrude(height=h)
      polygon([[-501.927728,30.539959],[-500.966275,28.991409],[-500.365215,26.791819],[-500.173376,24.234157],[-500.439588,21.611389],[-500.628330,18.337542],[-499.922305,14.792948],[-498.306035,10.928222],[-495.764040,6.693979],[-491.342076,-0.748511],[-489.806943,-4.013447],[-489.017535,-6.401261],[-488.199077,-8.335274],[-486.579019,-9.862149],[-484.198388,-10.955020],[-481.098209,-11.587021],[-477.169825,-11.952683],[-476.084082,-11.907412],[-475.542636,-11.655562],[-475.514485,-11.156247],[-475.968627,-10.368585],[-478.199783,-7.764681],[-479.722744,-5.696152],[-480.772049,-3.486573],[-481.253434,-1.400485],[-481.072633,0.297569],[-480.937806,1.164839],[-481.123905,2.188136],[-482.400176,4.618867],[-484.784038,7.421879],[-488.158085,10.429289],[-491.420649,13.370100],[-494.092407,16.424882],[-495.897648,19.232603],[-496.560664,21.432229],[-497.003173,25.969127],[-498.198423,29.739102],[-499.948001,32.314616],[-500.968659,33.020844],[-502.053495,33.268129],[-503.063930,33.108597],[-503.380455,32.615363],[-503.002060,31.766470],[-501.927733,30.539959]]);
    linear_extrude(height=h)
      polygon([[53.439344,31.452309],[54.456776,25.629539],[56.902944,15.440899],[58.149652,10.021919],[58.983763,5.097341],[59.332433,1.209842],[59.122824,-1.097901],[58.914360,-2.241497],[59.109841,-3.462773],[60.581419,-6.058075],[63.275123,-8.723227],[66.928516,-11.297651],[71.279165,-13.620766],[76.064635,-15.531994],[81.022489,-16.870755],[85.890294,-17.476471],[97.262034,-17.922341],[102.805174,-1.326281],[106.514004,11.464539],[107.481897,16.188152],[107.646944,18.911819],[106.983195,20.810518],[105.927606,21.987273],[104.572654,22.470623],[103.010818,22.289109],[101.334573,21.471274],[99.636400,20.045656],[98.008774,18.040798],[96.544174,15.485239],[94.959021,12.585934],[93.066627,9.794354],[88.714746,4.870577],[86.432578,2.906484],[84.197802,1.386323],[82.099078,0.394148],[80.225064,0.014009],[79.565296,0.148206],[78.978488,0.578836],[78.042258,2.275784],[77.453380,4.997630],[77.248864,8.637149],[77.158522,13.483010],[76.971382,14.856056],[76.623629,15.593957],[76.065788,15.745299],[75.248383,15.358667],[72.636984,13.165819],[70.604765,11.586796],[68.750114,10.661676],[67.101818,10.375978],[65.688661,10.715223],[64.539431,11.664930],[63.682912,13.210618],[63.147891,15.337808],[62.963154,18.032019],[62.587409,20.730625],[61.564344,23.708402],[60.050208,26.603667],[58.201254,29.054739],[56.352294,30.825233],[54.838155,31.867438],[53.815088,32.102686],[53.439344,31.452309]]);
    linear_extrude(height=h)
      polygon([[-126.477486,27.770549],[-127.149892,24.510481],[-127.076623,23.069240],[-126.719776,22.006059],[-126.597301,20.779383],[-127.162210,18.892969],[-128.309079,16.603956],[-129.932486,14.169479],[-132.298573,11.238902],[-133.855841,10.021094],[-134.436774,10.021371],[-134.942229,10.410109],[-135.895676,12.299999],[-136.746647,13.755635],[-137.928710,14.761488],[-139.285514,15.226950],[-140.660706,15.061409],[-142.159245,14.971646],[-143.851865,15.643432],[-145.530923,16.954649],[-146.988776,18.783179],[-148.672592,21.090324],[-150.329503,22.679759],[-151.869781,23.563047],[-153.203700,23.751748],[-154.241531,23.257426],[-154.893548,22.091643],[-155.070022,20.265960],[-154.681226,17.791939],[-154.348145,15.748694],[-154.415722,14.069911],[-154.820045,12.801478],[-155.497201,11.989278],[-156.383277,11.679197],[-157.414360,11.917120],[-158.526538,12.748933],[-159.655896,14.220519],[-160.435117,15.172639],[-161.416871,15.865582],[-163.872799,16.470457],[-166.793318,16.028178],[-169.948066,14.531779],[-170.802367,13.779548],[-171.450179,12.766880],[-172.165799,10.114001],[-172.173855,6.880679],[-171.553279,3.374449],[-170.382998,-0.097151],[-168.741942,-3.226585],[-166.709042,-5.706317],[-164.363226,-7.228811],[-159.840930,-8.743495],[-155.295132,-9.881163],[-150.829849,-10.637405],[-146.549096,-11.007816],[-142.556891,-10.987986],[-138.957250,-10.573509],[-135.854189,-9.759976],[-133.351726,-8.542981],[-130.744363,-7.100176],[-127.837416,-5.918642],[-124.985534,-5.120307],[-122.543366,-4.827101],[-120.050283,-4.688476],[-118.921909,-4.162002],[-119.055526,-3.081774],[-120.348416,-1.281891],[-121.657436,-0.008305],[-123.046561,0.838638],[-124.349977,1.185427],[-125.401866,0.958549],[-126.221597,0.650887],[-126.892882,0.777729],[-127.346453,1.299154],[-127.513036,2.175239],[-127.253139,3.154275],[-126.545497,3.956024],[-125.498191,4.497748],[-124.219296,4.696709],[-122.842149,5.072452],[-121.527310,6.095516],[-120.423714,7.609651],[-119.680296,9.458609],[-119.285986,12.821708],[-119.543609,13.844775],[-120.086636,14.220519],[-120.773697,14.821261],[-121.423490,16.456942],[-122.318346,21.833869],[-122.977923,27.313584],[-123.906471,30.151723],[-124.464344,30.569833],[-125.080742,30.315105],[-126.477486,27.770549]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[146.296484,20.313409],[146.484356,17.940663],[146.995890,15.776528],[147.752961,14.059991],[148.677444,13.030039],[149.601921,12.187960],[150.358989,10.982956],[150.870522,9.575889],[151.058394,8.127619],[150.702058,6.655928],[149.730573,5.611616],[148.290221,4.993277],[146.527288,4.799503],[144.588054,5.028888],[142.618806,5.680026],[140.765824,6.751508],[139.175394,8.241929],[137.746596,9.648461],[136.382030,10.444886],[135.162410,10.680066],[134.168453,10.402863],[133.480873,9.662139],[133.180388,8.506756],[133.347713,6.985575],[134.063564,5.147459],[134.738478,3.487410],[135.121631,1.779449],[135.075540,-1.448252],[134.677738,-2.802016],[134.051061,-3.871737],[133.211229,-4.574428],[132.173964,-4.827101],[131.128061,-4.075613],[129.626385,-2.029483],[126.058394,4.696709],[124.141409,8.394624],[122.096633,11.422898],[120.168719,13.469030],[118.602324,14.220519],[117.788260,14.027448],[116.884908,13.473713],[114.888611,11.437126],[112.769967,8.416509],[110.685513,4.717612],[108.791783,0.646185],[107.245312,-3.492021],[106.202638,-7.391256],[105.820294,-10.745771],[105.947934,-14.164505],[106.224259,-15.105333],[106.746053,-15.570386],[107.591165,-15.587099],[108.837447,-15.182911],[112.844914,-13.221581],[118.346037,-10.550220],[120.056711,-10.041131],[121.216653,-10.150566],[121.932755,-10.929118],[122.311911,-12.427384],[122.486964,-17.785441],[122.282235,-22.397622],[121.878898,-23.879361],[121.143868,-24.933848],[119.978860,-25.652820],[118.285591,-26.128013],[112.921134,-26.714011],[107.852337,-27.300639],[104.573356,-28.089038],[103.008280,-28.997120],[102.844734,-29.470390],[103.081198,-29.942798],[104.716198,-30.843985],[107.837370,-31.618594],[112.368802,-32.184539],[118.234584,-32.459731],[127.182268,-32.797812],[130.337846,-33.200218],[132.900419,-33.857109],[135.084363,-34.842667],[137.104057,-36.231072],[141.508204,-40.513151],[145.669867,-44.768779],[147.151838,-45.973929],[148.390875,-46.613971],[149.504209,-46.726402],[150.609070,-46.348722],[153.262294,-44.273031],[155.281570,-42.700639],[156.978949,-41.915678],[158.322305,-41.926328],[159.279514,-42.740771],[160.314655,-43.600962],[161.871745,-43.683007],[163.945129,-42.987859],[166.529154,-41.516471],[169.312327,-39.058927],[171.533955,-35.565781],[173.338195,-30.739120],[174.869204,-24.281031],[176.355586,-17.942720],[178.450045,-10.665728],[180.874303,-3.348802],[183.350084,3.109309],[186.869364,12.617057],[187.627725,15.892151],[187.714043,18.214831],[187.124925,19.610177],[185.856979,20.103271],[183.906813,19.719192],[181.271034,18.483019],[176.928981,16.633626],[175.093982,16.221973],[173.809444,16.250039],[172.484203,16.264494],[170.538381,15.815769],[165.832014,13.844509],[162.717176,12.390524],[160.517949,12.096924],[159.598027,12.412203],[158.710612,13.049899],[156.771444,15.335639],[154.418150,19.469396],[153.702268,21.439325],[153.439344,23.008919],[153.157536,24.218944],[152.390238,25.209849],[151.254635,25.879379],[149.867914,26.125279],[148.382095,25.720443],[147.257503,24.561394],[146.545259,22.731320],[146.296484,20.313409]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[156.947174,-14.551291],[156.449816,-16.510705],[156.382469,-17.886106],[156.738315,-18.678064],[157.510541,-18.887153],[158.692332,-18.513945],[160.276873,-17.559012],[164.626944,-13.906261],[167.190497,-11.787498],[169.369510,-10.605289],[171.154055,-10.363204],[172.534204,-11.064811],[172.976583,-11.720452],[173.129563,-12.511794],[172.570140,-14.495957],[170.861569,-17.006044],[168.009484,-20.030801],[164.336029,-23.277349],[161.579276,-24.880338],[160.378132,-25.122101],[159.206325,-25.020898],[156.684274,-23.880161],[154.458880,-22.992726],[151.781989,-22.671768],[148.884218,-22.850919],[145.996179,-23.463808],[143.348487,-24.444067],[141.171756,-25.725327],[139.696600,-27.241217],[139.153634,-28.925371],[139.032145,-29.354241],[138.683954,-29.500931],[137.405123,-29.007404],[135.512452,-27.564069],[133.201254,-25.290201],[130.961341,-22.649786],[129.255291,-20.170131],[128.093643,-17.910195],[127.486935,-15.928941],[127.445707,-14.285329],[127.980499,-13.038321],[129.101848,-12.246878],[130.820294,-11.969961],[132.268465,-12.363895],[133.408576,-13.466879],[134.160641,-15.160690],[134.444674,-17.327101],[134.497574,-22.684251],[138.611314,-17.432651],[140.485637,-15.407506],[142.773273,-13.507564],[147.969464,-10.379097],[150.568507,-9.298474],[152.961842,-8.638859],[154.994713,-8.474204],[156.512364,-8.878461],[157.129086,-9.669888],[157.416638,-11.003261],[157.360747,-12.692441],[156.947144,-14.551291]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[269.050534,20.833599],[266.432874,16.309296],[265.636567,14.320472],[265.344104,12.862599],[264.751869,11.805429],[263.139351,10.907642],[260.752830,10.264153],[257.838584,9.969879],[254.799703,9.685381],[252.073868,9.068521],[249.959175,8.210147],[248.753724,7.201109],[248.305138,6.736433],[247.706644,6.536791],[246.102139,6.912537],[244.024623,8.288194],[241.558514,10.623609],[239.410747,12.696977],[237.291905,14.354268],[235.281336,15.571556],[233.458390,16.324914],[231.902416,16.590417],[230.692765,16.344136],[229.908784,15.562146],[229.629824,14.220519],[229.977195,12.948667],[230.923006,11.245787],[234.032134,7.437249],[235.548788,5.270906],[236.619944,2.447002],[237.248383,-0.742762],[237.436886,-4.006686],[237.188234,-7.053068],[236.505207,-9.590208],[235.390587,-11.326406],[234.672298,-11.802995],[233.847154,-11.969961],[233.340616,-12.196607],[232.951065,-12.865574],[232.526525,-15.464642],[232.580734,-19.635510],[233.120894,-25.246521],[233.632746,-31.697362],[233.598760,-38.079708],[233.068103,-44.175203],[232.089943,-49.765493],[230.713448,-54.632223],[228.987786,-58.557039],[226.962125,-61.321587],[225.852160,-62.200524],[224.685634,-62.707511],[222.589975,-63.470285],[221.162950,-64.424735],[220.389134,-65.480435],[220.253101,-66.546961],[220.739425,-67.533887],[221.832679,-68.350789],[223.517437,-68.907242],[225.778274,-69.112821],[228.729146,-68.417664],[232.340931,-66.495036],[236.356022,-63.589196],[240.516810,-59.944404],[244.565687,-55.804922],[248.245046,-51.415008],[251.297277,-47.018924],[253.464774,-42.860931],[255.203746,-37.595018],[255.363530,-35.847177],[255.044045,-34.679788],[254.240688,-34.085631],[252.948859,-34.057485],[251.163954,-34.588132],[248.881374,-35.670351],[246.503778,-36.818928],[244.960847,-37.268479],[244.256299,-37.010133],[244.393848,-36.035017],[247.210103,-31.898989],[253.439344,-24.789421],[260.165536,-18.176146],[262.211666,-16.696508],[262.768772,-16.528345],[262.963154,-16.785061],[263.487708,-18.428317],[264.055511,-18.927636],[264.748874,-19.110351],[265.779541,-17.735321],[267.265759,-13.992826],[270.809394,-1.692011],[276.444254,20.924569],[276.830124,23.142706],[276.705772,24.722168],[276.139154,25.663792],[275.198225,25.968412],[273.950943,25.636864],[272.465262,24.669984],[270.809141,23.068607],[269.050534,20.833569]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[241.774034,-21.642251],[240.452345,-24.806222],[239.744344,-25.694386],[239.433820,-24.172139],[239.304564,-20.104881],[239.722489,-14.391096],[240.257883,-12.241240],[240.939344,-10.962711],[241.891428,-10.341214],[242.621006,-10.530827],[243.118222,-11.405485],[243.373225,-12.839127],[243.117176,-16.879104],[241.774034,-21.642251]]);
    }
    linear_extrude(height=h)
      polygon([[-396.410636,20.353669],[-397.433125,18.741710],[-398.036582,16.970613],[-398.244615,15.155671],[-398.080832,13.412181],[-397.568842,11.855435],[-396.732253,10.600728],[-395.594671,9.763355],[-394.179706,9.458609],[-392.878115,9.736946],[-391.788275,10.508620],[-390.936741,11.678633],[-390.350070,13.151982],[-390.054816,14.833667],[-390.077536,16.628687],[-390.444784,18.442042],[-391.183116,20.178729],[-392.434200,22.143419],[-393.492826,22.819787],[-394.703477,22.219358],[-396.410636,20.353659]]);
    linear_extrude(height=h)
      polygon([[-50.998326,19.837669],[-50.752602,17.039573],[-49.843865,13.188968],[-48.416014,8.793667],[-46.612946,4.361479],[-44.780164,-0.091225],[-43.271417,-4.542389],[-42.242958,-8.475669],[-41.851036,-11.374721],[-41.634608,-13.454800],[-41.084025,-15.158207],[-40.282543,-16.309158],[-39.313416,-16.731871],[-38.389558,-16.497030],[-37.711337,-15.857612],[-37.343191,-14.911273],[-37.349556,-13.755671],[-37.318706,-11.781926],[-36.849221,-8.607962],[-34.914016,-0.410881],[-33.344056,6.743158],[-33.086819,9.655119],[-33.177547,12.091613],[-33.613341,14.028567],[-34.391303,15.441909],[-35.508534,16.307567],[-36.962136,16.601469],[-37.934354,16.272693],[-38.766170,15.377511],[-39.369219,14.052640],[-39.655136,12.434799],[-39.878158,10.983906],[-40.067880,10.732790],[-40.309747,10.797894],[-40.949937,11.876766],[-41.798756,14.220519],[-43.214785,17.550131],[-43.699802,17.882626],[-43.942366,17.196709],[-44.257988,15.618398],[-44.849140,14.643796],[-45.634753,14.239040],[-46.533756,14.370263],[-47.465078,15.003602],[-48.347650,16.105191],[-49.100399,17.641165],[-49.642256,19.577659],[-50.576787,23.497411],[-50.998326,19.837669]]);
    linear_extrude(height=h)
      polygon([[498.048194,16.865289],[496.521684,13.888111],[494.284794,10.867127],[491.638253,8.155379],[488.882794,6.105909],[485.093004,4.024662],[483.802849,3.593998],[482.775410,3.606713],[481.905351,4.090362],[481.087338,5.072500],[479.186114,8.642459],[477.447570,11.813344],[475.786086,14.097608],[474.249070,15.493067],[472.883931,15.997534],[471.738078,15.608825],[470.858920,14.324753],[470.293866,12.143133],[470.090324,9.061779],[469.710807,5.416571],[468.689511,1.358412],[467.182069,-2.617903],[465.344114,-6.017581],[461.998565,-11.586777],[460.597894,-14.946151],[461.051794,-15.812137],[462.287743,-16.380339],[464.090343,-16.662654],[466.244194,-16.670979],[470.744049,-15.913253],[472.659255,-15.170996],[474.064114,-14.202341],[475.746281,-13.155115],[478.456543,-12.173667],[481.820810,-11.368051],[485.464994,-10.848321],[489.273172,-10.188026],[492.918528,-8.945107],[496.370754,-7.144830],[499.599544,-4.812456],[502.574590,-1.973248],[505.265584,1.347529],[507.642222,5.124612],[509.674194,9.332739],[510.964516,12.772154],[511.747992,15.728468],[512.022535,18.209238],[511.786056,20.222017],[511.036470,21.774361],[509.771689,22.873824],[507.989626,23.527962],[505.688194,23.744329],[503.315163,23.316712],[501.254244,22.030762],[499.500300,19.881836],[498.048194,16.865289]]);
    linear_extrude(height=h)
      polygon([[-317.989226,18.645939],[-317.734022,17.238855],[-317.039159,15.521889],[-314.754946,12.027039],[-312.972749,9.596152],[-311.400074,6.755675],[-310.076222,3.650413],[-309.040496,0.425172],[-308.332200,-2.775243],[-307.990636,-5.806028],[-308.055107,-8.522375],[-308.564916,-10.779481],[-309.632268,-13.035443],[-310.135329,-13.437060],[-310.674379,-13.315668],[-312.029641,-11.387560],[-314.036446,-7.018521],[-315.776647,-3.450118],[-317.796172,-0.034556],[-319.844508,2.840752],[-321.671136,4.788389],[-323.398268,6.540926],[-325.175695,8.885004],[-326.794278,11.514345],[-328.044876,14.122669],[-329.066195,16.249752],[-330.060501,17.568796],[-330.913995,17.973636],[-331.512876,17.358109],[-331.623023,15.746470],[-331.140454,13.386148],[-328.766984,7.216172],[-325.132084,0.441625],[-323.072730,-2.674412],[-320.975376,-5.344051],[-319.682580,-7.307048],[-318.810869,-9.629577],[-318.436951,-12.021318],[-318.637536,-14.191951],[-318.695072,-16.354562],[-317.938245,-18.854624],[-316.496580,-21.537058],[-314.499602,-24.246787],[-312.076837,-26.828731],[-309.357809,-29.127812],[-306.472044,-30.988951],[-303.549066,-32.257071],[-301.454451,-33.265211],[-300.317214,-34.819602],[-300.037598,-37.197082],[-300.515846,-40.674491],[-300.895808,-43.395061],[-300.893994,-45.620709],[-300.532761,-47.121923],[-299.834466,-47.669191],[-298.795885,-47.037842],[-297.265582,-45.376718],[-293.599890,-40.300582],[-290.577546,-35.111655],[-289.851428,-33.309543],[-289.938706,-32.480811],[-294.466522,-30.156078],[-297.737796,-27.354699],[-298.919812,-25.755045],[-299.808792,-24.011961],[-300.411769,-22.117359],[-300.735776,-20.063151],[-302.406548,-2.912703],[-303.219118,2.778195],[-304.147134,7.010528],[-305.288587,10.132534],[-306.741471,12.492452],[-308.603776,14.438521],[-310.973496,16.318979],[-313.828539,18.221928],[-316.044770,19.275668],[-317.479297,19.432804],[-317.858767,19.160334],[-317.989226,18.645939]]);
    linear_extrude(height=h)
      polygon([[-290.211446,10.252259],[-290.988578,9.021635],[-291.494196,7.283485],[-291.732694,3.010527],[-291.010551,-1.114783],[-290.315367,-2.668372],[-289.411376,-3.640611],[-288.513677,-4.564931],[-288.214444,-5.860431],[-288.513677,-7.530113],[-289.411376,-9.576981],[-291.282006,-13.952725],[-291.837527,-17.155199],[-291.630248,-18.108129],[-291.103943,-18.517742],[-290.261862,-18.300707],[-289.107256,-17.373691],[-288.025518,-15.282263],[-287.069855,-11.577432],[-286.343833,-6.782635],[-285.951016,-1.421311],[-285.915465,6.201996],[-286.540409,10.487913],[-287.134915,11.473466],[-287.935764,11.737610],[-288.956694,11.317993],[-290.211446,10.252259]]);
    linear_extrude(height=h)
      polygon([[-467.443599,4.250279],[-466.737613,2.769793],[-465.791950,1.649247],[-464.709496,0.903341],[-463.593137,0.546771],[-462.545759,0.594236],[-461.670250,1.060433],[-461.069494,1.960062],[-460.846378,3.307819],[-461.143842,4.771577],[-461.953769,5.970268],[-463.152460,6.780195],[-464.616218,7.077659],[-466.005612,6.854562],[-467.001822,6.247117],[-467.512076,5.348098],[-467.443599,4.250279]]);
    linear_extrude(height=h)
      polygon([[-277.610656,-0.202281],[-279.498768,-3.153593],[-280.807661,-5.807772],[-281.419076,-7.874110],[-281.214756,-9.061901],[-280.426607,-9.398953],[-279.448429,-9.148858],[-278.404734,-8.374585],[-277.420036,-7.139101],[-275.382321,-4.461480],[-275.108153,-4.601534],[-275.279289,-5.551484],[-276.804000,-9.353037],[-279.649516,-14.810061],[-283.341089,-22.047259],[-285.872966,-28.389971],[-286.595956,-31.332675],[-286.409695,-32.877303],[-285.915955,-33.204027],[-285.123332,-33.275657],[-282.546016,-32.779541],[-280.260517,-32.367600],[-278.693175,-32.454690],[-277.827828,-32.946230],[-277.648316,-33.747642],[-278.138480,-34.764348],[-279.282158,-35.901769],[-281.063190,-37.065326],[-283.465416,-38.160441],[-285.776614,-39.255689],[-287.669285,-40.564852],[-288.948116,-41.923629],[-289.417796,-43.167721],[-289.197170,-43.864090],[-288.569325,-44.383964],[-286.296166,-44.933344],[-283.006703,-44.894093],[-279.109321,-44.344444],[-275.012404,-43.362632],[-271.124334,-42.026890],[-267.853497,-40.415452],[-265.608276,-38.606551],[-263.978213,-37.161595],[-261.882907,-35.978499],[-259.532744,-35.091381],[-257.138109,-34.534363],[-254.909388,-34.341565],[-253.056966,-34.547106],[-251.791230,-35.185108],[-251.322566,-36.289691],[-251.013464,-37.474975],[-250.168329,-38.119716],[-248.910420,-38.263772],[-247.362994,-37.946999],[-245.649308,-37.209255],[-243.892622,-36.090395],[-242.216192,-34.630278],[-240.743276,-32.868761],[-237.879528,-28.264112],[-237.364056,-26.791138],[-237.486469,-25.827802],[-238.266980,-25.341655],[-239.725801,-25.300251],[-244.759226,-26.421881],[-251.877928,-28.196207],[-254.327729,-28.535149],[-256.097107,-28.499354],[-257.230522,-28.081881],[-257.772432,-27.275785],[-257.767294,-26.074126],[-257.259566,-24.469961],[-254.271416,-15.850821],[-253.699841,-13.463069],[-253.734174,-12.845708],[-254.043951,-12.605541],[-255.675931,-13.235345],[-258.967966,-15.309591],[-261.244335,-16.536734],[-263.596217,-17.343132],[-265.906787,-17.740071],[-268.059222,-17.738839],[-269.936699,-17.350723],[-271.422393,-16.587010],[-272.399480,-15.458987],[-272.751136,-13.977941],[-271.673445,-10.308772],[-269.082396,-4.638941],[-267.246931,-0.369893],[-266.514747,2.980569],[-266.748705,5.341101],[-267.185129,6.127847],[-267.811661,6.640357],[-268.611158,6.869711],[-269.566476,6.806992],[-271.876007,5.769661],[-274.603115,3.457018],[-277.610656,-0.202281]]);
    linear_extrude(height=h)
      polygon([[-368.031886,-0.144881],[-369.531225,-2.360990],[-371.213734,-3.701434],[-373.131334,-4.192629],[-375.335946,-3.860991],[-384.499673,-1.055654],[-388.616899,-0.156963],[-389.139139,-0.434814],[-388.827033,-1.203971],[-386.269486,-4.235731],[-384.120563,-6.433438],[-381.851761,-8.320721],[-377.107499,-11.170558],[-372.342652,-12.798341],[-367.863172,-13.217166],[-365.826055,-12.977312],[-363.975012,-12.440130],[-362.348286,-11.607258],[-360.984123,-10.480333],[-359.920765,-9.060991],[-359.196457,-7.350870],[-358.849442,-5.351608],[-358.917966,-3.064841],[-359.438506,-0.374843],[-360.249156,1.687180],[-361.293247,3.103073],[-362.514109,3.854678],[-363.855073,3.923841],[-365.259470,3.292406],[-366.670631,1.942218],[-368.031886,-0.144881]]);
    linear_extrude(height=h)
      polygon([[-259.406416,0.916889],[-260.495731,-2.219340],[-260.606379,-3.945082],[-260.246520,-4.408862],[-259.584177,-4.675830],[-257.274946,-4.827081],[-255.888225,-4.556360],[-254.752622,-3.819251],[-253.985324,-2.728328],[-253.703516,-1.396171],[-253.879959,0.328212],[-254.359382,1.703248],[-255.066927,2.698574],[-255.927734,3.283829],[-256.866945,3.428651],[-257.809701,3.102676],[-258.681145,2.275543],[-259.406416,0.916889]]);
    linear_extrude(height=h)
      polygon([[-237.879136,-1.255651],[-236.271318,-6.475896],[-233.891131,-11.822665],[-231.008866,-16.940904],[-227.894815,-21.475557],[-224.819268,-25.071568],[-222.052517,-27.373883],[-220.869405,-27.928949],[-219.864852,-28.027445],[-219.072644,-27.624990],[-218.526566,-26.677201],[-217.850728,-25.583070],[-216.701139,-24.675696],[-215.238661,-24.049518],[-213.624156,-23.798981],[-211.125844,-23.501318],[-208.837047,-22.750220],[-206.818614,-21.610661],[-205.131392,-20.147616],[-203.836232,-18.426058],[-202.993982,-16.510963],[-202.665490,-14.467306],[-202.911606,-12.360061],[-203.790914,-10.298918],[-205.227934,-8.542325],[-207.151214,-7.115398],[-209.489301,-6.043252],[-212.170742,-5.351004],[-215.124083,-5.063770],[-218.277872,-5.206667],[-221.560656,-5.804811],[-223.938801,-6.219330],[-225.824034,-6.186374],[-227.065672,-5.729547],[-227.513036,-4.872451],[-227.785510,-3.930354],[-228.527392,-3.158861],[-229.625377,-2.637582],[-230.966156,-2.446131],[-232.506727,-2.117355],[-234.148689,-1.222172],[-235.695659,0.102699],[-236.951256,1.720539],[-238.118072,3.437233],[-238.457725,3.712612],[-238.640231,3.582162],[-238.549873,2.052232],[-237.879136,-1.255651]]);
    linear_extrude(height=h)
      polygon([[-501.293890,-2.165121],[-500.889499,-4.122833],[-499.790310,-6.890133],[-496.341581,-13.444523],[-492.615780,-19.010342],[-491.170251,-20.541928],[-490.643053,-20.840784],[-490.280983,-20.769641],[-490.374377,-19.565854],[-491.349124,-17.008662],[-495.285797,-9.334881],[-497.609754,-5.533033],[-499.517182,-2.913951],[-500.810941,-1.712893],[-501.166088,-1.717643],[-501.293890,-2.165121]]);
    linear_extrude(height=h)
      polygon([[-576.566039,-5.793491],[-577.004501,-11.197100],[-577.248794,-23.435429],[-577.086551,-61.150631],[-576.540239,-91.293950],[-576.158935,-100.951243],[-575.593455,-107.970533],[-574.759740,-113.080500],[-573.573732,-117.009825],[-571.951372,-120.487189],[-569.808602,-124.241271],[-566.228918,-129.588996],[-562.289601,-133.957041],[-557.777056,-137.546511],[-552.477685,-140.558511],[-541.660733,-145.794901],[-0.464516,-147.098451],[383.608880,-147.553849],[501.887917,-147.330323],[534.728315,-147.109777],[547.041794,-146.818241],[550.539100,-145.514838],[554.381986,-143.357345],[558.380017,-140.519444],[562.342756,-137.174817],[566.079769,-133.497145],[569.400620,-129.660110],[572.114874,-125.837395],[574.032094,-122.202681],[574.855268,-119.544333],[575.541170,-115.741831],[576.535081,-104.044786],[577.081673,-85.792387],[577.248794,-59.665481],[577.248794,-4.827101],[571.443494,-4.827101],[569.674073,-5.183355],[567.191674,-6.241283],[560.186556,-10.397134],[550.625383,-17.164611],[538.705394,-26.413671],[526.690512,-35.754042],[515.722758,-43.640784],[505.621181,-50.166053],[496.204830,-55.422008],[487.292756,-59.500807],[478.704007,-62.494609],[470.257633,-64.495570],[461.772684,-65.595851],[453.229043,-66.614381],[445.544189,-68.323987],[438.127324,-70.892015],[430.387654,-74.485811],[423.979053,-77.531095],[418.521642,-79.486632],[413.812675,-80.301805],[411.675501,-80.265936],[409.649409,-79.925994],[407.709056,-79.275652],[405.829099,-78.308583],[402.149001,-75.398952],[398.406370,-71.146484],[394.398464,-65.500561],[387.650789,-55.805854],[381.652162,-48.556174],[378.817068,-45.816065],[376.029229,-43.648626],[373.241975,-42.040997],[370.408638,-40.980314],[367.482547,-40.453717],[364.417034,-40.448343],[361.165429,-40.951331],[357.681064,-41.949818],[353.917269,-43.430942],[349.827375,-45.381842],[340.482614,-50.641521],[323.677444,-60.741661],[290.344104,-61.966591],[271.784917,-62.810515],[265.344786,-63.335496],[260.242785,-64.025929],[256.062778,-64.954393],[252.388630,-66.193467],[248.804207,-67.815730],[244.893374,-69.893761],[239.019602,-73.515471],[231.984251,-78.422039],[224.670962,-83.969661],[217.963374,-89.514531],[206.071906,-99.403587],[201.341535,-103.007501],[198.282444,-105.038501],[195.155871,-106.233091],[191.614710,-106.672303],[187.623977,-106.345061],[183.148686,-105.240289],[178.153855,-103.346913],[172.604499,-100.653857],[166.465633,-97.150044],[159.702274,-92.824401],[149.656618,-86.357257],[145.869413,-84.273724],[142.510634,-82.812254],[139.283787,-81.864377],[135.892380,-81.321620],[127.429914,-81.017581],[120.755304,-80.820114],[114.787801,-80.144700],[109.247797,-78.866823],[103.855684,-76.861964],[98.331854,-74.005606],[92.396699,-70.173229],[85.770612,-65.240317],[78.173984,-59.082351],[61.090463,-45.221904],[48.332986,-35.767666],[43.412008,-32.580282],[39.375133,-30.359340],[36.156559,-29.059802],[33.690484,-28.636631],[29.519505,-29.411099],[21.817018,-31.519802],[0.211634,-38.451691],[-14.757318,-43.385812],[-25.274741,-46.188273],[-29.461484,-46.915243],[-33.252169,-47.259431],[-40.601136,-46.999641],[-47.369718,-46.117419],[-54.732246,-44.837217],[-70.046270,-41.389621],[-84.157464,-37.270362],[-90.016456,-35.150581],[-94.680086,-33.092951],[-99.970358,-30.666716],[-104.656929,-29.178469],[-109.027298,-28.705727],[-113.368962,-29.326012],[-117.969420,-31.116843],[-123.116170,-34.155740],[-129.096709,-38.520222],[-136.198536,-44.287811],[-144.300228,-50.941771],[-151.283984,-56.311178],[-157.576850,-60.616035],[-163.605872,-64.076346],[-169.798097,-66.912112],[-176.580570,-69.343338],[-184.380338,-71.590027],[-193.624446,-73.872181],[-203.542504,-76.498622],[-212.145190,-79.393532],[-219.241814,-82.484209],[-224.641686,-85.697951],[-234.052735,-92.185571],[-241.957234,-96.669644],[-245.483734,-98.142696],[-248.800646,-99.093676],[-251.963651,-99.515523],[-255.028434,-99.401174],[-258.050676,-98.743569],[-261.086061,-97.535644],[-264.190271,-95.770340],[-267.418990,-93.440593],[-274.472684,-87.059526],[-282.692606,-78.335951],[-289.984115,-70.595910],[-297.037650,-63.696881],[-303.048653,-58.390513],[-307.212566,-55.428461],[-312.035505,-53.761215],[-319.537572,-52.250794],[-329.226064,-50.976997],[-340.608276,-50.019621],[-354.813127,-48.888891],[-364.784141,-47.336992],[-368.912768,-46.239107],[-372.859906,-44.839135],[-381.379006,-40.870531],[-388.243319,-37.586667],[-394.324194,-35.312380],[-399.988745,-34.069903],[-405.604087,-33.881469],[-411.537335,-34.769311],[-418.155601,-36.755662],[-425.826000,-39.862754],[-434.915646,-44.112821],[-444.809556,-48.726465],[-453.119295,-52.040002],[-460.243342,-54.059228],[-463.485254,-54.585286],[-466.580172,-54.789941],[-469.577905,-54.673915],[-472.528263,-54.237935],[-478.486091,-52.409009],[-484.852132,-49.308959],[-492.024864,-44.943581],[-499.497990,-40.390640],[-508.572247,-35.300234],[-518.101937,-30.294141],[-526.941365,-25.994141],[-543.922334,-17.464277],[-551.493996,-13.214097],[-557.132257,-9.687181],[-564.728748,-5.017913],[-567.797545,-3.616244],[-570.404008,-2.831751],[-572.566114,-2.660830],[-574.301838,-3.099881],[-575.629154,-4.145302],[-576.566039,-5.793491]]);
    linear_extrude(height=h)
      polygon([[-189.417796,-16.861081],[-188.712105,-18.299687],[-186.808947,-19.873221],[-184.029199,-21.456469],[-180.693735,-22.924218],[-177.123430,-24.151256],[-173.639161,-25.012369],[-170.561801,-25.382345],[-168.212226,-25.135971],[-166.130731,-24.912958],[-164.248909,-25.679099],[-162.492805,-27.486719],[-160.788466,-30.388141],[-158.908652,-34.092357],[-157.845099,-35.430132],[-157.498730,-35.240063],[-157.211599,-34.492536],[-156.621946,-31.370641],[-156.039111,-26.882010],[-156.019790,-23.297395],[-156.673006,-20.512865],[-158.107780,-18.424487],[-160.433136,-16.928330],[-163.758095,-15.920463],[-168.191681,-15.296954],[-173.842916,-14.953871],[-180.344754,-14.881199],[-185.246590,-15.191833],[-188.340309,-15.860289],[-189.144089,-16.320735],[-189.417796,-16.861081]]);
    linear_extrude(height=h)
      polygon([[214.479324,-16.204891],[214.278708,-18.087323],[214.592567,-21.756857],[216.319663,-32.198963],[218.772516,-43.014678],[219.993573,-47.151223],[221.063034,-49.687471],[222.914574,-51.635791],[223.981649,-52.228474],[224.971914,-52.446151],[225.404699,-52.132320],[225.726746,-51.239176],[226.063388,-48.005017],[225.680235,-37.775748],[224.218719,-26.399538],[223.207408,-21.731703],[222.075104,-18.517581],[220.209871,-15.866877],[218.155699,-14.547179],[217.135791,-14.410215],[216.162284,-14.634510],[215.266391,-15.229567],[214.479324,-16.204891]]);
    linear_extrude(height=h)
      polygon([[492.648494,-26.403741],[490.859398,-29.216510],[488.898019,-31.246848],[486.904993,-32.490388],[485.020958,-32.942764],[483.386550,-32.599612],[482.142407,-31.456564],[481.429166,-29.509256],[481.387464,-26.753321],[481.379215,-23.038764],[481.058535,-21.908782],[480.562894,-21.493771],[478.504008,-22.647955],[474.566835,-25.700435],[463.781420,-35.039837],[453.654237,-44.591094],[450.539853,-47.908391],[449.632874,-49.433321],[450.380674,-49.661851],[451.627008,-49.494267],[454.921184,-48.140091],[457.105535,-47.285846],[459.572318,-46.978737],[462.236056,-47.219865],[465.011274,-48.010331],[467.704402,-48.814614],[470.013645,-49.042493],[471.906603,-48.694893],[473.350874,-47.772741],[474.882717,-46.811028],[477.228090,-46.017993],[480.067685,-45.475859],[483.082194,-45.266851],[486.901797,-45.028302],[490.162616,-44.304963],[492.935573,-43.023193],[495.291594,-41.109351],[497.301602,-38.489796],[499.036522,-35.090888],[500.567278,-30.838987],[501.964794,-25.660451],[502.401469,-22.643350],[502.132905,-20.534590],[501.282975,-19.324290],[499.975556,-19.002564],[498.334523,-19.559531],[496.483752,-20.985306],[494.547117,-23.270007],[492.648494,-26.403751]]);
    linear_extrude(height=h)
      polygon([[-239.465566,-39.408451],[-240.518809,-40.933678],[-241.160157,-42.403874],[-241.339095,-43.651657],[-241.005106,-44.509641],[-240.133495,-44.845661],[-238.911487,-44.629710],[-235.991554,-42.979487],[-233.395856,-40.434155],[-232.579144,-39.099319],[-232.274946,-37.868901],[-232.448155,-36.829857],[-232.933008,-36.165002],[-233.677341,-35.863170],[-234.628995,-35.913191],[-236.945613,-37.024121],[-239.465566,-39.408451]]);
    linear_extrude(height=h)
      polygon([[-228.306686,-42.128691],[-229.427719,-44.182263],[-229.893986,-46.890601],[-229.602256,-48.441657],[-228.808735,-49.452030],[-227.635927,-49.942138],[-226.206334,-49.932397],[-224.642460,-49.443224],[-223.066808,-48.495038],[-221.601883,-47.108254],[-220.370186,-45.303291],[-219.248402,-42.883480],[-219.131520,-41.432773],[-219.477892,-41.000733],[-220.109058,-40.726850],[-222.270536,-40.541391],[-225.878809,-41.007658],[-227.339331,-41.512370],[-228.306686,-42.128691]]);
  }
}
module CT_Stat(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-211.263708,33.611189],[-213.811554,32.815930],[-216.273383,31.703020],[-220.879984,28.622799],[-224.965493,24.567622],[-228.411893,19.734583],[-231.101167,14.320777],[-232.915295,8.523300],[-233.736262,2.539245],[-233.446048,-3.434291],[-232.644537,-7.489594],[-231.504453,-11.299313],[-230.044709,-14.850918],[-228.284218,-18.131877],[-226.241893,-21.129659],[-223.936647,-23.831734],[-221.387393,-26.225572],[-218.613043,-28.298642],[-215.632512,-30.038413],[-212.464712,-31.432354],[-209.128555,-32.467934],[-205.642956,-33.132624],[-202.026826,-33.413893],[-198.299080,-33.299208],[-194.478630,-32.776041],[-190.584388,-31.831861],[-187.190861,-30.991127],[-184.313546,-30.586904],[-182.209357,-30.637436],[-181.135208,-31.160961],[-180.091496,-32.522700],[-179.150375,-33.095912],[-178.324761,-32.906970],[-177.627568,-31.982248],[-177.071713,-30.348121],[-176.670111,-28.030963],[-176.381328,-21.453051],[-176.529029,-15.670857],[-176.908531,-12.742476],[-177.225706,-12.225686],[-177.649431,-12.275017],[-178.881328,-13.875591],[-182.134311,-18.284266],[-186.609868,-23.375591],[-190.177647,-26.293457],[-194.145497,-28.150943],[-198.350330,-28.974096],[-202.629058,-28.788963],[-206.818593,-27.621592],[-210.755845,-25.498030],[-214.277726,-22.444324],[-217.221148,-18.486521],[-218.690489,-15.231170],[-219.812664,-11.179074],[-220.577384,-6.574864],[-220.974356,-1.663171],[-220.993290,3.311374],[-220.623894,8.104140],[-219.855877,12.470495],[-218.678948,16.165809],[-217.449417,18.590872],[-215.934176,20.767537],[-214.164848,22.690533],[-212.173060,24.354590],[-209.990435,25.754436],[-207.648599,26.884801],[-202.613793,28.316001],[-197.321642,28.606021],[-194.658124,28.309912],[-192.025145,27.712695],[-189.454328,26.809100],[-186.977300,25.593854],[-184.625685,24.061688],[-182.431108,22.207329],[-177.948726,18.341314],[-176.515511,17.457984],[-175.654136,17.265609],[-175.389489,17.757569],[-175.746462,18.927240],[-178.424828,23.273229],[-181.253829,26.612970],[-184.564047,29.404446],[-188.297138,31.629289],[-192.394761,33.269134],[-196.798572,34.305613],[-201.450229,34.720360],[-206.291388,34.495008],[-211.263708,33.611189]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[-155.487438,33.086809],[-158.303205,31.643410],[-160.814518,29.731398],[-162.999500,27.389322],[-164.836273,24.655732],[-166.302959,21.569178],[-167.377679,18.168210],[-168.038555,14.491377],[-168.263708,10.577229],[-168.031917,5.154490],[-167.078935,1.192344],[-165.018346,-2.259929],[-161.463738,-6.153051],[-157.824718,-9.444266],[-154.538526,-11.534131],[-151.164940,-12.633456],[-147.263738,-12.953051],[-143.221796,-12.479783],[-139.369201,-11.134888],[-135.813699,-9.030730],[-132.663038,-6.279673],[-130.024965,-2.994081],[-128.007226,0.713683],[-126.717568,4.731254],[-126.263738,8.946269],[-126.487635,13.023392],[-127.148068,16.826374],[-128.228152,20.325164],[-129.711001,23.489713],[-131.579730,26.289972],[-133.817452,28.695890],[-136.407284,30.677419],[-139.332338,32.204509],[-144.231574,34.034741],[-148.006776,34.761811],[-151.483534,34.430804],[-155.487438,33.086809]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-138.334038,25.178429],[-137.366702,22.713652],[-136.720656,19.662213],[-136.389653,16.203679],[-136.367451,12.517614],[-136.647803,8.783585],[-137.224465,5.181158],[-138.091192,1.889897],[-139.241738,-0.910631],[-140.606457,-3.224783],[-142.064549,-5.109274],[-143.590982,-6.575115],[-145.160723,-7.633317],[-146.748739,-8.294890],[-148.329998,-8.570845],[-149.879467,-8.472193],[-151.372113,-8.009944],[-152.782904,-7.195110],[-154.086807,-6.038700],[-155.258788,-4.551726],[-156.273816,-2.745198],[-157.732881,1.782477],[-158.263738,7.456239],[-158.058635,12.290789],[-157.453552,16.570426],[-156.463835,20.267507],[-155.104826,23.354384],[-153.391868,25.803413],[-151.340306,27.586947],[-148.965481,28.677341],[-146.282738,29.046949],[-143.638948,28.790907],[-141.393838,28.041793],[-139.606004,26.828127],[-138.334038,25.178429]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[-12.043538,32.255939],[-14.388266,30.716234],[-16.427199,28.866606],[-18.159511,26.708752],[-19.584376,24.244371],[-20.700967,21.475160],[-21.508459,18.402817],[-22.006024,15.029041],[-22.192838,11.355529],[-22.006702,7.544953],[-21.408246,3.994056],[-20.433589,0.723362],[-19.118846,-2.246605],[-17.500136,-4.895322],[-15.613576,-7.202267],[-13.495284,-9.146915],[-11.181376,-10.708744],[-8.707970,-11.867231],[-6.111183,-12.601851],[-3.427133,-12.892083],[-0.691937,-12.717402],[2.058288,-12.057286],[4.787424,-10.891211],[7.459355,-9.198653],[10.037962,-6.959091],[13.087245,-3.634180],[14.979407,-0.863595],[15.681986,1.397583],[15.577039,2.351182],[15.162524,3.194274],[13.388560,4.571399],[10.327635,5.573876],[5.947289,6.246626],[0.215062,6.634569],[-7.302506,7.068116],[-11.695676,7.764048],[-12.967090,8.282422],[-13.753177,8.952810],[-14.152530,9.804017],[-14.263738,10.864849],[-13.918704,13.293709],[-12.955741,15.754313],[-11.483065,18.137061],[-9.608888,20.332353],[-7.441424,22.230588],[-5.088885,23.722166],[-2.659486,24.697487],[-0.261438,25.046949],[1.846741,24.851479],[3.953427,24.304062],[7.817612,22.387346],[9.402755,21.135025],[10.641696,19.764716],[11.448257,18.334907],[11.736262,16.904089],[11.894074,16.182995],[12.323762,15.592483],[13.736262,15.046949],[14.994126,15.345719],[15.663494,16.189161],[15.773206,17.497972],[15.352099,19.192848],[14.429013,21.194487],[13.032785,23.423585],[8.936262,28.246949],[6.269637,30.687772],[3.699037,32.558457],[1.182755,33.866973],[-1.320913,34.621289],[-3.853672,34.829375],[-6.457226,34.499199],[-9.173280,33.638730],[-12.043538,32.255939]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[3.736262,-1.382681],[3.405555,-3.389035],[2.485143,-5.065232],[1.082584,-6.373056],[-0.694563,-7.274294],[-2.738738,-7.730731],[-4.942382,-7.704153],[-7.197935,-7.156344],[-9.397838,-6.049091],[-11.833869,-4.262894],[-13.412324,-2.670634],[-14.140165,-1.285942],[-14.024351,-0.122448],[-13.071841,0.806218],[-11.289596,1.486426],[-8.684575,1.904547],[-5.263738,2.046949],[-0.833573,1.895174],[1.924187,1.356413],[3.337984,0.305513],[3.736262,-1.382681]]);
    }
    linear_extrude(height=h)
      polygon([[28.102662,29.389159],[25.469142,26.514958],[23.399271,23.391511],[21.872911,20.078751],[20.869924,16.636608],[20.370173,13.125016],[20.353521,9.603907],[20.799830,6.133212],[21.688962,2.772864],[23.000780,-0.417204],[24.715146,-3.377062],[26.811923,-6.046776],[29.270974,-8.366414],[32.072161,-10.276045],[35.195346,-11.715737],[38.620392,-12.625556],[42.327162,-12.945571],[44.968140,-12.580646],[47.667113,-11.573380],[50.270201,-10.065161],[52.623524,-8.197378],[54.573202,-6.111419],[55.965354,-3.948673],[56.646101,-1.850527],[56.461562,0.041629],[55.559999,1.440271],[54.240084,2.310107],[52.653426,2.680117],[50.951637,2.579276],[49.286325,2.036561],[47.809102,1.080951],[46.671578,-0.258579],[46.025362,-1.953051],[45.327514,-4.485436],[44.320641,-6.418396],[43.039501,-7.743444],[41.518849,-8.452097],[39.793443,-8.535869],[37.898038,-7.986275],[35.867392,-6.794831],[33.736262,-4.953051],[32.084010,-2.804272],[30.878257,-0.181774],[30.121635,2.802604],[29.816774,6.037024],[29.966306,9.409649],[30.572860,12.808641],[31.639069,16.122160],[33.167562,19.238369],[35.030434,21.758432],[37.188299,23.580206],[39.578684,24.702050],[42.139112,25.122324],[44.807109,24.839387],[47.520199,23.851598],[50.215909,22.157315],[52.831762,19.754899],[54.712986,17.902123],[56.138923,16.856192],[57.096575,16.573241],[57.572949,17.009406],[57.555050,18.120822],[57.029882,19.863626],[54.405762,25.067939],[51.781720,28.756171],[48.827074,31.568104],[45.612291,33.492164],[42.207837,34.516772],[38.684180,34.630352],[35.111787,33.821328],[31.561125,32.078123],[28.102662,29.389159]]);
    linear_extrude(height=h)
      polygon([[71.965862,31.782659],[70.701719,30.782568],[69.714518,29.652964],[68.970852,28.229169],[68.437312,26.346503],[67.866980,20.545840],[67.736262,10.933539],[67.611073,1.993787],[67.152424,-3.471953],[66.759108,-5.134229],[66.235694,-6.206595],[65.566605,-6.781914],[64.736262,-6.953051],[63.571418,-7.110863],[62.617512,-7.540551],[61.972980,-8.176488],[61.736262,-8.953051],[61.892634,-9.729613],[62.318387,-10.365551],[62.948477,-10.795238],[63.717862,-10.953051],[64.843821,-11.503441],[66.444662,-13.002028],[70.217862,-17.928291],[73.804429,-22.893749],[75.109040,-24.136458],[76.120899,-24.552597],[76.864779,-24.142247],[77.365451,-22.905492],[77.736262,-17.953091],[77.901448,-14.271842],[78.593424,-12.153092],[79.229030,-11.550748],[80.106819,-11.184341],[82.736262,-10.953091],[84.677668,-10.795278],[86.267512,-10.365591],[87.341730,-9.729653],[87.736262,-8.953091],[87.341730,-8.176528],[86.267512,-7.540591],[84.677668,-7.110903],[82.736262,-6.953091],[81.102782,-6.911684],[79.870485,-6.659341],[78.982849,-6.003872],[78.383349,-4.753091],[77.822669,0.303159],[77.736262,10.046909],[78.092541,20.443579],[78.582411,23.812693],[79.319674,26.038356],[80.334011,27.177587],[81.655101,27.287409],[83.312624,26.424843],[85.336262,24.646909],[86.380583,23.770147],[87.119441,23.479620],[87.554595,23.692073],[87.687799,24.324253],[87.055388,26.514782],[85.236262,29.385179],[83.748768,30.996483],[82.188090,32.237416],[80.566348,33.105789],[78.895662,33.599413],[77.188150,33.716098],[75.455934,33.453653],[73.711131,32.809890],[71.965862,31.782619]]);
    linear_extrude(height=h)
      polygon([[125.733762,29.627289],[123.352939,27.164916],[121.409878,24.461466],[119.894451,21.564879],[118.796526,18.523095],[118.105973,15.384054],[117.812663,12.195696],[117.906465,9.005960],[118.377249,5.862786],[119.214885,2.814114],[120.409243,-0.092117],[121.950193,-2.807965],[123.827604,-5.285492],[126.031346,-7.476758],[128.551290,-9.333823],[131.377306,-10.808747],[134.499262,-11.853591],[138.100603,-12.468863],[141.489116,-12.507828],[144.582399,-12.010925],[147.298049,-11.018593],[149.553663,-9.571271],[151.266838,-7.709397],[152.355172,-5.473411],[152.736262,-2.903751],[152.455446,-0.577746],[151.693427,1.149133],[150.570851,2.262824],[149.208362,2.749263],[147.726603,2.594386],[146.246221,1.784128],[144.887859,0.304428],[143.772162,-1.858781],[142.812833,-3.935533],[141.700272,-5.586331],[140.464797,-6.827251],[139.136726,-7.674366],[137.746377,-8.143749],[136.324069,-8.251474],[134.900121,-8.013615],[133.504849,-7.446247],[130.921612,-5.387276],[128.816904,-2.203150],[127.433272,1.977538],[127.013262,7.026199],[127.336250,10.931189],[128.072565,14.442096],[129.194872,17.519905],[130.675837,20.125601],[132.488123,22.220168],[134.604396,23.764592],[136.997321,24.719857],[139.639562,25.046949],[141.775710,24.852497],[143.904743,24.307553],[147.799087,22.396653],[149.393210,21.145932],[150.637843,19.775187],[151.447391,18.342033],[151.736262,16.904089],[151.904716,16.182995],[152.363374,15.592483],[153.871062,15.046949],[154.773952,15.411284],[155.150918,16.416199],[155.049506,17.929564],[154.517262,19.819246],[152.350455,24.199034],[149.030862,28.498509],[146.870548,30.325402],[144.163174,32.008886],[141.254594,33.361959],[138.490662,34.197619],[135.098529,34.577482],[132.193324,34.068371],[129.247563,32.481301],[125.733762,29.627289]]);
    linear_extrude(height=h)
      polygon([[170.181362,31.933539],[167.802437,29.765113],[167.020344,28.384782],[166.461587,26.591206],[165.869349,21.116818],[165.736262,12.046949],[165.603176,2.977081],[165.010949,-2.497307],[164.452204,-4.290883],[163.670129,-5.671214],[161.291262,-7.839641],[158.937360,-9.603599],[158.491321,-10.155460],[158.589924,-10.531891],[160.593157,-10.892410],[165.291262,-10.953051],[173.736262,-10.953051],[173.736262,5.646949],[174.100790,16.129229],[174.609364,19.854012],[175.382512,22.692309],[176.455510,24.737437],[177.863634,26.082709],[179.642159,26.821442],[181.826362,27.046949],[184.122609,26.734136],[186.123173,25.799945],[187.824821,24.250753],[189.224324,22.092933],[190.318451,19.332861],[191.103969,15.976911],[191.577650,12.031459],[191.736262,7.502879],[191.571788,1.102038],[190.927249,-3.067089],[190.354118,-4.559248],[189.575966,-5.786862],[187.291262,-7.839641],[184.937360,-9.603599],[184.491321,-10.155460],[184.589924,-10.531891],[186.593157,-10.892410],[191.291262,-10.953051],[199.736262,-10.953051],[199.736262,7.111399],[199.847299,17.105924],[200.407362,22.732639],[200.962160,24.374877],[201.756874,25.485332],[202.834057,26.250729],[204.236262,26.857789],[206.534979,27.865655],[206.984582,28.307904],[206.926249,28.772064],[205.161476,29.955224],[200.992062,31.793339],[195.482512,34.060673],[192.752312,34.730368],[192.125273,34.436800],[191.828037,33.708662],[191.736262,30.901789],[191.736262,26.756629],[186.466562,30.901789],[182.103915,33.740068],[180.118774,34.506308],[178.198637,34.841448],[176.294165,34.748615],[174.356021,34.230936],[172.334866,33.291535],[170.181362,31.933539]]);
    linear_extrude(height=h)
      polygon([[217.770162,31.080799],[215.700259,28.376979],[214.994221,26.717817],[214.473562,24.677069],[213.886690,18.920562],[213.736262,10.046949],[213.609427,1.578198],[213.148037,-3.619718],[212.753967,-5.206958],[212.230759,-6.234301],[211.563246,-6.787686],[210.736262,-6.953051],[209.571418,-7.110863],[208.617512,-7.540551],[207.972980,-8.176488],[207.736262,-8.953051],[207.892634,-9.729613],[208.318387,-10.365551],[208.948477,-10.795238],[209.717862,-10.953051],[210.843821,-11.503441],[212.444662,-13.002028],[216.217862,-17.928291],[219.804429,-22.893749],[221.109040,-24.136458],[222.120899,-24.552597],[222.864779,-24.142247],[223.365451,-22.905492],[223.736262,-17.953091],[223.901448,-14.271842],[224.593424,-12.153092],[225.229030,-11.550748],[226.106819,-11.184341],[228.736262,-10.953091],[230.677668,-10.795278],[232.267512,-10.365591],[233.341730,-9.729653],[233.736262,-8.953091],[233.341730,-8.176528],[232.267512,-7.540591],[230.677668,-7.110903],[228.736262,-6.953091],[227.102782,-6.911684],[225.870485,-6.659341],[224.982849,-6.003872],[224.383349,-4.753091],[223.822669,0.303159],[223.736262,10.046909],[224.092541,20.443579],[224.582411,23.812693],[225.319674,26.038356],[226.334011,27.177587],[227.655101,27.287409],[229.312624,26.424843],[231.336262,24.646909],[232.498776,23.641375],[233.236274,23.444541],[233.623766,24.086050],[233.736262,25.595549],[233.265505,27.139206],[231.983737,28.866808],[230.086705,30.567243],[227.770162,32.029399],[224.387566,33.625758],[222.093699,34.047236],[221.120508,33.795145],[220.138063,33.222635],[217.770162,31.080759]]);
    linear_extrude(height=h)
      polygon([[-122.263738,31.046899],[-122.027020,30.270337],[-121.382488,29.634399],[-120.428582,29.204712],[-119.263738,29.046899],[-118.436754,28.881535],[-117.769241,28.328150],[-117.246033,27.300806],[-116.851963,25.713567],[-116.390573,20.515650],[-116.263738,12.046899],[-116.390573,3.578148],[-116.851963,-1.619768],[-117.246033,-3.207008],[-117.769241,-4.234351],[-118.436754,-4.787736],[-119.263738,-4.953101],[-120.897984,-5.091726],[-121.878187,-5.478372],[-122.232868,-6.069193],[-121.990551,-6.820343],[-119.829009,-8.628248],[-115.621738,-10.551321],[-110.409659,-12.312010],[-108.754118,-12.673398],[-107.607301,-12.660892],[-106.875501,-12.253551],[-106.465012,-11.430434],[-106.233138,-8.453101],[-106.109956,-6.824455],[-105.793151,-5.858783],[-105.321340,-5.615418],[-104.733138,-6.153691],[-103.499627,-7.600867],[-101.860841,-8.932316],[-97.789088,-11.082346],[-93.361160,-12.272405],[-91.277156,-12.403892],[-89.420338,-12.171121],[-87.177418,-11.272536],[-85.272027,-9.766839],[-83.692308,-7.620262],[-82.426401,-4.799036],[-81.462449,-1.269391],[-80.788593,3.002441],[-80.392976,8.050228],[-80.263738,13.907739],[-80.132452,21.557356],[-79.603976,26.147859],[-79.127689,27.561614],[-78.476381,28.529395],[-77.624811,29.157471],[-76.547738,29.552109],[-73.865942,30.030032],[-71.649802,29.899320],[-69.866509,29.108434],[-68.483251,27.605834],[-67.467216,25.339983],[-66.785593,22.259339],[-66.405571,18.312364],[-66.294338,13.447519],[-66.542396,4.833864],[-66.888105,1.783311],[-67.429276,-0.580502],[-68.201667,-2.370655],[-69.241037,-3.700230],[-70.583141,-4.682308],[-72.263738,-5.429971],[-73.129290,-6.102463],[-72.684901,-7.037069],[-70.920981,-8.243099],[-67.827938,-9.729861],[-62.366684,-12.005995],[-59.519751,-12.665756],[-58.810631,-12.363854],[-58.435862,-11.627089],[-58.263738,-8.807941],[-58.263738,-4.662781],[-52.993938,-8.807941],[-50.582196,-10.520284],[-48.303024,-11.748215],[-46.135919,-12.491912],[-44.060376,-12.751552],[-42.055890,-12.527313],[-40.101959,-11.819373],[-38.178076,-10.627910],[-36.263738,-8.953101],[-34.227651,-6.287654],[-33.009438,-2.663868],[-32.418376,2.885179],[-32.263738,11.326409],[-32.114691,19.534601],[-31.574613,24.923832],[-30.504098,28.248451],[-29.726361,29.372266],[-28.763738,30.262809],[-27.345118,31.652487],[-27.369204,32.121915],[-27.961726,32.466679],[-31.090590,32.859056],[-37.208738,32.983289],[-43.774215,32.949221],[-46.811176,32.592839],[-47.194681,32.217246],[-46.921918,31.669233],[-44.708738,29.933489],[-42.447902,27.908389],[-41.098101,25.276554],[-40.449193,21.348187],[-40.291038,15.433489],[-40.469240,8.723474],[-41.000946,3.405365],[-41.935808,-0.585293],[-43.323476,-3.312954],[-44.202628,-4.223304],[-45.213602,-4.842074],[-47.655837,-5.237107],[-50.699832,-4.562508],[-54.395238,-2.882731],[-55.507287,-2.167529],[-56.389474,-1.270541],[-57.066946,-0.081260],[-57.564851,1.510821],[-58.122546,6.345407],[-58.263738,14.117269],[-58.130099,21.371487],[-57.667201,25.956718],[-56.782071,28.354632],[-56.152116,28.883867],[-55.381738,29.046899],[-52.983251,29.634399],[-51.971062,30.270337],[-51.263738,31.046899],[-51.370744,31.502593],[-52.279441,31.900093],[-56.436088,32.514816],[-63.602035,32.879678],[-73.645638,32.983289],[-85.795943,32.854788],[-92.451926,32.449651],[-94.062891,32.095608],[-94.712290,31.615125],[-94.537460,30.989106],[-93.675738,30.198459],[-92.660784,29.291365],[-91.865327,28.210241],[-91.271042,26.842468],[-90.859601,25.075422],[-90.511943,19.893023],[-90.675738,11.762069],[-91.114004,3.096049],[-91.865563,-1.699329],[-92.481107,-3.030565],[-93.321710,-3.856183],[-94.436283,-4.330201],[-95.873738,-4.606631],[-98.642669,-4.782286],[-100.909807,-4.401549],[-102.716023,-3.392917],[-104.102188,-1.684886],[-105.109172,0.794048],[-105.777845,4.115387],[-106.149077,8.350637],[-106.263738,13.571299],[-106.103357,20.535373],[-105.544388,25.267492],[-104.470095,28.324392],[-102.763738,30.262809],[-101.325565,31.654029],[-101.323835,32.123511],[-101.876176,32.468029],[-104.870568,32.859540],[-110.763738,32.983289],[-115.250362,32.851548],[-118.904626,32.444139],[-121.363446,31.822208],[-122.031101,31.449904],[-122.263738,31.046899]]);
    linear_extrude(height=h)
      polygon([[93.236262,30.605909],[94.607430,29.856716],[95.670044,28.990056],[96.462858,27.851527],[97.024624,26.286729],[97.610023,21.260720],[97.736262,12.676819],[97.615085,4.053686],[97.038124,-0.907873],[96.478679,-2.404708],[95.685232,-3.453124],[94.617766,-4.208779],[93.236262,-4.827331],[90.899974,-5.871638],[90.426441,-6.318552],[90.454887,-6.780711],[92.134437,-7.946981],[96.172062,-9.762881],[101.736212,-12.015973],[104.672062,-12.953101],[105.085266,-11.394224],[105.423649,-7.149757],[105.736262,6.802959],[105.855638,17.661508],[106.429599,23.998759],[106.988220,25.986639],[107.781891,27.461883],[108.851083,28.630387],[110.236262,29.698049],[112.458693,31.449569],[112.696777,32.003570],[112.238787,32.384754],[108.892618,32.753735],[101.736262,32.806639],[95.330449,32.705436],[92.038937,32.372346],[91.438969,32.087234],[91.471087,31.706219],[93.236262,30.605909]]);
    linear_extrude(height=h)
      polygon([[96.925262,-28.181791],[96.558894,-29.663772],[96.537274,-31.155776],[96.842898,-32.484114],[97.458262,-33.475101],[98.745902,-34.387139],[100.214201,-34.828739],[101.754558,-34.841448],[103.258374,-34.466811],[104.617052,-33.746373],[105.721991,-32.721680],[106.464594,-31.434277],[106.736262,-29.925711],[106.390677,-28.172240],[105.463801,-26.798884],[104.120452,-25.834941],[102.525449,-25.309706],[100.843610,-25.252476],[99.239754,-25.692549],[97.878698,-26.659222],[96.925262,-28.181791]]);
  }
}
module CT_Slog(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-239.982905,20.755674],[-241.970038,18.986023],[-243.704942,17.018081],[-246.415100,12.588370],[-248.107460,7.668623],[-248.776100,2.460927],[-248.415101,-2.832637],[-247.018543,-8.009982],[-244.580504,-12.869027],[-242.969080,-15.116035],[-241.095065,-17.207686],[-237.361202,-20.606288],[-235.667734,-21.672488],[-233.831110,-22.390361],[-231.657232,-22.815210],[-228.952001,-23.002341],[-221.171085,-22.884666],[-207.397405,-22.411366],[-207.461005,-14.312206],[-207.567382,-9.954434],[-207.944443,-8.024233],[-208.303401,-7.873105],[-208.812735,-8.213229],[-210.392805,-10.213046],[-214.055994,-14.996388],[-217.017908,-17.714906],[-218.508793,-18.476072],[-220.151846,-18.932493],[-224.331105,-19.213046],[-227.728362,-18.869059],[-230.725849,-17.851873],[-233.307171,-16.183645],[-235.455930,-13.886533],[-237.155730,-10.982697],[-238.390174,-7.494295],[-239.142865,-3.443485],[-239.397405,1.147574],[-239.175871,6.177750],[-238.397555,9.968314],[-236.891890,13.031079],[-234.488305,15.877854],[-232.090805,17.892339],[-229.504873,19.358387],[-226.775682,20.274597],[-223.948400,20.639564],[-221.068201,20.451887],[-218.180255,19.710161],[-215.329732,18.412985],[-212.561805,16.558954],[-208.112639,13.601382],[-206.878034,13.194639],[-206.332133,13.424482],[-206.496477,14.232330],[-207.392608,15.559603],[-211.466385,19.538094],[-214.650174,21.747068],[-218.187662,23.378848],[-221.956394,24.428206],[-225.833920,24.889914],[-229.697787,24.758743],[-233.425542,24.029465],[-236.894732,22.696852],[-239.982905,20.755674]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[-194.939485,23.448374],[-196.617726,22.371396],[-198.206875,20.615343],[-199.644430,18.338194],[-200.867888,15.697932],[-201.814747,12.852536],[-202.422504,9.959987],[-202.628658,7.178266],[-202.370705,4.665354],[-201.502800,2.065447],[-200.111345,-0.447167],[-198.290426,-2.792547],[-196.134125,-4.890753],[-193.736527,-6.661846],[-191.191715,-8.025886],[-188.593773,-8.902933],[-186.036785,-9.213046],[-183.776343,-9.008998],[-181.667236,-8.421341],[-179.722880,-7.486801],[-177.956689,-6.242107],[-176.382079,-4.723988],[-175.012466,-2.969170],[-172.941893,1.103647],[-171.852292,5.682520],[-171.850988,10.473625],[-172.291986,12.856944],[-173.045305,15.183137],[-174.124359,17.415477],[-175.542565,19.517234],[-177.238651,21.270031],[-179.270508,22.688290],[-181.574326,23.759080],[-184.086295,24.469469],[-186.742606,24.806525],[-189.479448,24.757315],[-192.233011,24.308909],[-194.939485,23.448374]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-180.611385,17.623374],[-179.705023,14.093021],[-179.490198,10.309566],[-179.890427,6.496104],[-180.829225,2.875727],[-182.230110,-0.328471],[-184.016597,-2.893394],[-186.112204,-4.595951],[-187.252025,-5.054124],[-188.440445,-5.213046],[-189.655585,-5.030172],[-190.751063,-4.506035],[-192.566015,-2.580890],[-193.851263,0.268560],[-194.572770,3.748484],[-194.696500,7.565054],[-194.188413,11.424439],[-193.014474,15.032809],[-191.140645,18.096334],[-189.876018,19.286605],[-188.421265,20.112029],[-186.864087,20.576545],[-185.292185,20.684092],[-183.793263,20.438609],[-182.455021,19.844036],[-181.365161,18.904311],[-180.611385,17.623374]]);
    }
    linear_extrude(height=h)
      polygon([[-169.397405,22.786954],[-169.239593,22.010392],[-168.809905,21.374454],[-168.173968,20.944767],[-167.397405,20.786954],[-166.873316,20.523122],[-166.429637,19.776361],[-165.778057,17.102465],[-165.431753,13.302093],[-165.379810,8.912072],[-165.611317,4.469227],[-166.115361,0.510385],[-166.881028,-2.427628],[-167.358560,-3.346066],[-167.897405,-3.807986],[-168.397965,-4.354881],[-167.912780,-5.157756],[-166.555308,-6.108605],[-164.439005,-7.099426],[-161.939228,-7.936910],[-159.931570,-8.295936],[-158.528480,-8.168856],[-157.842405,-7.548026],[-157.178446,-6.899183],[-155.836250,-6.727371],[-153.901817,-7.029176],[-151.461145,-7.801186],[-148.336586,-8.733764],[-145.746675,-8.929926],[-143.655028,-8.341921],[-142.025265,-6.922001],[-140.821004,-4.622415],[-140.005861,-1.395413],[-139.543456,2.806753],[-139.397405,8.031834],[-139.243004,13.049699],[-138.819003,17.098174],[-138.184203,19.802259],[-137.806128,20.532968],[-137.397405,20.786954],[-136.620843,20.944767],[-135.984905,21.374454],[-135.555218,22.010392],[-135.397405,22.786954],[-136.028655,23.563517],[-137.747405,24.199454],[-140.291155,24.629142],[-143.397405,24.786954],[-148.400731,24.352375],[-150.030478,23.859158],[-151.035153,23.226439],[-151.381908,22.487556],[-151.037896,21.675845],[-149.970271,20.824646],[-148.146185,19.967294],[-146.585884,18.911628],[-145.740628,16.960782],[-145.525810,13.698707],[-145.856825,8.709354],[-146.703306,1.817484],[-147.222448,-0.362003],[-147.887843,-1.819388],[-148.761226,-2.646321],[-149.904336,-2.934449],[-151.378910,-2.775421],[-153.246685,-2.260886],[-155.384429,-1.184105],[-156.111242,-0.350269],[-156.645773,0.785477],[-157.245253,4.277533],[-157.397405,9.921734],[-157.239593,14.140491],[-156.809905,17.595292],[-156.173968,19.929619],[-155.799163,20.565193],[-155.397405,20.786954],[-154.620843,20.944767],[-153.984905,21.374454],[-153.555218,22.010392],[-153.397405,22.786954],[-154.028655,23.563517],[-155.747405,24.199454],[-158.291155,24.629142],[-161.397405,24.786954],[-164.503655,24.629142],[-167.047405,24.199454],[-168.766155,23.563517],[-169.397405,22.786954]]);
    linear_extrude(height=h)
      polygon([[-131.352925,18.286954],[-131.308525,11.786954],[-127.685485,16.497634],[-125.959725,18.328114],[-124.043375,19.671782],[-122.119750,20.428376],[-120.372165,20.497634],[-118.537130,19.984799],[-117.353063,19.278219],[-116.820086,18.377567],[-116.938320,17.282519],[-117.707886,15.992751],[-119.128905,14.507937],[-123.925785,10.951874],[-127.456300,8.391706],[-129.762105,5.988767],[-131.017656,3.503601],[-131.397405,0.696754],[-131.222894,-1.771673],[-130.686158,-3.845609],[-129.767391,-5.539988],[-128.446788,-6.869748],[-126.704543,-7.849826],[-124.520851,-8.495157],[-121.875907,-8.820678],[-118.749905,-8.841326],[-114.783838,-8.530310],[-113.488904,-8.206919],[-112.569443,-7.704201],[-111.963008,-6.971602],[-111.607154,-5.958570],[-111.397405,-2.888986],[-111.530406,-0.702591],[-111.894294,0.957524],[-112.436404,2.072084],[-113.104068,2.621814],[-113.844617,2.587441],[-114.605385,1.949690],[-115.333704,0.689286],[-115.976905,-1.213046],[-116.582954,-2.546989],[-117.579567,-3.648523],[-118.865088,-4.490832],[-120.337865,-5.047096],[-121.896244,-5.290497],[-123.438569,-5.194218],[-124.863188,-4.731440],[-126.068445,-3.875346],[-126.354724,-3.017940],[-126.030890,-1.808918],[-124.061590,1.089532],[-121.177958,3.671118],[-119.711208,4.484060],[-118.397405,4.786954],[-117.061158,5.080280],[-115.595930,5.886522],[-112.657205,8.595354],[-110.338580,12.028641],[-109.648477,13.740452],[-109.397405,15.301574],[-109.667332,17.294929],[-110.449144,19.113790],[-111.700888,20.730022],[-113.380613,22.115487],[-115.446365,23.242049],[-117.856193,24.081572],[-120.568144,24.605919],[-123.540265,24.786954],[-127.948043,24.648525],[-129.337084,24.375057],[-130.290198,23.876144],[-130.887861,23.084833],[-131.210552,21.934168],[-131.352925,18.286954]]);
    linear_extrude(height=h)
      polygon([[-100.997405,22.386954],[-101.929280,20.552918],[-102.692405,17.333412],[-103.208030,13.182342],[-103.397405,8.553614],[-103.562547,3.730245],[-104.036325,-0.026571],[-104.786268,-2.550170],[-105.779905,-3.673886],[-106.216425,-3.978187],[-106.395254,-4.507079],[-105.995783,-6.201288],[-104.613373,-8.681832],[-102.279905,-11.874026],[-96.397405,-19.280006],[-95.778765,-13.354826],[-95.334077,-10.720253],[-94.630048,-9.076728],[-93.625378,-8.367377],[-92.278765,-8.535326],[-91.081058,-8.770654],[-90.173645,-8.477251],[-89.598453,-7.685810],[-89.397405,-6.427026],[-89.634124,-5.179093],[-90.278655,-4.157148],[-91.232562,-3.466647],[-92.397405,-3.213046],[-93.188799,-3.085866],[-93.839607,-2.677583],[-94.762695,-0.857246],[-95.253139,2.568886],[-95.397405,7.921734],[-95.288927,13.940624],[-94.774795,17.125744],[-94.277159,17.873787],[-93.571969,18.175164],[-91.397405,17.786954],[-88.572405,17.399922],[-87.713030,17.678771],[-87.397405,18.252174],[-87.599656,19.342051],[-88.162263,20.462094],[-90.103693,22.576329],[-92.691979,24.162182],[-95.397405,24.786954],[-96.829280,24.597579],[-98.362405,24.081954],[-100.997405,22.386954]]);
    linear_extrude(height=h)
      polygon([[-84.897405,22.002854],[-83.284478,20.221401],[-82.199803,17.621227],[-81.588929,14.002616],[-81.397405,9.165854],[-81.576071,4.262285],[-82.165513,0.789977],[-83.245901,-1.529113],[-84.897405,-2.973026],[-86.571668,-4.078384],[-86.897947,-4.532324],[-86.861870,-4.962363],[-85.637290,-5.876519],[-82.767205,-7.072406],[-76.267205,-9.213046],[-75.929483,-8.160237],[-75.652913,-5.293678],[-75.397405,4.129474],[-75.215429,10.468994],[-74.636303,15.245002],[-73.610233,18.713246],[-72.087425,21.129474],[-70.449215,23.174705],[-70.280609,23.819232],[-70.633830,24.260447],[-73.170243,24.679173],[-78.587425,24.723354],[-83.626583,24.601846],[-86.111150,24.214324],[-86.511157,23.870934],[-86.411350,23.401192],[-84.897405,22.002854]]);
    linear_extrude(height=h)
      polygon([[-62.064065,23.453614],[-62.581778,21.953317],[-63.005738,18.853977],[-63.397405,9.667594],[-63.553189,3.735894],[-64.066608,-0.305491],[-65.006766,-2.765658],[-65.658466,-3.499378],[-66.442765,-3.953706],[-67.914283,-4.691413],[-68.340420,-5.566771],[-67.692730,-6.857966],[-65.942765,-8.843186],[-62.739030,-12.594483],[-60.015025,-16.388546],[-58.712428,-18.328776],[-57.981508,-18.776658],[-57.642347,-17.611609],[-57.515025,-14.713046],[-57.254400,-12.245542],[-56.579305,-10.498858],[-55.467666,-9.438323],[-53.897405,-9.029266],[-44.238376,-8.513648],[-41.440184,-8.040650],[-39.664230,-7.126276],[-38.661532,-5.547091],[-38.183107,-3.079658],[-37.803145,5.413694],[-37.367149,12.908518],[-36.641018,16.916869],[-36.050776,17.921394],[-35.245950,18.423633],[-32.803145,18.413694],[-30.461206,17.708126],[-29.656335,17.000237],[-29.045685,15.934852],[-28.257510,12.369314],[-27.797605,6.286954],[-27.694466,1.503795],[-27.924468,-2.117521],[-28.466038,-4.411599],[-28.846920,-5.009238],[-29.297605,-5.213046],[-30.112914,-5.381340],[-30.780585,-5.839568],[-31.231717,-6.517745],[-31.397405,-7.345886],[-30.963421,-8.124091],[-29.781780,-8.666306],[-28.032952,-8.923310],[-25.897405,-8.845886],[-22.791550,-8.219787],[-21.792302,-7.567832],[-21.077423,-6.501471],[-20.583350,-4.879350],[-20.246522,-2.560117],[-19.790345,4.735094],[-19.366348,9.919889],[-18.663125,14.363952],[-17.773513,17.618586],[-16.790345,19.235094],[-15.817708,20.066996],[-15.585670,20.878947],[-16.107735,21.749281],[-17.397405,22.756334],[-20.717445,24.258594],[-23.959663,24.680464],[-25.331805,24.494372],[-26.420752,24.047924],[-27.138590,23.344369],[-27.397405,22.386954],[-27.509906,21.336958],[-27.897408,20.986959],[-28.634908,21.336958],[-29.797405,22.386954],[-31.338745,23.556124],[-33.136039,24.315664],[-35.082719,24.677142],[-37.072218,24.652124],[-38.997968,24.252178],[-40.753401,23.488869],[-42.231949,22.373766],[-43.327045,20.918434],[-44.130928,18.519616],[-44.789238,14.847907],[-45.234041,10.403146],[-45.397405,5.685174],[-45.498627,-0.623758],[-46.042330,-3.877981],[-46.592630,-4.613586],[-47.388571,-4.890326],[-49.897405,-4.473626],[-55.897405,-3.240346],[-56.479827,-2.342957],[-56.956780,0.079072],[-57.397405,8.020214],[-57.285599,14.069803],[-56.765923,17.314937],[-56.266762,18.105803],[-55.561988,18.459520],[-53.397405,18.207454],[-50.743002,17.859558],[-49.966597,18.067253],[-49.564218,18.511537],[-49.540988,19.179029],[-49.902028,20.056350],[-51.797405,22.386954],[-54.206216,23.955263],[-57.115310,24.696854],[-59.932117,24.550160],[-61.120734,24.124467],[-62.064065,23.453614]]);
    linear_extrude(height=h)
      polygon([[-8.064065,23.453614],[-8.581778,21.953317],[-9.005738,18.853977],[-9.397405,9.667594],[-9.553189,3.735894],[-10.066608,-0.305491],[-11.006766,-2.765658],[-11.658466,-3.499378],[-12.442765,-3.953706],[-13.914283,-4.691413],[-14.340420,-5.566771],[-13.692730,-6.857966],[-11.942765,-8.843186],[-8.739030,-12.594483],[-6.015025,-16.388546],[-4.706136,-18.349954],[-3.976100,-18.834301],[-3.640527,-17.735210],[-3.515025,-14.946306],[-3.211330,-12.534024],[-2.405715,-10.691791],[-1.075041,-9.385470],[0.803835,-8.580926],[2.236366,-8.012232],[3.170991,-7.245479],[3.628458,-6.365083],[3.629512,-5.455461],[3.194902,-4.601029],[2.345374,-3.886205],[1.101676,-3.395405],[-0.515445,-3.213046],[-1.261503,-3.076839],[-1.880039,-2.645753],[-2.769125,-0.764161],[-3.251862,2.701304],[-3.397405,8.020214],[-3.285599,14.069803],[-2.765923,17.314937],[-2.266762,18.105803],[-1.561988,18.459520],[0.602595,18.207454],[3.256998,17.859558],[4.033403,18.067253],[4.435782,18.511537],[4.459012,19.179029],[4.097972,20.056350],[2.202595,22.386954],[-0.206216,23.955263],[-3.115310,24.696854],[-5.932117,24.550160],[-7.120734,24.124467],[-8.064065,23.453614]]);
    linear_extrude(height=h)
      polygon([[6.602595,22.786954],[6.760407,22.010392],[7.190095,21.374454],[7.826032,20.944767],[8.602595,20.786954],[9.135359,20.517565],[9.586119,19.756169],[10.247455,17.037980],[10.598266,13.193637],[10.650212,8.784389],[10.414957,4.371487],[9.904161,0.516181],[9.129486,-2.220280],[8.646839,-2.993553],[8.102595,-3.276646],[7.353577,-3.555843],[7.461714,-4.239646],[9.526170,-6.276346],[12.849403,-8.297296],[14.531011,-8.961411],[15.984855,-9.213046],[16.649820,-9.020773],[17.205691,-8.419897],[18.015337,-5.847983],[18.464177,-1.208600],[18.602595,5.786954],[18.752594,11.786951],[19.169260,16.536952],[19.802593,19.661953],[20.184885,20.497891],[20.602595,20.786954],[21.379157,20.944767],[22.015095,21.374454],[22.444782,22.010392],[22.602595,22.786954],[21.971345,23.563517],[20.252595,24.199454],[17.708845,24.629142],[14.602595,24.786954],[11.496345,24.629142],[8.952595,24.199454],[7.233845,23.563517],[6.602595,22.786954]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[28.495575,18.286954],[26.891705,15.221660],[25.870741,12.140765],[25.427789,9.079255],[25.557957,6.072114],[26.256352,3.154329],[27.518082,0.360884],[29.338254,-2.273236],[31.711975,-4.713046],[34.557971,-6.794562],[37.431611,-8.123046],[40.282702,-8.757123],[43.061052,-8.755416],[45.716469,-8.176549],[48.198760,-7.079145],[50.457732,-5.521828],[52.443195,-3.563221],[54.104954,-1.261948],[55.392818,1.323368],[56.256595,4.134102],[56.646092,7.111632],[56.511117,10.197334],[55.801477,13.332584],[54.466981,16.458759],[52.457435,19.517234],[50.079798,22.070645],[47.533865,23.689887],[44.442367,24.540233],[40.428035,24.786954],[36.209854,24.551725],[33.233657,23.618009],[30.871534,21.643766],[28.495575,18.286954]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[47.388615,17.623374],[48.303508,14.068916],[48.519857,10.274146],[48.114290,6.459207],[47.163435,2.844242],[45.743920,-0.350608],[43.932373,-2.905201],[41.805422,-4.599394],[40.647616,-5.055047],[39.439695,-5.213046],[38.285882,-5.025209],[37.247083,-4.487320],[35.530441,-2.515123],[34.321596,0.396079],[33.652375,3.938817],[33.554605,7.805623],[34.060113,11.689030],[35.200728,15.281570],[37.008275,18.275774],[38.231311,19.411025],[39.655202,20.187334],[41.190162,20.610343],[42.746410,20.685694],[44.234162,20.419031],[45.563635,19.815995],[46.645047,18.882229],[47.388615,17.623374]]);
    }
    linear_extrude(height=h)
      polygon([[58.602595,22.786954],[58.760407,22.010392],[59.190095,21.374454],[59.826032,20.944767],[60.602595,20.786954],[61.126684,20.523122],[61.570363,19.776361],[62.221943,17.102465],[62.568247,13.302093],[62.620190,8.912072],[62.388683,4.469227],[61.884639,0.510385],[61.118972,-2.427628],[60.641440,-3.346066],[60.102595,-3.807986],[59.602035,-4.354881],[60.087220,-5.157756],[61.444692,-6.108605],[63.560995,-7.099426],[66.060772,-7.936910],[68.068430,-8.295936],[69.471520,-8.168856],[70.157595,-7.548026],[70.821554,-6.899183],[72.163750,-6.727371],[74.098183,-7.029176],[76.538855,-7.801186],[79.663414,-8.733764],[82.253325,-8.929926],[84.344972,-8.341921],[85.974735,-6.922001],[87.178996,-4.622415],[87.994139,-1.395413],[88.456544,2.806753],[88.602595,8.031834],[88.756996,13.049699],[89.180997,17.098174],[89.815797,19.802259],[90.193872,20.532968],[90.602595,20.786954],[91.379157,20.944767],[92.015095,21.374454],[92.444782,22.010392],[92.602595,22.786954],[91.971345,23.563517],[90.252595,24.199454],[87.708845,24.629142],[84.602595,24.786954],[79.654030,24.355375],[78.014159,23.867042],[76.978685,23.242472],[76.583699,22.515758],[76.865295,21.720995],[77.859562,20.892275],[79.602595,20.063694],[80.924924,19.031514],[81.855450,17.085304],[82.401893,14.199795],[82.571975,10.349714],[82.126640,3.542321],[81.569683,1.110717],[80.770210,-0.705023],[79.713477,-1.929046],[78.384742,-2.585499],[76.769262,-2.698530],[74.852295,-2.292286],[72.650165,-1.206504],[71.905461,-0.376993],[71.360232,0.753097],[70.753906,4.243511],[70.602595,9.921734],[70.760407,14.140491],[71.190095,17.595292],[71.826032,19.929619],[72.200837,20.565193],[72.602595,20.786954],[73.379157,20.944767],[74.015095,21.374454],[74.444782,22.010392],[74.602595,22.786954],[73.971345,23.563517],[72.252595,24.199454],[69.708845,24.629142],[66.602595,24.786954],[63.496345,24.629142],[60.952595,24.199454],[59.233845,23.563517],[58.602595,22.786954]]);
    linear_extrude(height=h)
      polygon([[114.602595,16.365794],[114.731910,13.488555],[115.088939,11.289920],[115.627310,9.795028],[116.300650,9.029014],[117.062585,9.017017],[117.866743,9.784173],[118.666750,11.355620],[119.416235,13.756494],[119.978905,15.293215],[120.822143,16.651510],[123.175432,18.819805],[126.126323,20.235339],[129.325040,20.872077],[132.421803,20.703979],[135.066835,19.705008],[136.110647,18.885808],[136.910358,17.849125],[137.422249,16.591706],[137.602595,15.110294],[137.014394,12.569992],[135.117392,9.871894],[131.712992,6.799846],[126.602595,3.137694],[121.312274,-0.654362],[117.817107,-3.854898],[115.802204,-6.816039],[114.952675,-9.889906],[114.863118,-13.165024],[115.401478,-15.961255],[116.570951,-18.281021],[118.374730,-20.126746],[120.816011,-21.500851],[123.897988,-22.405761],[127.623858,-22.843899],[131.996815,-22.817686],[142.602595,-22.236146],[142.594595,-14.224606],[142.586595,-6.213046],[138.623475,-12.713046],[136.941841,-15.039011],[135.063501,-16.878141],[133.048077,-18.214786],[130.955195,-19.033298],[128.844477,-19.318029],[126.775548,-19.053329],[124.808033,-18.223551],[123.001555,-16.813046],[121.810249,-15.498557],[121.089277,-14.326085],[120.882586,-13.216647],[121.234125,-12.091266],[122.187843,-10.870961],[123.787688,-9.476752],[129.101555,-5.850706],[135.255323,-1.702112],[140.057750,2.068571],[143.545563,5.534220],[145.755487,8.767714],[146.724249,11.841931],[146.488573,14.829747],[145.085187,17.804043],[142.550815,20.837694],[140.027558,22.842850],[136.963302,24.008509],[132.692802,24.483470],[126.550815,24.416534],[114.602595,23.944634],[114.602595,16.365794]]);
    linear_extrude(height=h)
      polygon([[155.935935,23.453614],[155.418222,21.993285],[154.994262,19.002769],[154.602595,10.174114],[154.420205,5.094267],[153.902120,0.879519],[153.091962,-2.229601],[152.033355,-3.992566],[151.018964,-5.339830],[151.109002,-6.926683],[152.411217,-9.039448],[155.033355,-11.964446],[158.013970,-14.922265],[159.693905,-16.121828],[160.159466,-16.097539],[160.435875,-15.676015],[160.602595,-13.697706],[160.906117,-11.977880],[161.762092,-10.485316],[163.088628,-9.319751],[164.803835,-8.580926],[166.250389,-8.008241],[167.188269,-7.239615],[167.639736,-6.358974],[167.627052,-5.450248],[167.172478,-4.597364],[166.298276,-3.884250],[165.026708,-3.394835],[163.380035,-3.213046],[162.584602,-3.100203],[161.951284,-2.732405],[161.131157,-1.056338],[160.839979,2.166375],[160.998075,7.286954],[161.445912,12.530259],[162.164420,15.695687],[162.679015,16.633280],[163.325885,17.212303],[165.102595,17.509174],[167.472174,17.658194],[168.137026,18.016745],[168.453275,18.555892],[168.034035,20.149676],[166.202595,22.386954],[163.793784,23.955263],[160.884690,24.696854],[158.067883,24.550160],[156.879266,24.124467],[155.935935,23.453614]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[172.624155,21.812934],[171.392480,19.806291],[170.853396,17.660351],[170.974460,15.442978],[171.723230,13.222032],[173.067261,11.065375],[174.974111,9.040868],[177.411337,7.216374],[180.346495,5.659754],[183.979997,3.849689],[186.203705,2.177049],[187.189988,0.459807],[187.111215,-1.484066],[186.452728,-3.101242],[185.511300,-4.240266],[184.380879,-4.904349],[183.155415,-5.096703],[181.928855,-4.820539],[180.795150,-4.079067],[179.848247,-2.875499],[179.182095,-1.213046],[178.628568,0.212066],[177.831853,1.340424],[176.858076,2.153833],[175.773362,2.634102],[174.643839,2.763035],[173.535632,2.522441],[172.514869,1.894125],[171.647675,0.859894],[171.427456,-0.379578],[171.968351,-1.899286],[173.119233,-3.561917],[174.728977,-5.230161],[176.646459,-6.766707],[178.720552,-8.034243],[180.800133,-8.895460],[182.734075,-9.213046],[185.926392,-9.042047],[188.529932,-8.483840],[190.594975,-7.470607],[192.171802,-5.934531],[193.310696,-3.807794],[194.061939,-1.022579],[194.475811,2.488931],[194.602595,6.794554],[194.725556,12.704993],[195.180492,16.153717],[195.572787,17.099013],[196.096479,17.601774],[196.767704,17.719631],[197.602595,17.510214],[198.798375,17.186031],[199.684987,17.218488],[200.256904,17.562661],[200.508597,18.173627],[200.029206,20.016245],[198.202595,22.386954],[196.945338,23.362410],[195.461320,24.079284],[192.299240,24.720594],[190.864298,24.636682],[189.688837,24.277494],[188.894415,23.638856],[188.602595,22.716594],[188.373137,21.913817],[187.668332,21.646224],[186.463528,21.913817],[184.734075,22.716594],[180.983847,24.278729],[177.751792,24.651542],[176.313045,24.390682],[174.983399,23.830966],[172.624155,21.812934]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[186.751215,17.286954],[187.738675,11.286954],[188.089652,8.356284],[187.941528,7.514824],[187.527875,7.066314],[186.811348,6.993532],[185.754608,7.279254],[182.471115,8.857314],[180.761633,10.086443],[179.548830,11.587953],[178.830927,13.227377],[178.606142,14.870252],[178.872697,16.382112],[179.628811,17.628492],[180.872703,18.474928],[182.602595,18.786954],[185.471252,18.346329],[186.377884,17.869376],[186.751215,17.286954]]);
    }
    linear_extrude(height=h)
      polygon([[205.935935,23.453614],[205.418222,21.953317],[204.994262,18.853977],[204.602595,9.667594],[204.446128,3.786351],[203.937045,-0.259003],[203.015822,-2.740079],[202.382056,-3.478890],[201.622935,-3.928486],[200.358204,-4.709641],[200.142563,-5.212739],[200.217782,-5.830788],[201.279936,-7.531554],[203.622935,-10.051566],[207.139822,-14.217328],[208.209669,-15.989549],[208.602595,-17.240166],[208.750707,-18.006319],[209.153982,-18.459456],[209.750829,-18.565163],[210.479655,-18.289026],[211.151287,-17.541540],[211.592382,-16.363898],[211.765139,-14.917685],[211.631755,-13.364486],[211.576325,-11.690936],[212.093027,-10.315526],[213.159828,-9.271916],[214.754695,-8.593766],[216.428364,-7.977676],[217.607144,-7.187480],[218.294801,-6.302159],[218.495102,-5.400696],[218.211813,-4.562071],[217.448701,-3.865267],[216.209533,-3.389265],[214.498075,-3.213046],[212.315877,-2.901631],[211.623418,-2.383049],[211.158405,-1.507606],[210.795767,1.658699],[210.998075,7.286954],[211.445912,12.530259],[212.164420,15.695687],[212.679015,16.633280],[213.325885,17.212303],[215.102595,17.509174],[217.472174,17.658194],[218.137026,18.016745],[218.453275,18.555892],[218.034035,20.149676],[216.202595,22.386954],[213.793784,23.955263],[210.884690,24.696854],[208.067883,24.550160],[206.879266,24.124467],[205.935935,23.453614]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[224.747755,19.517234],[222.874590,16.647023],[221.569259,13.578959],[220.829081,10.396619],[220.651377,7.183584],[221.033467,4.023431],[221.972669,0.999740],[223.466305,-1.803912],[225.511695,-4.303946],[227.817451,-6.271875],[230.242974,-7.714613],[232.739895,-8.629856],[235.259847,-9.015301],[237.754461,-8.868645],[240.175369,-8.187586],[242.474203,-6.969821],[244.602595,-5.213046],[246.869804,-2.717158],[248.265319,-0.614497],[248.776100,1.113567],[248.389107,2.485664],[247.091300,3.520422],[244.869639,4.236470],[241.711084,4.652438],[237.602595,4.786954],[229.833845,5.053064],[227.470563,5.341112],[226.602595,5.692854],[228.906115,11.654414],[230.259144,14.096308],[231.811808,15.957736],[233.536474,17.233173],[235.405512,17.917094],[237.391290,18.003974],[239.466177,17.488287],[241.602543,16.364509],[243.772755,14.627114],[245.818687,12.950625],[247.335563,12.179919],[248.309062,12.204865],[248.724862,12.915334],[248.568644,14.201195],[247.826087,15.952319],[246.482871,18.058575],[244.524675,20.409834],[242.247200,22.405508],[239.755828,23.791967],[237.129702,24.572782],[234.447965,24.751527],[231.789758,24.331772],[229.234226,23.317090],[226.860510,21.711054],[224.747755,19.517234]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[238.102595,-1.713046],[237.489700,-2.683749],[236.436965,-3.478671],[235.092044,-4.015780],[233.602595,-4.213046],[232.113145,-4.015780],[230.768225,-3.478671],[229.715489,-2.683749],[229.102595,-1.713046],[229.108062,-0.654449],[229.888010,0.130707],[231.400250,0.618986],[233.602595,0.786954],[235.804940,0.618986],[237.317180,0.130707],[238.097127,-0.654449],[238.102595,-1.713046]]);
    }
    linear_extrude(height=h)
      polygon([[-82.436665,-19.276566],[-82.819985,-20.328811],[-82.819720,-21.504676],[-82.458158,-22.660560],[-81.757585,-23.652866],[-80.603274,-24.432898],[-79.241650,-24.789118],[-77.800899,-24.769482],[-76.409210,-24.421948],[-75.194771,-23.794474],[-74.285768,-22.935017],[-73.810391,-21.891535],[-73.896825,-20.711986],[-74.510903,-19.573125],[-75.452308,-18.675144],[-76.622149,-18.034664],[-77.921533,-17.668308],[-79.251568,-17.592698],[-80.513364,-17.824457],[-81.608027,-18.380205],[-82.436665,-19.276566]]);
    linear_extrude(height=h)
      polygon([[10.602595,-21.213046],[10.804137,-23.115874],[11.431707,-24.329633],[12.519721,-24.889914],[14.102595,-24.832306],[15.461579,-24.338195],[16.574470,-23.491111],[17.326423,-22.409810],[17.602595,-21.213046],[17.326423,-20.016282],[16.574470,-18.934981],[15.461579,-18.087897],[14.102595,-17.593786],[12.519721,-17.536177],[11.431707,-18.096458],[10.804137,-19.310218],[10.602595,-21.213046]]);
  }
}
module CT_Back(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-50.268416,34.622007],[-51.203271,32.973400],[-51.202868,32.211722],[-50.854515,31.437954],[-49.005780,29.692639],[-45.440696,27.414427],[-41.969405,25.184528],[-40.105680,23.439343],[-39.719919,22.668076],[-39.667966,21.921455],[-40.474706,20.373447],[-41.185970,19.015925],[-41.654861,16.813465],[-41.840570,9.087917],[-40.981917,-4.374824],[-39.028986,-25.146383],[-37.844896,-36.885093],[-21.568976,-35.414083],[-2.068199,-34.477503],[21.961094,-34.291403],[49.215244,-34.639743],[50.613244,-19.721083],[51.049332,-13.216775],[51.203271,-6.535383],[51.073571,-0.462369],[50.658744,4.216807],[49.306224,13.236047],[33.006594,15.352797],[1.706964,19.324177],[-3.352567,20.167290],[-8.956326,21.491575],[-21.265011,25.390782],[-34.156056,30.636043],[-46.566426,36.841607],[-47.252488,36.885093],[-48.179151,36.481102],[-50.268396,34.622007]]);
  }
}
module DC_Stat(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    difference()
    {
       linear_extrude(height=h)
         polygon([[-371.888255,31.878190],[-372.679823,30.899201],[-373.478476,29.054995],[-375.041935,23.258107],[-376.468425,15.461871],[-377.647740,6.640634],[-378.469672,-2.231259],[-378.824015,-10.179461],[-378.600562,-16.229627],[-378.237722,-18.238463],[-377.689105,-19.407410],[-376.763167,-20.786405],[-376.004904,-22.608240],[-375.492564,-24.635853],[-375.304395,-26.632180],[-375.133841,-27.845526],[-374.641508,-28.948527],[-372.807473,-30.806177],[-370.034227,-32.170506],[-366.553707,-33.006885],[-362.597852,-33.280690],[-358.398598,-32.957293],[-354.187883,-32.002069],[-350.197645,-30.380390],[-346.880353,-28.602185],[-344.359859,-26.903223],[-342.502312,-24.903382],[-341.173861,-22.222544],[-340.240655,-18.480589],[-339.568843,-13.297396],[-338.473995,2.913180],[-337.855784,15.875696],[-337.906748,19.971915],[-338.290615,22.864681],[-339.077027,24.843923],[-340.335628,26.199570],[-342.136060,27.221553],[-344.547965,28.199800],[-353.239469,31.015995],[-361.208431,32.637092],[-364.680516,32.966994],[-367.682233,32.959140],[-370.117005,32.600537],[-371.888255,31.878190]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-350.533755,3.652880],[-350.816418,-2.604394],[-351.646304,-7.810845],[-352.996260,-11.851294],[-354.839135,-14.610560],[-357.165399,-16.546142],[-359.105969,-17.323886],[-359.930254,-17.281527],[-360.656477,-16.953259],[-361.812558,-15.443728],[-362.569843,-12.804759],[-362.923967,-9.045821],[-362.870563,-4.176379],[-362.405265,1.794100],[-361.375950,9.750008],[-360.104081,14.577655],[-359.285048,16.034222],[-358.294809,16.967734],[-357.096506,17.464528],[-355.653285,17.610940],[-354.193512,17.494067],[-353.031622,17.085606],[-352.135792,16.298797],[-351.474199,15.046879],[-350.726436,10.800667],[-350.533755,3.652880]]);
    }
    linear_extrude(height=h)
      polygon([[-160.425575,27.993710],[-167.977425,14.858640],[-171.600765,7.977910],[-171.617265,15.321620],[-172.148400,22.449779],[-172.804939,25.212922],[-173.728414,27.453880],[-174.923542,29.181479],[-176.395040,30.404548],[-178.147626,31.131916],[-180.186015,31.372410],[-181.638293,31.263390],[-182.808633,30.894189],[-183.725894,30.201591],[-184.418935,29.122382],[-185.247789,25.551277],[-185.526065,19.675160],[-186.055975,5.552450],[-187.147365,-11.976220],[-188.638715,-31.930350],[-181.512835,-31.930350],[-179.275858,-31.868375],[-177.556694,-31.588852],[-176.282937,-30.951379],[-175.382180,-29.815559],[-174.782018,-28.040991],[-174.410043,-25.487277],[-174.061035,-17.480810],[-174.061035,-0.967040],[-173.970408,-0.165543],[-173.482729,0.490815],[-172.677610,0.934300],[-171.634665,1.097180],[-171.081788,0.923279],[-170.566002,0.424874],[-169.690860,-1.405660],[-169.099548,-4.114850],[-168.882375,-7.423120],[-168.509792,-11.362125],[-167.495330,-15.788660],[-165.993923,-20.160865],[-164.160505,-23.936880],[-161.323919,-28.032172],[-159.873733,-29.426191],[-158.269984,-30.450553],[-156.413445,-31.154826],[-154.204889,-31.588582],[-148.334825,-31.842820],[-143.731248,-31.581455],[-139.639530,-30.887060],[-136.091094,-29.779490],[-133.117364,-28.278603],[-130.749762,-26.404254],[-129.019713,-24.176300],[-127.958639,-21.614596],[-127.597965,-18.739000],[-128.046923,-16.103631],[-129.268715,-13.927569],[-131.075722,-12.271955],[-133.280322,-11.197933],[-135.694896,-10.766645],[-138.131821,-11.039233],[-140.403478,-12.076841],[-142.322245,-13.940610],[-143.941974,-15.537518],[-145.882042,-16.502572],[-147.985580,-16.870944],[-150.095720,-16.677810],[-152.055594,-15.958343],[-153.708333,-14.747716],[-154.897070,-13.081104],[-155.464935,-10.993680],[-156.054580,-1.383096],[-155.838546,5.775039],[-155.418294,8.531314],[-154.784494,10.790728],[-153.933105,12.592034],[-152.860085,13.973980],[-151.199869,15.303782],[-149.263658,16.356950],[-145.316183,17.529716],[-143.681384,17.597481],[-142.523523,17.284946],[-142.030832,16.566194],[-142.391545,15.415310],[-143.040645,13.731353],[-142.983114,12.088858],[-142.319800,10.572901],[-141.151551,9.268559],[-139.579216,8.260906],[-137.703643,7.635019],[-135.625680,7.475975],[-133.446175,7.868850],[-130.846049,9.201522],[-129.007537,11.188350],[-127.927430,13.651899],[-127.602519,16.414739],[-128.029592,19.299436],[-129.205441,22.128558],[-131.126855,24.724674],[-133.790625,26.910350],[-136.846642,28.567848],[-140.589654,30.181782],[-144.545536,31.567428],[-148.240165,32.540060],[-152.509976,33.121273],[-154.188507,33.038583],[-155.643059,32.677081],[-156.933837,32.014304],[-158.121044,31.027791],[-160.425565,27.993710]]);
    linear_extrude(height=h)
      polygon([[-110.926455,27.658950],[-111.878451,24.192685],[-112.653294,19.534540],[-113.171357,14.294102],[-113.353015,9.080960],[-113.444185,-7.667566],[-113.690602,-12.975124],[-114.151243,-16.640721],[-114.886360,-18.966242],[-115.956206,-20.253568],[-117.421034,-20.804584],[-119.341095,-20.921170],[-121.929459,-21.377404],[-123.727634,-22.593345],[-124.748662,-24.339856],[-125.005584,-26.387796],[-124.511440,-28.508028],[-123.279271,-30.471412],[-121.322119,-32.048809],[-118.653025,-33.011080],[-112.345659,-33.861873],[-105.579626,-34.145470],[-98.813595,-33.861873],[-92.506235,-33.011080],[-89.837141,-32.048809],[-87.879989,-30.471412],[-86.647820,-28.508028],[-86.153676,-26.387796],[-86.410598,-24.339856],[-87.431626,-22.593345],[-89.229801,-21.377404],[-91.818165,-20.921170],[-93.840814,-20.884106],[-95.348867,-20.568163],[-96.409489,-19.666219],[-97.089846,-17.871151],[-97.457103,-14.875837],[-97.578425,-10.373152],[-97.351925,4.382820],[-97.534550,13.298129],[-98.399368,20.925428],[-99.821595,27.050753],[-101.676449,31.460137],[-102.727116,32.954487],[-103.839145,33.939615],[-104.996939,34.388774],[-106.184900,34.275220],[-107.387431,33.572206],[-108.588932,32.252987],[-109.773806,30.290817],[-110.926455,27.658950]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[-57.414495,27.488740],[-60.054636,25.299364],[-62.061535,23.309008],[-63.520759,21.216259],[-64.517877,18.719704],[-65.138457,15.517928],[-65.468066,11.309520],[-65.596645,-1.332850],[-65.441177,-9.397695],[-64.952138,-15.846811],[-64.005127,-20.906784],[-62.475740,-24.804204],[-60.239576,-27.765657],[-57.172232,-30.017730],[-53.149305,-31.787012],[-48.046395,-33.300090],[-44.684243,-33.936863],[-41.494150,-34.088290],[-38.487560,-33.770960],[-35.675917,-33.001465],[-33.070666,-31.796394],[-30.683249,-30.172336],[-28.525111,-28.145882],[-26.607695,-25.733621],[-24.942446,-22.952145],[-23.540807,-19.818041],[-22.414222,-16.347901],[-21.574135,-12.558315],[-21.031990,-8.465871],[-20.799231,-4.087161],[-20.887301,0.561226],[-21.307645,5.462700],[-22.027825,10.132713],[-23.034071,14.413143],[-24.308984,18.293373],[-25.835163,21.762791],[-27.595209,24.810781],[-29.571721,27.426729],[-31.747300,29.600021],[-34.104545,31.320042],[-36.626057,32.576178],[-39.294435,33.357815],[-42.092279,33.654338],[-45.002190,33.455133],[-48.006767,32.749584],[-51.088610,31.527079],[-54.230319,29.777002],[-57.414495,27.488740]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-35.752155,9.270950],[-33.802085,3.322433],[-33.022992,-2.208832],[-33.329703,-7.144908],[-34.637043,-11.307859],[-35.639331,-13.043807],[-36.859837,-14.519748],[-38.287912,-15.713438],[-39.912911,-16.602637],[-41.724187,-17.165102],[-43.711092,-17.378590],[-45.862980,-17.220860],[-48.169205,-16.669670],[-49.524507,-16.104576],[-50.637110,-15.316825],[-51.526122,-14.255638],[-52.210650,-12.870236],[-53.042680,-8.923673],[-53.286055,-3.070900],[-52.849961,6.739521],[-52.264843,10.325967],[-51.399454,13.117916],[-50.227127,15.178878],[-48.721195,16.572363],[-46.854990,17.361881],[-44.601845,17.610940],[-42.117579,17.041427],[-39.746260,15.397241],[-37.590311,12.774907],[-35.752155,9.270950]]);
    }
    linear_extrude(height=h)
      polygon([[47.514225,27.801560],[44.171039,23.977286],[42.866289,21.788329],[41.768315,19.315486],[40.079336,13.220116],[38.877385,5.095130],[38.310795,-1.967162],[38.297270,-8.133834],[38.863144,-13.480429],[40.034750,-18.082491],[41.838423,-22.015566],[44.300495,-25.355196],[47.447302,-28.176926],[51.305175,-30.556300],[56.014341,-32.676851],[59.988771,-33.511235],[64.123440,-33.106920],[69.313325,-31.511370],[74.271088,-29.404694],[75.938943,-28.314091],[77.154649,-27.082101],[77.984609,-25.621317],[78.495225,-23.844331],[78.824035,-18.992120],[78.624623,-15.466478],[78.081673,-12.579284],[77.278108,-10.628478],[76.804510,-10.097327],[76.296855,-9.912000],[74.193026,-10.072398],[72.159466,-10.525999],[68.562353,-12.147264],[67.128401,-13.232153],[66.023920,-14.444697],[65.313711,-15.743508],[65.062575,-17.087200],[64.731439,-18.575857],[63.829833,-19.794940],[62.495457,-20.618646],[60.866015,-20.921170],[58.915720,-20.381489],[57.085166,-18.877567],[55.441901,-16.582087],[54.053471,-13.667734],[52.987424,-10.307190],[52.311305,-6.673139],[52.092664,-2.938265],[52.399045,0.724750],[53.827075,12.794420],[54.315131,14.926746],[55.446237,16.409503],[57.067521,17.250570],[59.026113,17.457827],[61.169141,17.039154],[63.343737,16.002430],[65.397028,14.355536],[67.176145,12.106350],[68.800507,9.999459],[70.647524,8.393116],[72.581814,7.307313],[74.467998,6.762044],[76.170692,6.777301],[77.554518,7.373080],[78.484092,8.569371],[78.824035,10.386170],[78.234028,17.194302],[76.779890,23.808552],[74.935444,28.591741],[74.014926,29.785069],[73.174515,29.906690],[72.173402,29.592989],[71.093870,29.756306],[70.065721,30.350020],[69.218755,31.327510],[67.705947,32.851205],[65.541854,33.763539],[62.880653,34.089559],[59.876521,33.854310],[56.683636,33.082839],[53.456173,31.800193],[50.348311,30.031417],[47.514225,27.801560]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[97.402025,32.227470],[95.531859,31.521987],[94.000356,30.531572],[92.965558,29.387666],[92.585505,28.221710],[92.259745,26.829313],[91.372775,25.068860],[88.457065,21.346190],[87.550924,20.133424],[86.754933,18.455437],[85.497336,13.934963],[84.692141,8.247098],[84.347217,1.854174],[84.470431,-4.781480],[85.069651,-11.197530],[86.152743,-16.931648],[87.727575,-21.521500],[89.674477,-24.390137],[92.596374,-27.108344],[96.228211,-29.560288],[100.304935,-31.630135],[104.561490,-33.202054],[108.732821,-34.160211],[112.553875,-34.388774],[115.759595,-33.771910],[117.944852,-32.404996],[120.391817,-30.011604],[122.939245,-26.849602],[125.425890,-23.176859],[127.690507,-19.251244],[129.571850,-15.330625],[130.908675,-11.672871],[131.539735,-8.535850],[131.840423,-7.484389],[132.331760,-8.690666],[133.614225,-16.792730],[134.692587,-24.177960],[135.318357,-26.600071],[136.095643,-28.326799],[137.094787,-29.471860],[138.386132,-30.148971],[140.040020,-30.471845],[142.126795,-30.554200],[144.316794,-30.500076],[145.971873,-30.233476],[147.154309,-29.598054],[147.926379,-28.437466],[148.350358,-26.595370],[148.488522,-23.915419],[148.156515,-15.416580],[148.044201,-2.098065],[148.390395,3.998372],[148.969295,8.665980],[150.143687,13.457416],[150.907081,15.031415],[151.909785,16.155159],[153.243185,16.901815],[154.998665,17.344552],[160.141405,17.610940],[165.083920,17.841878],[166.750771,18.198315],[167.968311,18.775631],[168.801758,19.619003],[169.316330,20.773606],[169.649725,24.197210],[169.386216,27.002059],[168.566151,29.260199],[167.145222,30.989489],[165.079122,32.207787],[162.323545,32.932954],[158.834183,33.182849],[154.566729,32.975331],[149.476875,32.328260],[144.906087,31.504662],[141.318520,30.530817],[138.593849,29.262974],[136.611752,27.557382],[135.251908,25.270290],[134.393992,22.257946],[133.917682,18.376600],[133.702655,13.482500],[133.451095,2.473320],[130.122935,11.665690],[127.489373,17.873730],[124.459741,23.029769],[121.023996,27.140121],[117.172092,30.211096],[112.893985,32.249007],[108.179630,33.260165],[103.018981,33.250882],[97.401995,32.227470]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[117.336225,6.662110],[119.049447,0.762682],[119.432230,-1.507180],[119.489385,-3.493951],[119.213603,-5.325241],[118.597578,-7.128656],[116.315565,-11.162300],[114.569224,-13.591052],[112.853215,-15.477278],[111.138570,-16.830336],[109.396320,-17.659586],[107.597498,-17.974388],[105.713135,-17.784099],[103.714263,-17.098081],[101.571915,-15.925690],[99.900701,-14.258876],[98.463611,-11.710038],[97.315200,-8.583661],[96.510026,-5.184234],[96.102645,-1.816242],[96.147614,1.215827],[96.699488,3.607486],[97.812825,5.054250],[98.989151,6.155422],[99.952456,7.769537],[100.603335,9.679569],[100.842385,11.668490],[101.279203,13.706659],[102.545716,15.301367],[104.576017,16.398800],[107.304195,16.945140],[109.126698,16.989608],[110.682659,16.760838],[112.024134,16.205471],[113.203181,15.270147],[114.271857,13.901508],[115.282218,12.046195],[117.336225,6.662110]]);
    }
    linear_extrude(height=h)
      polygon([[184.041365,32.282610],[181.473814,30.699902],[179.263197,28.161317],[177.409436,24.666569],[175.912455,20.215370],[174.772178,14.807431],[173.988528,8.442465],[173.561429,1.120184],[173.490805,-7.159700],[173.800751,-19.962439],[174.122049,-24.128059],[174.628240,-27.096114],[175.374830,-29.086303],[176.417327,-30.318327],[177.811236,-31.011886],[179.612065,-31.386680],[182.078110,-31.408924],[184.094265,-30.624135],[185.698649,-28.912475],[186.929382,-26.154108],[187.824586,-22.229195],[188.422379,-17.017899],[188.878215,-2.256810],[189.109890,6.018714],[189.831850,11.623892],[190.409210,13.568693],[191.148170,15.018217],[192.061738,16.029901],[193.162925,16.661180],[196.563955,17.410730],[197.911016,17.326285],[198.776835,16.924190],[199.439735,14.519960],[200.234317,8.984147],[201.819225,-8.186460],[202.868832,-20.616907],[204.088382,-27.809929],[204.883240,-29.867925],[205.866207,-31.127189],[207.085825,-31.757928],[208.590635,-31.930350],[210.134114,-31.772732],[211.333084,-31.148837],[212.230300,-29.832107],[212.868514,-27.595984],[213.538952,-19.459324],[213.686425,-4.926390],[213.492587,9.360924],[212.701871,18.396722],[211.984622,21.522441],[211.000478,24.027847],[209.710214,26.143795],[208.074605,28.101140],[205.860148,30.049640],[203.247167,31.620845],[200.322109,32.799716],[197.171424,33.571210],[193.881558,33.920287],[190.538961,33.831907],[187.230081,33.291028],[184.041365,32.282610]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[274.395495,28.916480],[273.348219,24.891917],[272.557235,17.784034],[272.099446,8.596368],[272.051755,-1.667540],[272.367593,-11.768951],[273.011387,-19.681596],[274.118678,-25.631490],[274.888491,-27.941035],[275.825005,-29.844648],[276.945163,-31.370580],[278.265908,-32.547083],[279.804182,-33.402410],[281.576927,-33.964811],[285.893603,-34.323845],[291.351475,-33.850200],[296.484895,-32.982303],[300.632401,-31.826792],[303.887584,-30.279408],[306.344032,-28.235893],[308.095336,-25.591989],[309.235082,-22.243437],[309.856863,-18.085981],[310.054265,-13.015360],[310.566436,-2.210284],[311.099318,2.485282],[311.743325,5.882740],[312.936668,9.376012],[314.104855,11.032975],[314.666613,11.207088],[315.206598,10.963221],[316.200609,9.276342],[317.045600,6.081931],[317.700283,1.489578],[318.123371,-4.391123],[318.273575,-11.450580],[318.428940,-22.516361],[318.693899,-26.124067],[319.146601,-28.682303],[319.834215,-30.366559],[320.803910,-31.352325],[322.102853,-31.815092],[323.778215,-31.930350],[326.476342,-31.523627],[327.446198,-30.958097],[328.195578,-30.100341],[329.129882,-27.355820],[329.473215,-22.985390],[330.008498,-4.585274],[330.756603,7.119251],[331.251083,10.857937],[331.847513,13.399448],[332.562141,14.902693],[333.411215,15.526580],[334.055391,15.303707],[334.832882,14.389936],[336.669253,10.771590],[338.683204,5.235313],[340.637615,-1.655120],[345.076006,-18.071842],[346.987751,-23.875401],[348.778515,-28.253684],[350.511285,-31.340137],[352.249049,-33.268204],[354.054797,-34.171330],[355.991515,-34.182960],[356.923967,-33.719017],[357.997697,-32.694410],[360.470573,-29.193873],[363.213310,-24.142685],[366.029078,-18.002183],[368.721043,-11.233703],[371.092376,-4.298581],[372.946244,2.341845],[374.085815,8.226240],[375.263015,13.332939],[376.064381,15.329671],[376.885115,16.589440],[377.637956,17.849027],[378.254465,19.845277],[378.824015,24.950390],[378.429010,27.819305],[377.346842,29.841863],[375.731782,31.023206],[373.738103,31.368475],[371.520075,30.882813],[369.231970,29.571364],[367.028059,27.439269],[365.062615,24.491670],[363.068371,21.581340],[360.643590,19.420002],[357.886746,18.074315],[354.896315,17.610940],[351.873906,18.031878],[349.365865,19.306835],[347.348099,21.454027],[345.796515,24.491670],[344.005560,28.063889],[342.880787,29.269928],[341.468102,30.151687],[339.666219,30.755990],[337.373851,31.129662],[330.912515,31.372410],[324.617262,31.135701],[322.362652,30.787509],[320.593866,30.239595],[319.228763,29.457089],[318.185200,28.405118],[317.381038,27.048812],[316.734135,25.353300],[315.638617,22.430059],[314.595128,21.178761],[314.015781,21.148613],[313.356905,21.498677],[311.677185,23.289080],[309.811787,25.341969],[307.663905,27.201320],[302.709710,30.310881],[297.192638,32.560699],[291.490729,33.893712],[285.982021,34.252859],[281.044553,33.581078],[278.908171,32.840757],[277.056365,31.821305],[275.536388,30.515590],[274.395495,28.916480]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[299.805005,12.106350],[300.218794,9.317390],[300.006780,8.355426],[299.465082,7.639506],[298.555891,7.137904],[297.241397,6.818896],[293.245265,6.601760],[289.372493,7.030611],[286.760397,8.168461],[285.367621,9.792260],[285.152811,11.678955],[286.074614,13.605493],[288.091675,15.348823],[291.162640,16.685893],[295.246155,17.393650],[296.570928,17.043672],[297.872050,15.930136],[298.999937,14.226532],[299.805005,12.106350]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[358.952815,1.529440],[360.510213,0.073765],[360.865521,-0.811574],[360.934353,-1.866455],[360.199948,-4.678468],[358.281715,-8.749520],[355.314453,-14.020459],[354.407904,-15.305141],[354.070315,-15.398410],[351.493215,-5.077310],[350.741457,-1.945241],[350.471356,0.528316],[350.682684,2.343156],[351.375215,3.499075],[352.548721,3.995867],[354.202974,3.833328],[356.337748,3.011254],[358.952815,1.529440]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[298.483575,-14.728510],[297.695016,-16.598672],[296.233647,-18.130175],[294.308047,-19.164976],[292.126795,-19.545030],[289.945537,-19.164976],[288.019935,-18.130175],[286.558568,-16.598672],[285.770015,-14.728510],[285.702907,-12.453987],[286.037430,-11.619178],[286.641870,-10.967416],[288.734100,-10.157265],[292.126795,-9.912000],[295.519484,-10.157265],[297.611713,-10.967416],[298.216153,-11.619178],[298.550677,-12.453987],[298.483575,-14.728510]]);
    }
    linear_extrude(height=h)
      polygon([[-328.515405,-0.480780],[-328.376427,-17.604806],[-327.743421,-27.079201],[-327.140374,-29.598012],[-326.292280,-30.984684],[-325.158625,-31.499307],[-323.698895,-31.401970],[-322.427052,-31.010888],[-321.371674,-30.341930],[-320.514580,-29.346882],[-319.837589,-27.977533],[-318.951194,-23.923074],[-318.567045,-17.792850],[-317.793994,-5.905894],[-316.378125,4.871460],[-315.698576,9.512709],[-315.733679,12.611017],[-316.028737,13.637973],[-316.513875,14.346879],[-317.192895,14.760297],[-318.069605,14.900790],[-319.631613,15.030546],[-320.127678,15.422780],[-319.552251,16.156189],[-317.899785,17.309470],[-316.326718,18.883144],[-315.551120,20.931240],[-315.493560,23.242859],[-316.074609,25.607105],[-317.214836,27.813080],[-318.834813,29.649887],[-320.855109,30.906630],[-323.196295,31.372410],[-324.846297,31.219753],[-326.116063,30.564613],[-327.054979,29.111232],[-327.712434,26.563852],[-328.137816,22.626718],[-328.380513,17.004073],[-328.515405,-0.480780]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[-310.166775,29.537540],[-310.879221,28.101189],[-311.462652,25.546717],[-312.001645,18.528370],[-311.760819,13.998553],[-310.900726,11.188921],[-310.173948,10.321662],[-309.214945,9.755436],[-306.497055,9.354060],[-304.346828,9.676594],[-302.597977,10.558187],[-301.422520,11.869827],[-300.992475,13.482500],[-300.622254,14.904350],[-299.616872,16.064218],[-298.134249,16.931356],[-296.332305,17.475017],[-294.368961,17.664454],[-292.402138,17.468920],[-290.589756,16.857668],[-289.089735,15.799950],[-288.428691,14.567458],[-288.551781,13.132478],[-289.337661,11.608069],[-290.664985,10.107295],[-292.412409,8.743215],[-294.458587,7.628892],[-296.682174,6.877386],[-298.961825,6.601760],[-301.798666,6.236934],[-304.328146,5.164289],[-306.529972,3.416572],[-308.383855,1.026530],[-309.869503,-1.973090],[-310.966624,-5.549540],[-311.654929,-9.670072],[-311.914125,-14.301940],[-311.624877,-19.421277],[-310.689332,-23.810346],[-309.133349,-27.443162],[-306.982790,-30.293743],[-304.263515,-32.336103],[-301.001386,-33.544261],[-297.222262,-33.892231],[-292.952005,-33.354030],[-289.573794,-32.454443],[-286.592764,-31.370581],[-284.331739,-30.238887],[-283.113545,-29.195800],[-282.598039,-28.821348],[-281.675242,-28.645593],[-278.814947,-28.855910],[-274.947010,-29.758230],[-270.485775,-31.284030],[-264.283702,-33.368084],[-258.699170,-34.262374],[-252.648408,-34.028407],[-245.047645,-32.727690],[-239.301869,-31.744830],[-234.183108,-31.253614],[-230.248878,-31.282514],[-228.056695,-31.860000],[-225.991380,-32.679534],[-222.402581,-33.367485],[-217.795060,-33.851669],[-212.673575,-34.059900],[-205.840915,-33.855893],[-203.372506,-33.453169],[-201.359114,-32.768111],[-199.668039,-31.739331],[-198.166583,-30.305439],[-195.201735,-25.976760],[-193.637928,-22.451659],[-192.582391,-18.276105],[-192.022319,-13.795446],[-191.944906,-9.355033],[-192.337346,-5.300214],[-193.186833,-1.976339],[-194.480562,0.271242],[-195.290014,0.883501],[-196.205725,1.097180],[-196.593216,1.307835],[-196.809387,1.911578],[-196.750405,4.129001],[-196.074061,7.410788],[-194.825635,11.418280],[-192.072280,20.371981],[-191.408014,23.810921],[-191.219187,26.582784],[-191.506175,28.706216],[-192.269351,30.199867],[-193.509089,31.082382],[-195.225765,31.372410],[-197.297364,31.111622],[-199.338998,30.366242],[-201.294912,29.191742],[-203.109354,27.643597],[-204.726569,25.777281],[-206.090805,23.648267],[-207.146308,21.312028],[-207.837325,18.824040],[-208.735288,16.165940],[-210.142234,14.214944],[-211.865184,12.984250],[-213.711162,12.487054],[-215.487191,12.736553],[-217.000292,13.745946],[-218.057490,15.528429],[-218.465805,18.097200],[-218.670203,21.321297],[-219.217223,24.147651],[-220.075099,26.534799],[-221.212068,28.441279],[-222.596365,29.825626],[-224.196226,30.646379],[-225.979888,30.862075],[-227.915585,30.431250],[-229.222310,29.735308],[-230.224687,28.651965],[-230.944012,27.000273],[-231.401584,24.599284],[-231.616657,16.825625],[-231.040285,3.883410],[-230.480996,-8.682977],[-230.650159,-16.243921],[-231.045571,-18.504516],[-231.668290,-19.942345],[-232.533379,-20.700275],[-233.655905,-20.921170],[-235.222156,-20.703997],[-236.504781,-20.112685],[-237.371422,-19.237543],[-237.689715,-18.168880],[-238.088692,-17.100216],[-239.175015,-16.225070],[-240.782776,-15.633755],[-242.746065,-15.416580],[-244.232410,-15.296383],[-245.386445,-14.850889],[-246.240876,-13.952741],[-246.828410,-12.474584],[-247.333610,-7.268820],[-247.163695,1.785250],[-247.032560,16.545490],[-247.418590,21.744264],[-248.151092,25.652379],[-249.264123,28.392512],[-250.791738,30.087343],[-252.767994,30.859549],[-255.226945,30.831810],[-257.011613,30.463612],[-258.401212,29.809115],[-259.448749,28.687605],[-260.207232,26.918372],[-260.729669,24.320703],[-261.069067,20.713886],[-261.410775,9.749960],[-261.812651,0.249062],[-262.708389,-6.967011],[-264.152719,-12.189280],[-265.097711,-14.143680],[-266.200375,-15.708760],[-268.169520,-17.785140],[-270.026932,-19.317039],[-271.726126,-20.299427],[-273.220616,-20.727278],[-274.463917,-20.595561],[-275.409542,-19.899250],[-276.011007,-18.633316],[-276.221825,-16.792730],[-276.644878,-15.236123],[-277.782876,-14.031393],[-279.439077,-13.200400],[-281.416739,-12.765003],[-283.519119,-12.747062],[-285.549477,-13.168439],[-287.311070,-14.050991],[-288.607155,-15.416580],[-289.629398,-16.550641],[-291.006179,-17.378797],[-292.586212,-17.896810],[-294.218211,-18.100443],[-295.750893,-17.985458],[-297.032970,-17.547617],[-297.913160,-16.782684],[-298.240175,-15.686420],[-297.425776,-14.301290],[-295.208354,-12.365020],[-291.926567,-10.134233],[-287.919075,-7.865550],[-282.449651,-4.681342],[-280.593414,-3.154816],[-279.211489,-1.505648],[-278.220369,0.390936],[-277.536550,2.659705],[-276.756795,8.812890],[-276.528167,14.844092],[-276.872582,19.775631],[-277.864201,23.698589],[-279.577186,26.704042],[-282.085699,28.883072],[-285.463900,30.326757],[-289.785951,31.126176],[-295.126015,31.372410],[-304.991679,30.833417],[-308.412311,30.249986],[-310.166775,29.537540]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-206.038345,-12.664290],[-206.502009,-14.587353],[-207.734339,-15.891965],[-209.497343,-16.596349],[-211.553030,-16.718730],[-213.663407,-16.277333],[-215.590481,-15.290381],[-217.096261,-13.776098],[-217.942755,-11.752710],[-218.108120,-9.359358],[-217.860062,-8.542475],[-217.363626,-7.957730],[-215.541970,-7.421483],[-212.475845,-7.624270],[-209.976282,-8.303980],[-207.929359,-9.480804],[-206.546303,-10.989366],[-206.038345,-12.664290]]);
    }
    linear_extrude(height=h)
      polygon([[-14.153225,-0.967040],[-13.377795,-33.306490],[-2.368625,-33.657520],[7.898484,-33.568910],[11.531126,-33.114561],[14.265184,-32.345480],[16.177178,-31.230640],[17.343626,-29.739013],[17.841049,-27.839572],[17.745965,-25.501290],[16.965906,-22.549320],[16.305861,-21.558454],[15.398850,-20.854591],[14.194657,-20.410426],[12.643066,-20.198652],[8.296825,-20.363050],[4.336535,-20.465121],[1.345926,-19.902625],[-0.751745,-18.648156],[-2.033225,-16.674310],[-2.730037,-14.365186],[-2.909168,-12.395384],[-2.560986,-10.755215],[-1.675855,-9.434989],[-0.244141,-8.425015],[1.743791,-7.715602],[4.297575,-7.297061],[7.426845,-7.159700],[11.332357,-6.898222],[13.821404,-6.003710],[14.610626,-5.267468],[15.136781,-4.311048],[15.521285,-1.655120],[15.134243,1.011167],[14.602060,1.968019],[13.801099,2.702681],[11.263828,3.591442],[7.264405,3.849470],[4.018720,4.119674],[1.310825,4.856712],[-0.581910,5.950222],[-1.382115,7.289840],[-2.287485,16.234790],[-3.274015,26.555890],[-3.873250,28.511768],[-5.168114,30.033747],[-7.031604,31.020928],[-9.336715,31.372410],[-11.109482,31.251331],[-12.449661,30.668536],[-13.406305,29.294691],[-14.028461,26.800460],[-14.365182,22.856506],[-14.465515,17.133496],[-14.153225,-0.967040]]);
    linear_extrude(height=h)
      polygon([[218.537805,29.308190],[218.241913,26.180513],[218.159320,19.190511],[218.622905,-2.236260],[219.355664,-18.094324],[219.814008,-23.368530],[220.405580,-27.215180],[221.184320,-29.891021],[222.204168,-31.652797],[223.519063,-32.757255],[225.182945,-33.461140],[228.018883,-33.779762],[230.904430,-33.104895],[233.670906,-31.613572],[236.149630,-29.482824],[238.171923,-26.889684],[239.569105,-24.011184],[240.172495,-21.024355],[239.813415,-18.106230],[239.331126,-15.993226],[239.294816,-14.262859],[239.682821,-13.093693],[240.473475,-12.664290],[242.143999,-12.960183],[243.765464,-13.795836],[245.284340,-15.093207],[246.647095,-16.774258],[247.800199,-18.760947],[248.690121,-20.975236],[249.263330,-23.339084],[249.466295,-25.774450],[249.764849,-29.154651],[250.234167,-30.250524],[251.002291,-31.004546],[252.133305,-31.457445],[253.691293,-31.649944],[258.344525,-31.416650],[267.222765,-30.554200],[267.777745,-4.407410],[267.769688,15.473609],[267.455913,22.622584],[266.970935,26.555890],[266.027901,28.748995],[264.713466,30.242593],[263.139134,31.049371],[261.416411,31.182015],[259.656802,30.653209],[257.971811,29.475639],[256.472944,27.661991],[255.271705,25.224950],[252.997595,19.077490],[251.046465,25.224950],[250.005817,27.648918],[248.649103,29.443417],[247.017839,30.604178],[245.153541,31.126929],[243.097723,31.007400],[240.891901,30.241321],[238.577590,28.824421],[236.196305,26.752430],[233.627910,24.319555],[232.131906,23.508597],[231.655538,23.711337],[231.290654,24.319555],[230.686515,26.752430],[229.989281,28.337704],[228.682620,29.640159],[226.953909,30.620375],[224.990526,31.238934],[222.979851,31.456414],[221.109262,31.233396],[219.566137,30.530461],[218.537855,29.308190]]);
  }
}
module DC_Slog(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-536.005414,17.361409],[-536.481861,-2.302800],[-536.838237,-8.414320],[-537.389433,-12.630191],[-538.222492,-15.388967],[-539.424450,-17.129203],[-541.082350,-18.289456],[-543.283230,-19.308281],[-545.932448,-20.848874],[-547.753134,-22.768823],[-548.715015,-25.022721],[-548.787820,-27.565161],[-548.426897,-29.165573],[-547.769889,-30.449068],[-546.695176,-31.458402],[-545.081134,-32.236333],[-539.748583,-33.269012],[-530.799264,-33.889161],[-521.018032,-34.223291],[-517.967490,-34.088941],[-515.893060,-33.663429],[-514.606791,-32.879093],[-513.920730,-31.668269],[-513.646925,-29.963292],[-513.597424,-27.696501],[-513.885455,-24.434288],[-514.816200,-22.264619],[-516.489634,-21.057874],[-519.005734,-20.684431],[-520.670030,-20.536362],[-521.969887,-19.925172],[-522.960352,-18.600382],[-523.696470,-16.311514],[-524.233288,-12.808090],[-524.625850,-7.839632],[-525.198394,7.494299],[-525.775022,22.173171],[-526.695914,30.852192],[-527.381457,33.440550],[-528.268263,35.127494],[-529.394732,36.112542],[-530.799264,36.595209],[-532.216413,36.721735],[-533.339025,36.404386],[-534.204884,35.503562],[-534.851778,33.879667],[-535.639811,27.904269],[-536.005414,17.361409]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[-516.275364,29.544929],[-515.759399,24.434373],[-514.409515,16.114598],[-510.027964,-5.546811],[-506.673622,-19.575436],[-503.973780,-28.077508],[-502.695898,-30.675499],[-501.373563,-32.395147],[-499.937414,-33.404215],[-498.318094,-33.870471],[-496.731733,-33.950467],[-495.343040,-33.645177],[-494.096476,-32.875843],[-492.936503,-31.563706],[-490.654171,-26.995984],[-488.051734,-19.311941],[-484.706989,-7.485858],[-483.306844,-0.621311],[-482.449545,4.778771],[-480.410644,13.083849],[-478.738919,18.528446],[-478.022693,20.145256],[-477.307401,21.092628],[-476.533928,21.421232],[-475.643156,21.181733],[-473.273244,19.201099],[-471.069629,16.257229],[-469.372661,12.455473],[-468.195911,7.983364],[-467.552950,3.028433],[-467.457352,-2.221788],[-467.922686,-7.579769],[-468.962527,-12.857977],[-470.590444,-17.868881],[-473.799878,-26.537257],[-474.558548,-29.445428],[-474.743910,-31.560247],[-474.349010,-32.999708],[-473.366889,-33.881806],[-471.790593,-34.324535],[-469.613164,-34.445891],[-467.163129,-33.995519],[-465.121660,-32.671504],[-463.531168,-30.514501],[-462.434064,-27.565161],[-460.771183,-22.734311],[-459.879047,-21.484907],[-458.932323,-21.011613],[-457.920418,-21.313504],[-456.832738,-22.389652],[-454.387684,-26.861011],[-452.868382,-29.523704],[-451.005572,-31.612434],[-448.967275,-33.086836],[-446.921510,-33.906547],[-445.036299,-34.031201],[-443.479660,-33.420434],[-442.419615,-32.033882],[-442.024184,-29.831181],[-442.374158,-26.891921],[-443.336539,-22.598672],[-446.510274,-12.256851],[-448.920102,-4.901144],[-449.460792,-2.115606],[-449.534738,0.441754],[-449.123994,3.045964],[-448.210614,5.972048],[-444.804164,13.889939],[-438.598344,27.480709],[-435.125724,13.719239],[-428.020844,-17.244061],[-425.906762,-26.257778],[-424.938211,-29.276339],[-423.933575,-31.468026],[-422.821546,-32.956831],[-421.530813,-33.866748],[-419.990069,-34.321771],[-418.128004,-34.445891],[-415.121686,-34.046610],[-413.926859,-33.519846],[-412.912058,-32.750409],[-411.345943,-30.409749],[-410.270164,-26.877091],[-403.336994,2.799219],[-399.549252,19.512242],[-398.607353,25.058024],[-398.301291,29.052712],[-398.631958,31.738353],[-399.600245,33.356993],[-401.207043,34.150676],[-403.453244,34.361449],[-405.903284,33.911077],[-407.944756,32.587062],[-409.535250,30.430055],[-410.632354,27.480709],[-411.717397,24.574746],[-413.291575,22.412923],[-415.284188,21.064810],[-417.624534,20.599979],[-419.933028,21.133817],[-422.271529,22.596939],[-424.386605,24.781765],[-426.024824,27.480709],[-428.035038,30.922556],[-429.217884,32.123164],[-430.615115,33.024841],[-432.298652,33.663547],[-434.340415,34.075244],[-439.786294,34.361449],[-445.232172,34.075244],[-447.273933,33.663547],[-448.957469,33.024841],[-450.354700,32.123164],[-451.537546,30.922556],[-453.547764,27.480709],[-456.352973,22.621194],[-457.666320,21.142912],[-458.694974,20.599979],[-459.612513,21.142912],[-460.623334,22.621194],[-461.604747,24.809052],[-462.434064,27.480709],[-463.741966,31.103368],[-464.678592,32.311509],[-465.940803,33.185562],[-467.631446,33.776554],[-469.853373,34.135515],[-476.302474,34.361449],[-482.657954,34.146644],[-484.834286,33.813549],[-486.463733,33.272581],[-487.636832,32.480679],[-488.444122,31.394786],[-488.976143,29.971843],[-489.323434,28.168789],[-490.135912,25.321609],[-491.700546,23.246559],[-494.095352,21.875745],[-497.398344,21.141269],[-501.152365,21.026712],[-502.506008,21.352068],[-503.585205,21.996009],[-504.445804,23.006159],[-505.143653,24.430139],[-506.274494,28.710079],[-507.331381,32.298084],[-508.767101,34.917776],[-510.419841,36.555647],[-512.127788,37.198191],[-513.729127,36.831898],[-515.062045,35.443262],[-515.964728,33.018775],[-516.275364,29.544929]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-496.122184,2.798229],[-495.727881,1.101090],[-495.800390,-0.533094],[-496.304219,-1.918374],[-497.203874,-2.868801],[-498.225861,-3.053275],[-499.062784,-2.353003],[-499.628274,-0.900560],[-499.835964,1.171479],[-499.562697,5.029332],[-499.236547,6.106733],[-498.797770,6.610442],[-498.256657,6.535952],[-497.623495,5.878758],[-496.122184,2.798229]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-418.139314,0.817869],[-418.751226,-0.299458],[-419.250691,-0.376407],[-419.610181,0.559495],[-419.802164,2.480719],[-419.755319,4.397777],[-419.467156,5.717884],[-418.985107,6.322507],[-418.356604,6.093109],[-417.825013,5.162404],[-417.606846,3.857568],[-417.709234,2.351693],[-418.139304,0.817869]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[-341.532714,23.443759],[-344.704907,16.323896],[-346.853894,9.363257],[-348.074066,2.165172],[-348.459814,-5.667031],[-348.184316,-14.006787],[-347.754696,-17.144833],[-347.054721,-19.816201],[-346.027560,-22.186795],[-344.616381,-24.422524],[-340.414644,-29.153011],[-337.013413,-32.342960],[-333.980256,-34.668902],[-331.195745,-36.140213],[-328.540450,-36.766271],[-325.894944,-36.556454],[-323.139795,-35.520139],[-320.155577,-33.666706],[-316.822860,-31.005531],[-313.249949,-27.264268],[-311.899537,-25.187200],[-310.790719,-22.849876],[-309.150547,-17.026570],[-308.034810,-9.058571],[-307.638917,-2.031807],[-307.837217,5.009200],[-308.574129,11.830850],[-309.794070,18.199542],[-311.441459,23.881675],[-313.460713,28.643650],[-315.796251,32.251865],[-317.065257,33.550312],[-318.392490,34.472719],[-322.128887,36.201618],[-325.463100,37.119425],[-328.475669,37.187756],[-331.247133,36.368224],[-333.858030,34.622445],[-336.388900,31.912031],[-338.920282,28.198598],[-341.532714,23.443759]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-319.380560,11.229019],[-318.821308,7.149875],[-318.857587,2.263641],[-319.397412,-3.013285],[-320.348801,-8.264507],[-321.619772,-13.073629],[-323.118340,-17.024255],[-324.752524,-19.699987],[-325.591727,-20.429645],[-326.430340,-20.684431],[-328.573832,-20.259723],[-330.606085,-19.050433],[-332.473298,-17.153815],[-334.121666,-14.667118],[-335.497388,-11.687596],[-336.546659,-8.312499],[-337.215678,-4.639080],[-337.450640,-0.764591],[-337.289734,2.467914],[-336.831103,5.481266],[-336.110874,8.251486],[-335.165173,10.754597],[-332.741873,14.863572],[-331.336527,16.421479],[-329.850222,17.616361],[-328.319086,18.424237],[-326.779244,18.821131],[-325.266827,18.783061],[-323.817960,18.286051],[-322.468773,17.306121],[-321.255392,15.819291],[-320.213945,13.801584],[-319.380560,11.229019]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[-90.248870,32.385879],[-93.236016,30.315665],[-95.608778,28.077370],[-97.434524,25.456977],[-98.780620,22.240473],[-99.714431,18.213841],[-100.303324,13.163065],[-100.715820,-0.866981],[-100.580680,-6.091542],[-100.160847,-10.962087],[-99.469858,-15.463296],[-98.521249,-19.579849],[-97.328556,-23.296428],[-95.905315,-26.597713],[-94.265064,-29.468385],[-92.421337,-31.893124],[-90.387673,-33.856612],[-88.177607,-35.343530],[-85.804676,-36.338557],[-83.282415,-36.826375],[-80.624362,-36.791665],[-77.844052,-36.219107],[-74.955023,-35.093382],[-71.970810,-33.399171],[-69.050550,-30.940033],[-66.536783,-27.730123],[-64.427757,-23.879758],[-62.721720,-19.499255],[-61.416921,-14.698930],[-60.511609,-9.589101],[-60.004033,-4.280084],[-59.892441,1.117802],[-60.175082,6.494241],[-60.850205,11.738917],[-61.916058,16.741511],[-63.370890,21.391707],[-65.212949,25.579188],[-67.440485,29.193637],[-70.051746,32.124736],[-73.044980,34.262169],[-77.436426,36.306063],[-79.234696,36.740649],[-80.967909,36.761859],[-82.785998,36.353340],[-84.838899,35.498738],[-90.248870,32.385879]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-75.982750,17.905919],[-74.983175,17.051354],[-74.129579,15.833989],[-72.844661,12.242773],[-72.096678,6.996095],[-71.854310,-0.042221],[-72.000906,-5.251128],[-72.459710,-9.605415],[-73.259242,-13.156121],[-74.428024,-15.954284],[-75.994577,-18.050944],[-77.987423,-19.497140],[-80.435084,-20.343909],[-83.366080,-20.642291],[-84.620995,-20.321047],[-85.770508,-19.374581],[-86.807524,-17.879411],[-87.724952,-15.912059],[-89.172676,-10.866886],[-90.056940,-4.851224],[-90.321007,1.522766],[-89.908138,7.642922],[-88.761595,12.897084],[-87.895465,15.008116],[-86.824640,16.673089],[-84.307370,19.297239],[-83.189701,20.008807],[-82.065067,20.331516],[-80.857762,20.273972],[-79.492078,19.844786],[-75.982750,17.905919]]);
    }
    linear_extrude(height=h)
      polygon([[242.992020,34.865169],[240.752670,33.924940],[238.703579,32.517498],[236.878134,30.697490],[235.309720,28.519564],[234.031725,26.038369],[233.077536,23.308551],[232.480538,20.384758],[232.274120,17.321639],[232.620135,14.246388],[233.551633,11.900588],[234.908793,10.319080],[236.531795,9.536706],[238.260819,9.588308],[239.936045,10.508728],[241.397652,12.332808],[242.485820,15.095389],[243.520128,17.415385],[245.104968,19.105567],[247.028150,20.157648],[249.077483,20.563342],[251.040776,20.314362],[252.705840,19.402421],[253.860485,17.819232],[254.292520,15.556509],[254.084822,14.399248],[253.488259,13.064395],[251.287733,10.042432],[248.009325,6.851648],[243.971420,3.853069],[238.589686,-0.009941],[236.735177,-1.805905],[235.337745,-3.675399],[234.322016,-5.741345],[233.612617,-8.126660],[232.811320,-14.347081],[232.727183,-17.766304],[232.973720,-20.954527],[233.529572,-23.896710],[234.373378,-26.577819],[235.483779,-28.982814],[236.839416,-31.096659],[238.418929,-32.904318],[240.200957,-34.390752],[242.164143,-35.540924],[244.287126,-36.339798],[246.548546,-36.772337],[248.927043,-36.823502],[251.401259,-36.478257],[253.949834,-35.721565],[256.551407,-34.538389],[259.184620,-32.913691],[261.892687,-30.385540],[263.865540,-27.291346],[265.094855,-23.909472],[265.572307,-20.518278],[265.289574,-17.396128],[264.238331,-14.821382],[263.421917,-13.826273],[262.410254,-13.072402],[261.202302,-12.594563],[259.797020,-12.427551],[257.646806,-12.750086],[255.897982,-13.631682],[254.722553,-14.943322],[254.292520,-16.555991],[253.974874,-18.214860],[253.123379,-19.447694],[251.890206,-20.242815],[250.427520,-20.588548],[248.887491,-20.473216],[247.422286,-19.885141],[246.184073,-18.812648],[245.325020,-17.244061],[245.291893,-16.439164],[245.651003,-15.468278],[247.402933,-13.176454],[250.294806,-10.664429],[254.040620,-8.228041],[259.377790,-4.845041],[261.159471,-3.214995],[262.469057,-1.417007],[263.395933,0.705607],[264.029481,3.309530],[264.774120,10.588039],[264.849776,17.681228],[264.102997,23.640338],[262.545226,28.452616],[261.465795,30.424708],[260.187908,32.105309],[258.712994,33.492826],[257.042484,34.585664],[255.177809,35.382229],[253.120400,35.880928],[250.871685,36.080165],[248.433097,35.978347],[242.992020,34.865169]]);
    linear_extrude(height=h)
      polygon([[-389.744214,7.956989],[-389.898082,-6.371821],[-390.161730,-11.093059],[-390.613244,-14.506164],[-391.300166,-16.851622],[-392.270039,-18.369916],[-393.570404,-19.301531],[-395.248804,-19.886951],[-397.616007,-20.934530],[-399.340753,-22.649323],[-400.395672,-24.991382],[-400.753394,-27.920761],[-400.688956,-30.058361],[-400.325437,-31.671050],[-399.407529,-32.827846],[-397.679926,-33.597766],[-394.887321,-34.049828],[-390.774405,-34.253051],[-377.566414,-34.189051],[-354.379434,-33.863071],[-352.577014,-14.200351],[-351.570443,3.728873],[-351.471545,12.328999],[-351.681424,19.223829],[-352.370404,26.402607],[-352.865219,28.862522],[-353.524863,30.702703],[-354.397795,32.023085],[-355.532475,32.923603],[-356.977361,33.504192],[-358.780914,33.864789],[-360.789833,34.073507],[-362.309408,33.855848],[-363.407905,32.915990],[-364.153591,30.958111],[-364.614735,27.686387],[-364.859601,22.804997],[-364.973574,7.029929],[-365.172986,-3.731034],[-365.715938,-12.543334],[-366.519505,-18.497593],[-366.993106,-20.118776],[-367.500764,-20.684431],[-370.849895,-20.494118],[-373.467985,-19.771274],[-375.442720,-18.288038],[-376.861784,-15.816551],[-377.812863,-12.128951],[-378.383643,-6.997380],[-378.735044,8.509119],[-378.875994,22.680908],[-379.128339,27.243502],[-379.569626,30.441828],[-380.250628,32.514337],[-381.222115,33.699477],[-382.534860,34.235698],[-384.239634,34.361449],[-385.946753,34.234619],[-387.260598,33.690850],[-388.232227,32.485220],[-388.912700,30.372812],[-389.353076,27.108704],[-389.604414,22.447978],[-389.744214,7.956989]]);
    linear_extrude(height=h)
      polygon([[-304.423110,-0.233651],[-304.310882,-19.848425],[-304.075519,-25.946430],[-303.636140,-30.058402],[-302.929360,-32.549504],[-301.891792,-33.784901],[-300.460051,-34.129758],[-298.570750,-33.949241],[-297.116691,-33.565741],[-295.715566,-32.858098],[-293.059919,-30.455793],[-290.579410,-26.713137],[-288.249640,-21.600941],[-284.125210,-12.017535],[-282.632439,-9.547834],[-281.478946,-8.619681],[-281.019971,-8.732171],[-280.634467,-9.228232],[-280.068737,-11.368647],[-279.652470,-20.225701],[-279.466580,-27.672662],[-279.174913,-30.167825],[-278.698049,-31.980291],[-277.996450,-33.212194],[-277.030580,-33.965672],[-275.760902,-34.342858],[-274.147880,-34.445891],[-272.415228,-34.303438],[-271.089399,-33.650305],[-270.116206,-32.147831],[-269.441465,-29.457356],[-269.010989,-25.240218],[-268.770594,-19.157757],[-268.643300,-0.042221],[-268.786317,18.411879],[-269.428221,28.784971],[-270.036032,31.649992],[-270.888295,33.345385],[-272.024921,34.154690],[-273.485820,34.361449],[-275.582373,34.058411],[-277.554389,33.155565],[-279.395368,31.662315],[-281.098810,29.588063],[-282.658214,26.942214],[-284.067081,23.734169],[-285.318909,19.973333],[-286.407200,15.669109],[-287.445601,12.177892],[-288.667458,9.883380],[-289.939532,8.730293],[-291.128589,8.663348],[-292.101390,9.627265],[-292.724698,11.566762],[-292.865277,14.426557],[-292.389890,18.151369],[-291.823797,21.824244],[-291.676152,25.057604],[-291.940443,27.835975],[-292.610156,30.143884],[-293.678780,31.965860],[-295.139802,33.286427],[-296.986709,34.090115],[-299.212990,34.361449],[-300.825223,34.191891],[-302.067111,33.471220],[-302.986546,31.881447],[-303.631419,29.104579],[-304.049620,24.822627],[-304.289042,18.717599],[-304.423110,-0.233651]]);
    linear_extrude(height=h)
      polygon([[-241.169740,32.297229],[-245.248800,4.086219],[-248.249943,-16.692935],[-248.954557,-23.479031],[-249.116027,-28.298513],[-248.724976,-31.478160],[-247.772023,-33.344752],[-246.247791,-34.225069],[-244.142900,-34.445891],[-242.648733,-34.293578],[-241.402777,-33.770088],[-240.362015,-32.775594],[-239.483429,-31.210266],[-238.040719,-25.967798],[-236.730510,-17.244061],[-234.552480,-0.042221],[-231.574530,-16.555991],[-229.835311,-24.922208],[-228.041212,-30.087359],[-226.999631,-31.712098],[-225.795588,-32.827646],[-224.379501,-33.531028],[-222.701790,-33.919271],[-220.950254,-34.051656],[-219.497861,-33.822182],[-218.277333,-33.122553],[-217.221395,-31.844471],[-216.262769,-29.879638],[-215.334179,-27.119757],[-213.298000,-18.781661],[-209.788990,-2.794521],[-207.252340,-18.620211],[-205.750348,-26.635769],[-204.156877,-31.459981],[-203.210348,-32.902794],[-202.102363,-33.820727],[-200.786725,-34.304764],[-199.217240,-34.445891],[-196.439315,-34.118810],[-195.560518,-33.622968],[-194.987409,-32.828264],[-194.694173,-31.676705],[-194.654995,-30.110294],[-195.235550,-25.500941],[-200.196730,8.902729],[-202.234591,22.749732],[-203.128368,27.238317],[-204.051357,30.404603],[-205.088046,32.474325],[-206.322920,33.673217],[-207.840466,34.227014],[-209.725170,34.361449],[-211.546410,34.251724],[-213.009848,33.837760],[-214.177087,32.992376],[-215.109731,31.588388],[-215.869385,29.498615],[-216.517651,26.595874],[-217.726440,17.842759],[-218.591094,11.864909],[-219.636116,6.861801],[-220.771202,2.988351],[-221.906046,0.399474],[-222.950343,-0.749914],[-223.410316,-0.736390],[-223.813788,-0.304900],[-224.406076,1.889433],[-224.636900,5.987999],[-225.159359,14.480012],[-226.373160,24.040339],[-227.495307,29.256783],[-228.173608,31.059930],[-228.992139,32.404246],[-229.997458,33.348142],[-231.236126,33.950033],[-234.599740,34.361449],[-237.135473,34.198569],[-239.219432,33.755084],[-240.636046,33.098727],[-241.169740,32.297229]]);
    linear_extrude(height=h)
      polygon([[-191.579080,0.233009],[-191.579080,-33.895441],[-182.143200,-33.895441],[-172.297447,-34.432973],[-161.876130,-35.725351],[-156.512900,-36.366966],[-152.420000,-36.178932],[-149.221475,-35.095692],[-146.541370,-33.051691],[-144.792710,-31.535732],[-143.360712,-30.737288],[-142.393149,-30.707373],[-142.037790,-31.497001],[-141.615930,-32.642004],[-140.467301,-33.579658],[-138.767335,-34.213206],[-136.691460,-34.445891],[-135.212487,-34.331140],[-133.996643,-33.948020],[-133.013061,-33.238229],[-132.230876,-32.143466],[-131.147236,-28.565814],[-130.498800,-22.748651],[-129.848031,-16.879279],[-128.754044,-13.307424],[-127.955801,-12.226436],[-126.944704,-11.531870],[-125.686736,-11.161076],[-124.147880,-11.051401],[-122.609027,-11.161076],[-121.351062,-11.531870],[-120.339966,-12.226436],[-119.541725,-13.307424],[-118.447738,-16.879279],[-117.796970,-22.748651],[-117.148529,-28.565814],[-116.064890,-32.143466],[-115.282706,-33.238229],[-114.299126,-33.948020],[-113.083282,-34.331140],[-111.604310,-34.445891],[-109.936615,-34.289515],[-108.656010,-33.602571],[-107.711723,-32.058330],[-107.052980,-29.330066],[-106.629007,-25.091050],[-106.389032,-19.014555],[-106.257980,-0.042221],[-106.385274,19.073311],[-106.625669,25.155772],[-107.056145,29.372911],[-107.730886,32.063387],[-108.704079,33.565862],[-110.029908,34.218996],[-111.762560,34.361449],[-113.371672,34.258939],[-114.639514,33.885405],[-115.605145,33.141846],[-116.307621,31.929258],[-116.786002,30.148638],[-117.079345,27.700984],[-117.267150,20.408559],[-117.429913,12.811285],[-117.717470,10.390805],[-118.217239,8.731269],[-118.985287,7.714307],[-120.077685,7.221548],[-121.550503,7.134623],[-123.459810,7.335159],[-125.249848,7.692593],[-126.687266,8.263057],[-127.818218,9.138133],[-128.688856,10.409403],[-129.345334,12.168448],[-129.833805,14.506850],[-130.491340,21.288049],[-131.128490,27.898953],[-132.185346,31.885358],[-132.959119,33.080059],[-133.943365,33.841459],[-135.173264,34.243831],[-136.684000,34.361449],[-138.334970,34.221389],[-139.608419,33.633792],[-140.552857,32.347536],[-141.216796,30.111499],[-141.648748,26.674559],[-141.897223,21.785592],[-142.037790,6.647089],[-142.151774,-9.127979],[-142.396651,-14.009368],[-142.857802,-17.281092],[-143.603494,-19.238971],[-144.701990,-20.178830],[-146.221554,-20.396488],[-148.230450,-20.187771],[-150.186409,-19.801504],[-151.694423,-19.085289],[-152.823693,-17.764381],[-153.643417,-15.564037],[-154.222796,-12.209513],[-154.631028,-7.426065],[-155.210850,7.526579],[-155.786850,22.084001],[-156.182452,26.813626],[-156.722021,30.156879],[-157.459736,32.348524],[-158.449771,33.623325],[-159.746304,34.216046],[-161.403510,34.361449],[-163.073349,34.226204],[-164.360416,33.654874],[-165.314064,32.399072],[-165.983647,30.210409],[-166.418522,26.840496],[-166.668040,22.040944],[-166.808430,7.159369],[-166.929174,-8.432914],[-167.196093,-13.312142],[-167.703810,-16.674058],[-168.529651,-18.839134],[-169.750941,-20.127843],[-171.445005,-20.860658],[-173.689170,-21.358051],[-175.960123,-21.748413],[-177.667240,-21.769091],[-178.891558,-21.173992],[-179.714115,-19.717026],[-180.215947,-17.152099],[-180.478092,-13.233121],[-180.607470,-0.348641],[-180.999011,16.011368],[-181.494156,22.026095],[-182.215817,26.727788],[-183.184197,30.214308],[-184.419493,32.583517],[-185.941907,33.933277],[-187.771640,34.361449],[-188.807195,34.011549],[-189.647791,32.857074],[-190.310961,30.740861],[-190.814239,27.505746],[-191.411247,17.050159],[-191.579080,0.233009]]);
    linear_extrude(height=h)
      polygon([[-51.532690,29.846719],[-52.425240,28.318041],[-53.233977,25.985042],[-54.598890,18.914251],[-55.625170,8.650689],[-56.310560,-4.789301],[-57.341540,-34.910621],[-50.836440,-33.990201],[-48.728735,-33.622352],[-47.147303,-33.004535],[-46.030880,-31.850270],[-45.318204,-29.873073],[-44.948011,-26.786464],[-44.859038,-22.303962],[-45.279700,-8.005351],[-45.606301,5.048978],[-45.232852,12.910307],[-44.721511,15.345508],[-43.960637,17.024752],[-42.925394,18.128804],[-41.590940,18.838429],[-38.813739,19.656993],[-36.612097,19.624837],[-35.707340,19.233777],[-34.922748,18.562883],[-33.682425,16.292054],[-32.827861,12.633274],[-32.295788,7.407465],[-31.946050,-8.461551],[-31.805378,-22.709661],[-31.553277,-27.295718],[-31.112210,-30.509772],[-30.431336,-32.591819],[-29.459814,-33.781857],[-28.146802,-34.319882],[-26.441460,-34.445891],[-24.727031,-34.315385],[-23.409755,-33.745883],[-22.437678,-32.470407],[-21.758846,-30.221981],[-21.321305,-26.733626],[-21.073099,-21.738366],[-20.936880,-6.159221],[-21.100642,5.146776],[-21.656466,14.226642],[-22.701157,21.301885],[-24.331522,26.594011],[-25.396585,28.640625],[-26.644368,30.324524],[-28.086973,31.673396],[-29.736501,32.714931],[-31.605051,33.476815],[-33.704726,33.986737],[-38.645850,34.361449],[-42.522185,34.011277],[-46.220915,33.051428],[-49.353822,31.617908],[-51.532690,29.846719]]);
    linear_extrude(height=h)
      polygon([[-4.423110,6.838509],[-4.530622,-9.073190],[-4.785962,-13.964963],[-5.283202,-17.244063],[-6.102978,-19.233026],[-7.325922,-20.254385],[-9.032668,-20.630675],[-11.303850,-20.684431],[-14.701209,-20.985462],[-15.899961,-21.410131],[-16.808432,-22.060574],[-17.458877,-22.969045],[-17.883547,-24.167798],[-18.184580,-27.565161],[-18.093125,-29.775712],[-17.760437,-31.518067],[-17.099031,-32.845688],[-16.021422,-33.812037],[-14.440126,-34.470577],[-12.267657,-34.874771],[-5.799260,-35.133971],[6.869539,-34.932311],[10.991872,-34.585989],[13.909905,-33.992228],[15.826448,-33.088197],[16.944311,-31.811064],[17.466302,-30.097996],[17.595230,-27.886161],[17.236075,-24.976410],[16.178769,-22.643997],[14.453548,-20.932863],[12.090650,-19.886951],[10.412253,-19.301531],[9.111889,-18.369916],[8.142017,-16.851622],[7.455094,-14.506164],[7.003579,-11.093059],[6.739929,-6.371821],[6.586060,7.956989],[6.446260,22.447978],[6.194922,27.108704],[5.754545,30.372812],[5.074071,32.485220],[4.102440,33.690850],[2.788593,34.234619],[1.081470,34.361449],[-0.630114,34.232435],[-1.946054,33.673373],[-2.917957,32.426238],[-3.597427,30.233002],[-4.036072,26.835638],[-4.285497,21.976119],[-4.423110,6.838509]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[36.861320,-0.042221],[36.861320,-34.445891],[50.196220,-34.445891],[56.514272,-34.159622],[61.467783,-33.263072],[65.257987,-31.699624],[68.086120,-29.412661],[69.938286,-26.624525],[71.295753,-23.081312],[72.152325,-19.061816],[72.501808,-14.844831],[72.338004,-10.709151],[71.654718,-6.933572],[70.445756,-3.796887],[68.704920,-1.577891],[67.258619,-0.061190],[66.300265,1.714355],[65.834467,3.791437],[65.865833,6.212748],[66.398972,9.020982],[67.438493,12.258832],[71.055120,20.194149],[74.262547,27.178990],[74.969127,29.646771],[75.066083,31.518866],[74.544762,32.860827],[73.396512,33.738209],[71.612682,34.216565],[69.184620,34.361449],[67.466433,34.197167],[65.867628,33.669181],[64.340516,32.724785],[62.837408,31.311272],[59.712443,26.866064],[56.111220,19.911899],[49.246620,5.462359],[48.414720,19.911899],[47.787283,27.316812],[46.752370,31.711937],[45.985384,33.006503],[45.000458,33.819431],[43.758900,34.240990],[42.222020,34.361449],[40.548407,34.206377],[39.263687,33.522596],[38.316774,31.982263],[37.656583,29.257534],[37.232027,25.020566],[36.992022,18.943513],[36.861320,-0.042221]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[57.278420,-8.593571],[58.885099,-9.469204],[60.132631,-10.665109],[61.004091,-12.084651],[61.482558,-13.631198],[61.551107,-15.208117],[61.192815,-16.718776],[60.390761,-18.066542],[59.128020,-19.154781],[57.392469,-19.848795],[55.529603,-19.955817],[53.649985,-19.544812],[51.864183,-18.684742],[50.282759,-17.444570],[49.016281,-15.893261],[48.175313,-14.099776],[47.870420,-12.133081],[47.979234,-10.295984],[48.327498,-8.881991],[48.947941,-7.878787],[49.873295,-7.274057],[51.136289,-7.055485],[52.769654,-7.210757],[57.278420,-8.593571]]);
    }
    linear_extrude(height=h)
      polygon([[78.145720,-0.042221],[78.145720,-34.445891],[94.850920,-34.445891],[104.084639,-34.299318],[106.998086,-34.025927],[108.980770,-33.538976],[110.186322,-32.778348],[110.768376,-31.683926],[110.880565,-30.195592],[110.676520,-28.253231],[109.787059,-25.218465],[108.999136,-24.052577],[107.933633,-23.085898],[104.823525,-21.644798],[100.164020,-20.684431],[95.987601,-19.763374],[92.961495,-18.450364],[91.094889,-16.885537],[90.396970,-15.209031],[90.876926,-13.560981],[92.543945,-12.081525],[95.407214,-10.910799],[99.475920,-10.188941],[103.968789,-9.488546],[105.530354,-8.951086],[106.699720,-8.235563],[107.525174,-7.302061],[108.055001,-6.110664],[108.420920,-2.794521],[108.055001,0.521627],[107.525174,1.713024],[106.699720,2.646526],[105.530354,3.362048],[103.968789,3.899506],[99.475920,4.599899],[94.924173,5.305137],[93.360170,5.850274],[92.199820,6.585156],[91.389926,7.555830],[90.877292,8.808346],[90.531020,12.343099],[90.885590,15.963767],[91.437740,17.216298],[92.336633,18.169531],[93.654892,18.877895],[95.465143,19.395819],[100.852120,20.078059],[106.208004,20.758743],[108.016960,21.273569],[109.339970,21.973196],[110.247067,22.908981],[110.808286,24.132282],[111.173220,27.646869],[111.106394,29.764799],[110.796659,31.384138],[110.080126,32.571525],[108.792908,33.393596],[106.771116,33.916987],[103.850862,34.208335],[94.659420,34.361449],[78.145720,34.361449],[78.145720,-0.042221]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[116.456420,30.921079],[115.729420,-3.482591],[115.223720,-34.445891],[127.909520,-34.445891],[133.150603,-34.171213],[137.640159,-33.337929],[141.394436,-31.932161],[144.429683,-29.940032],[146.762146,-27.347666],[148.408075,-24.141185],[149.383717,-20.306712],[149.705320,-15.830371],[149.490815,-10.702363],[148.847409,-6.165740],[147.775268,-2.220797],[146.274558,1.132172],[144.345442,3.892872],[141.988087,6.061010],[139.202658,7.636290],[135.989320,8.618419],[131.436561,9.836541],[129.971249,10.680947],[128.944370,11.851042],[128.279216,13.473417],[127.899079,15.674667],[127.687020,22.320159],[127.483054,28.507440],[127.175570,30.615338],[126.684395,32.168208],[125.974510,33.242653],[125.010898,33.915274],[123.758541,34.262672],[122.182420,34.361449],[120.027592,34.089982],[118.229745,33.350839],[116.976736,32.256909],[116.456420,30.921079]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[136.836520,-16.823511],[135.746707,-18.816177],[134.383231,-20.075748],[132.875228,-20.638371],[131.351833,-20.540193],[129.942179,-19.817362],[128.775403,-18.506024],[127.980638,-16.642328],[127.687020,-14.262421],[127.843937,-11.611944],[128.271183,-9.142688],[128.903497,-7.130621],[129.675620,-5.851711],[130.879785,-5.310970],[132.252961,-5.710830],[133.666491,-6.854162],[134.991720,-8.543842],[136.099993,-10.582743],[136.862654,-12.773739],[137.151049,-14.919703],[136.836520,-16.823511]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[154.225120,32.242369],[153.696928,28.872121],[153.226908,21.262178],[152.666020,-2.161301],[152.416620,-34.445891],[167.024320,-34.445891],[172.956789,-34.185284],[178.311120,-33.475711],[182.499651,-32.425540],[184.934720,-31.143141],[186.284764,-28.781402],[187.274809,-25.056430],[187.899100,-20.424222],[188.151883,-15.340778],[188.027401,-10.262098],[187.519900,-5.644180],[186.623624,-1.943025],[185.332820,0.385369],[184.381574,2.067092],[183.924811,4.482426],[183.908377,7.336148],[184.278120,10.333032],[184.979888,13.177852],[185.959529,15.575384],[187.162891,17.230401],[188.535820,17.847679],[189.488604,18.499199],[190.268870,20.273139],[190.796086,22.898569],[190.989720,26.104559],[190.602641,30.284674],[189.520364,33.061633],[188.755538,33.933522],[187.861327,34.466134],[186.852536,34.663305],[185.743970,34.528872],[183.286732,33.280543],[180.608051,30.751844],[177.826368,26.973471],[175.060120,21.976119],[172.503787,17.167134],[169.991508,13.228989],[167.812209,10.568079],[166.937718,9.843586],[166.254820,9.590799],[165.694770,9.843586],[165.172292,10.568079],[164.285795,13.228989],[163.686811,17.167134],[163.466820,21.976119],[163.250108,27.686632],[162.558420,31.524611],[162.014984,32.802219],[161.329433,33.684676],[160.493975,34.196311],[159.500820,34.361449],[157.857548,34.194240],[156.315095,33.738968],[155.046579,33.065167],[154.225120,32.242369]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[175.852120,-13.803691],[175.388987,-16.339303],[174.158518,-18.126203],[172.399110,-19.170818],[170.349158,-19.479573],[168.247057,-19.058896],[166.331203,-17.915214],[164.839992,-16.054953],[164.011820,-13.484541],[163.901079,-10.668310],[164.161674,-9.675965],[164.662645,-8.931068],[165.426295,-8.411318],[166.474923,-8.094415],[169.516320,-7.979951],[172.360218,-8.446355],[174.332157,-9.543047],[175.480128,-11.314126],[175.852120,-13.803691]]);
    }
    linear_extrude(height=h)
      polygon([[193.742020,0.089119],[193.742020,-34.445891],[210.255820,-34.445891],[219.493189,-34.295376],[222.415340,-34.002409],[224.430095,-33.471124],[225.705172,-32.631640],[226.408289,-31.414073],[226.707165,-29.748541],[226.769520,-27.565161],[226.442689,-23.877518],[225.898686,-22.666671],[224.980545,-21.802548],[223.597957,-21.228706],[221.660614,-20.888702],[215.760420,-20.684431],[210.169782,-20.469408],[206.815420,-19.652321],[205.815568,-18.937369],[205.181257,-17.975141],[204.847978,-16.733383],[204.751220,-15.179841],[204.847978,-13.626296],[205.181257,-12.384536],[205.815568,-11.422308],[206.815420,-10.707357],[210.169782,-9.890272],[215.760420,-9.675251],[221.660614,-9.470979],[223.597957,-9.130975],[224.980545,-8.557133],[225.898686,-7.693010],[226.442689,-6.482163],[226.769520,-2.794521],[226.462609,0.670607],[226.016668,1.874593],[225.320358,2.776848],[224.332142,3.415361],[223.010487,3.828122],[219.200720,4.128349],[215.945456,4.305271],[213.085408,4.772420],[210.625257,5.491961],[208.569681,6.426064],[206.923361,7.536894],[205.690976,8.786621],[204.877207,10.137410],[204.486733,11.551431],[204.524233,12.990849],[204.994387,14.417832],[205.901875,15.794548],[207.251378,17.083165],[209.047574,18.245848],[211.295143,19.244767],[213.998765,20.042088],[217.163120,20.599979],[222.544823,21.521987],[225.912795,22.815497],[226.961802,23.676853],[227.651579,24.721431],[228.030196,25.979345],[228.145720,27.480709],[228.025662,29.109700],[227.580503,30.405392],[226.682768,31.414652],[225.204982,32.184342],[223.019670,32.761328],[219.999356,33.192475],[210.943820,33.804709],[193.742020,34.624099],[193.742020,0.089119]]);
    linear_extrude(height=h)
      polygon([[270.806220,-0.042171],[270.806220,-34.445841],[287.320020,-34.445841],[296.511404,-34.292727],[299.431640,-34.001381],[301.453420,-33.477991],[302.740631,-32.655921],[303.457161,-31.468534],[303.766895,-29.849193],[303.833720,-27.731261],[303.468786,-24.216678],[302.907567,-22.993376],[302.000470,-22.057591],[300.677460,-21.357963],[298.868504,-20.843136],[293.512620,-20.162451],[289.086578,-19.468191],[285.834368,-18.314560],[283.776794,-16.852324],[282.934657,-15.232249],[282.975879,-14.410137],[283.328760,-13.605102],[284.979903,-12.121647],[287.908889,-10.932651],[292.136520,-10.188881],[296.629389,-9.488488],[298.190954,-8.951029],[299.360320,-8.235507],[300.185774,-7.302005],[300.715601,-6.110608],[301.081520,-2.794461],[300.715601,0.521681],[300.185774,1.713077],[299.360320,2.646578],[298.190954,3.362101],[296.629389,3.899561],[292.136520,4.599959],[287.560436,5.333639],[285.946640,5.920566],[284.705695,6.720057],[283.780116,7.781490],[283.112417,9.154243],[282.320720,13.031229],[282.097293,17.233969],[282.433278,18.571998],[283.202783,19.500176],[284.507098,20.092785],[286.447515,20.424109],[292.641820,20.600029],[298.652842,20.801665],[300.622890,21.139364],[302.026470,21.711121],[302.956463,22.574037],[303.505748,23.785215],[303.833720,27.480769],[303.771365,29.664147],[303.472489,31.329678],[302.769372,32.547244],[301.494295,33.386729],[299.479540,33.918015],[296.557389,34.210983],[287.320020,34.361499],[270.806220,34.361499],[270.806220,-0.042171]]);
    linear_extrude(height=h)
      polygon([[308.925520,4.086269],[308.237420,-29.591621],[308.523172,-31.421536],[309.590173,-32.746485],[311.248029,-33.562526],[313.306345,-33.865718],[315.574727,-33.652120],[317.862779,-32.917790],[319.980109,-31.658787],[321.736320,-29.871171],[323.315239,-27.208911],[324.860295,-23.699489],[326.194189,-19.799219],[327.139620,-15.964411],[328.314228,-10.921395],[329.562537,-7.463816],[330.797109,-5.560789],[331.381920,-5.182581],[331.930508,-5.181429],[332.875295,-6.294852],[333.544034,-8.870173],[333.849288,-12.876508],[333.703620,-18.282971],[333.343312,-26.347845],[333.463955,-28.996251],[333.846808,-30.907009],[334.538131,-32.218902],[335.584184,-33.070709],[337.031227,-33.601212],[338.925520,-33.949191],[340.877084,-34.154123],[342.369731,-34.032848],[343.464707,-33.419227],[344.223258,-32.147122],[344.706628,-30.050394],[344.976065,-26.962905],[345.118120,-17.151091],[345.637583,0.303224],[346.886420,17.444009],[348.654620,34.361499],[340.363320,34.361499],[335.807864,33.996553],[334.177254,33.385282],[332.847695,32.350291],[331.721414,30.788186],[330.700639,28.595578],[328.584520,21.905279],[326.836900,16.188726],[325.249623,12.045076],[323.845088,9.478318],[322.645695,8.492442],[322.129926,8.593581],[321.673842,9.091437],[320.951929,11.279292],[320.502356,15.059996],[320.347520,20.437539],[320.159501,27.713210],[319.865971,30.155714],[319.387420,31.932881],[318.684844,33.143374],[317.719239,33.885858],[316.451599,34.258995],[314.842920,34.361449],[313.127049,34.221415],[311.801667,33.611018],[310.810987,32.244814],[310.099220,29.837362],[309.610578,26.103219],[309.289273,20.756942],[308.925520,4.086219]]);
    linear_extrude(height=h)
      polygon([[358.879620,8.535709],[358.724240,-5.458940],[358.459269,-10.077673],[358.006558,-13.422149],[357.318941,-15.725972],[356.349256,-17.222745],[355.050337,-18.146070],[353.375020,-18.729551],[350.945720,-19.801875],[349.227870,-21.574367],[348.207445,-24.068923],[347.870420,-27.307441],[348.190818,-31.114314],[348.713068,-32.385860],[349.584908,-33.314429],[350.887505,-33.958735],[352.702028,-34.377490],[358.191520,-34.773201],[375.393420,-35.461271],[378.762018,-35.133775],[381.273726,-33.909211],[382.903744,-32.020321],[383.627270,-29.699846],[383.419502,-27.180526],[382.255639,-24.695105],[380.110879,-22.476323],[376.960420,-20.756921],[374.672407,-19.811396],[372.939989,-18.734963],[371.685949,-17.212017],[370.833070,-14.926954],[370.304135,-11.564171],[370.021926,-6.808064],[369.888820,8.146539],[369.748628,22.527944],[369.496946,27.154981],[369.056258,30.396506],[368.375602,32.495216],[367.404018,33.693811],[366.090545,34.234990],[364.384220,34.361449],[362.679560,34.235750],[361.366868,33.699891],[360.395387,32.515736],[359.714358,30.445146],[359.273024,27.249981],[359.020628,22.692104],[358.879620,8.535659]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[378.145720,30.110639],[379.409433,21.687136],[382.447720,7.404219],[388.146150,-16.576274],[390.119427,-24.004953],[391.749783,-29.022356],[393.217992,-32.100808],[394.704834,-33.712635],[396.391084,-34.330164],[398.457520,-34.425721],[400.245138,-34.208083],[401.792920,-33.400072],[403.205196,-31.750474],[404.586295,-29.008078],[406.040547,-24.921672],[407.672283,-19.240043],[411.885520,-2.086271],[417.240983,21.345621],[419.454320,32.297279],[418.978424,33.892246],[417.750248,34.701561],[415.998183,34.810061],[413.950620,34.302584],[411.835951,33.263967],[409.882567,31.779045],[408.318859,29.932657],[407.373220,27.809639],[406.676393,25.732760],[405.732831,23.962584],[404.582783,22.495582],[403.266497,21.328223],[401.824220,20.456979],[400.296202,19.878319],[397.143933,19.584633],[394.131674,20.418928],[392.778669,21.250244],[391.581412,22.352966],[390.580150,23.723564],[389.815132,25.358509],[389.326606,27.254271],[389.154820,29.407319],[388.782120,31.497336],[387.702245,33.054103],[385.972533,34.026011],[383.650320,34.361449],[381.470348,34.037000],[379.724795,33.142011],[378.565854,31.794024],[378.145720,30.110579]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[400.164020,-1.418371],[399.946851,-2.487033],[399.355545,-3.362176],[398.480401,-3.953488],[397.411720,-4.170661],[396.343081,-3.953488],[395.467933,-3.362176],[394.876603,-2.487033],[394.659420,-1.418371],[394.876603,-0.349708],[395.467933,0.525434],[396.343081,1.116747],[397.411720,1.333919],[398.480401,1.116747],[399.355545,0.525434],[399.946851,-0.349708],[400.164020,-1.418371]]);
    }
    linear_extrude(height=h)
      polygon([[427.687020,7.029929],[427.555736,-8.332772],[427.295720,-13.208406],[426.820870,-16.601952],[426.067245,-18.804700],[424.970904,-20.107944],[423.467909,-20.802973],[421.494320,-21.181081],[418.789848,-21.964907],[416.677820,-23.436722],[415.205992,-25.548754],[414.422120,-28.253231],[414.213793,-30.251010],[414.404717,-31.765356],[415.255074,-32.863171],[417.025045,-33.611358],[419.974813,-34.076821],[424.364561,-34.326462],[438.504720,-34.445891],[463.466820,-34.445891],[463.466820,-0.042221],[463.339523,19.073311],[463.099124,25.155772],[462.668645,29.372911],[461.993900,32.063387],[461.020704,33.565862],[459.694873,34.218996],[457.962220,34.361449],[456.250641,34.232435],[454.934701,33.673373],[453.962796,32.426238],[453.283320,30.233002],[452.844669,26.835638],[452.595239,21.976119],[452.457620,6.838509],[452.350109,-9.073190],[452.094771,-13.964963],[451.597533,-17.244063],[450.777762,-19.233026],[449.554825,-20.254385],[447.848089,-20.630675],[445.576920,-20.684431],[443.305718,-20.630675],[441.598957,-20.254385],[440.376003,-19.233026],[439.556220,-17.244063],[439.058975,-13.964963],[438.803633,-9.073190],[438.696120,6.838509],[438.558515,21.976119],[438.309097,26.835638],[437.870458,30.233002],[437.190988,32.426238],[436.219081,33.673373],[434.903128,34.232435],[433.191520,34.361449],[431.480692,34.232809],[430.165114,33.676364],[429.193270,32.436333],[428.513645,30.256929],[428.074723,26.882371],[427.824989,22.056874],[427.687020,7.029929]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[475.082120,30.921079],[473.162071,27.867243],[471.431008,23.756121],[469.937882,18.850412],[468.731645,13.412816],[467.861249,7.706029],[467.375645,1.992752],[467.323785,-3.464317],[467.754620,-8.402481],[468.901320,-17.488438],[469.091320,-22.215111],[469.450597,-23.637360],[470.942914,-25.700055],[476.118620,-30.723396],[482.202351,-35.238364],[484.829699,-36.665593],[486.778020,-37.198191],[489.340796,-37.054399],[491.727980,-36.621272],[493.940985,-35.896183],[495.981228,-34.876505],[497.850122,-33.559608],[499.549082,-31.942867],[501.079522,-30.023653],[502.442857,-27.799339],[504.673873,-22.424902],[506.253443,-15.798535],[507.192887,-7.899218],[507.503520,1.294069],[507.276525,9.930888],[506.553415,17.063882],[505.271005,22.801623],[503.366108,27.252679],[502.160480,29.029629],[500.775537,30.525621],[499.203378,31.754226],[497.436106,32.729016],[493.284629,33.971436],[488.257920,34.361449],[484.014493,34.089982],[480.115833,33.350839],[476.994265,32.256909],[475.082120,30.921079]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[493.068220,17.159609],[494.490415,15.011417],[495.649943,12.504898],[496.554907,9.711601],[497.213414,6.703072],[497.823475,0.326504],[497.544970,-6.052433],[496.442740,-11.861365],[495.602991,-14.373213],[494.581626,-16.527919],[493.386752,-18.253938],[492.026472,-19.479722],[490.508893,-20.133725],[488.842120,-20.144401],[486.947505,-19.509593],[485.216059,-18.401105],[483.656403,-16.872753],[482.277159,-14.978352],[480.094392,-10.306672],[478.736733,-4.816593],[478.273152,1.061355],[478.772625,6.896642],[479.405060,9.663748],[480.304123,12.258740],[481.478436,14.627803],[482.936620,16.717119],[485.694309,19.432815],[486.947918,20.136378],[488.154858,20.405359],[489.342742,20.240966],[490.539187,19.644406],[493.068220,17.159609]]);
    }
    linear_extrude(height=h)
      polygon([[513.008120,-0.042221],[513.146459,-18.711269],[513.796983,-29.060478],[514.424707,-31.868776],[515.312950,-33.501476],[516.505868,-34.260029],[518.047620,-34.445891],[519.871424,-34.237188],[521.542492,-33.521460],[523.148212,-32.164275],[524.775970,-30.031202],[526.513153,-26.987809],[528.447148,-22.899665],[533.255120,-11.051401],[537.495020,-0.042221],[537.636820,-17.244061],[537.882967,-26.394849],[538.186281,-29.419122],[538.669020,-31.589867],[539.375634,-33.042501],[540.350573,-33.912439],[541.638285,-34.335097],[543.283220,-34.445891],[545.016332,-34.303081],[546.342379,-33.647448],[547.315603,-32.138191],[547.990245,-29.434506],[548.420546,-25.195589],[548.660748,-19.080638],[548.787820,0.140579],[548.787820,34.727059],[541.219020,33.856179],[537.787267,33.143646],[535.364470,31.880351],[533.881798,30.011102],[533.270420,27.480709],[532.831432,24.691864],[531.916945,21.167638],[529.196220,13.719239],[525.502020,5.462359],[524.615720,19.911899],[523.960012,27.308973],[522.906907,31.704969],[522.134473,33.001604],[521.146459,33.816818],[519.904123,34.240228],[518.368720,34.361449],[516.695140,34.206377],[515.410445,33.522596],[514.463550,31.982263],[513.803370,29.257534],[513.378822,25.020566],[513.138820,18.943513],[513.008120,-0.042221]]);
  }
}
module DC_Back(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-558.453634,167.270423],[-558.299496,166.302920],[-557.295980,165.455839],[-554.631432,164.721177],[-549.494200,164.090931],[-528.555069,163.111671],[-487.985361,162.454034],[-421.291850,162.053992],[-321.981311,161.847519],[0.463754,161.759173],[311.713566,161.868490],[478.846824,162.452061],[522.251773,163.041514],[546.286017,163.893316],[552.774378,164.432576],[556.502367,165.055396],[558.164085,165.767768],[558.453634,166.575683],[557.842670,167.382720],[555.878984,168.096293],[551.871834,168.723215],[545.130479,169.270296],[520.682185,170.152179],[477.008168,170.796433],[309.879232,171.590007],[-0.463796,172.086933],[-322.470045,172.399828],[-421.619785,172.317081],[-488.187903,172.000171],[-528.664872,171.393075],[-549.541167,170.439768],[-554.657335,169.815778],[-557.307263,169.084225],[-558.302259,168.238108],[-558.453634,167.270423]]);
    linear_extrude(height=h)
      polygon([[-202.300606,58.839683],[-202.804151,56.511022],[-203.085587,53.010068],[-202.903076,44.388053],[-202.031616,33.777523],[-135.990496,33.777523],[-69.949386,33.777523],[-69.605316,46.535913],[-69.261256,59.294283],[-84.729006,60.943043],[-94.705005,61.586744],[-110.433115,62.120563],[-150.511686,62.636313],[-175.540687,62.493441],[-191.164316,61.912085],[-196.082331,61.410551],[-199.408860,60.743686],[-201.397190,59.892920],[-202.300606,58.839683]]);
    linear_extrude(height=h)
      polygon([[-202.872496,0.111193],[-202.031616,-13.011467],[-135.987966,-13.011467],[-69.944316,-13.011467],[-70.232816,-0.626147],[-70.521306,11.759173],[-137.117346,12.496513],[-203.713386,13.233883],[-202.872496,0.111193]]);
    linear_extrude(height=h)
      polygon([[-193.431556,-38.810007],[-192.952350,-42.872438],[-193.082770,-44.532392],[-193.486741,-46.014031],[-194.184416,-47.369250],[-195.195947,-48.649942],[-198.241186,-51.195327],[-204.632566,-55.672017],[-197.227326,-55.672017],[-193.620836,-56.096477],[-190.616091,-57.434644],[-188.066701,-59.783700],[-185.826276,-63.240827],[-181.830476,-70.809637],[-178.925786,-63.240827],[-177.178954,-59.674067],[-175.037495,-57.337192],[-173.746510,-56.576752],[-172.270144,-56.059933],[-168.645636,-55.672017],[-164.658714,-55.554548],[-163.554739,-55.333796],[-163.006939,-54.939330],[-162.987700,-54.321873],[-163.469410,-53.432148],[-165.825226,-50.638787],[-167.593859,-48.109007],[-169.042212,-44.941722],[-170.020828,-41.541390],[-170.380246,-38.312467],[-170.554876,-34.383184],[-170.870694,-33.239494],[-171.425542,-32.591702],[-172.284441,-32.401257],[-173.512411,-32.629606],[-177.335646,-34.188477],[-180.807669,-35.537311],[-183.487287,-35.978102],[-185.636958,-35.509331],[-187.519136,-34.129477],[-189.388081,-32.442306],[-190.949762,-31.416666],[-192.196399,-31.046397],[-193.120210,-31.325339],[-193.713412,-32.247330],[-193.968225,-33.806213],[-193.431556,-38.810007]]);
    linear_extrude(height=h)
      polygon([[-152.753156,-34.078917],[-153.327308,-35.221623],[-153.354020,-35.859754],[-152.855099,-35.959244],[-151.852356,-35.486027],[-150.218354,-35.025759],[-148.945936,-35.703417],[-148.062330,-37.258711],[-147.594762,-39.431347],[-147.570460,-41.961034],[-148.016650,-44.587480],[-148.960560,-47.050391],[-150.429416,-49.089477],[-152.516799,-51.409569],[-153.271177,-53.080715],[-153.155643,-53.782579],[-152.715443,-54.453784],[-150.872486,-55.879647],[-147.116870,-57.629669],[-143.545386,-58.382167],[-142.209552,-58.724299],[-141.115622,-59.624669],[-140.376482,-60.946435],[-140.105016,-62.552757],[-139.852408,-64.533201],[-139.171812,-65.841481],[-138.179069,-66.502222],[-136.990020,-66.540050],[-135.720507,-65.979588],[-134.486371,-64.845462],[-133.403453,-63.162297],[-132.587596,-60.954717],[-131.620898,-58.500715],[-130.230359,-56.955797],[-128.394645,-56.305449],[-126.092426,-56.535157],[-123.761797,-56.723716],[-121.110429,-56.270999],[-118.464546,-55.266732],[-116.150376,-53.800647],[-113.675165,-51.462141],[-113.713526,-51.152134],[-114.667406,-51.514957],[-116.814665,-52.081630],[-118.920549,-51.713706],[-120.879047,-50.554359],[-122.584149,-48.746762],[-123.929844,-46.434089],[-124.810122,-43.759514],[-125.118973,-40.866209],[-124.750386,-37.897347],[-124.274324,-35.387635],[-124.222170,-33.427394],[-124.565562,-32.033136],[-125.276136,-31.221372],[-126.325530,-31.008612],[-127.685382,-31.411368],[-129.327328,-32.446149],[-131.223006,-34.129467],[-133.114026,-35.518432],[-135.273190,-35.981420],[-137.985515,-35.518432],[-141.536016,-34.129467],[-146.620406,-31.897827],[-149.501097,-31.148597],[-150.435507,-31.328441],[-151.203533,-31.877153],[-152.753156,-34.078867]]);
    linear_extrude(height=h)
      polygon([[-104.283056,-32.965597],[-103.494840,-35.623684],[-101.657426,-39.115717],[-100.809666,-41.329996],[-101.045960,-43.703729],[-102.406540,-46.363731],[-104.931636,-49.436817],[-108.725574,-53.902285],[-109.612719,-55.308836],[-109.621466,-55.882597],[-103.024466,-57.105137],[-100.626440,-57.890232],[-98.110630,-59.279802],[-95.775755,-61.077560],[-93.920536,-63.087217],[-91.813522,-65.742379],[-91.045105,-66.411965],[-90.382140,-66.644917],[-89.761172,-66.442757],[-89.118748,-65.807006],[-87.515706,-63.240817],[-86.044930,-61.370657],[-84.058504,-59.839157],[-81.816810,-58.804360],[-79.580236,-58.424307],[-77.151332,-58.237690],[-75.228940,-57.709510],[-73.835611,-56.887271],[-72.993897,-55.818480],[-72.726350,-54.550641],[-73.055521,-53.131261],[-74.003963,-51.607845],[-75.594226,-50.027897],[-77.179611,-48.209860],[-78.364877,-45.858552],[-79.035721,-43.277714],[-79.077836,-40.771087],[-78.951420,-38.798568],[-79.139389,-37.205585],[-79.642440,-35.991678],[-80.461269,-35.156386],[-81.596572,-34.699250],[-83.049047,-34.619808],[-86.908296,-35.592167],[-88.597658,-35.838836],[-90.813164,-35.595537],[-93.267240,-34.918911],[-95.672316,-33.865597],[-99.780252,-31.854598],[-102.447631,-31.048589],[-103.305357,-31.090740],[-103.880038,-31.426081],[-104.197371,-32.051926],[-104.283056,-32.965587]]);
    linear_extrude(height=h)
      polygon([[-558.453634,-165.757097],[-558.358881,-166.721920],[-557.780940,-167.567553],[-556.279286,-168.302396],[-553.413393,-168.934849],[-541.826791,-169.926184],[-519.496936,-170.608752],[-482.899626,-171.049751],[-428.510663,-171.316378],[-252.260976,-171.595297],[305.766524,-172.283367],[450.635277,-172.399828],[495.364859,-172.255086],[525.479133,-171.896305],[543.869012,-171.264440],[553.425412,-170.300448],[555.794468,-169.675453],[557.039248,-168.945285],[557.521115,-168.102563],[557.601434,-167.139907],[557.442494,-166.174122],[556.426778,-165.327354],[553.745944,-164.590624],[548.591652,-163.954952],[527.629322,-162.950858],[487.073053,-162.243232],[420.456109,-161.760233],[321.311757,-161.430020],[-0.426116,-160.940587],[-322.454153,-160.627695],[-421.610591,-160.710441],[-488.183197,-161.027349],[-528.662888,-161.634443],[-549.540580,-162.587749],[-554.657088,-163.211739],[-557.307190,-163.943292],[-558.302250,-164.789410],[-558.453634,-165.757097]]);
  }
}
module DE_Stat(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    difference()
    {
       linear_extrude(height=h)
         polygon([[-206.722660,-0.042570],[-206.722660,-25.252650],[-193.021240,-25.252650],[-186.610515,-25.091829],[-181.129813,-24.580479],[-176.480603,-23.675270],[-172.564355,-22.332875],[-169.282537,-20.509965],[-166.536619,-18.163210],[-164.228071,-15.249281],[-162.258360,-11.724850],[-160.600549,-7.392913],[-159.662663,-2.956159],[-159.425541,1.480962],[-159.870021,5.813997],[-160.976943,9.938496],[-162.727146,13.750007],[-165.101469,17.144078],[-168.080750,20.016260],[-172.000640,22.492717],[-176.638850,24.077728],[-182.646845,24.919818],[-190.676090,25.167510],[-206.722660,25.167510],[-206.722660,-0.042570]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-177.937260,13.553250],[-176.150254,12.244308],[-174.908808,9.848353],[-174.184662,6.279637],[-173.949560,1.452410],[-174.112942,-2.811019],[-174.626775,-6.359841],[-175.526586,-9.239103],[-176.847904,-11.493852],[-178.626256,-13.169132],[-180.897170,-14.309989],[-183.696176,-14.961470],[-187.058800,-15.168620],[-191.092418,-14.898526],[-192.345043,-14.307676],[-193.193256,-13.187864],[-193.715838,-11.370268],[-193.991572,-8.686068],[-194.117620,-0.042570],[-193.976530,8.361011],[-193.710193,11.035215],[-193.233353,12.889465],[-192.486025,14.072588],[-191.408229,14.733413],[-189.939981,15.020768],[-188.021300,15.083480],[-182.544366,14.633980],[-177.937260,13.553250]]);
    }
    linear_extrude(height=h)
      polygon([[-152.708850,21.805520],[-153.151468,18.825909],[-153.402914,13.198382],[-153.259970,-2.774310],[-152.520990,-23.992150],[-131.722670,-24.724350],[-120.248783,-25.002562],[-114.013155,-24.583877],[-112.364975,-24.008258],[-111.432704,-23.132488],[-111.018458,-21.914591],[-110.924350,-20.312590],[-111.016608,-18.783941],[-111.364462,-17.587445],[-112.074534,-16.683548],[-113.253445,-16.032694],[-117.444268,-15.331899],[-124.789900,-15.168620],[-132.096878,-15.003897],[-136.291992,-14.309190],[-137.481101,-13.669091],[-138.202445,-12.783694],[-138.559425,-11.615397],[-138.655440,-10.126600],[-138.561887,-8.655358],[-138.222141,-7.495302],[-137.547573,-6.610981],[-136.449555,-5.966943],[-132.628652,-5.257910],[-126.050400,-5.084590],[-119.472148,-4.911270],[-115.651245,-4.202233],[-114.553227,-3.558193],[-113.878659,-2.673870],[-113.538913,-1.513813],[-113.445360,-0.042570],[-113.538913,1.428672],[-113.878659,2.588729],[-114.553227,3.473052],[-115.651245,4.117092],[-119.472148,4.826129],[-126.050400,4.999450],[-132.628652,5.172769],[-136.449555,5.881802],[-137.547573,6.525840],[-138.222141,7.410161],[-138.561887,8.570217],[-138.655440,10.041460],[-138.559425,11.530256],[-138.202445,12.698553],[-137.481101,13.583950],[-136.291992,14.224050],[-132.096878,14.918756],[-124.789900,15.083480],[-117.482916,15.248203],[-113.287799,15.942910],[-112.098689,16.583009],[-111.377345,17.468406],[-111.020365,18.636703],[-110.924350,20.125500],[-111.032829,21.669593],[-111.477058,22.863844],[-112.435220,23.752626],[-114.085503,24.380310],[-120.175166,25.029872],[-131.171530,25.167510],[-140.544233,24.981925],[-147.048425,24.392451],[-150.998499,23.350009],[-152.113990,22.643588],[-152.708850,21.805520]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[-102.822360,0.587680],[-102.291265,-13.108441],[-101.917340,-17.489919],[-101.386650,-20.562552],[-100.635811,-22.577994],[-99.601437,-23.787902],[-98.220145,-24.443932],[-96.428550,-24.797740],[-94.611377,-24.987844],[-93.230262,-24.837269],[-92.225481,-24.140307],[-91.537311,-22.691250],[-91.106030,-20.284391],[-90.871915,-16.714022],[-90.756290,-5.259920],[-90.756290,15.083480],[-77.100820,15.083480],[-71.499875,15.296129],[-66.984514,15.892157],[-63.871831,16.808687],[-62.940586,17.367490],[-62.478920,17.982840],[-62.087346,18.094447],[-61.340386,17.288438],[-58.954866,13.254450],[-55.671470,6.542639],[-51.839310,-2.185230],[-46.587278,-14.212258],[-44.566824,-18.257597],[-42.803625,-21.205823],[-41.187840,-23.218189],[-39.609629,-24.455947],[-37.959152,-25.080350],[-36.126570,-25.252650],[-34.293400,-25.062581],[-32.597182,-24.384337],[-30.922366,-23.055860],[-29.153399,-20.915097],[-24.870806,-13.548484],[-18.824990,-0.988050],[-10.871216,16.426545],[-7.563010,24.222030],[-8.136581,24.589140],[-9.698283,24.889773],[-14.832010,25.167510],[-18.214629,24.881921],[-20.706346,23.985772],[-22.407775,22.419990],[-23.419530,20.125500],[-24.524539,17.651369],[-25.394640,16.773595],[-26.544749,16.105543],[-29.889817,15.309190],[-34.969400,15.083480],[-39.933758,15.341066],[-43.546759,16.190545],[-46.103518,17.746996],[-47.899150,20.125500],[-48.871860,21.648674],[-50.124692,22.833106],[-51.899548,23.720607],[-54.438330,24.352987],[-62.775275,25.019626],[-77.070740,25.167510],[-103.543900,25.167510],[-102.822360,0.587680]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-30.252090,3.573210],[-31.072235,1.033473],[-33.044080,-3.069900],[-34.521172,-5.498549],[-35.720397,-6.551808],[-36.275359,-6.583195],[-36.832312,-6.295368],[-38.047470,-4.794920],[-39.205848,-2.702897],[-39.920914,-0.808951],[-40.199674,0.861995],[-40.049135,2.285020],[-39.476302,3.435199],[-38.488183,4.287612],[-37.091784,4.817337],[-35.294110,4.999450],[-31.733184,4.580495],[-30.649937,4.126995],[-30.252090,3.573210]]);
    }
    linear_extrude(height=h)
      polygon([[-1.258450,22.016250],[-4.213173,12.147453],[-7.982246,-1.955082],[-11.226067,-15.088693],[-12.605030,-22.050720],[-12.129162,-23.293978],[-10.833485,-24.312090],[-8.915885,-25.000001],[-6.574250,-25.252650],[-4.784829,-25.145980],[-3.297743,-24.757498],[-2.044276,-23.984495],[-0.955714,-22.724262],[0.036657,-20.874090],[1.001552,-18.331272],[3.123770,-10.756860],[6.791000,3.738940],[11.137420,-10.756860],[13.682876,-18.573420],[14.790253,-21.126328],[15.916286,-22.939504],[17.157644,-24.135837],[18.610993,-24.838214],[20.373003,-25.169523],[22.540340,-25.252650],[26.394456,-24.881586],[27.797878,-24.276245],[28.960159,-23.265245],[29.962262,-21.754247],[30.885150,-19.648910],[32.817130,-13.277860],[35.719891,-3.798471],[36.924317,-1.067216],[37.995381,0.348688],[38.488233,0.568919],[38.956541,0.466952],[39.831253,-0.694717],[40.642974,-3.118611],[41.415160,-6.787020],[43.382812,-16.666769],[44.314895,-19.915592],[45.325572,-22.237163],[46.499661,-23.781568],[47.921977,-24.698894],[49.677338,-25.139226],[51.850560,-25.252650],[54.214704,-25.206889],[55.937954,-24.947904],[57.048201,-24.293144],[57.573335,-23.060057],[57.541248,-21.066091],[56.979829,-18.128696],[54.380560,-8.693410],[47.939360,14.607310],[46.220843,20.379540],[45.385552,22.251567],[44.464722,23.554887],[43.382216,24.370012],[42.061896,24.777456],[38.403260,24.691350],[34.887605,23.843385],[33.528378,23.045509],[32.359607,21.906547],[31.324835,20.357630],[30.367602,18.329891],[28.459920,12.562470],[25.087375,1.530258],[23.836296,-1.343238],[22.721730,-2.498468],[22.179637,-2.441921],[21.628468,-1.968034],[20.441300,0.215460],[17.324400,9.411210],[14.538368,17.698377],[13.348597,20.464566],[12.184315,22.467356],[10.963016,23.822896],[9.602195,24.647336],[8.019345,25.056824],[6.131960,25.167510],[3.602780,24.918856],[1.366321,24.241830],[-0.334921,23.239828],[-1.258450,22.016250]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[54.166360,20.236670],[57.781522,10.982365],[64.275560,-4.343160],[69.036169,-14.811362],[70.880249,-18.266522],[72.529110,-20.743697],[74.104453,-22.398866],[75.727976,-23.388011],[77.521378,-23.867112],[79.606360,-23.992150],[81.704126,-23.859269],[83.522838,-23.345230],[85.194780,-22.276943],[86.852235,-20.481315],[88.627487,-17.785257],[90.652819,-14.015676],[95.982860,-2.563580],[102.801235,13.496033],[104.910776,19.101828],[105.727560,22.016250],[105.636557,22.942253],[105.286909,23.707448],[103.945840,24.773914],[101.972677,25.252650],[99.635747,25.180661],[97.203375,24.594948],[94.943887,23.532515],[93.125606,22.030364],[92.016860,20.125500],[90.747680,17.643425],[89.792761,16.765320],[88.548322,16.098482],[84.962983,15.306542],[79.535860,15.083480],[74.083244,15.300424],[70.549260,16.082166],[69.353284,16.746200],[68.458801,17.625070],[67.336760,20.125500],[66.347326,22.368154],[64.705710,23.939696],[62.372894,24.864642],[59.309860,25.167510],[56.000532,24.966672],[54.189460,24.221038],[53.775792,23.576836],[53.652713,22.715931],[54.166360,20.236670]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[83.622660,0.587680],[80.346260,-7.084450],[80.084844,-7.582799],[79.726698,-7.745009],[78.784260,-7.133393],[77.647047,-5.394366],[76.443160,-2.672690],[74.980805,1.583958],[74.739908,2.940111],[74.868573,3.881492],[75.398829,4.483109],[76.362708,4.819970],[79.719460,4.999450],[82.726555,4.818924],[84.267148,4.150401],[84.540148,3.573634],[84.509696,2.803459],[83.622660,0.587680]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[110.924360,-0.042570],[110.924360,-25.252650],[128.010460,-25.252650],[135.074152,-25.049357],[141.024104,-24.420590],[145.913302,-23.338021],[149.794735,-21.773319],[152.721390,-19.698156],[154.746254,-17.084201],[155.922315,-13.903126],[156.302560,-10.126600],[155.950938,-6.928702],[154.964235,-3.937698],[153.444694,-1.379950],[151.494560,0.518180],[148.938685,2.621062],[148.396929,3.631703],[148.383510,4.802461],[148.926591,6.273823],[150.054335,8.186277],[154.176460,13.896410],[161.666460,23.907010],[154.724160,24.750920],[152.743519,24.876807],[150.921240,24.718100],[149.184373,24.230295],[147.459973,23.368887],[143.756774,20.347245],[139.228060,15.297140],[135.367142,10.910151],[132.093143,7.769562],[129.383830,5.875070],[127.216973,5.226372],[126.330017,5.369102],[125.570338,5.823167],[124.421696,7.665151],[123.748814,10.752023],[123.529460,15.083480],[123.342346,20.487891],[123.030904,22.262444],[122.505273,23.528856],[121.713752,24.369848],[120.604643,24.868140],[117.226860,25.167510],[115.146543,25.118271],[113.583227,24.773602],[112.463056,23.838072],[111.712172,22.016250],[111.256718,19.012705],[111.022837,14.532007],[110.924360,-0.042570]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[142.436960,-10.126600],[142.292217,-11.033191],[141.856288,-11.841295],[140.100685,-13.166965],[137.149769,-14.113443],[132.983160,-14.690560],[128.047319,-14.915713],[125.181910,-14.401739],[124.358982,-13.787126],[123.853701,-12.891186],[123.529460,-10.126600],[123.853701,-7.362058],[124.358982,-6.466122],[125.181910,-5.851504],[128.047319,-5.337511],[132.983160,-5.562650],[137.149769,-6.139768],[140.100685,-7.086244],[141.856288,-8.411911],[142.292217,-9.220014],[142.436960,-10.126600]]);
    }
    linear_extrude(height=h)
      polygon([[164.404560,0.587680],[165.126060,-23.992150],[185.924360,-24.724350],[197.398252,-25.002562],[203.633873,-24.583877],[205.282047,-24.008258],[206.214312,-23.132488],[206.628554,-21.914591],[206.722660,-20.312590],[206.627972,-18.767039],[206.261310,-17.562609],[205.498780,-16.657677],[204.216485,-16.010618],[199.597023,-15.323620],[191.411760,-15.168620],[183.471198,-15.014990],[178.946360,-14.391292],[177.714502,-13.826852],[177.036173,-13.053318],[176.811237,-12.040163],[176.939560,-10.756860],[177.310615,-9.579743],[177.972529,-8.592802],[178.977765,-7.776719],[180.378785,-7.112179],[184.578029,-6.160455],[190.989960,-5.583090],[197.759080,-5.008305],[201.777848,-4.060048],[202.961891,-3.357407],[203.705596,-2.455245],[204.091380,-1.318177],[204.201660,0.089180],[204.100558,1.526461],[203.731226,2.658309],[202.994623,3.519799],[201.791710,4.146003],[197.590794,4.832853],[190.336160,4.999450],[183.029155,5.164173],[178.834022,5.858878],[177.644907,6.498976],[176.923558,7.384372],[176.566576,8.552666],[176.470560,10.041460],[176.569038,11.544876],[176.943254,12.720035],[177.711379,13.606327],[178.991585,14.243145],[183.560929,14.925917],[191.596660,15.083480],[199.632333,15.241042],[204.201647,15.923815],[205.481847,16.560632],[206.249968,17.446925],[206.624182,18.622083],[206.722660,20.125500],[206.611694,21.676699],[206.150065,22.874286],[205.144673,23.763502],[203.402422,24.389591],[196.934949,25.033353],[185.202860,25.167510],[163.682960,25.167510],[164.404560,0.587680]]);
  }
}
module DE_Slog(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-7.650555,20.108044],[-10.527062,18.728854],[-13.007448,17.119284],[-15.041523,15.352949],[-16.579096,13.503466],[-17.569976,11.644451],[-17.963971,9.849520],[-17.710891,8.192289],[-16.760545,6.746374],[-15.163690,5.614458],[-13.613268,5.628148],[-11.925779,6.857917],[-9.917725,9.374234],[-8.116483,11.516391],[-6.124891,13.127210],[-4.006729,14.199389],[-1.825775,14.725627],[0.354190,14.698623],[2.469388,14.111075],[4.456040,12.955683],[6.250365,11.225144],[7.544441,9.245007],[7.699456,8.444168],[7.500564,7.722494],[5.963382,6.375677],[2.777545,4.922624],[-10.249435,-0.203546],[-13.026664,-1.811248],[-14.928372,-3.994416],[-15.967535,-6.589351],[-16.157129,-9.432352],[-15.510129,-12.359721],[-14.039511,-15.207759],[-11.758251,-17.812767],[-8.679325,-20.011046],[-5.070632,-21.757176],[-2.065863,-22.347074],[1.090853,-21.784033],[5.155385,-20.071346],[8.090751,-18.349849],[10.621646,-16.280213],[12.477896,-14.122756],[13.389325,-12.137796],[13.433788,-10.310854],[12.872019,-8.973944],[11.856742,-8.135287],[10.540678,-7.803104],[9.076549,-7.985618],[7.617079,-8.691050],[6.314990,-9.927622],[5.323005,-11.703556],[4.230625,-13.262483],[2.518028,-14.287211],[0.421269,-14.800220],[-1.823596,-14.823991],[-3.980514,-14.381005],[-5.813428,-13.493743],[-7.086283,-12.184686],[-7.563025,-10.476316],[-6.966255,-8.897873],[-5.341387,-7.240243],[-2.936583,-5.700345],[-0.000005,-4.475096],[6.034038,-1.929115],[11.280957,1.360306],[13.372772,3.105421],[14.984036,4.822333],[16.020160,6.439689],[16.386555,7.886134],[15.863125,9.527869],[14.452281,11.659223],[9.925014,16.506339],[4.718087,20.658588],[2.457669,21.921358],[0.744835,22.347074],[-3.068470,21.623447],[-7.650555,20.108074]]);
    linear_extrude(height=h)
      polygon([[78.063725,20.108044],[75.187218,18.728854],[72.706832,17.119284],[70.672757,15.352949],[69.135184,13.503466],[68.144304,11.644451],[67.750309,9.849520],[68.003389,8.192289],[68.953735,6.746374],[70.550590,5.614458],[72.101012,5.628148],[73.788501,6.857917],[75.796555,9.374234],[77.597796,11.516391],[79.589384,13.127210],[81.707542,14.199389],[83.888492,14.725627],[86.068458,14.698623],[88.183660,14.111075],[90.170322,12.955683],[91.964665,11.225144],[93.258715,9.245007],[93.413728,8.444168],[93.214840,7.722494],[91.677677,6.375677],[88.491865,4.922624],[75.464845,-0.203546],[72.687616,-1.811248],[70.785908,-3.994416],[69.746745,-6.589351],[69.557151,-9.432352],[70.204151,-12.359721],[71.674769,-15.207759],[73.956029,-17.812767],[77.034955,-20.011046],[80.643653,-21.757176],[83.648429,-22.347074],[86.805145,-21.784033],[90.869665,-20.071346],[93.805040,-18.349849],[96.335940,-16.280213],[98.192177,-14.122756],[99.103565,-12.137796],[99.148050,-10.310854],[98.586296,-8.973944],[97.571027,-8.135287],[96.254965,-7.803104],[94.790835,-7.985618],[93.331359,-8.691050],[92.029261,-9.927622],[91.037265,-11.703556],[89.943143,-13.266683],[88.229731,-14.292375],[86.132868,-14.803618],[83.888397,-14.823399],[81.732160,-14.374704],[79.899996,-13.480517],[78.627747,-12.163826],[78.151255,-10.447616],[78.719667,-8.897732],[80.267321,-7.339094],[82.557845,-5.953045],[85.354865,-4.920926],[88.472357,-3.878013],[91.494927,-2.478707],[94.323717,-0.804298],[96.859865,1.063921],[99.004513,3.044659],[100.658802,5.056625],[101.723873,7.018527],[102.100865,8.849074],[101.579499,10.506014],[100.169609,12.559553],[98.102502,14.815722],[95.609490,17.080551],[90.270984,20.860310],[87.888109,21.987301],[86.004565,22.347074],[82.512292,21.623447],[78.063725,20.108074]]);
    linear_extrude(height=h)
      polygon([[-223.109225,2.338774],[-223.233014,-7.650717],[-223.489045,-10.778342],[-223.964540,-12.913319],[-224.727028,-14.244726],[-225.844038,-14.961637],[-227.383101,-15.253129],[-229.411745,-15.308276],[-231.858897,-15.507200],[-233.862901,-16.048824],[-235.216957,-16.850427],[-235.714265,-17.829286],[-235.389292,-18.345911],[-234.453763,-18.823146],[-230.987381,-19.623082],[-225.787804,-20.156372],[-219.327715,-20.350296],[-212.867631,-20.156372],[-207.668053,-19.623082],[-204.201668,-18.823146],[-203.266138,-18.345911],[-202.941165,-17.829286],[-203.438473,-16.850427],[-204.792529,-16.048824],[-206.796533,-15.507200],[-209.243685,-15.308276],[-211.272306,-15.253129],[-212.811358,-14.961637],[-213.928367,-14.244726],[-214.690860,-12.913319],[-215.166364,-10.778342],[-215.422404,-7.650717],[-215.546205,2.338774],[-215.715021,11.004744],[-216.311506,16.414408],[-216.812330,18.095080],[-217.470719,19.198020],[-218.303553,19.802011],[-219.327715,19.985834],[-220.351877,19.802011],[-221.184711,19.198020],[-221.843100,18.095080],[-222.343924,16.414408],[-222.940409,11.004744],[-223.109225,2.338774]]);
    linear_extrude(height=h)
      polygon([[-200.420155,-0.182226],[-200.257667,-10.187479],[-199.671729,-16.358698],[-199.173805,-18.252737],[-198.514626,-19.483699],[-197.675727,-20.150059],[-196.638645,-20.350296],[-194.984231,-19.877606],[-193.802506,-18.459539],[-193.093470,-16.096095],[-192.857125,-12.787276],[-192.620783,-8.592158],[-192.177638,-7.255334],[-191.386543,-6.327188],[-190.149018,-5.733864],[-188.366586,-5.401504],[-182.773095,-5.224246],[-177.179608,-5.401504],[-175.397177,-5.733864],[-174.159651,-6.327188],[-173.368554,-7.255334],[-172.925409,-8.592158],[-172.689065,-12.787276],[-172.452720,-16.096095],[-171.743685,-18.459539],[-170.561963,-19.877606],[-168.907555,-20.350296],[-167.870472,-20.150059],[-167.031573,-19.483699],[-166.372392,-18.252737],[-165.874466,-16.358698],[-165.288524,-10.187479],[-165.126035,-0.182226],[-165.288524,9.823022],[-165.874466,15.994238],[-166.372392,17.888277],[-167.031573,19.119238],[-167.870472,19.785598],[-168.907555,19.985834],[-170.612613,19.473755],[-171.788707,17.884996],[-172.469603,15.140773],[-172.689065,11.162304],[-172.880378,6.149833],[-173.284121,4.585281],[-174.039569,3.520499],[-175.256455,2.859473],[-177.044515,2.506186],[-182.773095,2.338774],[-188.501633,2.506185],[-190.289691,2.859470],[-191.506584,3.520496],[-192.262042,4.585277],[-192.665798,6.149829],[-192.857125,11.162304],[-193.076588,15.140773],[-193.757488,17.884996],[-194.933585,19.473755],[-196.638645,19.985834],[-197.675727,19.785598],[-198.514626,19.119238],[-199.173805,17.888277],[-199.671729,15.994238],[-200.257667,9.823022],[-200.420155,-0.182226]]);
    linear_extrude(height=h)
      polygon([[-160.084025,-0.182226],[-160.084025,-20.350296],[-143.697465,-20.350296],[-137.237381,-20.156372],[-132.037803,-19.623082],[-128.571418,-18.823146],[-127.635888,-18.345911],[-127.310915,-17.829286],[-127.568186,-17.322869],[-128.305532,-16.850427],[-131.013646,-16.048824],[-135.021655,-15.507200],[-139.915955,-15.308276],[-146.494207,-15.134956],[-150.315110,-14.425923],[-151.413128,-13.781885],[-152.087696,-12.897564],[-152.427442,-11.737508],[-152.520995,-10.266266],[-152.107391,-7.666476],[-151.479600,-6.783466],[-150.472674,-6.134612],[-147.025985,-5.408070],[-141.176465,-5.224246],[-135.858713,-5.027292],[-132.352935,-4.383911],[-131.205679,-3.870190],[-130.422787,-3.215319],[-129.974717,-2.409450],[-129.831925,-1.442736],[-129.974717,-0.476021],[-130.422787,0.329848],[-131.205679,0.984719],[-132.352935,1.498439],[-135.858713,2.141821],[-141.176465,2.338774],[-147.345053,2.509468],[-149.345117,2.806540],[-150.756290,3.319168],[-151.679018,4.103155],[-152.213747,5.214304],[-152.520995,8.641304],[-152.205871,12.107690],[-151.634707,13.220478],[-150.630245,13.998446],[-149.074311,14.500678],[-146.848734,14.786261],[-139.915955,14.943824],[-135.021655,15.142747],[-131.013646,15.684368],[-128.305532,16.485967],[-127.568186,16.958409],[-127.310915,17.464824],[-127.635888,17.981450],[-128.571418,18.458685],[-132.037803,19.258621],[-137.237381,19.791911],[-143.697465,19.985834],[-160.084025,19.985834],[-160.084025,-0.182226]]);
    linear_extrude(height=h)
      polygon([[-107.142855,-0.182226],[-107.142855,-20.350296],[-92.016805,-20.350296],[-86.108192,-20.153342],[-81.302520,-19.615001],[-78.072478,-18.814055],[-77.196033,-18.339724],[-76.890755,-17.829286],[-77.122299,-17.322869],[-77.785910,-16.850427],[-80.223211,-16.048824],[-83.830417,-15.507200],[-88.235285,-15.308276],[-94.035164,-15.122868],[-97.487372,-14.406369],[-98.507401,-13.773832],[-99.149672,-12.918366],[-99.483907,-11.809922],[-99.579825,-10.418446],[-99.147485,-8.010748],[-98.552182,-7.110340],[-97.655342,-6.382341],[-94.810714,-5.353918],[-90.320915,-4.746176],[-85.919337,-4.119071],[-82.701402,-3.165020],[-80.685601,-2.010565],[-79.890422,-0.782249],[-79.956344,-0.179938],[-80.334355,0.393385],[-82.035889,1.389795],[-85.013513,2.080439],[-89.285715,2.338774],[-95.148374,2.501966],[-96.974299,2.851560],[-98.214285,3.509246],[-98.981582,4.572093],[-99.389438,6.137172],[-99.579825,11.162304],[-99.799287,15.140773],[-100.480182,17.884996],[-101.656277,19.473755],[-103.361335,19.985834],[-104.398418,19.785598],[-105.237317,19.119238],[-105.896498,17.888277],[-106.394424,15.994238],[-106.980366,9.823022],[-107.142855,-0.182226]]);
    linear_extrude(height=h)
      polygon([[-71.848735,-0.182226],[-71.686247,-10.187479],[-71.100309,-16.358698],[-70.602385,-18.252737],[-69.943206,-19.483699],[-69.104307,-20.150059],[-68.067225,-20.350296],[-67.030143,-20.150059],[-66.191244,-19.483699],[-65.532065,-18.252737],[-65.034141,-16.358698],[-64.448203,-10.187479],[-64.285715,-0.182226],[-64.448203,9.823022],[-65.034141,15.994238],[-65.532065,17.888277],[-66.191244,19.119238],[-67.030143,19.785598],[-68.067225,19.985834],[-69.104307,19.785598],[-69.943206,19.119238],[-70.602385,17.888277],[-71.100309,15.994238],[-71.686247,9.823022],[-71.848735,-0.182226]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[-56.722685,-0.182226],[-56.722685,-20.350296],[-43.361345,-20.350296],[-37.934677,-20.111588],[-33.036239,-19.461642],[-29.203714,-18.499720],[-26.974785,-17.325086],[-25.621161,-15.543803],[-24.690321,-13.415141],[-24.177106,-11.061671],[-24.076359,-8.605968],[-24.382921,-6.170604],[-25.091635,-3.878152],[-26.197342,-1.851185],[-27.694885,-0.212276],[-29.497452,1.632299],[-29.892442,2.511642],[-29.937566,3.455054],[-28.941215,5.812192],[-26.434385,9.259914],[-22.899034,14.395074],[-21.823565,16.455811],[-21.428575,17.804814],[-21.751301,19.077384],[-22.624160,19.814854],[-23.904176,20.055399],[-25.448371,19.837196],[-27.113769,19.198419],[-28.757392,18.177244],[-30.236263,16.811848],[-31.407405,15.140404],[-34.442881,10.189018],[-37.520648,6.448488],[-40.502928,3.949691],[-43.251938,2.723501],[-44.495910,2.597281],[-45.629897,2.800792],[-46.636676,3.337892],[-47.499025,4.212440],[-48.199721,5.428296],[-48.721542,6.989319],[-49.159665,11.162304],[-49.379127,15.140773],[-50.060023,17.884996],[-51.236117,19.473755],[-52.941175,19.985834],[-53.978257,19.785598],[-54.817156,19.119238],[-55.476335,17.888277],[-55.974259,15.994238],[-56.560197,9.823022],[-56.722685,-0.182226]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-32.773105,-9.005756],[-33.174500,-11.454682],[-33.717751,-12.382173],[-34.526265,-13.137944],[-37.049770,-14.213112],[-40.966385,-14.837756],[-45.353576,-15.063121],[-46.795239,-14.873988],[-47.824795,-14.420163],[-48.509130,-13.654038],[-48.915129,-12.528001],[-49.159665,-9.005756],[-48.915129,-5.483516],[-48.509130,-4.357481],[-47.824795,-3.591357],[-46.795239,-3.137533],[-45.353576,-2.948400],[-40.966385,-3.173766],[-37.049770,-3.798408],[-34.526265,-4.873572],[-33.717751,-5.629341],[-33.174500,-6.556830],[-32.773105,-9.005756]]);
    }
    linear_extrude(height=h)
      polygon([[31.512605,2.338774],[31.512605,-15.308276],[23.949575,-15.308276],[21.012997,-15.507200],[18.608193,-16.048824],[16.983325,-16.850427],[16.386555,-17.829286],[16.731224,-18.351214],[17.725840,-18.830938],[21.428570,-19.630008],[27.022058,-20.158969],[34.033615,-20.350296],[41.045167,-20.158969],[46.638651,-19.630008],[50.341380,-18.830938],[51.335996,-18.351214],[51.680665,-17.829286],[51.183357,-16.850427],[49.829301,-16.048824],[47.825297,-15.507200],[45.378145,-15.308276],[43.349524,-15.253129],[41.810472,-14.961637],[40.693463,-14.244726],[39.930970,-12.913319],[39.455466,-10.778342],[39.199426,-7.650717],[39.075625,2.338774],[38.906809,11.004744],[38.310324,16.414408],[37.809500,18.095080],[37.151111,19.198020],[36.318277,19.802011],[35.294115,19.985834],[34.269953,19.802011],[33.437119,19.198020],[32.778730,18.095080],[32.277906,16.414408],[31.681421,11.004744],[31.512605,2.338774]]);
    linear_extrude(height=h)
      polygon([[117.226865,2.338774],[117.226865,-15.308276],[109.663865,-15.308276],[106.727273,-15.507200],[104.322478,-16.048824],[102.697626,-16.850427],[102.100865,-17.829286],[102.445533,-18.351214],[103.440146,-18.830938],[107.142865,-19.630008],[112.736334,-20.158969],[119.747865,-20.350296],[126.759454,-20.158969],[132.352953,-19.630008],[136.055682,-18.830938],[137.050297,-18.351214],[137.394965,-17.829286],[136.897648,-16.850427],[135.543578,-16.048824],[133.539576,-15.507200],[131.092465,-15.308276],[129.063823,-15.253129],[127.524754,-14.961637],[126.407731,-14.244726],[125.645228,-12.913319],[125.169716,-10.778342],[124.913670,-7.650717],[124.789865,2.338774],[124.621049,11.004744],[124.024565,16.414408],[123.523742,18.095080],[122.865356,19.198020],[122.032524,19.802011],[121.008365,19.985834],[119.984206,19.802011],[119.151374,19.198020],[118.492988,18.095080],[117.992165,16.414408],[117.395681,11.004744],[117.226865,2.338774]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[133.597965,14.992414],[141.100165,-4.545396],[143.889156,-10.824136],[146.464792,-15.308951],[148.898192,-17.999840],[150.083779,-18.672562],[151.260477,-18.896803],[152.437177,-18.672562],[153.622768,-17.999840],[156.056182,-15.308951],[158.631841,-10.824136],[161.420865,-4.545396],[166.700673,8.750109],[169.098503,16.131331],[169.332155,18.138062],[168.983888,19.306996],[168.099894,19.851723],[166.726365,19.985834],[165.131765,19.587989],[163.585540,18.504746],[162.264278,16.901544],[161.344565,14.943824],[160.151649,12.584039],[158.210140,11.025508],[155.314818,10.165630],[151.260465,9.901804],[147.206156,10.165630],[144.310840,11.025508],[142.369337,12.584039],[141.176465,14.943824],[140.256696,16.901544],[138.935415,18.504746],[137.389209,19.587989],[135.794665,19.985834],[134.190756,19.692498],[133.301015,18.787487],[133.108924,17.233294],[133.597965,14.992414]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[155.003365,-0.812486],[154.375815,-3.984759],[152.919665,-7.186546],[151.816696,-8.330699],[151.257175,-8.436057],[150.678665,-8.221591],[149.423784,-6.807145],[147.970265,-4.035286],[146.588390,-0.656196],[146.389265,1.270093],[146.773453,1.811446],[147.501590,2.137208],[150.054065,2.338774],[151.987760,2.090121],[153.565478,1.413094],[154.624813,0.411092],[155.003365,-0.812486]]);
    }
    linear_extrude(height=h)
      polygon([[180.252065,2.338774],[180.252065,-15.308276],[172.689065,-15.308276],[169.752473,-15.507200],[167.347677,-16.048824],[165.722826,-16.850427],[165.126065,-17.829286],[165.470733,-18.351214],[166.465346,-18.830938],[170.168065,-19.630008],[175.761534,-20.158969],[182.773065,-20.350296],[189.784654,-20.158969],[195.378153,-19.630008],[199.080882,-18.830938],[200.075497,-18.351214],[200.420165,-17.829286],[199.922862,-16.850427],[198.568815,-16.048824],[196.564818,-15.507200],[194.117665,-15.308276],[192.089023,-15.253129],[190.549954,-14.961637],[189.432931,-14.244726],[188.670428,-12.913319],[188.194916,-10.778342],[187.938870,-7.650717],[187.815065,2.338774],[187.646249,11.004744],[187.049765,16.414408],[186.548942,18.095080],[185.890556,19.198020],[185.057724,19.802011],[184.033565,19.985834],[183.009406,19.802011],[182.176574,19.198020],[181.518188,18.095080],[181.017365,16.414408],[180.420881,11.004744],[180.252065,2.338774]]);
    linear_extrude(height=h)
      polygon([[202.941165,-0.182226],[202.941165,-20.350296],[218.067165,-20.350296],[223.975802,-20.153342],[228.781490,-19.615001],[232.011540,-18.814055],[232.887986,-18.339724],[233.193265,-17.829286],[232.961723,-17.322869],[232.298117,-16.850427],[229.860828,-16.048824],[226.253632,-15.507200],[221.848765,-15.308276],[216.046421,-15.122943],[212.594465,-14.405968],[211.575074,-13.772656],[210.933509,-12.915882],[210.599847,-11.805463],[210.504165,-10.411216],[210.956867,-7.949480],[211.599505,-7.048522],[212.587902,-6.330707],[215.806670,-5.334120],[221.022565,-4.738946],[225.995863,-4.116550],[229.622393,-3.165382],[231.883572,-2.012355],[232.760815,-0.784379],[232.674654,-0.181946],[232.235540,0.391633],[230.289162,1.388770],[226.903098,2.080121],[222.058765,2.338774],[215.762837,2.507082],[213.725190,2.802066],[212.289890,3.312804],[211.353536,4.095697],[210.812731,5.207145],[210.504165,8.641304],[210.819287,12.107690],[211.390451,13.220478],[212.394915,13.998446],[213.950854,14.500678],[216.176443,14.786261],[223.109265,14.943824],[228.003529,15.142747],[232.011528,15.684368],[234.719645,16.485967],[235.456993,16.958409],[235.714265,17.464824],[235.389294,17.981450],[234.453768,18.458685],[230.987390,19.258621],[225.787799,19.791911],[219.327665,19.985834],[202.941165,19.985834],[202.941165,-0.182226]]);
  }
}
module FL_Stat(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    difference()
    {
       linear_extrude(height=h)
         polygon([[-256.048407,57.864167],[-257.171247,53.528097],[-257.304484,50.778051],[-256.966036,49.813945],[-256.339429,49.025735],[-254.167397,47.682857],[-252.293268,46.713966],[-251.376214,45.738234],[-251.158702,44.180619],[-251.383197,41.466077],[-253.195009,33.151909],[-256.812965,19.662014],[-260.731157,6.351733],[-263.443677,-1.423593],[-264.315755,-2.980937],[-265.236497,-3.744556],[-266.678910,-3.898008],[-269.115997,-3.624853],[-273.396484,-3.036143],[-275.008344,-8.990843],[-275.949754,-13.521101],[-276.019624,-14.983707],[-275.801744,-15.736783],[-274.445336,-16.450124],[-270.491995,-17.785562],[-248.433277,-24.317053],[-225.483277,-31.036183],[-217.762869,-33.127537],[-212.608192,-34.070259],[-210.902163,-34.119528],[-209.728558,-33.892011],[-209.051042,-33.391167],[-208.833277,-32.620453],[-208.040152,-31.175923],[-206.133277,-29.272483],[-204.226402,-27.383194],[-203.433277,-25.972683],[-202.772340,-24.697413],[-201.183277,-23.133273],[-199.594215,-21.610091],[-198.933277,-20.433273],[-198.246026,-19.235764],[-196.593697,-17.662813],[-195.548389,-16.640904],[-194.771775,-15.471859],[-194.042300,-12.951329],[-194.098276,-11.729330],[-194.440619,-10.619164],[-195.073747,-9.685574],[-196.002077,-8.993303],[-199.762577,-6.386463],[-201.376827,-5.511678],[-203.236492,-5.394709],[-205.063510,-5.998815],[-206.579817,-7.287253],[-208.428303,-8.746915],[-211.361959,-10.406881],[-214.184706,-11.661543],[-215.700467,-11.905293],[-214.569067,-6.288877],[-211.161597,6.527127],[-206.133277,25.351257],[-207.604908,26.248417],[-210.992469,27.548493],[-214.754964,28.719016],[-217.351397,29.227517],[-218.232455,28.103923],[-219.725437,25.402517],[-221.638559,22.090353],[-223.505042,19.914831],[-225.433446,18.781289],[-227.532327,18.595067],[-228.828239,18.844415],[-229.554292,19.358301],[-229.855194,20.348682],[-229.875647,22.027517],[-229.336592,25.959956],[-228.166292,30.483152],[-226.699322,34.512142],[-225.270257,36.961967],[-224.358814,37.629665],[-223.172441,37.977796],[-219.226377,37.821847],[-214.618147,37.246087],[-213.071257,41.561807],[-211.814534,45.730520],[-211.540474,48.632531],[-211.777249,49.663942],[-212.266060,50.445180],[-213.009028,50.998412],[-214.008277,51.345807],[-220.083277,53.062107],[-240.812940,59.338492],[-249.154386,61.627427],[-253.263127,62.527517],[-253.955365,62.224469],[-254.659555,61.330776],[-256.048407,57.864167]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-230.570987,2.346947],[-229.599447,1.279787],[-229.007667,-0.061843],[-228.713120,-1.981626],[-228.633277,-4.783243],[-228.633277,-10.232883],[-225.258277,-11.311403],[-221.951436,-12.553320],[-221.240945,-13.009077],[-221.157511,-13.352746],[-222.867122,-13.697953],[-227.070887,-13.577213],[-231.756536,-13.008716],[-235.700105,-12.049838],[-238.419662,-10.856263],[-239.169833,-10.220115],[-239.433277,-9.583673],[-238.577287,-6.231783],[-236.742587,0.202517],[-235.767630,2.747725],[-235.157172,3.511450],[-234.454592,3.939444],[-233.652287,4.034349],[-232.742653,3.798807],[-230.570987,2.346947]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[250.338493,51.760437],[229.825343,46.086137],[229.958086,44.027681],[230.887983,39.689367],[232.385563,33.727517],[237.226133,33.727517],[242.066723,33.727517],[242.066723,29.269867],[241.793001,24.694284],[241.286197,23.122051],[240.386409,21.883849],[238.983868,20.872427],[236.968806,19.980528],[230.662053,18.126287],[220.944313,15.903057],[216.930025,21.667741],[215.581786,24.135994],[215.066723,25.673397],[215.330416,26.458670],[216.107124,27.271932],[219.113343,28.913367],[221.972269,30.406246],[222.842736,31.107529],[223.163353,31.658607],[221.817739,37.891491],[220.072173,43.422067],[214.717568,42.366476],[202.436443,39.235837],[183.944763,34.627517],[183.066714,34.127063],[182.721095,32.667189],[182.910454,30.310133],[183.637343,27.118127],[184.165305,24.661147],[184.069556,23.330209],[183.787034,23.085578],[183.347676,23.120743],[181.997243,24.028177],[176.366723,27.547657],[173.750520,28.720753],[170.590256,29.373549],[165.424476,29.673235],[156.791723,29.786997],[145.827191,29.676443],[141.266723,29.256927],[138.953441,28.504197],[133.391723,27.592557],[114.788665,24.973747],[107.310433,23.471237],[107.254921,21.297024],[107.787945,17.044062],[108.591116,12.749138],[109.346043,10.449037],[110.851591,10.045403],[113.667563,9.877517],[115.792864,9.800377],[117.041413,9.371811],[117.809683,8.296097],[118.494153,6.277517],[119.662434,0.824355],[120.982699,-7.405588],[122.103885,-15.993979],[122.674933,-22.522483],[122.957028,-25.964983],[123.394253,-27.922483],[124.061705,-30.331677],[124.582831,-34.291778],[124.817598,-38.322447],[124.625973,-40.943343],[124.139048,-41.756711],[123.241595,-42.536173],[120.493823,-43.800653],[116.929633,-44.868513],[117.099453,-51.770493],[117.269273,-58.672483],[121.168003,-58.672483],[123.921475,-58.482969],[125.066723,-58.027333],[126.635576,-57.442247],[130.450331,-56.740662],[139.466723,-55.811403],[143.066723,-55.195633],[156.116723,-53.091643],[164.198213,-51.871797],[170.682458,-50.585786],[175.272584,-49.302486],[177.671723,-48.090773],[178.751441,-47.512856],[180.146723,-47.272483],[181.290848,-47.008108],[181.766723,-46.372483],[182.004660,-45.736858],[182.576723,-45.472483],[184.352291,-44.398063],[187.081278,-41.782363],[189.900962,-38.536723],[191.948623,-35.572483],[195.806349,-28.093067],[197.604943,-22.681363],[198.331661,-19.077866],[198.704683,-15.155789],[198.735670,-11.022786],[198.436288,-6.786511],[197.818198,-2.554616],[196.893065,1.565244],[195.672552,5.465416],[194.168323,9.038247],[190.538688,15.964198],[189.309355,17.744733],[188.291723,18.697237],[187.276078,19.598813],[187.430773,20.234227],[188.731842,20.587206],[191.155323,20.641477],[193.359397,20.428074],[195.166203,19.820473],[196.992568,18.610100],[199.255323,16.588377],[202.158999,13.476956],[203.366723,11.498747],[203.631098,10.671564],[204.266723,10.327517],[204.902348,10.096373],[205.166723,9.540637],[206.072549,7.995978],[208.250383,5.387197],[210.744158,2.246808],[212.409573,-0.575933],[213.356645,-2.409749],[214.123343,-3.172483],[215.468744,-4.428264],[217.807183,-7.447483],[221.799883,-12.701903],[226.331863,-19.001903],[230.591723,-24.622483],[231.068441,-25.208889],[231.266723,-26.197483],[231.539394,-27.097952],[232.194963,-27.472483],[233.012850,-27.895443],[233.675743,-28.912343],[234.649440,-30.512718],[236.214543,-32.338483],[237.738376,-34.104368],[238.612823,-35.560773],[239.237738,-36.065508],[240.884530,-36.047107],[248.870773,-34.229793],[258.920273,-31.539083],[260.818213,-19.854431],[264.096693,5.827517],[267.019850,29.045969],[268.749023,39.367617],[270.104109,41.020303],[272.732163,42.760897],[275.035401,44.065886],[275.680403,44.697999],[276.019624,45.457816],[275.876606,47.784431],[274.798123,51.893477],[273.332409,55.877017],[272.617278,56.792877],[271.873123,57.063657],[250.338493,51.760437]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[157.989793,13.504987],[161.535757,11.359557],[164.958556,8.097814],[167.924461,4.099028],[170.099743,-0.257533],[171.253612,-4.020749],[172.052447,-8.132734],[172.499876,-12.389718],[172.599528,-16.587932],[172.355030,-20.523606],[171.770013,-23.992970],[170.848104,-26.792256],[169.592933,-28.717693],[168.656299,-29.914091],[168.266723,-30.928193],[168.015012,-31.716919],[167.310984,-32.609950],[164.852588,-34.516116],[161.504767,-36.261073],[157.880753,-37.459203],[155.488941,-37.912377],[153.597215,-38.008953],[152.123032,-37.646646],[150.983848,-36.723172],[150.097116,-35.136248],[149.380295,-32.783589],[148.126203,-25.371933],[147.321245,-18.107872],[147.274643,-14.335473],[147.346535,-13.094004],[146.826453,-11.914943],[146.028110,-9.269192],[145.430993,-4.501413],[144.812679,1.349894],[143.963343,6.600707],[143.380558,10.354297],[143.403083,12.605907],[144.090966,13.382853],[145.396865,13.988021],[149.275506,14.646831],[153.864614,14.509948],[157.989793,13.504987]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[238.805823,2.676977],[239.458241,1.225937],[239.570014,-0.465958],[239.157246,-2.214636],[238.236043,-3.836023],[237.774581,-5.022384],[237.887793,-6.311023],[238.094462,-7.373801],[237.709921,-7.624071],[236.936263,-7.108181],[235.975583,-5.872483],[234.853451,-4.590921],[233.734103,-4.037383],[232.151480,-2.828825],[229.811784,-0.158694],[227.797125,2.619120],[227.189613,4.150727],[232.555023,4.405917],[236.762523,3.989808],[237.977930,3.466718],[238.805823,2.676977]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[-185.433277,37.852517],[-185.742387,34.877037],[-186.094457,33.946368],[-186.547697,33.506047],[-187.121291,33.087955],[-187.276049,32.418986],[-186.541726,30.637331],[-184.770069,28.778911],[-182.386417,27.461557],[-180.065308,26.392422],[-179.339113,25.689844],[-178.874336,24.791267],[-178.644570,22.154144],[-179.207077,17.977107],[-180.663497,8.752517],[-181.280185,6.051111],[-181.670769,5.229333],[-182.055287,4.927517],[-182.557764,4.450957],[-182.518957,3.305187],[-182.801667,-1.466920],[-184.082626,-10.031434],[-185.728376,-18.665806],[-187.105457,-23.647483],[-187.816479,-24.649820],[-188.764009,-25.269699],[-190.140990,-25.584720],[-192.140367,-25.672483],[-196.084117,-25.672483],[-197.058707,-30.216783],[-197.910976,-34.787169],[-197.947497,-37.471341],[-197.623523,-38.276425],[-197.052017,-38.814351],[-195.108277,-39.361253],[-173.951787,-43.203223],[-160.934206,-45.502632],[-155.238297,-46.177503],[-154.205617,-42.208993],[-153.557421,-39.576741],[-152.772297,-38.144083],[-152.310989,-37.089893],[-152.441347,-35.367573],[-152.888686,-34.299529],[-153.675621,-33.433462],[-156.506397,-32.116833],[-158.503451,-31.484933],[-159.958531,-30.774191],[-160.901424,-29.714545],[-161.361922,-28.035932],[-161.369814,-25.468289],[-160.954889,-21.741553],[-158.975747,-9.730553],[-154.257477,16.712947],[-153.277544,20.120633],[-152.856864,20.649153],[-152.377417,20.881057],[-151.008271,21.106152],[-149.281696,20.917743],[-145.108547,19.464737],[-140.562544,16.850685],[-136.348257,13.404237],[-132.811979,9.256445],[-129.480796,4.273691],[-127.004777,-0.456721],[-126.290599,-2.387515],[-126.033987,-3.847483],[-125.567127,-4.672066],[-124.200154,-4.916019],[-121.981452,-4.580577],[-118.959407,-3.666973],[-115.259227,-2.361483],[-115.826327,-10.350963],[-115.959051,-17.035430],[-115.368755,-23.234707],[-114.050183,-28.981701],[-111.998077,-34.309323],[-110.469187,-37.853737],[-109.833277,-39.934323],[-109.560606,-40.667524],[-108.905037,-40.972483],[-108.077624,-41.420276],[-107.391817,-42.496883],[-106.091595,-44.416288],[-103.815387,-46.902543],[-101.462193,-49.054868],[-99.931007,-49.972483],[-99.314799,-50.170764],[-98.883277,-50.647483],[-97.140860,-52.029261],[-93.459596,-53.994503],[-88.943085,-56.007633],[-84.694927,-57.533073],[-78.866620,-58.575957],[-71.506137,-58.972483],[-67.358817,-58.809303],[-63.362450,-58.326319],[-59.528611,-57.533364],[-55.868873,-56.440271],[-52.394810,-55.056873],[-49.117995,-53.393004],[-46.050003,-51.458496],[-43.202407,-49.263183],[-40.586781,-46.816898],[-38.214699,-44.129474],[-36.097734,-41.210745],[-34.247459,-38.070543],[-32.675450,-34.718701],[-31.393279,-31.165054],[-30.412520,-27.419433],[-29.744747,-23.491673],[-29.393790,-19.032690],[-29.441097,-14.523720],[-29.867055,-10.051906],[-30.652050,-5.704394],[-31.776467,-1.568329],[-33.220694,2.269146],[-34.965115,5.720886],[-36.990117,8.699747],[-38.856850,11.325943],[-39.633277,12.974747],[-39.834450,13.647639],[-40.318117,13.927517],[-41.856394,14.847289],[-44.593117,17.058667],[-48.539603,20.002573],[-53.055242,22.503528],[-58.006677,24.530237],[-63.260550,26.051406],[-68.683504,27.035739],[-74.142182,27.451941],[-79.503225,27.268719],[-84.633277,26.454777],[-88.608631,25.200125],[-93.135869,23.288283],[-97.231769,21.177873],[-99.913107,19.327517],[-104.060607,15.704977],[-106.887027,12.597528],[-109.849437,8.317687],[-112.153184,4.842904],[-113.395987,3.671057],[-117.056597,17.358347],[-120.229927,30.577517],[-127.406597,32.150007],[-147.691417,35.961067],[-169.615487,40.013567],[-176.870136,41.294672],[-181.932347,41.827517],[-185.433277,41.827517],[-185.433277,37.852517]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-66.871447,10.405207],[-65.791517,9.995137],[-64.429396,8.982405],[-61.309246,5.698098],[-58.412332,1.650571],[-56.639987,-2.061893],[-55.864383,-5.829851],[-55.501292,-10.096420],[-55.528410,-14.677579],[-55.923435,-19.389308],[-56.664062,-24.047586],[-57.727989,-28.468394],[-59.092912,-32.467709],[-60.736527,-35.861513],[-63.137158,-39.192221],[-64.439828,-40.385821],[-65.864516,-41.292548],[-69.241290,-42.328280],[-73.590167,-42.465203],[-76.681912,-42.102767],[-79.385699,-41.339504],[-81.729405,-40.147033],[-83.740905,-38.496972],[-85.448077,-36.360938],[-86.878797,-33.710550],[-88.060942,-30.517426],[-89.022387,-26.753183],[-89.724194,-22.096202],[-90.000569,-17.380147],[-89.838076,-13.606840],[-89.588055,-12.386786],[-89.223277,-11.778103],[-88.644229,-10.564598],[-88.389487,-8.349993],[-88.171734,-5.886069],[-87.588647,-3.312512],[-85.515299,1.804157],[-82.547105,6.281315],[-80.845460,8.055486],[-79.061727,9.400267],[-77.309522,10.255232],[-75.175409,10.668003],[-66.871447,10.405207]]);
    }
    linear_extrude(height=h)
      polygon([[97.040243,24.301047],[92.656354,23.855462],[82.715243,23.383057],[64.991723,22.364997],[62.782251,22.000175],[61.646498,21.422467],[61.227107,20.223647],[61.166723,17.995487],[61.708473,11.443797],[62.126617,9.966434],[62.867174,9.073983],[64.265880,8.543065],[66.658473,8.150297],[69.156202,7.696440],[70.584021,7.028366],[71.168509,5.949357],[71.136243,4.262697],[71.295515,2.988104],[71.880233,1.489127],[72.604284,-3.010565],[73.318555,-12.398931],[73.882620,-24.333670],[74.156053,-36.472483],[74.216753,-45.022483],[69.945313,-46.372483],[67.711200,-47.172964],[66.338515,-47.985849],[65.567386,-49.037109],[65.137943,-50.552713],[65.047990,-53.090772],[65.584363,-55.218543],[66.278178,-57.043253],[66.566753,-58.852663],[66.701114,-59.706431],[67.100829,-60.386109],[68.676111,-61.218552],[71.252176,-61.340698],[74.788603,-60.743253],[78.902425,-60.127749],[82.449593,-60.169703],[85.291013,-60.293799],[87.708023,-59.875803],[91.139449,-59.272361],[96.419783,-58.950603],[107.066753,-58.364863],[111.116753,-57.900283],[111.116753,-51.298633],[111.116753,-44.696993],[105.941753,-44.096363],[102.271674,-43.499854],[100.714893,-42.909113],[100.114993,-38.722483],[99.783620,-34.395452],[99.756523,-29.047483],[99.642868,-24.446027],[99.347079,-23.335218],[98.885503,-22.972483],[98.425986,-22.618793],[98.176719,-21.502621],[98.277103,-16.652223],[98.366975,-12.046704],[97.948033,-9.849113],[97.396255,-6.889244],[97.166753,-0.451033],[97.276960,5.296639],[97.526322,7.112621],[98.004390,8.392894],[98.785566,9.264607],[99.944251,9.854903],[103.691753,10.699837],[105.848783,11.254015],[106.486155,11.719489],[106.870165,12.446281],[107.000296,15.090995],[106.483573,20.002517],[105.916033,24.727517],[101.691393,24.727517],[98.582461,24.602242],[97.040273,24.301047]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[-31.335307,21.110077],[-32.086846,18.317253],[-32.297997,14.242588],[-31.987757,10.403223],[-31.643050,9.045884],[-31.175117,8.316297],[-29.813694,7.836469],[-27.933277,7.611357],[-25.737346,7.074517],[-23.617337,5.845157],[-21.551387,4.122687],[-21.817337,-20.708713],[-22.048807,-36.462916],[-22.296347,-41.195630],[-22.741962,-44.293531],[-23.468309,-46.102704],[-24.558040,-46.969234],[-26.093811,-47.239205],[-28.158277,-47.258703],[-31.533277,-47.272503],[-31.533277,-53.636793],[-31.217366,-58.753233],[-30.816271,-60.330557],[-30.247567,-61.286793],[-29.137004,-62.142619],[-28.099684,-62.527517],[-27.332733,-62.412050],[-27.033277,-61.766783],[-26.607184,-61.457955],[-25.447027,-61.212692],[-21.633277,-61.011933],[-17.819527,-61.272601],[-16.233277,-61.827853],[-14.688688,-62.076195],[-10.483121,-62.186822],[3.341723,-61.975543],[26.741723,-61.402123],[29.443129,-61.236413],[30.566723,-60.776253],[31.770381,-59.966189],[34.664293,-58.959183],[37.024078,-58.097588],[39.332777,-56.873456],[41.536684,-55.339247],[43.582094,-53.547423],[45.415301,-51.550446],[46.982600,-49.400778],[48.230285,-47.150880],[49.104653,-44.853213],[49.843808,-40.968937],[49.889885,-36.984210],[49.292985,-33.024859],[48.103210,-29.216712],[46.370661,-25.685596],[44.145439,-22.557337],[41.477646,-19.957764],[38.417383,-18.012703],[35.736423,-16.440558],[34.496774,-14.964814],[34.403269,-14.224114],[34.653086,-13.460738],[36.160013,-11.803593],[37.944241,-9.946323],[39.009363,-8.122503],[40.259799,-5.896042],[42.489563,-3.070713],[46.386323,1.834117],[47.961737,3.784203],[50.156021,5.482474],[52.739733,6.784840],[55.483433,7.547207],[58.916723,8.102527],[59.181153,14.615007],[59.445583,21.127497],[55.581153,21.217297],[40.558293,21.333557],[33.414517,21.315247],[31.172243,21.081381],[29.472795,20.525071],[28.058485,19.516838],[26.671624,17.927205],[22.949503,12.485827],[20.090493,8.608957],[17.572673,5.735827],[15.961490,3.869003],[15.282273,2.411567],[14.630696,0.947712],[13.086553,-0.934523],[11.388463,-2.945421],[10.367353,-4.718613],[9.075624,-7.120455],[7.084234,-9.581084],[5.068283,-11.382496],[4.262067,-11.811618],[3.702873,-11.806683],[3.220022,-10.892696],[2.885223,-9.037330],[2.649846,-3.685821],[2.976878,1.881130],[3.345089,4.005797],[3.846453,5.296807],[4.631386,6.000141],[5.846234,6.603348],[9.246453,7.385887],[13.466723,7.861567],[13.466723,14.413727],[13.466723,20.965897],[6.041723,21.480497],[-15.788177,22.467077],[-23.874064,22.691327],[-28.316851,22.613546],[-30.382084,22.123270],[-31.335307,21.110037]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[17.265943,-29.379103],[20.496654,-31.621844],[22.566154,-34.201789],[23.140858,-35.572815],[23.395748,-36.973662],[23.320989,-38.386171],[22.906743,-39.792183],[21.309687,-42.413920],[18.948966,-44.283144],[15.648148,-45.495895],[11.230803,-46.148213],[6.485514,-46.285123],[4.971958,-45.951166],[3.920184,-45.224102],[3.246982,-44.010306],[2.869143,-42.216154],[2.666723,-36.512283],[2.865004,-30.772024],[3.341723,-27.980053],[5.567634,-27.650276],[9.782676,-27.889311],[14.258296,-28.523479],[17.265943,-29.379103]]);
    }
  }
}
module FL_Slog(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[270.067713,34.199985],[269.748143,33.850532],[268.878026,33.564360],[266.017713,33.299985],[262.912646,33.004664],[262.195501,32.611759],[261.967713,32.034245],[261.522710,31.220971],[260.291833,31.206755],[259.006467,31.193642],[258.088502,30.055420],[257.345600,27.346571],[256.585423,22.621575],[256.187283,18.049395],[256.315350,16.760280],[256.661423,16.142025],[257.012336,14.621612],[257.143698,10.607471],[256.748323,-5.036355],[256.293135,-19.939709],[256.359773,-26.824325],[257.230300,-27.599890],[258.707823,-27.815505],[260.540785,-27.894210],[262.265843,-28.340595],[264.296419,-28.681256],[267.544286,-28.641424],[276.055713,-27.678038],[284.527774,-25.965945],[287.726431,-24.990230],[289.688113,-24.020655],[290.435316,-22.689758],[290.588113,-20.777055],[290.299416,-19.444229],[289.358396,-18.748370],[287.052109,-18.477161],[282.667613,-18.418285],[276.188689,-18.354362],[273.008570,-17.910868],[272.290161,-17.395598],[271.957972,-16.604014],[271.867613,-13.950015],[271.603238,-11.089703],[271.317066,-10.219585],[270.967613,-9.900015],[270.495622,-9.758313],[270.202809,-9.371228],[270.119350,-8.089041],[270.646489,-6.509714],[271.713483,-5.089505],[273.856607,-4.035910],[276.704393,-3.600015],[279.847911,-3.061484],[281.130997,-2.409777],[282.203296,-1.522184],[283.051051,-0.413008],[283.660507,0.903446],[284.109503,4.100965],[284.017603,7.649985],[279.067603,7.405565],[275.277968,7.436900],[273.117783,7.855565],[272.283377,9.714542],[271.681253,13.208865],[271.538280,15.676233],[271.706530,17.471779],[272.261518,18.935867],[273.278763,20.408865],[274.581234,21.827802],[276.092428,22.587769],[278.580925,22.893564],[282.815303,22.949985],[290.317603,22.949985],[290.547353,28.106645],[290.619757,30.972121],[290.407692,32.587890],[289.753425,33.395129],[288.499223,33.835015],[285.178826,34.129797],[280.394473,34.035705],[276.279246,33.984474],[274.567603,34.382335],[273.906666,34.889172],[272.317603,35.099985],[270.728541,34.835610],[270.067603,34.199985]]);
    linear_extrude(height=h)
      polygon([[231.367713,32.399985],[230.980452,31.764360],[230.049373,31.499985],[229.131080,31.306848],[228.397850,30.627490],[227.828275,29.311993],[227.400948,27.210435],[226.887415,20.049462],[226.685993,7.945215],[226.818896,-7.616749],[227.123115,-11.167364],[227.608483,-12.396945],[228.651590,-13.155860],[228.382737,-14.184008],[226.911213,-15.343987],[224.346303,-16.498395],[221.106379,-18.109806],[218.801880,-20.282659],[217.424945,-23.027452],[216.967713,-26.354685],[217.125300,-27.899899],[217.612365,-29.143674],[218.450362,-30.094034],[219.660747,-30.759004],[221.264976,-31.146606],[223.284503,-31.264864],[228.655273,-30.725445],[238.291083,-29.694995],[242.394268,-29.400371],[245.654785,-28.570106],[247.916911,-27.264358],[248.624914,-26.451977],[249.024923,-25.543285],[249.154926,-23.253170],[248.555133,-21.108669],[247.416871,-19.520658],[246.705602,-19.063736],[245.931463,-18.900015],[244.833370,-18.684699],[243.936213,-17.944825],[243.212876,-16.539503],[242.636242,-14.327843],[241.814612,-6.921946],[241.254383,5.399985],[240.764380,16.728994],[240.079722,24.110235],[239.014378,28.830101],[237.382313,32.174985],[236.082086,32.955705],[234.054617,33.275576],[232.187346,33.101401],[231.591110,32.818673],[231.367713,32.399985]]);
    linear_extrude(height=h)
      polygon([[98.617713,31.875565],[90.543903,31.005205],[87.060916,30.589531],[84.727140,29.967042],[82.882995,28.865570],[80.868903,27.012945],[79.266027,25.260160],[78.215917,23.716432],[77.642003,22.239331],[77.467713,20.686425],[77.774881,18.616783],[78.632789,16.930479],[79.946045,15.658585],[81.619257,14.832175],[83.557033,14.482323],[85.663981,14.640101],[87.844708,15.336584],[90.003823,16.602845],[92.911348,18.378149],[95.816488,19.332951],[98.934951,19.507703],[102.482443,18.942855],[105.419863,17.855151],[107.435386,16.179405],[108.595755,13.831052],[108.967713,10.725525],[108.832952,9.659702],[108.384129,8.769586],[107.554431,8.030768],[106.277048,7.418836],[102.111983,6.477993],[95.354443,5.751775],[92.133501,5.414356],[90.178278,4.943379],[89.029170,4.151939],[88.226573,2.853135],[87.209481,1.201298],[86.923742,1.341931],[86.688723,2.077605],[86.352463,2.869801],[85.805460,3.330846],[85.079006,3.471428],[84.204392,3.302236],[82.135847,2.077289],[79.850153,-0.258485],[78.441618,-2.214581],[77.547777,-4.119856],[77.024779,-6.399181],[76.728773,-9.477425],[76.652475,-15.061905],[76.988653,-20.329075],[77.410691,-23.017955],[77.982778,-24.753510],[78.897098,-25.909615],[80.345833,-26.860145],[86.345443,-30.600015],[88.413676,-31.837191],[90.735111,-32.504104],[94.366342,-32.765535],[100.363963,-32.786265],[108.370595,-32.485476],[110.572665,-32.169676],[111.432123,-31.756805],[112.175537,-31.209736],[113.510873,-31.250525],[114.779181,-31.274074],[115.267713,-30.602245],[116.292862,-28.921310],[118.757583,-26.435445],[121.267632,-23.709906],[122.651880,-20.931191],[122.904034,-18.120791],[122.017803,-15.300195],[121.014007,-13.800624],[119.818353,-12.721476],[118.502581,-12.063953],[117.138430,-11.829259],[115.797640,-12.018595],[114.551950,-12.633165],[113.473102,-13.674170],[112.632833,-15.142815],[111.908430,-16.327489],[110.821007,-17.350987],[107.816095,-18.833889],[104.136087,-19.430394],[100.298973,-18.979375],[94.567713,-17.786415],[93.368039,-17.530607],[92.651437,-16.899690],[92.263678,-15.627951],[92.050533,-13.449675],[91.984123,-11.284480],[92.196127,-9.903995],[92.785334,-9.030337],[93.850533,-8.385625],[97.004795,-7.366678],[101.542382,-6.401758],[106.395567,-5.682368],[110.496623,-5.400015],[112.600599,-5.238559],[114.417356,-4.554256],[116.477469,-3.047205],[119.311513,-0.417505],[122.064815,2.347692],[123.545402,4.229540],[124.063129,5.756616],[123.927853,7.457495],[123.245823,15.749985],[123.001954,19.177693],[122.192853,21.722296],[120.345160,24.295664],[116.985513,27.809665],[115.585688,28.940697],[113.804661,29.866400],[108.684173,31.274985],[102.765632,32.197689],[98.617713,31.875565]]);
    linear_extrude(height=h)
      polygon([[142.267713,31.499985],[141.743997,30.864360],[140.484853,30.599985],[139.125247,30.060753],[138.220663,28.524329],[137.811665,26.112623],[137.938813,22.947545],[138.022171,20.724580],[137.706573,19.799985],[137.381610,18.279829],[137.442423,14.624985],[138.238273,-4.243925],[138.698583,-17.937825],[136.037773,-19.313785],[133.690985,-20.882477],[131.976440,-22.813982],[130.925046,-25.061601],[130.567713,-27.578635],[130.656166,-29.249727],[131.272338,-30.160049],[132.942448,-30.626526],[136.192713,-30.966085],[142.861536,-31.263809],[150.996143,-31.264375],[156.944378,-31.028992],[158.750418,-30.719689],[159.946260,-30.150327],[160.658291,-29.221668],[161.012903,-27.834472],[161.155423,-23.287515],[161.097176,-20.969473],[160.764101,-19.655112],[159.944797,-18.979336],[158.427863,-18.577045],[156.867419,-18.073230],[155.611342,-17.137552],[154.617275,-15.597611],[153.842861,-13.281009],[152.783561,-5.628226],[152.094583,7.199985],[151.322753,25.874985],[150.042513,26.099985],[149.532058,26.238974],[149.229160,26.656753],[149.244293,28.333555],[149.349658,29.476478],[149.103800,30.303704],[148.432340,30.933355],[147.260903,31.483555],[145.190181,32.138927],[143.617165,32.360285],[142.617720,32.147378],[142.267713,31.499955]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[168.367713,30.965725],[167.838963,29.814512],[166.567713,29.060755],[165.260656,28.197759],[164.788903,26.670015],[165.371001,22.932093],[166.689576,17.751810],[168.181127,13.100622],[169.282153,10.949985],[169.907581,10.152079],[170.167713,8.654985],[170.426063,6.987666],[171.047203,5.780495],[172.325294,3.440548],[173.748827,-0.457949],[174.816506,-4.347789],[175.027033,-6.661765],[175.130805,-7.944268],[176.030243,-9.333975],[176.891961,-10.369365],[176.905053,-10.800015],[177.171038,-12.023001],[178.640773,-14.963375],[180.284176,-18.515783],[180.967713,-21.210265],[181.232088,-22.845140],[181.867713,-23.850015],[182.503338,-25.020378],[182.767713,-27.053135],[182.854874,-28.551608],[183.370260,-29.340929],[184.694724,-29.648073],[187.209123,-29.700015],[191.220288,-29.448294],[194.158338,-28.635488],[196.213196,-27.175127],[197.574783,-24.980745],[200.271427,-15.635307],[204.699802,1.492571],[208.838901,18.379116],[210.667713,27.000555],[210.932088,28.271404],[211.567713,28.799985],[212.203338,29.184569],[212.467713,30.109205],[212.238462,30.659302],[211.610974,31.163284],[209.522890,31.946304],[206.926659,32.285075],[204.545483,32.006405],[203.715423,31.513442],[202.972582,30.598854],[201.793693,27.577445],[201.263944,25.880104],[200.567627,24.526819],[199.622855,23.481297],[198.347743,22.707250],[196.660405,22.168386],[194.478955,21.828414],[188.306173,21.599985],[180.429313,21.599985],[179.234083,24.905315],[177.730282,28.015890],[175.793653,30.376679],[173.545872,31.875454],[171.108613,32.399985],[169.022697,32.057248],[168.527679,31.611020],[168.367713,30.965725]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[190.516843,7.575425],[191.336175,5.887872],[191.935278,5.607555],[192.699413,5.669045],[193.460371,5.737346],[194.031853,5.469765],[194.733753,3.810595],[194.769108,1.356017],[194.102055,-0.886078],[192.953091,-2.453183],[192.266798,-2.839082],[191.542713,-2.882795],[190.801545,-2.853880],[190.315147,-3.148354],[189.967713,-4.884025],[189.578547,-6.666635],[189.054645,-7.072372],[188.277913,-7.200015],[186.586957,-6.761514],[185.322420,-5.534914],[184.570809,-3.653569],[184.418633,-1.250835],[184.234870,1.203551],[183.842922,1.940755],[183.247053,2.363265],[182.226292,3.073263],[181.788316,4.095634],[181.863064,5.306393],[182.380476,6.581554],[183.270493,7.797130],[184.463055,8.829136],[185.888101,9.553587],[187.475573,9.846495],[188.694113,9.763712],[189.543408,9.405209],[190.119104,8.699581],[190.516843,7.575425]]);
    }
    linear_extrude(height=h)
      polygon([[10.867713,29.251555],[8.808188,28.138597],[7.545237,26.799192],[7.340609,25.673076],[7.716963,25.327419],[8.456053,25.199985],[9.081575,25.050260],[9.362173,24.503070],[8.973853,21.628215],[8.424643,16.255331],[8.231143,8.353215],[7.686993,-16.417825],[7.423018,-29.182138],[7.805788,-31.328361],[8.616203,-32.073975],[9.941591,-32.142820],[10.944763,-31.406165],[11.590511,-30.664001],[11.753933,-31.578535],[11.853615,-31.999309],[12.215524,-32.320487],[14.158090,-32.694708],[25.942713,-32.585185],[36.582797,-32.010350],[39.550777,-31.612161],[40.778933,-31.156665],[41.370286,-29.184844],[41.404791,-26.500834],[40.944989,-23.884149],[40.053423,-22.114305],[39.018899,-21.451248],[37.368101,-21.014205],[31.503423,-20.700015],[25.782000,-20.432449],[24.675080,-20.019315],[24.367713,-19.350015],[24.109950,-18.396577],[23.490213,-18.000015],[23.189353,-17.800744],[23.018850,-17.258174],[23.117793,-15.474605],[23.143653,-13.281619],[22.195293,-11.764405],[21.031136,-10.495984],[20.959227,-9.971754],[21.270861,-9.479795],[23.175042,-8.469539],[27.004253,-7.218915],[30.383310,-6.133572],[32.393688,-5.178226],[33.515466,-4.030537],[34.228723,-2.368165],[34.937849,0.821592],[34.780474,1.952921],[34.214090,2.842777],[33.187909,3.541833],[31.651144,4.100759],[26.842713,5.000905],[22.567713,5.604365],[22.567713,10.002165],[22.273646,13.442014],[21.857200,14.178178],[21.217713,14.399985],[20.264276,14.631989],[19.867713,15.189785],[20.459631,16.464395],[22.263456,17.478856],[25.321300,18.248625],[29.675273,18.789155],[34.878252,19.525267],[38.233525,20.785595],[39.309424,21.669416],[40.032781,22.752783],[40.440057,24.058526],[40.567713,25.609475],[40.250463,27.925769],[39.487713,29.519985],[38.007981,29.995995],[34.990814,30.317618],[26.220322,30.515296],[16.928526,30.148212],[13.259728,29.763880],[10.867713,29.251555]]);
    linear_extrude(height=h)
      polygon([[-54.610847,29.080675],[-56.639417,28.673855],[-56.075137,-1.638075],[-55.402347,-24.799818],[-54.983825,-30.521497],[-54.496577,-32.611235],[-52.659305,-33.220693],[-50.375862,-33.222696],[-48.186626,-32.682294],[-46.631977,-31.664535],[-45.913771,-29.993505],[-45.510085,-26.212890],[-45.382117,-7.139535],[-45.761225,21.018060],[-46.194391,25.497733],[-46.957287,27.228705],[-48.257710,28.301733],[-50.115352,29.004020],[-52.307351,29.281642],[-54.610847,29.080675]]);
    linear_extrude(height=h)
      polygon([[-36.250937,29.012575],[-36.574935,24.300711],[-36.757267,13.937575],[-37.397287,-15.523035],[-37.632088,-25.226234],[-37.229719,-30.568749],[-36.698472,-32.004432],[-35.898584,-32.829564],[-34.793606,-33.204017],[-33.347087,-33.287665],[-30.685109,-33.095630],[-28.632035,-32.556335],[-27.210160,-31.678873],[-26.441777,-30.472335],[-25.514347,-28.746131],[-24.057057,-27.029865],[-22.532234,-24.596256],[-21.442427,-21.145385],[-20.312804,-17.383845],[-18.692277,-14.203315],[-16.722157,-11.436545],[-15.157957,-13.368245],[-13.827517,-14.732545],[-12.825337,-15.299985],[-11.880446,-16.340490],[-10.579610,-18.755111],[-9.428375,-21.483504],[-8.932287,-23.465325],[-7.852917,-26.384155],[-7.162214,-28.367364],[-7.017317,-30.374985],[-7.039484,-31.413000],[-6.713668,-32.028915],[-5.914708,-32.324115],[-4.517447,-32.399985],[-2.933073,-32.273764],[-1.685735,-31.812459],[-0.736809,-30.892107],[-0.047670,-29.388743],[0.420305,-27.178403],[0.705741,-24.137124],[0.883493,-15.065895],[0.637847,-5.523364],[0.366099,-2.781692],[0.021453,-1.799985],[-0.324834,-0.688142],[-0.594653,2.431906],[-0.832287,13.403725],[-0.905472,22.855616],[-1.434042,27.690177],[-2.013947,28.859764],[-2.881519,29.455585],[-5.711427,29.700015],[-7.303386,29.075345],[-8.689327,27.578609],[-9.493612,25.775713],[-9.560248,24.936301],[-9.340607,24.232565],[-9.251803,23.644577],[-9.760877,23.400015],[-10.960597,22.342515],[-12.532287,19.800015],[-13.667013,17.257515],[-13.816157,16.200015],[-14.797278,14.878140],[-17.932287,11.700015],[-21.400479,8.721842],[-23.940124,7.344787],[-24.846001,7.261053],[-25.500851,7.582847],[-25.898378,8.311918],[-26.032287,9.450015],[-26.315547,11.039077],[-26.996577,11.700015],[-27.260074,11.810927],[-27.264695,12.112917],[-26.555227,13.105645],[-25.549138,15.155414],[-25.210107,18.280645],[-25.426594,22.456944],[-26.003567,25.282150],[-27.071917,27.127856],[-28.762537,28.365655],[-30.999286,29.227840],[-33.280463,29.647889],[-35.174777,29.588543],[-36.250937,29.012545]]);
    linear_extrude(height=h)
      polygon([[-140.915687,27.065625],[-143.388749,25.046436],[-145.355817,22.617935],[-146.640350,20.789152],[-147.472417,20.211865],[-147.904992,19.401672],[-148.229027,17.012925],[-148.308968,15.041411],[-148.055669,13.991917],[-147.262382,13.574700],[-145.722357,13.500015],[-143.159573,13.905071],[-140.864457,14.878935],[-137.942697,16.081414],[-134.077287,16.767970],[-130.049044,16.861441],[-126.638787,16.284665],[-125.067601,15.531576],[-123.726321,14.439025],[-122.651564,13.099749],[-121.879950,11.606484],[-121.448097,10.051965],[-121.392623,8.528930],[-121.750147,7.130115],[-122.557287,5.948255],[-124.643337,4.793063],[-128.100154,3.748442],[-132.185520,2.991668],[-136.157217,2.700015],[-139.290614,2.567653],[-141.425123,2.151526],[-142.644446,1.423071],[-143.032287,0.353725],[-143.296662,-0.531708],[-143.932287,-0.899985],[-144.567912,-1.287246],[-144.832287,-2.218325],[-145.383419,-3.444353],[-146.708477,-4.540765],[-148.477915,-6.193832],[-150.023227,-9.034064],[-151.259704,-12.858519],[-152.102637,-17.464255],[-152.424050,-20.963027],[-152.360424,-23.367733],[-151.901245,-24.754632],[-151.035997,-25.199985],[-149.710311,-25.800876],[-148.280930,-27.167464],[-147.301698,-28.645620],[-147.153964,-29.222120],[-147.326457,-29.581215],[-147.662514,-30.306506],[-146.982697,-31.310475],[-145.958434,-31.944139],[-145.671377,-30.860475],[-145.452613,-29.891004],[-144.679757,-31.172095],[-143.338756,-32.605979],[-140.745082,-33.532758],[-136.556877,-34.023903],[-130.432287,-34.150885],[-123.737937,-33.905463],[-118.949434,-33.150235],[-115.572600,-31.755054],[-113.113257,-29.589775],[-111.784784,-27.595920],[-110.961002,-25.495441],[-110.620569,-23.403702],[-110.742139,-21.436064],[-111.304369,-19.707889],[-112.285915,-18.334540],[-113.665432,-17.431378],[-115.421577,-17.113765],[-117.017179,-17.285142],[-118.260745,-17.790534],[-119.191132,-18.654409],[-119.847197,-19.901235],[-120.438186,-20.608078],[-121.708483,-21.166256],[-126.771347,-21.982185],[-131.832716,-22.314655],[-134.875299,-21.933819],[-135.824341,-21.408883],[-136.490441,-20.625186],[-137.269487,-18.174265],[-138.665977,-13.305715],[-138.910235,-12.406968],[-138.678413,-11.581938],[-137.971536,-10.831088],[-136.790629,-10.154880],[-133.010824,-9.028234],[-127.347197,-8.205695],[-122.086268,-7.459690],[-118.355804,-6.294088],[-115.538319,-4.422469],[-113.016327,-1.558415],[-112.130026,0.104712],[-111.457473,2.345390],[-110.774508,8.002144],[-111.009230,14.297325],[-111.483785,17.336039],[-112.203437,20.116415],[-113.264748,23.137458],[-114.332859,24.904231],[-115.975767,26.020847],[-118.761467,27.091415],[-124.511942,28.421763],[-130.896718,28.860005],[-136.752423,28.407502],[-139.118321,27.847646],[-140.915687,27.065615]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[-102.527547,27.455765],[-102.995863,26.522724],[-103.236027,25.089995],[-103.050237,20.480765],[-102.598850,10.500645],[-102.346267,-5.587145],[-102.113230,-20.252891],[-101.708767,-26.814055],[-99.382287,-28.624495],[-98.441505,-29.353418],[-98.412502,-29.581417],[-98.707287,-29.672585],[-99.501818,-30.220698],[-99.832287,-31.499985],[-99.597252,-32.460711],[-98.952858,-33.096602],[-97.990168,-33.417280],[-96.800247,-33.432364],[-94.102963,-32.584233],[-92.777728,-31.740260],[-91.589517,-30.629175],[-90.332219,-28.969938],[-89.607729,-27.139463],[-89.255535,-24.466343],[-89.115127,-20.279175],[-89.267698,-14.421998],[-89.574842,-13.043265],[-90.047787,-12.599985],[-90.360574,-12.468558],[-90.362659,-12.099514],[-89.482287,-10.799985],[-87.513270,-9.597683],[-84.718983,-9.018568],[-81.704055,-9.113076],[-79.073117,-9.931645],[-78.163482,-10.679676],[-77.635919,-12.034629],[-77.332287,-18.510555],[-76.853127,-25.892682],[-76.219796,-28.561312],[-75.293405,-30.597301],[-74.051033,-32.037386],[-72.469760,-32.918302],[-70.526664,-33.276786],[-68.198827,-33.149575],[-66.995526,-32.784677],[-66.330230,-31.544671],[-65.996868,-28.557220],[-65.789367,-22.949985],[-65.764225,-9.811391],[-66.115067,7.875015],[-66.733697,28.800015],[-70.572797,28.800015],[-73.714610,28.420705],[-74.842328,27.968617],[-75.606017,27.361175],[-76.106606,26.063016],[-76.584974,23.636068],[-77.349577,16.953409],[-77.648887,10.428405],[-77.545640,8.198526],[-77.231967,7.176265],[-76.832944,6.774717],[-76.757520,6.351265],[-77.454735,5.518656],[-79.078147,4.838457],[-81.382287,4.470685],[-85.144381,4.323044],[-87.335744,4.537565],[-88.375689,5.232228],[-88.683527,6.525015],[-89.071627,15.737605],[-89.330857,20.022319],[-89.879655,22.772207],[-91.013280,24.831199],[-93.026987,27.043225],[-95.172297,28.279420],[-97.957732,28.781376],[-100.652934,28.517381],[-101.738462,28.088243],[-102.527547,27.455725]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-100.491757,-10.124985],[-101.313185,-14.165708],[-101.548265,-13.300340],[-101.632287,-10.499985],[-101.393069,-7.533735],[-101.134128,-6.631391],[-100.817927,-6.299985],[-100.540247,-6.601801],[-100.386192,-7.423579],[-100.491757,-10.124985]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[-231.445537,27.060915],[-233.825219,25.842633],[-236.367468,23.733567],[-238.945653,20.857015],[-241.433141,17.336275],[-242.654281,15.159253],[-243.384958,13.074589],[-243.739514,10.602150],[-243.832291,7.261805],[-243.435728,1.308309],[-242.482291,-4.195165],[-241.497088,-8.613476],[-241.151213,-11.774888],[-241.445865,-13.563608],[-241.833762,-13.907024],[-242.382241,-13.863845],[-242.984734,-13.846881],[-243.437929,-14.365971],[-244.018951,-17.267085],[-244.075714,-20.097510],[-243.669001,-21.449985],[-243.148699,-22.697329],[-242.932291,-25.274985],[-242.667916,-27.764516],[-242.381744,-28.521840],[-242.032291,-28.799985],[-241.396666,-29.196548],[-241.132291,-30.149985],[-240.867916,-31.103423],[-240.232291,-31.499985],[-239.596664,-32.028735],[-239.332287,-33.299985],[-239.212314,-34.140620],[-238.822507,-34.697216],[-237.054047,-35.099985],[-235.302848,-34.729475],[-234.291787,-33.838675],[-233.480279,-32.825050],[-232.208887,-32.159245],[-231.458658,-31.742899],[-230.876860,-30.905331],[-230.137387,-27.795565],[-229.828646,-19.479595],[-229.867000,-6.501441],[-230.179553,5.872120],[-230.693407,12.374315],[-230.926169,13.425906],[-230.767199,14.181245],[-230.144013,14.764369],[-228.984127,15.299315],[-226.402907,15.935432],[-223.523697,16.200015],[-221.072502,15.853091],[-220.575761,15.338576],[-220.432287,14.524815],[-220.327879,13.746325],[-219.977942,13.297006],[-218.321197,13.253185],[-217.179400,13.332837],[-216.390719,12.910269],[-215.772262,11.784206],[-215.141137,9.753375],[-214.453057,5.674751],[-214.299817,1.350015],[-214.040360,-8.664574],[-212.737197,-24.299985],[-212.153715,-29.416799],[-211.474318,-32.098264],[-210.976570,-32.771431],[-210.308346,-33.130590],[-208.265137,-33.299985],[-205.132287,-33.299985],[-204.959427,-20.924985],[-204.953427,-6.299985],[-205.801287,7.361865],[-206.492013,15.184970],[-207.006922,17.949968],[-207.707649,20.122706],[-208.648786,21.832270],[-209.884924,23.207742],[-211.470654,24.378206],[-213.460567,25.472745],[-217.319384,26.668121],[-222.464885,27.407362],[-227.604580,27.576337],[-231.445977,27.060915]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-242.317491,-19.968735],[-242.680907,-20.359264],[-242.861241,-19.424985],[-242.751663,-18.366431],[-242.388541,-18.243735],[-242.143382,-18.974753],[-242.317541,-19.968735]]);
    }
    linear_extrude(height=h)
      polygon([[-169.726927,26.158745],[-171.628093,24.657497],[-172.922267,22.944971],[-173.483856,21.251662],[-173.187267,19.808065],[-173.203078,19.166757],[-174.029167,18.900015],[-174.949644,18.591675],[-175.382914,17.811525],[-175.288413,16.776870],[-174.625577,15.705015],[-174.451127,15.112449],[-174.637142,14.157262],[-175.988687,11.475015],[-177.553304,9.353979],[-178.803535,8.272792],[-179.632242,8.286467],[-179.932287,9.450015],[-180.328849,10.403452],[-181.282287,10.800015],[-181.875932,10.629202],[-182.297472,10.114014],[-182.632287,8.034025],[-182.959513,5.912580],[-183.438157,5.554862],[-184.188697,5.567765],[-184.925610,5.909393],[-185.614226,6.575862],[-186.684107,8.460339],[-187.073430,10.375226],[-186.911349,11.079708],[-186.457287,11.474555],[-185.895800,12.076269],[-185.512413,13.301510],[-185.260662,16.754931],[-185.663473,20.099529],[-186.098289,21.188742],[-186.682287,21.600015],[-187.272912,21.768765],[-187.694787,22.275015],[-188.032287,24.300015],[-188.116662,25.734390],[-188.482287,26.550015],[-189.297912,26.915640],[-190.732287,27.000015],[-192.869787,26.625015],[-193.305724,26.071890],[-193.432287,25.200015],[-193.632123,23.928765],[-194.112587,23.400015],[-194.988058,22.540796],[-196.137587,20.475015],[-196.795837,18.157807],[-197.208284,14.151300],[-197.482287,-2.054565],[-197.729999,-17.836210],[-198.104426,-21.166692],[-198.703487,-22.417145],[-199.219730,-22.934979],[-199.489268,-23.716136],[-199.311307,-26.212555],[-198.565987,-29.574157],[-197.876092,-31.434995],[-196.981387,-32.231471],[-195.621637,-32.399985],[-194.075409,-32.664360],[-193.432287,-33.299985],[-193.237798,-33.794819],[-192.709220,-34.092607],[-190.979108,-34.144087],[-188.900586,-33.548517],[-187.132287,-32.399985],[-185.530568,-31.127744],[-184.207287,-30.596615],[-183.636123,-30.268600],[-182.912610,-29.378156],[-181.379667,-26.453605],[-180.224670,-22.934075],[-180.355586,-22.083812],[-180.929667,-21.520755],[-181.632623,-20.907736],[-181.057287,-20.713765],[-180.262755,-20.298386],[-179.932287,-19.318325],[-179.500842,-17.650564],[-178.462990,-15.734804],[-177.203460,-14.156219],[-176.106977,-13.499985],[-175.032118,-13.832380],[-173.844287,-14.770206],[-171.343317,-18.105990],[-169.031286,-22.795022],[-167.335417,-28.124985],[-166.623622,-30.924677],[-165.951069,-32.482350],[-165.068843,-33.155091],[-163.728027,-33.299985],[-161.544303,-32.773035],[-159.687827,-31.506105],[-158.823800,-30.246384],[-158.479525,-28.343249],[-159.205857,-18.800675],[-159.849348,-10.345174],[-159.758801,-8.198795],[-159.395687,-7.300975],[-158.800991,-5.814223],[-158.392397,-2.590554],[-158.116224,6.759286],[-158.532598,16.132048],[-158.989686,19.384369],[-159.606947,20.911235],[-160.067677,21.413818],[-159.457287,21.586235],[-158.507201,21.955914],[-158.437160,22.909805],[-159.193431,24.266941],[-160.722277,25.846355],[-162.834915,27.272478],[-164.918879,27.795718],[-167.155704,27.422373],[-169.726927,26.158745]]);
    linear_extrude(height=h)
      polygon([[-283.735871,24.168685],[-287.521631,19.350015],[-288.600106,18.196920],[-288.390981,20.250015],[-287.922081,22.950015],[-289.096641,20.476505],[-289.824221,17.856340],[-289.924141,15.030225],[-289.645834,13.434675],[-289.129907,12.510071],[-288.154517,12.050506],[-286.497821,11.850075],[-283.730146,12.135359],[-281.563521,13.370915],[-279.741783,14.477819],[-277.970401,14.644605],[-276.742861,14.618539],[-276.232291,15.195045],[-275.953370,15.730680],[-275.186683,16.058771],[-272.610463,16.132705],[-269.344540,15.497619],[-266.229821,14.234285],[-264.428144,13.111351],[-263.365333,12.079090],[-262.860384,10.879864],[-262.732291,9.256035],[-263.096809,6.917066],[-263.522062,6.151351],[-264.082291,5.725485],[-265.035728,4.999627],[-265.432291,3.981975],[-265.780142,3.249971],[-266.616461,3.210915],[-268.228537,3.127321],[-270.441461,2.288215],[-273.698402,1.314000],[-277.820521,0.905555],[-280.435553,0.825289],[-282.081126,0.462050],[-283.205583,-0.379074],[-284.257271,-1.892995],[-285.623323,-4.975575],[-286.522471,-8.464805],[-287.424857,-11.546500],[-288.101199,-12.726221],[-288.860711,-13.520475],[-289.578981,-14.262194],[-290.113278,-15.281439],[-290.619757,-17.917679],[-290.359761,-20.959539],[-289.312901,-23.937365],[-288.518464,-26.280870],[-288.461211,-28.344025],[-288.518833,-29.288450],[-288.259708,-30.329806],[-286.855611,-32.535255],[-285.464246,-33.865261],[-283.532508,-34.537906],[-279.818992,-34.747113],[-273.082291,-34.686805],[-265.749828,-34.442592],[-260.987693,-33.811309],[-257.728277,-32.539696],[-254.903971,-30.374495],[-253.339296,-28.373988],[-252.406443,-26.022278],[-252.212082,-23.756334],[-252.862881,-22.013125],[-254.416344,-20.999115],[-256.757868,-20.810604],[-259.956751,-21.453270],[-264.082291,-22.932795],[-268.665445,-24.494064],[-272.522748,-25.096766],[-275.678647,-24.741765],[-278.157591,-23.429925],[-279.327689,-22.171028],[-279.426454,-21.781221],[-279.157291,-21.629925],[-278.594987,-21.267270],[-278.211834,-20.340047],[-277.962064,-17.547555],[-278.366158,-14.763763],[-278.800334,-13.847415],[-279.382291,-13.499985],[-280.335728,-13.145271],[-280.732291,-12.292445],[-280.466452,-11.678186],[-279.715143,-11.083292],[-277.033336,-10.028699],[-273.241326,-9.282863],[-268.893571,-8.999985],[-264.572077,-8.510955],[-260.459871,-7.146656],[-256.899867,-5.061271],[-254.234981,-2.408985],[-253.281897,-0.774976],[-252.718768,1.281094],[-252.382291,9.000015],[-252.719817,16.740536],[-253.294718,18.776601],[-254.276371,20.409015],[-257.055887,23.391870],[-258.640278,24.465331],[-260.463651,25.300394],[-265.155017,26.376056],[-271.785341,26.860325],[-281.288371,27.187365],[-283.735871,24.168685]]);
  }
}
module FL_Back(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    difference()
    {
       linear_extrude(height=h)
         polygon([[-45.243225,131.089035],[-45.507600,130.532439],[-46.143225,130.625815],[-46.778850,130.760584],[-47.043225,130.303505],[-48.299006,129.410612],[-51.318225,128.497545],[-60.206812,125.977302],[-70.456404,122.243949],[-79.851331,118.177241],[-83.535899,116.293803],[-86.175925,114.656935],[-94.114405,109.385935],[-99.486387,105.416353],[-105.493336,100.263039],[-111.368025,94.622949],[-116.343225,89.193045],[-120.203687,83.672223],[-124.015154,76.593349],[-127.409716,68.719832],[-130.019465,60.815085],[-131.104339,56.308669],[-131.727430,51.811182],[-132.005866,45.980829],[-132.056775,37.475815],[-131.618583,23.438797],[-131.040329,17.386949],[-130.171214,11.700591],[-128.972670,6.170511],[-127.406130,0.587496],[-123.014795,-11.574185],[-119.852900,-18.729707],[-116.183617,-25.728228],[-112.066864,-32.489585],[-107.562561,-38.933614],[-102.730627,-44.980152],[-97.630980,-50.549035],[-92.323540,-55.560101],[-86.868225,-59.933185],[-84.166819,-62.171584],[-83.043225,-63.626765],[-82.881991,-64.099341],[-82.494355,-63.975315],[-81.076719,-64.237880],[-78.439125,-65.639905],[-71.436805,-69.389733],[-63.371842,-72.612303],[-54.991546,-75.050384],[-47.043225,-76.446745],[-35.620395,-76.940435],[-30.189687,-76.801064],[-26.412555,-76.407045],[-8.957375,-72.263775],[-7.493058,-71.925326],[-6.485286,-72.252305],[-5.558231,-73.562782],[-4.336065,-76.174825],[1.453085,-88.875085],[4.049729,-94.819188],[5.091795,-97.875085],[4.154009,-99.321284],[1.990535,-101.395285],[-1.045745,-103.916355],[-11.669495,-98.730145],[-22.293225,-93.543935],[-33.093225,-92.920445],[-39.111853,-92.651208],[-43.451524,-92.747616],[-47.337045,-93.307385],[-51.993225,-94.428225],[-60.440177,-97.235693],[-68.957320,-101.170916],[-77.199483,-106.052312],[-84.821495,-111.698295],[-89.676247,-115.919908],[-92.702952,-118.970261],[-93.691012,-120.603664],[-93.354737,-120.812231],[-92.429825,-120.574425],[-90.172205,-120.024215],[-88.598231,-119.158605],[-85.970815,-117.077455],[-82.697436,-114.600793],[-79.423724,-112.720174],[-76.774400,-111.737588],[-75.879109,-111.677429],[-75.374185,-111.955025],[-74.242231,-112.758617],[-72.548664,-112.638714],[-70.468919,-111.647002],[-68.178435,-109.835165],[-66.241324,-108.141681],[-64.463605,-107.270099],[-61.942883,-106.975625],[-57.776765,-107.013465],[-52.278942,-106.900415],[-51.153631,-106.598745],[-50.953835,-106.112935],[-50.720944,-105.032548],[-49.585555,-103.934625],[-46.705088,-103.238572],[-41.420624,-102.882079],[-26.915646,-103.044955],[-12.622500,-104.137606],[-7.602826,-104.943333],[-5.093065,-105.874385],[-9.744995,-106.537618],[-21.326115,-107.735525],[-36.126215,-109.472375],[-48.517435,-111.431345],[-63.693225,-114.150355],[-74.529376,-116.147403],[-84.950870,-118.916998],[-92.668382,-121.751809],[-94.797730,-122.972629],[-95.304854,-123.495211],[-95.392585,-123.944505],[-94.412113,-124.884171],[-91.766470,-126.025633],[-79.757905,-129.528925],[-75.191602,-130.617839],[-70.936350,-131.289581],[-66.233903,-131.629811],[-60.326015,-131.724185],[-49.510630,-131.444690],[-40.561531,-130.510641],[-32.567702,-128.778692],[-24.618125,-126.105495],[-17.108476,-122.620147],[-9.613984,-118.056990],[-2.457927,-112.636329],[4.036415,-106.578465],[7.049324,-103.899083],[8.074084,-103.361823],[8.676165,-103.428465],[15.003655,-114.624185],[19.292646,-122.320991],[21.843565,-126.292045],[22.534830,-126.911675],[22.932238,-126.999211],[23.156775,-125.356125],[22.606224,-121.102684],[20.943921,-115.547103],[18.153890,-108.644675],[14.220155,-100.350695],[9.916179,-91.384303],[8.374775,-87.406175],[10.387550,-88.784005],[14.628695,-92.694705],[19.111041,-96.547274],[24.412525,-100.186985],[30.348211,-103.535639],[36.733163,-106.515038],[43.382443,-109.046984],[50.111116,-111.053279],[56.734246,-112.455726],[63.066895,-113.176125],[69.828285,-113.251537],[78.008280,-112.856902],[96.204266,-110.981418],[105.010347,-109.662531],[112.815212,-108.197522],[119.013907,-106.667373],[123.001475,-105.153065],[128.681775,-102.548355],[131.065369,-101.244786],[131.790466,-100.566036],[132.056775,-99.981605],[130.243385,-97.731553],[126.133568,-94.015708],[121.722854,-90.522459],[119.006775,-88.940195],[118.428207,-88.615083],[118.301005,-87.900585],[117.948090,-87.323528],[116.794175,-87.353625],[115.929356,-87.405074],[115.147924,-87.050915],[113.631835,-84.972655],[111.914869,-82.716516],[109.838855,-81.260335],[108.355710,-80.470596],[108.031883,-80.103007],[108.064195,-79.816765],[107.539184,-79.043678],[105.401818,-77.678041],[97.896350,-73.910533],[88.760449,-69.997071],[81.206775,-67.420485],[77.432060,-66.563201],[74.017530,-66.074940],[63.656775,-65.772345],[54.450018,-66.086380],[51.635377,-66.656097],[49.087685,-67.618235],[44.703560,-69.218835],[40.087685,-70.407355],[35.827044,-71.419912],[32.136509,-72.679275],[29.538834,-73.973183],[28.813181,-74.566760],[28.556775,-75.089375],[28.309996,-75.601463],[27.716665,-75.511195],[25.056846,-76.175744],[19.841665,-78.502585],[14.655186,-81.043912],[11.614535,-82.307280],[9.783574,-82.589738],[8.226165,-82.188335],[7.225166,-81.466900],[6.100092,-80.115129],[3.888569,-76.358619],[2.413289,-72.594877],[2.208519,-71.234066],[2.495945,-70.499975],[4.557953,-69.886310],[8.045185,-69.319625],[11.531365,-68.688654],[13.590835,-67.920395],[15.381254,-67.176514],[18.220555,-66.604135],[23.656473,-65.159803],[30.685006,-62.489810],[36.765369,-59.660112],[38.655990,-58.518485],[39.356775,-57.736665],[39.632495,-57.233474],[40.295395,-57.024185],[42.642228,-55.837959],[46.753400,-52.883089],[51.450915,-49.065290],[55.556775,-45.290275],[60.047072,-40.454291],[64.098150,-35.581836],[67.028541,-31.542777],[68.156775,-29.206975],[68.355056,-28.530689],[68.831775,-28.074175],[69.886577,-26.701592],[71.622758,-23.340043],[76.698435,-11.574645],[79.251073,-2.773501],[82.065685,10.025825],[82.441655,15.501762],[82.621875,24.875825],[82.375774,33.979963],[81.593531,42.935592],[80.301035,51.523838],[78.524175,59.525825],[76.378034,66.294654],[71.934485,76.175825],[69.166501,81.400031],[65.685250,87.165930],[62.424852,92.004206],[60.319425,94.445545],[59.498303,95.232344],[59.156775,96.113335],[58.342884,97.561099],[56.241775,100.102340],[50.221295,106.166295],[45.271295,110.857655],[42.074252,113.632883],[38.167019,116.403487],[33.733472,119.080191],[28.957491,121.573719],[24.022953,123.794795],[19.113736,125.654146],[14.413717,127.062494],[10.106775,127.930565],[-3.393225,130.214825],[-13.164858,131.168179],[-27.191621,131.710931],[-39.781686,131.724185],[-43.759261,131.495095],[-45.243225,131.089045]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[33.056775,-93.073955],[53.427570,-96.011146],[71.306775,-97.459775],[103.256775,-98.887095],[122.584410,-99.845619],[126.285193,-100.457284],[126.820985,-100.813795],[126.547485,-101.210785],[124.988265,-101.769836],[122.981775,-102.010415],[121.171886,-102.187786],[120.085335,-102.595625],[118.549775,-103.097251],[115.660345,-103.500845],[110.456775,-104.383375],[107.878003,-105.048553],[104.698335,-105.331976],[101.470899,-105.218937],[98.748825,-104.694725],[96.952978,-104.245232],[95.298679,-104.209735],[93.392850,-104.630808],[90.842415,-105.551025],[86.093965,-107.422685],[81.655285,-105.173435],[78.389301,-103.725234],[75.644334,-103.058368],[73.027060,-103.129108],[70.144155,-103.893725],[68.132576,-104.232560],[65.002595,-103.870576],[51.334855,-100.261595],[38.832723,-96.452576],[27.134013,-92.531534],[18.470039,-89.283990],[15.973364,-88.158255],[15.072115,-87.495465],[17.110351,-87.895681],[22.031775,-89.670565],[28.147556,-91.806259],[33.056775,-93.073955]]);
    }
  }
}
module GA_Stat(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-256.792524,41.874976],[-261.022809,40.887383],[-265.123834,39.469751],[-269.086248,37.628250],[-272.900698,35.369053],[-276.557831,32.698330],[-280.048295,29.622252],[-283.362737,26.146990],[-286.491804,22.278716],[-288.907752,18.045002],[-290.636775,12.908130],[-291.678463,7.127236],[-292.032406,0.961456],[-291.698192,-5.330075],[-290.675411,-11.488221],[-288.963652,-17.253846],[-286.562504,-22.367814],[-282.977752,-27.797060],[-279.039599,-32.214713],[-274.521669,-35.709445],[-269.197587,-38.369929],[-262.840977,-40.284839],[-255.225463,-41.542846],[-246.124671,-42.232623],[-235.312224,-42.442844],[-207.978634,-42.442844],[-209.566674,-35.746414],[-211.483579,-29.472557],[-213.862274,-23.792084],[-215.443145,-20.903142],[-216.006844,-20.196102],[-216.489968,-19.987048],[-216.945454,-20.280754],[-217.426239,-21.081994],[-218.675454,-24.226174],[-219.843500,-26.576707],[-221.504948,-28.559230],[-223.716176,-30.194433],[-226.533561,-31.503009],[-230.013479,-32.505649],[-234.212308,-33.223044],[-239.186424,-33.675885],[-244.992204,-33.884864],[-250.739717,-33.659184],[-255.892335,-32.782978],[-260.486952,-31.231058],[-264.560463,-28.978234],[-268.149762,-25.999317],[-271.291744,-22.269116],[-274.023303,-17.762441],[-276.381334,-12.454104],[-278.739922,-5.638651],[-279.363884,-2.952623],[-279.626263,-0.500451],[-279.533539,1.903322],[-279.092192,4.444151],[-277.189544,10.678806],[-275.582849,14.481135],[-273.539571,17.998945],[-271.106881,21.216114],[-268.331945,24.116518],[-265.261934,26.684035],[-261.944016,28.902540],[-258.425360,30.755911],[-254.753133,32.228024],[-250.974505,33.302757],[-247.136645,33.963987],[-243.286721,34.195589],[-239.471901,33.981441],[-235.739355,33.305420],[-232.136251,32.151403],[-228.709758,30.503266],[-225.507044,28.344886],[-222.928932,25.858426],[-220.904683,22.970875],[-219.457036,19.820540],[-218.608729,16.545728],[-218.382501,13.284747],[-218.801088,10.175905],[-219.887230,7.357509],[-221.663664,4.967866],[-222.704142,3.410947],[-222.552774,2.852215],[-221.913026,2.423226],[-219.046466,1.904254],[-213.860614,1.753586],[-202.843304,1.753586],[-205.794904,9.573286],[-206.959255,13.444851],[-207.381166,16.991676],[-207.062244,20.320745],[-206.004094,23.539046],[-205.233400,25.447665],[-204.857435,27.027272],[-204.959273,28.380825],[-205.621986,29.611279],[-206.928645,30.821592],[-208.962323,32.114720],[-215.543024,35.361246],[-221.063329,37.728898],[-226.409657,39.641666],[-231.616979,41.105074],[-236.720268,42.124642],[-241.754497,42.705894],[-246.754638,42.854352],[-251.755663,42.575538],[-256.792544,41.874976]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[-78.204194,42.048576],[-83.602936,40.465461],[-88.702413,38.374227],[-93.443381,35.820641],[-97.766594,32.850473],[-101.612808,29.509493],[-104.922776,25.843471],[-107.637253,21.898175],[-109.696994,17.719376],[-111.954433,10.911784],[-113.247653,4.290108],[-113.621600,-2.096740],[-113.121223,-8.199843],[-111.791467,-13.970289],[-109.677281,-19.359163],[-106.823612,-24.317551],[-103.275406,-28.796538],[-99.077610,-32.747211],[-94.275172,-36.120654],[-88.913039,-38.867955],[-83.036158,-40.940199],[-76.689476,-42.288470],[-69.917940,-42.863856],[-62.766497,-42.617442],[-55.280094,-41.500314],[-49.789945,-40.136792],[-44.809726,-38.393968],[-40.304903,-36.246764],[-36.240944,-33.670098],[-32.583317,-30.638891],[-29.297488,-27.128061],[-26.348925,-23.112529],[-23.703094,-18.567214],[-22.011672,-14.084915],[-20.986093,-8.673787],[-20.599531,-2.658473],[-20.825157,3.636382],[-21.636144,9.886137],[-23.005665,15.766147],[-24.906891,20.951771],[-27.312994,25.118366],[-29.315860,27.526697],[-31.613310,29.800759],[-36.974069,33.906851],[-43.159491,37.358205],[-49.933794,40.076382],[-57.061198,41.982945],[-64.305919,42.999457],[-71.432179,43.047480],[-78.204194,42.048576]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-51.500094,30.244026],[-47.202861,28.096168],[-43.521680,25.489182],[-40.443273,22.399778],[-37.954357,18.804668],[-36.041652,14.680564],[-34.691877,10.004176],[-33.891752,4.752216],[-33.627994,-1.098604],[-33.925927,-8.611375],[-34.395116,-11.494574],[-35.163807,-14.014673],[-36.296515,-16.335941],[-37.857755,-18.622646],[-42.523894,-23.749444],[-47.127561,-27.748144],[-51.947234,-30.826835],[-56.907279,-33.020777],[-61.932058,-34.365230],[-66.945935,-34.895455],[-71.873272,-34.646712],[-76.638434,-33.654261],[-81.165782,-31.953362],[-85.379681,-29.579275],[-89.204493,-26.567261],[-92.564582,-22.952580],[-95.384312,-18.770492],[-97.588044,-14.056258],[-99.100143,-8.845136],[-99.844972,-3.172388],[-99.746894,2.926726],[-98.789213,9.995771],[-98.033119,12.817863],[-97.006944,15.339032],[-95.646758,17.689801],[-93.888626,20.000695],[-88.922794,25.024946],[-84.823154,28.359435],[-80.628397,30.917835],[-76.303483,32.705032],[-71.813369,33.725914],[-67.123015,33.985368],[-62.197379,33.488280],[-57.001419,32.239537],[-51.500094,30.244026]]);
    }
    linear_extrude(height=h)
      polygon([[-192.140324,1.757326],[-191.931878,-16.054883],[-192.192053,-28.586031],[-192.928596,-35.991080],[-193.477927,-37.819744],[-194.149254,-38.424994],[-195.264548,-38.583510],[-196.178476,-39.015113],[-196.796687,-39.653887],[-197.024834,-40.433914],[-196.202643,-40.821032],[-193.844801,-41.150404],[-185.183577,-41.616164],[-172.363974,-41.791705],[-156.708804,-41.637534],[-134.198670,-41.072577],[-127.127389,-40.707331],[-122.320521,-40.205484],[-119.384480,-39.505969],[-117.925685,-38.547719],[-117.550551,-37.269666],[-117.865494,-35.610744],[-120.844982,-25.116626],[-121.801920,-22.252995],[-122.577069,-20.781979],[-123.300491,-20.556326],[-124.102247,-21.428781],[-126.461004,-25.879004],[-127.748474,-28.193359],[-129.064645,-29.949057],[-130.707463,-31.223178],[-132.974868,-32.092799],[-136.164805,-32.634998],[-140.575216,-32.926854],[-154.249234,-33.067844],[-178.270824,-33.067844],[-178.270824,-18.335704],[-178.270824,-3.603564],[-164.877964,-3.603564],[-158.440601,-3.886767],[-153.388253,-4.786599],[-149.449060,-6.378396],[-146.351164,-8.737494],[-144.100184,-10.806853],[-142.274595,-12.031911],[-140.835789,-12.367799],[-139.745159,-11.769648],[-138.964098,-10.192589],[-138.453996,-7.591754],[-138.092244,0.860726],[-138.341607,8.228998],[-138.725716,10.416024],[-139.347136,11.673974],[-140.254137,12.054599],[-141.494991,11.609646],[-145.171334,8.450006],[-147.854470,6.727877],[-151.939093,5.468334],[-157.314501,4.695165],[-163.869994,4.432156],[-178.550784,4.432156],[-177.741164,18.494656],[-176.931534,32.557156],[-156.163684,33.339626],[-144.713295,33.583635],[-140.740584,33.409307],[-137.616667,32.969688],[-135.101897,32.213977],[-132.956628,31.091372],[-130.941212,29.551072],[-128.816004,27.542276],[-125.138477,24.021053],[-122.989308,22.680273],[-122.293574,22.792402],[-121.746790,23.407465],[-120.789214,26.090156],[-117.822494,36.575006],[-117.462801,38.291961],[-117.744470,39.596752],[-119.055889,40.545912],[-121.785447,41.195974],[-126.321531,41.603471],[-133.052528,41.824935],[-154.652814,41.935896],[-193.002964,41.939896],[-192.140324,1.757586]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[-10.860094,-0.257694],[-10.860094,-42.442844],[18.604206,-41.740124],[41.235531,-40.832129],[49.538218,-40.235507],[54.271806,-39.635864],[56.621566,-38.806754],[58.742927,-37.471649],[60.627610,-35.690665],[62.267337,-33.523921],[63.653829,-31.031531],[64.778806,-28.273613],[65.633992,-25.310284],[66.211106,-22.201659],[66.498005,-15.788992],[66.191233,-12.605182],[65.573274,-9.516543],[64.635851,-6.583192],[63.370685,-3.865246],[61.769496,-1.422821],[59.824006,0.683966],[57.549593,3.051407],[56.495806,5.054344],[56.605493,6.927492],[57.821506,8.905566],[59.156812,11.115488],[60.546906,14.426837],[61.827349,18.391528],[62.833706,22.561476],[64.804231,30.997874],[66.769506,37.244656],[67.439851,39.558548],[67.361479,40.375175],[66.977218,40.994157],[65.200454,41.726891],[61.928406,41.932156],[59.632243,41.859576],[57.813043,41.527860],[56.361399,40.766037],[55.167906,39.403139],[54.123156,37.268199],[53.117743,34.190247],[50.787306,24.521436],[49.469394,19.641009],[47.821192,15.729046],[45.680180,12.687613],[42.883843,10.418777],[39.269664,8.824604],[34.675126,7.807160],[28.937712,7.268512],[21.894906,7.110726],[3.248006,7.110726],[4.356606,24.521436],[5.465206,41.932156],[-2.697494,41.930156],[-10.860094,41.928156],[-10.860094,-0.256984]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[50.595206,-6.878134],[52.345799,-9.790587],[53.594606,-12.773539],[54.341737,-15.768186],[54.587306,-18.715723],[54.331424,-21.557344],[53.574206,-24.234245],[52.315762,-26.687620],[50.556206,-28.858664],[49.212750,-29.934930],[47.477195,-30.832042],[42.564068,-32.132759],[35.285385,-32.848724],[25.109706,-33.067844],[3.872406,-33.067844],[3.872406,-16.996414],[3.872406,-0.924994],[25.149106,-0.924994],[36.597512,-1.109549],[40.549055,-1.410561],[43.586006,-1.913236],[45.908750,-2.664451],[47.717674,-3.711086],[49.213164,-5.100021],[50.595606,-6.878134]]);
    }
    linear_extrude(height=h)
      polygon([[95.588606,36.589476],[91.003390,33.400626],[87.047087,29.804016],[83.714287,25.789177],[80.999581,21.345634],[78.897559,16.462918],[77.402812,11.130556],[76.509931,5.338075],[76.213506,-0.924994],[76.449906,-6.741094],[77.161638,-12.115296],[78.352502,-17.050098],[80.026293,-21.548001],[82.186811,-25.611504],[84.837854,-29.243108],[87.983219,-32.445310],[91.626706,-35.220612],[95.772111,-37.571512],[100.423232,-39.500511],[105.583869,-41.010107],[111.257818,-42.102801],[117.448878,-42.781092],[124.160848,-43.047480],[131.397524,-42.904464],[139.162706,-42.354544],[150.672285,-41.159419],[154.164252,-40.561142],[156.430668,-39.824481],[157.683783,-38.846003],[158.135845,-37.522277],[157.999103,-35.749871],[157.485806,-33.425354],[155.948910,-27.879971],[155.191384,-26.247674],[154.330143,-25.302512],[153.281941,-24.989638],[151.963532,-25.254206],[148.183106,-27.296284],[145.570149,-28.685294],[142.445349,-29.933797],[135.023506,-31.935282],[126.644137,-33.152728],[118.033806,-33.438124],[113.865482,-33.012811],[109.939766,-32.000552],[106.279670,-30.448645],[102.908204,-28.404385],[99.848382,-25.915068],[97.123214,-23.027991],[94.755714,-19.790449],[92.768893,-16.249738],[91.185763,-12.453155],[90.029336,-8.447995],[89.322624,-4.281556],[89.088638,-0.001132],[89.350392,4.345981],[90.130896,8.712485],[91.453164,13.051085],[93.340206,17.314486],[95.006922,20.108641],[96.979053,22.666925],[99.228522,24.982064],[101.727249,27.046786],[104.447159,28.853816],[107.360174,30.395882],[110.438215,31.665710],[113.653206,32.656027],[116.977068,33.359560],[120.381725,33.769034],[123.839099,33.877178],[127.321112,33.676718],[130.799687,33.160380],[134.246745,32.320890],[137.634211,31.150977],[140.934006,29.643366],[145.429173,27.008534],[146.821386,25.723951],[147.729943,24.259343],[148.219790,22.463274],[148.355870,20.184307],[147.826506,13.571936],[147.199415,6.774190],[147.280856,4.674932],[147.733381,3.261219],[148.637808,2.397403],[150.074959,1.947832],[154.870706,1.748836],[159.689503,1.979081],[161.177269,2.511893],[162.178856,3.538448],[162.790442,5.220208],[163.108209,7.718634],[163.247006,15.811336],[163.051357,24.014669],[162.597661,26.737546],[161.720818,28.849816],[160.281405,30.582917],[158.139998,32.168290],[151.193506,35.821606],[144.663943,38.459123],[137.422068,40.378664],[129.763887,41.576140],[121.985406,42.047463],[114.382631,41.788546],[107.251568,40.795301],[100.888224,39.063640],[98.086949,37.919626],[95.588606,36.589476]]);
    linear_extrude(height=h)
      polygon([[173.961306,0.414296],[173.961306,-41.103564],[184.675606,-41.062564],[188.996112,-40.895160],[191.668756,-40.444789],[192.368953,-40.119302],[192.635374,-39.730044],[192.460749,-39.279340],[191.837806,-38.769514],[190.904202,-37.733310],[190.162143,-35.828586],[189.601397,-32.896907],[189.211731,-28.779837],[188.904706,-16.355774],[189.159206,2.711096],[190.032706,41.939686],[181.997006,41.935686],[173.961306,41.931686],[173.961306,0.413836]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[218.283106,3.795716],[231.436756,-24.131441],[235.438118,-33.400000],[236.907706,-37.722144],[237.074152,-38.464271],[237.562085,-39.127468],[239.433968,-40.192389],[242.386470,-40.867543],[246.282706,-41.103564],[250.413209,-40.869450],[253.339681,-40.161887],[255.081415,-38.973045],[255.514035,-38.195698],[255.657706,-37.295094],[257.092801,-32.840836],[261.000243,-23.528239],[273.845106,4.222756],[292.032406,41.932156],[281.880806,41.932156],[276.450493,41.725804],[274.664479,41.384171],[273.388006,40.809173],[272.538657,39.945016],[272.034018,38.735904],[271.729206,35.059636],[271.528894,30.001580],[270.793365,26.022636],[269.320732,22.998065],[268.244911,21.804690],[266.909106,20.803131],[263.356598,19.313095],[258.461321,18.403220],[252.021386,17.948770],[243.834906,17.825006],[230.891837,17.953426],[226.796893,18.253004],[223.889331,18.833094],[221.871390,19.786400],[220.445312,21.205621],[219.313337,23.183459],[218.177706,25.812616],[217.016162,29.234882],[216.299331,32.648238],[216.084587,35.657176],[216.429306,37.866186],[216.748240,39.829299],[216.424444,40.535814],[215.740181,41.079442],[213.175384,41.739450],[208.824106,41.932156],[199.658506,41.932156],[218.283106,3.795716]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[259.242206,7.780366],[259.037388,5.657410],[257.576368,1.362149],[255.101517,-4.481053],[251.855206,-11.247834],[243.246206,-28.267114],[236.059106,-12.252184],[230.983218,-0.504623],[228.872006,5.250446],[229.191147,5.883063],[230.095104,6.483594],[233.336648,7.561667],[237.955011,8.431216],[243.308568,9.038792],[248.755692,9.330944],[253.654757,9.254224],[257.364137,8.755181],[258.572187,8.330585],[259.242206,7.780366]]);
    }
  }
}
module GA_Slog(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    difference()
    {
       linear_extrude(height=h)
         polygon([[-153.658910,22.767855],[-152.862021,16.802453],[-152.858246,14.907690],[-153.186375,13.596230],[-153.898001,12.761580],[-155.044719,12.297249],[-158.849800,12.053575],[-163.136839,11.836368],[-166.756824,11.166655],[-169.739174,10.017297],[-172.113307,8.361156],[-173.908645,6.171095],[-175.154605,3.419975],[-175.880607,0.080658],[-176.116070,-3.873995],[-175.756537,-9.292512],[-175.250754,-11.526407],[-174.477524,-13.549319],[-173.399268,-15.440691],[-171.978409,-17.279969],[-167.958570,-21.120015],[-164.582419,-23.676331],[-160.930797,-25.922357],[-157.054317,-27.855962],[-153.003588,-29.475014],[-148.829222,-30.777383],[-144.581830,-31.760937],[-140.312022,-32.423547],[-136.070409,-32.763080],[-131.907602,-32.777406],[-127.874212,-32.464395],[-124.020851,-31.821914],[-120.398128,-30.847834],[-117.056654,-29.540023],[-114.047041,-27.896350],[-111.419900,-25.914684],[-109.225840,-23.592895],[-107.117008,-20.623423],[-105.390060,-17.642360],[-104.223204,-14.996247],[-103.794650,-13.031625],[-103.255077,-11.514169],[-101.713476,-10.362329],[-99.285528,-9.630982],[-96.086910,-9.375005],[-92.844899,-9.074690],[-89.715459,-8.257000],[-87.055141,-7.046820],[-85.220500,-5.569035],[-83.319450,-3.741366],[-82.364663,-3.304421],[-81.310905,-3.189405],[-78.618097,-3.937172],[-74.664260,-6.008685],[-70.491732,-8.117636],[-68.747298,-8.665733],[-67.074135,-8.880904],[-65.354781,-8.766642],[-63.471776,-8.326442],[-58.744960,-6.482205],[-55.436127,-4.810784],[-52.726480,-3.048338],[-50.895638,-1.404627],[-50.223220,-0.089415],[-49.894200,0.458413],[-48.998355,0.012722],[-46.053470,-3.421855],[-44.052315,-5.737991],[-41.737756,-7.464062],[-39.159160,-8.596072],[-36.365896,-9.130021],[-33.407331,-9.061912],[-30.332831,-8.387747],[-27.191765,-7.103527],[-24.033500,-5.205255],[-21.237352,-3.423320],[-19.398290,-2.713671],[-18.797739,-2.755863],[-18.388548,-3.060016],[-18.080360,-4.446065],[-17.734612,-6.675645],[-16.793219,-10.225098],[-13.698600,-19.330095],[-11.269544,-24.937091],[-8.917912,-28.457293],[-7.656864,-29.557210],[-6.278052,-30.282265],[-4.735770,-30.681405],[-2.984310,-30.803575],[-0.530487,-30.620434],[1.284466,-30.023130],[2.470130,-28.939845],[3.036084,-27.298756],[2.991909,-25.028045],[2.347185,-22.055891],[-0.705590,-13.719975],[-2.880389,-8.239031],[-3.362848,-6.519968],[-3.417896,-5.344481],[-3.027447,-4.609549],[-2.173413,-4.212149],[0.997760,-4.017855],[4.091340,-3.687335],[5.027133,-3.106862],[5.604110,-2.100850],[5.858656,-0.557750],[5.827157,1.633987],[5.051570,8.409565],[3.848579,18.650271],[3.348210,25.820275],[2.890008,27.732057],[1.680807,29.231141],[-0.031283,30.279961],[-1.998154,30.840954],[-3.971695,30.876554],[-5.703797,30.349197],[-6.946352,29.221319],[-7.451250,27.455355],[-7.692546,26.254237],[-8.331125,25.998180],[-9.366821,26.687137],[-10.799470,28.321065],[-11.855325,29.368386],[-13.305868,30.269418],[-17.522827,31.661565],[-23.713955,32.555405],[-32.142860,33.008835],[-39.163126,33.023311],[-44.912115,32.712439],[-48.796567,32.131159],[-49.854197,31.756286],[-50.223220,31.334415],[-50.554877,30.957726],[-51.505415,30.712340],[-54.996541,30.606632],[-60.163409,30.999604],[-66.472830,31.873565],[-74.745202,33.068570],[-80.065590,33.304944],[-81.873546,33.047546],[-83.249212,32.531171],[-84.294493,31.749381],[-85.111290,30.695735],[-86.434350,28.940314],[-87.688796,28.278392],[-89.083157,28.690287],[-90.825960,30.156315],[-92.750133,31.549591],[-95.222395,32.550771],[-98.059332,33.158855],[-101.077529,33.372844],[-104.093573,33.191738],[-106.924050,32.614537],[-109.385547,31.640243],[-111.294650,30.267855],[-112.542693,28.466754],[-113.564734,25.938874],[-114.255303,23.019664],[-114.508930,20.044575],[-114.715029,16.071307],[-115.177872,14.934246],[-116.062992,14.299815],[-117.507203,14.120203],[-119.647317,14.347597],[-126.562500,15.832155],[-132.966295,17.549923],[-135.085100,18.418586],[-136.607440,19.400294],[-137.627510,20.574938],[-138.239508,22.022413],[-138.616070,26.055425],[-138.888655,29.972225],[-139.323529,31.276510],[-140.041136,32.218896],[-141.104239,32.855019],[-142.575599,33.240512],[-146.994130,33.482145],[-151.764137,33.296062],[-153.185190,32.882123],[-154.063875,32.093066],[-154.475390,30.808001],[-154.494935,28.906037],[-153.658910,22.767855]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-34.954530,21.727145],[-33.700111,20.178301],[-31.868065,18.710559],[-29.704459,17.489505],[-27.455360,16.680725],[-24.741723,15.956667],[-23.918620,15.516115],[-25.031297,15.248400],[-28.125000,15.042855],[-30.674181,14.594432],[-32.586610,13.577287],[-33.798659,12.043374],[-34.246700,10.044645],[-34.479400,8.130564],[-34.749468,7.760556],[-35.139770,7.790994],[-36.334343,9.080482],[-38.169650,12.053575],[-40.901070,17.766461],[-41.753678,20.269775],[-42.092590,22.098215],[-41.931850,23.563564],[-41.406031,24.588876],[-40.593169,25.178208],[-39.571303,25.335616],[-38.418468,25.065157],[-37.212703,24.370888],[-36.032044,23.256865],[-34.954530,21.727145]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-96.484380,21.149555],[-97.390138,20.632204],[-98.660017,20.419882],[-100.125561,20.519527],[-101.618310,20.938075],[-102.705708,21.533594],[-102.780594,22.019682],[-101.869760,22.369545],[-100.000000,22.556385],[-98.134287,22.510796],[-96.849541,22.230354],[-96.261120,21.761217],[-96.484380,21.149545]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-67.702720,14.865155],[-64.842704,8.654681],[-63.705190,4.820515],[-63.849915,4.326814],[-64.205992,4.207759],[-65.430396,4.930500],[-69.075574,9.077784],[-72.691852,14.652991],[-73.880131,17.160636],[-74.330360,19.046745],[-73.920805,22.050766],[-73.407108,22.542266],[-72.685909,22.359107],[-70.616329,19.965870],[-67.702720,14.865155]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-93.582590,4.185265],[-93.383791,2.877369],[-93.750001,2.008926],[-94.618444,1.642716],[-95.926340,1.841515],[-97.383862,2.573937],[-98.753491,3.701867],[-99.881420,5.071497],[-100.613840,6.529015],[-100.812643,7.836911],[-100.446432,8.705354],[-99.577988,9.071564],[-98.270090,8.872765],[-96.812572,8.140345],[-95.442942,7.012416],[-94.315012,5.642787],[-93.582590,4.185265]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-123.288430,3.348215],[-121.513358,0.805378],[-120.208300,-1.636440],[-119.372400,-3.991633],[-119.004804,-6.274600],[-119.104656,-8.499736],[-119.671101,-10.681438],[-120.703284,-12.834102],[-122.200350,-14.972125],[-126.944610,-20.831035],[-129.922180,-13.094095],[-133.635227,-2.847062],[-134.616894,0.620628],[-135.025730,3.160955],[-134.869538,4.906308],[-134.156123,5.989077],[-132.893289,6.541653],[-131.088840,6.696425],[-128.861597,6.432231],[-126.648481,5.712890],[-124.705442,4.648264],[-123.288430,3.348215]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-148.264320,-0.992965],[-147.021936,-4.740623],[-145.414670,-11.383925],[-144.874538,-15.147975],[-145.078793,-17.861888],[-146.004857,-19.524694],[-146.731511,-19.961630],[-147.630150,-20.135426],[-149.932093,-19.693116],[-152.888107,-18.196794],[-156.475612,-15.645493],[-160.672030,-12.038245],[-165.391355,-7.498475],[-166.722669,-5.910493],[-167.418815,-4.626392],[-167.517590,-3.533132],[-167.056790,-2.517671],[-164.607660,-0.267985],[-162.702522,0.855401],[-160.463516,1.618863],[-158.037893,2.028934],[-155.572905,2.092145],[-153.215802,1.815029],[-151.113836,1.204117],[-149.414258,0.265942],[-148.264320,-0.992965]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[26.785710,30.589015],[24.544167,28.638560],[22.988161,25.997164],[22.107101,22.957944],[21.890398,19.814016],[22.327461,16.858499],[23.407701,14.384508],[25.120527,12.685161],[26.210851,12.217578],[27.455350,12.053575],[29.756522,12.383918],[31.435363,13.357036],[32.463484,14.946064],[32.812500,17.124135],[32.969266,18.644401],[33.421569,20.025228],[35.104825,22.346980],[37.646343,24.046224],[40.830195,25.079791],[44.440456,25.404513],[48.261200,24.977221],[52.076500,23.754748],[55.670430,21.693925],[58.213318,19.552761],[58.607677,18.752331],[58.339653,18.046690],[57.350999,17.371853],[55.583470,16.663836],[49.478810,14.892325],[45.840674,13.727198],[42.590764,12.305689],[39.732860,10.643878],[37.270747,8.757846],[35.208206,6.663673],[33.549021,4.377438],[32.296975,1.915224],[31.455850,-0.706891],[31.029429,-3.472826],[31.021495,-6.366501],[31.435830,-9.371836],[32.276218,-12.472750],[33.546442,-15.653163],[35.250283,-18.896995],[37.391525,-22.188166],[39.973950,-25.510595],[43.737983,-29.431208],[45.558496,-30.819363],[47.441730,-31.874200],[49.465478,-32.631808],[51.707534,-33.128277],[57.157740,-33.482145],[62.382372,-33.116502],[66.885211,-32.034403],[70.645368,-30.258095],[73.641949,-27.809821],[75.854063,-24.711829],[77.260819,-20.986364],[77.841325,-16.655670],[77.574690,-11.741995],[77.212894,-7.836256],[77.277817,-5.069511],[77.693467,-3.436337],[78.383849,-2.931314],[79.272969,-3.549019],[80.284833,-5.284032],[81.343448,-8.130931],[82.372820,-12.084295],[83.539940,-15.999987],[84.273558,-17.393075],[85.156233,-18.455601],[86.224724,-19.222027],[87.515794,-19.726810],[90.912720,-20.089285],[94.585027,-19.849120],[95.701251,-19.419250],[96.399275,-18.667596],[96.725413,-17.507716],[96.725980,-15.853166],[95.935660,-10.714285],[95.517483,-7.225190],[95.666225,-4.472387],[96.322422,-2.490509],[97.426608,-1.314189],[98.919316,-0.978059],[100.741083,-1.516753],[102.832443,-2.964904],[105.133930,-5.357145],[106.714377,-6.846999],[108.624426,-8.000350],[110.733042,-8.802240],[112.909191,-9.237711],[115.021838,-9.291806],[116.939949,-8.949567],[118.532487,-8.196036],[119.668420,-7.016255],[120.759636,-6.000002],[122.653143,-4.976639],[125.082708,-4.065308],[127.782100,-3.385155],[131.309467,-3.066393],[132.640599,-3.346979],[133.764486,-3.985925],[134.741970,-5.032018],[135.633893,-6.534044],[137.404420,-11.101045],[139.063246,-15.170505],[140.969833,-17.964096],[143.210278,-19.573222],[145.870680,-20.089285],[148.699283,-19.772553],[149.583689,-19.275686],[150.152914,-18.463416],[150.435518,-17.268443],[150.460063,-15.623464],[149.849220,-10.714285],[149.423305,-7.336036],[149.360023,-4.723067],[149.651244,-2.882123],[150.288835,-1.819953],[151.264667,-1.543301],[152.570609,-2.058915],[154.198530,-3.373541],[156.140300,-5.493925],[158.148355,-7.153050],[160.896933,-8.300504],[164.195173,-8.881720],[167.852220,-8.842135],[176.116070,-8.035715],[175.444870,9.102435],[174.972460,16.012036],[174.182405,22.156227],[173.184787,26.866551],[172.089690,29.474545],[170.795306,30.275346],[168.297731,30.942312],[159.347444,31.895605],[144.547695,32.376151],[123.207350,32.425675],[77.008930,32.142855],[76.205620,16.741075],[75.598730,8.192366],[75.154001,5.469749],[74.514406,3.580465],[73.604437,2.373646],[72.348584,1.698422],[70.671341,1.403924],[68.497200,1.339285],[64.698971,1.095541],[63.551799,0.634937],[62.837395,-0.190085],[62.504362,-1.483475],[62.501304,-3.349181],[63.279530,-9.213335],[63.789292,-13.880037],[63.687571,-17.509603],[63.011550,-20.078390],[61.798414,-21.562753],[60.085346,-21.939047],[57.909530,-21.183630],[55.308150,-19.272858],[52.318390,-16.183085],[49.338068,-12.266784],[47.454053,-8.700242],[46.673949,-5.459567],[47.005359,-2.520866],[48.455886,0.139750],[51.033135,2.546175],[54.744709,4.722299],[59.598210,6.692015],[65.797163,9.117823],[67.956881,10.289208],[69.596539,11.531495],[70.795968,12.918622],[71.635003,14.524527],[72.551220,18.688415],[72.643257,22.322207],[72.027820,25.427116],[70.709041,27.991030],[68.691050,30.001835],[65.549195,31.373229],[60.717547,32.389052],[54.741528,33.041661],[48.166563,33.323415],[41.538074,33.226670],[35.401487,32.743783],[30.302224,31.867113],[26.785710,30.589015]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[111.761570,17.543735],[113.658106,13.586110],[114.933386,10.332484],[115.604415,7.874278],[115.688203,6.302914],[115.201754,5.709811],[114.162078,6.186392],[112.586181,7.824076],[110.491070,10.714285],[107.345313,16.187598],[105.495788,20.899391],[105.113284,22.767219],[105.122244,24.201667],[105.545136,25.121735],[106.404430,25.446425],[107.220207,24.822853],[108.502178,23.125010],[111.761570,17.543735]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[130.284910,13.392855],[130.973955,9.876652],[131.061058,8.082882],[130.873725,7.809438],[130.529721,7.939634],[129.363450,9.374995],[128.304500,11.340157],[127.431154,13.720704],[126.833970,16.216344],[126.603510,18.526785],[126.845848,22.000714],[127.163408,22.510824],[127.597554,22.223032],[128.772587,19.313745],[130.284910,13.392855]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[92.793770,15.852355],[94.048509,11.797009],[94.328940,8.930509],[94.111409,8.026813],[93.659443,7.520815],[92.976091,7.446007],[92.064400,7.835885],[90.910990,8.926356],[89.870482,10.579151],[88.344481,14.699183],[87.967141,16.730153],[87.919010,18.450915],[88.254164,19.643337],[89.026680,20.089285],[89.986378,19.754965],[91.016530,18.844686],[91.993530,17.497475],[92.793770,15.852355]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[147.950060,12.723215],[147.808973,9.338205],[147.378033,7.722510],[147.027766,7.545025],[146.573715,7.770113],[145.312500,9.374995],[143.407414,13.260032],[142.772385,16.697410],[142.931142,18.081047],[143.407414,19.152153],[144.201200,19.843857],[145.312500,20.089285],[146.349300,19.508056],[147.192190,17.925502],[147.754625,15.583323],[147.950060,12.723215]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[168.144430,6.494565],[168.972991,2.428898],[168.900840,0.939948],[168.523231,-0.154553],[167.854289,-0.830708],[166.908138,-1.064622],[165.698900,-0.832400],[164.240700,-0.110145],[163.075148,1.035910],[162.217489,2.706445],[161.673878,4.692708],[161.450471,6.785945],[161.553423,8.777403],[161.988890,10.458330],[162.763027,11.619972],[163.881990,12.053575],[164.991165,11.614935],[166.164538,10.420618],[167.262247,8.653026],[168.144430,6.494565]]);
    }
  }
}
module GU_Stat(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-82.558330,52.515975],[-80.544610,52.291896],[-78.808330,52.562375],[-78.506776,52.800448],[-78.823179,52.988450],[-81.019620,53.138615],[-83.018491,52.936621],[-83.121034,52.743449],[-82.558330,52.516055]]);
    linear_extrude(height=h)
      polygon([[59.605380,52.058435],[59.972568,51.350461],[60.855380,51.507215],[61.738193,52.214750],[62.105380,52.830995],[61.738193,53.220294],[60.855380,53.382215],[59.972568,52.993355],[59.605380,52.058435]]);
    linear_extrude(height=h)
      polygon([[-44.144620,50.882215],[-43.755760,49.999402],[-42.820840,49.632215],[-42.112866,49.999402],[-42.269620,50.882215],[-42.977155,51.765027],[-43.593400,52.132215],[-43.982699,51.765027],[-44.144620,50.882215]]);
    linear_extrude(height=h)
      polygon([[25.230380,50.882215],[25.937915,49.999402],[26.554160,49.632215],[26.943459,49.999402],[27.105380,50.882215],[26.716520,51.765027],[25.781600,52.132215],[25.073626,51.765027],[25.230380,50.882215]]);
    linear_extrude(height=h)
      polygon([[-300.456423,28.001415],[-304.483443,26.693813],[-308.077774,25.142589],[-311.302461,23.293538],[-314.220547,21.092455],[-316.895077,18.485137],[-319.389097,15.417379],[-321.765651,11.834976],[-324.087783,7.683725],[-326.110589,3.405548],[-327.414372,-0.568915],[-328.212780,-5.104558],[-328.719463,-11.066275],[-328.980380,-17.123533],[-328.794174,-21.562349],[-328.047690,-25.385015],[-326.627773,-29.593825],[-325.145602,-33.037240],[-323.398834,-36.251634],[-321.396986,-39.226569],[-319.149574,-41.951606],[-316.666115,-44.416305],[-313.956126,-46.610228],[-311.029123,-48.522934],[-307.894623,-50.143985],[-303.941334,-51.732912],[-300.068932,-52.702768],[-295.411360,-53.202790],[-289.102563,-53.382215],[-282.249265,-53.354227],[-277.845868,-52.875639],[-274.301574,-51.594136],[-270.025583,-49.157405],[-266.347078,-46.610114],[-263.072270,-43.731250],[-260.294033,-40.672811],[-258.105242,-37.586793],[-256.598771,-34.625193],[-255.867496,-31.940008],[-256.004291,-29.683237],[-256.427238,-28.763005],[-257.102030,-28.006875],[-258.404895,-27.276585],[-260.070664,-26.855799],[-263.924468,-26.865032],[-267.530556,-27.879165],[-268.886680,-28.714502],[-269.756043,-29.742785],[-271.618382,-33.049695],[-273.506392,-35.746638],[-275.506599,-37.885560],[-277.705528,-39.518409],[-280.189705,-40.697130],[-283.045654,-41.473670],[-286.359902,-41.899977],[-290.218973,-42.027995],[-296.041027,-41.491363],[-298.664278,-40.831544],[-301.091207,-39.916697],[-303.318461,-38.751305],[-305.342684,-37.339849],[-307.160524,-35.686811],[-308.768625,-33.796674],[-310.163636,-31.673918],[-311.342200,-29.323026],[-313.036577,-23.954759],[-313.824925,-17.727727],[-313.680413,-10.677785],[-312.745433,-3.399270],[-311.173489,2.214026],[-310.079240,4.571758],[-308.742452,6.723835],[-305.230193,10.691885],[-302.611402,12.763396],[-299.606286,14.468853],[-296.330317,15.785276],[-292.898968,16.689682],[-289.427712,17.159089],[-286.032020,17.170515],[-282.827366,16.700978],[-279.929223,15.727495],[-278.221595,14.664598],[-276.421116,13.052281],[-272.912155,8.723720],[-270.143441,3.830477],[-269.268270,1.512307],[-268.856073,-0.538785],[-268.706428,-3.199853],[-269.045636,-3.986597],[-269.940764,-4.501095],[-274.238485,-4.984192],[-283.278993,-5.190825],[-291.788373,-5.367785],[-291.403993,-10.680285],[-291.019623,-15.992785],[-272.269623,-15.992785],[-253.519620,-15.992785],[-253.128930,3.784925],[-253.186787,18.565708],[-253.501960,23.039117],[-253.987820,25.068275],[-254.984696,25.967432],[-256.176523,26.556742],[-257.495723,26.843662],[-258.874716,26.835650],[-261.541770,25.964658],[-262.694672,25.116593],[-263.637053,24.003425],[-264.855731,22.273649],[-265.833387,21.604767],[-267.045655,21.919964],[-268.968173,23.142425],[-272.290279,25.075571],[-275.984815,26.660328],[-279.953271,27.881495],[-284.097133,28.723870],[-288.317891,29.172251],[-292.517033,29.211437],[-296.596048,28.826226],[-300.456423,28.001415]]);
    linear_extrude(height=h)
      polygon([[-220.394620,27.931515],[-228.033285,25.403118],[-233.987569,22.393674],[-236.369878,20.685157],[-238.375266,18.828298],[-240.018455,16.813734],[-241.314170,14.632105],[-242.855603,10.777213],[-243.800164,5.308823],[-244.403188,-4.252862],[-244.920010,-20.387635],[-245.320988,-39.590876],[-245.150213,-45.425776],[-244.594782,-49.272815],[-243.551836,-51.524460],[-242.815400,-52.174655],[-241.918513,-52.573176],[-239.591954,-52.811429],[-236.469300,-52.631685],[-233.522311,-52.310659],[-231.805299,-51.669479],[-230.871442,-50.383267],[-230.273920,-48.127145],[-229.620245,-38.005964],[-229.221600,-19.451475],[-228.852383,-2.958176],[-228.402438,2.478644],[-227.663004,6.455786],[-226.549630,9.283405],[-224.977868,11.271658],[-222.863268,12.730699],[-220.121380,13.970685],[-216.606893,15.080266],[-213.056762,15.647136],[-209.559229,15.690451],[-206.202537,15.229364],[-203.074931,14.283028],[-200.264652,12.870597],[-197.859944,11.011225],[-195.949050,8.724065],[-194.888627,6.442812],[-194.349076,2.961923],[-194.253775,-2.838916],[-194.526100,-12.080015],[-194.790896,-27.723960],[-194.488100,-40.605235],[-193.781010,-51.519145],[-188.326480,-52.337105],[-185.344587,-52.738216],[-183.111714,-52.663416],[-182.241384,-52.325506],[-181.516580,-51.722167],[-180.447907,-49.523930],[-179.794417,-45.678166],[-179.444830,-39.794337],[-179.212250,-20.350325],[-179.246272,-1.276981],[-179.505263,4.926454],[-180.025594,9.480756],[-180.882276,12.815694],[-182.150324,15.361035],[-183.904751,17.546549],[-186.220570,19.802005],[-190.697746,23.394826],[-193.029156,24.741578],[-195.602622,25.855230],[-202.016248,27.583259],[-211.019670,28.978955],[-215.320451,28.869062],[-220.394670,27.931515]]);
    linear_extrude(height=h)
      polygon([[168.008670,28.333905],[163.519577,27.258582],[159.358754,25.614222],[155.559342,23.431252],[152.154480,20.740105],[149.177310,17.571209],[146.660971,13.954996],[144.638604,9.921894],[143.143350,5.502335],[142.359947,1.082099],[142.513918,-0.419891],[143.076921,-1.501140],[144.082896,-2.200155],[145.565780,-2.555444],[150.098030,-2.388875],[153.343899,-1.712607],[155.497086,-0.511442],[156.706250,1.350026],[157.120050,4.007205],[157.503123,5.368124],[158.507024,7.225516],[161.767310,11.452525],[164.568117,14.298337],[166.990153,15.774115],[170.330042,16.339100],[175.884410,16.452535],[181.116180,16.376625],[184.602523,15.926079],[187.260283,14.877151],[190.006310,13.006095],[192.257868,11.110690],[193.661976,9.403747],[194.378081,7.622978],[194.565630,5.506095],[194.406106,3.134625],[193.872576,1.167343],[192.804870,-0.500112],[191.042816,-1.972101],[188.426243,-3.352985],[184.794978,-4.747123],[173.847690,-7.992605],[161.791619,-11.710007],[157.346052,-13.508765],[153.790076,-15.368005],[150.999648,-17.363061],[148.850726,-19.569266],[147.219267,-22.061953],[145.981230,-24.916455],[145.229474,-27.641359],[144.902935,-30.317983],[144.983460,-32.928730],[145.452899,-35.456005],[146.293103,-37.882214],[147.485919,-40.189760],[149.013197,-42.361049],[150.856788,-44.378484],[152.998538,-46.224470],[155.420300,-47.881412],[158.103920,-49.331715],[161.031249,-50.557783],[164.184137,-51.542020],[167.544431,-52.266831],[171.093983,-52.714622],[174.814640,-52.867795],[181.282823,-52.260154],[187.794400,-50.600850],[193.615573,-48.135311],[196.037944,-46.676900],[198.012540,-45.108965],[199.912544,-42.948646],[201.699539,-40.243619],[204.568043,-34.190038],[205.466321,-31.336781],[205.885130,-28.929412],[205.732855,-27.215580],[205.413931,-26.696131],[204.917880,-26.442935],[199.155090,-25.995045],[196.527422,-25.966524],[194.853811,-26.403551],[193.717502,-27.539415],[192.701740,-29.607405],[191.538788,-31.941380],[190.123489,-34.038124],[188.485350,-35.892280],[186.653872,-37.498492],[182.528918,-39.945657],[177.984660,-41.336768],[173.257128,-41.628972],[168.582353,-40.779417],[166.338509,-39.913089],[164.196367,-38.745252],[162.185429,-37.270550],[160.335200,-35.483625],[159.111695,-33.973540],[158.626029,-32.737305],[158.837554,-31.392200],[159.705620,-29.555505],[160.678756,-28.208439],[162.128362,-26.871183],[166.271436,-24.318340],[171.763740,-22.081449],[178.234170,-20.344985],[187.422826,-18.165067],[194.393858,-15.854279],[199.631290,-13.216421],[203.619150,-10.055295],[206.508089,-6.636918],[207.462189,-4.881293],[208.123868,-2.960676],[208.673435,1.777631],[208.363740,8.382205],[207.785714,11.259499],[206.581645,14.097505],[204.804728,16.843595],[202.508154,19.445142],[199.745115,21.849519],[196.568803,24.004098],[193.032410,25.856253],[189.189130,27.353355],[184.209652,28.694285],[179.415583,29.286360],[174.213172,29.157070],[168.008670,28.333905]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[243.487790,28.186555],[241.628653,27.312007],[240.855380,26.576825],[245.337450,13.724045],[261.279720,-28.492795],[268.756120,-48.180295],[269.440666,-49.246586],[270.753250,-49.918040],[272.943814,-50.267496],[276.262300,-50.367795],[282.997680,-50.367795],[287.124530,-39.430295],[293.055830,-24.117795],[295.842840,-17.242795],[301.276630,-3.492795],[309.386651,17.702459],[311.424255,23.721508],[312.105380,26.656025],[311.734866,27.457383],[310.541156,27.991686],[305.191150,28.382205],[301.765441,28.284452],[299.535470,27.939237],[298.230002,27.268632],[297.577800,26.194705],[292.322980,12.757205],[289.776370,6.507205],[275.734030,6.507205],[261.691700,6.507205],[258.461040,15.910045],[254.308180,26.703435],[253.628002,27.346064],[252.566608,27.883975],[249.678390,28.593800],[246.399970,28.729222],[243.487790,28.186555]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[284.605380,-6.092845],[283.390659,-10.254594],[280.651811,-17.996544],[277.746810,-25.621297],[276.033630,-29.431455],[275.391753,-28.982111],[274.331970,-27.064751],[271.547490,-20.056455],[267.440090,-8.245915],[267.631929,-7.552380],[268.797069,-7.002620],[274.184330,-6.294765],[283.042880,-5.604155],[284.146394,-5.650204],[284.605380,-6.092845]]);
    }
    linear_extrude(height=h)
      polygon([[-97.496880,26.915225],[-98.058191,23.764654],[-98.442422,16.019716],[-98.666720,-12.814135],[-98.519620,-50.885475],[-94.144620,-51.844805],[-90.109005,-52.332968],[-86.549970,-52.159495],[-85.388139,-51.884803],[-84.401923,-51.407294],[-83.447019,-50.467321],[-82.379122,-48.805235],[-79.327138,-42.276131],[-74.091540,-29.742795],[-65.189377,-8.353585],[-60.398377,2.400816],[-59.076883,4.719536],[-58.221964,5.495041],[-57.646547,5.099161],[-57.163560,3.903725],[-48.575310,-18.492795],[-44.155020,-30.199965],[-38.402620,-44.887465],[-35.426150,-51.617795],[-27.984160,-51.617795],[-22.275699,-51.198353],[-20.484686,-50.706469],[-19.557900,-50.055295],[-19.199056,-46.694667],[-18.893288,-38.783643],[-18.492726,-15.076435],[-18.459696,9.534267],[-18.897680,23.516405],[-19.338553,25.550553],[-20.304157,26.630243],[-22.409016,27.056963],[-26.267650,27.132205],[-33.106920,27.132205],[-32.757950,3.416695],[-32.713420,-13.534286],[-33.096330,-20.986165],[-33.533068,-20.782351],[-34.214086,-19.719290],[-35.936230,-15.708165],[-38.976317,-7.628497],[-42.770050,1.181085],[-45.394620,7.935465],[-48.346915,15.250151],[-52.756910,24.632205],[-53.547402,25.406911],[-54.937297,26.080724],[-58.868770,26.887145],[-62.052923,27.040983],[-63.143652,26.735762],[-64.102185,25.940162],[-66.228765,22.170973],[-69.644870,14.319705],[-76.515230,-0.645015],[-80.570192,-9.985621],[-83.129400,-17.133325],[-84.428104,-20.927980],[-85.012708,-21.965192],[-85.452510,-22.207015],[-85.741689,-20.204986],[-85.916180,-15.132685],[-85.866730,1.156295],[-85.841402,17.720034],[-86.042160,23.089755],[-86.363620,25.454975],[-87.199822,26.265264],[-88.505545,26.936961],[-91.903917,27.783046],[-95.315456,27.830158],[-96.637637,27.503139],[-97.496880,26.915225]]);
    linear_extrude(height=h)
      polygon([[65.928980,26.319815],[60.635230,24.184878],[56.898640,21.823459],[54.079982,18.700788],[51.540030,14.282095],[49.716277,10.105619],[49.150979,7.824882],[48.768904,4.874956],[48.410931,-4.655034],[48.355380,-21.729495],[48.426072,-40.373047],[48.677166,-45.934132],[49.216740,-49.545928],[50.153279,-51.626813],[51.595270,-52.595167],[53.651199,-52.869368],[56.429550,-52.867795],[59.701074,-52.408813],[60.977980,-51.911987],[61.781500,-51.305295],[62.289715,-48.657714],[62.732486,-42.560150],[63.262220,-23.057425],[63.743121,-3.420799],[64.127099,3.167603],[64.550400,6.317575],[66.228074,9.094560],[68.801570,11.994215],[70.099383,12.955891],[71.692097,13.735001],[75.567179,14.768174],[80.036706,15.139038],[84.710568,14.892896],[89.198655,14.075052],[93.110860,12.730810],[96.057071,10.905473],[97.046020,9.826551],[97.647180,8.644345],[98.174108,0.086750],[98.431350,-17.306865],[98.684615,-35.613253],[99.201910,-46.365385],[99.907270,-51.737975],[106.318820,-51.365385],[112.730380,-50.992795],[113.065530,-22.086775],[113.177199,-6.338069],[112.961695,3.106499],[112.277861,8.590089],[110.984540,12.455865],[108.540129,16.730082],[105.101673,20.531496],[100.737449,23.798260],[95.515740,26.468525],[92.830650,27.283284],[89.403376,27.857669],[81.227643,28.289866],[72.799268,27.774215],[69.056192,27.163790],[65.928980,26.319815]]);
    linear_extrude(height=h)
      polygon([[118.862290,26.650205],[118.507855,23.824436],[118.589020,19.462705],[118.980380,14.007205],[125.109440,13.618395],[129.956999,13.740100],[131.438033,14.179258],[132.277800,14.868395],[133.110663,17.544016],[133.292570,21.158057],[132.861487,24.630720],[132.427938,25.976597],[131.855380,26.882205],[130.722072,27.570676],[129.047357,28.046992],[124.876045,28.377486],[120.946128,27.902340],[119.573157,27.371605],[118.862290,26.650205]]);
    linear_extrude(height=h)
      polygon([[213.926290,26.816995],[213.577588,24.169982],[213.653580,20.188675],[214.032020,15.257205],[220.881200,15.257205],[227.730380,15.257205],[227.730380,21.507205],[227.730380,27.757205],[221.153900,28.135515],[215.964878,28.027914],[214.594723,27.568201],[213.926290,26.816995]]);
    linear_extrude(height=h)
      polygon([[315.087050,26.584465],[314.745488,23.975790],[314.834590,20.076155],[315.230380,15.257205],[322.105380,15.257205],[328.980380,15.257205],[328.980380,21.507205],[328.980380,27.757205],[322.357850,28.015515],[317.166020,27.807402],[315.766121,27.328435],[315.087050,26.584465]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[-176.644620,24.766085],[-175.382768,19.297454],[-172.361156,9.626292],[-168.725701,-0.789691],[-165.622320,-8.492785],[-162.011909,-17.629620],[-156.650720,-32.575625],[-152.327759,-44.597632],[-150.682522,-48.276872],[-149.122080,-50.711165],[-147.451907,-52.132680],[-145.477479,-52.773588],[-143.004268,-52.866060],[-139.837750,-52.642265],[-137.100816,-52.236522],[-136.116767,-51.789390],[-135.266324,-51.037974],[-133.598240,-48.197951],[-131.360530,-42.867785],[-126.010510,-29.742785],[-122.223380,-19.142625],[-119.757759,-12.277870],[-116.948300,-5.392625],[-109.503100,13.221175],[-106.813811,20.961408],[-106.304082,23.414525],[-106.409579,25.109741],[-107.174263,26.187131],[-108.642097,26.786767],[-113.863060,27.113075],[-116.606878,27.009079],[-118.398791,26.587760],[-119.529776,25.720896],[-120.290810,24.280265],[-123.909030,15.842765],[-127.233130,7.507355],[-127.976171,5.972747],[-128.699527,5.489398],[-129.851691,5.159329],[-134.025198,4.850959],[-141.662200,4.831495],[-155.301060,4.905495],[-159.490780,15.706345],[-163.680520,26.507215],[-170.162570,26.849895],[-173.580483,26.951553],[-175.541455,26.721297],[-176.433497,26.034385],[-176.644620,24.766075]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-132.070970,-8.805285],[-137.068747,-23.146313],[-140.873367,-32.210033],[-142.268985,-34.644218],[-143.295202,-35.616656],[-143.662378,-35.539884],[-143.928315,-35.079873],[-144.144620,-32.986395],[-145.246182,-28.358215],[-147.894620,-20.367785],[-150.543057,-12.539278],[-151.644620,-8.300405],[-151.137876,-7.500888],[-149.447821,-6.982110],[-141.498830,-6.617785],[-136.094895,-6.683587],[-133.129797,-6.975549],[-131.992251,-7.635504],[-132.070970,-8.805285]]);
    }
  }
}
module GU_Slog(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    difference()
    {
       linear_extrude(height=h)
         polygon([[182.959433,34.568843],[179.668270,33.521045],[176.508923,31.900030],[173.193237,29.528098],[169.433063,26.227543],[168.071638,24.705788],[166.841045,22.840465],[164.787167,18.238748],[163.301043,12.741649],[162.412286,6.668430],[162.150512,0.338351],[162.545336,-5.929330],[163.626371,-11.815353],[165.423233,-17.000457],[167.552323,-21.093838],[169.932137,-24.594774],[172.588281,-27.520467],[175.546364,-29.888120],[178.831993,-31.714933],[182.470775,-33.018109],[186.488319,-33.814849],[190.910233,-34.122357],[195.821085,-33.812207],[200.084168,-32.602507],[204.126083,-30.313557],[208.373433,-26.765657],[210.369682,-24.674036],[211.992672,-22.457110],[213.275412,-19.993814],[214.250909,-17.163082],[214.952170,-13.843846],[215.412205,-9.915041],[215.740623,0.255543],[215.657932,8.138118],[215.204205,13.011693],[214.070959,16.502118],[211.949713,20.235243],[208.527039,24.750762],[204.261589,28.669393],[199.296991,31.880174],[193.776873,34.272143],[190.823122,35.213440],[188.687746,35.558768],[186.392574,35.334959],[182.959433,34.568843]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[197.546563,19.581743],[199.393962,17.959367],[200.997395,15.916255],[202.344779,13.490044],[203.424034,10.718368],[204.223078,7.638864],[204.729830,4.289168],[204.932208,0.706916],[204.818133,-3.070257],[203.998129,-9.311521],[203.314161,-11.820674],[202.408568,-13.999395],[201.252112,-15.905598],[199.815558,-17.597199],[195.985213,-20.568257],[193.322191,-21.760902],[190.419707,-22.262765],[187.406921,-22.119040],[184.412994,-21.374920],[181.567085,-20.075598],[178.998355,-18.266268],[176.835964,-15.992123],[175.209073,-13.298357],[174.495301,-11.120556],[174.022638,-8.363109],[173.780873,-1.748320],[174.444244,5.267926],[175.103003,8.527193],[175.973223,11.407543],[177.291241,14.509376],[178.717259,16.792480],[180.437016,18.491991],[182.636253,19.843043],[186.768302,21.433451],[190.629379,21.920055],[194.221470,21.302829],[197.546563,19.581743]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[335.740623,34.280343],[331.779627,32.201498],[327.711795,28.867405],[323.985472,24.709082],[321.049003,20.157543],[319.924198,17.389878],[319.014395,13.942302],[317.895906,5.783193],[317.805755,-2.768241],[318.181376,-6.706223],[318.856162,-10.160457],[320.564414,-15.111390],[322.935028,-19.708410],[325.863096,-23.854797],[329.243713,-27.453832],[332.971971,-30.408795],[336.942965,-32.622966],[341.051787,-33.999627],[345.193532,-34.442057],[349.216307,-34.006826],[353.185975,-32.858009],[357.012363,-31.064531],[360.605297,-28.695320],[363.874603,-25.819300],[366.730105,-22.505399],[369.081630,-18.822543],[370.839002,-14.839657],[372.061265,-9.331082],[372.528127,-2.453157],[372.231302,5.091743],[371.162502,12.601243],[370.176077,16.556849],[368.794024,19.720568],[366.621652,22.783899],[363.264272,26.438343],[360.044826,29.421382],[356.770259,31.829910],[353.436557,33.665071],[350.039710,34.928005],[346.575705,35.619858],[343.040530,35.741770],[339.430173,35.294884],[335.740622,34.280343]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[352.693723,20.740743],[353.938700,19.868479],[355.090483,18.657309],[357.090167,15.370184],[358.644176,11.183232],[359.703913,6.400318],[360.220778,1.325307],[360.146175,-3.737935],[359.431506,-8.485545],[358.028172,-12.613657],[356.910193,-14.605446],[355.584041,-16.348940],[352.427785,-19.085215],[348.800535,-20.810820],[344.943416,-21.514095],[341.097559,-21.183377],[337.504090,-19.807005],[335.877354,-18.723056],[334.404139,-17.373319],[333.114584,-15.756339],[332.038833,-13.870657],[331.271300,-11.692465],[330.616969,-8.786820],[329.925313,-2.310457],[330.079449,3.082224],[330.786764,7.880113],[332.023086,12.044921],[333.764240,15.538355],[335.986053,18.322126],[338.664352,20.357941],[341.774963,21.607511],[345.293712,22.032543],[349.524301,21.653080],[352.693722,20.740743]]);
    }
    linear_extrude(height=h)
      polygon([[-35.110537,32.268443],[-38.918217,29.977390],[-42.062446,26.923493],[-44.747373,22.857396],[-47.177147,17.529743],[-48.855847,12.549087],[-49.979660,7.588229],[-50.549230,2.659150],[-50.565197,-2.226170],[-50.028205,-7.055750],[-48.938895,-11.817612],[-47.297908,-16.499774],[-45.105887,-21.090257],[-43.371696,-23.903433],[-41.405009,-26.419372],[-39.234077,-28.633333],[-36.887153,-30.540571],[-34.392488,-32.136345],[-31.778332,-33.415910],[-29.072939,-34.374524],[-26.304557,-35.007445],[-23.501441,-35.309928],[-20.691839,-35.277231],[-17.904005,-34.904611],[-15.166189,-34.187324],[-12.506643,-33.120629],[-9.953618,-31.699781],[-7.535366,-29.920038],[-5.280138,-27.776657],[-3.403560,-25.469543],[-1.929101,-23.064698],[-0.872915,-20.653350],[-0.251160,-18.326732],[-0.079993,-16.176073],[-0.375571,-14.292604],[-1.154050,-12.767555],[-2.431588,-11.692157],[-3.793258,-11.109487],[-5.107606,-10.856974],[-6.393420,-10.943619],[-7.669489,-11.378420],[-10.267546,-13.328484],[-13.052088,-16.779157],[-14.918096,-19.103985],[-16.899707,-20.904003],[-18.964457,-22.198351],[-21.079880,-23.006170],[-23.213509,-23.346597],[-25.332880,-23.238773],[-27.405527,-22.701839],[-29.398985,-21.754932],[-31.280787,-20.417193],[-33.018469,-18.707762],[-34.579565,-16.645779],[-35.931609,-14.250382],[-37.042136,-11.540712],[-37.878680,-8.535908],[-38.408776,-5.255110],[-38.599958,-1.717457],[-38.248910,4.683257],[-37.129470,10.125930],[-35.204069,14.734585],[-32.435137,18.633243],[-30.436334,20.632063],[-28.560790,21.842680],[-26.418924,22.440454],[-23.621157,22.600743],[-20.844808,22.450779],[-18.788630,21.890705],[-17.086215,20.755251],[-15.371157,18.879143],[-12.880066,15.089855],[-11.076837,11.205543],[-9.793907,8.437223],[-8.088522,6.785155],[-5.835600,6.177932],[-2.910057,6.544143],[-1.762995,6.968808],[-0.892549,7.610598],[-0.295651,8.489825],[0.030768,9.626805],[-0.115566,12.755282],[-1.307007,17.158543],[-3.591476,22.165288],[-6.751076,26.424462],[-10.625524,29.864420],[-15.054535,32.413518],[-19.877826,34.000113],[-24.935112,34.552562],[-30.066111,33.999220],[-32.609164,33.285488],[-35.110537,32.268443]]);
    linear_extrude(height=h)
      polygon([[38.240623,33.797943],[37.754344,32.650549],[37.446784,29.824768],[37.420713,20.026643],[37.414494,10.368355],[37.171405,7.201348],[36.795713,5.766343],[35.547662,5.343680],[32.929461,4.933168],[25.115623,4.336243],[14.490623,3.907543],[13.865623,17.657543],[13.240623,31.407543],[8.240623,31.407543],[3.240623,31.407543],[3.115323,0.467743],[3.150700,-19.133115],[3.399436,-25.134998],[3.915300,-29.123895],[4.783114,-31.489336],[6.087699,-32.620855],[7.913878,-32.907985],[10.346473,-32.740257],[14.490623,-32.342457],[14.634833,-24.842457],[14.947333,-12.608057],[15.115623,-7.873657],[26.678123,-8.233057],[38.240623,-8.592457],[38.360003,-15.467457],[38.672503,-27.726857],[38.865623,-33.111257],[44.178123,-32.726857],[49.490623,-32.342457],[49.872993,-7.967457],[49.983846,11.604626],[49.469749,23.855180],[48.930904,27.727896],[48.178893,30.361841],[47.194741,31.954222],[45.959473,32.702243],[40.755538,33.967130],[39.300139,34.042188],[38.240623,33.797943]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[-223.203418,30.470043],[-230.255828,26.422748],[-232.528767,24.844349],[-234.169855,23.336455],[-235.331837,21.729323],[-236.167456,19.853207],[-237.470587,14.615043],[-238.383536,9.458648],[-238.946071,4.507325],[-239.165106,-0.224340],[-239.047555,-4.721762],[-238.600331,-8.970354],[-237.830350,-12.955531],[-236.744524,-16.662706],[-235.349769,-20.077295],[-233.652997,-23.184710],[-231.661124,-25.970366],[-229.381063,-28.419678],[-226.819727,-30.518059],[-223.984032,-32.250923],[-220.880891,-33.603685],[-217.517218,-34.561758],[-213.899927,-35.110557],[-207.531468,-35.216972],[-201.970573,-34.303105],[-199.490787,-33.461439],[-197.210282,-32.362149],[-195.128188,-31.004384],[-193.243635,-29.387295],[-191.555753,-27.510029],[-190.063672,-25.371736],[-187.663431,-20.308665],[-186.035953,-14.191274],[-185.174278,-7.012757],[-185.005703,-0.437413],[-185.388365,5.427216],[-186.353193,10.652937],[-187.931115,15.311555],[-190.153061,19.474879],[-193.049961,23.214713],[-196.652743,26.602866],[-200.992338,29.711143],[-203.695995,31.208666],[-206.445721,32.306296],[-209.228871,33.003600],[-212.032800,33.300143],[-214.844864,33.195493],[-217.652418,32.689215],[-220.442817,31.780876],[-223.203418,30.470043]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-203.635808,18.015543],[-201.944822,16.199583],[-200.473728,14.131836],[-198.192890,9.389451],[-196.796642,4.085327],[-196.288335,-1.483595],[-196.671320,-7.020374],[-197.948947,-12.228071],[-200.124566,-16.809746],[-201.550169,-18.773030],[-203.201528,-20.468457],[-205.907469,-22.432901],[-208.700609,-23.688068],[-211.528097,-24.243052],[-214.337083,-24.106945],[-217.074715,-23.288839],[-219.688144,-21.797827],[-222.124518,-19.643003],[-224.330987,-16.833457],[-226.037838,-13.923637],[-227.034100,-11.096045],[-227.494468,-7.591259],[-227.593638,-2.649857],[-227.393677,2.506246],[-226.821572,6.943057],[-225.853848,10.701796],[-224.467032,13.823680],[-222.637651,16.349929],[-220.342231,18.321760],[-217.557297,19.780392],[-214.259378,20.767043],[-211.050244,21.214087],[-208.415093,20.957668],[-206.046191,19.918062],[-203.635808,18.015543]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[52.928123,32.454643],[51.864872,31.434979],[51.415039,29.774805],[51.611362,27.927151],[52.486583,26.345043],[54.056888,22.462343],[56.258183,14.794843],[59.550865,3.367329],[64.204944,-11.345270],[68.703550,-24.692587],[71.529813,-32.024257],[72.317775,-32.902923],[73.537848,-33.564301],[76.737405,-34.207607],[80.054641,-33.899013],[81.421812,-33.370516],[82.415713,-32.583357],[83.920173,-29.430770],[85.632833,-24.145857],[91.397553,-4.842457],[99.603806,22.483268],[101.164863,28.908584],[101.381876,30.576086],[101.250643,31.314143],[99.407536,31.810955],[95.727973,32.253543],[90.740623,32.657543],[88.195163,24.771343],[85.956734,18.929368],[84.932833,16.940246],[84.149473,15.957943],[81.129241,15.355590],[76.105696,15.206968],[71.067600,15.486259],[68.003713,16.167643],[66.428937,18.684968],[64.521552,23.576043],[62.630024,28.683193],[61.093403,31.720043],[59.688134,32.661334],[57.629584,33.118143],[55.261623,33.059552],[52.928122,32.454643]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[80.799263,0.470043],[78.358883,-7.967457],[76.776443,-13.592457],[74.696033,-6.525057],[73.164743,-0.969788],[72.868898,0.768578],[72.921210,1.954593],[73.347899,2.693627],[74.175183,3.091049],[77.136413,3.282543],[79.551920,3.202584],[80.801179,2.834943],[81.133767,1.987977],[80.799263,0.470043]]);
    }
    linear_extrude(height=h)
      polygon([[104.281013,31.312043],[103.964399,21.051030],[104.265013,-0.851857],[104.728293,-17.044251],[105.251075,-26.373582],[106.026543,-30.901901],[106.569405,-32.010071],[107.247883,-32.691257],[109.566166,-33.657532],[111.990583,-33.669357],[115.747953,-32.984557],[116.351948,-32.706423],[117.067008,-31.962482],[118.472703,-29.529957],[121.488569,-21.197949],[125.809235,-8.154620],[129.684855,4.181666],[131.365583,10.392543],[131.692656,11.550793],[132.479023,12.032543],[133.279293,10.873604],[134.635145,7.718080],[138.255433,-2.654957],[143.890853,-19.842457],[146.431203,-26.501757],[148.234403,-29.824837],[150.699838,-32.306745],[153.574607,-33.761059],[155.086461,-34.044611],[156.605813,-34.001357],[157.556659,-33.815951],[158.279715,-33.373668],[158.815714,-32.386864],[159.205393,-30.567895],[159.708723,-23.282877],[160.115583,-9.217457],[160.373395,10.567680],[160.115583,23.907543],[159.490583,32.657543],[154.490583,32.657543],[149.490583,32.657543],[149.532683,14.938343],[149.400248,4.564680],[148.933214,-0.946882],[148.570081,-1.899450],[148.118331,-1.660582],[146.942353,2.359343],[146.068413,5.585568],[145.182623,7.657543],[143.522354,11.661430],[140.786383,19.532543],[138.164729,27.050915],[136.148106,31.213468],[135.174696,32.314604],[134.122160,32.910734],[132.913703,33.113175],[131.472533,33.033243],[130.079778,32.678562],[128.801658,31.891091],[127.586837,30.574044],[126.383979,28.630630],[123.808809,22.477551],[120.665463,12.657543],[116.519823,-0.467457],[116.356101,-0.514110],[116.189493,0.080323],[115.866169,2.957930],[115.388953,13.826543],[114.749705,25.868130],[114.244214,29.765529],[113.673403,31.639043],[112.756046,32.388896],[111.525358,32.904466],[108.603965,33.249480],[105.869168,32.707526],[104.871726,32.114385],[104.280913,31.312043]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[219.452343,31.970643],[218.973969,26.931405],[218.962433,16.658143],[219.461473,-10.467457],[219.877623,-28.279957],[220.115623,-32.967457],[237.225773,-32.967457],[246.629503,-32.890577],[252.308866,-32.528070],[255.758020,-31.682130],[258.471123,-30.154957],[261.042560,-27.800751],[263.062324,-24.731629],[264.504243,-21.145996],[265.342146,-17.242257],[265.549864,-13.218818],[265.101224,-9.274085],[263.970057,-5.606463],[262.130193,-2.414357],[260.499088,-0.132371],[259.798553,1.443180],[259.941078,2.767013],[260.839153,4.293843],[261.636674,6.078330],[262.454380,9.004318],[263.766173,16.657943],[264.792829,24.328168],[265.722503,29.078343],[266.021096,30.525612],[265.558761,31.409518],[264.038137,31.942537],[261.161863,32.337143],[256.993104,32.389235],[255.539704,31.922716],[254.420381,31.026855],[253.570203,29.625931],[252.924237,27.644220],[251.985213,21.635543],[250.912991,14.970016],[250.139997,12.688504],[249.103130,10.978755],[247.722929,9.743968],[245.919933,8.887338],[243.614678,8.312064],[240.727703,7.921343],[234.617349,7.497220],[232.732249,7.778445],[231.464138,8.565155],[230.690716,9.989821],[230.289688,12.184910],[230.115623,19.416243],[229.716848,27.792505],[229.245126,30.409307],[228.615623,31.782543],[226.559480,32.843066],[223.755194,33.240055],[221.090305,32.955313],[220.087490,32.551606],[219.452353,31.970643]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[249.615993,-5.174157],[251.190290,-6.784935],[252.549956,-9.175132],[253.505049,-11.923116],[253.865623,-14.607257],[253.721025,-16.254707],[253.249775,-17.604799],[252.395688,-18.683999],[251.102581,-19.518770],[249.314269,-20.135576],[246.974569,-20.560884],[240.416263,-20.942857],[230.740623,-21.092457],[230.357123,-14.366457],[230.219733,-8.604695],[230.518403,-6.805641],[231.197934,-5.581407],[232.360286,-4.822191],[234.107424,-4.418195],[239.763903,-4.236657],[246.154601,-4.519745],[249.616003,-5.174157]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[269.695813,32.345043],[269.345678,29.078334],[269.180339,21.689834],[269.311136,0.088768],[269.902386,-21.375535],[270.312614,-28.593082],[270.768273,-31.620457],[272.669838,-32.229032],[276.567965,-32.670224],[287.817418,-33.043970],[299.443670,-32.728709],[303.812797,-32.308643],[306.373763,-31.711457],[309.606630,-29.503563],[312.573911,-26.260407],[314.950199,-22.413726],[316.410083,-18.395257],[316.686025,-16.301351],[316.665513,-13.938118],[315.847034,-8.849845],[314.178469,-4.022777],[313.095350,-1.986053],[311.883643,-0.349257],[310.752303,1.016470],[310.365030,2.018080],[310.715364,3.002948],[311.796843,4.318443],[312.734755,5.798462],[313.377588,7.894343],[313.747233,10.712324],[313.865583,14.358643],[314.404370,21.124543],[314.987576,24.186305],[315.699743,26.502643],[316.688772,29.602759],[316.644099,30.619943],[316.182656,31.329418],[315.261462,31.766840],[313.837531,31.967865],[309.309533,31.803343],[304.490573,31.407543],[302.998573,22.394543],[301.525056,14.742034],[300.728084,12.283300],[299.742819,10.547643],[298.458148,9.393611],[296.762960,8.679752],[291.696583,8.006743],[285.511629,7.808362],[283.588247,8.161817],[282.295244,8.976293],[281.520857,10.371231],[281.153323,12.466074],[281.191763,19.233243],[281.285810,24.210841],[281.076991,27.573605],[280.503191,29.762188],[279.502293,31.217243],[277.236103,32.517393],[274.208060,33.212143],[271.375501,33.191393],[270.331695,32.878299],[269.695763,32.345043]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[302.005223,-6.733657],[302.866990,-8.002000],[303.528438,-9.606190],[304.218470,-13.336770],[304.011505,-16.954718],[303.551708,-18.418119],[302.843733,-19.489357],[301.535113,-20.066915],[299.041305,-20.540195],[291.697903,-21.010157],[281.990623,-21.092157],[281.609873,-13.708157],[281.606480,-8.489884],[282.010380,-6.820188],[282.818796,-5.655795],[284.132316,-4.905959],[286.051529,-4.479937],[292.109383,-4.236357],[295.958695,-4.338584],[298.651454,-4.728295],[300.547137,-5.496287],[302.005223,-6.733357]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[-335.821877,31.047743],[-337.025363,30.743149],[-337.869035,30.183310],[-338.347477,29.252041],[-338.455271,27.833155],[-337.537245,23.067795],[-335.071617,14.957743],[-322.083034,-24.639795],[-319.377447,-31.852480],[-317.947217,-34.269057],[-316.983400,-34.769205],[-315.578526,-35.119045],[-312.199937,-35.240257],[-309.841975,-34.812860],[-308.989330,-34.343502],[-308.258115,-33.571282],[-306.871592,-30.720991],[-305.105637,-25.467457],[-299.094709,-5.742895],[-293.386637,14.532543],[-291.283725,21.502455],[-289.754697,25.095043],[-289.515720,25.081377],[-289.299002,24.534887],[-288.943995,21.979393],[-288.629297,11.970043],[-288.386874,-2.827132],[-287.810137,-18.304857],[-287.291259,-27.309052],[-286.703255,-32.161070],[-286.285311,-33.467065],[-285.732462,-34.259480],[-284.065217,-35.002857],[-281.869538,-35.422111],[-279.954565,-35.445048],[-278.231411,-35.000758],[-276.611189,-34.018332],[-275.005010,-32.426859],[-273.323989,-30.155429],[-269.381867,-23.289057],[-258.510667,-3.029557],[-253.712937,4.949443],[-253.503229,4.768388],[-253.305031,3.844918],[-252.961245,0.067393],[-252.610697,-13.133357],[-252.503920,-23.240507],[-252.180340,-29.251757],[-251.507061,-32.386157],[-250.351187,-33.862757],[-248.206382,-35.011124],[-246.079881,-35.401645],[-244.168974,-35.033221],[-242.670947,-33.904757],[-242.168475,-31.217582],[-241.900077,-24.782657],[-242.076877,-1.294157],[-242.512819,16.572477],[-243.030536,25.945943],[-243.420833,28.372634],[-243.952501,29.785909],[-244.665850,30.555725],[-245.601187,31.052043],[-247.535207,31.760487],[-249.297922,32.005829],[-250.941422,31.752456],[-252.517792,30.964755],[-254.079122,29.607116],[-255.677497,27.643926],[-259.193737,21.758443],[-266.089397,9.532743],[-268.589715,5.191380],[-271.663167,-0.857957],[-274.240416,-5.870932],[-275.547787,-7.720557],[-276.071999,-2.116907],[-276.766317,10.789643],[-277.490025,23.725580],[-278.084897,29.399943],[-281.626510,29.905124],[-288.696722,30.144018],[-295.837217,30.075224],[-299.589677,29.657343],[-300.888145,27.961030],[-302.437247,24.935343],[-304.003371,22.343743],[-304.749070,21.721809],[-305.342747,21.691043],[-305.904482,21.766630],[-305.591747,20.916043],[-305.211900,19.229505],[-305.602947,17.285343],[-306.651217,14.220243],[-307.002861,13.558143],[-307.696677,13.282743],[-315.995067,13.282743],[-323.355947,13.282743],[-324.200327,17.783643],[-325.438234,22.471948],[-327.170930,26.605205],[-329.119930,29.641157],[-330.088517,30.578187],[-331.006747,31.037543],[-333.247135,31.225955],[-335.821677,31.047543]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-308.924517,0.177643],[-309.243116,-1.079645],[-310.479317,-3.718957],[-311.816149,-7.082570],[-312.376677,-10.081157],[-312.782522,-12.903477],[-313.232823,-13.397402],[-313.804974,-13.305970],[-315.185613,-11.445430],[-316.666017,-7.478657],[-318.177267,-1.937705],[-318.459254,-0.243158],[-318.385951,0.861705],[-317.927711,1.472586],[-317.054884,1.685185],[-313.946877,1.298343],[-308.924517,0.177643]]);
    }
    linear_extrude(height=h)
      polygon([[-126.466817,31.283443],[-126.823090,29.913587],[-127.114845,26.862118],[-127.384377,17.520643],[-127.483469,10.730705],[-127.874902,6.164518],[-128.699919,2.914543],[-130.099757,0.073243],[-131.595047,-2.317088],[-132.621371,-3.423607],[-133.450639,-3.405876],[-134.354757,-2.423457],[-135.089784,-1.616631],[-135.745621,-1.250198],[-136.289609,-1.271763],[-136.689091,-1.628932],[-136.923907,-3.140504],[-136.188807,-5.365757],[-135.521365,-7.395207],[-135.666529,-8.098298],[-136.131007,-8.590357],[-137.016160,-9.812482],[-137.384337,-11.662957],[-138.485900,-15.506095],[-141.134337,-21.519057],[-143.782775,-27.633120],[-144.884337,-31.719257],[-144.714574,-33.104940],[-143.988926,-33.851145],[-142.382859,-34.095805],[-139.571837,-33.976857],[-134.259337,-33.592457],[-128.009337,-20.782357],[-123.332384,-11.734457],[-121.705047,-8.981529],[-120.864397,-7.969857],[-118.601289,-10.814370],[-114.416897,-17.654957],[-109.337604,-26.315965],[-106.043497,-30.883145],[-104.676447,-32.040255],[-103.288364,-32.664355],[-99.825987,-32.967457],[-96.157641,-32.553332],[-95.207400,-32.049541],[-94.884337,-31.360257],[-97.821837,-25.294357],[-104.884337,-12.967457],[-114.884337,3.818043],[-114.903437,15.737743],[-115.187375,24.581393],[-115.843807,29.105343],[-116.570645,29.758267],[-117.798532,30.369957],[-121.098802,31.334580],[-124.427310,31.729110],[-125.690494,31.628183],[-126.466747,31.283443]]);
    linear_extrude(height=h)
      polygon([[-355.553087,29.461743],[-355.838303,26.911523],[-356.011465,20.944180],[-355.967267,2.320443],[-355.565177,-23.500257],[-358.662277,-23.628057],[-367.143757,-23.986757],[-372.528127,-24.217457],[-372.143747,-29.529957],[-371.759377,-34.842457],[-351.759377,-35.467457],[-337.882803,-35.741770],[-333.367438,-35.609263],[-330.171172,-35.240057],[-328.071870,-34.591457],[-326.847394,-33.620770],[-326.275609,-32.285301],[-326.134377,-30.542357],[-326.272607,-28.916174],[-326.708019,-27.563938],[-327.471702,-26.468043],[-328.594741,-25.610882],[-330.108225,-24.974849],[-332.043239,-24.542338],[-337.302208,-24.217457],[-343.634377,-24.217457],[-343.634377,2.511743],[-343.679307,17.948466],[-343.988565,25.969705],[-344.324099,27.998652],[-344.823854,29.132688],[-345.520543,29.691467],[-346.446877,29.994643],[-349.563379,30.604926],[-352.279565,30.710205],[-354.355959,30.324479],[-355.553087,29.461743]]);
  }
}
module GU_Back(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    difference()
    {
       linear_extrude(height=h)
         polygon([[348.500469,247.707468],[345.179019,239.400333],[344.174664,236.048890],[343.812969,233.838948],[343.839469,230.232878],[341.339469,233.411118],[339.573844,235.988114],[338.839469,237.720828],[338.534476,238.652727],[337.684736,239.811815],[334.742447,242.505880],[330.795469,245.191677],[326.626669,247.257858],[323.953761,248.058558],[320.621904,248.714264],[313.680539,249.320028],[306.251427,248.745857],[297.925909,247.311394],[290.737062,245.448713],[288.204225,244.491814],[286.717959,243.589888],[285.686265,241.733754],[285.464982,239.495319],[285.998300,237.611704],[286.530494,237.033303],[287.230409,236.820028],[287.924316,236.490929],[288.428243,235.517752],[288.839409,231.723878],[289.007685,229.118026],[289.574602,226.978594],[290.633298,225.073869],[292.276909,223.172138],[294.070552,221.114794],[295.108837,219.029830],[295.584055,216.306327],[295.688499,212.333368],[295.595196,208.431366],[295.248533,206.198409],[294.496853,205.186492],[293.188499,204.947608],[292.123389,204.811651],[291.419259,204.403300],[291.073052,203.719583],[291.081709,202.757528],[291.066656,201.693793],[290.514799,201.007413],[289.308898,200.627250],[287.331709,200.482168],[283.542033,200.153368],[280.634104,199.082978],[277.902913,196.859147],[274.643449,193.070028],[271.547214,188.924457],[268.822184,184.756792],[266.530726,180.713593],[264.735207,176.941420],[263.497995,173.586833],[262.881456,170.796392],[262.947959,168.716657],[263.759869,167.494188],[264.602961,166.164354],[264.986339,163.982918],[265.140539,160.331424],[265.571494,157.875784],[266.502280,155.888041],[268.155969,153.640238],[269.806684,151.729882],[271.107036,150.840813],[272.485584,150.828891],[274.370889,151.549978],[277.615542,152.713280],[280.823783,153.169644],[284.098724,152.875703],[287.543474,151.788093],[291.261146,149.863449],[295.354851,147.058407],[299.927698,143.329601],[305.082799,138.633668],[310.082733,134.108522],[314.551468,130.504938],[318.425782,127.870188],[321.642449,126.251548],[326.099335,124.913792],[329.176356,124.785720],[330.160350,125.167913],[330.754900,125.843642],[330.945179,126.809948],[330.716359,128.063868],[330.415833,129.924898],[330.631483,130.342485],[331.077497,130.420345],[332.619882,129.563569],[334.961519,127.367928],[338.189308,124.403825],[341.841463,121.923960],[346.024416,119.899669],[350.844597,118.302289],[356.408438,117.103158],[362.822369,116.273612],[370.192823,115.784990],[378.626229,115.608628],[390.288049,115.570028],[389.461649,119.332608],[388.331382,123.085645],[386.774439,126.825288],[385.616657,130.058962],[385.365717,133.013527],[385.994553,135.312694],[386.630429,136.098914],[387.476099,136.580178],[388.215125,136.717333],[388.620533,136.524537],[388.452819,135.115588],[388.254114,133.670928],[388.470459,133.231455],[388.878639,133.070048],[389.348757,132.823466],[389.733744,132.152079],[390.089409,129.945048],[390.517796,127.738017],[390.981502,127.066630],[391.547749,126.820048],[392.350382,126.592743],[392.232269,126.046238],[392.080736,125.596858],[392.240176,124.945320],[393.345819,123.385058],[394.498823,121.583170],[394.620599,119.901328],[394.573353,119.108974],[394.897566,118.131685],[396.423709,116.118758],[397.775415,114.948798],[398.497562,114.587768],[398.786707,115.056620],[398.839409,116.376308],[398.501533,118.451027],[397.689199,120.007548],[395.700312,124.150905],[392.533699,132.445048],[390.535866,138.603332],[389.127109,144.454500],[388.142222,150.843340],[387.415999,158.614638],[386.919548,169.803022],[387.061581,173.163032],[387.462799,174.693438],[388.525215,175.339218],[390.181176,175.858398],[394.548129,176.470120],[399.112453,176.434927],[401.015126,176.145461],[402.422939,175.659138],[403.759885,175.087030],[404.995173,174.867157],[406.161977,174.998289],[407.293469,175.479198],[408.549492,176.458210],[408.388350,176.693703],[407.708169,176.782038],[406.973200,176.920324],[406.801346,177.339329],[408.203569,179.308068],[409.353431,181.239599],[410.193498,184.510725],[410.839989,189.789898],[411.409119,197.745568],[411.942494,209.152880],[411.885289,214.181818],[408.882977,215.409528],[402.959539,216.830715],[395.737506,218.111837],[388.839409,218.919348],[383.479608,219.177283],[379.266422,218.849337],[374.841754,217.703843],[368.847509,215.509138],[362.140050,212.638768],[357.181898,209.666653],[353.018361,205.886045],[348.694749,200.590198],[346.885363,198.321817],[345.610691,197.246108],[344.524795,197.198438],[343.281739,198.014178],[342.465142,198.928040],[341.894276,200.056805],[341.610691,201.285827],[341.655939,202.500458],[341.776763,203.798133],[341.507477,204.636744],[340.790677,205.091582],[339.568959,205.237938],[336.254287,205.369952],[334.810256,205.720369],[334.762265,206.002287],[335.148976,206.368575],[337.182559,207.393958],[340.599462,209.550672],[343.242259,212.312118],[344.404219,213.934123],[345.289631,214.647367],[346.132369,214.532886],[347.166309,213.671718],[348.213088,211.977187],[348.338969,211.150147],[348.156519,210.476388],[348.130265,210.046770],[348.805089,210.098715],[351.595863,211.304758],[355.204623,213.409443],[358.307149,215.727698],[360.144919,216.939232],[363.232118,218.489503],[371.432149,221.808198],[377.463413,224.006548],[380.557223,225.557667],[381.290607,226.308073],[381.635257,227.157743],[381.619189,229.502968],[380.704668,233.798762],[378.824904,238.590883],[376.277228,243.244958],[373.358969,247.126618],[369.356824,250.590662],[364.035433,254.156815],[358.872793,256.931212],[356.812878,257.742169],[355.346899,258.019988],[354.117856,257.365474],[352.575007,255.440442],[350.706497,252.227058],[348.500469,247.707488]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[329.355299,206.816888],[331.095412,206.356880],[331.381534,206.179293],[331.249686,206.024595],[326.112349,205.453868],[322.239125,205.225424],[320.352471,205.340167],[320.031297,205.565595],[320.059395,205.924054],[320.966909,207.103048],[322.726628,208.393627],[323.556008,208.604480],[324.209859,208.466078],[326.251936,207.653693],[329.355299,206.816888]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[319.003889,196.838868],[319.995860,194.770677],[320.462478,193.185148],[320.422732,191.957136],[319.895609,190.961498],[319.469963,190.151136],[319.988282,189.694335],[324.618469,189.626048],[328.139550,189.742459],[329.994496,189.376430],[330.485358,188.900669],[330.785515,188.170098],[331.114819,185.765598],[331.141313,183.853999],[330.858428,182.088052],[330.285749,180.543532],[329.442859,179.296218],[328.437471,177.811442],[327.937467,175.873520],[327.891074,173.029355],[328.246519,168.825848],[328.682346,164.146921],[328.564367,161.536938],[328.231448,160.743458],[327.680574,160.150002],[325.818959,159.140218],[323.887214,158.448987],[322.263106,158.612813],[320.357300,159.868728],[317.580459,162.453768],[314.783712,165.067180],[312.911593,166.302397],[311.352388,166.396374],[309.494379,165.586068],[307.232222,164.641877],[306.376529,164.594025],[305.646608,164.866504],[304.390633,166.484955],[303.117389,169.722238],[302.207357,171.750355],[300.913382,173.266848],[298.998238,174.472983],[296.224699,175.570028],[292.511905,176.943956],[289.833881,178.235023],[288.186769,179.489155],[287.566708,180.752278],[287.969840,182.070315],[289.392306,183.489192],[291.830245,185.054835],[295.279799,186.813168],[302.970169,190.450138],[299.622419,191.975478],[297.375046,193.450902],[296.903178,194.161812],[296.851573,194.800558],[297.209520,195.326417],[297.966308,195.698668],[300.633559,195.819458],[302.269714,195.771413],[303.432363,196.077708],[304.210470,196.784795],[304.692999,197.939128],[305.244807,199.110519],[306.247629,199.967125],[307.776127,200.551448],[309.904959,200.905988],[313.700718,201.210667],[315.937242,200.878082],[317.432357,199.542669],[319.003889,196.838868]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[348.270969,184.273088],[351.652817,183.119194],[357.833859,181.963118],[364.849029,180.492369],[370.236339,178.581978],[374.464409,176.358478],[370.263649,175.468858],[366.717566,174.261254],[364.090809,172.607138],[363.132217,171.407782],[363.034606,170.196748],[363.923996,168.513356],[365.926409,165.896928],[369.203809,161.376186],[370.691078,158.082924],[370.779876,156.822112],[370.440895,155.778786],[369.680721,154.923153],[368.505939,154.225418],[366.833842,153.661939],[365.136028,153.566733],[363.179935,153.958689],[360.732999,154.856698],[357.460197,156.044705],[356.367767,156.207887],[355.570333,156.050842],[355.017157,155.548808],[354.657500,154.677028],[354.315789,151.725188],[353.791849,148.719492],[352.627543,146.379373],[350.938265,144.860871],[348.839409,144.320028],[346.807529,144.789892],[345.179694,146.258239],[343.892045,148.813203],[342.880719,152.542918],[342.178672,155.064768],[341.139814,156.960437],[339.559742,158.497873],[337.234049,159.945028],[333.957552,162.156859],[332.960059,163.176963],[332.592789,163.964028],[333.701507,166.301947],[336.370809,169.789818],[338.420855,172.293419],[339.404127,174.257879],[339.513727,176.410711],[338.942759,179.479428],[338.356066,183.726144],[338.488439,185.220855],[338.910468,186.305535],[339.626534,186.986987],[340.641019,187.272010],[341.958303,187.167407],[343.582769,186.679978],[346.321058,185.455454],[348.270969,184.273088]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[383.839409,171.041978],[383.762390,170.088280],[383.477774,169.705205],[381.964409,170.570028],[380.089409,172.598078],[380.640191,172.931392],[381.964409,173.070028],[382.692437,172.910001],[383.288628,172.474285],[383.691460,171.829428],[383.839409,171.041978]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[324.861579,142.695368],[326.442551,137.772460],[326.675202,136.428347],[326.465779,136.116928],[324.802947,138.373694],[322.685128,142.574682],[320.863542,147.062909],[320.089409,150.181398],[320.418180,151.543432],[320.817701,151.386152],[321.363811,150.685959],[322.865284,147.704698],[324.861579,142.695368]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[143.185879,248.411908],[141.518349,241.277655],[141.084274,235.384174],[141.332769,232.816496],[141.893212,230.455539],[142.766797,228.266814],[143.954719,226.215828],[146.933369,222.845539],[148.503370,221.648450],[149.868429,221.004718],[151.671032,220.249178],[151.847846,219.825559],[151.528413,219.360012],[149.361047,218.269048],[145.089409,216.908118],[139.325285,215.139745],[134.445207,213.309412],[130.291393,211.299799],[126.706059,208.993585],[123.531421,206.273451],[120.609696,203.022077],[117.783100,199.122142],[114.893849,194.456328],[111.289780,187.694141],[110.435463,185.303322],[110.222824,183.424705],[110.659266,181.947303],[111.752188,180.760131],[113.508993,179.752201],[115.937079,178.812528],[121.929328,177.399789],[128.124579,176.801198],[133.508052,176.346247],[138.758572,175.204859],[142.864408,173.666783],[144.171904,172.839534],[144.813829,172.021768],[144.634667,170.994863],[143.823868,169.167809],[140.830199,164.146838],[138.614212,160.589073],[136.879549,157.117860],[135.595906,153.547576],[134.732982,149.692602],[134.260473,145.367314],[134.148076,140.386094],[134.882409,127.713368],[136.341209,105.882528],[136.476557,102.485485],[136.760420,101.507616],[137.289347,100.958264],[138.139040,100.798488],[139.385203,100.989350],[143.369749,102.267228],[148.627227,103.728338],[154.464409,104.857918],[160.369631,105.886046],[165.699718,107.206816],[170.481951,108.834613],[174.743608,110.783822],[178.511969,113.068825],[181.814314,115.704008],[184.677921,118.703754],[187.130069,122.082448],[189.016333,124.971903],[190.137971,126.208084],[190.523473,126.267916],[190.851520,125.988494],[191.513519,124.510638],[192.247434,122.992543],[193.327038,122.250158],[195.234835,122.146900],[198.453329,122.546188],[204.344030,123.934295],[210.548467,126.241293],[216.342117,129.152101],[221.000459,132.351638],[222.626975,134.066441],[224.063314,136.239309],[225.266817,138.722927],[226.194819,141.369983],[226.804661,144.033161],[227.053679,146.565149],[226.899213,148.818633],[226.298599,150.646298],[225.698786,152.485040],[225.872863,152.937577],[226.305308,153.080164],[227.772438,152.439304],[229.754449,150.570098],[231.528525,148.855213],[232.900708,148.149254],[233.353900,148.188761],[233.607992,148.497467],[233.387369,149.945098],[233.225783,150.813525],[233.554241,151.394117],[234.414870,151.718949],[235.849799,151.820098],[237.399660,152.092239],[239.164772,152.850295],[240.981338,154.006718],[242.685559,155.473958],[246.339409,159.127788],[246.339409,177.973958],[246.339409,196.820108],[250.810559,196.820108],[253.306562,197.072038],[255.574911,197.803294],[257.583196,198.977076],[259.299012,200.556582],[260.689949,202.505010],[261.723599,204.785559],[262.367556,207.361429],[262.589409,210.195818],[262.151171,215.081770],[261.523811,217.062023],[260.553568,218.837428],[259.187402,220.485709],[257.372271,222.084593],[252.182949,225.445068],[246.852663,228.838309],[243.353629,231.666268],[240.733091,233.822555],[237.514929,235.600948],[235.142131,236.991467],[234.576431,237.667062],[234.554069,238.215178],[234.624355,238.644201],[234.310911,238.995534],[232.767349,239.320108],[230.884953,239.734807],[229.827159,240.731858],[228.473217,241.421704],[225.071254,242.204873],[213.602159,243.773888],[200.951547,245.335663],[192.659499,246.801228],[186.350542,247.725265],[178.467829,247.985088],[170.046085,248.090564],[162.995979,248.868114],[157.092534,250.357101],[152.110769,252.596888],[146.115609,255.555038],[145.621836,254.996369],[144.904867,253.463250],[143.185879,248.411978]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[175.522019,221.166668],[180.313350,219.553553],[184.597913,217.657700],[188.474572,215.393840],[192.042191,212.676704],[195.399631,209.421024],[198.645757,205.541530],[201.879432,200.952954],[205.199519,195.570028],[208.760368,189.910443],[211.676719,185.957618],[212.719301,184.420294],[213.741413,182.258113],[215.254639,177.207618],[217.031559,169.117668],[217.137175,168.104462],[216.689354,167.319043],[215.627306,166.705066],[213.890239,166.206188],[211.130971,165.246665],[208.989399,163.797090],[207.494144,161.985625],[206.673829,159.940433],[206.557076,157.789676],[207.172507,155.661518],[208.548744,153.684121],[210.714409,151.985648],[212.545368,150.730375],[213.921789,149.414787],[214.788271,148.103764],[215.089409,146.862188],[214.764772,145.136112],[214.279221,144.676363],[213.507291,144.480524],[210.891614,144.865728],[206.492389,146.262028],[202.556381,147.501737],[200.777349,147.806338],[196.265317,139.802094],[194.532314,136.021123],[193.839409,133.784938],[193.472222,132.397220],[192.589409,131.820028],[192.104058,132.063140],[191.706597,132.725078],[191.339409,134.901048],[191.156412,136.227042],[190.649352,137.474554],[189.881131,138.529993],[188.914649,139.279768],[187.847162,140.134027],[187.013009,141.414530],[186.426552,143.091375],[186.102149,145.134658],[185.784176,147.064304],[185.209299,148.790057],[184.439745,150.168249],[183.537739,151.055218],[182.285826,151.571915],[181.018726,151.386658],[179.483457,150.393020],[177.427039,148.484578],[173.493019,144.550568],[176.305409,140.000028],[177.835500,137.395724],[178.413137,135.745778],[178.088025,134.475392],[176.909869,133.009768],[175.811533,132.062457],[174.453186,131.286697],[173.007510,130.762537],[171.647189,130.570028],[170.148527,130.288235],[168.445614,129.499193],[166.684741,128.287406],[165.012199,126.737378],[163.071163,124.873884],[161.324886,123.761272],[159.500010,123.277338],[157.323179,123.299878],[154.970966,123.625795],[154.256923,123.919593],[153.794702,124.395360],[153.457069,126.177032],[153.620749,129.539268],[153.717140,132.759402],[153.314556,134.991934],[152.191171,136.828355],[150.125159,138.860158],[148.527211,140.503477],[147.397190,142.147994],[146.734354,143.762926],[146.537958,145.317493],[146.807259,146.780914],[147.541514,148.122409],[148.739978,149.311197],[150.401909,150.316498],[152.748985,151.998140],[153.399239,152.985922],[153.698028,154.048364],[153.643396,155.167981],[153.233387,156.327287],[151.339409,158.695028],[149.578370,160.562702],[148.948513,161.935044],[149.058330,162.425801],[149.451605,162.781128],[151.089409,163.070028],[153.076744,163.468300],[154.695229,164.425848],[155.768454,165.218350],[156.942374,165.600036],[158.165431,165.594246],[159.386067,165.224319],[160.552722,164.513594],[161.613839,163.485411],[162.517857,162.163109],[163.213219,160.570028],[164.123621,158.292362],[165.186608,156.910720],[166.711405,156.171697],[169.007239,155.821888],[171.125254,155.792290],[172.876371,156.126094],[174.355997,156.854670],[175.659539,158.009388],[176.845419,159.016060],[178.335468,159.828883],[179.955955,160.372118],[181.533149,160.570028],[183.515385,160.696790],[184.579342,161.376810],[185.009267,163.059689],[185.089409,166.195028],[185.089409,171.820028],[190.015629,171.820028],[193.737188,171.427808],[195.057948,171.003252],[195.767069,170.484818],[196.250120,170.035730],[196.955318,169.800015],[198.653349,170.028578],[205.089409,171.724248],[207.526712,172.284852],[208.789487,173.096675],[209.201495,174.609018],[209.086499,177.271178],[208.412329,181.595020],[207.322149,185.348218],[206.402266,187.987297],[206.137559,189.632528],[205.762081,190.294639],[204.575919,190.570028],[203.682656,191.000798],[202.554132,192.173688],[200.169629,196.029298],[197.153878,200.936193],[192.874732,206.285245],[188.101909,211.203396],[183.605129,214.817588],[179.173665,216.962301],[173.298547,218.796443],[166.854040,220.097522],[160.714409,220.643048],[156.397008,220.960319],[156.111074,221.309516],[156.964409,221.820028],[160.534692,222.722139],[165.084011,222.904574],[170.212931,222.381396],[175.522019,221.166668]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[219.605469,104.509488],[213.233991,95.368968],[209.479779,88.924638],[208.300937,85.295774],[207.731732,81.620618],[207.746321,78.001765],[208.318862,74.541810],[209.423512,71.343350],[211.034428,68.508979],[213.125768,66.141293],[215.671689,64.342888],[218.118872,62.742217],[218.580443,62.102190],[218.521794,61.549545],[217.933771,61.069664],[216.807219,60.647929],[212.901909,59.920428],[206.625610,58.827398],[201.678952,57.232964],[197.086395,54.716744],[191.872399,50.858358],[188.341919,47.797066],[185.423237,44.715117],[183.027796,41.507705],[181.067039,38.070028],[178.622728,33.765340],[177.844220,32.884481],[177.616843,32.833700],[177.516799,33.070028],[177.363297,33.471457],[177.058376,33.178334],[176.170899,30.805228],[175.742883,28.441917],[175.616559,25.418589],[176.266899,17.680228],[177.574502,9.587525],[178.806051,4.558347],[179.450044,3.026310],[180.143111,2.060634],[180.907947,1.594808],[181.767249,1.562328],[183.230727,1.438447],[183.675922,1.102474],[183.839429,0.624828],[184.306403,0.115375],[185.579484,-0.304337],[189.776929,-0.703012],[196.907791,-1.237995],[205.714429,-2.491972],[214.559248,-3.351367],[225.005068,-3.393037],[234.868069,-2.688285],[238.898568,-2.078282],[241.964429,-1.308412],[247.311677,0.860840],[252.427422,3.508105],[256.374363,6.092322],[257.616626,7.191705],[258.215199,8.072428],[258.247250,9.235850],[257.887191,10.946171],[256.368114,15.141018],[254.412711,18.923995],[253.507242,20.119478],[252.775719,20.562128],[251.584812,19.470613],[249.860819,16.856988],[248.747927,15.262967],[247.431069,13.963309],[245.983805,12.980717],[244.479694,12.337892],[242.992297,12.057533],[241.595174,12.162342],[240.361885,12.675020],[239.365989,13.618268],[238.761363,14.828499],[238.407129,16.405498],[238.504449,20.240028],[238.668424,22.105698],[238.509566,23.710490],[238.024089,25.058139],[237.208203,26.152383],[236.058121,26.996957],[234.570053,27.595598],[230.564809,28.070028],[227.575808,28.530481],[225.027924,29.757949],[223.254641,31.521594],[222.762687,32.532346],[222.589439,33.590578],[223.244875,35.405341],[224.984037,37.260259],[227.466205,38.875261],[230.350659,39.970278],[233.280603,41.042716],[234.293898,41.821151],[235.062192,42.863048],[236.032134,46.043182],[236.527139,51.195028],[236.964439,58.695028],[230.401939,59.808328],[225.836502,60.916100],[224.553982,61.479829],[223.971879,61.981818],[224.115409,62.370842],[225.009786,62.595676],[229.151939,62.347868],[235.296302,61.215112],[240.291859,59.619688],[244.682699,57.336783],[249.012909,54.141588],[253.503480,50.875569],[255.348784,49.978603],[256.992178,49.565123],[258.482223,49.629723],[259.867479,50.166997],[261.196504,51.171537],[262.517859,52.637938],[263.926171,54.543364],[264.444994,55.824988],[264.109470,56.942849],[262.954739,58.356988],[260.400407,60.655114],[257.310589,62.808588],[255.716594,64.018306],[254.608072,65.422276],[253.980559,66.940302],[253.829594,68.492190],[254.150713,69.997747],[254.939452,71.376776],[256.191349,72.549085],[257.901939,73.434478],[259.446859,74.566790],[260.089439,76.155808],[260.218612,77.049886],[260.600421,77.643083],[261.226302,77.936741],[262.087693,77.932204],[264.482749,77.033919],[267.717079,74.958978],[277.175269,68.466978],[280.065219,66.438927],[281.678071,64.608629],[282.445772,62.208483],[282.800269,58.470888],[282.669617,53.091479],[282.260618,51.072178],[281.651939,49.723968],[280.548422,46.819845],[280.089439,42.831118],[279.995292,40.242760],[279.549057,38.811073],[278.505046,38.199136],[276.617569,38.070028],[273.348842,38.642082],[270.365369,40.017438],[268.298963,41.079513],[266.623356,41.198217],[265.499765,40.411991],[265.089409,38.759278],[265.432336,37.732724],[266.366047,36.167144],[269.435409,32.270558],[272.227763,28.509952],[273.604042,25.162580],[273.740103,23.742793],[273.496884,22.545037],[272.865967,21.608887],[271.838929,20.973918],[268.781946,20.807995],[264.241349,21.487068],[258.644219,22.767868],[259.458319,19.524268],[261.047261,15.457731],[263.670457,11.318516],[267.099445,7.296141],[271.105761,3.580124],[275.460939,0.359985],[279.936516,-2.174756],[284.304027,-3.834582],[288.335009,-4.429972],[289.739327,-4.315120],[290.814876,-3.941287],[291.572561,-3.264562],[292.023287,-2.241032],[292.047481,1.022087],[290.974699,6.199368],[289.170709,13.282448],[295.813569,6.722088],[299.612590,3.139813],[302.498638,1.093419],[305.431365,0.077932],[309.370419,-0.411622],[313.322476,-0.631640],[315.923788,-0.270528],[318.077535,0.977321],[320.686899,3.417518],[322.648310,5.596462],[324.020171,7.633888],[324.826023,9.572778],[325.089409,11.456118],[325.654097,14.352065],[326.904432,17.435253],[328.174817,19.378463],[328.609531,19.507821],[328.799659,18.854478],[328.977717,18.512334],[329.414167,18.528459],[330.714409,19.342519],[332.004714,20.710650],[332.589409,22.046848],[332.165488,22.611680],[331.146269,22.325668],[330.335187,22.053785],[330.525339,22.764088],[330.884354,24.314827],[330.569661,26.039288],[329.811765,27.296657],[329.338648,27.549927],[328.841169,27.446118],[328.457717,27.430714],[328.142746,27.839369],[327.848519,29.640798],[326.370249,49.320028],[324.840237,62.148096],[323.825193,66.919045],[322.547094,70.832857],[320.933669,74.068221],[318.912644,76.803830],[316.411748,79.218372],[313.358709,81.490538],[307.596852,84.757964],[302.170739,86.932768],[299.639850,87.828391],[296.717455,89.231209],[290.080703,93.296522],[283.025592,98.604897],[276.317229,104.632528],[272.963125,107.779768],[270.406327,109.574172],[267.939562,110.382129],[264.855559,110.570028],[260.128874,109.971545],[258.032724,109.317877],[256.457229,108.511868],[254.817568,107.436992],[253.790066,107.078700],[253.073582,107.436992],[252.366979,108.511868],[251.112788,109.959819],[249.714799,110.550888],[248.938859,110.297512],[249.836049,109.503048],[250.556812,108.926607],[250.761394,108.369428],[250.440174,107.733026],[249.583529,106.918918],[248.647586,106.315391],[247.605335,106.007632],[246.408263,106.011651],[245.007856,106.343458],[241.402978,108.054476],[236.402589,111.268768],[231.647332,114.306535],[228.995209,115.570028],[227.897140,114.697282],[225.760756,112.320995],[219.605449,104.509488]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[178.443299,12.835658],[177.938552,12.293253],[177.688099,13.590868],[177.840237,15.061075],[178.059172,15.335672],[178.344619,15.231488],[178.685118,14.216187],[178.443219,12.835658]]);
    }
    linear_extrude(height=h)
      polygon([[220.089409,-46.929972],[219.132378,-47.785746],[219.127007,-48.046072],[219.464409,-48.141682],[220.898003,-47.785746],[222.589409,-46.929972],[223.546441,-46.074198],[223.551812,-45.813872],[223.214409,-45.718262],[221.780816,-46.074198],[220.089409,-46.929972]]);
    linear_extrude(height=h)
      polygon([[-389.092756,-164.597062],[-390.523013,-165.091941],[-392.607213,-165.345065],[-398.155256,-165.094112],[-402.277216,-164.752350],[-404.372493,-165.125033],[-404.727391,-165.624672],[-404.656336,-166.357376],[-403.343995,-168.594592],[-402.269952,-169.623144],[-400.750577,-170.454682],[-396.736887,-171.480223],[-392.025044,-171.578234],[-387.337166,-170.655732],[-384.610472,-169.914883],[-382.088618,-169.657317],[-379.318958,-169.880059],[-375.848851,-170.580132],[-372.502411,-171.229634],[-369.496466,-171.486866],[-366.617659,-171.356429],[-363.652633,-170.842922],[-360.832684,-170.343472],[-358.173656,-170.182443],[-355.597866,-170.360079],[-353.027633,-170.876622],[-348.216848,-171.777353],[-343.660595,-172.088322],[-340.570356,-172.252040],[-340.563451,-172.627298],[-341.463508,-173.261412],[-342.886319,-173.751839],[-344.946882,-173.900627],[-351.209608,-173.171212],[-357.363610,-172.482917],[-359.865245,-172.492182],[-361.531708,-172.755252],[-365.705443,-173.361060],[-373.759477,-173.850591],[-397.098095,-174.290452],[-400.316429,-174.379219],[-402.328628,-174.695892],[-403.366185,-175.311530],[-403.660595,-176.297192],[-403.298189,-177.360212],[-402.307659,-178.408437],[-399.022348,-180.231421],[-394.964903,-181.307980],[-393.009205,-181.423175],[-391.295564,-181.179952],[-386.552984,-180.538512],[-378.114071,-179.962761],[-358.035595,-179.424642],[-334.285595,-179.131442],[-330.627392,-179.294172],[-327.098095,-179.947822],[-325.307668,-180.380012],[-324.265285,-180.316668],[-323.779932,-179.668874],[-323.660595,-178.347712],[-323.913223,-177.196965],[-324.623852,-176.060289],[-327.135567,-173.997463],[-330.628651,-172.495857],[-334.536020,-171.892092],[-337.052775,-171.634470],[-336.840581,-171.226438],[-335.745045,-170.522312],[-334.508581,-170.065316],[-332.849292,-169.817060],[-329.085807,-170.010112],[-326.723296,-170.379103],[-325.462124,-170.264805],[-325.022931,-169.527268],[-325.126357,-168.026542],[-325.522997,-166.741263],[-326.303351,-165.707560],[-327.471212,-164.924549],[-329.030373,-164.391348],[-333.337771,-164.070847],[-339.255895,-164.738992],[-342.786478,-165.220693],[-345.864810,-165.357121],[-348.606068,-165.146815],[-351.125432,-164.588312],[-353.660914,-164.019653],[-356.358263,-163.819548],[-359.396562,-163.986976],[-362.954895,-164.520912],[-369.344535,-165.222576],[-371.810768,-165.044244],[-373.957595,-164.512912],[-377.951568,-163.567376],[-382.226411,-163.268398],[-386.150636,-163.612503],[-389.092756,-164.596212]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[-370.338520,-183.170822],[-405.141441,-183.804972],[-408.170761,-191.253332],[-410.058699,-196.541456],[-411.317330,-201.621527],[-411.942494,-206.553824],[-411.930033,-211.398626],[-411.275787,-216.216212],[-409.975595,-221.066860],[-408.025300,-226.010851],[-405.420741,-231.108462],[-401.447037,-237.131411],[-396.698465,-242.678944],[-391.418122,-247.592567],[-385.849103,-251.713786],[-380.234504,-254.884105],[-374.817420,-256.945031],[-372.258914,-257.509941],[-369.840948,-257.738068],[-367.593908,-257.609599],[-365.548182,-257.104722],[-363.499856,-256.505455],[-361.633262,-256.273708],[-359.863330,-256.407184],[-358.104995,-256.903582],[-354.796410,-257.913600],[-353.453658,-258.019988],[-352.192362,-257.824853],[-349.535418,-256.422694],[-346.068145,-253.492472],[-334.836750,-242.681010],[-330.761972,-238.157766],[-327.534826,-233.964721],[-325.020576,-229.908280],[-323.084486,-225.794850],[-321.591821,-221.430835],[-320.407845,-216.622642],[-319.392120,-209.835386],[-319.462296,-203.694828],[-320.677340,-197.641483],[-323.096220,-191.115862],[-325.041615,-187.312027],[-327.143223,-184.894605],[-329.862423,-183.498633],[-333.660595,-182.759152],[-370.338520,-183.170822]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-370.365640,-196.479432],[-370.927079,-202.176402],[-371.160590,-207.729432],[-371.234153,-210.867178],[-371.729618,-212.486790],[-373.059149,-213.090358],[-375.634909,-213.179972],[-378.180769,-213.109352],[-379.400129,-212.653110],[-379.607084,-211.444674],[-379.115729,-209.117472],[-378.401344,-204.779583],[-378.078910,-200.054972],[-378.138654,-197.178302],[-378.683483,-195.655386],[-380.165195,-195.000728],[-383.035590,-194.728832],[-387.571973,-194.725918],[-388.979979,-195.099814],[-389.876255,-195.808371],[-390.307097,-196.914907],[-390.318801,-198.482742],[-389.269977,-203.255582],[-386.109444,-214.683672],[-384.845471,-219.312372],[-377.082214,-219.683672],[-369.318953,-220.054972],[-368.533540,-224.429972],[-366.711802,-231.304972],[-366.161454,-233.077988],[-367.563778,-231.929972],[-371.700090,-226.617472],[-372.808865,-225.282928],[-374.126096,-224.233257],[-376.858947,-223.085281],[-378.011077,-223.035346],[-378.844683,-223.367028],[-379.228021,-224.104511],[-379.029347,-225.271982],[-378.745397,-226.246678],[-378.863851,-226.749236],[-379.431394,-226.818577],[-380.494710,-226.493622],[-381.794071,-226.238293],[-383.164319,-226.385660],[-384.530206,-226.879603],[-385.816486,-227.664003],[-387.849234,-229.879699],[-388.445210,-231.198756],[-388.660590,-232.583792],[-388.814152,-234.770470],[-389.183356,-235.679972],[-391.602772,-236.407782],[-392.689018,-236.345925],[-393.961038,-235.499051],[-395.343087,-233.989709],[-396.759417,-231.940448],[-399.391943,-226.712371],[-401.252650,-220.795212],[-401.696107,-217.690023],[-401.850417,-214.078020],[-401.391162,-206.188006],[-400.074020,-198.834038],[-399.155971,-195.892092],[-398.098127,-193.724982],[-396.692016,-192.021514],[-394.506794,-191.111201],[-390.301924,-190.746526],[-382.836869,-190.679972],[-369.570778,-190.679972],[-370.365690,-196.479432]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-330.677528,-195.679972],[-329.798696,-201.555337],[-329.378753,-209.537602],[-329.469719,-214.496611],[-329.924382,-218.470798],[-330.848890,-222.040887],[-332.349390,-225.787602],[-335.017826,-231.177331],[-337.131102,-234.632502],[-338.162415,-235.654103],[-339.147621,-235.789130],[-340.458965,-234.918320],[-342.468690,-232.922412],[-345.585165,-230.398252],[-346.914303,-229.836169],[-347.919690,-229.837532],[-348.882690,-229.912232],[-350.150933,-229.596130],[-352.943740,-228.028892],[-355.362350,-226.545204],[-356.341495,-226.287272],[-357.158033,-226.349181],[-357.805088,-226.728857],[-358.275783,-227.424226],[-358.660590,-229.753742],[-359.003905,-231.646776],[-359.374788,-231.628863],[-359.826697,-231.057233],[-360.818232,-228.520536],[-361.667777,-224.572102],[-362.494615,-219.089232],[-358.128177,-219.797802],[-353.826096,-219.961853],[-349.614390,-219.361242],[-347.399431,-218.557571],[-345.909900,-217.367506],[-344.826539,-215.399134],[-343.830090,-212.260542],[-340.938377,-202.959622],[-340.244881,-199.755376],[-340.623149,-196.992993],[-341.188809,-195.848076],[-341.991947,-194.898315],[-343.022408,-194.171940],[-344.270040,-193.697182],[-347.117486,-193.261434],[-349.508932,-193.492717],[-351.429000,-194.387015],[-352.862315,-195.940312],[-353.492638,-197.614338],[-353.374483,-200.234207],[-352.357594,-204.743702],[-350.291715,-212.086602],[-350.228729,-213.111194],[-350.947042,-213.706920],[-352.700529,-213.961069],[-355.743065,-213.960932],[-361.785590,-213.803632],[-362.165740,-207.887492],[-362.172224,-204.951844],[-361.816293,-202.028306],[-361.100881,-199.132831],[-360.028927,-196.281372],[-357.511990,-190.591402],[-344.697552,-190.948182],[-331.883127,-191.304972],[-330.677527,-195.679972]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-345.605303,-201.817172],[-345.344825,-203.235022],[-345.705553,-205.046982],[-346.147705,-206.003886],[-346.559627,-206.383346],[-347.009491,-206.200950],[-347.565465,-205.472282],[-348.317530,-203.835762],[-348.641515,-202.242472],[-348.321544,-201.177309],[-347.518650,-200.724725],[-346.518150,-200.924689],[-345.605365,-201.817172]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-381.390062,-206.088872],[-381.502297,-208.448522],[-381.841181,-209.166338],[-382.327562,-209.429972],[-383.274026,-209.154583],[-383.677658,-208.492472],[-384.492211,-204.575122],[-384.727757,-202.379062],[-384.321500,-202.053401],[-383.537642,-202.171522],[-382.826143,-202.658899],[-382.184068,-203.559942],[-381.390062,-206.088872]]);
    }
  }
}
module HI_Stat(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-148.275000,30.140675],[-148.735239,29.866858],[-149.076972,29.380943],[-149.475364,26.198180],[-149.625000,-0.033535],[-149.546903,-25.196168],[-149.370533,-28.655492],[-149.032620,-29.518565],[-148.362268,-30.024892],[-147.441116,-30.308429],[-143.801280,-30.379035],[-141.031825,-30.240630],[-140.220012,-29.884590],[-139.700115,-29.095064],[-139.265997,-25.488768],[-139.189320,-17.968175],[-139.103620,-7.026195],[-128.464300,-7.026195],[-117.824980,-7.026195],[-117.824980,-17.949525],[-117.824980,-28.872855],[-116.873500,-29.673475],[-115.574031,-30.354786],[-112.346830,-30.375145],[-109.153109,-30.176860],[-108.526975,-29.914677],[-108.048310,-29.434465],[-107.324980,-28.592735],[-107.324980,0.023805],[-107.324980,28.640345],[-108.048310,29.482075],[-108.526975,29.962281],[-109.153109,30.224455],[-112.346830,30.422755],[-115.574031,30.402396],[-116.873500,29.721085],[-117.824980,28.920465],[-117.824980,16.347135],[-117.824980,3.773805],[-128.465530,3.773805],[-139.106080,3.773805],[-139.190580,16.365725],[-139.274980,28.957645],[-139.957480,29.640725],[-141.089226,30.228106],[-144.157480,30.402965],[-148.274980,30.140675]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[-92.234280,30.170275],[-93.340350,29.040845],[-93.396468,27.961935],[-92.403746,24.299785],[-84.189540,-0.838335],[-75.869190,-25.681911],[-74.455517,-29.316044],[-73.783500,-30.161375],[-69.028328,-30.368698],[-64.733280,-29.955335],[-54.219780,-0.764245],[-45.427459,24.428044],[-44.409309,27.969620],[-44.490000,29.002795],[-45.708900,30.186705],[-50.046191,30.446271],[-54.358080,30.203405],[-55.398428,28.281099],[-57.682980,21.749495],[-60.424830,13.523785],[-69.295710,13.444385],[-78.166560,13.364985],[-79.267440,16.894405],[-82.758675,27.826717],[-83.471964,29.622365],[-83.916750,30.169415],[-87.990251,30.447759],[-92.234280,30.170315]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-63.831810,3.098805],[-66.708968,-5.708797],[-69.611940,-13.626195],[-74.760180,2.498805],[-74.965440,3.173805],[-69.395220,3.173805],[-63.831810,3.098805]]);
    }
    linear_extrude(height=h)
      polygon([[-21.461520,29.970435],[-22.038803,28.647539],[-23.185519,24.338185],[-28.729500,0.508415],[-34.312215,-24.313148],[-34.977038,-28.057481],[-34.867350,-29.129975],[-34.257678,-29.785354],[-33.320828,-30.180614],[-29.488710,-30.426195],[-26.620684,-30.325545],[-25.454760,-29.901195],[-24.986568,-28.939425],[-24.238991,-26.006753],[-20.921520,-9.882735],[-17.005680,9.767265],[-12.196260,-9.726195],[-8.192216,-25.750244],[-7.276611,-28.861319],[-6.757830,-29.921045],[-5.433596,-30.359911],[-1.381440,-30.371045],[3.635490,-29.976195],[12.368010,5.273805],[13.059255,8.013709],[13.261929,8.425007],[13.395540,8.273805],[17.496690,-11.076195],[21.704700,-29.976195],[25.888380,-30.375025],[29.773500,-30.473825],[30.674250,-29.573075],[31.575000,-28.236495],[24.807630,0.811575],[19.237924,23.955370],[18.014755,28.491607],[17.424390,29.948825],[16.234556,30.375598],[13.125000,30.473825],[10.014214,30.375238],[8.807850,29.948825],[8.290108,28.848339],[7.355655,25.561518],[3.241800,8.615985],[-1.782840,-12.281005],[-6.921630,8.676835],[-12.260760,30.023825],[-16.679190,30.420455],[-20.217934,30.408230],[-21.461520,29.970455]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[41.865720,30.170265],[40.760160,29.041795],[40.704953,27.961894],[41.698766,24.297100],[49.911780,-0.837695],[58.231024,-25.678160],[59.645377,-29.314992],[60.317340,-30.161705],[65.076259,-30.369340],[69.371790,-29.950275],[79.883340,-0.755415],[88.663845,24.419541],[89.685319,27.970041],[89.608050,29.006555],[88.335630,30.208185],[83.646052,30.416379],[79.377000,30.076675],[76.397970,21.676675],[73.665180,13.523805],[64.799310,13.444405],[55.933440,13.365005],[54.832560,16.894425],[51.341325,27.826734],[50.628036,29.622381],[50.183250,30.169435],[46.109749,30.447775],[41.865720,30.170335]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[70.268190,3.098805],[67.391033,-5.708797],[64.488060,-13.626195],[59.339820,2.498805],[59.134560,3.173805],[64.704780,3.173805],[70.268190,3.098805]]);
    }
    linear_extrude(height=h)
      polygon([[105.825000,30.140675],[105.364761,29.866858],[105.023028,29.380943],[104.624636,26.198180],[104.475000,-0.033535],[104.553098,-25.196168],[104.729467,-28.655492],[105.067380,-29.518565],[105.737732,-30.024892],[106.658884,-30.308429],[110.298720,-30.379035],[113.047916,-30.179761],[114.142350,-29.592865],[114.825000,-28.909525],[114.825000,0.023805],[114.825000,28.957135],[114.142500,29.640475],[113.010911,30.228101],[109.942500,30.402965],[105.825000,30.140675]]);
    linear_extrude(height=h)
      polygon([[140.625000,30.140675],[140.164761,29.866858],[139.823028,29.380943],[139.424636,26.198180],[139.275000,-0.033535],[139.353097,-25.196168],[139.529467,-28.655492],[139.867380,-29.518565],[140.537732,-30.024892],[141.458884,-30.308429],[145.098720,-30.379035],[147.847916,-30.179761],[148.942350,-29.592865],[149.625000,-28.909525],[149.625000,0.023805],[149.625000,28.957135],[148.942500,29.640475],[147.810911,30.228101],[144.742500,30.402965],[140.625000,30.140675]]);
  }
}
module HI_Slog(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    difference()
    {
       linear_extrude(height=h)
         polygon([[-139.821916,27.574149],[-142.402505,27.017001],[-144.815103,26.187260],[-147.056496,25.087366],[-149.123466,23.719759],[-151.012799,22.086882],[-152.721278,20.191174],[-155.582816,15.621029],[-157.012742,12.329836],[-157.967628,9.148409],[-158.533058,5.703845],[-158.794616,1.623239],[-158.800313,-2.358394],[-158.530666,-5.825791],[-157.952019,-9.044224],[-157.030716,-12.278971],[-155.167577,-16.623562],[-152.687253,-20.347977],[-149.651461,-23.376641],[-146.121916,-25.633981],[-141.927069,-27.092197],[-137.453616,-27.579349],[-133.007313,-27.095318],[-128.893916,-25.639981],[-126.066626,-23.929824],[-123.581375,-21.830143],[-121.442208,-19.348561],[-119.653166,-16.492699],[-118.218293,-13.270179],[-117.141631,-9.688621],[-116.427225,-5.755648],[-116.079116,-1.478881],[-116.172662,3.742885],[-116.837235,8.558373],[-118.051135,12.928171],[-119.792666,16.812864],[-122.040128,20.173042],[-124.771822,22.969290],[-127.966051,25.162197],[-131.601116,26.712349],[-135.876816,27.516649],[-139.821916,27.574249]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-133.547716,17.554889],[-131.505228,16.498227],[-129.710725,14.970755],[-128.180837,13.010770],[-126.932191,10.656566],[-125.981417,7.946438],[-125.345144,4.918683],[-125.040001,1.611595],[-125.082616,-1.936531],[-125.854621,-7.266119],[-127.449478,-11.633798],[-128.547271,-13.441031],[-129.840930,-14.988719],[-131.327172,-16.270504],[-133.002716,-17.280031],[-134.711278,-17.851013],[-137.421916,-17.978971],[-140.202741,-17.841188],[-142.106216,-17.151811],[-143.702333,-16.154504],[-145.287003,-14.796154],[-146.673280,-13.258980],[-147.674216,-11.725201],[-148.647619,-9.454760],[-149.261566,-7.012624],[-149.691816,0.021029],[-149.631628,4.058515],[-149.333166,6.920913],[-148.680328,9.240639],[-147.557016,11.650109],[-146.347061,13.515885],[-144.811353,15.220499],[-143.110777,16.610136],[-141.406216,17.530979],[-139.566564,18.005508],[-137.485703,18.168164],[-135.400474,18.018228],[-133.547716,17.554979]]);
    }
    linear_extrude(height=h)
      polygon([[47.828084,27.495649],[43.289378,26.400599],[39.540309,24.496074],[36.531228,21.747912],[34.212484,18.121949],[32.897642,14.771301],[32.095322,11.440649],[31.911733,8.775840],[32.085153,7.894953],[32.453084,7.422719],[36.323584,6.970859],[38.577086,6.888784],[39.777222,7.108256],[40.327389,7.851072],[40.630984,9.339029],[41.308037,12.141244],[42.367159,14.303808],[43.895819,15.955628],[45.981484,17.225609],[47.943459,17.889393],[50.978084,18.021029],[54.033584,17.887061],[56.018384,17.166479],[57.490804,16.255716],[58.529997,15.156172],[59.176583,13.808869],[59.471184,12.154829],[59.367159,9.619376],[58.277184,7.808849],[57.266023,6.849420],[55.835997,6.039393],[49.614884,3.923729],[42.111322,1.239862],[39.803154,-0.038107],[37.943684,-1.512721],[36.514629,-3.060229],[35.371597,-4.801392],[34.499033,-6.764782],[33.881384,-8.978971],[33.465322,-12.127508],[33.881384,-15.278971],[34.968140,-18.690402],[36.667759,-21.629404],[38.919415,-24.014057],[41.662284,-25.762441],[45.669059,-27.186484],[50.080084,-27.542701],[53.170922,-27.315898],[55.982312,-26.700132],[58.504545,-25.702704],[60.727909,-24.330912],[62.642695,-22.592058],[64.239194,-20.493441],[65.507693,-18.042362],[66.438484,-15.246121],[67.029234,-11.384539],[66.907440,-10.118926],[66.505484,-9.480661],[62.619084,-9.027901],[60.346245,-8.965767],[59.050122,-9.160789],[58.466329,-9.718877],[58.330484,-10.745941],[57.944394,-13.092115],[56.894684,-15.202909],[55.344200,-16.843414],[53.455784,-17.778721],[49.740522,-18.112606],[46.113084,-17.675731],[44.340714,-16.762711],[43.041022,-15.311044],[42.321061,-13.493983],[42.287884,-11.484781],[42.928569,-9.817481],[44.497809,-8.466124],[47.435237,-7.172733],[52.180484,-5.679331],[59.438984,-3.108061],[63.255481,-0.648522],[64.765279,0.856238],[66.006134,2.539027],[66.975564,4.395873],[67.671087,6.422804],[68.230484,10.971029],[68.010668,13.804833],[67.369664,16.476261],[66.335142,18.948312],[64.934772,21.183984],[63.196221,23.146276],[61.147161,24.798185],[58.815259,26.102710],[56.228184,27.022849],[52.068784,27.579349],[47.830484,27.495649]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[-247.088596,26.675449],[-248.066456,25.684149],[-248.228084,24.768975],[-247.483312,21.696428],[-240.472676,-0.630121],[-234.366718,-19.483598],[-231.862456,-26.453971],[-230.464545,-26.745481],[-228.018357,-26.841064],[-225.569891,-26.741601],[-224.165146,-26.447971],[-215.155017,-1.079096],[-206.571916,24.911949],[-206.794992,25.600812],[-207.362386,26.248949],[-208.596773,26.764487],[-211.540936,26.870749],[-214.981996,26.611624],[-215.660891,26.135759],[-216.029956,25.293949],[-218.312446,18.095729],[-220.397566,11.570729],[-227.810896,11.570729],[-235.224226,11.570729],[-237.408076,18.845729],[-239.125070,24.210797],[-240.089236,26.495749],[-243.329663,26.836699],[-247.088596,26.675149]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-223.371796,2.346029],[-227.867026,-11.923441],[-228.421486,-10.855021],[-230.561986,-3.760681],[-232.371916,2.295899],[-227.871916,2.571029],[-223.371796,2.346029]]);
    }
    linear_extrude(height=h)
      polygon([[-197.594986,25.994149],[-198.471916,25.117149],[-198.471916,0.021029],[-198.471916,-25.075111],[-197.567026,-25.980001],[-196.402197,-26.757683],[-193.697806,-26.781931],[-191.042303,-26.715119],[-190.282367,-26.183556],[-189.811343,-24.839498],[-189.467142,-18.272729],[-189.471916,-4.132471],[-189.471916,17.271029],[-180.062416,17.271029],[-173.361878,17.295561],[-170.137591,17.736448],[-169.434834,18.285194],[-169.128091,19.144631],[-169.071916,22.071049],[-169.105008,25.038424],[-169.476468,25.899565],[-170.377953,26.442049],[-174.651255,26.860174],[-183.685416,26.871049],[-196.718056,26.871049],[-197.594986,25.994149]]);
    linear_extrude(height=h)
      polygon([[-100.481416,26.249249],[-101.271916,25.627449],[-101.271916,0.021029],[-101.271916,-25.585411],[-100.481416,-26.207191],[-99.330578,-26.715721],[-96.921916,-26.828971],[-94.513253,-26.715736],[-93.362416,-26.207191],[-92.571916,-25.585411],[-92.571916,-16.007191],[-92.571916,-6.428971],[-83.421916,-6.428971],[-74.271916,-6.428971],[-74.271916,-16.007191],[-74.271916,-25.585411],[-73.481416,-26.207191],[-72.321853,-26.716576],[-69.858416,-26.828971],[-67.296591,-26.707542],[-66.148816,-25.952041],[-65.271916,-25.075111],[-65.271916,0.021029],[-65.271916,25.117149],[-66.148816,25.994149],[-67.296591,26.749624],[-69.858416,26.871049],[-72.321853,26.758824],[-73.481416,26.249249],[-74.271916,25.627449],[-74.271916,14.399249],[-74.271916,3.171029],[-83.421916,3.171029],[-92.571916,3.171029],[-92.571916,14.399249],[-92.571916,25.627449],[-93.362416,26.249249],[-94.513253,26.757774],[-96.921916,26.871049],[-99.330578,26.757699],[-100.481416,26.249249]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[-55.388616,26.675449],[-56.366416,25.684149],[-56.528071,24.768975],[-55.783303,21.696428],[-48.772616,-0.630121],[-42.666691,-19.483598],[-40.162416,-26.453971],[-38.764525,-26.745481],[-36.318341,-26.841064],[-33.869869,-26.741601],[-32.465116,-26.447971],[-23.455028,-1.079096],[-14.871916,24.911949],[-15.095003,25.600812],[-15.662416,26.248949],[-16.896778,26.764487],[-19.840916,26.870749],[-23.281966,26.611624],[-23.960863,26.135759],[-24.329916,25.293949],[-26.612416,18.095729],[-28.697516,11.570729],[-36.110916,11.570729],[-43.524216,11.570729],[-45.708116,18.845729],[-47.425053,24.210797],[-48.389216,26.495749],[-51.629641,26.836699],[-55.388616,26.675149]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-31.671816,2.346029],[-33.807416,-4.778971],[-35.875878,-11.109736],[-36.331452,-12.092764],[-36.474416,-11.813971],[-38.574416,-4.676191],[-40.671916,2.298809],[-36.171916,2.571029],[-31.671816,2.346029]]);
    }
    linear_extrude(height=h)
      polygon([[93.432984,26.022049],[92.528084,25.117149],[92.528084,3.944099],[92.528084,-17.228971],[86.568584,-17.228971],[82.086847,-17.278004],[79.861859,-17.759727],[79.349236,-18.319701],[79.105109,-19.176071],[79.028084,-22.028971],[79.038681,-25.020519],[79.471317,-25.882667],[80.561634,-26.421458],[85.833687,-26.826153],[97.091584,-26.828971],[113.574184,-26.828971],[114.451184,-25.952041],[115.209922,-24.782776],[115.328084,-22.028971],[115.209847,-19.275166],[114.451184,-18.105901],[113.574184,-17.228971],[107.551184,-17.228971],[101.528084,-17.228971],[101.528084,4.174529],[101.532859,18.314793],[101.188659,24.881559],[100.717635,26.225612],[99.957697,26.757166],[97.302184,26.823949],[94.597784,26.799762],[93.432984,26.022049]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[120.711384,26.675449],[119.732284,25.682049],[119.531647,24.887298],[120.013734,22.641511],[124.946384,6.867839],[133.047184,-18.578971],[134.909834,-24.122791],[135.932184,-26.453971],[137.334026,-26.745409],[139.781772,-26.840963],[142.230398,-26.741521],[143.634884,-26.447971],[152.644972,-1.079096],[161.228084,24.911949],[161.004997,25.600812],[160.437584,26.248949],[159.203222,26.764487],[156.259084,26.870749],[152.818034,26.611624],[152.139137,26.135759],[151.770084,25.293949],[149.487584,18.095729],[147.402384,11.570729],[139.989084,11.570729],[132.575784,11.570729],[130.391884,18.845729],[128.674947,24.210797],[127.710784,26.495749],[124.470359,26.836737],[120.711384,26.675149]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[144.428184,2.346029],[142.292584,-4.778971],[140.224122,-11.109736],[139.768548,-12.092764],[139.625584,-11.813971],[137.525584,-4.676191],[135.428084,2.298809],[139.928084,2.571029],[144.428184,2.346029]]);
    }
    linear_extrude(height=h)
      polygon([[180.132984,26.022049],[179.228084,25.117149],[179.228084,3.944099],[179.228084,-17.228971],[173.268584,-17.228971],[168.786847,-17.278004],[166.561859,-17.759727],[166.049236,-18.319701],[165.805109,-19.176071],[165.728084,-22.028971],[165.738681,-25.020519],[166.171317,-25.882667],[167.261634,-26.421458],[172.533687,-26.826153],[183.791584,-26.828971],[200.274184,-26.828971],[201.151184,-25.952041],[201.909922,-24.782776],[202.028084,-22.028971],[201.909847,-19.275166],[201.151184,-18.105901],[200.274184,-17.228971],[194.251184,-17.228971],[188.228084,-17.228971],[188.228084,4.174529],[188.232859,18.314793],[187.888659,24.881559],[187.417635,26.225612],[186.657697,26.757166],[184.002184,26.823949],[181.297784,26.799762],[180.132984,26.022049]]);
    linear_extrude(height=h)
      polygon([[214.818584,26.249249],[214.028084,25.627449],[214.028084,0.021029],[214.028084,-25.585411],[214.828584,-26.215081],[215.548062,-26.575033],[217.492534,-26.752988],[230.905184,-26.761831],[246.181384,-26.678931],[246.754784,-25.970691],[247.223384,-24.801193],[247.328084,-22.028931],[247.223422,-19.256724],[246.754784,-18.087171],[246.181584,-17.378931],[234.454784,-17.293831],[222.728084,-17.208731],[222.728084,-11.518811],[222.728084,-5.828891],[233.401184,-5.828891],[244.074184,-5.828891],[244.951184,-4.951961],[245.709922,-3.782696],[245.828084,-1.028891],[245.709847,1.724914],[244.951184,2.894179],[244.074184,3.771109],[233.401184,3.771109],[222.728084,3.771109],[222.728084,10.521109],[222.728084,17.271109],[234.687584,17.271109],[243.030415,17.285288],[246.993059,17.708921],[247.835740,18.252921],[248.188090,19.113653],[248.228084,22.071129],[248.211167,25.056856],[247.795583,25.918761],[246.757972,26.458442],[241.764833,26.866372],[231.128084,26.871129],[217.547272,26.789279],[215.550561,26.604167],[214.818584,26.249329]]);
  }
}
module IA_Stat(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-151.894796,57.455178],[-152.922149,56.149681],[-153.477854,54.810139],[-153.585004,53.489324],[-153.266693,52.240012],[-152.546013,51.114976],[-151.446058,50.166991],[-149.989921,49.448830],[-148.200696,49.013268],[-146.438966,48.658880],[-145.104727,47.786706],[-144.128736,45.831711],[-143.441749,42.228858],[-142.974526,36.413112],[-142.657822,27.819435],[-142.199006,0.038148],[-141.935595,-27.003628],[-142.288851,-41.409702],[-142.798088,-45.113522],[-143.583124,-47.145423],[-144.684502,-48.001074],[-146.142766,-48.176142],[-148.132638,-48.555542],[-149.341255,-49.568108],[-149.822675,-51.025389],[-149.630956,-52.738933],[-148.820154,-54.520289],[-147.444329,-56.181005],[-145.557537,-57.532630],[-143.213836,-58.386712],[-137.852408,-58.865751],[-128.770888,-58.946281],[-116.848035,-58.637836],[-102.962606,-57.949952],[-101.258551,-57.504809],[-99.943259,-56.457566],[-99.095974,-54.903538],[-98.795936,-52.938042],[-99.112157,-50.720782],[-100.135224,-49.247569],[-101.976742,-48.429118],[-104.748316,-48.176142],[-110.700696,-48.176142],[-110.700696,0.633388],[-110.700696,49.442908],[-104.573746,49.442908],[-101.737381,49.658637],[-99.979977,50.365408],[-99.187225,51.652597],[-99.244816,53.609578],[-99.665726,54.827758],[-100.531075,55.803393],[-102.020878,56.570115],[-104.315152,57.161561],[-112.037181,57.953153],[-125.137296,58.447238],[-143.348757,58.432599],[-149.268946,58.047957],[-151.894796,57.455178]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[-78.659696,54.530928],[-82.002219,52.246360],[-84.992331,49.670786],[-87.651091,46.771223],[-89.999561,43.514687],[-92.058800,39.868195],[-93.849870,35.798765],[-95.393832,31.273414],[-96.711746,26.259158],[-97.804763,19.129519],[-97.812247,12.279672],[-96.827068,5.775909],[-94.942097,-0.315480],[-92.250202,-5.928205],[-88.844253,-10.995975],[-84.817121,-15.452500],[-80.261676,-19.231489],[-75.270786,-22.266653],[-69.937322,-24.491700],[-64.354154,-25.840341],[-58.614152,-26.246285],[-52.810185,-25.643241],[-47.035124,-23.964920],[-41.381837,-21.145030],[-35.943196,-17.117282],[-32.174017,-13.511869],[-29.108671,-9.874639],[-26.703156,-6.080334],[-24.913471,-2.003697],[-23.695614,2.480530],[-23.005583,7.497603],[-22.799378,13.172780],[-23.032996,19.631318],[-23.603737,25.640791],[-24.542339,30.903383],[-25.915407,35.540792],[-27.789546,39.674718],[-30.231359,43.426861],[-33.307452,46.918919],[-37.084429,50.272591],[-41.628896,53.609578],[-45.648139,55.844182],[-50.159114,57.481134],[-55.003043,58.516484],[-60.021146,58.946281],[-65.054642,58.766574],[-69.944752,57.973414],[-74.532696,56.562849],[-78.659696,54.530928]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-52.227196,48.444358],[-50.849104,47.259543],[-49.771908,45.798785],[-48.959500,43.823129],[-48.375771,41.093619],[-47.749921,32.417213],[-47.605496,17.857918],[-47.718430,7.681587],[-48.107308,-0.418172],[-48.847242,-6.643863],[-50.013346,-11.197987],[-51.680730,-14.283049],[-52.725875,-15.337963],[-53.924508,-16.101551],[-56.819792,-16.855998],[-60.441696,-16.748892],[-63.595931,-15.979071],[-66.202614,-14.399742],[-68.301501,-11.895189],[-69.932346,-8.349697],[-71.134903,-3.647549],[-71.948927,2.326971],[-72.414173,9.689578],[-72.570396,18.555988],[-72.273421,28.914658],[-71.344124,37.367348],[-69.777819,43.920959],[-68.754324,46.487766],[-67.569821,48.582392],[-66.223723,50.205698],[-64.715444,51.358547],[-63.044400,52.041803],[-61.210005,52.256326],[-59.211672,52.002981],[-57.048817,51.282630],[-54.720853,50.096134],[-52.227196,48.444358]]);
    }
    linear_extrude(height=h)
      polygon([[-4.672496,23.244378],[-10.398888,9.098533],[-15.553658,-2.871899],[-19.571897,-11.404283],[-21.888696,-15.235982],[-23.091502,-16.492995],[-24.076471,-18.015109],[-24.741977,-19.610345],[-24.986396,-21.086722],[-24.766419,-21.949037],[-24.062124,-22.659195],[-22.806958,-23.228656],[-20.934371,-23.668881],[-15.070730,-24.207459],[-5.938796,-24.366612],[5.683189,-23.929665],[9.472316,-23.338611],[11.986679,-22.459286],[13.281140,-21.261776],[13.410558,-19.716170],[12.429792,-17.792553],[10.393704,-15.461012],[9.760401,-14.591113],[9.390458,-13.474237],[9.472404,-10.308623],[10.703051,-5.582298],[13.145904,1.086608],[17.432004,11.354696],[20.059404,16.617448],[20.453288,16.663507],[21.020587,16.136009],[22.568617,13.569687],[24.489865,9.337178],[26.570704,3.857178],[29.375318,-4.466692],[30.096143,-7.209313],[30.370942,-9.284852],[30.205936,-10.902652],[29.607347,-12.272059],[27.134304,-15.103072],[24.719188,-17.724777],[23.340343,-19.817922],[23.084401,-21.437678],[23.404590,-22.087277],[24.037992,-22.639217],[26.287747,-23.477709],[29.920297,-24.008324],[41.680304,-24.366612],[50.919606,-24.209278],[56.771317,-23.665971],[58.615571,-23.216152],[59.839422,-22.629731],[60.518367,-21.893338],[60.727904,-20.993602],[60.528079,-19.617315],[59.984004,-18.363443],[59.178779,-17.370364],[58.195504,-16.776452],[57.748470,-16.281629],[57.584728,-15.210309],[58.081992,-11.454024],[59.637037,-5.739291],[62.199604,1.702198],[68.736104,19.336718],[74.255804,2.973658],[77.962606,-8.329405],[79.417167,-14.367022],[79.349430,-15.925182],[78.778122,-16.783654],[77.723070,-17.147994],[76.204104,-17.223762],[74.817368,-17.505570],[73.681742,-18.272868],[72.914422,-19.408471],[72.632604,-20.795192],[72.782967,-21.735819],[73.265056,-22.509881],[74.125372,-23.130060],[75.410417,-23.609039],[79.440697,-24.194129],[85.727904,-24.366612],[90.440438,-24.245229],[94.069914,-23.868814],[96.633053,-23.218972],[98.146579,-22.277304],[98.627215,-21.025416],[98.091683,-19.444908],[96.556705,-17.517386],[94.039004,-15.224452],[92.791639,-13.741841],[91.251309,-11.148133],[87.427592,-2.948476],[82.839531,8.732413],[77.758804,23.252428],[72.829076,37.732732],[68.834876,48.206472],[67.094175,51.966967],[65.474047,54.757124],[63.936722,56.587380],[62.444429,57.468167],[60.959400,57.409921],[59.443865,56.423076],[57.860053,54.518066],[56.170195,51.705328],[52.321261,43.398400],[47.594904,31.585768],[43.371945,21.254948],[39.864204,13.709487],[37.326664,9.447404],[36.501400,8.703260],[36.014304,8.966718],[26.525504,35.157198],[22.484209,46.020274],[19.087926,53.585009],[17.537200,56.094428],[16.034370,57.735977],[14.541650,58.495227],[13.021254,58.357751],[11.435398,57.309119],[9.746295,55.334904],[7.916160,52.420677],[5.907208,48.552011],[1.201706,37.893644],[-4.672496,23.244378]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[82.156404,53.292028],[82.485987,51.926948],[83.383367,50.644978],[84.711490,49.590033],[86.333304,48.906028],[87.541330,48.142151],[88.909500,46.391865],[90.472157,43.573293],[92.263642,39.604558],[96.670465,27.889099],[102.404704,10.590478],[108.837701,-9.019957],[113.140754,-20.290884],[114.809753,-23.492468],[116.325708,-25.441297],[117.815098,-26.414747],[119.404404,-26.690192],[120.972871,-26.489740],[122.406889,-25.704212],[123.813845,-24.113716],[125.301129,-21.498357],[128.946233,-12.313477],[134.201304,3.609578],[142.469567,27.819959],[146.092653,37.341082],[148.739004,43.398718],[152.161492,50.611597],[153.585004,54.708248],[153.220538,55.085401],[152.175967,55.437251],[148.339479,56.034244],[142.661479,56.437619],[135.727904,56.585768],[126.910937,56.429518],[121.442167,55.871481],[119.754097,55.399940],[118.651965,54.777730],[118.052069,53.988110],[117.870704,53.014338],[118.152522,51.627617],[118.919842,50.492014],[120.055468,49.724716],[121.442204,49.442908],[123.840806,49.278365],[124.485447,48.942710],[124.777967,48.322599],[124.359597,45.882405],[122.691604,41.264578],[121.189775,38.238202],[120.287035,37.173729],[119.215642,36.369023],[116.364590,35.420777],[112.232004,35.157198],[108.661333,35.405669],[105.829579,36.133633],[103.803364,37.314920],[102.649304,38.923358],[101.422878,43.258900],[101.392392,46.575899],[101.814397,47.796871],[102.521912,48.696516],[103.510445,49.252605],[104.775504,49.442908],[106.162225,49.724716],[107.297817,50.492014],[108.065103,51.627617],[108.346904,53.014338],[108.196546,53.954966],[107.714468,54.729029],[106.854168,55.349210],[105.569142,55.828191],[101.538897,56.413284],[95.251704,56.585768],[89.171511,56.409340],[85.118229,55.840814],[82.857861,54.821331],[82.326893,54.124086],[82.156404,53.292028]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[116.552704,22.657198],[114.319998,16.317623],[113.375409,14.574383],[112.499829,13.763529],[111.659134,13.871080],[110.819198,14.883050],[109.005104,19.564318],[107.677209,24.302273],[107.466655,25.797998],[107.603492,26.827229],[108.121568,27.476723],[109.054731,27.833235],[112.301704,28.014338],[115.273903,27.817624],[116.214147,27.519941],[116.827017,27.043338],[117.139910,26.353289],[117.180225,25.415268],[116.552704,22.657198]]);
    }
  }
}
module IA_Back(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    difference()
    {
       linear_extrude(height=h)
         polygon([[273.440129,167.299543],[271.830484,165.973634],[271.292604,164.666856],[271.878053,163.348897],[273.638394,161.989445],[276.625191,160.558187],[280.890008,159.024810],[293.459959,155.530453],[307.426864,151.484679],[312.252001,149.677585],[314.708629,148.329403],[316.236579,147.350497],[318.533141,146.548860],[321.287274,146.007214],[324.187939,145.808283],[327.524760,145.668836],[329.236342,145.165794],[329.534788,144.738220],[329.489466,144.172104],[328.450909,142.560713],[326.717577,141.198461],[324.252554,140.455815],[320.986441,140.322165],[316.849839,140.786903],[311.888906,141.278172],[304.964874,141.526333],[288.896409,141.234573],[280.484534,140.684564],[276.025634,140.131623],[275.217250,139.840362],[275.323551,139.531941],[278.182129,138.841712],[286.515459,137.474952],[287.215009,120.213043],[287.914559,102.951143],[275.905479,102.951143],[263.896409,102.951143],[263.896409,120.808283],[264.072347,128.231019],[264.575700,133.854682],[265.369778,137.419431],[265.864372,138.348511],[266.417889,138.665422],[267.299261,138.823449],[267.835082,139.253720],[267.983235,139.890522],[267.701599,140.668142],[265.945523,141.453106],[262.079085,142.109929],[256.673304,142.569841],[250.299199,142.764072],[238.851816,142.577596],[238.810817,142.393911],[239.822023,142.135736],[244.848789,141.356592],[248.961978,140.632999],[252.240904,139.772178],[254.353534,138.881964],[254.868729,138.459533],[254.967839,138.070192],[254.547451,131.868881],[254.372599,119.466952],[254.372599,102.649422],[246.634509,103.395522],[242.227616,104.074348],[240.804338,104.737795],[239.772187,105.815314],[239.034426,107.455442],[238.494317,109.806716],[237.620099,117.236852],[236.343819,130.332092],[235.239149,115.506592],[234.813480,104.032957],[235.306950,95.800770],[235.842483,93.287862],[236.540747,92.050489],[236.943918,91.958583],[237.379389,92.243706],[238.336059,94.022572],[239.494116,95.812566],[241.380934,97.118305],[243.950056,97.917843],[247.155029,98.189232],[254.372599,98.189232],[254.372599,81.522572],[254.247173,72.251093],[254.009077,69.304017],[253.581781,67.262737],[252.911075,65.962271],[251.942751,65.237632],[250.622598,64.923838],[248.896409,64.855902],[246.544663,65.081350],[244.189567,65.695190],[242.104560,66.603672],[240.563079,67.713042],[239.527932,68.339886],[239.096182,68.117745],[238.715163,67.417481],[238.085865,64.219338],[237.601129,58.018967],[236.909712,33.705586],[236.329649,-11.334578],[235.231169,-83.953618],[234.993065,-104.668135],[235.217212,-111.754164],[235.783606,-117.422184],[236.777333,-122.244304],[238.283477,-126.792632],[240.387123,-131.639277],[243.173359,-137.356348],[246.116412,-142.726841],[249.183815,-147.147955],[252.492997,-150.690868],[256.161384,-153.426754],[260.306403,-155.426789],[265.045482,-156.762149],[270.496048,-157.504010],[276.775529,-157.723548],[285.307598,-157.459441],[288.476741,-157.002678],[291.262552,-156.198233],[293.925978,-154.947696],[296.727965,-153.152661],[303.791409,-147.535468],[310.471835,-142.099917],[314.305057,-139.664171],[315.468039,-139.449246],[316.296106,-139.837898],[316.914886,-140.781336],[317.450009,-142.230768],[318.589670,-144.905365],[320.362275,-147.933543],[325.226837,-154.374930],[330.884740,-160.203503],[333.649021,-162.465664],[336.177029,-164.067838],[338.225342,-164.912781],[338.607695,-164.827999],[338.552326,-164.382563],[337.098859,-162.342279],[333.805819,-158.657028],[327.983271,-151.538024],[323.160290,-144.034151],[319.873199,-137.100187],[318.973212,-134.145288],[318.658319,-131.690908],[318.509803,-129.859622],[318.090656,-128.688194],[317.440473,-128.159342],[316.598854,-128.255784],[315.605395,-128.960238],[314.499694,-130.255423],[312.109959,-134.548858],[310.259398,-137.560855],[307.400645,-140.921625],[303.923864,-144.221011],[300.219219,-147.048858],[292.789717,-151.857668],[290.680485,-153.006828],[289.556527,-153.301244],[289.354042,-152.727476],[290.009226,-151.272089],[293.637389,-145.662708],[297.796295,-138.703970],[300.655195,-132.257209],[301.506574,-129.479652],[301.924270,-127.134687],[301.872054,-125.323848],[301.313699,-124.148668],[300.700955,-124.243630],[299.956539,-125.426096],[298.448719,-130.252428],[297.192004,-133.775257],[294.964201,-137.931099],[292.080122,-142.201062],[288.854579,-146.066258],[284.542179,-150.360225],[281.419579,-152.552630],[280.086518,-152.959177],[278.789384,-152.958449],[275.954199,-151.892658],[273.494753,-149.879722],[270.718803,-146.509336],[267.852625,-142.210558],[265.122496,-137.412448],[262.754693,-132.544062],[260.975493,-128.034459],[260.011173,-124.312698],[259.905304,-122.881339],[260.088009,-121.807838],[260.615562,-120.981953],[261.532316,-120.284192],[264.644561,-119.250838],[269.647013,-118.663381],[276.761939,-118.477428],[282.973213,-118.338278],[288.459600,-117.927132],[293.189266,-117.253444],[297.130376,-116.326668],[300.251098,-115.156258],[302.519598,-113.751668],[303.904043,-112.122353],[304.372599,-110.277768],[304.622375,-108.897349],[305.336287,-108.051348],[306.461213,-107.772263],[307.944029,-108.092598],[309.330750,-109.090637],[310.466352,-110.794946],[311.233651,-112.966819],[311.515459,-115.367548],[311.887317,-118.275434],[313.101929,-120.558566],[315.307853,-122.395896],[318.653649,-123.966378],[321.942739,-125.456459],[323.915591,-127.018054],[324.699674,-128.806030],[324.422459,-130.975258],[324.311414,-133.090616],[324.976710,-136.013095],[326.335772,-139.586162],[328.306026,-143.653288],[333.749814,-152.643593],[337.058199,-157.253712],[340.647479,-161.731768],[342.251853,-163.354599],[344.121385,-164.791629],[348.467302,-167.096248],[353.307980,-168.621547],[358.266174,-169.343448],[362.964635,-169.237873],[367.026116,-168.280747],[368.700099,-167.475327],[370.073370,-166.447991],[371.098772,-165.195727],[371.729149,-163.715528],[372.263479,-160.282764],[371.990161,-159.457016],[371.324690,-159.227563],[370.243195,-159.596307],[368.721803,-160.565153],[364.263839,-164.310768],[361.072637,-167.131859],[359.522676,-168.141906],[359.266597,-167.981626],[359.304951,-167.385191],[360.110459,-164.905998],[361.647959,-159.444691],[362.903219,-153.001238],[363.957509,-145.858378],[360.950769,-153.425598],[358.351494,-159.237618],[356.324409,-162.584898],[355.714552,-162.850862],[354.987366,-162.615867],[353.272575,-160.857570],[351.363162,-157.739146],[349.442255,-153.689735],[347.692982,-149.138475],[346.298472,-144.514506],[345.441852,-140.246967],[345.306249,-136.764998],[345.963760,-132.897357],[346.511239,-131.489414],[347.262741,-130.365044],[348.261925,-129.473988],[349.552446,-128.765987],[353.182129,-127.698118],[360.324979,-126.183688],[351.991649,-125.865528],[348.864321,-125.602368],[346.819712,-125.124396],[345.991572,-124.483680],[346.513649,-123.732288],[347.122621,-123.033049],[347.707848,-121.758858],[348.761675,-117.719664],[349.584346,-112.082799],[350.085079,-105.316358],[350.801169,-88.715528],[362.110699,-87.989838],[373.420219,-87.264148],[373.420219,-103.886668],[373.256641,-112.360760],[372.636789,-117.588516],[372.095236,-119.242288],[371.366987,-120.393200],[370.427831,-121.144161],[369.253559,-121.598078],[366.277356,-122.570851],[369.253559,-122.963148],[370.871393,-123.279587],[372.196261,-123.937016],[373.091443,-124.839379],[373.420219,-125.890618],[373.657409,-126.423680],[374.332389,-126.827609],[376.776189,-127.275221],[380.312551,-127.287759],[384.502409,-126.919526],[388.906695,-126.224827],[393.086344,-125.257967],[396.602287,-124.073249],[399.015459,-122.724978],[400.370084,-121.783776],[401.294305,-121.568458],[401.823151,-122.086309],[401.991649,-123.344618],[402.119849,-124.408173],[402.468909,-125.035061],[402.985519,-125.177882],[403.616369,-124.789238],[404.300352,-122.611401],[404.961671,-117.882686],[405.914649,-103.559078],[406.073717,-95.316561],[405.882689,-90.083535],[405.343301,-87.877393],[404.943514,-87.914839],[404.457289,-88.715528],[403.572612,-90.423338],[402.866087,-91.241359],[402.380594,-91.143684],[402.159009,-90.104408],[401.879904,-87.923042],[401.375575,-87.173106],[400.706343,-87.694743],[399.932530,-89.328096],[398.312450,-95.290527],[396.997909,-103.781548],[396.271285,-109.502929],[396.011760,-110.419505],[395.810900,-109.970545],[395.436179,-93.477428],[395.823611,-78.328448],[396.304881,-75.017013],[396.596213,-74.687414],[396.913269,-75.341078],[397.872010,-78.347914],[398.308304,-79.161612],[398.777420,-79.534899],[399.325511,-79.482327],[399.998732,-79.018448],[401.905179,-76.914978],[402.693013,-75.631020],[403.421909,-73.761463],[404.686035,-68.362153],[405.663850,-60.910249],[406.321649,-51.598958],[406.718794,-40.521396],[406.483579,-34.090625],[406.078625,-32.243781],[405.455328,-31.109828],[404.593604,-30.539164],[403.473369,-30.382188],[402.418872,-30.514548],[401.564242,-30.952918],[400.891211,-31.759227],[400.381514,-32.995405],[399.779046,-37.005093],[399.610699,-43.477428],[399.422827,-48.562063],[398.911294,-52.725940],[398.154226,-55.539371],[397.708031,-56.305392],[397.229749,-56.572668],[396.751464,-56.310980],[396.305266,-55.560978],[395.548195,-52.806378],[395.036661,-48.729573],[394.848789,-43.751268],[395.058581,-37.063250],[395.867932,-32.630834],[396.581805,-31.009117],[397.546802,-29.649670],[400.365149,-27.315408],[403.130079,-24.983872],[404.126634,-23.590881],[404.906027,-21.939981],[405.933670,-17.545166],[406.453679,-11.160858],[406.632572,-4.693165],[406.306260,-1.309244],[405.899598,-0.601741],[405.301770,-0.458832],[403.446129,-1.591668],[401.981434,-3.529042],[400.639670,-6.607876],[399.569386,-10.404736],[398.919129,-14.496188],[398.499003,-17.989119],[398.334760,-18.561211],[398.200531,-18.347678],[397.955769,-9.596648],[398.119730,-2.013130],[398.769627,2.714579],[399.340815,4.244432],[400.110303,5.344645],[401.103695,6.109988],[402.346599,6.635232],[404.420265,7.765251],[405.781260,9.747397],[406.526664,12.814374],[406.753559,17.198882],[406.526526,20.905826],[405.900121,24.022304],[404.956388,26.268130],[403.777369,27.363122],[402.454314,28.112973],[401.995596,29.335106],[402.397050,31.257753],[403.654509,34.109142],[405.886742,39.566600],[407.246599,44.617813],[407.569739,45.925568],[408.136378,47.023926],[409.004008,47.941006],[410.230125,48.704925],[413.987794,49.885760],[419.869339,50.791383],[425.792755,51.565501],[427.021546,51.832148],[427.179493,51.942104],[427.024295,52.039048],[423.139375,52.335189],[413.713409,52.577093],[395.673409,52.951143],[396.680369,46.090233],[396.865432,43.299002],[396.624929,40.770923],[396.011435,38.784035],[395.077529,37.616383],[393.955322,37.439708],[393.137580,38.458444],[392.637360,40.640882],[392.467719,43.955313],[392.183494,48.016210],[391.164151,50.904380],[390.300685,52.038356],[389.159687,53.034746],[385.920099,54.822233],[376.354502,59.844143],[364.091405,67.232259],[352.066870,75.137779],[343.216959,81.711903],[335.924269,87.853643],[351.695979,88.006023],[368.954564,88.641673],[388.301059,89.956043],[409.134389,91.753783],[409.134389,115.209663],[409.301830,125.278407],[409.794756,132.629836],[410.599071,137.135149],[411.113594,138.280261],[411.700679,138.665543],[412.290802,138.277353],[412.790877,137.116706],[413.518795,132.501581],[413.880250,124.867247],[413.871059,114.260783],[413.627711,96.238847],[413.954444,87.281529],[414.467903,85.216113],[415.287459,84.233665],[416.467636,83.939790],[418.062959,83.940093],[419.646909,84.073265],[420.429001,84.426179],[420.395607,84.982480],[419.533099,85.725813],[418.892255,86.715081],[418.315048,88.710526],[417.363148,95.114611],[416.700598,103.727392],[416.350596,113.338193],[416.336342,122.736338],[416.681035,130.711154],[417.407874,136.051964],[417.921848,137.356280],[418.540059,137.548093],[419.069438,136.781075],[419.550618,135.207119],[420.340782,129.913183],[420.855358,122.215856],[421.039149,112.664713],[421.136452,99.368100],[421.347151,95.267452],[421.745054,92.535368],[422.389539,90.924439],[423.339987,90.187260],[424.655777,90.076424],[426.396289,90.344523],[428.114156,90.748079],[429.407820,91.393304],[430.326184,92.542244],[430.918150,94.456948],[431.232620,97.399462],[431.318497,101.631836],[431.000079,115.014353],[430.832995,125.305052],[431.076817,132.702349],[431.728698,137.168445],[432.206770,138.290481],[432.785789,138.665543],[433.362590,138.268920],[433.869765,137.093176],[434.666256,132.488518],[435.157314,125.019962],[435.324989,114.855903],[435.324989,91.046383],[441.417889,91.046383],[443.715180,90.864256],[445.337400,90.362299],[446.155209,89.607143],[446.039269,88.665423],[445.930522,88.142051],[446.283979,87.691016],[448.313021,87.017503],[451.997437,86.667974],[457.208269,86.665523],[464.828769,87.189251],[465.114286,87.364951],[464.755326,87.559477],[462.110699,88.006853],[454.372599,88.967143],[454.372599,108.913853],[453.848046,123.327780],[453.280246,127.966692],[452.586889,129.972263],[452.244027,129.811279],[451.954806,128.918224],[451.553842,125.226556],[451.417110,119.478582],[451.577719,112.255623],[451.749354,104.110233],[451.505086,98.216171],[450.850707,94.634763],[450.371536,93.730468],[449.792009,93.427333],[449.266546,93.655504],[448.765612,94.310614],[447.882356,96.725210],[447.232302,100.318247],[446.905509,104.736853],[446.401106,110.975696],[446.033327,111.512808],[445.643699,110.094003],[444.233143,102.296112],[442.889013,97.086683],[441.641276,94.433619],[441.062921,94.055694],[440.519902,94.304823],[439.554860,96.668195],[438.776118,101.491639],[438.213645,108.743058],[437.897409,118.390353],[437.901714,127.982576],[438.265244,135.098118],[438.968291,139.523784],[439.440975,140.661291],[439.991149,141.046383],[440.955683,140.435797],[441.751025,138.773314],[442.294714,136.312840],[442.504289,133.308283],[442.703694,130.021918],[443.220932,126.794146],[443.977292,123.996063],[444.894059,121.998763],[445.880649,121.044177],[446.190921,121.267436],[446.380774,121.969315],[446.404011,124.843699],[445.959939,129.736853],[445.589646,134.477814],[445.672774,138.035038],[446.194906,140.270551],[446.616095,140.849550],[447.141629,141.046383],[448.106026,140.717606],[448.906666,139.822424],[449.460155,138.497553],[449.683099,136.879713],[449.777719,134.647566],[450.091867,133.903518],[450.826449,134.647566],[452.182369,136.879713],[453.585012,138.497553],[455.610090,139.822424],[457.986538,140.717606],[460.443289,141.046383],[462.708551,141.234255],[464.563606,141.745788],[465.817023,142.502855],[466.277369,143.427333],[465.322142,143.966318],[462.493665,144.441007],[451.440171,145.188164],[433.563317,145.650143],[409.309529,145.808283],[379.355878,145.995392],[358.376365,146.710966],[342.476529,148.186371],[327.761909,150.652973],[312.325273,153.822870],[300.042097,156.622541],[290.934017,159.042771],[285.022671,161.074343],[283.272535,161.941501],[282.329696,162.708039],[282.196859,163.372804],[282.876729,163.934644],[286.685408,164.744940],[293.777369,165.129713],[301.636588,165.322810],[304.761624,165.631366],[304.674688,165.889770],[303.555244,166.250031],[298.420219,167.373453],[289.711700,168.859999],[282.726860,169.343448],[277.343677,168.823448],[275.214575,168.187047],[273.440129,167.299653]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[343.658319,143.427333],[343.936790,142.502855],[343.607210,141.745788],[342.743076,141.234255],[341.417889,141.046383],[339.976609,141.234255],[338.796325,141.745788],[337.998835,142.502855],[337.705939,143.427333],[337.882722,144.351810],[338.364064,145.108878],[339.076450,145.620410],[339.946369,145.808283],[340.932395,145.620410],[341.960927,145.108878],[343.658319,143.427333]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[427.900439,119.022573],[427.667092,109.570330],[427.249494,104.010765],[426.966884,102.657296],[426.632552,102.236867],[426.244613,102.736101],[425.801179,104.141623],[424.901309,108.821741],[424.258545,114.454817],[423.744334,126.635625],[423.872887,132.211252],[424.258545,136.795622],[424.901309,139.902684],[425.319106,140.750332],[425.801179,141.046383],[426.310638,140.644860],[426.758890,139.473091],[427.453014,135.015621],[427.846035,128.067580],[427.900439,119.022573]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[338.989769,93.917523],[338.103051,93.253448],[337.432586,93.345531],[336.969649,94.326978],[336.705516,96.330993],[336.738770,103.939551],[337.462559,117.236853],[338.896409,139.855903],[339.585009,117.528643],[339.694237,101.382878],[339.433959,96.177779],[338.989769,93.917523]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[349.610699,118.567853],[349.422827,110.648231],[348.911294,103.941684],[348.154226,99.155948],[347.708031,97.704553],[347.229749,96.998763],[346.690927,97.027638],[346.216313,97.805755],[345.469126,101.530270],[345.007010,108.013424],[344.848789,117.096333],[345.022237,125.863166],[345.509731,132.677911],[346.261994,137.094140],[346.722015,138.263301],[347.229749,138.665423],[347.733796,138.286293],[348.192085,137.186109],[348.944946,133.045789],[349.435446,126.690893],[349.610699,118.567853]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[356.753559,118.567853],[356.565686,110.648231],[356.054152,103.941684],[355.297082,99.155948],[354.850884,97.704553],[354.372599,96.998763],[353.833777,97.027638],[353.359165,97.805755],[352.611981,101.530270],[352.149869,108.013424],[351.991649,117.096333],[352.165097,125.863166],[352.652590,132.677911],[353.404850,137.094140],[353.864868,138.263301],[354.372599,138.665423],[354.876649,138.286293],[355.334941,137.186109],[356.087805,133.045789],[356.578306,126.690893],[356.753559,118.567853]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[363.896409,118.427383],[363.728628,110.569306],[363.271799,104.134223],[362.595692,99.786194],[362.197213,98.602345],[361.770079,98.189282],[361.337137,98.602345],[360.922015,99.786194],[360.184781,104.134223],[359.637481,110.569306],[359.359219,118.427383],[359.413363,126.761578],[359.810081,133.143755],[360.512946,137.227269],[360.967799,138.298700],[361.485529,138.665473],[362.002019,138.291015],[362.468936,137.200923],[363.230264,133.073499],[363.721944,126.682539],[363.896409,118.427383]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[373.918529,115.451193],[374.416839,92.236903],[375.197269,115.620193],[375.714515,126.397989],[376.456431,133.467589],[377.485856,137.212651],[378.128022,137.958373],[378.865629,138.016833],[379.630994,137.253419],[380.273498,135.614150],[381.200829,130.220497],[381.669440,122.860772],[381.701152,114.559874],[381.317784,106.342703],[380.541155,99.234158],[379.393083,94.259138],[378.686575,92.891981],[377.895389,92.442543],[374.606015,92.792781],[372.026321,93.474017],[370.084388,94.620953],[368.708300,96.368298],[367.826138,98.850754],[367.365984,102.203028],[367.424029,112.055853],[368.409529,133.308333],[368.694033,135.388411],[369.284670,137.091814],[370.095171,138.242761],[371.039269,138.665472],[371.550257,138.224020],[372.034819,136.944651],[372.891185,132.142091],[373.541408,124.797652],[373.918529,115.451192]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[389.849559,120.072573],[389.561157,111.078031],[389.047998,104.332327],[388.387101,99.915962],[387.655490,97.909435],[387.287235,97.835017],[386.930185,98.393247],[386.288207,101.447897],[385.806578,107.153885],[385.562319,115.591713],[385.617532,125.480859],[386.002655,132.520964],[386.703515,136.567266],[387.167917,137.422502],[387.705939,137.475003],[388.179376,136.854252],[388.611687,135.646589],[389.317764,131.756035],[389.753832,126.374358],[389.849559,120.072573]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[399.170839,116.835093],[398.657521,107.125663],[397.872746,100.132001],[396.805315,95.785523],[396.162104,94.583544],[395.444029,94.017643],[394.672283,94.036931],[394.032915,94.697070],[393.516839,96.064708],[393.114970,98.206491],[392.617507,105.079083],[392.467839,115.848023],[392.611048,127.478525],[393.160299,134.425881],[393.643262,136.486686],[394.295022,137.788671],[395.138008,138.469159],[396.194649,138.665473],[397.257492,138.487949],[398.084729,137.861905],[398.695474,136.647134],[399.108842,134.703428],[399.419907,128.068378],[399.170839,116.835093]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[405.870559,117.259353],[405.447093,107.678637],[404.887150,100.728420],[404.250196,96.433379],[403.595700,94.818193],[403.280457,95.023256],[402.983129,95.907538],[402.471952,99.726093],[402.121636,106.298535],[401.991649,115.649543],[402.165959,124.730452],[402.645574,132.032753],[403.365518,136.897418],[403.795310,138.209692],[404.260819,138.665423],[404.724370,138.255932],[405.122639,137.070330],[405.703991,132.628001],[405.966192,125.852855],[405.870559,117.259313]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[303.182129,133.903523],[303.554529,132.979045],[303.480701,132.221978],[302.995097,131.710445],[302.132169,131.522573],[301.153133,131.710445],[300.351384,132.221978],[299.809660,132.979045],[299.610699,133.903523],[299.919119,135.585068],[300.660649,136.284473],[301.834441,135.585068],[303.182129,133.903523]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[323.420219,132.713043],[322.607977,131.915177],[321.143625,131.245362],[316.961249,130.369283],[312.278413,130.243608],[310.188485,130.511799],[308.500439,131.027143],[307.906633,131.532743],[307.638599,132.299913],[307.708537,133.224470],[308.128649,134.202233],[309.395086,135.148597],[311.538271,135.703949],[314.211974,135.902008],[317.069965,135.776491],[319.766015,135.361118],[321.953893,134.689606],[323.287371,133.795675],[323.525513,133.275839],[323.420219,132.713043]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[332.944029,117.236853],[332.772781,109.841019],[332.306511,103.784471],[331.616430,99.692209],[331.209714,98.577997],[330.773749,98.189233],[329.994010,98.518009],[329.475296,99.413191],[329.262646,100.738062],[329.401099,102.355903],[330.017952,109.669894],[330.380909,121.403523],[330.859285,131.913193],[331.276947,135.110272],[331.753559,136.284473],[332.215797,134.781496],[332.594329,130.689234],[332.944029,117.236853]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[296.039269,126.760663],[296.411670,125.836185],[296.337846,125.079118],[295.852246,124.567585],[294.989319,124.379713],[294.010277,124.567585],[293.208525,125.079118],[292.666800,125.836185],[292.467839,126.760663],[292.776262,128.442216],[293.517789,129.141623],[294.691585,128.442216],[296.039269,126.760663]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[304.372599,124.379713],[304.184727,123.455235],[303.673194,122.698168],[302.916126,122.186635],[301.991649,121.998763],[301.067172,122.186635],[300.310104,122.698168],[299.798571,123.455235],[299.610699,124.379713],[299.798571,125.304190],[300.310104,126.061258],[301.067172,126.572790],[301.991649,126.760663],[302.916126,126.572790],[303.673194,126.061258],[304.184727,125.304190],[304.372599,124.379713]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[328.182129,124.424913],[327.968327,123.438752],[327.362232,122.571141],[325.185033,121.198084],[322.074267,120.318768],[318.453669,119.946223],[314.746974,120.093476],[311.377919,120.773556],[308.770239,121.999492],[307.884332,122.821228],[307.347669,123.784313],[307.259345,124.512883],[307.525275,125.131985],[309.170557,126.056979],[312.384838,126.589687],[317.269439,126.760503],[321.506628,126.576279],[324.976522,126.074526],[327.321048,125.331895],[327.959399,124.894202],[328.182129,124.425033]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[294.094289,114.409313],[293.564951,113.442740],[293.132879,113.376173],[292.821894,114.185800],[292.655819,115.847813],[292.945637,118.648218],[293.362638,119.171262],[293.906339,118.972813],[294.366200,118.167680],[294.554912,117.038894],[294.094199,114.409313]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[304.372599,114.996383],[304.184727,114.010357],[303.673194,112.981824],[301.991649,111.284433],[301.067172,111.005961],[300.310104,111.335541],[299.798571,112.199675],[299.610699,113.524863],[299.798571,114.966142],[300.310104,116.146426],[301.067172,116.943916],[301.991649,117.236813],[302.916126,117.060029],[303.673194,116.578688],[304.184727,115.866301],[304.372599,114.996383]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[325.801169,109.092673],[325.562529,104.773132],[325.187670,103.261684],[324.574399,102.089276],[323.671677,101.186028],[322.428464,100.482059],[318.716409,99.392433],[313.751807,98.744893],[311.706906,98.831545],[309.983511,99.182565],[308.604050,99.791018],[307.590952,100.649969],[306.966645,101.752482],[306.753559,103.091623],[307.306085,103.961541],[308.810490,104.673928],[311.037012,105.155269],[313.755889,105.332053],[316.590875,105.519925],[319.133546,106.031458],[321.105854,106.788525],[322.229749,107.713003],[322.387130,108.222132],[322.214235,108.682808],[320.948069,109.434843],[318.572157,109.921198],[315.227409,110.093963],[311.395314,110.299645],[308.761101,110.940069],[307.241579,112.050294],[306.753559,113.665383],[306.880667,114.559401],[307.274392,115.311586],[308.936097,116.418358],[311.887486,117.041499],[316.277369,117.236813],[321.669873,117.077217],[323.357853,116.746692],[324.509856,116.132545],[325.228036,115.147423],[325.614545,113.703972],[325.801169,109.092673]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[304.372599,102.951103],[304.184727,102.026625],[303.673194,101.269558],[302.916126,100.758025],[301.991649,100.570153],[301.067172,100.758025],[300.310104,101.269558],[299.798571,102.026625],[299.610699,102.951103],[299.798571,103.875580],[300.310104,104.632648],[301.067172,105.144180],[301.991649,105.332053],[302.916126,105.144180],[303.673194,104.632648],[304.184727,103.875580],[304.372599,102.951103]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[287.436479,81.522533],[287.182789,64.855863],[275.539599,64.855863],[263.896409,64.855863],[263.896409,79.935223],[264.362681,91.051300],[264.867396,94.795716],[265.483719,96.601883],[266.913520,97.218209],[269.633179,97.722924],[277.380599,98.189193],[287.690169,98.189193],[287.436479,81.522533]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[320.067599,85.689193],[319.610363,80.357244],[319.227418,78.580331],[318.680746,77.295585],[317.924717,76.427600],[316.913698,75.900970],[313.944169,75.570153],[311.423342,75.824205],[309.459619,76.495682],[308.098282,77.448567],[307.384615,78.546841],[307.363900,79.654486],[308.081418,80.635483],[309.582454,81.353815],[311.912289,81.673463],[317.467839,81.824413],[312.110699,83.977723],[308.722318,85.468933],[307.734861,86.131089],[307.163021,86.852103],[306.965145,87.717844],[307.099580,88.814182],[308.198769,92.042123],[309.191679,93.504463],[310.826806,94.701986],[312.877182,95.511120],[315.115839,95.808293],[318.036071,95.509728],[318.973499,95.011318],[319.616929,94.168865],[320.007208,92.898900],[320.185182,91.117954],[320.067599,85.689243]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[302.852669,89.855863],[303.202826,88.469146],[303.143117,87.333543],[302.704252,86.566242],[301.916939,86.284433],[301.021470,86.566242],[300.288157,87.333543],[299.792676,88.469146],[299.610699,89.855863],[299.885575,92.378186],[300.183111,93.145485],[300.546439,93.427293],[301.609884,92.378186],[302.852669,89.855863]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[303.080529,79.306103],[303.421482,78.327490],[303.337170,77.301429],[302.862050,76.349716],[302.030579,75.594153],[301.091022,75.306355],[300.321604,75.628293],[299.801726,76.487268],[299.610789,77.810583],[299.865917,80.273039],[300.580276,81.365101],[301.085749,81.386927],[301.677327,81.053785],[303.080529,79.306103]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[342.864199,72.942193],[342.215534,70.130128],[341.430762,68.045406],[340.578490,66.704270],[339.727327,66.122965],[338.945883,66.317735],[338.302764,67.304823],[337.866580,69.100474],[337.705939,71.720933],[337.891412,75.080461],[338.448549,77.328141],[339.378428,78.466420],[340.682129,78.497743],[341.775055,77.737422],[342.550755,76.436529],[342.937634,74.777355],[342.864099,72.942193]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[327.481579,57.117813],[327.080941,55.883157],[326.752851,56.481649],[326.449749,62.474953],[326.752851,68.468256],[327.080941,69.066748],[327.481579,67.832093],[327.907219,62.474949],[327.481579,57.117813]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[303.272599,51.215733],[304.155145,48.603747],[304.789760,47.728299],[305.609970,47.109414],[307.977277,46.549920],[311.597269,46.742453],[314.468809,46.917462],[316.995124,46.777905],[318.903131,46.358414],[319.919749,45.693623],[320.256308,44.345008],[319.811098,42.888464],[318.735079,41.432596],[317.179211,40.086010],[315.294457,38.957311],[313.231776,38.155104],[311.142129,37.787996],[309.176479,37.964593],[306.609526,38.303770],[305.764489,37.976541],[305.160045,37.213320],[304.517835,34.064566],[304.372699,28.228833],[303.876697,21.490146],[303.309158,19.242972],[302.575225,17.803051],[301.709874,17.214740],[300.748080,17.522395],[299.724816,18.770370],[298.675059,21.003023],[297.577500,25.827194],[297.285085,31.490191],[297.772110,36.572551],[298.299879,38.452411],[299.012869,39.654813],[299.676599,41.505883],[300.165719,45.227860],[300.433629,56.123073],[300.476725,64.396284],[300.722533,65.280107],[301.089169,63.665423],[303.272599,51.215733]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[321.039269,64.751523],[320.790842,62.679712],[320.050159,61.289778],[318.824113,60.589048],[317.119599,60.584853],[315.515556,60.621662],[314.045650,60.204705],[312.872641,59.408679],[312.159289,58.308283],[312.102639,57.092889],[312.813011,56.153198],[314.211564,55.547001],[316.219459,55.332093],[318.083917,55.144220],[319.389681,54.632688],[320.017667,53.875620],[319.848789,52.951143],[318.669655,51.680048],[317.117286,50.888325],[315.351876,50.549760],[313.533622,50.638141],[311.822722,51.127254],[310.379370,51.990886],[309.363763,53.202823],[308.936099,54.736853],[308.143529,64.260663],[308.111902,66.968594],[308.401308,67.904528],[308.940652,68.602239],[310.908538,69.404383],[314.294319,69.617813],[317.544448,69.385625],[319.618999,68.593123],[320.717447,67.096392],[321.039269,64.751523]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[295.204289,32.117813],[294.701342,28.188774],[293.949202,24.971233],[293.049589,22.797218],[292.576266,22.205294],[292.104219,21.998763],[291.672305,22.423310],[291.299317,23.627143],[290.729446,27.953804],[290.289445,41.351094],[290.773505,55.488883],[291.358712,60.741169],[292.170919,63.665423],[292.542416,63.973015],[292.912192,63.742365],[293.627264,61.867194],[294.824295,53.867370],[295.453001,42.879669],[295.204369,32.117813]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[368.931339,58.525123],[374.843821,55.044026],[378.387229,52.113215],[379.442113,50.660998],[380.110627,49.114548],[380.563079,45.429883],[380.317419,41.590349],[379.801518,40.391038],[378.837945,39.574243],[377.287483,39.066624],[375.010913,38.794841],[367.722579,38.665423],[362.921447,38.758272],[359.203112,39.134313],[356.431143,39.939781],[354.469106,41.320914],[353.180571,43.423948],[352.429104,46.395122],[352.078274,50.380671],[351.991649,55.526833],[352.195429,59.208583],[352.756229,62.168330],[353.598233,64.139596],[354.100995,64.671274],[354.645629,64.855903],[356.593936,64.356363],[359.936824,62.996233],[368.931339,58.525123]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[254.372599,47.296383],[253.957375,36.181936],[252.959079,27.431093],[252.018475,23.869716],[251.444552,22.696112],[250.744132,21.879221],[249.874152,21.383038],[248.791549,21.171555],[245.816219,21.458663],[243.998202,21.877076],[242.611376,22.481907],[241.597553,23.474911],[240.898545,25.057842],[240.456163,27.432457],[240.212218,30.800511],[240.086889,41.323953],[240.086889,60.094002],[247.229749,60.094002],[251.320278,59.870803],[252.588186,59.375559],[253.445137,58.432335],[253.971593,56.896968],[254.248015,54.625296],[254.372599,47.296382]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[287.679719,51.165423],[287.227740,42.236856],[286.177719,33.308283],[285.140743,28.189193],[284.452005,26.604060],[283.460226,25.533775],[282.023250,24.877268],[279.998921,24.533468],[273.619579,24.379713],[262.537219,24.379713],[263.305099,39.260663],[264.141489,51.177468],[264.819892,54.874957],[265.875199,57.376529],[267.459983,58.915701],[269.726818,59.725992],[272.828279,60.040920],[276.916939,60.094003],[287.705939,60.094003],[287.679739,51.165423]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[347.193289,49.974953],[346.991716,47.921617],[346.455993,46.131907],[345.609517,44.625113],[344.475682,43.420530],[343.077885,42.537450],[341.439520,41.995167],[339.583983,41.812974],[337.534669,42.010163],[330.563079,43.266093],[330.426536,43.419783],[330.626384,43.759732],[331.868813,44.890257],[336.559545,48.196780],[341.972282,51.455299],[344.117216,52.525819],[345.444029,52.935453],[346.134510,52.707282],[346.694480,52.072790],[347.193289,49.974953]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[388.312199,47.594003],[388.596740,46.062657],[388.546710,44.093255],[388.187322,41.939702],[387.543789,39.855903],[386.305785,36.972870],[385.867864,36.397260],[385.496270,36.460397],[384.788885,38.687345],[383.857269,44.022573],[383.653952,46.279812],[383.802476,48.127620],[384.235517,49.512024],[384.885754,50.379054],[385.685863,50.674738],[386.568522,50.345105],[387.466408,49.336183],[388.312199,47.594002]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[344.377979,20.213043],[345.097649,7.713043],[330.885909,7.713043],[325.304047,7.904192],[320.611680,8.424650],[317.301625,9.194929],[316.318970,9.648912],[315.866699,10.135543],[315.548340,15.014284],[315.916899,23.342193],[316.774589,34.126333],[330.216439,33.419693],[343.658279,32.713043],[344.377939,20.213043]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[379.117869,30.137353],[379.679023,27.844969],[380.138554,24.387390],[380.563079,15.851643],[380.563079,5.332093],[366.277369,5.332093],[351.991649,5.332093],[351.991649,18.030503],[352.457921,27.465035],[352.962636,30.697918],[353.578959,32.316213],[355.083219,32.932535],[358.005611,33.437250],[366.419459,33.903523],[371.660373,33.694629],[375.404644,33.032626],[377.830924,31.864529],[378.605648,31.074137],[379.117869,30.137353]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[387.705939,17.236853],[387.519928,11.656499],[387.011497,7.117810],[386.255047,4.067214],[385.807065,3.239461],[385.324979,2.951143],[384.842896,3.239461],[384.394916,4.067214],[383.638469,7.117810],[383.130039,11.656499],[382.944029,17.236853],[383.130039,22.817207],[383.638469,27.355900],[384.394916,30.406499],[384.842896,31.234253],[385.324979,31.522573],[385.807065,31.234253],[386.255047,30.406499],[387.011497,27.355900],[387.519928,22.817207],[387.705939,17.236853]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[395.223439,16.273003],[394.736195,11.202484],[394.012645,7.250746],[393.150445,4.811375],[392.697868,4.281821],[392.247249,4.277953],[391.422984,5.714528],[390.788300,8.583423],[390.133967,16.760676],[390.376828,25.094715],[390.863636,28.159592],[391.609459,29.870543],[392.742820,30.755499],[393.674044,30.929791],[394.406825,30.379514],[394.944859,29.090766],[395.451469,24.242245],[395.223439,16.273003]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[285.324979,1.901192],[284.800426,-10.893235],[284.232626,-15.004849],[283.539269,-16.775618],[282.047454,-17.064040],[279.305637,-17.139526],[271.634509,-16.666098],[261.515459,-15.596358],[261.515459,0.423402],[261.981731,12.203625],[262.486446,16.150081],[263.102769,18.030452],[264.533191,18.646775],[267.254541,19.151490],[275.007529,19.617762],[285.324979,19.617762],[285.324979,1.901142]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[296.654959,1.571692],[296.744969,-3.763222],[296.532404,-8.357920],[296.038312,-12.152795],[295.283741,-15.088240],[294.289739,-17.104649],[293.077355,-18.142417],[291.667635,-18.141935],[290.081629,-17.043598],[289.507772,-16.082460],[289.078911,-14.556586],[288.621181,-10.164663],[288.638459,-4.575891],[289.060765,1.501667],[289.818119,7.359951],[290.840541,12.290896],[292.058051,15.586440],[292.718095,16.399668],[293.400669,16.538522],[293.943277,16.076023],[294.473775,15.088362],[295.445046,11.783105],[296.207701,7.113849],[296.654959,1.571693]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[251.991649,-0.778428],[251.991649,-16.412767],[245.444029,-15.659378],[241.936991,-14.992808],[240.799105,-14.421648],[240.002575,-13.584916],[239.495602,-12.402370],[239.226386,-10.793768],[239.194029,-5.977427],[239.680281,6.241017],[240.017203,9.951073],[240.529972,12.406559],[241.303577,13.866129],[242.423002,14.588440],[243.973237,14.832146],[246.039269,14.855903],[247.944444,14.803012],[249.392949,14.534973],[250.447244,13.887729],[251.169789,12.697229],[251.623042,10.799417],[251.869463,8.030239],[251.991649,-0.778427]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[303.890979,-2.217027],[303.427868,-7.983966],[302.690942,-12.825234],[301.781583,-16.232833],[301.293921,-17.240258],[300.801169,-17.698767],[300.288802,-17.602033],[299.861150,-16.960358],[299.270301,-14.137919],[299.049251,-9.422909],[299.218629,-3.006787],[299.709437,3.004479],[300.455591,7.927189],[301.355710,11.253345],[301.831823,12.158967],[302.308409,12.474952],[302.765226,12.184727],[303.159245,11.348715],[303.736489,8.247320],[303.995335,3.586747],[303.890979,-2.217027]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[341.999909,-11.852498],[342.223018,-17.947197],[342.069030,-19.995765],[341.680906,-21.521399],[341.015816,-22.631289],[340.030928,-23.432627],[336.930439,-24.538408],[330.831980,-25.335618],[324.303149,-25.210958],[320.492611,-24.482771],[319.252569,-23.790882],[318.357315,-22.705378],[317.732824,-21.094942],[317.305074,-18.828262],[316.743699,-11.800908],[316.019579,0.827972],[328.648459,0.103852],[341.277369,-0.620288],[341.999909,-11.852498]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[380.090439,-10.516858],[380.170921,-15.040236],[379.672844,-18.824503],[378.568955,-21.896799],[376.832001,-24.284263],[374.434732,-26.014034],[371.349895,-27.113254],[367.550238,-27.609062],[363.008509,-27.528598],[353.182129,-26.810767],[352.441529,-15.136358],[352.335920,-10.491289],[352.595845,-6.473936],[353.169940,-3.513984],[354.006839,-2.041118],[355.811960,-1.494975],[359.022301,-1.058271],[367.842679,-0.690478],[379.372599,-0.760678],[380.090439,-10.516888]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[387.705939,-13.715528],[387.518066,-18.337923],[387.006532,-22.123265],[386.249462,-24.680928],[385.803264,-25.377310],[385.324979,-25.620288],[384.846697,-25.377310],[384.400502,-24.680928],[383.643434,-22.123265],[383.131901,-18.337923],[382.944029,-13.715528],[383.131901,-9.093132],[383.643434,-5.307790],[384.400502,-2.750127],[384.846697,-2.053745],[385.324979,-1.810767],[385.803264,-2.053745],[386.249462,-2.750127],[387.006532,-5.307790],[387.518066,-9.093132],[387.705939,-13.715528]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[392.778979,-16.327688],[390.643579,-29.191717],[390.365219,-17.088548],[390.634917,-8.074403],[391.079837,-4.969403],[391.674199,-3.398077],[392.664963,-2.570244],[393.404504,-2.351714],[393.896625,-2.786984],[394.145126,-3.920550],[393.926480,-8.460552],[392.778979,-16.327688]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[251.510459,-34.249497],[251.752358,-41.003789],[251.604982,-43.210725],[251.211005,-44.806404],[250.519638,-45.917487],[249.480094,-46.670638],[246.153319,-47.609787],[242.695401,-48.011975],[241.619239,-47.660245],[240.888959,-46.749131],[240.437571,-45.135509],[240.198089,-42.676253],[240.086889,-34.648338],[240.215347,-26.856685],[240.453305,-24.395411],[240.875871,-22.718955],[241.534636,-21.698652],[242.481190,-21.205839],[243.767124,-21.111852],[245.444029,-21.288027],[248.265730,-22.103474],[249.243287,-22.888768],[249.989060,-24.047728],[250.956482,-27.852498],[251.510459,-34.249497]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[285.324979,-31.572667],[285.152763,-35.732826],[284.683859,-39.139635],[283.989879,-41.441533],[283.580866,-42.068277],[283.142439,-42.286957],[282.120910,-42.803604],[280.952904,-44.210317],[279.782438,-46.292256],[278.753529,-48.834577],[277.463708,-52.471436],[276.610789,-53.811845],[276.239385,-53.653829],[275.846669,-52.961238],[274.823249,-50.025047],[273.788302,-47.874740],[272.287580,-46.179140],[270.473345,-45.067209],[268.497859,-44.667907],[266.287132,-45.015693],[264.871134,-46.196800],[264.118135,-48.417853],[263.896409,-51.885477],[264.133537,-54.709366],[264.805353,-57.055771],[265.852506,-58.885791],[267.215644,-60.160520],[268.835415,-60.841055],[270.652467,-60.888492],[272.607449,-60.263928],[274.641009,-58.928457],[276.617097,-57.739830],[278.539457,-57.418272],[280.343440,-57.897035],[281.964396,-59.109369],[283.337677,-60.988524],[284.398634,-63.467752],[285.082618,-66.480303],[285.324979,-69.959428],[285.324979,-78.001238],[273.420219,-78.001238],[261.515459,-78.001238],[261.515459,-50.794857],[261.702295,-33.623461],[262.242451,-28.419943],[263.352975,-24.968225],[264.186002,-23.781404],[265.238274,-22.891069],[268.102754,-21.811235],[272.150824,-21.351484],[277.586889,-21.134577],[282.012631,-21.166084],[283.385963,-21.533973],[284.315192,-22.292549],[284.887015,-23.558759],[285.188124,-25.449550],[285.324979,-31.572667]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[303.215289,-36.536578],[302.911131,-44.374953],[302.527012,-46.953846],[302.001165,-48.613151],[301.343313,-49.333327],[300.563179,-49.094830],[299.670486,-47.878118],[298.674959,-45.663648],[298.042366,-43.295048],[297.599219,-40.180826],[297.274004,-32.901820],[297.684801,-26.199238],[298.161670,-23.805546],[298.817099,-22.445688],[299.873732,-21.655949],[300.776581,-21.566361],[301.530130,-22.191291],[302.138864,-23.545106],[302.939824,-28.496864],[303.215339,-36.536578]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[294.331529,-49.831048],[293.836455,-61.678848],[293.098333,-70.197110],[292.211866,-75.372152],[291.742598,-76.701690],[291.271757,-77.190293],[290.811182,-76.836249],[290.372711,-75.637850],[289.609430,-70.701145],[289.076618,-62.366494],[288.868979,-50.620218],[289.007476,-37.553847],[289.508870,-29.118126],[289.920872,-26.410252],[290.453860,-24.588231],[291.117924,-23.561460],[291.923149,-23.239338],[292.730611,-23.540393],[293.375615,-24.508953],[293.867045,-26.243109],[294.213785,-28.840954],[294.508732,-37.020074],[294.331529,-49.831048]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[313.199409,-42.854428],[312.793568,-44.193794],[312.613277,-44.227515],[312.453997,-43.859895],[312.115889,-38.715528],[312.400255,-33.205135],[312.734455,-32.475046],[313.151369,-33.330618],[313.612429,-37.835542],[313.199469,-42.854428]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[339.440319,-33.833048],[340.102160,-36.010300],[340.491301,-41.381394],[340.464129,-62.054237],[340.086889,-80.631048],[327.586889,-79.911378],[315.086889,-79.191718],[315.925579,-56.572668],[316.796216,-40.139980],[317.277677,-34.784677],[317.711749,-32.394527],[318.789220,-32.032169],[321.165651,-31.879627],[328.153817,-32.094174],[335.353092,-32.818527],[337.993408,-33.303244],[339.440319,-33.833048]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[318.658319,-63.574997],[318.837664,-66.503443],[319.351845,-68.886293],[320.165083,-70.696568],[321.241599,-71.907293],[322.545612,-72.491487],[324.041342,-72.422175],[325.693011,-71.672377],[327.464839,-70.215118],[328.883390,-68.281503],[329.651058,-66.103608],[329.815544,-63.836190],[329.424547,-61.634003],[328.525771,-59.651801],[327.166915,-58.044342],[325.395680,-56.966379],[323.259769,-56.572668],[321.062162,-56.916738],[319.644706,-58.073718],[318.884419,-60.230754],[318.658319,-63.574997]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[378.464219,-36.929808],[378.646660,-40.501331],[378.552706,-44.581038],[377.026579,-63.767268],[375.496749,-81.676168],[363.148959,-80.433928],[350.801169,-79.191718],[350.119719,-55.977428],[349.438269,-32.763148],[363.810199,-32.763148],[371.126240,-32.925249],[375.546226,-33.542640],[376.886307,-34.083516],[377.761703,-34.811950],[378.258860,-35.752521],[378.464219,-36.929808]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[355.959909,-60.540928],[355.027927,-61.968225],[354.492225,-63.853490],[354.326093,-66.018835],[354.502817,-68.286373],[354.995690,-70.478214],[355.777998,-72.416473],[356.823031,-73.923260],[358.104079,-74.820688],[360.261411,-75.358476],[362.112106,-75.254841],[363.612987,-74.577773],[364.720880,-73.395263],[365.392609,-71.775299],[365.584998,-69.785874],[365.254873,-67.494976],[364.359059,-64.970598],[362.311472,-61.321192],[361.286136,-60.138056],[360.253635,-59.379394],[359.209365,-59.042777],[358.148723,-59.125780],[357.067105,-59.625972],[355.959909,-60.540928]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[387.193979,-57.167908],[386.744257,-66.984513],[386.036495,-74.706609],[385.142607,-79.760544],[384.648340,-81.107686],[384.134509,-81.572668],[382.982002,-81.037198],[382.067614,-79.455095],[381.394116,-76.862822],[380.964277,-73.296840],[380.846664,-63.389593],[381.736939,-50.025048],[382.703628,-41.683936],[383.728610,-36.163820],[384.742088,-33.373340],[385.222701,-32.973164],[385.674264,-33.221138],[386.455339,-35.615852],[387.015515,-40.466125],[387.284994,-47.680597],[387.193979,-57.167908]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[391.770839,-52.378238],[391.364998,-53.717604],[391.184707,-53.751325],[391.025427,-53.383705],[390.687319,-48.239338],[390.971684,-42.728945],[391.305880,-41.998856],[391.722789,-42.854428],[392.183856,-47.359353],[391.770889,-52.378238]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[251.991649,-66.096477],[251.814937,-71.200645],[251.520806,-72.876612],[251.024386,-74.072669],[250.276851,-74.866940],[249.229372,-75.337550],[246.039269,-75.620288],[242.969459,-75.350839],[241.926992,-74.941691],[241.161079,-74.285293],[240.632915,-73.333418],[240.303698,-72.037843],[240.086889,-68.222688],[240.267401,-64.855660],[240.849452,-62.789475],[241.893817,-61.914219],[243.461269,-62.119978],[244.875062,-62.352803],[246.230057,-62.029533],[247.372456,-61.219933],[248.148459,-59.993767],[249.730943,-57.015524],[250.387370,-56.685104],[250.942930,-57.109701],[251.718479,-60.171589],[251.991649,-66.096477]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[302.491389,-73.294717],[301.920946,-76.046654],[301.136720,-78.300247],[300.242096,-79.822943],[299.340459,-80.382187],[298.514292,-79.728658],[297.888592,-77.985300],[297.274926,-72.532481],[297.572116,-66.630493],[298.084987,-64.325673],[298.852819,-62.886098],[299.842310,-62.238965],[300.733599,-62.304539],[301.499405,-63.004783],[302.112449,-64.261657],[302.771126,-68.133151],[302.491389,-73.294717]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[251.991649,-96.016527],[251.875448,-103.580974],[251.620313,-105.903688],[251.136146,-107.439874],[250.349691,-108.329392],[249.187690,-108.712100],[245.444029,-108.516528],[242.948680,-108.083100],[240.994625,-107.459899],[239.777177,-106.730237],[239.491649,-105.977427],[239.912036,-101.568947],[240.086889,-93.477427],[240.248098,-87.651540],[240.528665,-85.762590],[241.012811,-84.429815],[241.753241,-83.558349],[242.802658,-83.053327],[246.039269,-82.763148],[249.347146,-83.069194],[250.399533,-83.647610],[251.129075,-84.683719],[251.594415,-86.308092],[251.854195,-88.651303],[251.991649,-96.016527]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[285.292479,-91.691717],[285.176918,-97.464539],[284.812372,-102.003221],[284.101621,-105.450911],[282.947444,-107.950754],[281.252619,-109.645896],[278.919927,-110.679483],[275.852147,-111.194662],[271.952059,-111.334577],[261.515459,-111.334577],[261.515459,-97.048857],[261.515459,-82.763147],[273.420219,-82.763147],[285.324979,-82.763147],[285.292579,-91.691717]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[292.939099,-89.656547],[293.308093,-93.390070],[293.400124,-97.382725],[292.874032,-105.212226],[291.602296,-111.278633],[290.762272,-113.067420],[289.826389,-113.715528],[289.400437,-113.399656],[289.003061,-112.494359],[288.328824,-109.169395],[287.873257,-104.248450],[287.705939,-98.239338],[287.854714,-92.849746],[288.262751,-88.505111],[288.872613,-85.299634],[289.626867,-83.327511],[290.468078,-82.682943],[291.338810,-83.460127],[292.181628,-85.753262],[292.939099,-89.656548]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[301.991649,-95.717857],[301.803777,-100.864047],[301.292244,-105.299391],[300.535176,-108.550529],[299.610699,-110.144097],[299.081392,-110.220952],[298.611246,-109.774897],[297.862509,-107.390626],[297.392629,-103.144411],[297.229749,-97.189377],[297.415398,-91.547543],[297.923225,-86.964941],[298.679552,-83.888000],[299.127878,-83.053661],[299.610699,-82.763148],[300.088981,-83.027555],[300.535176,-83.785355],[301.292244,-86.568594],[301.803777,-90.687787],[301.991649,-95.717857]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[334.729749,-88.964617],[335.423912,-89.380420],[336.026864,-90.232788],[336.957475,-93.238637],[337.518271,-97.964994],[337.705939,-104.394687],[337.590324,-112.564910],[337.363603,-115.094959],[336.951204,-116.768385],[336.298324,-117.720254],[335.350163,-118.085631],[332.348789,-117.597167],[326.991652,-116.573670],[321.634509,-116.128977],[318.729315,-115.750349],[317.785163,-115.121845],[317.117591,-114.047674],[316.679813,-112.413182],[316.425042,-110.103715],[316.277369,-103.001237],[316.089496,-97.916602],[315.577962,-93.752725],[314.820892,-90.939294],[314.374694,-90.173273],[313.896409,-89.905997],[312.971932,-89.650292],[312.214864,-88.954062],[311.703331,-87.923641],[311.515459,-86.665357],[311.751071,-85.670562],[312.530541,-85.020528],[313.962824,-84.726047],[316.156870,-84.797910],[323.266065,-86.083831],[334.729749,-88.964617]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[391.809269,-109.548858],[391.436399,-111.332246],[391.131050,-110.467756],[390.848959,-101.810768],[391.131050,-93.153770],[391.436399,-92.289279],[391.809269,-94.072668],[392.205374,-101.810763],[391.809269,-109.548858]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[385.639719,-94.072668],[386.182195,-104.269026],[386.024334,-111.504360],[385.677438,-114.072132],[385.149053,-115.972235],[384.437041,-117.228865],[383.539269,-117.866218],[382.789719,-117.929934],[382.160770,-117.551824],[381.239201,-115.354793],[380.723619,-111.044448],[380.563079,-104.390118],[380.748580,-98.722957],[381.256161,-94.122265],[382.012439,-91.034469],[382.460906,-90.197416],[382.944029,-89.905998],[383.893347,-90.234774],[384.718039,-91.129956],[385.329647,-92.454827],[385.639719,-94.072668]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[251.058559,-127.670307],[251.627354,-131.321885],[252.880039,-135.376497],[254.631578,-139.340337],[256.696939,-142.719597],[259.048392,-146.120952],[260.425179,-148.595301],[260.877681,-150.135190],[260.773070,-150.552381],[260.456280,-150.733162],[259.211357,-150.381765],[257.193293,-149.073541],[251.039269,-143.556797],[246.910182,-139.025185],[244.273731,-135.015470],[242.877191,-131.026421],[242.467839,-126.556807],[242.650645,-122.452951],[243.296579,-119.993605],[243.838928,-119.295347],[244.551910,-118.905885],[246.562909,-118.916907],[248.405582,-119.747467],[249.755947,-121.457645],[250.633706,-124.085804],[251.058559,-127.670307]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[339.006439,-143.527177],[343.607510,-154.422104],[344.601487,-157.736376],[344.693192,-158.638762],[344.484749,-158.953618],[342.903935,-158.253964],[340.848972,-156.345760],[338.507945,-153.515139],[336.068935,-150.048236],[331.649305,-142.350124],[330.044851,-138.691182],[329.094749,-135.540498],[328.497959,-131.687065],[328.515573,-129.292294],[328.740734,-128.630587],[329.102639,-128.319963],[330.214205,-128.733853],[331.805320,-130.497740],[333.831031,-133.575404],[339.006439,-143.527177]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[-463.683394,126.570812],[-458.304111,123.990906],[-451.778642,121.820313],[-444.652016,119.770249],[-437.763381,117.373869],[-431.368398,114.763689],[-425.722728,112.072224],[-421.082033,109.431990],[-417.701974,106.975503],[-415.838210,104.835279],[-415.554834,103.925176],[-415.746404,103.143833],[-415.978964,101.325842],[-415.515911,98.237600],[-413.158586,90.115273],[-409.985657,82.506672],[-408.503102,80.060590],[-407.859509,79.381077],[-407.308356,79.141623],[-405.774338,79.316470],[-405.115356,79.736853],[-401.731903,89.855903],[-399.930829,94.628327],[-398.656341,96.840714],[-398.129089,97.067552],[-397.628510,96.751172],[-396.567404,94.617813],[-395.520793,92.523358],[-394.014208,90.340796],[-392.249132,88.328468],[-390.427047,86.744713],[-388.748329,85.171596],[-387.373607,83.188271],[-386.444742,81.048645],[-386.103595,79.006623],[-385.921618,77.210076],[-385.426137,75.738864],[-384.692825,74.744803],[-383.797357,74.379713],[-382.997609,74.130302],[-382.524893,73.451216],[-382.415087,72.446171],[-382.704071,71.218883],[-382.960275,69.442543],[-382.761341,66.942567],[-382.156915,64.050987],[-381.196642,61.099833],[-378.476261,54.141623],[-373.133546,66.046383],[-371.134806,70.879374],[-369.642210,75.238121],[-368.799574,78.644426],[-368.750713,80.620093],[-368.811317,81.776153],[-368.266761,82.950883],[-367.215329,84.006902],[-365.755308,84.806833],[-364.293481,85.672923],[-363.320174,86.887210],[-362.908988,88.309528],[-363.133522,89.799713],[-363.469964,91.261114],[-363.400216,92.671260],[-362.955937,93.869513],[-362.168784,94.695233],[-360.470283,95.358817],[-358.576215,95.470690],[-356.616657,95.100035],[-354.721689,94.316035],[-353.021391,93.187874],[-351.645843,91.784737],[-350.725122,90.175805],[-350.389308,88.430263],[-350.108578,86.506857],[-349.344213,84.726661],[-348.212956,83.287909],[-346.831546,82.388833],[-345.554084,81.690549],[-344.705850,80.798513],[-344.360356,79.827463],[-344.591117,78.892143],[-344.955581,77.829691],[-344.974130,76.512533],[-344.664678,75.108261],[-344.045141,73.784473],[-342.912634,71.758104],[-342.190088,69.624458],[-341.228141,61.879713],[-340.768724,59.805065],[-339.894677,58.470396],[-338.721295,57.844611],[-337.363873,57.896616],[-335.937709,58.595318],[-334.558096,59.909622],[-333.340332,61.808435],[-332.399712,64.260663],[-331.215540,69.409473],[-330.951117,72.594003],[-330.820939,73.287360],[-330.177832,73.855160],[-329.126153,74.238809],[-327.770260,74.379713],[-326.383541,74.029305],[-325.247939,73.075226],[-324.480639,71.663188],[-324.198831,69.938903],[-323.847569,67.766568],[-322.891165,65.134595],[-321.475688,62.375013],[-319.747211,59.819853],[-317.885852,57.006675],[-316.108590,53.544559],[-314.616746,49.872835],[-313.611641,46.430833],[-312.779164,43.280552],[-311.815081,40.726104],[-310.769260,38.808554],[-309.691566,37.568969],[-308.631867,37.048412],[-307.640029,37.287950],[-306.765918,38.328649],[-306.059401,40.211573],[-305.206293,44.328928],[-305.155873,47.205005],[-305.925407,48.950806],[-306.623052,49.434541],[-307.532161,49.677333],[-310.681043,50.206859],[-311.813223,50.847708],[-311.630856,51.253781],[-310.953681,51.740369],[-308.127401,53.025333],[-306.017100,54.235446],[-304.317055,55.913414],[-303.182898,57.860199],[-302.770261,59.876763],[-302.582389,61.817056],[-302.070856,63.627051],[-301.313788,65.104307],[-300.389311,66.046383],[-299.464828,66.998056],[-298.707758,68.501456],[-298.196224,70.350147],[-298.008351,72.337693],[-297.784558,74.190953],[-297.163554,75.518185],[-296.220901,76.221271],[-295.032161,76.202093],[-293.521493,75.038039],[-291.173766,72.454362],[-285.140413,64.648590],[-279.278661,56.025682],[-277.145436,52.420584],[-275.935071,49.826543],[-274.924799,49.421593],[-272.294047,49.055172],[-262.884298,48.466744],[-249.132215,48.118918],[-232.464191,48.069353],[-209.139158,48.354745],[-195.657135,49.046700],[-191.572654,49.653333],[-188.707408,50.491441],[-186.647557,51.604301],[-184.979261,53.035193],[-183.512638,54.571522],[-182.842589,55.728704],[-182.913372,56.182078],[-183.311808,56.561021],[-185.262988,57.122755],[-194.981998,57.651602],[-214.741161,57.749503],[-228.402237,57.945755],[-240.125998,58.453216],[-248.664615,59.194946],[-251.349549,59.629617],[-252.770261,60.094003],[-254.723431,61.627754],[-254.741555,62.124747],[-253.974636,62.477095],[-249.647464,62.853692],[-240.865501,62.969213],[-233.454548,63.201101],[-234.482798,63.537699],[-238.484541,64.108643],[-242.341685,64.766347],[-245.431373,65.588037],[-247.679850,66.496140],[-249.013361,67.413083],[-249.358151,68.261293],[-248.640465,68.963200],[-246.786546,69.441231],[-243.722641,69.617813],[-239.283907,69.847863],[-237.869613,70.328174],[-236.868595,71.223343],[-236.188275,72.661867],[-235.736074,74.772248],[-235.145711,81.522573],[-234.909364,82.451163],[-234.303041,83.242529],[-233.285284,83.908809],[-231.814636,84.462141],[-227.348834,85.278521],[-220.573971,85.788783],[-206.234831,86.483573],[-207.160621,96.191283],[-207.361096,100.561746],[-207.039371,103.983201],[-206.196389,106.450887],[-204.833091,107.960043],[-203.781539,108.888641],[-203.744867,109.246634],[-204.039300,109.536556],[-205.636582,109.920590],[-208.603591,110.057543],[-211.871814,109.941248],[-213.568861,109.491143],[-213.868884,109.113360],[-213.824941,108.619064],[-212.770261,107.236853],[-211.688535,105.656369],[-210.856538,103.469122],[-210.286837,100.899218],[-209.991996,98.170761],[-209.984579,95.507858],[-210.277152,93.134613],[-210.882277,91.275133],[-211.812521,90.153523],[-213.451791,89.502193],[-214.970090,89.583429],[-216.322374,90.326375],[-217.463599,91.660171],[-218.348720,93.513961],[-218.932694,95.816886],[-219.170476,98.498089],[-219.017021,101.486713],[-218.695023,105.748787],[-219.018169,108.383411],[-219.458351,109.193843],[-220.103836,109.721509],[-222.069401,110.094003],[-224.069582,109.714721],[-224.703970,109.159636],[-225.115568,108.288935],[-225.333427,105.384730],[-224.849231,100.570193],[-224.325846,95.514330],[-224.608795,92.636939],[-225.123725,91.829921],[-225.925534,91.345222],[-228.503521,91.046383],[-230.975516,91.425331],[-231.880301,91.961467],[-232.600346,92.784221],[-233.594419,95.456120],[-234.174141,99.774093],[-234.840295,104.537946],[-235.421431,106.200915],[-236.277955,107.509826],[-237.492379,108.558616],[-239.147214,109.441222],[-244.108161,111.083623],[-248.690703,112.021735],[-254.370621,112.667441],[-260.425263,112.962790],[-266.131971,112.849833],[-272.671170,112.259602],[-276.577200,111.341975],[-277.735822,110.679776],[-278.467806,109.838992],[-278.850370,108.787379],[-278.960731,107.492693],[-279.137516,105.729291],[-279.618860,104.285220],[-280.331247,103.309498],[-281.201161,102.951143],[-282.418486,103.137204],[-283.445631,103.642213],[-284.248809,104.386408],[-284.794233,105.290028],[-285.048115,106.273310],[-284.976668,107.256495],[-284.546106,108.159820],[-283.722641,108.903523],[-282.876092,109.668414],[-282.388624,110.627756],[-282.295967,111.658970],[-282.633851,112.639473],[-283.927018,113.613615],[-286.187265,114.297046],[-289.063376,114.693021],[-292.204135,114.804794],[-295.258325,114.635619],[-297.874728,114.188751],[-299.702129,113.467444],[-300.210199,113.004893],[-300.389311,112.474953],[-300.107502,111.550471],[-299.340201,110.793404],[-298.204598,110.281873],[-296.817881,110.094003],[-295.877248,109.943642],[-295.103182,109.461560],[-294.483001,108.601254],[-294.004021,107.316220],[-293.418933,103.285961],[-293.246451,96.998763],[-293.404576,92.221774],[-293.824703,88.421129],[-294.425463,85.699741],[-295.125486,84.160525],[-295.487293,83.866391],[-295.843402,83.906393],[-296.497842,85.040260],[-297.007435,87.665039],[-297.290811,91.883643],[-297.513015,94.012352],[-298.043472,96.185663],[-299.925842,100.565673],[-302.731308,104.822839],[-306.253255,108.756329],[-310.285071,112.165308],[-314.620142,114.848944],[-319.051854,116.606403],[-321.239383,117.075056],[-323.373593,117.236853],[-326.467456,117.048980],[-329.001061,116.537448],[-330.712957,115.780380],[-331.341689,114.855903],[-330.825041,113.927247],[-329.418326,113.158803],[-327.336387,112.630433],[-324.794069,112.422003],[-321.782072,112.034107],[-318.421303,111.016951],[-315.121917,109.525081],[-312.294071,107.713043],[-308.908447,104.654648],[-308.288487,103.709312],[-308.354370,103.176676],[-309.084053,103.074334],[-310.455494,103.419878],[-315.035471,105.525003],[-317.826010,106.874387],[-319.690541,107.488268],[-320.662181,107.456693],[-320.774049,106.869708],[-320.059261,105.817358],[-318.550936,104.389692],[-313.286141,100.768593],[-309.678208,98.476200],[-307.299006,96.632004],[-306.102158,95.284464],[-306.041286,94.482038],[-307.070013,94.273184],[-309.141959,94.706361],[-312.210748,95.830028],[-316.230001,97.692643],[-320.010369,99.397868],[-323.532594,100.642195],[-326.402999,101.307990],[-328.227903,101.277623],[-329.031750,101.312664],[-330.233318,101.806282],[-333.595243,103.994190],[-337.844926,107.491242],[-342.513617,111.947333],[-353.960736,123.629593],[-374.198832,122.517813],[-382.201479,121.874598],[-389.011306,120.945878],[-393.911736,119.855224],[-395.421996,119.287790],[-396.186190,118.726213],[-397.006075,117.615033],[-397.553092,117.248620],[-397.863086,117.627478],[-397.971903,118.752113],[-398.614702,119.884466],[-400.497065,120.942435],[-403.597074,121.922181],[-407.892816,122.819869],[-419.983831,124.353722],[-436.594785,125.513303],[-451.043101,126.591573],[-461.179928,127.925713],[-464.742187,128.627361],[-466.248919,128.688411],[-466.277369,128.453866],[-465.847023,128.029355],[-463.683394,126.570683]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-357.284975,115.822662],[-355.758052,114.084935],[-354.700626,112.158969],[-354.208143,110.279136],[-354.376046,108.679813],[-354.702781,107.379958],[-354.642764,106.315488],[-354.225393,105.596249],[-353.480070,105.332093],[-352.268695,105.041191],[-350.582374,104.249131],[-346.677713,101.645403],[-344.415737,99.771477],[-343.973886,99.302296],[-344.024368,99.144788],[-349.643236,101.628703],[-352.929909,102.925861],[-356.270010,103.744837],[-359.272915,104.018354],[-361.547998,103.679133],[-363.756530,102.938830],[-364.598424,103.015690],[-364.129743,104.081331],[-362.406546,106.307373],[-360.707922,108.627993],[-360.223014,110.226032],[-360.991199,111.500868],[-363.051856,112.851873],[-364.536496,113.920019],[-365.544811,115.130441],[-365.987453,116.334449],[-365.775070,117.383353],[-364.312234,119.072447],[-363.512425,119.414930],[-362.615540,119.413240],[-360.376088,118.348957],[-357.284975,115.822823]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-265.115261,80.442833],[-265.293943,70.970560],[-265.691140,64.661189],[-266.277005,61.793532],[-266.631361,61.737475],[-267.021691,62.646403],[-267.837055,67.206382],[-268.417036,73.857052],[-268.873395,89.854761],[-268.395852,103.488131],[-267.808456,107.183377],[-267.427880,107.859547],[-266.989491,107.605762],[-266.221585,104.459231],[-265.612214,98.289045],[-265.222881,89.986485],[-265.115091,80.442833]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-255.905711,102.504712],[-256.435055,101.538135],[-256.867130,101.471569],[-257.178116,102.281199],[-257.344191,103.943212],[-257.054371,106.743618],[-256.637371,107.266662],[-256.093661,107.068212],[-255.633806,106.263080],[-255.445096,105.134294],[-255.905811,102.504712]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-281.509041,89.260662],[-281.591947,88.105066],[-281.941461,87.158730],[-282.501553,86.519313],[-283.216191,86.284472],[-283.974203,86.895058],[-284.652409,88.557541],[-285.176748,91.018015],[-285.473161,94.022573],[-285.577329,97.694866],[-285.374820,99.332086],[-285.136392,99.426408],[-284.794692,99.058597],[-283.766001,96.998762],[-282.241049,92.761410],[-281.509041,89.260662]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-277.252211,84.531502],[-277.641127,82.915835],[-277.813115,82.899288],[-277.964504,83.381149],[-278.279761,89.855902],[-278.000426,96.699601],[-277.680955,97.564272],[-277.284711,96.436262],[-276.851316,90.742917],[-277.252311,84.531502]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-255.905711,92.980902],[-256.435055,92.014325],[-256.867130,91.947759],[-257.178116,92.757389],[-257.344191,94.419402],[-257.054371,97.219807],[-256.637371,97.742852],[-256.093661,97.544402],[-255.633806,96.739270],[-255.445096,95.610484],[-255.905811,92.980902]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-251.747071,84.174212],[-251.614304,83.257133],[-252.216918,82.320103],[-253.442341,81.472998],[-255.178001,80.825692],[-257.212417,80.511718],[-258.696275,80.766127],[-259.604776,81.577884],[-259.913121,82.935952],[-259.647505,84.183408],[-258.929525,85.154550],[-257.877487,85.831439],[-256.609695,86.196136],[-255.244453,86.230701],[-253.900065,85.917195],[-252.694837,85.237679],[-251.747071,84.174212]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-255.905711,71.552332],[-256.435055,70.585755],[-256.867130,70.519189],[-257.178116,71.328819],[-257.344191,72.990832],[-257.054371,75.791234],[-256.637371,76.314281],[-256.093661,76.115832],[-255.633806,75.310700],[-255.445096,74.181914],[-255.905811,71.552332]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-195.627401,51.891122],[-195.541721,51.731845],[-196.683021,51.573793],[-202.197343,51.277912],[-223.008351,50.882832],[-235.273583,50.946359],[-245.788003,51.296611],[-253.433269,51.876302],[-257.091041,52.628142],[-257.187142,52.788517],[-256.959953,52.934743],[-255.612969,53.185674],[-249.889469,53.527938],[-230.651393,53.625967],[-209.267231,53.040829],[-200.861123,52.529134],[-195.627401,51.891122]]);
    }
    linear_extrude(height=h)
      polygon([[-195.032161,123.962092],[-198.036723,122.964404],[-200.497196,121.799926],[-202.159678,120.613441],[-202.770261,119.549732],[-202.619497,118.930410],[-202.190230,118.412615],[-200.634343,117.672838],[-198.378912,117.312867],[-195.700250,117.315164],[-192.874668,117.662193],[-190.178478,118.336419],[-187.887992,119.320304],[-186.279521,120.596312],[-185.180689,122.163980],[-184.736746,123.414849],[-184.933521,124.343469],[-185.756841,124.944391],[-187.192537,125.212165],[-189.226436,125.141339],[-195.032161,123.962092]]);
    linear_extrude(height=h)
      polygon([[104.372599,121.998762],[104.560471,121.074281],[105.072004,120.317214],[105.829072,119.805683],[106.753549,119.617812],[107.678032,119.805683],[108.435102,120.317214],[108.946636,121.074281],[109.134509,121.998762],[108.946636,122.923240],[108.435102,123.680307],[107.678032,124.191840],[106.753549,124.379712],[105.829072,124.191840],[105.072004,123.680307],[104.560471,122.923240],[104.372599,121.998762]]);
    linear_extrude(height=h)
      polygon([[218.658319,121.085852],[219.180865,120.377734],[220.568589,119.784263],[224.860086,119.034557],[229.373842,119.023317],[231.039390,119.352928],[231.950889,119.937122],[232.058193,120.351262],[231.870930,120.737618],[230.711291,121.393155],[228.669154,121.836086],[225.941699,121.998762],[220.797811,121.730595],[219.233023,121.440318],[218.658319,121.085852]]);
    linear_extrude(height=h)
      polygon([[-343.692879,117.991352],[-341.063299,117.530714],[-339.934512,117.719408],[-339.129379,118.179212],[-338.930932,118.722920],[-339.453977,119.139932],[-342.254379,119.429732],[-343.916393,119.263642],[-344.726022,118.952661],[-344.659455,118.520599],[-343.692879,117.991262]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[-157.532161,112.603923],[-157.778974,111.957298],[-158.521871,111.411310],[-161.510673,110.619053],[-166.528076,110.222773],[-173.603591,110.218093],[-180.313508,110.168293],[-186.702551,109.754935],[-192.048068,109.047086],[-195.627401,108.113812],[-198.894488,106.706166],[-200.048611,105.949249],[-199.140939,105.616916],[-196.222641,105.483022],[-194.502237,105.130858],[-192.988572,104.286415],[-191.761484,103.115896],[-190.900810,101.785503],[-190.486387,100.461438],[-190.598053,99.309903],[-191.315645,98.497100],[-192.719001,98.189233],[-193.397163,97.446797],[-193.873509,95.425315],[-194.104481,92.433524],[-194.046521,88.780162],[-193.520541,79.371072],[-207.073971,78.516072],[-212.538900,78.085075],[-213.512096,77.906857],[-213.279403,77.747569],[-199.794071,77.210852],[-190.623731,77.176490],[-184.119508,77.530485],[-180.244230,78.276779],[-179.280832,78.798269],[-178.960731,79.419312],[-178.591153,80.364983],[-177.578561,80.944435],[-176.067175,81.114825],[-174.201211,80.833312],[-172.247955,80.520276],[-170.448108,80.588025],[-169.001586,81.006613],[-168.108311,81.746092],[-167.954413,82.583788],[-168.521061,83.269782],[-169.700715,83.733290],[-171.385831,83.903522],[-173.410028,84.185330],[-175.512945,84.952629],[-177.446030,86.088232],[-178.960731,87.474952],[-181.776238,89.997272],[-183.194743,90.764573],[-184.383191,91.046382],[-184.997714,90.670638],[-184.853561,89.647571],[-184.011466,88.133433],[-182.532161,86.284472],[-180.194289,83.593924],[-179.474810,82.173299],[-179.736413,81.812704],[-180.419947,81.617785],[-183.075921,81.522572],[-185.091325,81.843778],[-186.757780,82.725454],[-188.032534,84.044690],[-188.872831,85.678576],[-189.235919,87.504201],[-189.079042,89.398654],[-188.359448,91.239025],[-187.034381,92.902402],[-184.532632,94.084290],[-180.072766,95.002315],[-174.067308,95.596853],[-166.928781,95.808282],[-158.207278,95.583365],[-151.872180,94.777297],[-146.999948,93.193105],[-142.667041,90.633812],[-138.588830,87.631277],[-137.503320,86.636799],[-137.024270,85.871982],[-137.129731,85.255677],[-137.797750,84.706733],[-140.733661,83.486332],[-142.976765,82.826685],[-145.141521,82.489110],[-146.981318,82.494094],[-148.249541,82.862122],[-149.447547,83.274540],[-151.096158,83.400387],[-154.875541,82.800422],[-156.942623,81.744264],[-158.203299,80.020592],[-158.746393,77.416271],[-158.660731,73.718162],[-158.499116,70.197581],[-158.629645,67.320702],[-158.993499,65.174132],[-159.531859,63.844479],[-160.185907,63.418351],[-160.896826,63.982358],[-161.605797,65.623105],[-162.254001,68.427202],[-163.174916,72.039818],[-163.816926,73.328163],[-164.639816,74.327177],[-165.688467,75.078846],[-167.007762,75.625152],[-170.637811,76.269612],[-177.770261,76.969162],[-177.684061,63.110822],[-177.456952,56.797165],[-176.827801,51.207272],[-175.749783,46.232818],[-174.176073,41.765479],[-172.059844,37.696928],[-169.354273,33.918840],[-166.012534,30.322890],[-161.987801,26.800752],[-152.528941,19.199392],[-121.101941,20.859562],[-102.977654,21.941051],[-97.090919,22.525986],[-92.731454,23.277205],[-89.457009,24.297327],[-86.825334,25.688968],[-84.394179,27.554747],[-81.721291,29.997282],[-78.166449,33.882237],[-74.409061,38.889417],[-70.708030,44.544418],[-67.322261,50.372831],[-64.510659,55.900250],[-62.532127,60.652268],[-61.645570,64.154478],[-61.692689,65.288653],[-62.109891,65.932472],[-62.878352,66.774257],[-63.388038,68.088131],[-63.594822,69.694271],[-63.454581,71.412852],[-62.476181,78.686782],[-62.165090,80.550010],[-61.569875,81.298899],[-60.766290,81.051644],[-59.830086,79.926437],[-57.862838,75.514946],[-56.274151,69.009972],[-54.666930,61.172799],[-53.151081,56.522442],[-51.907565,53.092386],[-50.955101,48.189112],[-49.917305,42.143385],[-48.490705,36.779512],[-46.837788,32.345376],[-45.121039,29.088862],[-43.502944,27.257853],[-42.781668,26.954376],[-42.145988,27.100231],[-41.616215,27.726404],[-41.212659,28.863880],[-40.865441,32.796682],[-40.567439,35.595214],[-39.756045,38.752862],[-38.555182,41.882438],[-37.088771,44.596752],[-35.744415,47.032228],[-34.875840,49.402614],[-34.556226,51.436664],[-34.858751,52.863132],[-35.165563,53.947503],[-34.857639,55.050090],[-34.006336,56.041913],[-32.683011,56.793992],[-31.237697,57.704256],[-30.054113,59.126779],[-29.254395,60.866800],[-28.960681,62.729562],[-28.775939,64.983127],[-28.274134,66.429048],[-27.533895,67.102145],[-26.633855,67.037235],[-25.652644,66.269135],[-24.668892,64.832663],[-23.761231,62.762636],[-23.008291,60.093872],[-21.395838,55.049229],[-20.512725,53.514629],[-19.722131,52.951012],[-19.117410,53.189660],[-18.383292,53.870628],[-16.619816,56.349688],[-12.562563,64.307429],[-9.037586,73.466806],[-7.939456,77.447913],[-7.532101,80.470392],[-7.813910,82.894005],[-8.581211,85.084621],[-9.716815,86.801596],[-11.103531,87.804282],[-13.127226,88.773692],[-14.313622,89.759705],[-14.709982,90.708770],[-14.363570,91.567332],[-13.321649,92.281841],[-11.631481,92.798742],[-9.340331,93.064484],[-6.495461,93.025512],[-3.404918,92.673453],[-1.036608,92.122086],[0.376591,91.446945],[0.652249,91.086563],[0.601799,90.723562],[0.560924,89.368267],[1.249669,86.972557],[4.327059,80.413132],[6.193719,76.750982],[7.722354,73.107127],[8.755216,69.903276],[9.134559,67.561132],[9.275816,65.037292],[9.689957,63.245541],[10.362537,62.185373],[11.279112,61.856279],[12.425238,62.257753],[13.786469,63.389288],[17.096469,67.840512],[18.911135,71.383519],[20.300512,75.316361],[21.128071,79.160132],[21.257279,82.435922],[21.088461,86.103315],[21.276826,87.254782],[21.710019,88.015514],[22.435271,88.433575],[23.499814,88.557029],[26.835709,88.112372],[29.338750,87.791550],[31.554429,87.797266],[33.242347,88.109910],[34.162109,88.709872],[34.999302,89.253887],[36.777358,89.739747],[42.997015,90.523899],[52.502994,91.036110],[64.977209,91.250162],[67.237732,91.443374],[69.287384,91.972397],[71.073619,92.790001],[72.543892,93.848955],[73.645661,95.102029],[74.326379,96.501992],[74.533503,98.001613],[74.214489,99.553662],[73.727858,101.422410],[73.917097,102.549761],[74.659671,102.983072],[75.833045,102.769697],[77.314684,101.956995],[78.982055,100.592319],[80.712621,98.723026],[82.383849,96.396472],[84.559281,93.481002],[86.806556,91.580906],[89.214680,90.641896],[91.872659,90.609682],[94.439087,90.734166],[96.088451,90.148142],[96.969204,88.734277],[97.229799,86.375232],[97.511606,84.324815],[98.278905,82.439821],[99.414508,80.929354],[100.801229,80.002512],[102.828882,79.046559],[104.014450,78.100775],[104.404276,77.211539],[104.044705,76.425231],[102.982081,75.788231],[101.262747,75.346918],[98.933049,75.147672],[96.039329,75.236872],[90.153906,75.408925],[88.363541,75.234496],[87.705989,74.901162],[89.878804,72.170844],[95.102799,66.999492],[98.015807,63.930673],[100.075942,61.027877],[101.160686,58.502587],[101.147519,56.566282],[101.145858,54.580593],[102.197122,51.843472],[104.148190,48.657035],[106.845939,45.323392],[109.583527,42.015248],[111.825375,38.714312],[113.340138,35.803145],[113.896469,33.664302],[114.156642,31.918651],[114.865036,30.078026],[115.913462,28.361487],[117.193729,26.988092],[118.343734,26.270892],[119.386549,26.163206],[120.348206,26.712607],[121.254735,27.966669],[123.006538,32.779074],[124.850209,40.981012],[125.642860,43.407622],[126.989948,45.463884],[128.875193,47.143066],[131.282317,48.438437],[134.195043,49.343265],[137.597090,49.850816],[141.472182,49.954360],[145.804039,49.647162],[151.501884,49.103825],[154.461719,49.142035],[155.018582,49.400665],[155.015381,49.830417],[153.494709,51.237592],[152.381909,52.194018],[151.756246,53.200094],[151.686134,54.386395],[152.239987,55.883492],[155.493245,60.332368],[162.063329,67.591302],[174.610759,81.035612],[187.051489,79.050922],[201.625259,77.492956],[219.194349,76.534202],[230.120636,76.361900],[236.116825,76.834709],[237.761320,77.424561],[238.767514,78.309527],[239.333482,79.534220],[239.657299,81.143252],[239.751750,83.139495],[239.446547,84.774231],[238.800281,85.878775],[237.871539,86.284442],[236.882766,86.002635],[236.073042,85.235336],[235.525929,84.099733],[235.324989,82.713012],[234.937294,80.413547],[234.450197,79.730496],[233.765395,79.357956],[231.796068,79.542578],[229.016089,80.963752],[227.652236,82.407326],[226.614886,84.636364],[225.916319,87.417968],[225.568817,90.519237],[225.584662,93.707272],[225.976135,96.749173],[226.755517,99.412040],[227.935089,101.462972],[228.819011,102.634893],[229.223829,103.545582],[229.049222,104.227632],[228.194872,104.713634],[224.045667,105.227860],[215.973659,105.348992],[200.481489,105.812261],[184.540369,106.901442],[168.279539,108.436992],[168.901279,95.015282],[168.863651,85.059489],[168.481221,81.659917],[167.900179,79.970752],[167.278598,79.538259],[166.780887,79.627651],[166.142927,81.476949],[165.958011,85.728363],[166.197849,92.591612],[166.153693,95.626796],[165.735539,98.348425],[165.013612,100.458920],[164.058139,101.660702],[163.456193,101.775608],[162.921544,101.334726],[162.054171,98.785766],[161.456090,94.014149],[161.127369,87.020202],[160.739299,70.808252],[159.232919,83.903492],[158.465182,89.325864],[157.650320,92.695011],[156.798597,93.982262],[156.362121,93.836216],[155.920279,93.158942],[155.312628,90.890747],[154.993387,87.553457],[154.982860,83.596293],[155.301349,79.468472],[155.586068,75.637998],[155.481167,72.506412],[155.021065,70.393185],[154.668569,69.818289],[154.240179,69.617782],[153.788497,69.933654],[153.367119,70.838950],[152.652160,74.163911],[152.169080,79.084856],[151.991659,85.093972],[152.158587,91.997555],[152.673034,96.707196],[153.555490,99.330464],[154.141126,99.893321],[154.826449,99.974922],[156.003868,100.097612],[157.114139,100.871686],[158.032342,102.169551],[158.633559,103.863612],[158.900055,106.131346],[158.702735,106.822467],[158.232106,107.243326],[156.312141,107.348962],[152.822589,106.597662],[144.534846,105.117726],[134.134519,104.016922],[118.425634,102.639073],[107.670826,100.981265],[103.951757,100.004060],[101.231874,98.904886],[99.431401,97.666416],[98.470559,96.271322],[97.622696,94.392281],[96.860865,93.702786],[96.000471,94.178512],[94.856919,95.795132],[94.161542,97.369856],[93.937550,98.989644],[94.183968,100.518939],[94.899819,101.822182],[95.214287,102.456748],[94.995608,102.978548],[92.877915,103.696356],[88.384959,104.000620],[81.354959,103.916352],[74.548812,103.486095],[69.178429,102.701239],[65.407982,101.595729],[64.174041,100.933338],[63.401649,100.203512],[62.254380,98.787506],[61.369075,98.282249],[60.635961,98.680480],[59.945269,99.974942],[59.163241,101.127668],[57.926695,102.066172],[56.405466,102.693997],[54.769389,102.914682],[52.825113,102.815737],[52.125644,102.479151],[52.648862,101.774201],[54.372649,100.570162],[55.921194,99.420612],[56.187294,98.709090],[55.099643,98.341979],[52.586939,98.225662],[50.506859,98.428939],[48.803452,99.008110],[47.652502,99.874437],[47.229789,100.939182],[46.948246,101.853430],[46.131786,102.001045],[44.822663,101.391216],[43.063129,100.033132],[40.995827,98.615476],[38.766291,97.802149],[36.479429,97.616355],[34.240149,98.081302],[31.640786,99.106916],[30.990945,99.513989],[30.774331,99.918509],[31.640786,100.923701],[34.240149,102.530112],[35.113797,103.257717],[34.926365,103.837629],[33.559277,104.278646],[30.893956,104.589562],[21.194311,104.856283],[4.878819,104.708162],[-11.974074,104.271200],[-22.786408,103.536474],[-26.343191,103.010295],[-28.888825,102.353092],[-30.589642,101.546001],[-31.611971,100.570162],[-32.843909,99.029570],[-33.809190,98.426346],[-34.596052,98.746221],[-35.292731,99.974922],[-36.063408,101.135383],[-37.246481,102.007574],[-38.733588,102.584079],[-40.416364,102.857484],[-42.186444,102.820372],[-43.935465,102.465328],[-45.555062,101.784937],[-46.936871,100.771782],[-48.284808,99.841318],[-50.282856,98.918931],[-55.151161,97.524592],[-57.890097,96.967580],[-58.562983,96.594737],[-53.365441,96.132492],[-50.366277,95.806807],[-48.074868,95.180352],[-46.531391,94.359215],[-45.776024,93.449484],[-45.848945,92.557245],[-46.790331,91.788585],[-48.640361,91.249592],[-51.439211,91.046352],[-53.811958,90.858480],[-55.976094,90.346946],[-57.692633,89.589875],[-58.722591,88.665392],[-59.674929,87.424046],[-60.651826,86.646890],[-61.581429,86.307398],[-62.391885,86.379042],[-63.011340,86.835297],[-63.367940,87.649633],[-63.389832,88.795524],[-63.005161,90.246442],[-62.508181,91.883185],[-62.552030,92.799771],[-63.138742,92.999805],[-64.270351,92.486892],[-65.351939,90.978040],[-66.237663,88.142441],[-66.836123,84.386050],[-67.055921,80.114822],[-67.269130,74.644197],[-68.070905,71.074234],[-68.768514,69.820338],[-69.704474,68.823612],[-72.413061,67.311012],[-77.770211,65.157702],[-72.413061,65.006752],[-68.800041,64.752268],[-67.848812,64.311450],[-67.442450,63.462502],[-67.561965,62.056118],[-68.188367,59.942987],[-70.885871,52.999252],[-72.719326,49.014769],[-74.553487,46.104294],[-76.312790,44.277107],[-77.921669,43.542487],[-79.304559,43.909715],[-80.385894,45.388071],[-81.090110,47.986833],[-81.341641,51.715282],[-81.575224,56.059434],[-81.933068,57.590130],[-82.510163,58.780176],[-83.350417,59.694777],[-84.497743,60.399136],[-87.889251,61.437942],[-96.817831,63.559372],[-97.308206,63.469069],[-97.768409,62.934983],[-98.560916,60.695121],[-99.120594,57.159100],[-99.372681,52.646232],[-99.315568,46.255448],[-99.068999,44.191302],[-98.602564,42.731680],[-97.860369,41.764351],[-96.786523,41.177085],[-93.420301,40.693822],[-85.929430,40.098872],[-77.812751,39.017922],[-77.526836,38.822217],[-77.615460,38.398158],[-78.806933,36.971182],[-84.480971,32.545232],[-93.487591,26.425062],[-98.724141,32.909132],[-104.643206,41.207583],[-109.745554,50.095222],[-113.324903,58.190442],[-114.322740,61.509141],[-114.674971,64.111632],[-114.366693,66.991289],[-113.803981,67.868074],[-112.811230,68.420422],[-111.270196,68.686530],[-109.062637,68.704591],[-102.174971,68.149352],[-95.900784,67.627889],[-92.651268,67.706495],[-92.023370,68.000771],[-91.986770,68.481000],[-93.467641,70.047232],[-94.790249,71.660891],[-95.890507,74.021792],[-96.745836,76.954539],[-97.333659,80.283736],[-97.631395,83.833988],[-97.616467,87.429899],[-97.266295,90.896072],[-96.558301,94.057112],[-95.642033,96.316030],[-94.678369,97.367456],[-93.714941,97.297979],[-92.799379,96.194191],[-91.979313,94.142682],[-91.302374,91.230042],[-90.816194,87.542862],[-90.568401,83.167732],[-90.271371,70.808252],[-88.428561,83.463992],[-87.023873,91.820148],[-86.343851,94.536737],[-85.617725,96.395377],[-84.799758,97.483354],[-83.844210,97.887949],[-82.705344,97.696448],[-81.337421,96.996132],[-80.285696,95.475679],[-79.622659,92.585190],[-79.376265,88.537904],[-79.574471,83.547062],[-79.799963,78.887471],[-79.719775,74.907979],[-79.360922,72.030838],[-78.750421,70.678302],[-78.379949,70.770680],[-78.002804,71.458573],[-77.270533,74.388582],[-76.637675,79.003677],[-76.188301,84.839202],[-75.389251,100.089752],[-86.103541,101.212872],[-94.686603,102.271274],[-100.276871,103.238782],[-101.214415,103.327939],[-101.979869,103.016904],[-102.589119,102.243525],[-103.058050,100.945649],[-103.638499,96.527788],[-103.848301,89.266092],[-104.032879,83.489770],[-104.452258,78.758649],[-105.044183,75.561009],[-105.385397,74.689833],[-105.746401,74.385132],[-111.280061,74.380132],[-112.299768,74.505201],[-113.109837,74.920546],[-113.725360,75.686376],[-114.161428,76.862901],[-114.555562,80.688872],[-114.412971,86.880132],[-114.245285,93.279113],[-114.639878,96.977679],[-115.102089,98.002349],[-115.769742,98.577566],[-116.664462,98.778548],[-117.807871,98.680512],[-119.364864,98.579806],[-120.639906,98.822771],[-121.501421,99.361280],[-121.817831,100.147202],[-122.121554,100.692690],[-122.992032,101.414840],[-126.189111,103.264909],[-130.920788,105.448977],[-136.698781,107.718612],[-154.555921,114.244752],[-155.711522,114.462127],[-156.657858,114.225290],[-157.297272,113.588084],[-157.532111,112.604352]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-142.308541,101.919353],[-141.368632,99.550657],[-139.884396,97.384111],[-138.059616,95.659359],[-136.098071,94.616043],[-134.476578,93.934816],[-133.141160,93.060980],[-132.131794,92.081898],[-131.488459,91.084930],[-131.251131,90.157437],[-131.459789,89.386781],[-132.154410,88.860322],[-133.374971,88.665423],[-135.042149,89.169796],[-137.187249,90.531867],[-142.047939,94.922816],[-146.230490,100.025694],[-147.527916,102.277675],[-148.008351,104.027923],[-147.829365,105.868000],[-147.343794,107.050005],[-146.628717,107.602453],[-145.761214,107.553858],[-144.818365,106.932735],[-143.877250,105.767600],[-143.014949,104.086968],[-142.308541,101.919353]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[178.182129,93.286813],[178.015165,89.643457],[177.560560,86.659864],[176.887745,84.643923],[176.066149,83.903523],[175.063495,84.592703],[174.079555,86.437203],[172.432807,92.253918],[171.655886,98.677172],[171.759228,101.279847],[172.278769,103.030473],[173.348161,104.312570],[174.399796,104.753360],[175.395199,104.416344],[176.295895,103.365026],[177.063411,101.662911],[177.659271,99.373501],[178.182129,93.286813]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[190.496529,97.594003],[190.985107,92.179204],[190.426089,87.837064],[189.787801,86.187988],[188.928498,84.950773],[187.861808,84.173318],[186.601359,83.903523],[185.473535,84.573812],[184.377246,86.361745],[183.386744,88.932923],[182.576286,91.952944],[182.020126,95.087408],[181.792518,98.001914],[181.967717,100.362063],[182.619979,101.833453],[183.739919,102.667474],[184.928838,103.053851],[186.132906,103.021555],[187.298297,102.599559],[188.371183,101.816833],[189.297735,100.702351],[190.024127,99.285083],[190.496529,97.594003]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[202.450439,101.711973],[203.329457,101.158637],[204.034500,100.275452],[204.951040,97.721286],[205.256816,94.452990],[205.008584,90.874079],[204.263100,87.388067],[203.077120,84.398469],[201.507401,82.308799],[200.596375,81.727536],[199.610699,81.522573],[197.531573,81.997790],[196.730815,82.639719],[196.066389,83.593778],[195.077919,86.566038],[194.428939,91.170073],[194.088474,98.283560],[194.379043,100.555668],[195.043831,102.059423],[196.133101,102.860877],[197.697117,103.026085],[199.786142,102.621099],[202.450439,101.711973]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-21.222641,98.993333],[-24.198828,98.497958],[-27.175021,98.993333],[-27.860938,99.459626],[-27.528443,99.841485],[-24.198831,100.194263],[-20.869216,99.841485],[-20.536720,99.459626],[-21.222641,98.993333]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-0.389301,98.189233],[-0.753957,97.264755],[-1.746831,96.507688],[-3.216286,95.996155],[-5.010681,95.808283],[-6.921196,95.996155],[-8.706801,96.507688],[-10.167574,97.264755],[-11.103591,98.189233],[-11.219531,99.130953],[-10.401723,99.886109],[-8.779503,100.388066],[-6.482211,100.570193],[-4.116449,100.382320],[-2.179094,99.870786],[-0.870070,99.113715],[-0.389301,98.189233]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[24.444619,97.424523],[23.457147,96.164192],[21.692964,95.379354],[19.232668,95.090492],[16.156859,95.318093],[12.599034,96.000301],[10.051922,96.809557],[8.516733,97.678664],[7.994680,98.540430],[8.486974,99.327660],[9.994827,99.973160],[12.519452,100.409735],[16.062059,100.570193],[20.435233,100.400157],[23.195649,99.854626],[24.015319,99.424444],[24.484894,98.880461],[24.622075,98.216034],[24.444559,97.424523]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[221.039269,91.046383],[220.862557,85.942215],[220.568426,84.266248],[220.072006,83.070191],[219.324471,82.275920],[218.276992,81.805310],[215.086889,81.522573],[211.896786,81.805310],[210.849307,82.275920],[210.101771,83.070191],[209.605352,84.266248],[209.311220,85.942215],[209.134509,91.046383],[209.311220,96.150550],[209.605352,97.826517],[210.101771,99.022574],[210.849307,99.816845],[211.896786,100.287455],[215.086889,100.570193],[218.276992,100.287455],[219.324471,99.816845],[220.072006,99.022574],[220.568426,97.826517],[220.862557,96.150550],[221.039269,91.046383]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[140.507199,77.716353],[140.665350,69.680619],[140.526614,62.935373],[140.124282,58.188344],[139.491649,56.147263],[139.132403,56.185053],[138.796224,56.719043],[138.222792,59.086218],[137.830807,62.869993],[137.679719,67.691573],[137.227740,79.241706],[136.177719,89.260663],[135.725919,93.026069],[135.756247,95.831896],[136.257747,97.584249],[136.681761,98.036031],[137.219459,98.189233],[137.776558,97.814696],[138.306949,96.722313],[139.257521,92.571375],[140.010997,86.111145],[140.507199,77.716353]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[149.610699,79.141623],[149.422826,72.663277],[148.911292,67.137013],[148.154222,63.148766],[147.708024,61.914504],[147.229739,61.284472],[146.693148,61.279717],[146.219583,61.953460],[145.472035,65.257674],[145.008101,71.039574],[144.848789,79.141623],[145.008101,87.243667],[145.472035,93.025566],[146.219583,96.329779],[146.693148,97.003521],[147.229739,96.998762],[147.708024,96.368731],[148.154222,95.134469],[148.911292,91.146224],[149.422826,85.619963],[149.610699,79.141623]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[108.479099,76.208073],[108.103088,74.314188],[107.937222,74.313979],[107.791516,74.909351],[107.491339,82.713043],[107.763982,90.891496],[108.073064,91.892313],[108.454819,90.493783],[108.869400,83.614050],[108.479119,76.208073]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[120.395939,72.647093],[120.030550,70.474790],[119.869626,70.490827],[119.728446,71.199629],[119.439599,80.332093],[119.707166,89.845464],[120.006990,90.982604],[120.376719,89.313763],[120.776819,81.247874],[120.395719,72.647093]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[132.302909,64.188833],[131.951438,61.978530],[131.665592,63.387625],[131.408219,75.570193],[131.680257,87.360841],[131.814444,88.296825],[131.967635,88.345719],[132.316099,85.617403],[132.681151,74.627939],[132.301799,64.188832]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-17.055971,90.133473],[-17.525651,88.764736],[-18.804483,87.472928],[-20.697153,86.403456],[-23.008351,85.701733],[-25.319549,85.421740],[-27.212220,85.500535],[-28.491051,85.908156],[-28.960731,86.614643],[-28.584988,87.410922],[-27.561925,88.063006],[-26.047790,88.503603],[-24.198831,88.665423],[-22.349871,88.853295],[-20.835733,89.364829],[-19.812666,90.121900],[-19.436921,91.046383],[-19.087221,92.727928],[-18.708689,93.239460],[-18.246451,93.427333],[-17.784212,93.167426],[-17.405676,92.459760],[-17.055971,90.133473]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[115.621959,73.827123],[115.245943,71.933238],[115.080075,71.933029],[114.934369,72.528401],[114.634199,80.332093],[114.906841,88.510543],[115.215919,89.511361],[115.597669,88.112833],[116.012254,81.233100],[115.621969,73.827123]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-148.008351,74.520233],[-148.196224,72.609724],[-148.707758,70.824121],[-149.464828,69.363349],[-150.389311,68.427333],[-151.331026,68.311392],[-152.086179,69.129201],[-152.588135,70.751421],[-152.770261,73.048713],[-152.582389,75.414475],[-152.070856,77.351830],[-151.313788,78.660854],[-150.389311,79.141623],[-149.464828,78.776967],[-148.707758,77.784091],[-148.196224,76.314634],[-148.008351,74.520233]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-143.986141,67.832093],[-144.408931,66.871804],[-144.755161,67.337299],[-145.075021,71.998763],[-144.755161,76.660218],[-144.408931,77.125711],[-143.986141,76.165423],[-143.536996,71.998761],[-143.986141,67.832093]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-136.103591,70.667763],[-136.276356,67.323014],[-136.762710,64.947103],[-137.514742,63.680936],[-137.975415,63.508041],[-138.484541,63.665423],[-139.409024,64.789317],[-140.166095,66.761625],[-140.677629,69.304297],[-140.865501,72.139283],[-140.677629,74.858161],[-140.166095,77.084686],[-139.409024,78.589095],[-138.484541,79.141623],[-137.560064,78.472982],[-136.802996,76.652425],[-136.291463,73.958002],[-136.103591,70.667763]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-166.473231,66.046383],[-167.545021,61.842514],[-168.079762,60.563682],[-168.524021,60.094003],[-168.878481,60.563682],[-169.168755,61.842514],[-169.436921,66.046383],[-169.275102,68.357580],[-168.834505,70.250251],[-168.182421,71.529083],[-167.386141,71.998763],[-166.679646,71.529083],[-166.272026,70.250251],[-166.193236,68.357580],[-166.473231,66.046383]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[128.182129,64.574883],[127.994256,63.766509],[127.482722,63.325580],[126.725652,63.281937],[125.801169,63.665423],[124.119624,65.404081],[123.608091,66.477291],[123.420219,67.517883],[123.608091,68.326250],[124.119624,68.767176],[124.876692,68.810818],[125.801169,68.427333],[127.482722,66.688679],[127.994256,65.615470],[128.182129,64.574883]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-84.173401,49.813853],[-84.847234,47.565722],[-86.127840,45.784591],[-87.955442,44.528871],[-90.270261,43.856973],[-93.005739,43.731985],[-93.942820,43.991460],[-94.636320,44.515556],[-95.423156,46.507533],[-95.627401,50.007763],[-95.251602,55.301659],[-94.744644,57.030535],[-93.991904,58.179830],[-92.968576,58.773893],[-91.649854,58.837075],[-90.010931,58.393724],[-88.027001,57.468193],[-86.154495,56.081562],[-84.855914,54.279775],[-84.179476,52.158612],[-84.173401,49.813853]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-135.413711,52.951143],[-134.793861,49.588044],[-134.807350,48.564977],[-135.052261,48.189233],[-136.425055,49.588044],[-138.484541,52.951143],[-139.304914,54.805041],[-139.646356,56.318628],[-139.497261,57.338946],[-138.846021,57.713043],[-137.898572,57.337300],[-136.935624,56.314236],[-136.069797,54.800101],[-135.413711,52.951143]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-159.004641,44.494143],[-158.618039,43.132880],[-158.661484,42.266552],[-159.110442,41.953912],[-159.940381,42.253713],[-161.602671,43.939191],[-162.108349,44.964109],[-162.294071,45.948813],[-162.002683,47.746422],[-161.670623,48.081194],[-161.242918,48.052593],[-160.186371,46.943206],[-159.004641,44.494143]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-117.515801,37.411953],[-118.161604,37.231310],[-118.934676,37.724749],[-119.737943,38.795915],[-120.474331,40.348453],[-121.141849,42.316485],[-121.174240,43.162613],[-120.523461,42.934875],[-119.141471,41.681313],[-118.097902,40.435943],[-117.443539,39.215871],[-117.231725,38.161180],[-117.515801,37.411953]]);
       translate([0, 0, -fu