
// Module names are of the form poly_<inkscape-path-id>().  As a result,
// you can associate a polygon in this OpenSCAD program with the corresponding
// SVG element in the Inkscape document by looking for the XML element with
// the attribute id="inkscape-path-id".

// fudge value is used to ensure that subtracted solids are a tad taller
// in the z dimension than the polygon being subtracted from.  This helps
// keep the resulting .stl file manifold.
fudge = 0.1;
FontHeight=25;
PlateText="OKTOBRFST";

module OntarioPlate(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    difference()
    {
       linear_extrude(height=h)
         polygon([[368.052385,264.451910],[362.231557,263.083401],[355.917885,262.546060],[350.128688,262.858769],[347.748680,263.339793],[345.881285,264.040410],[342.803666,264.999054],[339.601607,265.003585],[336.835205,264.135079],[335.790405,263.398772],[335.064555,262.474610],[334.349692,260.260898],[334.052355,257.594410],[333.344755,254.610423],[331.552355,251.634310],[330.442949,250.084210],[329.657355,248.446360],[329.186311,246.695785],[329.020555,244.807510],[328.551005,241.496985],[327.466155,238.951910],[326.750067,237.634260],[326.386930,235.832110],[326.598755,229.451910],[327.184527,225.143934],[328.167087,221.553627],[329.612688,218.620721],[331.587584,216.284948],[334.158028,214.486038],[337.390274,213.163724],[341.350575,212.257738],[346.105185,211.707810],[352.657885,211.211310],[354.243985,205.123610],[355.202943,200.791512],[355.272447,198.141372],[354.950396,197.334916],[354.378071,196.814402],[352.445385,196.451810],[351.236082,196.334818],[350.506310,195.895373],[350.147826,195.000771],[350.052385,193.518310],[350.158172,192.015927],[350.560360,191.075173],[351.386185,190.543487],[352.762885,190.268310],[354.036696,189.984199],[354.980497,189.445698],[355.639243,188.614377],[356.057885,187.451810],[356.490904,186.187313],[357.185860,185.425035],[358.326729,185.051144],[360.097485,184.951810],[361.916201,185.042926],[363.006310,185.418910],[363.583382,186.233719],[363.862985,187.641310],[364.140696,188.953121],[364.673547,189.830672],[365.551118,190.363543],[366.862985,190.641310],[368.181974,190.920262],[369.059222,191.458797],[369.589802,192.353715],[369.868785,193.701810],[369.946499,195.165851],[369.644197,195.996235],[368.793440,196.366907],[367.225785,196.451810],[365.775387,196.671162],[364.648799,197.269049],[363.864550,198.155220],[363.441172,199.239423],[363.397196,200.431405],[363.751152,201.640915],[364.521571,202.777700],[365.726985,203.751510],[366.243397,204.365683],[366.664635,205.445523],[367.052385,208.407710],[367.129135,210.641607],[367.652885,211.859835],[369.063885,212.480801],[371.802385,212.922910],[376.946722,214.194773],[382.125710,216.358235],[386.389360,218.936260],[387.881062,220.231659],[388.787685,221.451810],[389.332953,223.039065],[389.714547,225.155983],[389.991760,230.350323],[389.629410,235.777855],[388.637585,240.181610],[386.559685,246.951910],[385.654810,249.555160],[384.410485,251.601310],[382.946772,254.336323],[381.514485,258.595710],[380.323663,262.095438],[378.867735,264.550360],[377.134382,265.975457],[375.111285,266.385710],[368.052385,264.451910]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[370.864785,255.187410],[370.620010,253.798885],[369.579185,252.873335],[368.178060,252.620947],[366.852385,253.251910],[366.221422,254.577585],[366.473810,255.978710],[367.399360,257.019535],[368.787885,257.264310],[370.116360,256.515847],[370.864785,255.187410]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[347.871985,253.691710],[347.921501,252.631726],[347.683035,251.940685],[347.116294,251.565207],[346.180985,251.451910],[344.642077,251.682973],[343.697047,252.356310],[343.367486,253.442147],[343.674985,254.910710],[344.094491,255.632579],[344.651433,256.073462],[345.962822,256.174673],[347.179543,255.339152],[347.871985,253.691710]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[359.448685,254.861610],[359.741957,253.428352],[359.411810,252.356322],[358.486276,251.684512],[356.993385,251.451910],[355.567072,251.938022],[355.184736,252.514402],[355.052385,253.285210],[355.195211,254.429114],[355.581329,255.348060],[356.829260,256.419935],[357.563986,256.527292],[358.287829,256.318547],[358.937243,255.770915],[359.448685,254.861610]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[381.409185,245.952310],[382.829785,243.277885],[384.139385,238.953910],[384.657318,235.588735],[384.687632,232.415112],[384.255735,229.490640],[383.387035,226.872922],[382.106942,224.619559],[380.440863,222.788152],[378.414208,221.436302],[376.052385,220.621610],[372.713819,220.163783],[369.996910,220.410572],[367.591063,221.439330],[365.185685,223.327410],[363.659667,224.962926],[362.422063,226.746605],[361.474039,228.673584],[360.816760,230.738997],[360.451390,232.937981],[360.379094,235.265671],[361.118385,240.287710],[361.982788,243.412138],[362.785035,245.110385],[363.862457,245.813344],[365.552385,245.951910],[367.205161,245.864552],[368.078997,245.417447],[368.388327,244.333049],[368.347585,242.333810],[368.374444,240.520360],[368.713585,239.024385],[369.410851,237.722097],[370.512085,236.489710],[372.881385,234.263910],[374.033485,236.416510],[374.660472,238.810235],[374.530485,241.551510],[374.364559,243.331070],[374.645530,244.857769],[375.296489,246.082402],[376.240522,246.955760],[377.400720,247.428637],[378.700171,247.451826],[380.061963,246.976119],[381.409185,245.952310]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[341.441785,244.879410],[341.561935,243.197135],[341.003485,241.360510],[340.595632,240.286204],[340.567335,239.190410],[341.722685,236.432910],[343.147122,234.327560],[344.098985,233.451910],[344.612284,233.664999],[345.136769,234.243177],[346.083485,236.128272],[346.667501,238.374137],[346.617185,240.247710],[346.519296,241.170593],[346.760213,242.093072],[348.015360,243.730910],[349.896419,244.749397],[350.919727,244.897690],[351.917185,244.736710],[353.845077,243.631852],[355.123722,241.766297],[355.831974,238.954449],[356.048685,235.010710],[355.847686,231.545324],[355.263052,228.469813],[354.311075,225.806526],[353.008047,223.577810],[351.370262,221.806013],[349.414011,220.513482],[347.155588,219.722565],[344.611285,219.455610],[340.929417,219.921318],[337.731063,221.231533],[335.085492,223.267147],[333.061971,225.909047],[331.729769,229.038125],[331.158154,232.535268],[331.416393,236.281366],[332.573755,240.157310],[335.196155,245.125210],[336.708181,246.126613],[338.611845,246.405335],[340.369071,245.982544],[341.024622,245.514697],[341.441785,244.879410]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[-348.947675,240.266010],[-352.258316,237.414816],[-353.483954,235.785993],[-354.436126,233.991785],[-355.124577,232.009768],[-355.559048,229.817516],[-355.705025,224.712610],[-355.271128,221.115777],[-354.396433,217.983893],[-353.075282,215.311321],[-351.302018,213.092422],[-349.070980,211.321560],[-346.376511,209.993096],[-343.212952,209.101392],[-339.574645,208.640810],[-336.258096,208.574072],[-333.270123,208.820043],[-330.602628,209.382563],[-328.247515,210.265472],[-326.196686,211.472612],[-324.442045,213.007821],[-322.975494,214.874940],[-321.788935,217.077810],[-320.738040,220.144723],[-320.220926,223.306157],[-320.218621,226.483242],[-320.712151,229.597110],[-321.682546,232.568890],[-323.110831,235.319713],[-324.978035,237.770710],[-327.265185,239.843010],[-328.988661,240.865587],[-331.119263,241.567847],[-333.947826,242.017340],[-337.765185,242.281610],[-341.922381,242.381994],[-344.731476,242.158885],[-346.853049,241.493238],[-348.947675,240.266010]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-333.481975,240.030710],[-331.870481,239.199909],[-330.505642,238.145882],[-329.377660,236.847519],[-328.476738,235.283710],[-327.316877,231.275313],[-326.947675,225.951810],[-327.123505,222.270055],[-327.653981,219.098644],[-328.543583,216.431585],[-329.796794,214.262885],[-331.418093,212.586550],[-333.411960,211.396588],[-335.782878,210.687006],[-338.535325,210.451810],[-341.354419,210.770390],[-343.809076,211.699649],[-345.874334,213.199867],[-347.525229,215.231322],[-348.736797,217.754295],[-349.484077,220.729065],[-349.742104,224.115910],[-349.485915,227.875110],[-348.596550,232.113652],[-347.152681,235.501347],[-345.128704,238.082249],[-342.499015,239.900410],[-340.075758,240.962997],[-338.145348,241.333410],[-336.137511,241.019897],[-333.481975,240.030710]]);
    }
    linear_extrude(height=h)
      polygon([[-307.079105,240.942010],[-309.293391,239.334902],[-310.034704,238.231753],[-310.586524,236.725672],[-311.284860,231.895112],[-311.714755,223.624010],[-312.032444,216.862847],[-312.446306,213.050910],[-313.145951,211.228872],[-314.320985,210.437410],[-314.840675,210.047490],[-314.151901,209.768822],[-308.975165,209.515210],[-302.869676,209.687985],[-302.580448,209.881343],[-302.679461,210.167204],[-303.828985,211.081310],[-305.132252,212.234657],[-305.783891,214.068835],[-305.948655,217.683401],[-305.791295,224.177910],[-305.530845,230.494394],[-305.123084,234.180685],[-304.370779,236.208238],[-303.076695,237.548510],[-301.732907,238.383962],[-300.120000,238.980366],[-296.445215,239.456010],[-292.769110,238.975404],[-291.154553,238.376495],[-289.808455,237.538510],[-288.506626,236.197182],[-287.755756,234.175435],[-287.357734,230.488951],[-287.114445,224.153410],[-286.975783,217.672202],[-287.149318,214.053397],[-287.798544,212.211999],[-289.086955,211.063010],[-290.289000,210.147563],[-290.479097,209.861281],[-290.350621,209.666085],[-285.981615,209.448010],[-280.570555,209.448010],[-282.759115,211.487010],[-283.937770,212.887844],[-284.597121,214.882735],[-284.884610,218.317138],[-284.947675,224.036510],[-285.194138,231.361535],[-286.060915,236.271860],[-286.786634,238.009385],[-287.739087,239.368685],[-288.942159,240.424910],[-290.419735,241.253210],[-294.073308,242.135882],[-298.876594,242.362285],[-303.616293,241.955351],[-307.079105,240.938010]]);
    linear_extrude(height=h)
      polygon([[-238.697675,241.789610],[-239.197676,241.277412],[-239.585083,240.255148],[-239.908535,237.118610],[-239.869435,232.951910],[-238.502485,236.093310],[-237.295797,237.978264],[-235.595635,239.437055],[-233.551867,240.449589],[-231.314364,240.995772],[-229.032994,241.055510],[-226.857628,240.608708],[-224.938135,239.635273],[-223.424385,238.115110],[-222.358170,236.243427],[-221.880142,234.518396],[-221.987187,232.944281],[-222.676190,231.525347],[-223.944035,230.265859],[-225.787608,229.170080],[-228.203793,228.242276],[-231.189475,227.486710],[-235.215322,226.310233],[-237.930689,224.630572],[-238.837387,223.564135],[-239.464999,222.326405],[-239.947675,219.276410],[-239.728094,216.853032],[-239.080339,214.707626],[-238.020893,212.854105],[-236.566238,211.306385],[-234.732856,210.078381],[-232.537230,209.184007],[-229.995842,208.637178],[-227.125175,208.451810],[-222.867489,208.612051],[-220.387579,209.263035],[-219.672617,209.852367],[-219.232092,210.660157],[-218.947675,213.058810],[-219.241425,215.455135],[-219.559394,216.184088],[-219.947675,216.451810],[-220.653925,215.874672],[-220.947675,214.487010],[-221.441265,212.884299],[-222.805581,211.605222],[-224.865945,210.758240],[-227.447675,210.451810],[-230.014269,210.741899],[-232.040183,211.599897],[-233.497135,213.007402],[-234.356845,214.946010],[-234.583507,217.788630],[-234.219551,218.922075],[-233.509058,219.892097],[-232.430765,220.720066],[-230.963412,221.427346],[-226.776485,222.565310],[-222.032505,223.833257],[-220.324683,224.627361],[-219.010321,225.573310],[-218.052429,226.704921],[-217.414017,228.056013],[-216.947675,231.551910],[-217.090662,233.740110],[-217.612308,235.515060],[-218.651637,237.183435],[-220.347675,239.051910],[-222.396445,240.943007],[-224.244528,241.950885],[-226.706684,242.339526],[-230.597675,242.372910],[-235.802675,242.169160],[-238.697675,241.789610]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[-158.706815,240.511910],[-161.937813,237.904690],[-164.191128,234.703197],[-165.511566,230.818587],[-165.943935,226.162010],[-165.624192,221.898148],[-164.668752,218.200241],[-163.092295,215.081456],[-160.909504,212.554960],[-158.135060,210.633920],[-154.783644,209.331504],[-150.869939,208.660878],[-146.408625,208.635210],[-142.654190,209.112127],[-139.402710,210.031851],[-136.655482,211.393067],[-134.413801,213.194460],[-132.678966,215.434716],[-131.452272,218.112519],[-130.735016,221.226556],[-130.528495,224.775510],[-130.824238,228.903476],[-131.610907,232.429365],[-132.911848,235.376598],[-134.750404,237.768597],[-137.149920,239.628786],[-140.133741,240.980587],[-143.725211,241.847420],[-147.947675,242.252710],[-151.852582,242.320980],[-154.634296,242.104222],[-156.762485,241.526508],[-158.706815,240.511910]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-143.379565,239.987910],[-141.852644,239.177503],[-140.537038,238.107744],[-139.430366,236.773437],[-138.530248,235.169385],[-137.340143,231.131263],[-136.947675,225.951810],[-137.131090,222.354178],[-137.679205,219.222254],[-138.588824,216.560345],[-139.856754,214.372760],[-141.479799,212.663806],[-143.454764,211.437791],[-145.778454,210.699023],[-148.447675,210.451810],[-151.995400,210.930822],[-154.830805,212.082510],[-156.167367,213.243688],[-157.293472,214.678039],[-158.926957,218.198438],[-159.756549,222.308060],[-159.807539,226.671260],[-159.105217,230.952391],[-157.674874,234.815807],[-155.541800,237.925862],[-154.219642,239.093490],[-152.731285,239.946910],[-150.104274,240.970738],[-148.084799,241.317035],[-146.050637,240.988519],[-143.379565,239.987910]]);
    }
    linear_extrude(height=h)
      polygon([[-50.197675,241.762510],[-51.016137,241.342744],[-51.557141,240.531010],[-51.947675,237.378610],[-51.653925,234.605372],[-51.335956,233.761749],[-50.947675,233.451910],[-50.241425,233.993860],[-49.947675,235.296910],[-49.489206,237.133958],[-48.249888,238.658246],[-46.433858,239.822288],[-44.245249,240.578597],[-41.888197,240.879690],[-39.566837,240.678080],[-37.485305,239.926282],[-35.847735,238.576810],[-34.692179,236.818715],[-34.083825,235.112832],[-34.005223,233.495350],[-34.438920,232.002460],[-35.367466,230.670351],[-36.773408,229.535213],[-38.639295,228.633236],[-40.947675,228.000610],[-44.943932,227.039688],[-47.811919,225.864810],[-49.749828,224.365707],[-50.955855,222.432110],[-51.633398,219.555719],[-51.404136,216.616460],[-50.318879,213.835451],[-48.428435,211.433810],[-47.236337,210.577298],[-45.662268,209.840373],[-41.747176,208.790910],[-37.441082,208.416673],[-33.501905,208.848910],[-32.182318,209.314207],[-31.418175,210.042060],[-31.077077,211.266338],[-31.026625,213.220910],[-31.244389,215.415235],[-31.436728,215.739841],[-31.657115,215.451810],[-32.802166,213.271833],[-34.403820,211.708498],[-36.454762,210.766818],[-38.947675,210.451810],[-41.865579,210.889341],[-44.069145,212.144035],[-45.461976,214.129041],[-45.947675,216.757510],[-45.408889,218.947519],[-43.781980,220.701010],[-41.051124,222.029176],[-37.200495,222.943210],[-33.251920,223.950082],[-31.783000,224.673119],[-30.626708,225.566310],[-29.764833,226.647470],[-29.179164,227.934413],[-28.763595,231.196910],[-29.183994,234.568215],[-30.313771,237.431947],[-32.104751,239.703387],[-34.508755,241.297810],[-37.488716,241.972507],[-41.927223,242.299485],[-46.578725,242.241826],[-50.197675,241.762610]]);
    linear_extrude(height=h)
      polygon([[-14.447675,240.591310],[-16.612685,239.043304],[-18.464884,237.273318],[-19.998295,235.294337],[-21.206940,233.119347],[-22.084843,230.761334],[-22.626026,228.233283],[-22.824512,225.548180],[-22.674325,222.719010],[-21.822987,218.845047],[-20.152703,215.645860],[-17.546932,212.961097],[-13.889135,210.630410],[-11.309284,209.440485],[-8.853060,208.794085],[-5.857819,208.587522],[-1.660915,208.717110],[4.089925,209.273685],[6.981825,210.038610],[7.446023,211.686719],[7.311694,214.180585],[6.736925,216.456763],[6.333778,217.180893],[5.879805,217.451810],[5.392062,217.160535],[5.547145,216.460210],[5.587177,215.877251],[5.243135,215.023035],[3.651615,212.960210],[2.196003,211.722540],[0.650437,210.954247],[-1.263817,210.561837],[-3.825495,210.451810],[-6.076157,210.603921],[-8.137990,211.055349],[-10.001246,211.798736],[-11.656176,212.826722],[-13.093031,214.131952],[-14.302062,215.707065],[-15.273519,217.544704],[-15.997655,219.637510],[-16.625066,224.078507],[-16.164697,228.263569],[-14.752673,232.040927],[-12.525123,235.258810],[-9.618170,237.765449],[-6.167942,239.409076],[-2.310565,240.037919],[-0.271735,239.924369],[1.817835,239.500210],[6.137302,238.518197],[6.872769,238.691293],[7.052325,239.291410],[6.865846,239.899199],[6.333740,240.448350],[4.396640,241.360824],[1.569010,242.009000],[-1.821168,242.373047],[-5.445908,242.433134],[-8.977229,242.169427],[-12.087146,241.562097],[-14.447675,240.591310]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[20.308555,240.807210],[18.537455,239.752694],[16.985013,238.448296],[15.656606,236.904327],[14.557611,235.131097],[13.069361,230.938105],[12.563275,225.951810],[13.045151,220.731776],[13.665739,218.526722],[14.555157,216.563335],[15.725204,214.820382],[17.187677,213.276632],[18.954375,211.910852],[21.037095,210.701810],[24.455583,209.322815],[27.987580,208.546363],[31.531400,208.353003],[34.985359,208.723285],[38.247773,209.637757],[41.216958,211.076969],[43.791230,213.021471],[45.868905,215.451810],[47.076862,217.504646],[47.739707,219.525598],[47.964414,222.064180],[47.857955,225.669910],[47.262284,230.539651],[45.925112,234.285460],[43.605497,237.356494],[40.062495,240.201910],[38.245221,241.132035],[35.961853,241.826601],[30.556467,242.491910],[24.965611,242.163544],[22.450403,241.616017],[20.308555,240.807210]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[37.803845,238.168210],[39.671128,235.794508],[40.979669,232.762647],[41.733542,229.288325],[41.936819,225.587235],[41.593572,221.875073],[40.707874,218.367535],[39.283797,215.280315],[37.325415,212.829110],[35.896087,211.718405],[34.352464,210.983347],[32.556741,210.576846],[30.371115,210.451810],[27.558075,210.654595],[25.183657,211.280102],[23.228319,212.354060],[21.672520,213.902197],[20.496718,215.950243],[19.681371,218.523924],[19.206937,221.648970],[19.053875,225.351110],[19.503413,230.268658],[20.834347,234.331722],[21.823457,236.028699],[23.024658,237.495105],[24.435198,238.725292],[26.052325,239.713610],[29.160588,240.777760],[32.226915,240.865485],[35.143827,239.990923],[37.803845,238.168210]]);
    }
    linear_extrude(height=h)
      polygon([[66.701095,237.279210],[60.166035,221.829710],[56.444742,213.956835],[54.972036,211.739219],[53.746435,210.647410],[53.025587,210.126468],[53.614437,209.800797],[59.552325,209.582910],[65.258679,209.787473],[65.903210,210.073424],[65.232865,210.508710],[63.753969,211.328422],[63.474478,211.983606],[63.544451,213.016035],[64.861268,216.853710],[67.961375,224.123610],[70.921551,230.350510],[72.024024,232.238432],[72.668805,232.924310],[73.354958,232.164800],[74.450687,230.160623],[77.255951,223.902385],[79.854749,217.117835],[81.017235,212.775210],[80.544961,211.087185],[79.997927,210.487635],[79.302325,210.141210],[79.056817,209.956199],[79.682012,209.790622],[83.052325,209.590110],[87.529669,209.738485],[87.677013,209.939729],[87.508243,210.242469],[86.367725,211.224110],[85.043644,213.014952],[83.085084,216.615422],[78.170435,227.451810],[73.350862,238.142673],[71.657517,241.134608],[70.584205,242.279210],[69.745111,242.105994],[68.831807,241.232410],[66.701095,237.279210]]);
    linear_extrude(height=h)
      polygon([[-379.197675,240.420710],[-378.002954,239.743641],[-377.323220,238.618785],[-377.018246,236.598241],[-376.947805,233.234110],[-377.076225,229.594518],[-377.703969,226.728372],[-379.195059,223.607021],[-381.913515,219.201810],[-385.871154,213.728372],[-387.425834,212.063333],[-388.413385,211.451810],[-389.819717,211.164324],[-389.991760,210.856318],[-389.844426,210.484447],[-388.695747,209.686052],[-386.581915,209.043010],[-383.456482,208.749185],[-382.241353,208.996997],[-381.152493,209.586060],[-379.037207,212.022235],[-376.477885,216.526310],[-373.643039,221.417435],[-371.937805,223.451810],[-370.080006,221.395560],[-366.878365,216.451810],[-363.534190,211.508060],[-362.200019,210.004154],[-361.333705,209.451810],[-360.278500,209.625116],[-360.216403,210.481035],[-363.803145,216.256710],[-367.404414,221.833430],[-369.582876,226.010172],[-370.653778,229.534058],[-370.932365,233.152210],[-370.791973,236.378977],[-370.321563,238.529072],[-369.410381,239.883437],[-367.947675,240.723010],[-367.799433,240.838015],[-367.957050,240.945924],[-369.091425,241.130822],[-373.947675,241.309510],[-379.230188,241.115760],[-379.833883,240.838472],[-379.197675,240.420710]]);
    linear_extrude(height=h)
      polygon([[-275.947675,240.723010],[-274.357589,239.691093],[-273.834573,238.782904],[-273.460350,237.444522],[-273.060602,232.971071],[-272.962985,225.258510],[-273.006470,218.179640],[-273.273753,214.188022],[-273.937452,212.169149],[-275.170185,211.008510],[-276.089332,210.154907],[-275.944741,209.880160],[-275.280376,209.687610],[-265.670185,209.451810],[-259.392368,209.515052],[-255.577683,209.787122],[-253.378621,210.391537],[-251.947675,211.451810],[-250.968377,212.628060],[-250.324245,213.858194],[-250.014382,215.135893],[-250.037890,216.454835],[-250.393871,217.808699],[-251.081428,219.191163],[-253.447675,222.016610],[-255.919550,224.550622],[-256.947675,226.007710],[-255.507036,228.660540],[-252.208048,233.306147],[-248.585100,237.897062],[-246.172585,240.385810],[-245.567557,240.871919],[-245.811055,241.186035],[-249.204235,241.421510],[-253.960785,241.451510],[-258.542215,234.304010],[-261.937041,228.896665],[-263.480270,225.939597],[-263.638999,225.151411],[-263.432584,224.701587],[-262.054665,224.451410],[-259.840231,223.852719],[-257.880978,222.284485],[-256.481820,220.088463],[-255.947675,217.606410],[-256.459732,215.049708],[-257.923889,213.111147],[-260.232124,211.881468],[-263.276415,211.451410],[-266.947675,211.451410],[-266.947675,225.483710],[-266.903167,233.438940],[-266.641488,237.729397],[-265.970402,239.631162],[-264.697675,240.420310],[-264.061467,240.838129],[-264.665163,241.115510],[-269.947675,241.309110],[-274.803925,241.129860],[-275.938300,240.945313],[-276.095917,240.837553],[-275.947675,240.722610]]);
    linear_extrude(height=h)
      polygon([[-190.698355,240.763010],[-189.863737,240.412096],[-189.209087,239.774335],[-188.718289,238.743087],[-188.375230,237.211710],[-188.067866,232.222010],[-188.158075,223.952110],[-188.447675,211.952110],[-192.947675,211.952110],[-195.309289,212.029088],[-196.717950,212.344885],[-197.446362,213.026794],[-197.767225,214.202110],[-198.321811,216.055746],[-198.679936,216.393338],[-199.047575,216.363547],[-199.678277,215.278130],[-199.947675,212.952110],[-199.947675,209.452110],[-185.447675,209.452110],[-170.947675,209.452110],[-170.947675,212.952110],[-171.217074,215.278130],[-171.847775,216.363547],[-172.215414,216.393338],[-172.573539,216.055746],[-173.128125,214.202110],[-173.454801,213.055280],[-174.171054,212.323622],[-175.474435,211.893483],[-177.562495,211.651210],[-179.868898,211.555605],[-181.177061,211.850197],[-181.865441,212.764046],[-182.312495,214.526210],[-182.768653,218.226865],[-182.920356,222.996597],[-182.310495,234.253910],[-181.904748,237.391829],[-181.402550,239.306535],[-180.666825,240.322554],[-179.560495,240.764410],[-179.331876,240.927310],[-180.271355,241.063735],[-184.947555,241.200010],[-189.730569,241.079910],[-190.785668,240.938897],[-190.698235,240.763010]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[-109.848755,236.702210],[-109.275284,231.800457],[-109.038038,226.399635],[-109.142840,220.975751],[-109.595515,216.004810],[-110.008752,213.749385],[-110.568433,212.135660],[-111.329154,211.052110],[-112.345515,210.387210],[-112.568084,210.190869],[-112.247946,210.025371],[-110.039316,209.790047],[-99.767015,209.724110],[-91.852333,209.909654],[-87.042158,210.259260],[-84.219411,210.920941],[-82.267015,212.042710],[-80.160551,214.110561],[-78.602955,216.692147],[-77.601015,219.645959],[-77.161519,222.830485],[-77.291253,226.104214],[-77.997006,229.325635],[-79.285564,232.353237],[-81.163715,235.045510],[-84.561669,238.388722],[-86.268258,239.512386],[-88.158660,240.330785],[-90.366929,240.888944],[-93.027119,241.231885],[-100.239475,241.452210],[-110.630605,241.452210]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-89.218485,237.864810],[-86.859370,235.757799],[-85.115077,232.992916],[-83.995168,229.773599],[-83.509204,226.303285],[-83.666745,222.785412],[-84.477351,219.423416],[-85.950584,216.420737],[-88.096005,213.980810],[-89.935062,212.611416],[-91.719951,211.860060],[-94.000645,211.588329],[-97.327115,211.657810],[-103.447675,211.952110],[-103.729345,224.942410],[-103.664170,235.971372],[-103.164033,238.141880],[-102.229345,239.255310],[-101.197218,239.738679],[-99.772885,240.010508],[-96.192451,239.967097],[-92.377750,239.220168],[-89.218485,237.864810]]);
    }
    linear_extrude(height=h)
      polygon([[-70.197675,240.421010],[-68.925657,239.633715],[-68.254493,237.747322],[-67.992419,233.501824],[-67.947675,225.637210],[-67.993645,217.791019],[-68.257763,213.520960],[-68.929336,211.567876],[-70.197675,210.672610],[-71.009853,210.129946],[-70.551255,209.797722],[-64.947675,209.583210],[-59.660914,209.786360],[-59.059137,210.064907],[-59.697675,210.483310],[-60.970532,211.272877],[-61.641604,213.177872],[-61.903211,217.477787],[-61.947675,225.452110],[-61.903209,233.426491],[-61.641600,237.726435],[-60.970528,239.631441],[-59.697675,240.421010],[-59.058255,240.840254],[-59.659305,241.120260],[-64.947675,241.325410],[-70.236045,241.120260],[-70.837095,240.840254],[-70.197675,240.421010]]);
    linear_extrude(height=h)
      polygon([[93.802325,240.789910],[94.385362,239.790955],[94.771969,237.158022],[95.052325,225.836610],[95.008422,217.634232],[94.747750,213.221210],[94.076866,211.277563],[92.802325,210.483310],[92.449084,210.266465],[92.543318,210.078038],[94.095397,209.784385],[102.802325,209.515510],[115.052325,209.452510],[115.052325,212.452510],[114.758575,214.571260],[114.440606,215.215791],[114.052325,215.452510],[113.346075,214.865010],[113.052325,213.452510],[112.864824,212.390001],[112.052324,211.785835],[110.239824,211.515007],[107.052325,211.452510],[101.052325,211.452510],[101.052325,217.452510],[101.052325,223.452510],[105.584545,223.452510],[107.916903,223.363832],[109.433131,223.028535],[110.384221,222.342726],[111.021165,221.202510],[111.453806,220.383568],[111.723451,220.589172],[111.872935,224.452510],[111.701491,227.823022],[111.544808,228.448440],[111.363135,228.203210],[110.491963,226.910069],[108.798286,225.992960],[106.522259,225.535076],[103.904035,225.619610],[102.603068,225.971010],[101.898391,226.931635],[101.608609,229.066047],[101.552325,232.938810],[101.727174,237.540068],[102.068866,238.951617],[102.689521,239.866397],[103.671227,240.356373],[105.096071,240.493508],[109.603525,239.997110],[111.794006,239.560472],[113.266006,238.946910],[114.232674,238.021947],[114.907155,236.651110],[115.771615,234.824435],[115.973375,237.702510],[116.052375,241.452510],[104.302375,241.373510],[96.371125,241.169747],[94.244172,240.992290],[93.802375,240.790110]]);
    linear_extrude(height=h)
      polygon([[122.052325,240.722910],[123.642411,239.691035],[124.165427,238.782847],[124.539650,237.444460],[124.939398,232.970985],[125.037015,225.258410],[124.993530,218.179554],[124.726247,214.187960],[124.062548,212.169091],[122.829815,211.008410],[121.903783,210.154512],[122.037499,209.879752],[122.683501,209.687247],[132.107315,209.451710],[140.185930,209.695854],[142.972423,210.054527],[145.046226,210.618485],[146.499228,211.423390],[147.423319,212.504904],[147.910388,213.898690],[148.052325,215.640410],[147.857825,217.247363],[147.233670,218.788335],[146.118880,220.372919],[144.452475,222.110710],[140.852615,225.505810],[145.100575,232.025810],[148.710044,237.057397],[151.422925,239.998810],[152.450910,240.799380],[152.492924,241.235122],[148.836205,241.451810],[144.175075,241.451810],[138.791455,233.201810],[133.407845,224.951710],[136.217075,224.639310],[138.043351,224.118864],[139.580220,223.078204],[140.783033,221.645847],[141.607142,219.950310],[142.007900,218.120111],[141.940659,216.283766],[141.360770,214.569794],[140.223585,213.106710],[137.853602,211.937885],[134.723585,211.451710],[131.052325,211.451710],[131.052325,225.484010],[131.096833,233.439240],[131.358512,237.729697],[132.029598,239.631462],[133.302325,240.420610],[133.938533,240.838429],[133.334837,241.115810],[128.052325,241.309410],[123.196075,241.130160],[122.061700,240.945613],[121.904083,240.837853],[122.052325,240.722910]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[28.249725,-166.107030],[23.975088,-167.384779],[20.574869,-168.878168],[16.962728,-171.174255],[12.052325,-174.860100],[4.891811,-180.787560],[-2.228216,-187.461700],[-9.244348,-194.819577],[-16.093175,-202.798250],[-22.029230,-209.684188],[-24.083572,-211.778914],[-25.133285,-212.548250],[-25.453538,-211.705809],[-25.620411,-209.458418],[-25.557174,-202.428390],[-25.069884,-194.817367],[-24.284855,-189.984550],[-22.919669,-188.707744],[-20.359245,-187.519070],[-18.184919,-186.454551],[-17.079013,-185.214868],[-16.965805,-184.620086],[-17.166608,-184.090410],[-18.572785,-183.371570],[-32.072785,-183.357070],[-41.619898,-183.892681],[-43.445849,-184.388381],[-43.947675,-185.131800],[-43.732289,-185.782890],[-43.145841,-186.471985],[-41.218025,-187.635560],[-39.068423,-188.717326],[-37.733335,-189.860810],[-37.195591,-198.060481],[-36.962985,-216.107120],[-37.056589,-231.951164],[-37.272903,-236.941933],[-37.682200,-240.405430],[-38.344461,-242.661826],[-39.319666,-244.031293],[-40.667797,-244.834004],[-42.448835,-245.390130],[-44.566765,-246.376045],[-45.211048,-247.002429],[-45.447675,-247.620200],[-45.292090,-248.021401],[-44.757992,-248.340262],[-42.150186,-248.761811],[-27.947675,-248.956150],[-18.604215,-248.840397],[-12.682260,-248.531225],[-8.893013,-247.904413],[-5.947675,-246.835740],[-2.550279,-245.057887],[-0.039973,-243.075763],[1.881948,-240.588134],[3.514185,-237.293770],[4.536841,-234.118222],[4.940405,-231.023759],[4.741752,-228.053032],[3.957757,-225.248694],[2.605298,-222.653395],[0.701249,-220.309787],[-1.737514,-218.260522],[-4.694115,-216.548250],[-8.400465,-214.552520],[-9.944115,-213.264910],[-7.722221,-209.313523],[-2.450755,-201.307523],[3.767706,-192.351050],[8.830585,-185.548250],[13.142412,-180.609590],[17.493491,-176.678243],[22.683215,-173.127291],[29.510975,-169.329820],[34.763153,-166.349341],[35.997989,-165.404382],[36.304994,-164.822098],[35.683917,-164.601854],[34.134513,-164.743018],[28.249725,-166.107030]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-13.986315,-219.028270],[-11.686325,-220.534174],[-9.806894,-222.416021],[-8.368594,-224.603714],[-7.391994,-227.027156],[-6.897664,-229.616252],[-6.906174,-232.300903],[-7.438094,-235.011015],[-8.513995,-237.676490],[-9.686856,-239.344542],[-11.334687,-240.856153],[-13.335520,-242.163121],[-15.567390,-243.217245],[-17.908328,-243.970323],[-20.236369,-244.374152],[-22.429543,-244.380532],[-24.365885,-243.941260],[-25.127197,-242.714275],[-25.671754,-240.013391],[-26.109818,-232.065887],[-25.678515,-223.850675],[-25.136364,-220.815155],[-24.376285,-219.119680],[-22.442704,-218.000078],[-19.837405,-217.609627],[-16.904063,-217.951353],[-13.986355,-219.028280]]);
    }
    difference()
    {
       linear_extrude(height=h)
         polygon([[-312.947675,-171.850560],[-318.023119,-173.615469],[-322.754012,-175.917310],[-327.137936,-178.753807],[-331.172471,-182.122681],[-334.855201,-186.021656],[-338.183707,-190.448454],[-341.155571,-195.400798],[-343.768375,-200.876410],[-345.168814,-204.553139],[-345.960863,-208.082420],[-346.315687,-212.676656],[-346.404455,-219.548250],[-346.066682,-228.898424],[-345.555974,-232.649253],[-344.749774,-236.008064],[-343.597375,-239.142971],[-342.048071,-242.222089],[-337.555915,-248.885420],[-333.828603,-253.350294],[-329.867813,-257.130514],[-325.636211,-260.243071],[-321.096465,-262.704961],[-316.211241,-264.533177],[-310.943205,-265.744711],[-305.255024,-266.356557],[-299.109365,-266.385710],[-294.884137,-266.092411],[-291.082647,-265.549460],[-287.629037,-264.724571],[-284.447448,-263.585457],[-281.462020,-262.099834],[-278.596894,-260.235414],[-275.776212,-257.959911],[-272.924115,-255.241040],[-270.217144,-252.219492],[-267.797713,-248.983892],[-265.668419,-245.556084],[-263.831862,-241.957910],[-262.290640,-238.211217],[-261.047352,-234.337846],[-260.104596,-230.359644],[-259.464971,-226.298452],[-259.131076,-222.176117],[-259.105510,-218.014481],[-259.390870,-213.835388],[-259.989755,-209.660683],[-260.904765,-205.512210],[-262.138497,-201.411812],[-263.693551,-197.381334],[-265.572525,-193.442620],[-268.519798,-188.587701],[-271.965683,-184.250944],[-275.861794,-180.463711],[-280.159748,-177.257362],[-284.811158,-174.663258],[-289.767641,-172.712760],[-294.980812,-171.437227],[-300.402285,-170.868020],[-307.420334,-171.026496],[-312.947675,-171.850560]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-292.105905,-180.477420],[-288.525305,-182.850716],[-285.342172,-186.062227],[-282.581446,-190.051497],[-280.268070,-194.758069],[-278.426986,-200.121487],[-277.083136,-206.081294],[-276.261462,-212.577034],[-275.986905,-219.548250],[-276.290591,-227.545818],[-277.007565,-233.433590],[-278.232968,-237.727058],[-279.829462,-241.686079],[-281.758650,-245.293554],[-283.982139,-248.532385],[-286.461532,-251.385474],[-289.158435,-253.835723],[-292.034453,-255.866032],[-295.051189,-257.459305],[-298.170249,-258.598442],[-301.353237,-259.266346],[-304.561759,-259.445918],[-307.757419,-259.120060],[-310.901822,-258.271673],[-313.956572,-256.883660],[-316.883275,-254.938921],[-319.643535,-252.420360],[-322.363020,-249.017325],[-324.641239,-245.075762],[-326.485107,-240.682891],[-327.901539,-235.925929],[-328.897449,-230.892096],[-329.479753,-225.668611],[-329.655365,-220.342691],[-329.431200,-215.001557],[-328.814173,-209.732428],[-327.811199,-204.622520],[-326.429192,-199.759055],[-324.675067,-195.229250],[-322.555739,-191.120324],[-320.078123,-187.519496],[-317.249133,-184.513985],[-314.075685,-182.191010],[-310.985371,-180.535678],[-308.075349,-179.298493],[-305.304628,-178.476258],[-302.632219,-178.065775],[-300.017132,-178.063847],[-297.418377,-178.467277],[-294.794965,-179.272867],[-292.105905,-180.477420]]);
    }
    linear_extrude(height=h)
      polygon([[-194.367635,-182.255700],[-204.842685,-196.048250],[-222.683809,-219.232639],[-228.122182,-225.785652],[-230.697675,-228.303760],[-231.026301,-228.259402],[-231.294655,-227.858599],[-231.667374,-225.802884],[-231.874675,-215.381580],[-231.597331,-204.374996],[-231.033105,-196.635750],[-230.461610,-193.405051],[-229.475063,-191.211957],[-227.442479,-189.171718],[-223.732875,-186.399580],[-222.323285,-185.025595],[-222.053503,-184.444487],[-222.143275,-184.037320],[-225.850543,-183.507399],[-233.428895,-183.144399],[-241.253037,-183.054839],[-245.697675,-183.345240],[-246.804010,-184.141256],[-246.805765,-185.257159],[-245.796610,-186.475877],[-243.870215,-187.580340],[-241.920259,-188.478600],[-240.442009,-189.543873],[-239.375642,-191.072847],[-238.661335,-193.362207],[-238.239266,-196.708644],[-238.049611,-201.408843],[-238.128255,-216.057280],[-238.447675,-238.705480],[-242.241385,-242.180380],[-245.636514,-244.719527],[-246.924410,-245.120894],[-248.073165,-245.008420],[-249.097577,-244.769872],[-249.669256,-244.919242],[-249.869462,-245.537322],[-249.779455,-246.704900],[-249.421847,-247.983058],[-248.490871,-248.727302],[-246.516940,-249.121698],[-243.030465,-249.350310],[-237.660589,-249.284008],[-235.547762,-248.895359],[-233.666634,-248.197404],[-231.904922,-247.135912],[-230.150344,-245.656652],[-226.213465,-241.227910],[-209.961245,-221.048250],[-201.744679,-211.062834],[-197.818525,-206.714920],[-197.480389,-207.817647],[-197.203486,-211.066539],[-196.947675,-221.997030],[-197.171252,-233.392979],[-197.522679,-237.274082],[-198.097824,-240.167314],[-198.944658,-242.240204],[-200.111151,-243.660285],[-201.645274,-244.595086],[-203.594995,-245.212140],[-206.383340,-246.275595],[-207.168946,-246.923214],[-207.447675,-247.585770],[-207.215263,-247.973106],[-206.556648,-248.320156],[-204.192533,-248.887642],[-196.898838,-249.475856],[-189.274186,-249.258295],[-186.496376,-248.818561],[-185.026175,-248.142840],[-184.529380,-247.340266],[-184.599891,-246.662849],[-185.314452,-245.977360],[-186.749805,-245.150570],[-189.008968,-243.402797],[-190.306915,-241.338300],[-190.744179,-231.292976],[-190.934025,-210.357270],[-191.207769,-189.282569],[-191.517333,-183.334274],[-191.921035,-181.064720],[-193.041229,-181.166425],[-194.367635,-182.255700]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[69.334565,-183.596960],[66.279919,-185.030566],[63.422443,-186.814807],[60.774700,-188.917284],[58.349255,-191.305603],[56.158672,-193.947366],[54.215515,-196.810176],[52.532349,-199.861637],[51.121737,-203.069351],[49.996245,-206.400923],[49.168437,-209.823954],[48.650877,-213.306049],[48.456129,-216.814811],[48.596757,-220.317843],[49.085326,-223.782748],[49.934401,-227.177129],[51.156545,-230.468590],[53.639393,-235.047905],[56.882116,-239.410639],[60.564086,-243.180248],[64.364675,-245.980190],[69.544557,-248.274830],[75.461930,-249.700052],[81.570312,-250.169749],[87.323225,-249.597810],[91.076072,-248.515091],[94.556069,-246.913357],[97.747203,-244.839301],[100.633459,-242.339613],[103.198822,-239.460984],[105.427278,-236.250106],[107.302812,-232.753670],[108.809410,-229.018366],[109.931057,-225.090886],[110.651740,-221.017922],[110.955443,-216.846163],[110.826151,-212.622301],[110.247851,-208.393028],[109.204528,-204.205035],[107.680168,-200.105011],[105.658755,-196.139650],[102.579107,-191.873876],[98.809067,-188.284675],[94.485135,-185.419180],[89.743810,-183.324525],[84.721591,-182.047842],[79.554978,-181.636265],[74.380469,-182.136927],[69.334565,-183.596960]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[86.334445,-187.919370],[89.042094,-189.391914],[91.423335,-191.362688],[93.477848,-193.831031],[95.205309,-196.796280],[96.605396,-200.257774],[97.677788,-204.214852],[98.422161,-208.666851],[98.838195,-213.613110],[98.811386,-222.054762],[98.406850,-225.592134],[97.718117,-228.757960],[96.727604,-231.615305],[95.417728,-234.227236],[93.770906,-236.656819],[91.769555,-238.967120],[88.804912,-241.602735],[85.720103,-243.503422],[82.566343,-244.668222],[79.394845,-245.096176],[76.256823,-244.786326],[73.203491,-243.737712],[70.286064,-241.949376],[67.555755,-239.420360],[65.843100,-237.272929],[64.410317,-234.916947],[63.249488,-232.321338],[62.352695,-229.455025],[61.319542,-222.785978],[61.247515,-214.661190],[61.642440,-209.606087],[62.372763,-205.111863],[63.451952,-201.151969],[64.893477,-197.699859],[66.710808,-194.728983],[68.917413,-192.212795],[71.526763,-190.124747],[74.552325,-188.438290],[77.821753,-187.164807],[80.645375,-186.663950],[83.368002,-186.920533],[86.334445,-187.919370]]);
    }
    linear_extrude(height=h)
      polygon([[-163.183195,-183.697330],[-163.636470,-184.141381],[-163.831686,-184.708382],[-163.563500,-185.986652],[-162.609754,-187.082992],[-161.201565,-187.548250],[-159.271184,-188.005532],[-157.170185,-189.104950],[-156.443210,-189.675779],[-155.895033,-190.440746],[-155.234144,-193.800404],[-154.985647,-201.678539],[-154.947675,-216.569770],[-154.992139,-230.984435],[-155.226090,-238.866364],[-155.800369,-242.333664],[-156.262269,-243.073736],[-156.865815,-243.504440],[-158.999728,-244.140779],[-161.523637,-244.105633],[-164.245557,-243.493039],[-166.973506,-242.397037],[-169.515501,-240.911667],[-171.679558,-239.130966],[-173.273694,-237.148974],[-174.105925,-235.059730],[-174.884008,-233.453752],[-176.204531,-232.809522],[-177.688039,-233.165984],[-178.955075,-234.562080],[-179.423000,-235.918737],[-179.442441,-237.661724],[-177.998265,-243.607610],[-175.899105,-250.518640],[-168.173385,-249.783440],[-156.842103,-249.264214],[-140.447675,-249.048250],[-126.138630,-248.795846],[-121.642535,-248.522632],[-119.821135,-248.189000],[-119.827009,-246.046276],[-120.609220,-242.005347],[-121.811423,-237.585515],[-123.077275,-234.306080],[-124.469201,-233.064615],[-126.494675,-232.548250],[-127.844693,-232.644150],[-128.509756,-233.129260],[-128.630396,-234.299698],[-128.347145,-236.451580],[-128.102237,-238.557838],[-128.261228,-239.967376],[-128.935022,-241.006259],[-130.234525,-242.000550],[-133.283718,-243.263992],[-136.880900,-243.797650],[-140.093910,-243.560886],[-141.265049,-243.140895],[-141.990585,-242.513060],[-142.351521,-239.957557],[-142.649399,-234.082334],[-142.932365,-215.869680],[-142.826994,-200.082557],[-142.215116,-191.609499],[-141.592130,-189.408140],[-140.689988,-188.186174],[-139.457848,-187.660557],[-137.844865,-187.548250],[-136.444036,-187.131290],[-135.403836,-186.123554],[-134.964928,-184.889758],[-135.367975,-183.794620],[-139.882496,-183.295269],[-149.077623,-183.101919],[-158.371730,-183.230594],[-163.183195,-183.697320]]);
    difference()
    {
       linear_extrude(height=h)
         polygon([[-75.662025,-184.250360],[-75.818028,-185.449405],[-75.423465,-186.507082],[-74.588637,-187.260871],[-73.423845,-187.548250],[-72.641721,-187.716599],[-71.941008,-188.190703],[-70.858349,-189.870511],[-70.324936,-192.216352],[-70.489835,-194.856900],[-71.794081,-199.445700],[-73.544834,-203.510875],[-75.465602,-206.519705],[-76.403338,-207.461515],[-77.279895,-207.939470],[-81.421032,-208.389952],[-87.592003,-208.501176],[-93.421502,-208.292415],[-96.538225,-207.782940],[-97.892671,-205.707629],[-99.334479,-201.883582],[-100.480522,-197.522577],[-100.947675,-193.836390],[-100.807821,-192.058881],[-100.283064,-190.725859],[-99.215612,-189.592942],[-97.447675,-188.415750],[-94.170147,-186.043620],[-93.764621,-185.196910],[-94.225230,-184.549481],[-95.584956,-184.081118],[-97.876781,-183.771602],[-105.388655,-183.548250],[-113.987249,-183.836905],[-116.445103,-184.180463],[-117.505305,-184.641500],[-117.409379,-185.393719],[-116.645546,-186.632202],[-113.615385,-189.891500],[-110.972674,-192.619819],[-108.717464,-196.113190],[-106.117560,-201.748269],[-102.440765,-210.901710],[-91.731675,-237.313870],[-89.598621,-242.466264],[-88.512981,-245.763940],[-88.293294,-247.972353],[-88.758095,-249.856960],[-89.385071,-252.237470],[-89.310625,-253.770000],[-88.757144,-254.093544],[-87.930522,-253.802761],[-85.643993,-251.603456],[-82.823310,-247.622565],[-79.840745,-242.310570],[-68.347963,-217.377581],[-62.364807,-203.683429],[-59.058125,-195.548250],[-57.953232,-192.734825],[-56.664796,-190.576019],[-54.982912,-188.793290],[-52.697675,-187.108100],[-50.097566,-184.989285],[-49.928429,-184.258644],[-50.585954,-183.716796],[-54.599137,-183.108330],[-62.573415,-182.981580],[-72.316890,-183.317331],[-74.725308,-183.702982],[-75.662025,-184.250360]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-78.947675,-215.117770],[-79.961697,-218.206116],[-82.274526,-223.788642],[-84.792310,-229.343401],[-86.421195,-232.348440],[-87.547740,-233.027543],[-88.092584,-232.833632],[-88.663351,-232.231282],[-89.997282,-229.642885],[-91.778785,-224.945580],[-93.702340,-219.045830],[-93.994340,-217.202500],[-93.762859,-215.946766],[-92.950174,-215.166051],[-91.498563,-214.747777],[-86.447675,-214.548250],[-81.150800,-214.715545],[-78.947675,-215.117770]]);
    }
    linear_extrude(height=h)
      polygon([[16.723975,-184.443620],[16.246965,-185.173276],[16.189996,-185.778921],[16.575971,-186.341915],[17.427795,-186.943620],[21.110448,-189.310305],[22.212608,-190.676505],[22.939397,-192.665638],[23.378870,-195.653471],[23.619081,-200.015774],[23.853935,-214.366870],[23.803799,-233.577609],[23.391370,-238.199518],[22.654965,-240.956850],[21.213000,-243.497774],[20.476923,-244.274232],[19.853355,-244.563560],[18.118383,-244.870554],[16.907489,-245.622617],[16.400768,-246.634769],[16.778315,-247.722030],[17.883273,-248.334241],[20.163187,-248.691364],[29.464015,-248.737710],[39.073064,-248.186400],[40.672237,-247.623007],[41.052325,-246.706950],[40.830021,-245.938953],[40.215040,-245.161641],[38.118625,-243.879380],[36.781872,-243.230952],[35.759116,-242.236012],[35.014660,-240.615121],[34.512807,-238.088836],[34.094120,-229.202322],[34.217475,-213.340940],[34.550952,-199.402444],[35.248665,-191.637139],[35.838093,-189.516476],[36.643360,-188.275562],[37.706060,-187.693214],[39.067785,-187.548250],[40.460865,-187.120450],[41.346010,-186.103901],[41.530497,-184.898879],[40.821605,-183.905660],[36.812745,-183.384445],[28.780015,-183.123630],[20.011484,-183.369805],[17.824364,-183.787743],[16.723975,-184.443620]]);
  }
}

module PlateOutline (){
    color("grey"){
        difference(){
            translate([-60,-25,0]){
                minkowski(){
                    cube([120,50,1]);
                    cylinder(r=10,h=1);
                }
            }
            union(){
                translate([-50,25,0])cylinder(d=5,h=10,center=true);
                translate([-50,-25,0])cylinder(d=5,h=10,center=true);
                translate([50,25,0])cylinder(d=5,h=10,center=true);
            }
        }
    }
}

translate([10,0,0])scale([.4,.4,1])OntarioPlate(4);
PlateOutline();
linear_extrude(height=4)scale([.75,1,1])text(PlateText,font="Univers 57 Condensed",valign="center",halign="center",size=FontHeight);