
// Module names are of the form poly_<inkscape-path-id>().  As a result,
// you can associate a polygon in this OpenSCAD program with the corresponding
// SVG element in the Inkscape document by looking for the XML element with
// the attribute id="inkscape-path-id".

// fudge value is used to ensure that subtracted solids are a tad taller
// in the z dimension than the polygon being subtracted from.  This helps
// keep the resulting .stl file manifold.
fudge = 0.1;

module VW(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    difference()
    {
       linear_extrude(height=h)
         polygon([[-12.091459,152.355875],[-18.451909,151.442575],[-26.451909,150.414475],[-33.451909,148.845475],[-47.224908,145.063950],[-53.857493,142.928144],[-57.951909,141.353375],[-69.938499,135.191474],[-79.978752,129.646963],[-87.675365,124.949258],[-92.631036,121.327775],[-100.455146,114.800915],[-105.096843,110.618946],[-110.354805,105.313199],[-115.789397,99.347121],[-120.960979,93.184155],[-125.146121,87.369219],[-129.917101,79.616315],[-135.345869,69.801520],[-141.504379,57.800905],[-145.312789,46.800905],[-148.028529,37.172134],[-150.554699,26.300905],[-151.347808,21.290769],[-151.909391,14.891464],[-152.341157,-0.254807],[-151.856344,-15.498222],[-151.272204,-22.018956],[-150.461299,-27.199095],[-149.457259,-32.199095],[-147.729638,-39.489256],[-145.241480,-47.389328],[-142.109001,-55.649780],[-138.448417,-64.021082],[-134.375943,-72.253702],[-130.007795,-80.098110],[-125.460189,-87.304774],[-120.849339,-93.624165],[-113.930636,-101.732118],[-106.338858,-109.664356],[-99.034825,-116.470230],[-92.979356,-121.199095],[-89.490996,-123.858875],[-82.863526,-128.308715],[-76.951879,-132.148935],[-73.615924,-134.093489],[-66.807073,-137.423136],[-52.451879,-143.680865],[-44.444147,-146.482018],[-34.951879,-148.699095],[-25.451879,-150.786645],[-21.106589,-151.521037],[-15.618957,-152.045878],[-0.951879,-152.485265],[8.617278,-152.359412],[16.623858,-151.900738],[23.592569,-151.063845],[30.048121,-149.803335],[35.048121,-148.803985],[40.689281,-147.478119],[47.528708,-145.262796],[55.121258,-142.358927],[63.021784,-138.967423],[70.785143,-135.289196],[77.966189,-131.525156],[84.119776,-127.876215],[88.800761,-124.543285],[94.300761,-120.201225],[99.643846,-115.404298],[107.539612,-107.690586],[115.253325,-99.794820],[120.050251,-94.451735],[124.392311,-88.951735],[127.720207,-84.279979],[131.361302,-78.143563],[135.116991,-70.982342],[138.788667,-63.236171],[142.177722,-55.344905],[145.085551,-47.748400],[147.313546,-40.886511],[148.663101,-35.199095],[149.750441,-29.699095],[150.728331,-25.199095],[151.445612,-20.458549],[151.952942,-14.340752],[152.341157,0.170354],[151.899783,14.621736],[151.370129,20.664878],[150.635631,25.300905],[148.548081,34.800905],[146.331001,44.293173],[143.529851,52.300905],[137.272122,66.656099],[133.942475,73.464950],[131.997921,76.800905],[128.157701,82.712555],[123.707861,89.340025],[121.048081,92.828385],[116.319215,98.883859],[109.513338,106.187902],[101.581100,113.779684],[93.473151,120.698375],[88.106652,124.682071],[82.163343,128.585358],[75.765525,132.346926],[69.035502,135.905463],[62.095575,139.199658],[55.068045,142.168199],[48.075217,144.749775],[41.239391,146.883075],[31.223504,149.469250],[20.048081,151.336175],[13.334310,151.826155],[2.603308,152.258938],[-7.440195,152.485265],[-12.091469,152.355875]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[21.048091,117.397615],[27.048091,116.116315],[30.889721,115.219515],[32.740961,114.441415],[32.140562,112.251608],[30.181856,107.444245],[25.090331,96.702625],[20.214461,85.702625],[14.849071,73.465380],[5.552931,53.300905],[1.607751,44.050905],[0.870762,42.461843],[0.074021,41.800905],[-1.450823,44.039894],[-3.938359,49.422995],[-9.357522,61.875177],[-17.083849,78.453235],[-20.951909,87.114095],[-24.070246,94.369190],[-30.695889,108.584015],[-32.128665,111.799851],[-32.618791,113.718928],[-32.171891,114.721298],[-30.793589,115.187015],[-27.451959,116.045915],[-20.476649,117.293515],[-15.054979,118.364475],[-9.724901,118.594703],[1.682819,118.413493],[13.747396,117.966060],[21.048041,117.397615]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-53.858279,104.550905],[-57.905389,95.300905],[-72.166869,63.800905],[-77.604969,51.935625],[-83.601166,38.435625],[-86.330724,32.411415],[-88.013896,29.350905],[-88.676364,28.296969],[-88.951906,27.097075],[-90.243974,23.460188],[-93.350426,16.547075],[-102.437026,-3.699095],[-107.934096,-15.699095],[-111.440249,-23.199095],[-113.609174,-28.012480],[-115.036319,-30.457425],[-115.537094,-30.805056],[-115.478759,-30.575945],[-115.405062,-29.648635],[-115.868859,-28.317615],[-116.962766,-24.536805],[-117.764336,-18.410381],[-118.269325,-10.658079],[-118.473487,-1.999632],[-118.372576,6.845225],[-117.962347,15.156756],[-117.238553,22.215228],[-116.196949,27.300905],[-115.383129,30.300905],[-114.000427,34.975080],[-111.450748,41.832108],[-108.403599,49.173534],[-105.528486,55.300905],[-101.471320,62.397689],[-96.743145,69.366383],[-91.427335,76.120453],[-85.607267,82.573363],[-79.366315,88.638579],[-72.787854,94.229565],[-65.955261,99.259785],[-58.951909,103.642705],[-53.226659,106.791515],[-53.858279,104.550905]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[60.048091,102.615695],[60.382358,102.040248],[61.186021,101.800905],[62.611651,101.284761],[64.975470,99.861990],[71.555242,95.050554],[79.000479,88.874567],[85.386321,82.841995],[91.066495,76.479116],[96.452114,69.779202],[100.470280,64.149022],[101.631286,62.174698],[102.048091,60.995345],[102.483416,59.817342],[103.530051,58.461805],[105.974624,54.261141],[109.471847,46.617410],[112.754310,38.480652],[114.554601,32.800905],[115.307981,30.300905],[116.497941,25.503385],[118.203061,15.830265],[118.645311,11.872371],[118.873111,6.919011],[118.740126,-4.652187],[117.913637,-16.239499],[116.503181,-25.199095],[115.801121,-28.949095],[115.460978,-30.126518],[115.139380,-30.135021],[114.718796,-29.759173],[113.586763,-27.861789],[112.077071,-24.449095],[109.665342,-19.066282],[107.151531,-14.199095],[104.776541,-9.461965],[103.319989,-5.414542],[98.519961,5.300905],[95.521701,12.321375],[92.176617,20.026307],[87.004961,30.800905],[83.240601,39.303695],[78.111611,50.803695],[70.376011,67.800905],[62.411951,85.050905],[60.145408,89.818093],[59.455081,91.800905],[58.755777,93.864922],[56.467651,98.827335],[53.048091,106.311215],[54.076216,106.143928],[56.548091,105.099515],[59.019966,103.681415],[60.048091,102.615695]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[-36.420709,40.800905],[-28.914659,24.300905],[-22.935229,11.050905],[-19.655829,3.800905],[0.067731,3.800905],[19.791301,3.800905],[24.554411,14.550905],[30.060421,26.300905],[31.491241,29.545085],[36.722351,41.511395],[41.265531,51.233525],[42.805091,48.295155],[47.088141,38.828845],[52.429311,26.546245],[55.110491,20.046245],[57.023811,16.300905],[61.556741,6.829475],[67.229174,-6.143226],[72.045311,-16.199095],[75.949531,-24.940235],[81.475791,-37.190235],[83.807128,-42.140241],[84.548091,-44.199095],[85.250257,-46.181907],[87.488311,-50.949095],[93.486811,-64.044185],[95.164673,-68.499407],[95.360446,-70.188312],[95.011734,-71.815566],[94.031755,-73.604284],[92.333724,-75.777582],[86.436371,-82.170375],[80.504061,-87.912192],[73.684053,-93.784583],[67.726347,-98.357050],[65.617731,-99.708781],[64.380941,-100.199095],[63.841758,-99.863743],[63.134424,-98.950657],[61.582591,-95.949095],[58.011191,-88.199095],[54.161441,-79.495485],[48.916051,-67.495485],[43.477221,-55.699095],[36.705561,-40.949095],[33.658012,-34.063157],[32.693071,-31.199095],[32.428398,-30.178745],[31.064451,-27.725565],[29.026797,-23.869297],[27.142361,-19.475565],[22.624891,-8.928655],[19.882761,-3.158215],[-0.082089,-3.428655],[-20.046939,-3.699095],[-23.590309,-11.699095],[-29.738649,-25.199095],[-32.325539,-31.199095],[-35.647759,-38.457955],[-41.050469,-50.457955],[-44.931449,-59.199095],[-49.516039,-68.789695],[-54.951909,-81.199095],[-60.715252,-93.975946],[-62.848231,-98.025243],[-64.135429,-99.812515],[-64.781333,-99.821309],[-65.856971,-99.371681],[-69.070993,-97.297881],[-78.164855,-89.857196],[-87.793772,-80.702087],[-91.676611,-76.485259],[-94.334496,-73.044185],[-95.250641,-71.418687],[-95.452439,-69.883765],[-94.861325,-67.686195],[-93.398736,-64.072755],[-87.727946,-51.227665],[-77.689769,-29.199095],[-67.301419,-6.477545],[-63.951909,1.300905],[-61.327371,7.502119],[-54.301869,22.666185],[-48.304749,36.166185],[-43.392019,46.515725],[-42.374942,48.579858],[-41.951909,50.432385],[-41.843716,51.585088],[-41.202459,50.915500],[-36.420709,40.800905]]);
       translate([0, 0, -fudge])
         linear_extrude(height=h+2*fudge)
           polygon([[4.554051,-49.912635],[13.276551,-69.162635],[20.119051,-84.402715],[25.180131,-95.902715],[30.857511,-108.004595],[32.259600,-111.440112],[32.506327,-113.628168],[32.172288,-114.368508],[31.520438,-114.933915],[29.224681,-115.722505],[24.798091,-116.734485],[20.943472,-117.536179],[16.760307,-118.096258],[3.518731,-118.884575],[-4.144984,-119.077018],[-10.567903,-118.845060],[-17.315165,-118.068893],[-25.951909,-116.628715],[-28.899223,-115.931043],[-31.070429,-115.135205],[-32.397847,-114.708118],[-33.316499,-114.897015],[-33.409425,-114.707512],[-33.062936,-113.584366],[-31.356059,-109.265301],[-26.017139,-97.433165],[-22.951909,-90.738565],[-19.289319,-82.504495],[-15.539319,-74.126215],[-11.303079,-64.626215],[-3.905039,-48.449095],[-1.394883,-43.328782],[0.077461,-41.199095],[1.694943,-43.758696],[4.554051,-49.912635]]);
    }
  }
}

VW(8);

translate([0,41,0]){
    difference(){
        translate([-2.5,0,0])cube([5,10,8]);
        translate([-5,2,2])cube([10,6,4]);
        }
    }