//  Ioniq 5 magnetic glasses holder
// designed for 2 8 mm dia, 3 mm thick magnets
// all(); to see full holder
// generate back() to print
// generate top() and flip over to print
// attach pieces and magnets with glue
//  R Benecict March, 2023

magr=4+.2; // or use your magnet radius
magh=3+.3; // or use your magnet height
bakz=magh+2;  // back thickness

trih=18; // nosepiece height 
triw=20;  // nosepiece width 
triz=14;  // adjust for deeper holder gap
trizp=triz+.1; // taller hole
trir=4;  // nosepiece radius
frh =trih+2*trir; // front height
frz=3; // front thickness

scr=1.8; // attachment width
scrp=scr+.1; // slightly larger hole

$fn=90;

module back(){
    difference() {
        union(){
            minkowski() {
                translate([-(triw)/2,0,0])
                cube([triw, frh, bakz/2]);
                cylinder(r=trir,h=bakz/2);
            }
         
        cylinder(r=scr,h=bakz+triz-1);
        translate([0,11,0])
        cylinder(r=scr,h=bakz+triz-1);
        translate([-scr,0,0])
        cube([2*scr,11,bakz+triz-1]); 
        
    }
        translate([triw/3,frh-magr,0])
        cylinder(r=magr, h=magh);
        translate([-triw/3,frh-magr,0])
        cylinder(r=magr, h=magh);    
    
        
    }
}


module tri(){
//    translate([0,0,bakz])
    difference() {
        minkowski() {
            linear_extrude(height=triz/2)
            polygon(points =[[-triw/2,0],[triw/2,0],[0,trih]]);
            cylinder(r=trir,h=triz/2);
        }
        cylinder(r=scrp,h=trizp);    
        translate([0,11,0])
        cylinder(r=scrp,h=trizp);
        translate([-scrp,0,0])
        cube([2*scrp,11,trizp]); 
    }   
}


module front(){
    minkowski() {
        translate([-(triw)/2,0,triz])
        cube([triw, frh,frz/2]);
        cylinder(r=trir,h=frz/2);
    }
}

module top(){
    union(){
        front();
        tri();
    }
}

//tri();
//top();
back();

module all(){
    back();
    translate([0,0,bakz])
    top();
}

//all();