Text = "Text";

module __Customizer_Limit__ () {}  // This actually works
PI = 3.14159;
chars_per_circle = 30;
radius = 24.2;
step_angle = 360 / chars_per_circle;
circumference = 2 * PI * radius;
char_size = circumference / chars_per_circle;
char_thickness = 0.5;
$fn=100;

rotate([0,180,0])


union(){
    difference(){
        union(){
            sphere(d=54,$fn=100);
            cylinder(d=54,h=40,$fn=100);
        }
        sphere(d=50.2);
        cylinder(d=50.2,h=40.1);
    }
    translate([0,0,16])
    rotate_extrude(angle=360, convexity=10){
        translate([25,0,0])
            circle(d=0.4,$fn=80);
    }
} 



rotate([0,0,90])

translate([0,0,-20])
for(i = [0 : chars_per_circle - 1]) {
    rotate(i * step_angle) 
        translate([0, radius + char_size / 2, 0]) 
            rotate([90, 0, 180]) linear_extrude(char_thickness) text(
                Text[i], 
                font = "Courier New; Style = Bold", 
                size = char_size, 
                valign = "center", halign = "center"
            );
}