//Radius of long side
R1=44.7541;
//Width of long side
R1Width=35;
//Radius of short side
R2=44.7541;
//Width of short side
R2Width=50.45;
//Radius of key face
R3=196.2658;
//Thickness of key
R3Width=13.15;
//Wall Thickness
Wall=2;
//Cut Height
CutHeight=13;
//Sphere Resolution
$fn=100;

module KeyBillet(Thickness){
	intersection(){
		//Long Side
		translate([0,R1-R1Width/2,0]){sphere(r=R1+Thickness);}
		translate([0,-R1+R1Width/2,0]){sphere(r=R1+Thickness);}
		//Short Side
		translate([R2-R2Width/2,0,0]){sphere(r=R2+Thickness);}
		translate([-R2+R2Width/2,0,0]){sphere(r=R2+Thickness);}
		//Face
		translate([0,0,R3-R3Width/2]){sphere(r=R3+Thickness*2);}
		translate([0,0,-R3+R3Width/2]){sphere(r=R3+Thickness);}
	}
}

fudge = 0.1;

module Honda_H(h)
{
  scale([25.4/90, -25.4/90, 1]) union()
  {
    linear_extrude(height=h)
      polygon([[-77.366078,-54.598215],[-28.080363,-64.955358],[-19.598220,-38.616072],[-17.459951,-34.684437],[-15.085405,-32.347668],[-12.534231,-31.203136],[-9.866078,-30.848215],[10.133923,-30.848215],[14.122621,-32.095741],[16.472792,-33.623866],[18.041921,-35.572201],[19.687494,-38.080358],[28.437498,-65.401787],[77.276778,-54.508929],[77.366078,57.276788],[41.473208,65.223218],[21.562494,-3.883929],[20.458138,-6.302249],[19.034279,-8.625900],[17.944066,-9.675642],[16.463813,-10.609816],[14.490132,-11.397790],[11.919637,-12.008929],[-11.562506,-11.919639],[-15.265225,-10.801370],[-18.169643,-9.017851],[-20.270492,-6.564691],[-21.562506,-3.437501],[-41.116078,65.401788],[-77.008935,57.187498]]);
  }
}

intersection(){
	difference(){
		KeyBillet(Wall);
		KeyBillet(0);
		translate([0,0,Wall*.5+CutHeight]){cube([R2Width+Wall*3,R1Width+Wall*3,R3Width+Wall*3],center=true);}
		translate([-(R2Width+Wall*3)/2,-(R1Width+Wall*3)/2,-(R3Width+Wall*3)-R3Width/2-Wall]){cube([R2Width+Wall*3,R1Width+Wall*3,R3Width+Wall*3]);}
	}
	//Honda H Cut-out
	translate([0,0,-(R3Width+Wall*3)/2]){rotate(a=[0,0,90]){Honda_H(R3Width+Wall*3);}}
	//rotate(a=[0,0,90]){linear_extrude(file="HondaH.dxf",layer="0",height=R3Width+Wall*3,center=true,convexity=10,twist=0);}
}