$fn = 200;

module keyhole(radius, height, width) {
  cylinder(r = radius, h = height);
  translate([-radius, 0, 0]) {
    cube([radius * 2, width - radius, height]);
  }
  translate([0, width - radius, 0]) {
    cylinder(r = radius, h = height);
  }
}

module bevel(radius, height, width) {
  rotate_extrude() {
    polygon([[radius - width, 0], [radius, height], [radius - width, height]]);
  }
}

difference() {

  // MAIN BODY +FIRST STAGE REMOVAL
  union() {
    difference() {

      // MAIN BODY
      union() {
        difference() {
          // BASE CYLINDER SHAPE
          cylinder(h = 53, r = 10);

          // MINUS LOWER OUTER PART
          difference() {
            cylinder(h = 38, r = 10);
            cylinder(h = 38, r = 9);
          }
          
        }

        // ADD THE BEVEL THING
        translate([0, 0, 36]) {
          bevel(10, 2, 1);
        }
      }

      // FIRST REMOVAL
      union() {

        // TOP - NARROW CYLINDER
        translate([0, 0, 47]) {
          difference() {
            cylinder(r = 10, h = 6.5);
            cylinder(r = 7, h = 6.5);
          }
        }

        // FLAT TOP CUTS
        translate([-5, 6, 47]) {
          cube([10, 2, 4.5]);
        }
        translate([-5, -8, 47]) {
          cube([10, 2, 4.5]);
        }

      }
    }

    // BEGIN REBUILDING TOP

    // TOP FLAT PIECES
    translate([-17 / 2, -7 / 2, 49.75]) {
      cube([17, 7, 1.5]);
    }

    // SECOND FLAT(ISH) PIECES
    translate([-7 / 2, 6, 47.75]) {
      difference() {
        cube([7, 3, 1.5]);
        translate([0, 0, 0.5]) {
          cube([7.5, 2, 1]);
        }
      }
    }
    mirror([0, 1, 0]) {
      translate([-7 / 2, 6, 47.75]) {
        difference() {
          cube([7, 3, 1.5]);
          translate([0, 0, 0.5]) {
            cube([7.5, 2, 1]);
          }
        }
      }
    }

  }

  // SECOND STAGE REMOVAL
  union() {

    // TOP LIP STRUCTURE
    translate([0, 0, 51.25]) {
      difference() {
        cylinder(r = 10, h = 1);
        cylinder(r = 5.5, h = 1);
      }
      difference() {
        cylinder(r = 10, h = 2);
        cylinder(r = 6, h = 2);
      }
    }

    // THE PEG
    translate([-3, -10, 12]) {
      cube([6, 20, 6.5]);
    }

    // THE SLOT
    translate([-.75, 7, 0]) {
      cube([1.5, 2, 12]);
    }

    // KEYHOLE
    rotate(a = 90, v = [1, 0, 0]) {
      h = 32;
      r = 2.5;
      translate([0, r + h, -10]) {
        keyhole(r, 20, 8.0);
      }
    }

    // MINE IS THE DRILL THAT WILL PIERCE THE HEAVENS!
    translate([0, 0, -1]) {
      cylinder(h = 55, r = 3.5);
      cylinder(h = 45, r = 7.5);
      cylinder(h = 26, r = 8.1);
    }

  }
}