// acura integra 90-91
spline_major=19.9;
spline_minor=17.7;
spline_count=24;
pilot_diam=14.9;

// acura integra 92- (any b-series car including civics I think)
//spline_major=25.9;
//spline_minor=22;
//spline_count=24;
//pilot_diam=14.9;

spline_length=40;
handle_length=30;



spline_depth=(spline_major-spline_minor)/2;
major_circumference=3.14159*spline_major;
minor_circumference=3.14159*spline_minor;

//spline_width=major_circumference/(spline_count*2);
spline_bottom_width=minor_circumference/(spline_count*2);
spline_width=(major_circumference-(spline_bottom_width*spline_count))/spline_count;


cylinder(r=spline_major/2, h=handle_length);

translate([0,0,handle_length-0.01])
	union() {
		difference() {
			cylinder(r=spline_major/2, h=spline_length);
			
			for (c=[0:spline_count])
				rotate([0,0,c*360/spline_count])
					translate([spline_minor/2+0.001,0,-0.5])
						linear_extrude(height=spline_length+1)
							polygon(points=[[0,-spline_bottom_width/2],[spline_depth,-spline_width/2],[spline_depth,spline_width/2],[0,spline_bottom_width/2]]);				
		}
		
		cylinder(r=pilot_diam/2, h=spline_length+13);
	}