// hub_cover.scad
res=100;

//disc
r1 = (149.9-1)/2;
d2 = 6.2; //center 
z1 = 3.0;

//cutout
x1 = 10;
y1 = 5;
z2 = z1+0.1;

r2 = 140/2; //innen abstand

r3 = 10; // circle cutout radius
r4 = r3-2; // thickness circle cutout radius
z5 = 10; // cutout height

module clip()
{
    deg1 = 16;
    translate([0,0,z1/2]) 
        rotate([0,0,90-deg1/2])
            rotate_extrude(angle=deg1,$fn=200) 
                translate([r2,0,0])    
                    polygon( points=[[0,0],[1.5,0],[1.5,6],[2.5,7],[2.5,9],[1.5,10],[0,10],[-5,0]]);   
   
}

//cutout bolts
module circle_cutout(){
    mirror([0,0,1])
        translate([0,r2-15,-z1+4])
        {
            difference()
            {
                cylinder(z5,r3,r3,center = false, $fn=res);
                translate([0,0,-0.5])
                    cylinder(z5+1,r4,r4,center = false, $fn=5); 
            }  
        }
}

module base_disc()
{
    difference()
    {
        cylinder(z1,r1,r1,center = true, $fn=res);
        translate([0,-r1,0])
            cube([x1,y1,z2], center = true);
    }
}

module version()
{
    translate([0,0,0.6])
        linear_extrude(height = 2, $fn = res) { text("V01", size = 10, valign="center", halign="center");}
}

module main()
{   
    difference()
    {
        base_disc();
        union()
        {    
            for (i =[-3:3])
            {
                rotate([0,0,72*i])  
                    circle_cutout();    
            }
            //version();
        }
    }
    for (i =[-3:3])
    {
        rotate([0,0,45*i])  
            clip(); 
    }
}

main();