/*prototype dims:
L=173.4
W=73.7
H=70.9
*/

rez=30; // resolution for cylinders

fullchassis();
//basebody();

module fullchassis(){
difference(){
 basebody();
 translate([30,9.5,17])rotate([0,90,17])punchout(15,3,2,1);//wshield
 translate([28.5,13,17])rotate([0,90,90])punchout(15,6.25,2,1);//fr sun
 translate([18.5,13,17])rotate([0,90,90])punchout(15,5.75,2,1);//mid sun
 translate([9,13,17])rotate([0,90,90])punchout(15,1.2,2,1);//rear sun
 translate([-0,10.5,17])rotate([0,90,-40])punchout(15,5.25,2,1);//r window
 translate([1.5,7,17])rotate([0,90,0])punchout(15,2,6,1);//luggage area
}

seat(22.5,1.5); //front seat
seat(13,1.5); //back seat

translate([-.5,6,.75])color("red")cube([1,1.5,1.5]);//l taillight
translate([-.5,6,16.5])color("red")cube([1,1.5,1.5]);//r taillight

translate([0.24,-3,.5])wheel(.3,1); //lr wheel
translate([32.5,-3,.5])wheel(.3,1); //lf wheel
translate([0.24,-3,18.5])wheel(.3,1); //rr wheel
translate([32.5,-3,18.5])wheel(.3,1); //rf wheel
translate([7.15,.5,1])color("blue")diff(3.95,7.25,6,1.3,180); //r diff
translate([7.15,.5,.5])color("blue")axle(3.95,7.25,7); //r axle
translate([32.5-0.24+7.15,.5,1])color("blue")diff(3.95,7.25,6,1.3,0); //f diff
translate([32.5-0.24+7.15,.5,.5])color("blue")axle(3.95,7.25,7); //f axle
translate([9.75,0,9.5])rotate([0,90,3])cylinder(r=.75,h=20,$fn=rez); //rear dshaft
translate([27,1.25,9.5])rotate([0,90,-6])cylinder(r=.75,h=10,$fn=rez); //front dshaft

translate([-1.25,0,0])cube([1.5,1.5,19]); //rear bumper
translate([44.8,2.0,0])cube([1.5,1.5,19]); //front bumper

translate([-1,2,16.5])rotate([0,90,0])scale([])wheel(.3,2);//spare

/* fill/fabric */
translate([6.95,14.5,2])color("black")cube([3,.2,15]); //rear
translate([11.9,14.5,2])color("black")cube([7.4,.2,15]); //mid
translate([21.4,14.5,2])color("black")cube([8.0,.2,15]); //front
}


module grill(){
 hr=1;
 mr=.25;
 mw=.4;
 s=1.8;
 c=19;
  translate([.8+hr,3.1,0])cylinder(r=hr,h=1,$fn=rez); //r headlight
  translate([19-hr-.8,3.1,0])cylinder(r=hr,h=1,$fn=rez); //l headlight
  translate([(19/2-mw/2)-s-s-s,0.5,0]) 
   minkowski(){ cube([mw,3,1]); cylinder(r=mr,h=.01,$fn=rez); }
  translate([(19/2-mw/2)-s-s,0.5,0]) 
   minkowski(){ cube([mw,3,1]); cylinder(r=mr,h=.01,$fn=rez); }
  translate([(19/2-mw/2)-s,0.5,0]) 
   minkowski(){ cube([mw,3,1]); cylinder(r=mr,h=.01,$fn=rez); }
  translate([(19/2-mw/2),0.5,0]) //center
   minkowski(){ cube([mw,3,1]); cylinder(r=mr,h=.01,$fn=rez); }
  translate([(19/2-mw/2)+s,0.5,0]) 
   minkowski(){ cube([mw,3,1]); cylinder(r=mr,h=.01,$fn=rez); }
  translate([(19/2-mw/2)+s+s,0.5,0]) 
   minkowski(){ cube([mw,3,1]); cylinder(r=mr,h=.01,$fn=rez); }
  translate([(19/2-mw/2)+s+s+s,0.5,0]) 
   minkowski(){ cube([mw,3,1]); cylinder(r=mr,h=.01,$fn=rez); }
}


module axle(r,h,l){
  cylinder(r=r,h=h/4,$fn=rez);
  translate([0,0,h/4])
  cylinder(r1=r,r2=0,h=h,$fn=rez);
  translate([0,0,l]){
    translate([0,0,h/4+h])
     cylinder(r=r,h=h/4,$fn=rez);
    translate([0,0,h/4])
     cylinder(r2=r,r1=0,h=h,$fn=rez);
  }
  cylinder(r=r/3,h=h+l,$fn=rez);
}


module diff(r,h,l,s,yrot){
 difference(){
  translate([0,0,h/4+h-h/16])
rotate([0,yrot,0])
  union(){
    translate([-r,h/8,0])
  cube([r*3,h/3.33,l*2],center=true);
   sphere(r=r*.75,$fn=rez);
  }
  scale([s,s,1])axle(r,h,l);
 }
}

module seat(x,y){
color("red") 
  translate([x+2,y+.3,0])rotate([0,0,102])cushion(10,2,19,1.5);
  translate([x,y,0])rotate([0,0,7])cushion(6,2,19,1.5);
}

module cushion(x,y,z,r){
  translate([r,r,r]){
  minkowski(){
    cube([x-2*r,y/2-0,z/2-2*r]);
    rotate([90,90,0])cylinder(r=r,h=1,$fn=rez);
  }
  translate([0,0,z/2])
  minkowski(){
    cube([x-2*r,y/2-0,z/2-2*r]);
    rotate([90,90,0])cylinder(r=r,h=1,$fn=rez);
  }
 }
}

module basebody(){
difference(){
union(){
translate([0,1,1])
difference(){color("red")
 minkowski(){
   cube([45,13,17]);//z was 14
   translate([])rotate([0,90,0])cylinder(r=1,h=1,$fn=rez);
  }
  translate([2,-1,17.5])fender(); //rr fender line
  translate([45,-1,20.5])rotate([0,180,0])fender(); //rf fender line
  translate([2,-1,-2])fender(); //lr fender line
  translate([45,-1,1])rotate([0,180,0])fender(); //lf fender line
}
  translate([2.3,0,16])scale([.95,.95,1])fender(); //rr fender flare
  translate([44.7,0,19])rotate([0,180,0])scale([.95,.95,1])fender(); //rf fender flare
  translate([2.3,0,0])scale([.95,.95,1])fender(); //lf fender flare
  translate([44.7,0,3])rotate([0,180,0])scale([.95,.95,1])fender(); //lr fender flare
}
  translate([3.1,0,-2])scale([.80,.80,8])fender(); //rear wheelwell
  translate([43.8,0,20])rotate([0,180,0])scale([.80,.80,8])fender(); //front wheelwell
  translate([0,-5,-1])cube([50,5,22]); //trim chassis bottom
  translate([43,-3,-1])cube([5,5,22]); //trim front fender
translate([28,17,0])rotate([0,0,-90+24])mold(25,8); // trim windshield
translate([34.1,6.45,0])rotate([0,0,-5])mold(10,15); // trim hood
translate([36.75,7.75,0])rotate([0,0,-22])mold(5,5); // trim nose
translate([40.5,9,0])rotate([0,0,-90+18])mold(5,5); //trim grill
translate([-1,3.25,0])rotate([0,0,50])mold(6,12); //trim rear window
translate([2.5,0,0])rotate([0,0,90])mold(6,12); //trim back end
union(){ //trim backseat
  translate([14.2,3.5,-1])rotate([0,0,42])punchout(3,3,20,1);
  translate([15,3.5,-1])rotate([0,0,0])punchout(4,9.5,20,1); 
  translate([12.25,5.8,-1])rotate([0,0,0])punchout(4,7.2,20,1);
} 
union(){ // trim front seat
  translate([22,6.5,-1])rotate([0,0,0])punchout(8,6.5,20,1); 
  translate([24,3.5,-1])rotate([0,0,42])punchout(3,3,20,1);
  translate([24.75,3.5,-1])rotate([0,0,0])punchout(7.25,3.5,20,1);
  translate([27.25,12,-1])rotate([0,0,-71])cube([6.25,4,22]);
}

union(){ //trim cargo area
  translate([6.75,10.2,-1])rotate([0,0,50])punchout(2,2,20,1);
  translate([6.75,9.2,-1])rotate([0,0,0])punchout(2.5,3.8,20,1);
translate([3.35,9.2,-1])trianglepunchout();
} 
translate([9,8,1])cube([3,6,17]); //punch out rear rollbar
translate([18.5,2.5,1])cube([4,11,17]); //punch out front rollbar

 translate([44.5,3.4,19])rotate([0,90,18])grill();//grill details

}
translate([44.8,2.0,0])cube([1.5,1.5,19]); //front bumper
}




module punchout(x,y,z,r){
  minkowski(){
    cube([x,y,z]);
    cylinder(r=r,h=z,$fn=rez);
  }
}

module mold(len,thick){
 translate([0,0,-1]) rotate([90,0,90])
 difference(){
  cube([len+2,21,thick+2]);
  translate([-.5,2,-1])punchout(2,17,thick+2,1);
 }
}


//outline shape
module fender(){
 minkowski(){
  linear_extrude(height=2)
   polygon(points=[[0,0],[12,0],[7.5,5],[2,5]],
    paths=[[0,1,2,3]]);
  cylinder(r=1,h=1,$fn=rez);
 }
}

//outline shape
module trianglepunchout(){
 minkowski(){
  linear_extrude(height=22)
   polygon(points=[[0,0],[3.1,0],[3.1,tan(50)*3.1]],
    paths=[[0,1,2]]);
  cylinder(r=1,h=1,$fn=rez);
 }
}

module wheel(xy,z){
scale([xy,xy,z])
translate([0,0,-.5])
linear_extrude(height=1){
import("wheel.dxf");
}
}

