mm=25.4;

box_x = .375*mm;
box_y =.745*mm;
box_z = .100*mm;

crimp_x = box_x;
crimp_y = .325*mm;
crimp_z = .275*mm;

rod_d = .175*mm;
space_x = box_x/2;
space_y = crimp_y + 2;
space_z = .110*mm;
space_z2 = .200*mm;

flange_x = .090*mm;
flange_y = .450*mm;
flange_z = crimp_z;

hole_od1 = .250*mm;
hole_od2 = .270*mm;
hole_od3 = .214*mm;
hole_ht1 = .150*mm;
hole_ht2 = .190*mm;
hole_center_dist_y = .725*mm;
hole_y_padding = .140*mm;
total_y = .952*mm;
hole_z = .425*mm; 

space2_x = .200*mm;
space2_y = space_z;
space2_z = .430*mm;

    
module assembly ()
{
//initial plate
cube([box_x, box_y, box_z]);

//add crimp box
difference() {
    translate([0,0,box_z]) cube([crimp_x, crimp_y, crimp_z]);
    translate([box_x/2, -1, box_z+rod_d/2]) rotate([270,0,0])cylinder (d=rod_d, h = crimp_y+2, $fn=40);
    translate([0,-1,box_z]) rotate ([0,-5,0]) cube([space_x, space_y, space_z]);
    translate([-1.5,-1,space_z2]) rotate ([0,25,0]) cube([space_x, space_y, space_z]);
};
//add flange on left
hull(){
    translate([box_x-flange_x, crimp_y, box_z]) cube ([flange_x, .1, flange_z/2]); 
    translate([box_x-flange_x, crimp_y, box_z]) cube ([flange_x, flange_y, .1]);
}
//build through hole
translate([box_x/2,box_y, 0]) cylinder(d2 = rod_d+hole_y_padding, d1=box_x, h = box_z,$fn=40);
translate([box_x/2, box_y,-hole_ht1]) cylinder(d = hole_od1, h = hole_ht1,$fn=40);
translate([box_x/2, box_y,-(hole_ht1+hole_ht2)]) cylinder (d1 = hole_od3, d2 = hole_od2, h = hole_ht2, $fn= 40);
}
difference(){
assembly();
translate([box_x/2, box_y, -hole_z+1]) cylinder (d = rod_d, h = hole_z+2, $fn=40);
translate([0,box_y-space2_y/2, -(space2_z+1-box_z)]) cube([space2_x, space2_y, space2_z+2]);
}
