// Round corner radius.
MR=5;

// Z offset for wheels.
WO=-1;

CUT=40;

// Make a trapezoid with 4 inclined sides.
// h is height
// l2 and w2 is the length of width of top face.
// l1 is the front extrusion, l3 is back extrusion.
// w1 is the extrusion on left and right sides.
module trapezoid(l1,l2,l3,w1,w2,h) {
    p = [[0,0,0],[0,w1*2+w2,0],[l1+l2+l3,w1*2+w2,0],[l1+l2+l3,0,0],
         [l1,w1,h],[l1,w1+w2,h],[l1+l2,w1+w2,h],[l1+l2,w1,h]];
    f = [[0,3,2,1],[4,5,6,7],[0,1,5,4],[0,4,7,3],[1,2,6,5],[2,3,7,6]];
    polyhedron(points=p, faces=f);
}

// Body has two trapezoid and a cubic base.
//  - base is length l_front+l_middle, height h_base.
//  - middle has length l_middle at the top, and l_front+l_middle at bottom. It has vertical sides and back. Only front is inclined.
//  - top is inclined on 4 sides. front incline by s
module box_body(l_front,l_middle,s_front,s_back,w,s_side,h_base,h_middle,h_top) {
  // top of car.
  translate([0,0,h_base+h_middle]) trapezoid(l1=s_back,l2=l_middle-s_front-s_back, l3=s_front, w1=s_side, w2=w-s_side*2, h=h_top);
  // middle
  translate([0,0,h_base])trapezoid(l1=0, l2=l_middle, l3=l_front, w1=0, w2=w, h=h_middle);
  // base
  cube([l_middle+l_front,w,h_base]);
}

$fn=100;
module body(l_front,l_middle, s_front, w, s_side, h_base, h_middle, h_top) {
  translate([MR,MR,MR])
  minkowski() {
   box_body(l_front-MR, l_middle-MR, s_front, 3, w-MR*2, s_side,
            h_base-MR, h_middle, h_top-MR);
   sphere(r=MR);
  }
}

module body_shell() {
  difference() {
    body(l_front=30,l_middle=64,s_front=15, w=49, s_side=4.5, h_base=18, h_middle=3, h_top=22);
    translate([1,1.5,1])body(l_front=29.6, l_middle=62.4, s_front=15, w=46, s_side=4.5, h_base=16, h_middle=2.5, h_top=22.5);
    windows();
  }
}

module wheel_slot(r,d,x,y) {
  translate([x,y+1,WO])rotate([-90,0,0])cylinder(r=r,h=d);
}

module wheels(r, o, w=8) {
    wheel_slot(r,w,20,8-w-o);
    wheel_slot(r,w,70,8-w-o);
    wheel_slot(r,w,20,39+o);
    wheel_slot(r,w,70,39+o);
}

module window0(w,h,x) {
  translate([x,0,24])minkowski(){
      cube([w-2,10,h-2]);
      rotate([90,0,0])cylinder(r=2,h=0.1);
  }
}
module window(w1,w2,h,x,sym=false) {
  o=2;
  wo1=w1-2*o;
  wo2=w2-2*o;
  ho=h-2*o;
  d = sym ? (w1-w2)/2 : 0;

  translate([x,20,24])rotate([90,0,0])linear_extrude(height=20){
      offset(r=o)translate([o,o])polygon([[0,0],[wo1,0],[wo2+d,ho],[d,ho]]);
  }
}


module windows() {
 for (y=[0,40]) { translate([0,y,0]) {
    translate([19,0,0])mirror([1,0,0])window(13,11,14,0);
    window(13,13,14,23);
    window(17.5,10,14,39.5);
  } }
  translate([70,6.5,2])rotate([0,0,90])  window(36,32,14, 0,sym=true);
  translate([10,8,1])rotate([0,0,90])  window(33,29,15, 0,sym=true);
}

module bearing_connector(x, y, cr=1.2) {
  translate([x+4,y+6,0])cylinder(r=cr,h=3);
  translate([x-4,y+6,0])cylinder(r=cr,h=3);
}

module bearing_body() {
  translate([-6,2,-3])cube([12,8,3]);
  bearing_connector(0, 0, cr=0.6);
}
module bearing() {
  difference() {
    bearing_body();
    axel(0, 1.5);
  }
}

module bearings() {
  translate([20,6,0])bearing();
  translate([20,43,0])mirror([0,1,0])bearing();
  translate([70,6,0])bearing();
  translate([70,43,0])mirror([0,1,0])bearing();
}

module axel(x, r) {
  translate([x,0,WO])rotate([-90,0,0])cylinder(r=r,h=80);
}

module light(y) {
  translate([96,y,10]) {
    rotate([0,-90,0])cylinder(r=4, h=3);
  }
}

module grill() {
  for (i = [0:5]) {
      translate([90, 14 + i*4, 14]) rotate([0,90,0]) 
      linear_extrude(height=5) {
        offset(r=1)square([8,0.1]);
      }
  }
}
module hood_support(y) {
  MR2=MR*2;
  translate([73.5-MR,y,MR+1])rotate([90,0,0])linear_extrude(height=0.6) {
    offset(r=MR)polygon([[0,0],[30-MR2,0],[30-MR2,18-MR*1.4],[0,20.5-MR*1.4]]);
  }
}

module whole_body() {
  body_shell();

  // Wheel shell
  wheels(13,0);

  for (y=[9:31.5/4:40.5]) {
    hood_support(y);
  }

  // block behind grill.
  translate([89, 12, 5]) cube([5, 25, 11]);

  light(7);
  light(42);
}

module side_connectors(inward=0) {
  translate([8+inward, 6+inward, CUT-3])cube([41-inward*2,1,4]);
  translate([8+inward,42-inward, CUT-3])cube([41-inward*2,1,4]);
}

module real_wheel() {
  difference() {
    cylinder(r=10, h=6);
    cylinder(r=8, h = 6.1);
  }
  difference() {
    cylinder(r=3, h=6);
    translate([0,0,1])cylinder(r=1.2, h = 6.1);
  }
  for (d=[0:30:340]) {
     rotate([0,0,d]) translate([1,-0.5,0])cube([8,1,6]);
  }
}

module twistry_wheel(ro=10, ri=5, w=6) {
  difference() {
    cylinder(r=ro, h=w);
    cylinder(r=ro-2, h = w+0.1);
  }
  difference() {
    cylinder(r=ri, h=6);
    translate([0,0,1])cylinder(r=1.2, h = 6.1);
  }
  for (d=[0:30:340]) {
     rotate([0,0,d]) translate([1,-0.5,0])cube([8,1,6]);
  }
}

module car(top) {
 difference() {
  whole_body();

  grill();

  // Make hollow space for wheels
  wheels(12,1.01);
  // Remove the wheel shell below body.
  translate([0,0,-15])cube([100,100,15]);

  // Leave some space for axels.
  axel(20, 1.75);
  axel(70, 1.75);

  bearing_connector(20,6);
  bearing_connector(20,31);
  bearing_connector(70,6);
  bearing_connector(70,31);

  // Cut an opening for inspection.
  // translate([10,40,0])cube([100,50,60]);
 
  if (top) {
    translate([-1,0,-1])cube([100,50,CUT+1]);
  } else {
    translate([-1,0,CUT])cube([100,50,40]);
    side_connectors(inward=0);
  }

 }
}

// To show the wheels and bearings.
%translate([0,-50,0]){ 
  bearings();
  difference() {
    wheels(10,3,w=6);
    axel(20, 0.8);
    axel(70, 0.8);
  }
}

// To print the top of the car, 4 bears and 4 wheels.
module top_and_wheels() {
  mirror([0,0,1])translate([0,0,-43]) {
    car(top=true);side_connectors(inward=0.4);
  }
  for (x=[0:25:75])translate([x,50,3]) bearing();
  for (x=[0:25:75])translate([x,80,0]) real_wheel();
}

%top_and_wheels();
translate([0,-50,0]) {
  car(top=false);
  
  // To show top piece above the main body.
  %union(){car(top=true); side_connectors(inward=0.4);}
}
