//Set the text to render. A "---" will generate a horizontal line of thickness textsize. Text before a "|" will be right-aligned, text after a "|" will be left aligned. You can have many lines, leave the last ones empty if not needed. 
text1="! Caution !";
text2="---";
text3="Max. capacity:|14 clowns";
text4="Music style:|Picked by driver";
text5="Batteries:|Not included";
text6="";
text7="";
text8="";
text9="";
text10="";
text11="";
text12="";
text13="";
text14="";
text15="";
text16="";
text17="";
text18="";
text19="";
text20="";

//Set font sizes in mm. Here is one number for each text line above. Note e.g. that the first lines font size is bigger (13). Also note that to get a 1mm line, you have to set the font size to 8.
font_sizes=[13,10,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]; 

//text1="We ain't";
//text2="Got shit";
//text3="---";
//text4="Try next door";
//text5="";
//text6="";
//text7="";
//text8="";
//text9="";
//text10="";
//textsizes=[16,16,10,8,8,8,8,8,8,8]; 
//fontname="Coustard";

//text1="+";
//text2="SAFETY";
//text3="FIRST";
//text4="DRINK";
//text5="WITH A";
//text6="NURSE";
//text7="";
//text8="";
//text9="";
//text10="";
//textsizes=[30,8,8,8,8,8,8,8,8,8]; 

//text1="Coast Guard Capacity Information";
//text2="---";
//text3="Maximum persons|3";
//text4="Maximum gross load|100kg";
//text5="Persons, motor & equip.|50 pounds";
//text6="Maximum horsepower|42hp";
//text7="---";
//text8="This boat complies with safety standards";
//text9="in effect on date of certification";
//text10="Model#: 3  Serial No: 23542134   Mfr.: Coolboats";
//textsizes=[13,10,8,8,8,8,10,8,8,8]; 

//text1="|Some";
//text2="|people are";
//text3="|like clouds.";
//text4="|When they";
//text5="|disappear,";
//text6="|it's a";
//text7="|beautiful";
//text8="|day.";
//text9="|";
//text10="|";
//textsizes=[10,10,10,10,10,10,10,10,10,10,10,10]; 

//text1="TV channels";
//text2="---";
//text3="Canal Ocho|8";
//text4="W&G TV|9";
//text5="Broken Antenna|11";
//text6="SaltV|25";
//text7="Antarctica Television|34";
//text8="Drying paint|71";
//text9="Noflix|72";
//text10="---";
//textsizes=[13,10,8,8,8,8,8,8,8,10,6,1]; 

//text1="Wine";
//text2="---";
//text3="Chardonnay|$9.00";
//text4="Merlot|$8.00";
//text5="Oops|$8.00";
//text6="Arrogant Frog|$11.00";
//text7="Cat's Pee|$7.00";
//text8="Mad Housewife|$13.00";
//text9="";
//text10="";
//textsizes=[13,10,10,10,10,10,10,10,10,1,6,1]; 

//text1="|DO NOT";
//text2="|READ";
//text3="|THE NEXT";
//text4="|SENTENCE.";
//text5="|";
//text6="|";
//text7="|";
//text8="---";
//text9="|You little rebel. I like you.";
//text10="---";
//textsizes=[13,13,13,13,8,8,8,10,6,10]; 


//Font name. For an overview of the google fonts please refer: http://www.google.com/fonts
fontname="Roboto"; //[ABeeZee,Abel,Abril Fatface,Aclonica,Acme,Actor,Adamina,Advent Pro,Aguafina Script,Akronim,Aladin,Aldrich,Alef,Alegreya,Alegreya Sans,Alegreya Sans SC,Alegreya SC,Alex Brush,Alfa Slab One,Alice,Alike,Alike Angular,Allan,Allerta,Allerta Stencil,Allura,Almendra,Almendra Display,Almendra SC,Amarante,Amaranth,Amatic SC,Amethysta,Amiri,Anaheim,Andada,Andika,Angkor,Annie Use Your Telescope,Anonymous Pro,Antic,Antic Didone,Antic Slab,Anton,Arapey,Arbutus,Arbutus Slab,Architects Daughter,Archivo Black,Archivo Narrow,Arimo,Arizonia,Armata,Artifika,Arvo,Asap,Asset,Astloch,Asul,Atomic Age,Aubrey,Audiowide,Autour One,Average,Average Sans,Averia Gruesa Libre,Averia Libre,Averia Sans Libre,Averia Serif Libre,Bad Script,Balthazar,Bangers,Basic,Battambang,Baumans,Bayon,Belgrano,Belleza,BenchNine,Bentham,Berkshire Swash,Bevan,Bigelow Rules,Bigshot One,Bilbo,Bilbo Swash Caps,Bitter,Black Ops One,Bokor,Bonbon,Boogaloo,Bowlby One,Bowlby One SC,Brawler,Bree Serif,Bubblegum Sans,Bubbler One,Buda,Buenard,Butcherman,Butterfly Kids,Cabin,Cabin Condensed,Cabin Sketch,Caesar Dressing,Cagliostro,Calligraffitti,Cambay,Cambo,Candal,Cantarell,Cantata One,Cantora One,Capriola,Cardo,Carme,Carrois Gothic,Carrois Gothic SC,Carter One,Caudex,Cedarville Cursive,Ceviche One,Changa One,Chango,Chau Philomene One,Chela One,Chelsea Market,Chenla,Cherry Cream Soda,Cherry Swash,Chewy,Chicle,Chivo,Cinzel,Cinzel Decorative,Clicker Script,Coda,Coda Caption,Codystar,Combo,Comfortaa,Coming Soon,Concert One,Condiment,Content,Contrail One,Convergence,Cookie,Copse,Corben,Courgette,Cousine,Coustard,Covered By Your Grace,Crafty Girls,Creepster,Crete Round,Crimson Text,Croissant One,Crushed,Cuprum,Cutive,Cutive Mono,Damion,Dancing Script,Dangrek,Dawning of a New Day,Days One,Dekko,Delius,Delius Swash Caps,Delius Unicase,Della Respira,Denk One,Devonshire,Dhurjati,Didact Gothic,Diplomata,Diplomata SC,Domine,Donegal One,Doppio One,Dorsa,Dosis,Dr Sugiyama,Droid Sans,Droid Sans Mono,Droid Serif,Duru Sans,Dynalight,Eagle Lake,Eater,EB Garamond,Economica,Ek Mukta,Electrolize,Elsie,Elsie Swash Caps,Emblema One,Emilys Candy,Engagement,Englebert,Enriqueta,Erica One,Esteban,Euphoria Script,Ewert,Exo,Exo 2,Expletus Sans,Fanwood Text,Fascinate,Fascinate Inline,Faster One,Fasthand,Fauna One,Federant,Federo,Felipa,Fenix,Finger Paint,Fira Mono,Fira Sans,Fjalla One,Fjord One,Flamenco,Flavors,Fondamento,Fontdiner Swanky,Forum,Francois One,Freckle Face,Fredericka the Great,Fredoka One,Freehand,Fresca,Frijole,Fruktur,Fugaz One,Gabriela,Gafata,Galdeano,Galindo,Gentium Basic,Gentium Book Basic,Geo,Geostar,Geostar Fill,Germania One,GFS Didot,GFS Neohellenic,Gidugu,Gilda Display,Give You Glory,Glass Antiqua,Glegoo,Gloria Hallelujah,Goblin One,Gochi Hand,Gorditas,Goudy Bookletter 1911,Graduate,Grand Hotel,Gravitas One,Great Vibes,Griffy,Gruppo,Gudea,Gurajada,Habibi,Halant,Hammersmith One,Hanalei,Hanalei Fill,Handlee,Hanuman,Happy Monkey,Headland One,Henny Penny,Herr Von Muellerhoff,Hind,Holtwood One SC,Homemade Apple,Homenaje,Iceberg,Iceland,IM Fell Double Pica,IM Fell Double Pica SC,IM Fell DW Pica,IM Fell DW Pica SC,IM Fell English,IM Fell English SC,IM Fell French Canon,IM Fell French Canon SC,IM Fell Great Primer,IM Fell Great Primer SC,Imprima,Inconsolata,Inder,Indie Flower,Inika,Irish Grover,Istok Web,Italiana,Italianno,Jacques Francois,Jacques Francois Shadow,Jim Nightshade,Jockey One,Jolly Lodger,Josefin Sans,Josefin Slab,Joti One,Judson,Julee,Julius Sans One,Junge,Jura,Just Another Hand,Just Me Again Down Here,Kalam,Kameron,Kantumruy,Karla,Karma,Kaushan Script,Kavoon,Kdam Thmor,Keania One,Kelly Slab,Kenia,Khand,Khmer,Khula,Kite One,Knewave,Kotta One,Koulen,Kranky,Kreon,Kristi,Krona One,La Belle Aurore,Laila,Lakki Reddy,Lancelot,Lateef,Lato,League Script,Leckerli One,Ledger,Lekton,Lemon,Liberation Sans,Libre Baskerville,Life Savers,Lilita One,Lily Script One,Limelight,Linden Hill,Lobster,Lobster Two,Londrina Outline,Londrina Shadow,Londrina Sketch,Londrina Solid,Lora,Love Ya Like A Sister,Loved by the King,Lovers Quarrel,Luckiest Guy,Lusitana,Lustria,Macondo,Macondo Swash Caps,Magra,Maiden Orange,Mako,Mallanna,Mandali,Marcellus,Marcellus SC,Marck Script,Margarine,Marko One,Marmelad,Martel Sans,Marvel,Mate,Mate SC,Maven Pro,McLaren,Meddon,MedievalSharp,Medula One,Megrim,Meie Script,Merienda,Merienda One,Merriweather,Merriweather Sans,Metal,Metal Mania,Metamorphous,Metrophobic,Michroma,Milonga,Miltonian,Miltonian Tattoo,Miniver,Miss Fajardose,Modak,Modern Antiqua,Molengo,Molle,Monda,Monofett,Monoton,Monsieur La Doulaise,Montaga,Montez,Montserrat,Montserrat Alternates,Montserrat Subrayada,Moul,Moulpali,Mountains of Christmas,Mouse Memoirs,Mr Bedfort,Mr Dafoe,Mr De Haviland,Mrs Saint Delafield,Mrs Sheppards,Muli,Mystery Quest,Neucha,Neuton,New Rocker,News Cycle,Niconne,Nixie One,Nobile,Nokora,Norican,Nosifer,Nothing You Could Do,Noticia Text,Noto Sans,Noto Serif,Nova Cut,Nova Flat,Nova Mono,Nova Oval,Nova Round,Nova Script,Nova Slim,Nova Square,NTR,Numans,Nunito,Odor Mean Chey,Offside,Old Standard TT,Oldenburg,Oleo Script,Oleo Script Swash Caps,Open Sans,Open Sans Condensed,Oranienbaum,Orbitron,Oregano,Orienta,Original Surfer,Oswald,Over the Rainbow,Overlock,Overlock SC,Ovo,Oxygen,Oxygen Mono,Pacifico,Paprika,Parisienne,Passero One,Passion One,Pathway Gothic One,Patrick Hand,Patrick Hand SC,Patua One,Paytone One,Peddana,Peralta,Permanent Marker,Petit Formal Script,Petrona,Philosopher,Piedra,Pinyon Script,Pirata One,Plaster,Play,Playball,Playfair Display,Playfair Display SC,Podkova,Poiret One,Poller One,Poly,Pompiere,Pontano Sans,Port Lligat Sans,Port Lligat Slab,Prata,Preahvihear,Press Start 2P,Princess Sofia,Prociono,Prosto One,PT Mono,PT Sans,PT Sans Caption,PT Sans Narrow,PT Serif,PT Serif Caption,Puritan,Purple Purse,Quando,Quantico,Quattrocento,Quattrocento Sans,Questrial,Quicksand,Quintessential,Qwigley,Racing Sans One,Radley,Rajdhani,Raleway,Raleway Dots,Ramabhadra,Ramaraja,Rambla,Rammetto One,Ranchers,Rancho,Ranga,Rationale,Ravi Prakash,Redressed,Reenie Beanie,Revalia,Ribeye,Ribeye Marrow,Righteous,Risque,Roboto,Roboto Condensed,Roboto Slab,Rochester,Rock Salt,Rokkitt,Romanesco,Ropa Sans,Rosario,Rosarivo,Rouge Script,Rozha One,Rubik Mono One,Rubik One,Ruda,Rufina,Ruge Boogie,Ruluko,Rum Raisin,Ruslan Display,Russo One,Ruthie,Rye,Sacramento,Sail,Salsa,Sanchez,Sancreek,Sansita One,Sarina,Sarpanch,Satisfy,Scada,Scheherazade,Schoolbell,Seaweed Script,Sevillana,Seymour One,Shadows Into Light,Shadows Into Light Two,Shanti,Share,Share Tech,Share Tech Mono,Shojumaru,Short Stack,Siemreap,Sigmar One,Signika,Signika Negative,Simonetta,Sintony,Sirin Stencil,Six Caps,Skranji,Slabo 13px,Slabo 27px,Slackey,Smokum,Smythe,Sniglet,Snippet,Snowburst One,Sofadi One,Sofia,Sonsie One,Sorts Mill Goudy,Source Code Pro,Source Sans Pro,Source Serif Pro,Special Elite,Spicy Rice,Spinnaker,Spirax,Squada One,Sree Krushnadevaraya,Stalemate,Stalinist One,Stardos Stencil,Stint Ultra Condensed,Stint Ultra Expanded,Stoke,Strait,Sue Ellen Francisco,Sunshiney,Supermercado One,Suranna,Suravaram,Suwannaphum,Swanky and Moo Moo,Syncopate,Tangerine,Taprom,Tauri,Teko,Telex,Tenali Ramakrishna,Tenor Sans,Text Me One,The Girl Next Door,Tienne,Timmana,Tinos,Titan One,Titillium Web,Trade Winds,Trocchi,Trochut,Trykker,Tulpen One,Ubuntu,Ubuntu Condensed,Ubuntu Mono,Ultra,Uncial Antiqua,Underdog,Unica One,UnifrakturCook,UnifrakturMaguntia,Unkempt,Unlock,Unna,Vampiro One,Varela,Varela Round,Vast Shadow,Vesper Libre,Vibur,Vidaloka,Viga,Voces,Volkhov,Vollkorn,Voltaire,VT323,Waiting for the Sunrise,Wallpoet,Walter Turncoat,Warnes,Wellfleet,Wendy One,Wire One,Yanone Kaffeesatz,Yellowtail,Yeseva One,Yesteryear,Zeyada]

//Only if you use the "|" character: "Align towards middle" will align the two columns right and left, so towards each other. "Align towards edge" will align the two columns left and right, so towards the outside. 
align_columns="towards middle";//[towards middle,towards edge] 

//This is needed **only** if you choose align="towards edge" above: Set the width of the label
width_label=150;

//You can set the distance between the individual text lines 
verticaldistance=5;

//Border in mm to add on top and bottom
border_topdown=7;

//Border to add on left and right side
border_side=7;

//Height of the text letters in mm
textheight=2;

//Thickness of the chamfered base in mm
base_height=2;

//Distance between two columns, in case you use text like "bla|blubb" its the distance between the words bla and blubb.
column_distance=6;

/* [Hidden] */
//-------------------------------------------------------------------------------
        
//Outer rim thickness (set to 0 if no rim is needed)
//outer_line=0;

textstrings=[str(text1),str(text2),str(text3),str(text4),str(text5),str(text6),str(text7),str(text8),str(text9),str(text10),str(text11),str(text12),str(text13),str(text14),str(text15),str(text16),str(text17),str(text18),str(text19),str(text20)];
function text_entered(x) = (x!="");
number_textstrings = max([ for (i=[0:len(textstrings)-1]) if (text_entered(textstrings[i])) i ])+1;


textsizes = [ for (i = [0 : len(font_sizes)-1]) font_sizes[i]/(textstrings[i]=="---"?10:1) ];

function join(strings, delimeter="") = 
	strings == undef?
		undef
	: strings == []?
		""
	: _join(strings, len(strings)-1, delimeter, 0);

function _join(strings, index, delimeter) = 
	index==0 ? 
		strings[index] 
: str(_join(strings, index-1, delimeter), delimeter, strings[index]) ;

//note: start is inclusive, end is exclusive
function between(string, start, end) = 
	string == undef?
		undef
	: start == undef?
		undef
	: start > len(string)?
		undef
	: start < 0?
		before(string, end)
	: end == undef?
		undef
	: end < 0?
		undef
	: end > len(string)?
		after(string, start-1)
	: start > end?
		undef
	: start == end ? 
		"" 
	: 
        join([for (i=[start:end-1]) string[i]])
;
        
function cat(L1, L2) = [for (i=[0:len(L1)+len(L2)-1]) 
                        i < len(L1)? L1[i] : L2[i-len(L1)]] ;



/*
Multiline Label
Version D, April 2019
Written by MC Geisler (mcgenki at gmail dot com)

This is a multiline label! Enjoy! Its auto-sizing :)

Have fun!

License: Attribution 4.0 International (CC BY 4.0)

You are free to:
    Share - copy and redistribute the material in any medium or format
    Adapt - remix, transform, and build upon the material
    for any purpose, even commercially.
*/

function add(v, i = 0, r = 0, max) = i < max ? add(v, i + 1, r + v[i], max) : r; 

valignval="top";

//cube ([width,5,5],center=true);
module letters(textstr,textsize)
{         
    if (textstr!="---")
    {
        FindVertical=search("|",textstr,0);
        FindVerticalPos=(FindVertical[0])[0];

        if(len(FindVertical[0])>0)
        {
            //two columns, separated by vertical line
            NameStr1=between(textstr,0, FindVerticalPos );
            NameStr2=between(textstr,  (FindVerticalPos+1 ) , len(textstr) );
            
            if (align_columns=="towards middle")
            {
                text(text=NameStr1, size=textsize, font=fontname, valign="top", halign="right");

                translate([column_distance,0,0])
                    text(text=NameStr2, size=textsize, font=fontname, valign=valignval, halign="left");
            }
            else
            {
                shift_text=(width_label-border_side)/2;
                translate([-shift_text,0,0])
                    text(text=NameStr1, size=textsize, font=fontname, valign="top", halign="left");

                translate([shift_text,0,0])
                    text(text=NameStr2, size=textsize, font=fontname, valign=valignval, halign="right");
            }
        }
        else
        {
            text(text=textstr, size=textsize, font=fontname, valign=valignval, halign="center");
        }
    }
}

verticalshift = [ for (ii = [number_textstrings-1 : -1 : 0]) add(textsizes,max=number_textstrings-ii)  ];

module alltext()
{
        for (i =[0:number_textstrings-1])
        {
        //    translate([0,-i*textsizes[0],0])
            //echo("I=",i);
            translate([0,(i==0?0:-i*verticaldistance-verticalshift[i-1]),0])
            {
                //echo("hoehe",-i*verticaldistance-verticalshift[i]);
                letters(textstrings[i],textsizes[i]);
            }
        }
}

module extrude_object(base_height)
{
    linear_extrude(height=base_height/2,convexity = 10)    
            alltext();
}

line_thickness=1.5;

module line_hull_of_object(line_thickness)
{
    minkowski()
    {        
        translate([0,border_topdown,0])rotate ([90,0,0])
                linear_extrude(height = line_thickness,convexity = 2)
                     hull()
                        projection(cut = false)
                            rotate([-90,0,0])
                                extrude_object((textheight+base_height)*2);
    }
}

module alllines()
{
        for (i =[0:number_textstrings-1])
        {
        //    translate([0,-i*textsizes[0],0])
            //echo("I=",i);
            translate([0,(i==0?0:-i*verticaldistance-verticalshift[i-1])-border_topdown,0])
            {
                //echo("hoehe",-i*verticaldistance-verticalshift[i]);
                if (textstrings[i]=="---")
                {
                    echo("LINE!",-i*verticaldistance,-verticalshift[i-1],textsizes[i]);
                    color("white") 
                        translate([0,-3*textsizes[i]/5,0])
                            line_hull_of_object(textsizes[i]);
                    //letters(textstrings[i],textsizes[i]);
                }
                else
                {
                    //color("blue") line_hull_of_object(textsizes[i]);
                }
            }
        }
}

alllines();

module square_hull_of_object(base_height)
{
    minkowski()
    {
        translate([-border_side,0,0])
            rotate ([0,90,0])
                linear_extrude(height = 2*border_side,convexity = 2)
                     hull()
                        projection(cut = false)
                            rotate([0,-90,0])
                                extrude_object(base_height);
        
        translate([0,border_topdown,0])rotate ([90,0,0])
                linear_extrude(height = 2*border_topdown,convexity = 2)
                     hull()
                        projection(cut = false)
                            rotate([-90,0,0])
                                extrude_object(base_height);
    }
}

color("red")
minkowski()
{       
    square_hull_of_object(base_height*.2);
    cylinder(r1=base_height,r2=0,h=base_height,$fn=4);
}


//color ("yellow")
//difference()
//{
//    linear_extrude(height = textheight+base_height,convexity = 2)
//        offset(r=outer_line, $fn=16)
//            projection()
//                square_hull_of_object();
//    square_hull_of_object(textheight+base_height+1);
//}


color("white")
    linear_extrude(height = textheight+base_height,convexity = 10)
        alltext();


