blank_width = 44.7;
blank_length = 24.1;
blank_depth = 8;
blank_corner_radius = 5;
blank_wall_thickness = 3.2;
blank_clip_thickness = 3;
blank_clip_width = 6;
blank_clip_depth = 8.5;
extrude_scale = 1.8;
blank_wall_inset = 1.2;
blank_inset_depth = 3.2;
hollow = true;
guard = true;
guard_height = 9;
guard_thickness =3;
clips_x = 3;
clips_y = 0;
holes = 2;
hole_d = 12;
tol = 0.03;
$fn = 360;

module holes(){
spacing=(blank_width-holes*hole_d)/(holes+1);
    for(n=[1:1:holes]){
        translate([n*(spacing+hole_d)-hole_d/2,blank_length/2,0])
            cylinder(h=2.1*blank_depth,d=hole_d+2*tol,center=true);
    }
}

module roundedCubeoid(blank_width, blank_length, blank_depth, blank_corner_radius) {
    // Define the points for the corners of the width-length face
    points = [
        [blank_corner_radius, blank_corner_radius, blank_depth/2],
        [blank_width - blank_corner_radius, blank_corner_radius, blank_depth/2],
        [blank_corner_radius, blank_length - blank_corner_radius, blank_depth/2],
        [blank_width - blank_corner_radius, blank_length - blank_corner_radius, blank_depth/2]
    ];
    
    // hull some cylinders to make a rounded cubeoid
    hull() {
        for (p = points) {
            translate(p) cylinder(r=blank_corner_radius, h=blank_depth, center=true);
        }
    }
}

module inset(){
    translate([0,0,blank_inset_depth]){
        difference(){
            roundedCubeoid(blank_width, blank_length, blank_depth-blank_wall_thickness, blank_corner_radius);
            translate([blank_wall_inset+tol,blank_wall_inset+tol,-0.01])
                roundedCubeoid(blank_width-2*blank_wall_inset-2*tol, blank_length-2*blank_wall_inset-2*tol, blank_depth-blank_wall_thickness+0.02, blank_corner_radius);
        }
    }
}

module guard(){
spacing=(blank_width-holes*hole_d)/(holes+1);
    translate([0,-blank_length-2,0]){
        difference(){
            union(){
                roundedCubeoid(blank_width-2*tol, blank_length-2*tol, blank_wall_thickness, blank_corner_radius);
                translate([0,0,blank_wall_thickness-guard_thickness/2]){
                    for(n=[0:1:holes]){
                        translate([spacing/2+n*(spacing+hole_d),blank_length/2,guard_height-(blank_length/2-guard_thickness)]){
                            translate([0,-blank_length/2+guard_thickness,-(guard_height-(blank_length/2-guard_thickness))/2])
                                cylinder(h=(guard_height-(blank_length/2-guard_thickness)),d=guard_thickness,center=true);
                            translate([0,blank_length/2-guard_thickness,-(guard_height-(blank_length/2-guard_thickness))/2])
                                cylinder(h=(guard_height-(blank_length/2-guard_thickness)),d=guard_thickness,center=true);
                            translate([0,0,0]){
                                rotate([90,0,90]){
                                    rotate_extrude(angle=180){
                                        translate([blank_length/2-guard_thickness,0])
                                            circle(d=guard_thickness);
                                    
                                    }
                                }
                            }
                        }
                    }
                }
            }
        for(n=[1:1:holes]){
        translate([n*(spacing+hole_d)-hole_d/2,blank_length/2,0])
            cylinder(h=2.1*blank_depth,d=hole_d+2*tol,center=true);
            }
        }
    }

}

module clipCutout(x_pos, y_pos, blank_clip_width, blank_clip_thickness, blank_wall_thickness) {
    translate([x_pos - blank_wall_thickness/2, y_pos - blank_wall_thickness/2, blank_wall_thickness])
    cube([blank_clip_width + blank_wall_thickness, blank_clip_thickness + blank_wall_thickness, blank_clip_depth]);
}

module addClip(x_pos, y_pos, blank_clip_width, blank_clip_depth, blank_clip_thickness, blank_wall_thickness) {
    // Add the clip
    translate([x_pos, y_pos, 0])
    cube([blank_clip_width, blank_clip_thickness, blank_clip_depth]);
    
    // Calculate the dimensions for the doohickey
    trapezoid_height = blank_wall_thickness / 2;
    
    // Add the doohickey at the end of the clip
    translate([x_pos, y_pos, blank_clip_depth]) {
        translate([blank_clip_width/2, blank_clip_thickness/2, 0])
        linear_extrude(height=trapezoid_height, scale=extrude_scale) {
            square([blank_clip_width, blank_clip_thickness], center=true);
        }
        
        translate([0, 0, trapezoid_height])
        translate([blank_clip_width/2, blank_clip_thickness/2, 0])
        linear_extrude(height=blank_wall_thickness, scale=1/extrude_scale) {
            square([blank_clip_width*extrude_scale, blank_clip_thickness*extrude_scale], center=true);
        }
    }
}

module blank(blank_width, blank_length, blank_depth, blank_corner_radius, blank_wall_thickness, blank_clip_thickness, blank_clip_width, blank_clip_depth, hollow, clips_x, clips_y, tol) {
    difference() {
        roundedCubeoid(blank_width-2*tol, blank_length-2*tol, blank_depth, blank_corner_radius);
        
        if (hollow) {
            translate([blank_wall_thickness+blank_wall_inset+tol, blank_wall_thickness+blank_wall_inset+tol, blank_wall_thickness+tol])
            roundedCubeoid(blank_width - blank_wall_thickness * 2 -blank_wall_inset*2+2*tol, blank_length - blank_wall_thickness * 2-blank_wall_inset*2+2*tol, blank_depth - blank_wall_thickness, blank_corner_radius-blank_wall_thickness);
        }
        
        // Courtyard cutout for clips
        if(clips_x != 0) {
            for (i = [0:clips_x-1]) {
                x_pos = (blank_width) / (clips_x + 1) * (i+1) - blank_clip_width/2;
                y_pos = (blank_length - blank_clip_thickness);
                clipCutout(x_pos, 0, blank_clip_width, blank_clip_thickness, blank_wall_thickness);
                clipCutout(x_pos, y_pos, blank_clip_width, blank_clip_thickness, blank_wall_thickness);
            }
        }
        
        if(clips_y != 0) {
            for (j = [0:clips_y-1]) {
                x_pos = (blank_width - blank_clip_thickness);
                y_pos = (blank_length) / (clips_y + 1) * (j + 1) - blank_clip_width/2;
                clipCutout(0, y_pos, blank_clip_thickness, blank_clip_width, blank_wall_thickness);
                clipCutout(x_pos, y_pos, blank_clip_thickness, blank_clip_width, blank_wall_thickness);
            }
        }
        
        if(holes != 0){
            holes();
        }
        if(blank_wall_inset > 0){
            inset();
        }
    }
    
    // Clips themselves
    if(clips_x != 0) {
        for (i = [0:clips_x-1]) {
            x_pos = (blank_width) / (clips_x + 1) * (i+1) - blank_clip_width/2;
            y_pos = (blank_length - blank_clip_thickness);
            addClip(x_pos, blank_wall_inset, blank_clip_width, blank_clip_depth, blank_clip_thickness, blank_wall_thickness);
            addClip(x_pos, y_pos-blank_wall_inset, blank_clip_width, blank_clip_depth, blank_clip_thickness, blank_wall_thickness);
        }
    }
    
    if(clips_y != 0) {
        for (j = [0:clips_y-1]) {
            x_pos = (blank_width - blank_clip_thickness);
            y_pos = (blank_length) / (clips_y + 1) * (j + 1) - blank_clip_width/2;
            addClip(0+blank_wall_inset, y_pos, blank_clip_thickness, blank_clip_depth, blank_clip_width, blank_wall_thickness);
            addClip(x_pos-blank_wall_inset, y_pos, blank_clip_thickness, blank_clip_depth, blank_clip_width, blank_wall_thickness);
        }
    }
}

// Example usage
difference(){
    union(){
        blank(blank_width, blank_length, blank_depth, blank_corner_radius, blank_wall_thickness, blank_clip_thickness, blank_clip_width, blank_clip_depth, hollow, clips_x, clips_y, tol);

        if(guard==true)
            guard();
    }
    if(guard==true)
        translate([0,0,-(blank_length+blank_width)+blank_wall_thickness/2])
            cube([2*(blank_length+blank_width),2*(blank_length+blank_width),2*(blank_length+blank_width)],center=true);
}
