//  Copyright - 2020 D Conran

$fn = 75;   // used to ensure smooth rounding (but rendering takes a while!)

ht = 2.4;   // thickness of the main cover
clip_depth = 6; //  thickness of the high clips
cutout_y = 6;   // height of cutout above the cover base (in y direction)
capht = 5;      //  height of the cap cover

module high_clip(h) {
    //  the 4 higher clips holding the cover to the dash
    rotate([90,0,0])linear_extrude(height=8)polygon([[1,0],[0.6,8+h],[-2,10+h],[3,16+h],[clip_depth,0],[8,0]]);
}
module low_clip() {
    //  the 2 lower, slanting clips that insert under the dash
    translate([10,9,ht-0.1])rotate([90,0,-90])linear_extrude(height=10)polygon([[0,5],[0,6.5],[1,6.5],[12,0],[3,0],[3,2]]);
}
module clips() {
    //  all 6 clips appropriately positioned
    translate([30,-9.5,0])rotate([0,0,87.2])high_clip(1);
    translate([80,-11.6,0])rotate([0,0,87.2])high_clip(1);
    translate([-7.5,61,0])rotate([0,0,0])high_clip(3);
    translate([124.5,59,0])rotate([0,0,0])mirror([1,0,0])high_clip(2);
    
    translate([16,119,0])low_clip();
    translate([92,119.5,0])low_clip();
}
module corner(h,r) {
    //  a corner of the main fuse cover
    cylinder(h,r,r);
}
module cover(h) {
    //  the basic fuse cover
    hull() {
        translate([2,4,0]) corner(h,14);
        translate([4,109,0]) corner(h,16);
        translate([115,112,0])corner(h,14);
        translate([115,-1,0])corner(h,14);
    }   
}
module mytext(z) {
        translate([60,cutout_y+39,z])rotate([0,0,-2.8])mirror([1,0,0]) linear_extrude(-z+0.4)text("FUSE OBD",halign="center",valign="center",size=8,font="Arial:style=bold",spacing=1);
}
module support_wall(h) {
    //  the triangular support 'holding' the shielding lip
    minkowski() {
        rotate([0,-90,0])linear_extrude(height=1)polygon([[0,0],[0,38],[h,2],[h,0]]);
        sphere(1);
    }
}
module support() {
    //  the shield structure
    translate([7,cutout_y,-0.2+ht/2]) minkowski() {
        rotate([0,0,0])cube([44,1.2,9]);
        sphere(1);
    }
    translate([8,6.1,-0.2+ht/2])support_wall(9);
    translate([52,6,0])support_wall(10.1);
}
module assembly() {
    //  the whole fuse cover assembly
    difference() {
        cover(ht+2.6);  // the cover
        translate([1,1,ht])scale([0.984,1,1])cover(ht+10);  // less a shrunken cover used to create the cover wall
        mytext(-1);     //  less text cutout
        translate([24,-13,ht])cube([20,10,10]);     // less wall cutouts
        translate([74,-14.5,ht])cube([20,10,10]);
        translate([-13,47,ht])cube([10,20,10]);
        translate([125,45,ht])cube([10,20,10]);
        translate([16,120,ht+2])cube([12,4,10]);
        translate([92,121,ht+2])cube([12,4,10]);
        
        translate([7,cutout_y,-1]) rotate([0,0,-2.8])cube([102,34,20]); //  the main cutout area
    }
    //  rounded edges around the main cutout area
    translate([7,cutout_y,1.2])rotate([-90,0,-2.8])cylinder(34,1.2,1.2);
    translate([109,cutout_y-6,1.2])rotate([-90,0,-2.8])cylinder(34,1.2,1.2);
    translate([7,cutout_y,1.2])rotate([0,90,-2.8])cylinder(110,1.2,1.2);
    translate([7,cutout_y+34,1.2])rotate([0,90,-2.8])cylinder(110,1.2,1.2);
    clips();
    rotate([0,0,-2.8]) support();
    
    
}
module cap() {
    difference() {
        translate([-1,-1,0])minkowski() {
            cube([56,32,capht]);
            sphere(2);
        }
        translate([-0.5,-0.5,-1.4])cube([55,31,20]);
        translate([-50,-100,capht])cube([200,200,200]);
    }
    translate([1.5,29.7,-1.4])capclip();
    translate([48,29.7,-1.4])capclip();
    translate([6.5,0.3,-1.4])rotate([0,0,180])capclip();
    translate([53,0.3,-1.4])rotate([0,0,180])capclip();
}
module capclip() {
    intersection() {
        union() {
            cube([5,0.8,capht+4.6]);
            translate([0,-1.4,capht+4])rotate([-45,0,0])cube([5,2,2]);
        }
        translate([-50,0,-1])cube([100,100,100]);
    }
}

intersection() {
    assembly();
    translate([-100,-100,0])cube([300,300,200]);    //  block used to shave off any rounding below the main fuse cover
}
translate([52,5,-3])rotate([0,0,-2.8])cap();
