module rBox(size, radius, fn)
{
	cube(size - [2*radius,0,0], true);
	cube(size - [0,2*radius,0], true);
	for (x = [radius-size[0]/2, -radius+size[0]/2],
			 y = [radius-size[1]/2, -radius+size[1]/2]) {
		translate([x,y,0]) cylinder(r=radius, h=size[2], center=true, $fn=fn);
	}
}

module tCU(t,c){
	translate(t)cube(c,true);
}
module trCU(t,r,c){
	translate(t)rotate(r)cube(c,true);
}
module tCY(t,r0,h0,fn)
{
	translate(t)cylinder(r=r0,h=h0,center=true,$fn=fn);
}
module trCY(t,r,r0,h0,fn)
{
	translate(t)rotate(r)cylinder(r=r0,h=h0,center=true,$fn=fn);
}
module tCY2(t,r1,r2,h0,fn)
{
	translate(t)cylinder(r1=r1,r2=r2,h=h0,center=true,$fn=fn);
}
module trCY2(t,r,r1,r2,h0,fn)
{
	translate(t)rotate(r)cylinder(r1=r1,r2=r2,h=h0,center=true,$fn=fn);
}
module tRB(t,size,radius,fn){
	translate(t)rBox(size,radius,fn);
}
module trRB(t,r,size,radius,fn){
	translate(t)rotate(r)rBox(size,radius,fn);
}
//tCU([,,],[,,]);
//trCU([,,],[,,],[,,]);
//tCY([,,],r,h,fn);
//trCY([,,],[,,],r,h,fn);
//tCY2([,,],r1,r2,h,fn);
//trCY2([,,],[,,],r1,r2,h,fn);
//tRB([,,],[,,],radius,fn);
//trRB([,,],[,,],[,,],radius,fn);

%tCU([0,-36,62],[56,12,124]);


module side()
{
	difference()
	{
		union()
		{
			tCU([-30+0.5,-30,30],[3,24,60]);
			tCU([-27.5,-44,30],[7,4,60]);
			tCU([-26.5,-37,1],[5,10,2]);
		}
		tCY([-24,-46,30],3.2,100,4);
	}
	difference()
	{
		union()
		{
			tRB([-28+0.5,-18,30],[7,16,60],3.5,16);
		}
		tRB([-28+0.5,-20-2,30],[1,16,100],0.5,16);
	}
	difference()
	{
		union()
		{
			tRB([-24+0.5,-22,30],[7,16,60],3.5,16);
		}
		tRB([-24+0.5,-20+2,30],[1,16,100],0.5,16);
	}
	difference()
	{
		union()
		{
			tRB([-20+0.5,-15,30],[7,16,60],3.5,16);
		}
		tRB([-20+0.5,-17-2,30],[1,16,100],0.5,16);
	}
	difference()
	{
		union()
		{
			tRB([-16+0.5,-22,30],[7,16,60],3.5,16);
		}
		tRB([-16+0.5,-20+2,30],[1,16,100],0.5,16);
	}
	difference()
	{
		union()
		{
			tRB([-12+0.5,-12,30],[7,16,60],3.5,16);
		}
		tRB([-12+0.5,-14-2,30],[1,16,100],0.5,16);
	}
	difference()
	{
		union()
		{
			tRB([-8+0.5,-22,30],[7,16,60],3.5,16);
		}
		tRB([-8+0.5,-20+2,30],[1,16,100],0.5,16);
	}
	difference()
	{
		union()
		{
			tRB([0,-7-6,30],[14,14+12,60],7,16);
		}
		tCY([0,-7,25],4.1,100,16);
		tRB([0,-26,30],[8,24,100],3,16);
	}
	
}
side();
mirror([1,0,0])side();
//tCU([0,-18.5,0.1],[58,32,0.2]);
