
// From the manual of my 3d printer (Makerbot Replicator 2)
// Very large build volume: 410 in3 (11.2 L x 6.0 W x 6.1 H in) / 6691.0 cm3 (28.4 x 15.5 x 15.2 cm).

// Printing Area:
// % cube ([284, 155, 152]);

$fn = 90;

layerHeight = .2;
yScale = .4;
scaleBRatio = .5;
animatedLayers = 5; // 1 mm top is rounded


totalHeight = 7;

footOffset = layerHeight;

union () {
    for (layer = [0 : animatedLayers]) {

        moveX = (layer == 0) ? [0] : [yScale * layer, - yScale * layer];

        for (x = moveX) {
            
            footOffset = layer == animatedLayers ? 0 : footOffset + layerHeight;
            
            linear_extrude (height = (totalHeight - (layerHeight * layer) + footOffset)) {
                // ******* The Text:

                translate(v = [x + 26, 47, footOffset])
                    scale ([.7, 1, 1])
                        text("280 BE", font="BoostLightSSK:style=Bold", size=37, spacing = 1.35);

                
                translate(v = [(scaleBRatio * x) + 6, 13, footOffset])
                    scale ([.87, 1, 1])
                        text("BRABUS C32", font="BoostSSK:style=Regular", size = 20, spacing=1.4);
                // ********************
            }
        }
    }

    /// Support  bar 1
    difference () {
        translate (v = [1, 46, 0])
            rotate (a = [0, 90, 0]) 
                cylinder (h = 220, r = 4.6);

        translate (v = [0, 0, -20]) 
            cube ([285, 155, 20]);

    }

    // support bar 2
    difference () {
        translate (v = [1, 13, 0])
            rotate (a = [0, 90, 0]) 
                cylinder (h = 220, r = 3);

        translate (v = [0, 0, -20]) 
            cube ([285, 155, 20]);

    }

    for (x = [30, 105, 185]) {
        translate (v = [x, 30, 0])
            cube ([3, 20, 3]);
    }



}
