// Вкладыш в маленьку круглую  нишу Пинина
// round storage box for Mitsubishi Pajero Pinin
// (c) e-geht 2021

include <threads-scad-master/threads.scad>

$fn = 100;

ww = 1.6; // толщина стенок (Wall thickness)

ddb = 66;   // диаметр низа реальная 67 (bottom diameter )
ddt = 76;   // диаметр верха 77 (top diameter)
h1 = 55;    // высота гнезда в высокой части (nest height in the high part)
h2 = 40;    // высота гнезда в низкой части  (nest height in the lower part)

thread_len = 7;                     // высота резьбы (thread height)
thread_diam = ddt - 2 * ww; // диаметр резьбы (thread diameter)
thread_pitch = 3;                  // шаг резьбы (thread pitch)
chamfer = 3;                        // высота фаски должна быть больше  ww (chamfer height must be greater than  ww)


// какую часть генерировать
show_1 = 1;                 // base [0:No,1:Yes]
show_2 = 0;                 // lid [0:No,1:Yes]
show_assembled = 0;  // все в сборе[0:No,1:Yes]

// толщина резьбы она же высота утолщения стенки под резьбу (что б печатать без поддержек)
thread_thick = thread_pitch * sin(60) + ww;


if (show_assembled) {
    base();
    translate([0,0,h2]) lid();
    }
else{
  if(show_1)
    base();
  if(show_2)
    lid();
}

// база
module base()
{
    // основной конус высотой гнезда в низкой части
    // днище с фаской
 difference() {
       cylinder(h = chamfer, d2 = ddb, d1 = ddb - 2 * chamfer);
       translate([0, 0, ww]) cylinder(h = chamfer-ww, d2 = ddb - 2 * ww, d1 = ddb - 2 * chamfer - 2 * ww);  
   }   
   // стенки
translate([0, 0, chamfer])   
 difference(){
cylinder(d1=ddb, d2=ddt, h=h2-chamfer);
    // убираем внутренности
translate([0,0,0]) cylinder(d1=ddb-2*ww, d2=ddt-2*ww, h=h2 - thread_thick - chamfer);
    // формируем утолщение стенки под резьбой     
translate([0, 0, h2 - thread_thick - chamfer]) cylinder(h = thread_thick, d1= ddt - 2 * ww, d2=ddt - 2 * ww - 2 * thread_thick);      
}
 
// резьба   
translate([0, 0, h2])
  difference()  {
  RodStart(ddt, 1, thread_len, thread_diam, thread_pitch);
  cylinder(thread_len+1.1, d = ddt - 2 * ww - 2 * thread_thick );
  }
}

module lid()
// крышка с резьбой
{
    hh = h1 - h2;   // высота крышки
    difference() {
    // стенки (цилиндр с высотой = высота крышки минус фаска, минус толщина стенки (?))
    cylinder(h=hh- chamfer, d=ddt);
    // вычитаем резьбу
    ScrewHole(thread_diam, thread_len, position=[0,0,0], rotation=[0,0,0], pitch=thread_pitch, tooth_angle=30, tolerance=0.4, tooth_height=0);
    translate([0,0, thread_len]) cylinder(h = hh - chamfer - thread_len, d=ddt - 2 * ww);  
  
}

 // верх крышки с фаскойкой
 // высота = chamfer
translate([ 0, 0, hh - chamfer])    // поднимаем ее наверх
  difference() {
       cylinder(h = chamfer, d1 = ddt, d2 = ddt - 2 * chamfer);
       translate([0, 0, 0]) cylinder(h = chamfer-ww, d1 = ddt - 2 * ww, d2 = ddt - 2 * chamfer - 2 * ww);  
   }   
}
