// Вкладыш в большую нишу Пинина
// storage box for Mitsubishi Pajero Pinin
// (c) e-geht 2021

$fn = 64;

ww = 2.0;          // толщина стенок (the wall thickness)
hh = 95;            // высота 95 (height)
wwlid = 2.1;      // толщина крышки (lid thickness)
wwlid1 = 5;       // толщина бортика крышки  (lid rim height)
ofstlid = 0.2;     // зазор бортика крышки  (cover rim gap)

show_box = 1;               // [0:No,1:Yes]
show_lid = 0;                 // [0:No,1:Yes]
show_assembled = 0;    // [0:No,1:Yes]


ar = 13;     // радиус
ay = 13;    // позиция по Y
ax = 25;    // позиция по X
az = 110;    // высота 95

br = 6;          // радиус
by = 67;       // позиция по Y
bx = 0;         // позиция по X
bz = 110;       // 83

cr = 21;         // радиус
cy = 51;        // позиция по Y
cx = 80;        // позиция по X
cz = 110;        // 65

dr = 18;         // радиус
dy = 18;        // позиция по Y
dx = 110;      // позиция по X
dz = 110;        //75



if (show_assembled) 
   {
    // все в сборе   
    // корпус   
      color("GreenYellow",0.5) box();
    //  крышка   
    color("Gold",0.5) translate([0,0,hh-wwlid]) lid();
   } 
else {
  if (show_box)
    box();
  if (show_lid) 
    lid();
  }

module box() {
 difference() {    
        body(type = 0, aar=ar, bbr=br, ccr=cr, ddr=dr);
        translate([0,0,ww]) body(type = 1, aar=ar, bbr=br, ccr=cr, ddr=dr);
     }
}

module lid() {
     // крышка 
    translate([0,0,-(hh-wwlid)]) {
        difference() {   
            // верх крышки
        body(type = 2, aar=ar, bbr=br, ccr=cr, ddr=dr);
            // отверстие под ручку
        translate([(dx+dr)/2-3,(cy+cr)/2+9,hh-wwlid]) cylinder(r=2.6, h=wwlid);  
        }
         difference() {     
           // бордюр крышки  
            body(type = 3, aar=ar-ww-ofstlid, bbr=br-ww-ofstlid, ccr=cr-ww-ofstlid, ddr=dr-ww-ofstlid);
            // выемка в центре бордюра, размер и положение подогнана вручную 
            translate ([-5, 5.5,0]) hull(){
                translate([ax,ay,hh-wwlid-wwlid1]) cylinder(r=ar-ww, h=wwlid1);
                translate([bx,by,hh-wwlid-wwlid1]) cylinder(r=br-ww, h=wwlid1);
                translate([cx+10,cy,hh-wwlid-wwlid1])  cylinder(r=cr-ww, h=wwlid1);
                translate([dx+10,dy,hh-wwlid-wwlid1]) cylinder(r=dr-ww, h=wwlid1);  

             }
          }  
    }
}

module body(type, aar, bbr, ccr, ddr) {
// what print 0 - body out, 1 - body in, 2- lid, 3-бортик крышки
// hh - higth of box   

offset = 10;    // tilt compensation

if (type == 0)
    mainbody(aar, bbr,ccr, ddr, offset);
else if (type == 1)
    {mainbody(aar-ww, bbr-ww, ccr-ww, ddr-ww, offset, type);}  
else if (type == 2)
    {mainbody(aar, bbr, ccr, ddr, offset, type);}  
else if (type == 3)
    {mainbody(aar, bbr, ccr, ddr, offset, type);}  
//mainbody(ar-ww, br-ww, cr-ww, dr-ww);
}


module mainbody(arr, brr, crr, drr, offset, type) { 
  xx =  dx+dr+4*ar;  // размер отсекающего параллелепипеда по X (с запасом)
  yy =  cy+2*cr;       // по Y
  zz =  2*offset;        // по Z
  offx = -2*ar;           //смещение по X
    
hull() {
    difference() {    
        union() {  
          // цилиндры в углах, наклоняем их  
            translate([ax,ay,0]) rotate([0,-6.0,0]) translate([0,0,-offset]) cylinder(r=arr, h=hh+2*offset);
            translate([bx,by,0]) rotate([-7.0,-8,0]) translate([0,0,-offset]) cylinder(r=brr, h=hh+2*offset);
            translate([cx,cy,0]) rotate([-7.5,6,0]) translate([0,0,-offset]) cylinder(r=crr, h=hh+2*offset);
            translate([dx,dy,0]) rotate([0,11,0]) translate([0,0,-offset]) cylinder(r=drr, h=hh+2*offset);
            }   
           // обрезаем верх и низ (наклоненные части днища и крышки 
         if (type==2)   {
             // обрезаем низ и верх крышки
           translate([offx,  0,- 2*offset]) cube([xx, yy,2*offset+hh-wwlid]);
           translate([offx, 0, hh]) cube([xx, yy,2*offset]);       
         }
          else if (type==3)   {
             // обрезаем низ и верх зацепа крышки
           translate([offx,  0,- 2*offset]) cube([xx, yy,2*offset+hh-wwlid-wwlid1]);
           translate([offx, 0, hh-wwlid]) cube([xx, yy,2*offset]);       
         }
         else {
             // обрезаем низ и верх тела
            translate([offx,  0,- 2*offset]) cube([xx, yy, zz]);  
             // верх
            translate([offx, 0, hh-wwlid]) cube([xx, yy,zz]);
         }
         }
}
}

