concentric_layers = 4;
height = 100;
top_cut_radius = 90;
bottom_cut_radius = 0;
top_scale = 2;         //.1
cell_radius = 10;      //.1
wall_thickness_ = 2;   //.1
bottom_thickness_ = 2; //.1
twist = 0;
twist_slices = 50;
min_arc_angle = 12;
rounded_edges = false;
show_vertex_labels = false;
items_to_remove = "";

module __customizer_limit() {}

rounded_corners = true;
$fa = min_arc_angle;
edge_rounding = rounded_edges ? min(wall_thickness_, bottom_thickness_) / 2 - 0.01 : 0;
wall_thickness = wall_thickness_ - edge_rounding * 2;
bottom_thickness = bottom_thickness_ - edge_rounding * 2;
slices = twist == 0 ? 2 : twist_slices;
max_layer = concentric_layers - 1;
max_part = 5;
vertex_segments = rounded_corners ? 64 : 6;
text_color = "white";
removed_text_color = "red";
vertex_text_color = "lightgray";
wall_color = "blue";
tile_color = "green";

_key = 0;
_label = 1;
_pos = 2;
_fst = 3;
_snd = 4;
function obj(_key, _label, _pos, _fst, _snd) = [_key, _label, _pos, _fst, _snd];

function is_numeric(char) = ord(char) >= 48 && ord(char) <= 57;

function split_num_string(src, idx = 0, word = "", dst = []) =
  idx >= len(src) ? word != "" ? concat(dst, word) : dst :
                    split_num_string(src, idx + 1,
                                     is_numeric(src[idx]) ? str(word, src[idx]) : "",
                                     is_numeric(src[idx]) || word == "" ?
                                       dst :
                                       concat(dst, word));

removals = split_num_string(items_to_remove);

function point_on_circle(center, radius, angle) = [
  cos(angle) * radius + center.x, sin(angle) * radius + center.y
];

function rotate_point(point, angle) = [
  point.x * cos(angle) - point.y * sin(angle), point.x *sin(angle) + point.y *cos(angle)
];

function cell_vertex(x, y) =
  x == 0 && y == 0 ?
    [0, 0] :
    (y == 0 ?
       point_on_circle(cell_vertex(x - 1, 0), cell_radius, 30 * (x % 2 == 0 ? -1 : 1)) :
       point_on_circle(cell_vertex(x, 0) + cell_vertex(1, y - 1), cell_radius, 90));

vertices =
  [for (part = [0:max_part]) for (y = [0:max_layer]) for (x = [0:(max_layer - y) * 2])
      obj(_key = [part, y, x], _label = str(part, y, x),
          _pos = rotate_point(cell_vertex(x, y), part * 60 - 30) +
                 point_on_circle([0, 0], cell_radius, part * 60))];

function search_vertex(key) = vertices[search([key], vertices)[0]];

function join(v1, v2) = obj(_label = str(v1[_label], v2[_label]),
                            _key = [v1[_label], v2[_label]], _fst = v1[_pos],
                            _snd = v2[_pos]);

function is_removed(item) = search([item[_label]], removals)[0] != [] ||
                            search([item[_key][0]], removals)[0] != [] ||
                            search([item[_key][1]], removals)[0] != [];

module vertex_node() {
  radius = rounded_corners ? (wall_thickness / 2) : (wall_thickness / sqrt(3));
  // workaround for https://github.com/openscad/openscad/issues/3791
  scale([1, rounded_corners ? 1 : 0.9999]) circle(radius, $fn = vertex_segments);
}

module floor_tile() {
  hull() for (angle = [0:60:300]) translate(point_on_circle([0, 0], cell_radius, angle))
    vertex_node();
}

module key_label(label) {
  translate([0, 0, 0.2])
    text(label, font = ":style=Bold", size = 1.5, halign = "center", valign = "center");
}

module walls(show_labels) {
  walls = [for (v0 = vertices) let(
    v1 = search_vertex(v0[_key] + [0, 0, 1]),
    v2 = v0[_key][2] % 2 != 0 ? search_vertex(v0[_key] + [0, 1, -1]) : undef,
    v3 = v0[_key][2] == 0 ?
           search_vertex(
             [(v0[_key][0] == max_part ? 0 : v0[_key][0] + 1), 0, v0[_key][1] * 2]) :
           undef) each[if (!is_undef(v1)) join(v0, v1), if (!is_undef(v2)) join(v0, v2),
                       if (!is_undef(v3)) join(v0, v3)]];

  for (wall = walls) {
    removed = is_removed(wall);
    angle =
      round(atan2((wall[_snd].y - wall[_fst].y), (wall[_snd].x - wall[_fst].x))) % 180;

    if (show_labels)
      color(removed ? removed_text_color : text_color)
        translate((wall[_fst] + wall[_snd]) / 2)
          rotate([0, 0, angle == -120 ? 60 : angle == 120 ? -60 : angle])
            key_label(wall[_label]);

    if (!removed)
      color(wall_color) translate([0, 0, 0.1]) hull() {
        translate(wall[_fst]) vertex_node();
        translate(wall[_snd]) vertex_node();
      }
  }
}

module tiles(show_labels) {
  tiles = [for (v0 = vertices) let(
    v1 = v0[_key] == [0, 0, 0] ? search_vertex([3, 0, 0]) : undef,
    v2 = v0[_key][2] % 2 == 0 ? search_vertex(v0[_key] + [0, 1, -1]) : undef,
    v3 = v0[_key][2] == 1 ?
           search_vertex(
             [v0[_key][0] == max_part ? 0 : v0[_key][0] + 1, 0, v0[_key][1] * 2 + 1]) :
           undef) each[if (!is_undef(v1)) join(v0, v1), if (!is_undef(v2)) join(v0, v2),
                       if (!is_undef(v3)) join(v0, v3)]];

  for (tile = tiles) {
    removed = is_removed(tile);
    center = (tile[_fst] + tile[_snd]) / 2;

    translate(center) {
      if (!removed)
        color(tile_color) floor_tile();

      if (show_labels)
        color(removed ? removed_text_color : text_color) key_label(tile[_label]);
    }
  }
}

module vertex_labels() {
  for (vertex = vertices) {
    removed = is_removed(vertex);

    translate(vertex[_pos]) color(removed ? removed_text_color : vertex_text_color)
      scale([0.5, 0.5, 1]) key_label(vertex[_label]);
  }
}

module organizer() {
  difference() {
    intersection() {
      union() {
        linear_extrude(height = height, twist = twist, scale = top_scale, slices = slices)
          walls(show_labels = false);

        intersection() {
          linear_extrude(height = height, twist = twist, scale = top_scale,
                         slices = slices) tiles(show_labels = false);
          cylinder(h = bottom_thickness, r = cell_radius * (max_layer * 2 + 1));
        }

        difference() {
          r = bottom_cut_radius + bottom_thickness;

          sphere(r);
          translate([0, 0, -r]) cylinder(h = r, r = r);
        }
      }

      sphere(top_cut_radius);
    }

    sphere(bottom_cut_radius);
  }
}

if (edge_rounding > 0)
  minkowski() {
    organizer();
    sphere(edge_rounding);
  }
else
  organizer();

if ($preview)
  translate([cell_radius * concentric_layers * 4, 0]) {
    walls(show_labels = true);
    tiles(show_labels = true);

    if (show_vertex_labels)
      vertex_labels();
  }
