//Author: Duy Nguyen
//Version: 1.0
//Date: 11/14/2025

//Total size of the loom (diameter) (mm)
Size=190;

//Number of Pegs
Number_of_Pegs=31;

module ring() {
    
    translate([0,0,5])
    rotate_extrude(convexity = 10)
    translate([Outer_Radius-8.75, 0, 0]){
            square(10,true);
            translate([5,0,0])
                scale([.75,1,1])
                    circle(5);
            translate([-5,0,0])
                scale([.75,1,1])
                    circle(5);
       
    }
}

module peg() {    
    difference() {
    cylinder(30,4,3);
    translate([3,0,13])
        scale([1,1,7])
        sphere(2);
    }
    
    disc_size=4;
    ds=disc_size*.66;
    translate([0,0,29])
        rotate_extrude(convexity = 10)
        translate([ds/2+.1,0,0]){
            square(ds,true);
            translate([ds/2,0,0])
                circle(ds/2);
        }
}

module cutouts() {
    for(i=[0:1:Number_of_Pegs]){
        rotate([0,0,(360/Number_of_Pegs)*i])
            translate([Outer_Radius+20.3,0,9])
                scale([4,.70,1])
                    cylinder(3,7,7);
    }   
}
   
$fn = 64;

Outer_Radius=Size/2;

//Create Ring
difference(){
    ring();
    cutouts();

    rotate([0,0,180/Number_of_Pegs])
    translate([Outer_Radius-1.5,0,0])
        cylinder(20,1.5,1.5);
}

//Add Pegs
for(i=[0:1:Number_of_Pegs]){
    
    rotate([0,0,(360/Number_of_Pegs)*i])
    translate([Outer_Radius-8.75,0,0]) peg();
}