//
// This template was generated by:
//    OmNomNom Creator  (http://www.thingiverse.com/thing:24639)
//    with the "Medallion" template.
//
// Template License:   Attribution - Non-Commercial - Creative Commons
// Copyright: 12th October, 2012
// Author:    Jetty
//
// This project consists of 3 files:
//    MadeByASailfish.scad   (this file)
//    MadeByASailfish.dat    (datafile - the shape information)
//    MadeByASailfish.tiff   (source image)
//


//The dimensions of the object
surfaceWidth = 60.0;
aspectRatio = 256 / 256;
surfaceLength = surfaceWidth / aspectRatio;
surfaceHeight = 1.0;
baseDiameter = max(surfaceWidth, surfaceLength) * 1.3;
baseHeight = 1.0;
holeDiameter = 4;         //0 removes the hole
holeDistanceFromTop = 5;

//Controls how circular the base is
$fn=40;


// START Your code goes here

3DSurface(surfaceWidth, surfaceLength, surfaceHeight);

// END Your code goes here




// Creates the 3D Surface from the surface datafile
// Call with xSize / ySize / zSize set to the dimensions 
// you want your surface to be in mm's.

module 3DSurface( xSize, ySize, zSize )
{
   // Manifold Correction
   // Used to correct for manifold issues when using difference()
   // This is set to a small amount, if it's too small objects
   // aren't completely removed.
   // http://en.wikibooks.org/wiki/OpenSCAD_User_Manual/STL_Import_and_Export
   mc = 0.02;

   // These are templated to be set 
   // to the number of columns and rows of the datafile
   surfaceMaxX = 256;
   surfaceMaxY = 256;

   //We translate Z so that the surface is located starting from 0
   translate( [0, 0, baseHeight] )
   {
      //Create the base
      translate( [0, 0, -baseHeight / 2] )
         difference()
         {
            cylinder( r = baseDiameter / 2, h = baseHeight, center = true );
            translate( [0, baseDiameter / 2 - holeDistanceFromTop, mc] )
               cylinder( r = holeDiameter / 2, h = baseHeight * 2, center = true );
         }

      // When a surface map is read in, the axis
      // have the following scales:
      //    X: 0 - # Columns
      //    Y: 0 - # Rows
      //    Z: 0 - 1.0
      //
      // We take that into account here to allow scaling
      // to any X/Y/Z size
      // -1 because "surface" is out by 1 pixel
      scale( [xSize / (surfaceMaxX - 1.0), ySize / (surfaceMaxY - 1.0), zSize] )
      {
         // We create the surface, then subtract a cube
         // that is 1.0mm thick to remove the plate
         // surface added that we didn't ask for.
         //
         // We use difference to do the subtracting
         difference()
         {
            // Load the surface data from the datafile
            surface( file="MadeByASailfish.dat", center = true, convexity = 5 );

            // Now we specify the cube to subtract the plate
            // Note, the cube height is 1.0, and it's centered, so we need
            // to move the plate down by half in the Z axis (-0.5)
            translate( [0, 0, -0.5] )
            {
               cube( [surfaceMaxX + mc * 2, surfaceMaxY + mc * 2, 1.0 + mc * 2], center = true );
            }
         }
      }
   }	
}