/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app;

import java.io.FileWriter;
import java.io.IOException;
import replicatorg.app.Base;
import replicatorg.machine.MachineListener;
import replicatorg.machine.MachineProgressEvent;
import replicatorg.machine.MachineStateChangeEvent;
import replicatorg.machine.MachineToolStatusEvent;

public class DataCapture
implements MachineListener {
    FileWriter outFile;

    public DataCapture(String filename) {
        try {
            this.outFile = new FileWriter(filename);
        }
        catch (IOException e) {
            Base.logger.severe("Couldn't open data capture file for writing:" + e.getMessage());
        }
        Base.getMachineLoader().addMachineListener(this);
    }

    public void WriteMessage(String message) {
        try {
            this.outFile.write(message + "\n");
            this.outFile.flush();
        }
        catch (IOException e) {
            Base.logger.severe("Couldn't write to data capture file:" + e.getMessage());
        }
    }

    public void machineStateChanged(MachineStateChangeEvent evt) {
    }

    public void machineProgress(MachineProgressEvent event) {
    }

    private String jsonString(String name, double value) {
        return "\"" + name + "\" : " + Double.toString(value);
    }

    private String jsonString(String name, String value) {
        return "\"" + name + "\" : \"" + value + "\"";
    }

    public void toolStatusChanged(MachineToolStatusEvent event) {
        this.WriteMessage("{" + this.jsonString("time", event.getDateString()) + ", " + this.jsonString("tool_index", event.getTool().getIndex()) + ", " + this.jsonString("bed_temp", event.getTool().getPlatformCurrentTemperature()) + ", " + this.jsonString("ext_temp", event.getTool().getCurrentTemperature()) + "}" + "\n");
    }
}

