/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app;

import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import replicatorg.app.Base;

public class UpdateChecker {
    public static final String DEFAULT_UPDATES_URL = "http://download.replicat.org/updates.xml";
    private static final int TIMEOUT_MS = 10000;

    protected static URL getUpdateURL() {
        try {
            String url = Base.preferences.get("replicatorg.app.updates.url", DEFAULT_UPDATES_URL);
            return new URL(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void checkLatestVersion(Component parent) {
    }

    private static void doCheckVersion(final Component parent) {
        int latestVersion = UpdateChecker.getLatestVersion();
        final String lvString = Integer.toString(latestVersion);
        if (latestVersion > 40) {
            final String key = "replicatorG.ignoreNewVersion." + lvString;
            if (Base.preferences.getBoolean(key, false)) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JCheckBox checkbox = new JCheckBox("Do not show this message for this version again");
                    String message = "A newer version (" + lvString + ") of ReplicatorG is now available.\n" + "Would youlike to visit the download page?";
                    Object[] params = new Object[]{message, checkbox};
                    int result = JOptionPane.showOptionDialog(parent, params, "New Version Available", 0, 3, null, null, null);
                    boolean dontShow = checkbox.isSelected();
                    Base.preferences.putBoolean(key, dontShow);
                    if (result == 0) {
                        Base.openURL("http://replicat.org/download/");
                    }
                }
            });
        }
    }

    private static int getLatestVersion() {
        int latestVersion = 40;
        return latestVersion;
    }
}

