/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.model;

import com.sun.j3d.loaders.Loader;
import com.sun.j3d.loaders.Scene;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.j3d.renderer.java3d.loaders.ColladaLoader;
import org.j3d.renderer.java3d.loaders.ObjLoader;
import org.j3d.renderer.java3d.loaders.STLLoader;
import replicatorg.app.Base;
import replicatorg.app.ui.modeling.EditingModel;
import replicatorg.model.Build;
import replicatorg.model.BuildElement;
import replicatorg.model.j3d.StlAsciiWriter;

public class BuildModel
extends BuildElement {
    private File file;
    private Transform3D transform = new Transform3D();
    private Shape3D shape = null;
    private EditingModel editListener = null;
    Map<String, Loader> loaderExtensionMap = new HashMap<String, Loader>();

    public void setEditListener(EditingModel eModel) {
        this.editListener = eModel;
    }

    BuildModel(Build build, File file) {
        this.loaderExtensionMap.put("stl", (Loader)new STLLoader());
        this.loaderExtensionMap.put("obj", (Loader)new ObjLoader());
        this.loaderExtensionMap.put("dae", (Loader)new ColladaLoader());
        this.file = file;
    }

    public BuildElement.Type getType() {
        return BuildElement.Type.MODEL;
    }

    public String getPath() {
        try {
            return this.file.getCanonicalPath();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public Shape3D getShape() {
        if (this.shape == null) {
            this.loadShape();
        }
        return this.shape;
    }

    private Shape3D loadShape(Loader loader) {
        Scene scene = null;
        try {
            scene = loader.load(this.file.getCanonicalPath());
        }
        catch (Exception e) {
            Base.logger.log(Level.INFO, "Could not load " + this.file.getPath() + " with " + loader.getClass().getSimpleName(), e);
            return null;
        }
        if (scene == null) {
            return null;
        }
        return (Shape3D)scene.getSceneGroup().getChild(0);
    }

    private void loadShape() {
        Loader loadCandidate;
        String suffix = null;
        String name = this.file.getName();
        int idx = name.lastIndexOf(46);
        if (idx > 0) {
            suffix = name.substring(idx + 1);
        }
        Shape3D candidate = null;
        if (suffix != null && (loadCandidate = this.loaderExtensionMap.get(suffix.toLowerCase())) != null) {
            candidate = this.loadShape(loadCandidate);
        }
        if (candidate == null) {
            Loader loadCandidate2;
            Iterator<Loader> i$ = this.loaderExtensionMap.values().iterator();
            while (i$.hasNext() && (candidate = this.loadShape(loadCandidate2 = i$.next())) == null) {
            }
        }
        if (candidate != null) {
            this.shape = candidate;
        }
    }

    public Transform3D getTransform() {
        return this.transform;
    }

    public void setTransform(Transform3D t, String description, boolean newOp) {
        if (this.transform.equals(t)) {
            return;
        }
        this.undo.addEdit(new UndoEntry(this.transform, t, description, newOp));
        this.transform.set(t);
        this.setModified(true);
        if (this.editListener != null) {
            this.editListener.modelTransformChanged();
        }
    }

    public void doEdit(Transform3D edit) {
        this.transform.set(edit);
        this.setModified(this.undo.canUndo());
        this.editListener.modelTransformChanged();
    }

    private String getFileExtension(File file) {
        int dotExtension = file.getName().lastIndexOf(46);
        if (dotExtension == -1) {
            return "";
        }
        return file.getName().substring(dotExtension + 1).toLowerCase();
    }

    private String getFileBase(File file) {
        int dotExtension = file.getName().lastIndexOf(46);
        if (dotExtension == -1) {
            return file.getName();
        }
        return file.getName().substring(0, dotExtension);
    }

    public void save() {
        if (this.getFileExtension(this.file).equals("gcode") || this.getFileExtension(this.file).equals("stl")) {
            this.saveInternal(this.file);
        } else {
            String newFileName = this.file.getParent() + File.separatorChar + this.getFileBase(this.file) + ".stl";
            Base.logger.info("Exporting modified model as .stl file: " + newFileName);
            File newFile = new File(newFileName);
            if (this.saveInternal(newFile)) {
                this.file = newFile;
            }
        }
    }

    public void saveAs(File f) {
        if (this.saveInternal(f)) {
            this.file = f;
        }
    }

    private boolean saveInternal(File f) {
        try {
            FileOutputStream ostream = new FileOutputStream(f);
            Base.logger.info("Writing to " + f.getCanonicalPath() + ".");
            StlAsciiWriter saw = new StlAsciiWriter(ostream);
            saw.writeShape(this.getShape(), this.getTransform());
            ostream.close();
            this.undo = new UndoManager();
            this.setModified(false);
            return true;
        }
        catch (FileNotFoundException fnfe) {
            Base.logger.log(Level.SEVERE, "Error during save", fnfe);
        }
        catch (IOException ioe) {
            Base.logger.log(Level.SEVERE, "Error during save", ioe);
        }
        return false;
    }

    void writeToStream(OutputStream ostream) {
    }

    class UndoEntry
    implements UndoableEdit {
        Transform3D before;
        Transform3D after;
        String description;
        boolean newOp;

        public UndoEntry(Transform3D before, Transform3D after, String description, boolean newOp) {
            this.before = new Transform3D(before);
            this.after = new Transform3D(after);
            this.description = description;
            this.newOp = newOp;
        }

        public boolean addEdit(UndoableEdit edit) {
            if (edit instanceof UndoEntry) {
                UndoEntry ue = (UndoEntry)edit;
                if (!ue.newOp && this.description == ue.description) {
                    this.after = ue.after;
                    return true;
                }
            }
            return false;
        }

        public boolean canRedo() {
            return true;
        }

        public boolean canUndo() {
            return true;
        }

        public void die() {
        }

        public String getPresentationName() {
            return this.description;
        }

        public String getRedoPresentationName() {
            return "Redo " + this.getPresentationName();
        }

        public String getUndoPresentationName() {
            return "Undo " + this.getPresentationName();
        }

        public boolean isSignificant() {
            return true;
        }

        public void redo() throws CannotRedoException {
            BuildModel.this.doEdit(this.after);
        }

        public boolean replaceEdit(UndoableEdit edit) {
            return false;
        }

        public void undo() throws CannotUndoException {
            BuildModel.this.doEdit(this.before);
        }
    }
}

