/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.plugin.toolpath;

import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.model.Build;
import replicatorg.plugin.toolpath.SkeinStep;
import replicatorg.plugin.toolpath.ToolpathGenerator;

class ProgressDialog
extends JDialog
implements ToolpathGenerator.GeneratorListener {
    Thread parentThread;
    JLabel topLabel;
    JLabel progressLabel;
    JProgressBar subProgressBar;
    JLabel totalProgressLabel;
    JProgressBar totalProgressBar;
    JButton doneButton;
    int layerIndex;
    int layerTotal;
    int currentProcessI = -1;
    String currentSlicer;
    SkeinStep[] slicer = new SkeinStep[]{new SkeinStep("Processing triangulated mesh", 12), new SkeinStep("Generating perimeters", 8), new SkeinStep("Detecting solid surfaces", 8), new SkeinStep("Preparing infill surfaces", 8), new SkeinStep("Cleaning up", 8), new SkeinStep("Detect bridges", 8), new SkeinStep("Cleaning up the perimeters", 8), new SkeinStep("Generating horizontal shells", 8), new SkeinStep("DISCOVERING HORIZONTAL SHELLS", 8), new SkeinStep("Combining infill", 8), new SkeinStep("Infilling layers", 8), new SkeinStep("Generating skirt", 8)};
    SkeinStep[] steps = new SkeinStep[]{new SkeinStep("Carve", 13), new SkeinStep("Inset", 27), new SkeinStep("Fill", 12), new SkeinStep("Raft", 36), new SkeinStep("Clip", 8), new SkeinStep("Comb", 4), new SkeinStep("Oozebane", 5)};
    boolean done = false;
    private static Pattern patOfNum = Pattern.compile(" of ([0-9]+)...");
    private static Pattern patLayerCount = Pattern.compile("([A-Za-z]+) layer count ([0-9]+)");
    private static Pattern patOldLayerTotal = Pattern.compile("total Layer count is[^0-9]([0-9]+)[^0-9]");
    private static Pattern patFillingLayer = Pattern.compile("^Filling layer.*[^0-9]([0-9]+)[^0-9]");
    private static Pattern patOldFillingLayer = Pattern.compile("Filling layer[^0-9]([0-9]+)/([0-9]+)[^0-9]");
    private static Pattern patSliceToGcode = Pattern.compile("Slice to GCode.*layer ([0-9]+)[^0-9]");
    private static Pattern patProcedureTook = Pattern.compile("(.*) procedure took");
    private static Pattern patOfReverseBridge = Pattern.compile("Found reverse bridge");
    private static Pattern patOfDetection = Pattern.compile("Detecting solid surfaces...");
    private static Pattern patOfMembrane = Pattern.compile("layer ([0-9]+) contains ([0-9]+) membrane");
    private static Pattern patOfInternalSurface = Pattern.compile("internal surfaces found");
    private static Pattern patOfOverhang = Pattern.compile("overhang on layer ([0-9]+) with ([0-9]+) support");
    private static Pattern patOfBridgeSupport = Pattern.compile("Bridge is supported on ([0-9]+) edge");
    private static Pattern patOfBridgeInfill = Pattern.compile("Optimal infill angle of bridge on layer ([0-9]+) is ([0-9]+) degrees");
    private static Pattern patOfFillBridge = Pattern.compile("Filling bridge with angle ([0-9]+)");
    private static Pattern patOfSmallSurface = Pattern.compile("small surfaces at layer ([0-9]+)");
    private static Pattern patOfHorizontal = Pattern.compile("Facet is horizontal; ([A-Za-z]+)");
    private static Pattern patOfZLevel = Pattern.compile("z: min = ([0-9]+), max = ([0-9]+)");
    private static Pattern patOfFacets = Pattern.compile("==> FACET ([0-9]+)");
    private static Pattern patOfPoly = Pattern.compile("poly([A-Za-z]+)");
    private static Pattern patOfLayers = Pattern.compile("layers: min = ([0-9]+), max = ([0-9]+)");
    private static Pattern patOfPower = Pattern.compile("fan = ([0-9]+)%, speed = ([0-9]+)%");
    private static Pattern patOfSurfaces = Pattern.compile("Making surfaces for layer ([0-9]+)");
    private static Pattern patOfPerimeters = Pattern.compile("Making perimeters for layer ([0-9]+)");
    private static Pattern patOfLines = Pattern.compile("([0-9]+) lines start at point ([0-9]+)");
    private static Pattern patOfWalls = Pattern.compile("([0-9]+) thin walls detected");
    private static Pattern patOfSolids = Pattern.compile("Layer ([0-9]+)");
    private static Pattern patOfRemoveWall = Pattern.compile("removed ([0-9]+) unprintable perimeters at layer ([0-9]+)");
    private static Pattern patOfSolidShells = Pattern.compile("looking for neighbors on layer ([0-9]+)...");
    private static Pattern patOfFillLayer = Pattern.compile("Filling layer ([0-9]+):");
    private static Pattern patProcedureTakes = Pattern.compile("Done. Process took ([0-9]+) minutes and ([0-9]+.[0-9]+) seconds");
    private static Pattern patTotalFilament = Pattern.compile("Filament required: ([0-9]+.[0-9])mm *([0-9].[0-9])cm3");
    private static Pattern patNewProcedure = Pattern.compile("=> (.+)");

    public ProgressDialog(Frame parent, Build build, Thread parentThread, String generator) {
        super(parent);
        this.currentSlicer = generator;
        this.parentThread = parentThread;
        ImageIcon icon = new ImageIcon(Base.getDirectImage("images/slicing-icon.gif", this));
        this.setTitle("Generating toolpath for " + build.getName());
        this.topLabel = new JLabel("Generating toolpath for " + build.getName(), icon, 2);
        icon.setImageObserver(this.topLabel);
        this.progressLabel = new JLabel("Launching plugin...");
        this.subProgressBar = new JProgressBar();
        this.totalProgressLabel = new JLabel("Total progress:");
        this.totalProgressBar = new JProgressBar();
        this.subProgressBar.setValue(0);
        this.subProgressBar.setStringPainted(false);
        this.subProgressBar.setValue(0);
        this.totalProgressBar.setStringPainted(false);
        this.setLayout((LayoutManager)new MigLayout());
        this.add((Component)this.topLabel, "wrap");
        this.add((Component)new JLabel("Generator: " + generator), "wrap");
        this.add((Component)this.progressLabel, "wrap,growx,wmax 400px");
        this.add((Component)this.subProgressBar, "wrap,wmin 400px");
        this.add((Component)this.totalProgressLabel, "wrap,growx");
        this.add((Component)this.totalProgressBar, "wrap,wmin 400px");
        this.doneButton = new JButton("Cancel");
        this.doneButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    ProgressDialog.this.abortGeneration();
                }
            }
        });
        this.add((Component)this.doneButton, "tag cancel");
        this.setResizable(false);
        this.setModal(false);
        this.doneButton.addKeyListener(new KeyAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    2 var2_2 = this;
                    synchronized (var2_2) {
                        ProgressDialog.this.abortGeneration();
                    }
                }
            }
        });
    }

    public boolean isDone() {
        return this.done;
    }

    public void setVisible(boolean b) {
        if (!b) {
            this.parentThread = null;
        }
        super.setVisible(b);
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abortGeneration() {
        if (this.parentThread != null) {
            this.parentThread.interrupt();
        }
        ProgressDialog progressDialog = this;
        synchronized (progressDialog) {
            this.setVisible(false);
            this.setDone(true);
        }
    }

    public void updateGenerator(final ToolpathGenerator.GeneratorEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){
            String processName = "";
            boolean logIt = true;
            boolean showIt = true;
            boolean showProgress = false;
            int sub;
            Matcher m = null;

            String doSlic3rUpdate(String newMessage) {
                this.m = patOfRemoveWall.matcher(newMessage);
                if (this.m.find()) {
                    this.logIt = false;
                    ProgressDialog.this.subProgressBar.setIndeterminate(true);
                    ProgressDialog.this.layerIndex = Integer.parseInt(this.m.group(2));
                    ProgressDialog.this.subProgressBar.setIndeterminate(false);
                    newMessage = "Removing unprintable perimeter at layer " + this.m.group(2);
                }
                this.m = patOfBridgeSupport.matcher(newMessage);
                if (this.m.find()) {
                    this.logIt = false;
                    this.showIt = false;
                }
                this.m = patOfWalls.matcher(newMessage);
                if (this.m.find()) {
                    this.logIt = false;
                    this.showIt = false;
                }
                this.m = patOfPower.matcher(newMessage);
                if (this.m.find()) {
                    this.logIt = false;
                    this.showIt = false;
                }
                this.m = patOfLines.matcher(newMessage);
                if (this.m.find()) {
                    this.logIt = false;
                    this.showIt = false;
                }
                this.m = patOfFillBridge.matcher(newMessage);
                if (this.m.find()) {
                    this.logIt = false;
                    this.showIt = false;
                }
                this.m = patOfBridgeInfill.matcher(newMessage);
                if (this.m.find()) {
                    this.logIt = false;
                    this.showIt = false;
                }
                this.m = patOfOverhang.matcher(newMessage);
                if (this.m.find()) {
                    this.logIt = false;
                    this.showIt = false;
                }
                this.m = patOfSmallSurface.matcher(newMessage);
                if (this.m.find()) {
                    this.logIt = false;
                    this.showIt = false;
                }
                this.m = patOfMembrane.matcher(newMessage);
                if (this.m.find()) {
                    this.logIt = false;
                    this.showIt = false;
                }
                this.m = patOfDetection.matcher(newMessage);
                if (this.m.find()) {
                    this.logIt = false;
                    this.showIt = false;
                }
                this.m = patOfInternalSurface.matcher(newMessage);
                if (this.m.find()) {
                    this.logIt = false;
                    this.showIt = false;
                }
                this.m = patOfHorizontal.matcher(newMessage);
                if (this.m.find()) {
                    this.logIt = false;
                    this.showIt = false;
                }
                this.m = patOfReverseBridge.matcher(newMessage);
                if (this.m.find()) {
                    this.logIt = false;
                    this.showIt = false;
                }
                this.m = patOfZLevel.matcher(newMessage);
                if (this.m.find()) {
                    this.logIt = false;
                    this.showIt = false;
                }
                this.m = patOfPoly.matcher(newMessage);
                if (this.m.find()) {
                    this.logIt = false;
                    this.showIt = false;
                }
                this.m = patOfFacets.matcher(newMessage);
                if (this.m.find()) {
                    this.logIt = false;
                    ProgressDialog.this.subProgressBar.setIndeterminate(true);
                    newMessage = "Processing facet " + this.m.group(1);
                }
                this.m = patOfLayers.matcher(newMessage);
                if (this.m.find()) {
                    this.logIt = false;
                    this.showIt = false;
                    int temp = Integer.parseInt(this.m.group(2));
                    if (temp > ProgressDialog.this.layerTotal) {
                        ProgressDialog.this.layerTotal = temp;
                    }
                }
                this.m = patOfSurfaces.matcher(newMessage);
                if (this.m.find()) {
                    this.logIt = false;
                    ProgressDialog.this.layerIndex = Integer.parseInt(this.m.group(1));
                    ProgressDialog.this.subProgressBar.setIndeterminate(false);
                    this.showProgress = true;
                    this.processName = "Making surfaces";
                    newMessage = this.processName + " (layer " + ProgressDialog.this.layerIndex + " of " + ProgressDialog.this.layerTotal + ")";
                }
                this.m = patOfPerimeters.matcher(newMessage);
                if (this.m.find()) {
                    this.logIt = false;
                    ProgressDialog.this.layerIndex = Integer.parseInt(this.m.group(1));
                    ProgressDialog.this.subProgressBar.setIndeterminate(false);
                    this.showProgress = true;
                    this.processName = "Making perimeters";
                    newMessage = this.processName + " (layer " + ProgressDialog.this.layerIndex + " of " + ProgressDialog.this.layerTotal + ")";
                }
                this.m = patOfSolids.matcher(newMessage);
                if (this.m.find()) {
                    this.logIt = false;
                    ProgressDialog.this.layerIndex = Integer.parseInt(this.m.group(1));
                    ProgressDialog.this.subProgressBar.setIndeterminate(false);
                    this.showProgress = true;
                    this.processName = "Detecting solid surfaces...";
                    newMessage = this.processName + " (layer " + ProgressDialog.this.layerIndex + " of " + ProgressDialog.this.layerTotal + ")";
                }
                this.m = patOfSolidShells.matcher(newMessage);
                if (this.m.find()) {
                    this.logIt = false;
                    ProgressDialog.this.layerIndex = Integer.parseInt(this.m.group(1));
                    ProgressDialog.this.subProgressBar.setIndeterminate(false);
                    this.showProgress = true;
                    this.processName = "looking for neighbors";
                    newMessage = this.processName + " (layer " + ProgressDialog.this.layerIndex + " of " + ProgressDialog.this.layerTotal + ")";
                }
                this.m = patOfFillLayer.matcher(newMessage);
                if (this.m.find()) {
                    this.logIt = false;
                    ProgressDialog.this.layerIndex = Integer.parseInt(this.m.group(1));
                    ProgressDialog.this.subProgressBar.setIndeterminate(false);
                    this.showProgress = true;
                    this.processName = "Filling";
                    newMessage = this.processName + " (layer " + ProgressDialog.this.layerIndex + " of " + ProgressDialog.this.layerTotal + ")";
                }
                return newMessage;
            }

            String doSkeinforge33Update(String newMessage) {
                if (newMessage.startsWith("\u001b")) {
                    newMessage = newMessage.substring(4);
                }
                this.m = patOfNum.matcher(newMessage);
                if (this.m.find()) {
                    this.logIt = false;
                    ProgressDialog.this.layerTotal = Integer.parseInt(this.m.group(1));
                }
                this.m = patLayerCount.matcher(newMessage);
                if (this.m.find()) {
                    this.processName = this.m.group(1);
                    ProgressDialog.this.layerIndex = Integer.parseInt(this.m.group(2));
                    this.logIt = false;
                    if (ProgressDialog.this.layerTotal > 0) {
                        ProgressDialog.this.subProgressBar.setIndeterminate(false);
                        this.showProgress = true;
                        newMessage = this.processName + " (layer " + ProgressDialog.this.layerIndex + " of " + ProgressDialog.this.layerTotal + ")";
                    } else {
                        newMessage = this.processName + " (layer " + ProgressDialog.this.layerIndex + ")";
                        ProgressDialog.this.subProgressBar.setIndeterminate(true);
                    }
                }
                this.m = patOldLayerTotal.matcher(newMessage);
                if (this.m.find()) {
                    ProgressDialog.this.layerTotal = Integer.parseInt(this.m.group(1));
                }
                this.m = patFillingLayer.matcher(newMessage);
                if (this.m.find()) {
                    ProgressDialog.this.layerIndex = Integer.parseInt(this.m.group(1));
                    this.showProgress = true;
                    this.logIt = false;
                    this.sub = (int)(55.0 * (double)ProgressDialog.this.layerIndex / (double)ProgressDialog.this.layerTotal);
                    ProgressDialog.this.totalProgressBar.setValue(10 + this.sub);
                }
                this.m = patOldFillingLayer.matcher(newMessage);
                if (this.m.find()) {
                    ProgressDialog.this.layerIndex = Integer.parseInt(this.m.group(1));
                    ProgressDialog.this.layerTotal = Integer.parseInt(this.m.group(2));
                    this.showProgress = true;
                    this.logIt = false;
                    this.sub = (int)(55.0 * (double)ProgressDialog.this.layerIndex / (double)ProgressDialog.this.layerTotal);
                    ProgressDialog.this.totalProgressBar.setValue(10 + this.sub);
                }
                this.m = patSliceToGcode.matcher(newMessage);
                if (this.m.find()) {
                    ProgressDialog.this.layerIndex = Integer.parseInt(this.m.group(1));
                    this.showProgress = true;
                    this.logIt = false;
                    this.sub = (int)(2.0 * (double)ProgressDialog.this.layerIndex / (double)ProgressDialog.this.layerTotal);
                    ProgressDialog.this.totalProgressBar.setValue(2 + this.sub);
                }
                return newMessage;
            }

            String doMiracleGrueUpdate(String newMessage) {
                int split = newMessage.indexOf("[");
                String base = split >= 0 ? newMessage.substring(0, split) : newMessage;
                newMessage = base.trim();
                this.logIt = true;
                this.showIt = true;
                return newMessage;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String newMessage = evt.getMessage();
                ProgressDialog progressDialog = ProgressDialog.this;
                synchronized (progressDialog) {
                    newMessage = ProgressDialog.this.currentSlicer.startsWith("Slic3r") ? this.doSlic3rUpdate(newMessage) : (ProgressDialog.this.currentSlicer.startsWith("Miracle") ? this.doMiracleGrueUpdate(newMessage) : this.doSkeinforge33Update(newMessage));
                    if (this.showProgress) {
                        String j = new Integer(ProgressDialog.this.layerTotal).toString();
                        double completion = (double)ProgressDialog.this.layerIndex / (double)ProgressDialog.this.layerTotal;
                        if (ProgressDialog.this.layerIndex > 0 && this.processName == "") {
                            newMessage = newMessage + " (" + j + " layers)";
                        }
                        ProgressDialog.this.subProgressBar.setValue((int)(100.0 * completion));
                    }
                    this.m = patProcedureTook.matcher(newMessage);
                    if (this.m.find()) {
                        for (int i = 0; i < 5; ++i) {
                            if (!ProgressDialog.this.steps[i].stepName.equals(this.m.group(1))) continue;
                            ProgressDialog.this.currentProcessI = i;
                            ProgressDialog.this.subProgressBar.setIndeterminate(true);
                        }
                    }
                    this.m = patNewProcedure.matcher(newMessage);
                    if (this.m.find() && !this.m.group(0).contains("FACET")) {
                        for (int i = 0; i < ProgressDialog.this.slicer.length; ++i) {
                            if (!ProgressDialog.this.slicer[i].stepName.equals(this.m.group(1))) continue;
                            newMessage = ProgressDialog.this.slicer[i].stepName;
                            this.logIt = false;
                            ProgressDialog.this.currentProcessI = i;
                            ProgressDialog.this.subProgressBar.setIndeterminate(true);
                        }
                    }
                    if (ProgressDialog.this.currentProcessI >= 0) {
                        if (ProgressDialog.this.currentSlicer.startsWith("Slic3r")) {
                            ProgressDialog.this.totalProgressBar.setValue(2 * ProgressDialog.this.slicer[ProgressDialog.this.currentProcessI].getStepPercentage(ProgressDialog.this.layerIndex, ProgressDialog.this.layerTotal));
                        } else {
                            ProgressDialog.this.totalProgressBar.setValue(ProgressDialog.this.steps[ProgressDialog.this.currentProcessI].getStepPercentage(ProgressDialog.this.layerIndex, ProgressDialog.this.layerTotal));
                        }
                    } else if (ProgressDialog.this.layerTotal > 0) {
                        ProgressDialog.this.subProgressBar.setValue((int)((double)ProgressDialog.this.layerIndex / (double)ProgressDialog.this.layerTotal * 100.0));
                        ProgressDialog.this.subProgressBar.setIndeterminate(false);
                    }
                    if (this.logIt) {
                        Base.logger.info(newMessage);
                    }
                    if (this.showIt) {
                        ProgressDialog.this.progressLabel.setText(newMessage);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generationComplete(ToolpathGenerator.GeneratorEvent evt) {
        ProgressDialog progressDialog = this;
        synchronized (progressDialog) {
            this.setVisible(false);
            this.setDone(true);
        }
    }
}

