/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.plugin.toolpath.skeinforge;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.app.ui.SavingTextField;
import replicatorg.plugin.toolpath.skeinforge.SkeinforgeGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintOMatic
implements SkeinforgeGenerator.SkeinforgePreference {
    private JPanel component;
    private JCheckBox enabled;
    private String baseName = "replicatorg.skeinforge.printOMatic.";
    JTabbedPane printOMatic;
    private Defaults defaults = new Mk8Defaults();

    private void addTextParameter(JComponent target, String name, String description, String defaultValue, String toolTip) {
        String fullName = this.baseName + name;
        String value = null;
        if (fullName != null) {
            value = Base.preferences.get(fullName, defaultValue);
            Base.preferences.put(fullName, value);
        }
        target.add(new JLabel(description));
        SavingTextField input = new SavingTextField(fullName, value, 10);
        target.add((Component)input, "wrap");
        if (toolTip != null) {
            input.setToolTipText(toolTip);
        }
    }

    private void addDropDownParameter(JComponent target, String name, String description, Vector<String> options, String toolTip) {
        String fullName = this.baseName + name;
        String value = null;
        if (fullName != null) {
            value = Base.preferences.get(fullName, options.firstElement());
            Base.preferences.put(fullName, value);
        }
        target.add(new JLabel(description));
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(options);
        model.setSelectedItem(value);
        JComboBox<String> input = new JComboBox<String>(model);
        target.add(input, "wrap");
        input.addActionListener(new ComboListener(model, fullName));
        if (toolTip != null) {
            input.setToolTipText(toolTip);
        }
    }

    public double getValue(String optionName) {
        String value = Base.preferences.get(this.baseName + optionName, null);
        Base.logger.fine("Saved value for preference " + this.baseName + optionName + " is " + value);
        Double number = null;
        try {
            number = Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            Base.logger.severe("Print-O-Matic setting " + optionName + "does not contain a valid number, please correct this!");
        }
        return number;
    }

    private void setValue(String optionName, String value) {
        Base.preferences.put(this.baseName + optionName, value);
    }

    private double getScalingFactor() {
        String value = Base.preferences.get(this.baseName + "materialType", null);
        double scalingFactor = 1.0;
        if (value.equals("ABS")) {
            scalingFactor = 0.85;
        } else if (value.equals("PLA")) {
            scalingFactor = 1.0;
        } else {
            Base.logger.severe("Couldn't determine scaling factor for material " + value + ", defaulting to 1");
        }
        return scalingFactor;
    }

    private JComponent printPanel() {
        JPanel printPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        this.addTextParameter(printPanel, "infillPercent", "Object infill (%)", this.defaults.infillPercent, "0= hollow object, 100=solid object");
        this.addTextParameter(printPanel, "desiredLayerHeight", "Layer Height (mm)", this.defaults.desiredLayerHeight, "Sets thickness for plastic layers");
        this.addTextParameter(printPanel, "numberOfShells", "Number of shells:", this.defaults.numberOfShells, "Number of shells to add to the perimeter of an object. Set this to 0 if you are printing a model with thin features");
        this.addTextParameter(printPanel, "desiredFeedrate", "Feedrate (mm/s)", this.defaults.desiredFeedrate, "slow: 0-20, default: 30, Fast: 40+, Accelerated: 80+");
        this.addTextParameter(printPanel, "travelFeedrate", "Travel Feedrate", this.defaults.desiredFeedrate, "slow: 0-20, default: 30, Fast: 50+, Accelerated:150+");
        return printPanel;
    }

    private JComponent materialPanel() {
        JPanel materialPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        Vector<String> materialTypes = new Vector<String>();
        materialTypes.add("ABS");
        materialTypes.add("PLA");
        this.addDropDownParameter(materialPanel, "materialType", "Material type:", materialTypes, "Select the type of plastic to use during print");
        this.addTextParameter(materialPanel, "filamentDiameter", "Filament Diameter (mm)", this.defaults.filamentDiameter, "measure feedstock");
        return materialPanel;
    }

    private JComponent machinePanel() {
        JPanel machinePanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        this.addTextParameter(machinePanel, "nozzleDiameter", "Nozzle Diameter (mm)", this.defaults.nozzleDiameter, "exit hole diameter");
        this.addTextParameter(machinePanel, "driveGearDiameter", "Drive Gear Diameter (mm)", this.defaults.driveGearDiameter, "measure at teeth");
        return machinePanel;
    }

    private JComponent defaultsPanel() {
        JPanel defaultsPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        final JButton mk8 = new JButton("Load Mk8 Defaults");
        final JButton mk7 = new JButton("Load Mk7 Defaults");
        final JButton mk6 = new JButton("Load Mk6 Defaults (0.5 nozzle)");
        final JButton mk6ns = new JButton("Load Mk6 Defaults (0.4 nozzle)");
        final JButton accelerated = new JButton("Load Accelerated Defaults");
        ActionListener loadDefaults = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Defaults def = null;
                if (evt.getSource() == mk8) {
                    def = new Mk8Defaults();
                } else if (evt.getSource() == mk7 || evt.getSource() == accelerated) {
                    def = new Mk7Defaults();
                } else if (evt.getSource() == mk6) {
                    def = new Mk6Defaults();
                } else if (evt.getSource() == mk6ns) {
                    def = new Mk6NewStyleDefaults();
                }
                PrintOMatic.this.setValue("infillPercent", def.infillPercent);
                PrintOMatic.this.setValue("desiredLayerHeight", def.desiredLayerHeight);
                PrintOMatic.this.setValue("numberOfShells", def.numberOfShells);
                PrintOMatic.this.setValue("filamentDiameter", def.filamentDiameter);
                PrintOMatic.this.setValue("nozzleDiameter", def.nozzleDiameter);
                PrintOMatic.this.setValue("driveGearDiameter", def.driveGearDiameter);
                if (evt.getSource() == accelerated) {
                    PrintOMatic.this.setValue("travelFeedrate", "150");
                    PrintOMatic.this.setValue("desiredFeedrate", "80");
                } else {
                    PrintOMatic.this.setValue("travelFeedrate", def.travelFeedrate);
                    PrintOMatic.this.setValue("desiredFeedrate", def.desiredFeedrate);
                }
                PrintOMatic.this.printOMatic.removeAll();
                PrintOMatic.this.makeTabs();
            }
        };
        mk8.addActionListener(loadDefaults);
        mk7.addActionListener(loadDefaults);
        mk6.addActionListener(loadDefaults);
        mk6ns.addActionListener(loadDefaults);
        accelerated.addActionListener(loadDefaults);
        defaultsPanel.add((Component)mk8, "growx, wrap");
        defaultsPanel.add((Component)mk7, "growx, wrap");
        defaultsPanel.add((Component)mk6, "growx, Wrap");
        defaultsPanel.add((Component)mk6ns, "growx, Wrap");
        defaultsPanel.add((Component)accelerated, "growx, Wrap");
        return defaultsPanel;
    }

    private void makeTabs() {
        this.printOMatic.addTab("Settings", this.printPanel());
        this.printOMatic.addTab("Plastic", this.materialPanel());
        this.printOMatic.addTab("Extruder", this.machinePanel());
        this.printOMatic.addTab("Defaults", this.defaultsPanel());
    }

    public PrintOMatic() {
        this.component = new JPanel((LayoutManager)new MigLayout("ins 0, fillx, hidemode 1"));
        final String enabledName = this.baseName + "enabled";
        this.enabled = new JCheckBox("Use Print-O-Matic (stepper extruders only)", Base.preferences.getBoolean(enabledName, true));
        this.enabled.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (enabledName != null) {
                    Base.preferences.putBoolean(enabledName, PrintOMatic.this.enabled.isSelected());
                    PrintOMatic.this.printOMatic.setVisible(PrintOMatic.this.enabled.isSelected());
                    PrintOMatic.this.printOMatic.invalidate();
                    Window w = SwingUtilities.getWindowAncestor(PrintOMatic.this.printOMatic);
                    w.pack();
                }
            }
        });
        this.component.add((Component)this.enabled, "wrap, spanx");
        this.printOMatic = new JTabbedPane();
        this.makeTabs();
        this.component.add((Component)this.printOMatic, "spanx,hidemode 1");
        this.printOMatic.setVisible(this.enabled.isSelected());
    }

    @Override
    public JComponent getUI() {
        return this.component;
    }

    @Override
    public String valueSanityCheck() {
        if (this.enabled.isSelected()) {
            if (this.calculateWidthOverThickness() > 1.8) {
                return "Layer height is smaller than recommended for the specified nozzle. Try increasing the layer height, or changing to a smaller nozzle.";
            }
            if (this.calculateWidthOverThickness() < 1.2) {
                return "Layer height is larger than recommended for the specified nozzle. Try decreasing the layer height, or changing to a larger nozzle.";
            }
        }
        return null;
    }

    public double calculateWidthOverThickness() {
        return Math.pow(this.getValue("nozzleDiameter") / 2.0, 2.0) * Math.PI / this.getValue("desiredLayerHeight") / this.getValue("desiredLayerHeight");
    }

    @Override
    public List<SkeinforgeGenerator.SkeinforgeOption> getOptions(String displayName) {
        LinkedList<SkeinforgeGenerator.SkeinforgeOption> options = new LinkedList<SkeinforgeGenerator.SkeinforgeOption>();
        if (this.enabled.isSelected()) {
            double infillRatio = this.getValue("infillPercent") / 100.0;
            double flowRate = Math.pow(this.getValue("nozzleDiameter") / 2.0, 2.0) * Math.PI * this.getValue("desiredFeedrate") * 60.0 / (Math.pow(this.getValue("filamentDiameter") / 2.0, 2.0) * Math.PI * (this.getScalingFactor() * this.getValue("driveGearDiameter") * Math.PI));
            double perimeterWidthOverThickness = this.calculateWidthOverThickness();
            double infillWidthOverThickness = this.calculateWidthOverThickness();
            double feedRate = this.getValue("desiredFeedrate");
            double layerHeight = this.getValue("desiredLayerHeight");
            double extraShellsOnAlternatingSolidLayer = this.getValue("numberOfShells");
            double extraShellsOnBase = this.getValue("numberOfShells");
            double extraShellsOnSparseLayer = this.getValue("numberOfShells");
            Base.logger.fine("Print-O-Matic settings:\n infillRatio=" + infillRatio + "\n flowRate=" + flowRate + "\n perimeterWidthOverThickness=" + perimeterWidthOverThickness + "\n infillWidthOverThickness=" + infillWidthOverThickness + "\n feedRate=" + feedRate + "\n layerHeight=" + layerHeight + "\n extraShellsOnAlternatingSolidLayer=" + extraShellsOnAlternatingSolidLayer + "\n extraShellsOnBase=" + extraShellsOnBase + "\n extraShellsOnSparseLayer=" + extraShellsOnSparseLayer);
            options.add(new SkeinforgeGenerator.SkeinforgeOption("fill.csv", "Infill Solidity (ratio):", Double.toString(infillRatio)));
            options.add(new SkeinforgeGenerator.SkeinforgeOption("speed.csv", "Flow Rate Setting (float):", Double.toString(flowRate)));
            options.add(new SkeinforgeGenerator.SkeinforgeOption("carve.csv", "Perimeter Width over Thickness (ratio):", Double.toString(perimeterWidthOverThickness)));
            options.add(new SkeinforgeGenerator.SkeinforgeOption("fill.csv", "Infill Width over Thickness (ratio):", Double.toString(infillWidthOverThickness)));
            options.add(new SkeinforgeGenerator.SkeinforgeOption("speed.csv", "Feed Rate (mm/s):", Double.toString(feedRate)));
            options.add(new SkeinforgeGenerator.SkeinforgeOption("carve.csv", "Layer Thickness (mm):", Double.toString(layerHeight)));
            options.add(new SkeinforgeGenerator.SkeinforgeOption("fill.csv", "Extra Shells on Alternating Solid Layer (layers):", Double.toString(extraShellsOnAlternatingSolidLayer)));
            options.add(new SkeinforgeGenerator.SkeinforgeOption("fill.csv", "Extra Shells on Base (layers):", Double.toString(extraShellsOnBase)));
            options.add(new SkeinforgeGenerator.SkeinforgeOption("fill.csv", "Extra Shells on Sparse Layer (layers):", Double.toString(extraShellsOnSparseLayer)));
        }
        return options;
    }

    @Override
    public String getName() {
        return "Print-O-Matic";
    }

    private class Mk6NewStyleDefaults
    extends Mk6Defaults {
        private Mk6NewStyleDefaults() {
            this.nozzleDiameter = ".4";
        }
    }

    private class Mk6Defaults
    extends Defaults {
        private Mk6Defaults() {
            this.infillPercent = "10";
            this.desiredLayerHeight = ".30";
            this.numberOfShells = "1";
            this.desiredFeedrate = "30";
            this.filamentDiameter = "2.94";
            this.nozzleDiameter = ".5";
            this.driveGearDiameter = "10.58";
            this.travelFeedrate = "30";
        }
    }

    private class Mk7Defaults
    extends Defaults {
        private Mk7Defaults() {
            this.infillPercent = "10";
            this.desiredLayerHeight = ".30";
            this.numberOfShells = "1";
            this.desiredFeedrate = "30";
            this.filamentDiameter = "1.82";
            this.nozzleDiameter = ".4";
            this.driveGearDiameter = "10.58";
            this.travelFeedrate = "30";
        }
    }

    private class Mk8Defaults
    extends Defaults {
        private Mk8Defaults() {
            this.infillPercent = "10";
            this.desiredLayerHeight = ".30";
            this.numberOfShells = "1";
            this.desiredFeedrate = "40";
            this.filamentDiameter = "1.82";
            this.nozzleDiameter = ".4";
            this.driveGearDiameter = "10.58";
            this.travelFeedrate = "55";
        }
    }

    private abstract class Defaults {
        public String infillPercent;
        public String desiredLayerHeight;
        public String numberOfShells;
        public String desiredFeedrate;
        public String filamentDiameter;
        public String nozzleDiameter;
        public String driveGearDiameter;
        public String travelFeedrate;

        private Defaults() {
        }
    }

    private class ComboListener
    implements ActionListener {
        final String name;
        final DefaultComboBoxModel input;

        public ComboListener(DefaultComboBoxModel input, String name) {
            this.input = input;
            this.name = name;
        }

        public void actionPerformed(ActionEvent arg0) {
            String value = this.input.getSelectedItem().toString();
            if (this.name != null) {
                Base.logger.fine("here: " + this.name + "=" + value);
                Base.preferences.put(this.name, value);
            }
        }
    }
}

