/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.plugin.toolpath.slic3r;

import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.logging.Level;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.plugin.toolpath.slic3r.ProfileUtils;
import replicatorg.plugin.toolpath.slic3r.Slic3rGenerator;

class EditProfileDialog
extends JDialog {
    final boolean postProcessToolheadIndex = true;
    final String manageStr = "Manage profiles...";
    final String profilePref = "replicatorg.slic3r.profilePref";
    JButton editButton = new JButton("Edit...");
    JButton duplicateButton = new JButton("Duplicate...");
    JButton locateButton = new JButton("Locate...");
    JButton deleteButton = new JButton("Delete");
    JButton doneButton = new JButton("Done");
    JCheckBox filterBox = new JCheckBox("Show profiles for every machine.");
    private Slic3rGenerator parentGenerator = null;
    private List<Slic3rGenerator.Profile> profiles = null;
    JPanel profilePanel = new JPanel();
    final JList prefList = new JList();

    private void loadList(JList list) {
        list.removeAll();
        this.profiles = this.parentGenerator.getProfiles();
        DefaultListModel<String> model = new DefaultListModel<String>();
        int i = 0;
        int foundLastProfile = -1;
        for (Slic3rGenerator.Profile p : this.profiles) {
            if (ProfileUtils.shouldDisplay(p) || this.filterBox.isSelected()) {
                model.addElement(p.toString());
            }
            if (p.toString().equals(Base.preferences.get("lastGeneratorProfileSelected", "---"))) {
                Base.logger.fine("Selecting last used element: " + p);
                foundLastProfile = i;
            }
            ++i;
        }
        list.setModel(model);
        list.clearSelection();
        if (foundLastProfile != -1) {
            list.setSelectedIndex(foundLastProfile);
            this.doneButton.setEnabled(true);
            this.doneButton.requestFocusInWindow();
            this.doneButton.setFocusPainted(true);
        }
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (!b) {
            this.parentGenerator = null;
            this.profiles = null;
        }
    }

    public EditProfileDialog(final Frame parent, Slic3rGenerator parentGeneratorIn) {
        super(parent, true);
        this.parentGenerator = parentGeneratorIn;
        this.setTitle("Edit Profiles");
        this.setLayout((LayoutManager)new MigLayout("aligny, top, ins 5, fill"));
        this.editButton.setToolTipText("Click to edit this profile's properties.");
        this.deleteButton.setToolTipText("Click to remove this profile. Note that this can not be undone.");
        this.locateButton.setToolTipText("Click to find the folder for this profile, e.g. to make backups or to share your settings.");
        this.duplicateButton.setToolTipText("This will make a copy of the currently selected profile, with a new name that you provide.");
        this.doneButton.setEnabled(false);
        this.editButton.setEnabled(false);
        this.locateButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
        this.duplicateButton.setEnabled(false);
        this.profilePanel.setLayout((LayoutManager)new MigLayout("top, ins 0, fill, flowy"));
        this.profilePanel.add((Component)new JLabel("Select a Slic3r profile:"), "split");
        this.prefList.setSelectionMode(0);
        this.prefList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent selectionEvent) {
                boolean selected = !((JList)selectionEvent.getSource()).isSelectionEmpty();
                EditProfileDialog.this.doneButton.setEnabled(selected);
                EditProfileDialog.this.editButton.setEnabled(selected);
                EditProfileDialog.this.locateButton.setEnabled(selected);
                EditProfileDialog.this.deleteButton.setEnabled(selected);
                EditProfileDialog.this.duplicateButton.setEnabled(selected);
            }
        });
        this.prefList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                JList list = (JList)evt.getSource();
                if (evt.getClickCount() == 2) {
                    int idx = list.locationToIndex(evt.getPoint());
                    Slic3rGenerator.Profile p = ProfileUtils.getListedProfile(list.getModel(), EditProfileDialog.this.profiles, idx);
                    Base.preferences.put("lastGeneratorProfileSelected", p.toString());
                    ((EditProfileDialog)EditProfileDialog.this).parentGenerator.configSuccess = true;
                    ((EditProfileDialog)EditProfileDialog.this).parentGenerator.profile = p.getFullPath();
                    EditProfileDialog.this.setVisible(false);
                }
            }
        });
        this.loadList(this.prefList);
        this.profilePanel.add((Component)new JScrollPane(this.prefList), "growx, growy");
        this.prefList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                Base.logger.fine("key pressed event: " + e);
                if (e.getKeyCode() == 10) {
                    int idx = EditProfileDialog.this.prefList.getSelectedIndex();
                    Base.logger.fine("idx=" + idx);
                    Slic3rGenerator.Profile p = ProfileUtils.getListedProfile(EditProfileDialog.this.prefList.getModel(), EditProfileDialog.this.profiles, idx);
                    Base.preferences.put("lastGeneratorProfileSelected", p.toString());
                    ((EditProfileDialog)EditProfileDialog.this).parentGenerator.configSuccess = true;
                    ((EditProfileDialog)EditProfileDialog.this).parentGenerator.profile = p.getFullPath();
                    EditProfileDialog.this.setVisible(false);
                } else if (e.getKeyCode() == 27) {
                    EditProfileDialog.this.setVisible(false);
                }
            }
        });
        this.filterBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                EditProfileDialog.this.loadList(EditProfileDialog.this.prefList);
            }
        });
        this.profilePanel.add((Component)this.filterBox, "growx, wrap");
        this.profilePanel.add((Component)this.editButton, "split, growx");
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int idx = EditProfileDialog.this.prefList.getSelectedIndex();
                if (idx == -1) {
                    JOptionPane.showMessageDialog(parent, "Select a profile to edit.");
                } else {
                    Slic3rGenerator.Profile p = ProfileUtils.getListedProfile(EditProfileDialog.this.prefList.getModel(), EditProfileDialog.this.profiles, idx);
                    EditProfileDialog.this.parentGenerator.editProfile(p);
                }
            }
        });
        this.profilePanel.add((Component)this.duplicateButton, "split, growx");
        this.duplicateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int idx = EditProfileDialog.this.prefList.getSelectedIndex();
                String newName = JOptionPane.showInputDialog(parent, (Object)"Name your new profile:");
                if (newName != null) {
                    Slic3rGenerator.Profile p = ProfileUtils.getListedProfile(EditProfileDialog.this.prefList.getModel(), EditProfileDialog.this.profiles, idx);
                    Slic3rGenerator.Profile newp = EditProfileDialog.this.parentGenerator.duplicateProfile(p, newName);
                    EditProfileDialog.this.loadList(EditProfileDialog.this.prefList);
                    if (newp != null) {
                        EditProfileDialog.this.prefList.setSelectedValue(newp.toString(), true);
                    }
                    EditProfileDialog.this.pack();
                }
            }
        });
        this.profilePanel.add((Component)this.locateButton, "split, growx");
        this.locateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int idx = EditProfileDialog.this.prefList.getSelectedIndex();
                if (idx != -1) {
                    Slic3rGenerator.Profile p = ProfileUtils.getListedProfile(EditProfileDialog.this.prefList.getModel(), EditProfileDialog.this.profiles, idx);
                    boolean result = new ProfileUtils().openFolder(p);
                    Base.logger.log(Level.FINEST, "Opening directory for profile: " + result);
                }
            }
        });
        this.profilePanel.add((Component)this.deleteButton, "growx");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int idx = EditProfileDialog.this.prefList.getSelectedIndex();
                Slic3rGenerator.Profile p = ProfileUtils.getListedProfile(EditProfileDialog.this.prefList.getModel(), EditProfileDialog.this.profiles, idx);
                int userResponse = JOptionPane.showConfirmDialog(null, "Are you sure you want to delete profile " + p.toString() + "? This cannot be undone.", "Delete Profile", 0);
                if (userResponse == 0) {
                    boolean result = new ProfileUtils().delete(p);
                    EditProfileDialog.this.loadList(EditProfileDialog.this.prefList);
                    EditProfileDialog.this.pack();
                    Base.logger.log(Level.INFO, "Profile " + p.getFullPath() + " deleted: " + result);
                }
            }
        });
        this.add((Component)this.profilePanel, "wrap, growx");
        this.add((Component)this.doneButton, "tag ok, split 2");
        this.doneButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ((EditProfileDialog)EditProfileDialog.this).parentGenerator.configSuccess = false;
                EditProfileDialog.this.setVisible(false);
            }
        });
    }
}

