/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.uploader;

import java.io.File;
import org.w3c.dom.Node;
import replicatorg.app.Base;
import replicatorg.drivers.Version;

public class FirmwareVersion {
    private Version version;
    private String name;
    private String where;
    private String eeprom;
    private String description;

    private String getAttrNodeValue(Node n, String attr) {
        Node n2 = n.getAttributes().getNamedItem(attr);
        if (n2 == null) {
            return null;
        }
        return n2.getNodeValue();
    }

    public FirmwareVersion(Node n) {
        int major = Integer.parseInt(this.getAttrNodeValue(n, "major"));
        int minor = Integer.parseInt(this.getAttrNodeValue(n, "minor"));
        this.version = new Version(major, minor);
        this.name = this.getAttrNodeValue(n, "name");
        if (this.name == null) {
            this.name = "v" + this.version.toString();
        }
        this.where = this.getAttrNodeValue(n, "relpath");
        this.eeprom = this.getAttrNodeValue(n, "eeprompath");
        this.description = this.getAttrNodeValue(n, "description");
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getRelPath() {
        return this.where;
    }

    public String getEepromPath() {
        return this.eeprom;
    }

    public void setEepromPath(String path) {
        this.eeprom = path;
    }

    public File getFile() {
        return Base.getUserFile(this.where);
    }

    public String toString() {
        return this.name;
    }
}

