/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.Date;
import org.w3c.dom.Element;
import twitter4j.TwitterException;
import twitter4j.TwitterResponse;
import twitter4j.http.Response;

public class RateLimitStatus
extends TwitterResponse {
    private int remainingHits;
    private int hourlyLimit;
    private int resetTimeInSeconds;
    private Date resetTime;
    private static final long serialVersionUID = 933996804168952707L;

    RateLimitStatus(Response res) throws TwitterException {
        super(res);
        Element elem = res.asDocument().getDocumentElement();
        this.remainingHits = RateLimitStatus.getChildInt("remaining-hits", elem);
        this.hourlyLimit = RateLimitStatus.getChildInt("hourly-limit", elem);
        this.resetTimeInSeconds = RateLimitStatus.getChildInt("reset-time-in-seconds", elem);
        this.resetTime = RateLimitStatus.getChildDate("reset-time", elem, "yyyy-M-d'T'HH:mm:ss+00:00");
    }

    public int getRemainingHits() {
        return this.remainingHits;
    }

    public int getHourlyLimit() {
        return this.hourlyLimit;
    }

    public int getResetTimeInSeconds() {
        return this.resetTimeInSeconds;
    }

    public Date getDateTime() {
        return this.resetTime;
    }

    public Date getResetTime() {
        return this.resetTime;
    }
}

