/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.java3d.loaders;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.LoaderBase;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.SceneBase;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleArray;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.j3d.loaders.stl.STLFileReader;

public class STLLoader
extends LoaderBase {
    private final Component itsParentComponent;
    private boolean itsShowProgress = false;

    public STLLoader() {
        this.itsParentComponent = null;
    }

    public STLLoader(Component parentComponent) {
        this.itsParentComponent = parentComponent;
        this.itsShowProgress = true;
    }

    public Scene load(String fileName) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        try {
            return this.load(new File(fileName).toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new FileNotFoundException();
        }
    }

    public Scene load(URL url) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        STLFileReader reader = null;
        try {
            reader = this.itsShowProgress ? new STLFileReader(url, this.itsParentComponent) : new STLFileReader(url);
            return STLLoader.createScene(reader);
        }
        catch (InterruptedIOException ie) {
            return null;
        }
        catch (IOException e) {
            throw new IncorrectFormatException(e.toString());
        }
    }

    public Scene load(Reader reader) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        return null;
    }

    public static Scene createScene(STLFileReader reader) throws IncorrectFormatException, ParsingErrorException {
        try {
            SceneBase scene = new SceneBase();
            BranchGroup bg = new BranchGroup();
            int numOfObjects = reader.getNumOfObjects();
            int[] numOfFacets = reader.getNumOfFacets();
            String[] names = reader.getObjectNames();
            double[] normal = new double[3];
            float[] fNormal = new float[3];
            double[][] vertices = new double[3][3];
            for (int i = 0; i < numOfObjects; ++i) {
                TriangleArray geometry = new TriangleArray(3 * numOfFacets[i], 3);
                int index = 0;
                for (int j = 0; j < numOfFacets[i]; ++j) {
                    boolean ok = reader.getNextFacet(normal, vertices);
                    if (ok) {
                        fNormal[0] = (float)normal[0];
                        fNormal[1] = (float)normal[1];
                        fNormal[2] = (float)normal[2];
                        if (fNormal[0] == 0.0f && fNormal[1] == 0.0f && fNormal[2] == 0.0f) {
                            Vector3d v0 = new Vector3d(vertices[0]);
                            v0.negate();
                            Vector3d v1 = new Vector3d(vertices[1]);
                            v1.add((Tuple3d)v0);
                            Vector3d v2 = new Vector3d(vertices[2]);
                            v2.add((Tuple3d)v0);
                            Vector3d n = new Vector3d();
                            n.cross(v1, v2);
                            n.normalize();
                            fNormal[0] = (float)n.x;
                            fNormal[1] = (float)n.y;
                            fNormal[2] = (float)n.z;
                        }
                        for (int k = 0; k < 3; ++k) {
                            geometry.setNormal(index, fNormal);
                            geometry.setCoordinate(index, vertices[k]);
                            ++index;
                        }
                        continue;
                    }
                    throw new ParsingErrorException();
                }
                Shape3D shape = new Shape3D((Geometry)geometry);
                bg.addChild((Node)shape);
                String name = names[i];
                if (name == null) {
                    name = new String("Unknown_" + i);
                }
                scene.addNamedObject(name, (Object)shape);
            }
            scene.setSceneGroup(bg);
            SceneBase sceneBase = scene;
            return sceneBase;
        }
        catch (InterruptedIOException ie) {
            Scene scene = null;
            return scene;
        }
        catch (IOException e) {
            throw new ParsingErrorException(e.toString());
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

