/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;

public class CollapsableContainer
extends JComponent {
    private boolean isCollapsed = false;
    private static Icon collapsedIcon = null;
    private static Icon expandedIcon = null;
    private Header header;
    private JPanel content;

    private static synchronized void initIcons(JComponent comp) {
        if (collapsedIcon != null && expandedIcon != null) {
            return;
        }
        collapsedIcon = new ImageIcon(Base.getImage("images/icon-collapsed.png", comp));
        expandedIcon = new ImageIcon(Base.getImage("images/icon-expanded.png", comp));
    }

    public void toggleCollapsed() {
        this.setCollapsed(!this.isCollapsed);
    }

    public void setCollapsed(boolean collapsed) {
        if (this.isCollapsed == collapsed) {
            return;
        }
        this.header.setIcon(collapsed);
        this.isCollapsed = collapsed;
        if (this.isCollapsed) {
            this.remove(this.content);
        } else {
            this.add(this.content);
        }
        this.invalidate();
        Window w = SwingUtilities.windowForComponent(this);
        if (w != null) {
            w.pack();
        }
    }

    public CollapsableContainer(String title, boolean collapsed) {
        this.setLayout((LayoutManager)new MigLayout());
        this.header = new Header(title, collapsed);
        this.isCollapsed = collapsed;
        this.content = new JPanel((LayoutManager)new MigLayout());
        this.add((Component)this.header, "wrap");
        if (!this.isCollapsed) {
            this.add(this.content);
        }
    }

    public JPanel getContent() {
        return this.content;
    }

    protected class Header
    extends JButton
    implements ActionListener {
        public Header(String title, boolean collapsed) {
            this.setText(title);
            CollapsableContainer.initIcons(this);
            this.setIcon(collapsed);
            this.setBorderPainted(false);
            this.addActionListener(this);
        }

        public void setIcon(boolean collapsed) {
            this.setIcon(collapsed ? collapsedIcon : expandedIcon);
        }

        public void actionPerformed(ActionEvent e) {
            CollapsableContainer.this.toggleCollapsed();
        }
    }
}

