/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui;

import java.awt.LayoutManager;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.miginfocom.swing.MigLayout;
import org.w3c.dom.Node;
import replicatorg.app.Base;
import replicatorg.drivers.Driver;
import replicatorg.drivers.OnboardParameters;
import replicatorg.machine.MachineFactory;

public class InfoPanel
extends JFrame {
    JTextArea infoArea;

    public InfoPanel() {
        super("About this Machine");
        this.setLayout((LayoutManager)new MigLayout("fill"));
        this.infoArea = new JTextArea("ReplicatorG:", 40, 80);
        this.infoArea.setFont(new JLabel().getFont());
        this.infoArea.setEditable(false);
        this.infoArea.setOpaque(false);
        this.infoArea.setBorder(BorderFactory.createEmptyBorder());
        this.infoArea.setBackground(this.getBackground());
        this.add(this.infoArea);
        this.pack();
        this.infoArea.setText(this.getMachineInfo());
    }

    public static String convertNodeToHtml(Node node) {
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter sw = new StringWriter();
            t.transform(new DOMSource(node), new StreamResult(sw));
            return sw.toString();
        }
        catch (TransformerConfigurationException e) {
        }
        catch (TransformerFactoryConfigurationError e) {
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return null;
    }

    public String getMachineInfo() {
        Driver driver = Base.getMachineLoader().getDriver();
        String info = new String();
        info = info + "System Information\n";
        info = info + " ReplicatorG version: " + Base.VERSION_NAME + "\n";
        info = info + " Java version: " + System.getProperty("java.version") + "\n";
        info = info + "\n";
        info = info + "Machine\n";
        info = info + " Profile Name: " + Base.preferences.get("machine.name", "") + "\n";
        info = info + " Driver Type: " + Base.getMachineLoader().getDriver().getDriverName() + "\n";
        info = info + " Name: " + Base.getMachineLoader().getMachineInterface().getMachineName() + "\n";
        info = info + " Motherboard firmware version: " + driver.getFirmwareInfo() + "\n";
        if (driver instanceof OnboardParameters) {
            OnboardParameters.CommunicationStatistics stats = ((OnboardParameters)((Object)driver)).getCommunicationStatistics();
            info = info + " Motherboard communication statistics\n";
            info = info + "  Number of packets received from the USB interface:" + stats.packetCount + "\n";
            info = info + "  Number of packets sent over the RS485 interface:" + stats.sentPacketCount + "\n";
            info = info + "  Number of packets sent over the RS485 interface that were not responded to:" + stats.packetFailureCount + "\n";
            info = info + "  Number of packet retries attempted:" + stats.packetRetryCount + "\n";
            info = info + "  Number of bytes received over the RS485 interface that were discarded as noise:" + stats.noiseByteCount + "\n";
        }
        info = info + "\n";
        info = info + "Machine Driver XML:\n";
        Node machineNode = MachineFactory.getMachineNode(Base.preferences.get("machine.name", ""));
        if (machineNode != null) {
            info = info + InfoPanel.convertNodeToHtml(machineNode) + "\n";
        }
        return info;
    }
}

