/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui.onboard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.app.ui.MainWindow;
import replicatorg.app.ui.onboard.ExtruderOnboardParameters;
import replicatorg.app.ui.onboard.MachineOnboardParameters;
import replicatorg.drivers.Driver;
import replicatorg.drivers.OnboardParameters;
import replicatorg.machine.model.ToolModel;

public class OnboardParametersWindow
extends JFrame {
    private final JTabbedPane paramsTabs;
    private final JButton cancelButton;
    private MachineOnboardParameters onboardParamsTab;
    private boolean disconnectOnExit = false;
    private MainWindow mainwin;

    public OnboardParametersWindow(OnboardParameters targetParams, Driver driver, MainWindow mainwin) {
        super("Update Machine Options");
        this.mainwin = mainwin;
        BufferedImage icon = Base.getImage("images/icon.gif", this);
        this.setIconImage(icon);
        this.setLayout((LayoutManager)new MigLayout());
        this.paramsTabs = new JTabbedPane();
        this.add((Component)this.paramsTabs, "span 2, wrap");
        this.onboardParamsTab = new MachineOnboardParameters(targetParams, driver, this);
        this.paramsTabs.addTab("Motherboard", this.onboardParamsTab);
        String machineType = targetParams.getMachineType();
        Vector<ToolModel> tools = driver.getMachine().getTools();
        for (ToolModel t : tools) {
            this.paramsTabs.addTab("Extruder " + t.getIndex(), new ExtruderOnboardParameters(targetParams, t, this));
        }
        JLabel verifyString = new JLabel("Warning: Machine Type is not verifiable.");
        verifyString.setToolTipText("this machine has no way to verify the EEPORM is a valid layout");
        if (targetParams.canVerifyMachine()) {
            verifyString = new JLabel("Error: Machine Type " + targetParams.getMachineType() + " is of unverifed type.");
            verifyString.setToolTipText("this machine can verify, but failed verification. ");
            if (targetParams.verifyMachineId()) {
                verifyString = new JLabel("Awesome: You have a verified " + targetParams.getMachineType());
                verifyString.setToolTipText("Everything is great! We know this machine is the right one. ");
            }
        }
        this.add(verifyString);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                OnboardParametersWindow.this.dispose();
            }
        });
        this.add((Component)this.cancelButton, "align right");
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screen.width - this.getWidth()) / 2, (screen.height - this.getHeight()) / 2);
    }

    public void dispose() {
        this.disconnectOnExit = this.onboardParamsTab.disconnectOnExit();
        boolean leavePreheatRunning = this.onboardParamsTab.leavePreheatRunning();
        if (this.mainwin != null && this.disconnectOnExit) {
            this.mainwin.handleDisconnect(leavePreheatRunning, true);
        }
        super.dispose();
    }
}

