/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.app.util.PythonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingPythonSelector
implements PythonUtils.Selector {
    private Frame frame;
    private String selectedCandidate = null;

    public SwingPythonSelector(Frame frame) {
        this.frame = frame;
    }

    @Override
    public String selectPythonPath(Vector<String> candidates) {
        if (candidates != null && candidates.size() >= 2) {
            return this.selectCandidatePath(candidates);
        }
        if (candidates != null && Base.isLinux()) {
            return null;
        }
        String s = "<html><p>ReplicatorG couldn't find a Python interpreter on your computer.</p><p>Would you like to visit the Python download page, or manually select your Python installation?</p></html>";
        Object[] options = new Object[]{"Go to Python website", "Select Python", "Cancel"};
        int r = JOptionPane.showOptionDialog(this.frame, s, "Python not found", 1, 3, null, options, options[0]);
        if (r == 0) {
            Base.openURL("http://python.org/download");
        }
        if (r == 1) {
            return this.selectFreeformPath();
        }
        return null;
    }

    private String selectCandidatePath(Vector<String> candidates) {
        final JDialog dialog = new JDialog(this.frame, "Select Python binary", true);
        Container content = dialog.getContentPane();
        content.setLayout((LayoutManager)new MigLayout());
        String msg = "<html>Multiple Python binaries have been found on your computer.<br>Select one from the list below, or click 'Other...' to find another version.</html>";
        content.add((Component)new JLabel(msg), "growx,wrap");
        final JList<String> list = new JList<String>(candidates);
        list.setSelectionMode(0);
        content.add(list, "growx,wrap");
        this.selectedCandidate = null;
        JButton ok = new JButton("Ok");
        JButton cancel = new JButton("Cancel");
        JButton other = new JButton("Other...");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                SwingPythonSelector.this.selectedCandidate = (String)list.getSelectedValue();
                dialog.setVisible(false);
            }
        });
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                SwingPythonSelector.this.selectedCandidate = null;
                dialog.setVisible(false);
            }
        });
        other.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                dialog.setVisible(false);
                SwingPythonSelector.this.selectedCandidate = SwingPythonSelector.this.selectFreeformPath();
            }
        });
        dialog.add((Component)other, "wrap,wmin button");
        dialog.add((Component)ok, "tag ok,wmin button");
        dialog.add((Component)cancel, "tag cancel,wmin button");
        dialog.pack();
        dialog.setVisible(true);
        return this.selectedCandidate;
    }

    public String selectFreeformPath() {
        File chosen;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Select installed Python binary");
        chooser.setDialogType(0);
        chooser.setApproveButtonText("Select");
        if (chooser.showOpenDialog(this.frame) == 0 && (chosen = chooser.getSelectedFile()) != null) {
            return chosen.getAbsolutePath();
        }
        return null;
    }
}

